
/* mr N , 02.12.2008 */

function main()
{
	var oDoc = app.activeDocument;

	var nWidth = oDoc.width;
	var nHeight = oDoc.height;
	var dScale = 96.875;

	//    CS3:  nWidth % 32   
	// ,        
	var nNumTexsHor = Math.round(nWidth / 32);
	var nNumTexsVer = Math.round(nHeight / 32);
	if ( nWidth != nNumTexsHor * 32 || nHeight != nNumTexsVer * 32 )
	{
		alert("Width and Height must by multiple of 32");
		return false;
	}
	
	oDoc.resizeImage(nWidth * 2, nHeight * 2, oDoc.resolution,
			ResampleMethod.NEARESTNEIGHBOR);
	
	var nTotal = nNumTexsHor * nNumTexsVer;
	var nReported = 0;
	{for (var i = 0; i < nNumTexsHor; i++)
	{
		{for (var j = 0; j < nNumTexsVer; j++)
		{
			oDoc.selection.select(Array(
						Array(i * 64, j * 64),Array(i * 64 + 64, j * 64),
						Array(i * 64 + 64, j * 64 + 64),Array(i * 64, j * 64 + 64),
						Array(i * 64, j * 64)));
			oDoc.selection.resize(dScale, dScale, AnchorPosition.MIDDLECENTER);
			
			if ( (nReported + 1) < (i+1) * j / nTotal * 100 )
			{
				nReported = (i+1) * j / nTotal * 100;
				var soText = "progress " + nReported.toFixed(3) + "%";
				try
				{
					oDoc.activeLayer.name = soText;
				} catch(e) {};
			}
		}}
	}}
	oDoc.selection.deselect();

	oDoc.resizeImage(nWidth, nHeight, oDoc.resolution,
			ResampleMethod.BICUBIC);
}

var n_startRullerUnits = app.preferences.rulerUnits;
var n_startTypeUnits = app.preferences.typeUnits;
var e_startDisplayDialogs = app.displayDialogs;

app.preferences.rulerUnits = Units.PIXELS;
app.preferences.typeUnits = TypeUnits.PIXELS;
app.displayDialogs = DialogModes.NO;

if (0 != app.documents.length)
	main();
		
app.preferences.rulerUnits = n_startRullerUnits;
app.preferences.typeUnits = n_startTypeUnits;
app.displayDialogs = e_startDisplayDialogs;
