#!BPY

"""
Name: 'Blendy Blendy exporter'
Blender: 249
Group: 'Export'
Tooltip: 'IL2:1946 msh/him exporter'
"""

import Blender
from Blender import Mesh, Material
from Blender.Mathutils import Vector
import bpy

#Global variables
dest_dir = "" # out path

blendymat = None

vertlist = [] # List of len(mesh.material) lists - List of vertices for each material
faceslist = [] # List of len(mesh.material) lists - Reindexed faces
uvlist = [] # List of unique uv coordinates per material

dummyuv = (Vector(0.0,0.0),Vector(0.0,1.0),Vector(1.0,1.0))


def write(filename):
	global dest_dir
	global sce
	
	dest_dir = filename
	# Remove chars until we are just the path.
	while dest_dir and dest_dir[-1] not in '\\/':
		dest_dir = dest_dir[:-1]
	
	out = open(filename, "w")
	sce= bpy.data.scenes.active
	ob = sce.objects.active
	
	# - Write ROOT -
	out.write("[_ROOT_]\nVisibilitySphere 6.50000\nCollisionObject sphere 6.50000 0.0 0.0 0.0\n")
	parentname = "_ROOT_"
	
	writehim(ob,parentname,out)
#	for ob in sce.objects:
#		out.write(ob.type + ": " + ob.name + "\n")
	out.close()
	return;


#	Get Children of obj, filters out hooks, shadows, collision boxes and LODs
def getChildren(obj): 
	children = [] 
	for ob in Blender.Object.Get():
		if ob.getParent() == obj: 
			children.append(ob)
		children = filter( lambda x: not (x.name.startswith('_') or x.name[0]=='x' or x.name[len(x.name)-3]=='-'), children)
	if len(children) != 0: return children 
	else: return None

#	Get Collision boxes for obj
def getCollisionBoxes(obj): 
	boxes = [] 
	for ob in Blender.Object.Get():
		if (ob.getParent() == obj) and ob.name.startswith('x'): 
			boxes.append(ob)
	if len(boxes) != 0: return boxes
	else: return None

#	Get Hooks for obj
def getHooks(obj): 
	hooks = [] 
	for ob in Blender.Object.Get():
		if (ob.getParent() == obj) and ob.name.startswith('_'): 
			hooks.append(ob)
	if len(hooks) != 0: return hooks
	else: return None
	
# Get Shadow for obj
def getShadow(obj):
	for ob in Blender.Object.Get():
		if (ob.getParent() == obj) and ob.name.endswith('-sh'):
			shadow = ob
			break
	else:
		return None
	return shadow;

# Get LODs for obj
def getLODs(obj):
	lods = []
	for ob in Blender.Object.Get():
		if (ob.getParent() == obj) and ob.name[len(ob.name)-3]=='-' and not(ob.name.endswith('-sh')):
			x = ob.name[-1]
			if x.isdigit():
				lods.insert(int(x),ob)
			else:
				lods.append(ob)
	lods.insert(0,obj)
	return lods


# --- Writes HIM

def writehim(obj, parent, file, level=0):
	file.write("[%s]\nMesh %s\nParent %s\n" % (obj.getName(), obj.getName(), parent))
	
	mymat = obj.getMatrix('localspace') #obj.matrix
	# --- Hidden object? ---
	if obj.getDrawType() == 2 :
		file.write ('Hidden\n')
	if obj.getDrawMode()&4 == 4 :
		file.write ('Separable\n')
	file.write ('Attaching %g %g %g %g %g %g %g %g %g %g %g %g\n' % (mymat[0][0], mymat[0][1], mymat[0][2], mymat[1][0], mymat[1][1], mymat[1][2], mymat[2][0], mymat[2][1], mymat[2][2], mymat[3][0], mymat[3][1], mymat[3][2]))
	children = getChildren(obj)
	boxes = getCollisionBoxes(obj)
	if boxes != None:
		for box in boxes:
			bn = box.getName()
			file.write('CollisionObject	')
			if bn.startswith('xx'):
				file.write('.')
			file.write('%s\n' % bn)

	hooks = getHooks(obj)

	writemsh(obj,boxes,hooks)
	if children == None: return 
	else:
		nparent = obj.getName()
		for child in children:
			writehim(child, nparent, file, level+1)
	return;
# --- end writehim

# --- Generate list of reindexed faces and unique vertices and UVs
def generatelists(mesh): 
	id = 0 #Material ID count
	#Declare globals so we can 'write' in them
	global vertlist
	global faceslist
	global uvlist
	
	del vertlist[:] # List of len(mesh.material) lists - List of vertices for each material
	del faceslist[:] # List of len(mesh.material) lists - Reindexed faces
	del uvlist[:] # List of unique uv coordinates per material
	
	vt = 0 #Vertices sub-total
	for ma in mesh.materials:
		if ma.name == 'NULL':
			id+=1
			continue	# Skip NULL material
		# - Count faces and vertices for each material
		fa = filter(lambda x: x.mat == id, mesh.faces)
		tempfaces = [] #Temporal list of faces
		tempvert = [] #Temporal list of vertices
		tempuv = [] #Temporal uv coords
		vc = 0 #Vertices count for each material
		for f in fa:
			temp_fv = [] #Temporal face vertices
			for v in f.v:
				if (v not in tempvert) or (f.uv[f.v.index(v)] not in tempuv):
					tempvert.append(v)
					tempuv.append(f.uv[f.v.index(v)])
					temp_fv.append(vc)
					vc += 1
				else:
					indexes = [ix for ix, vx in enumerate(tempvert) if vx == v]
					for ix in indexes:
						if tempuv[ix] == f.uv[f.v.index(v)]:
							temp_fv.append(ix)
							break
					else: # if no match is found then is this face has bad uv projection, add new vertice and uv to list
						tempvert.append(v)
						tempuv.append(f.uv[f.v.index(v)])
						temp_fv.append(vc)
						vc += 1
			tempfaces.append(temp_fv)
		uvlist.append(tempuv)
		vertlist.append(tempvert)
		faceslist.append(tempfaces)
		id+= 1
		vt+= vc
	return vt;
# --- end generatelists

# --- Check for quads and triangulate, give dummy uvmap if missing

def preparemesh(me):
	
	global blendymat
	
	has_quads = False
	for f in me.faces:
		if len(f) == 4:
			has_quads = True
			break
	
	if has_quads:
		oldmode = Mesh.Mode()
		Mesh.Mode(Mesh.SelectModes['FACE'])
		
		me.sel = True
		tempob = sce.objects.new(me)
		me.quadToTriangle(0) # more=0 shortest length
		oldmode = Mesh.Mode(oldmode)
		sce.objects.unlink(tempob)
		
		Mesh.Mode(oldmode)
	
	if len(me.materials) < 1:
		if blendymat == None:
			blendymat = Material.New('BLENDYMAT')
			blendymat.rgbCol = [1,0,1]
		me.materials += [blendymat]
	
	if not me.faceUV:
		me.faceUV = True
		for f in me.faces:
			for jx in range(3):
				f.uv = dummyuv

	return;

# --- end preparemesh

# --- Writes MSH

def writemsh(obj,boxes,hooks):
	objname = obj.getName() + '.msh'
	filepath = dest_dir + objname.split('\\')[-1].split('/')[-1]

	mshout = open(filepath, "w")
	
	mshout.write('//Generated by Blendy Blendy exporter by The_WOZ\n\n')
	#-COMMON
	mshout.write('[Common]\nNumBones 0\n FramesType Single\n NumFrames 1\n\n')
	#-LOD --temp--
	lodobjs = getLODs(obj)
	mshout.write('[LOD]\n')
	for i in range(len(lodobjs)):
		dx = int(75*((i*1.5)+1))
		mshout.write('%i\n' % dx)
	#-HOOKS
	if hooks != None:
		mshout.write('\n[Hooks]\n')
		for hook in hooks:
			hn = hook.getName()
			mshout.write('%s <BASE>\n' % hn)
	#-HOOKLOC
		mshout.write('\n[HookLoc]\n')
		for hook in hooks:
			hmat = hook.getMatrix('localspace')
			mshout.write ('%g %g %g %g %g %g %g %g %g %g %g %g\n' % (hmat[0][0], hmat[0][1], hmat[0][2], hmat[1][0], hmat[1][1], hmat[1][2], hmat[2][0], hmat[2][1], hmat[2][2], hmat[3][0], hmat[3][1], hmat[3][2]))

	level = ""
	lvl = 0
	for lod in lodobjs:
		if lod.name[len(lod.name)-3]=='-':
			x = lod.name[-1]
			if x.isdigit():
				lvl = int(x)
			else:
				lvl += 1
		if lvl > 0:
			level = "LOD%i_" % lvl

		mesh = lod.getData(mesh=1)

		preparemesh(mesh)
		

	#-MATERIALS
		mshout.write('\n[%sMaterials]\n' % level)
		for ma in mesh.materials:
			if ma.name == 'NULL':
				continue	#Skip NULL material
			mshout.write('%s\n' % (ma.name))
	#-FACEGROUPS
		mshout.write('\n[%sFaceGroups]\n' % level)

		vt = generatelists(mesh)
		
		ft = 0
		
		#count faces
		for mx in faceslist:
			ft += len(mx)
		
		mshout.write('%i %i\n' % (vt, ft)) #len(mesh.faces)))
		id = 0
		vt = 0
		ft = 0 #Faces sub-total
		nu = 0 #NULL compensator
		for ma in mesh.materials:
			if ma.name == 'NULL':
				id+=1
				nu=1 
				continue	#Skip NULL material
			fa = filter(lambda x: x.mat == id, mesh.faces)
			mshout.write('%i %i %i %i %i\n' % (id-nu, vt, len(vertlist[id-nu]), ft,len(fa)))
			vt+= len(vertlist[id-nu])
			ft+= len(fa)
			id+= 1
	#-VERTICES
		mshout.write('\n[%sVertices_Frame0]\n' % level)
		for vl in vertlist:
			for v in vl:
				mshout.write ('%g %g %g %g %g %g\n' % (v.co.x, v.co.y ,v.co.z, v.no.x, v.no.y, v.no.z))
	#-MATERIALMAPPING
		if mesh.faceUV:
			mshout.write('\n[%sMaterialMapping]\n' % level)
			for uvs in uvlist:
				for uv in uvs:
					mshout.write('%g %g\n' % (uv.x,1-uv.y))
					#mshout.write('%g %g\n' % tuple(uv))
	#-FACES
		mshout.write('\n[%sFaces]\n' % level)
		for fl in faceslist:
			for fa in fl: #faces:
				tt = ""
				for v in fa: #.v:
					#print v
					mshout.write('%s%i' % (tt,v)) #vertlist[id].index(v)))
					tt = " "
				mshout.write('\n')
	#-SHADOW
		Shadow = getShadow(lod)
		if Shadow!=None:
	#-SHVERTICES
			mshout.write('\n[%sShVertices_Frame0]\n' % level)
			sm = Shadow.getData(mesh=1)
			preparemesh(sm)
			for v in sm.verts:
				mshout.write ('%g %g %g\n' % (v.co.x, v.co.y ,v.co.z))
			mshout.write('\n[%sShFaces]\n' % level)
			for f in sm.faces:
				tt = ""
				for v in f.verts:
					mshout.write('%s%i' % (tt,v.index))
					tt = " "
				mshout.write('\n')
		#level = "LOD%i_" % lvl
	#---
	#-Collision boxes
	if boxes!=None	:
		mshout.write('\n[CoCommon]\nNBlocks 1\n\n[CoCommon_b0]\nNParts %i\n' % len(boxes))
		for box in boxes:
			mshout.write('\n[CoCommon_b0p%i]\n' % boxes.index(box))
			mshout.write('Type Mesh\nNFrames 1\nName %s\n' % box.name)
			bmesh = box.getData(mesh=1)
			preparemesh(bmesh)
			#-COVER
			mshout.write('\n[CoVer0_b0p%i]\n' % boxes.index(box))
			for v in bmesh.verts:
				mshout.write ('%g %g %g\n' % (v.co.x, v.co.y ,v.co.z))
			#-vertex use count and neighbors
			neighbors = [[] for _ in xrange(len(bmesh.verts))]
			for f in bmesh.faces:
				if len(neighbors[f.verts[0].index]) == 0:
					neighbors[f.verts[0].index].append(f.verts[1].index)
					neighbors[f.verts[0].index].append(f.verts[2].index)
				else:
					if not(f.verts[1].index in neighbors[f.verts[0].index]):
						neighbors[f.verts[0].index].append(f.verts[1].index)
					if not(f.verts[2].index in neighbors[f.verts[0].index]):
						neighbors[f.verts[0].index].append(f.verts[2].index)

				if len(neighbors[f.verts[1].index]) == 0:
					neighbors[f.verts[1].index].append(f.verts[0].index)
					neighbors[f.verts[1].index].append(f.verts[2].index)
				else:
					if not(f.verts[0].index in neighbors[f.verts[1].index]):
						neighbors[f.verts[1].index].append(f.verts[0].index)
					if not(f.verts[2].index in neighbors[f.verts[1].index]):
						neighbors[f.verts[1].index].append(f.verts[2].index)
	
				if len(neighbors[f.verts[2].index]) == 0:
					neighbors[f.verts[2].index].append(f.verts[1].index)
					neighbors[f.verts[2].index].append(f.verts[0].index)
				else:
					if not(f.verts[1].index in neighbors[f.verts[2].index]):
						neighbors[f.verts[2].index].append(f.verts[1].index)
					if not(f.verts[0].index in neighbors[f.verts[2].index]):
						neighbors[f.verts[2].index].append(f.verts[0].index)
			#-CONEICNT
			mshout.write('\n[CoNeiCnt_b0p%i]\n' % boxes.index(box))
			for cnt in neighbors:
				mshout.write('%i\n' % len(cnt))
			#-CONEI
			mshout.write('\n[CoNei_b0p%i]\n' % boxes.index(box))
			for cnt in neighbors:
				for n in cnt:
					mshout.write('%i\n' % n)
			
			#-COFAC	
			mshout.write('\n[CoFac_b0p%i]\n' % boxes.index(box))
			for fa in bmesh.faces:
				tt = ""
				for v in fa:
					mshout.write('%s%i' % (tt,v.index))
					tt = " "
				mshout.write('\n')
				

	#-close
	mshout.write('\n\n; eof\n')
	mshout.close()
	return;
# --- end writemsh

Blender.Window.FileSelector(write, "Export", "hier.him")