/* PlMapActors - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package com.maddox.il2.builder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.maddox.JGP.Point2d;
import com.maddox.JGP.Point3d;
import com.maddox.JGP.Point3f;
import com.maddox.TexImage.TexImage;
import com.maddox.gwindow.GFileFilter;
import com.maddox.gwindow.GFileFilterName;
import com.maddox.gwindow.GNotifyListener;
import com.maddox.gwindow.GWindow;
import com.maddox.gwindow.GWindowFileOpen;
import com.maddox.gwindow.GWindowFileSaveAs;
import com.maddox.gwindow.GWindowMenu;
import com.maddox.gwindow.GWindowMenuItem;
import com.maddox.gwindow.GWindowMenuPopUp;
import com.maddox.gwindow.GWindowMessageBox;
import com.maddox.gwindow.GWindowRoot;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.Actor;
import com.maddox.il2.engine.ActorFilter;
import com.maddox.il2.engine.ActorMesh;
import com.maddox.il2.engine.ActorSpawn;
import com.maddox.il2.engine.ActorSpawnArg;
import com.maddox.il2.engine.Engine;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.engine.IconDraw;
import com.maddox.il2.engine.Landscape;
import com.maddox.il2.engine.Loc;
import com.maddox.il2.engine.Mat;
import com.maddox.il2.engine.Mesh;
import com.maddox.il2.engine.Orient;
import com.maddox.il2.objects.Statics;
import com.maddox.il2.objects.air.Runaway;
import com.maddox.il2.objects.bridges.Bridge;
import com.maddox.il2.objects.buildings.Mountain;
import com.maddox.rts.CmdEnv;
import com.maddox.rts.Finger;
import com.maddox.rts.HomePath;
import com.maddox.rts.HotKeyCmd;
import com.maddox.rts.HotKeyCmdEnv;
import com.maddox.rts.MsgAddListener;
import com.maddox.rts.MsgMouseListener;
import com.maddox.rts.ObjIO;
import com.maddox.rts.Property;
import com.maddox.rts.RTSConf;
import com.maddox.rts.SFSInputStream;
import com.maddox.rts.SFSReader;
import com.maddox.rts.SectFile;
import com.maddox.rts.SoftClass;
import com.maddox.rts.Spawn;
import com.maddox.util.HashMapExt;
import com.maddox.util.HashMapXY16List;

public class PlMapActors extends Plugin implements MsgMouseListener
{
    protected HashMapExt allActors = new HashMapExt();
    protected TexImage landMapT;
    protected TexImage landMapH;
    protected Mat matLabel = null;
    private static final int EXT_TYPES = 4;
    private static final int OFS_BRIDGE = 4;
    private static final int OFS_ROAD = 3;
    private static final int OFS_HEIGHT = 2;
    private static final int OFS_TILE = 1;
    private boolean bTMapChanged;
    private boolean bHMapChanged;
    private boolean bBridgeChanged;
    Type[] type;
    private HashMapExt _saveCls0Map = new HashMapExt();
    private HashMapExt _saveClsMap = new HashMapExt();
    private Point2d p2d = new Point2d();
    private int newCurType;
    private int newCurItem;
    private ActorSpawnArg spawnArg = new ActorSpawnArg();
    private int fillHeight = 0;
    private Point3d _startFill = new Point3d();
    private Point3d _endFill = new Point3d();
    private Point3d _stepFill = new Point3d();
    private int squareTile = 1;
    private ArrayList _clipSpawns = new ArrayList();
    private ArrayList _clipAirdroms = new ArrayList();
    private ArrayList _clipLoc = new ArrayList();
    private Point3d _clipP0 = new Point3d();
    private GWindowFileOpen dlgPasteFrom;
    private int startComboBox1;
    ViewItem[] viewType;
    GWindowMenuItem viewBridge;
    GWindowMenuItem viewRunaway;
    HashMap viewClassFingers = new HashMap();
    GWindowMenuItem mSave_st;
    GWindowMenuItem mapLoaded_st;
    GWindowMenuItem mLoad_st;
    GWindowMenuItem mSaveSpawn_st;
    GWindowMenuItem mLoadSpawn_st;
    GWindowMenuItem mSaveAs_st;
    GWindowMenuItem mLoadAs_st;
    GWindowMenuItem mCreateBridges;
    private GWindowFileOpen dlgLoadAs;
    private GWindowFileOpen dlgLoadSpawn;
    private GWindowFileSaveAs dlgSaveAs;
    private GWindowFileSaveAs dlgSaveSpawn;
    private int newIndxBridge = 10000;
    private Bridge curBridge;
    private int indxBridge;
    private Point3d _clearRoadP0 = new Point3d();
    private Point3d _clearRoadP1 = new Point3d();
    private ArrayList _clearRoadArray = new ArrayList();
    private float[] _clearRoadBound = new float[6];
    private ClearRoadFilter _clearRoadFilter = new ClearRoadFilter();
    private GWindowFileOpen dlgLoadPattern;
    private GWindowFileOpen dlgRemovePattern;
    private double PIXEL = 200.0;
    private double PIXELD2 = 100.0;
    private int TILE = 8;
    private int TILEMASK = 7;
    private double QUAD = PIXEL * (double) TILE;
    private int _changedPatternType;
    Point3f _changeOffsetXY = new Point3f();
    Loc _changeLoc = new Loc();
    /*synthetic*/ static Class class$com$maddox$il2$builder$PlMapActors;
    
    static class ItemPattern
    {
	public int finger;
	public int flags;
	public float x;
	public float y;
	public ActorSpawn spawn;
	
	public float getAzimut() {
	    return ((float) (flags >> 16)
		    + (float) (flags >> 8 & 0xff) / 256.0F);
	}
	
	public ItemPattern(int i, float f, float f_0_, float f_1_) {
	    finger = i;
	    x = f;
	    y = f_0_;
	    flags = (int) f_1_ << 16 | ((int) (f_1_ * 256.0F) & 0xff) << 8;
	    spawn = (ActorSpawn) Spawn.get(i);
	}
    }
    
    private static class ClearRoadFilter implements ActorFilter
    {
	private ClearRoadFilter() {
	    /* empty */
	}
	
	public boolean isUse(Actor actor, double d) {
	    return actor instanceof ActorMesh;
	}
    }
    
    class ViewItem extends GWindowMenuItem
    {
	int indx;
	
	public void execute() {
	    bChecked = !bChecked;
	    viewType(indx);
	}
	
	public ViewItem(int i, GWindowMenu gwindowmenu, String string,
			String string_2_) {
	    super(gwindowmenu, string, string_2_);
	    indx = i;
	}
    }
    
    static class Type
    {
	public String name;
	public Item[] item;
	
	public Type(String string, Item[] items) {
	    name = string;
	    item = items;
	}
    }
    
    static class Item
    {
	public String name;
	ActorSpawn spawn_;
	String fullClassName;
	int fingerOfFullClassName;
	
	public Item(String string, String string_3_) {
	    name = string;
	    fullClassName = string_3_;
	    fingerOfFullClassName = Finger.Int(fullClassName);
	    spawn_ = (ActorSpawn) Spawn.get_WithSoftClass(fullClassName);
	}
	
	public Item(String string) {
	    name = string;
	    fullClassName = null;
	    spawn_ = null;
	    fingerOfFullClassName = Finger.Int("* an impossible name *");
	}
    }
    
    private static final String getFullClassName(Actor actor) {
	return (actor instanceof SoftClass
		? ((SoftClass) actor).fullClassName()
		: actor.getClass().getName());
    }
    
    private static final int getFingerOfFullClassName(Actor actor) {
	return Finger.Int(actor instanceof SoftClass
			  ? ((SoftClass) actor).fullClassName()
			  : actor.getClass().getName());
    }
    
    private String staticFileName() {
	String string = "maps/" + PlMapLoad.mapFileName();
	SectFile sectfile = new SectFile(string);
	int i = sectfile.sectionIndex("static");
	if (i >= 0 && sectfile.vars(i) > 0) {
	    String string_4_ = sectfile.var(i, 0);
	    return HomePath.concatNames(string, string_4_);
	}
	return null;
    }
    
    
    public void mapLoaded_st() {
 deleteAll();
 builder.deleteAll();
 Engine.drawEnv().resetGameClear();
 Engine.drawEnv().resetGameCreate();
 if (World.cur().statics != null)
     World.cur().statics.resetGame();
 if (builder.isLoadedLandscape()) {
     load_st(staticFileName());
     Statics.trim();
     Engine.dreamEnv().resetGlobalListener(World.cur().statics);
 }
    }
    
    
    public void deleteAll() {
	for (Map.Entry entry = allActors.nextEntry(null); entry != null;
	     entry = allActors.nextEntry(entry)) {
	    Actor actor = (Actor) entry.getKey();
	    if (Actor.isValid(actor))
		actor.destroy();
	}
	allActors.clear();
    }
    
    public void loadAs_st(String string) {
	load_st(string, false, false);
    }
    
    public void load_st(String string) {
	load_st(string, true, false);
    }
    
    public void load_st(String string, boolean bool, boolean bool_5_) {
	int i = 0;
	if (bool_5_) {
	    _clipSpawns.clear();
	    _clipAirdroms.clear();
	    _clipLoc.clear();
	    _clipP0.x = _clipP0.y = _clipP0.z = 0.0;
	} else {
	    landMapT = new TexImage();
	    landMapH = new TexImage();
	    try {
		landMapT.LoadTGA("maps/" + PlMapLoad.mapDirName() + "/"
				 + World.land().config.typeMap);
		landMapH.LoadTGA("maps/" + PlMapLoad.mapDirName() + "/"
				 + World.land().config.heightMap);
	    } catch (Exception exception) {
		/* empty */
	    }
	    bTMapChanged = false;
	    bBridgeChanged = false;
	    if (string == null) {
		if (!"Test".equals(PlMapLoad.mapKeyName()) && !bool)
		    PlMapLoad.bridgesCreate(landMapT);
		return;
	    }
	}
	Loc loc = new Loc();
	try {
	    DataInputStream datainputstream
		= new DataInputStream(new SFSInputStream(string));
	    boolean bool_6_ = true;
	    int i_7_ = datainputstream.readInt();
	    if (i_7_ == -655535) {
		bool_6_ = false;
		i_7_ = datainputstream.readInt();
	    }
	    int i_8_ = 0;
	    for (int i_9_ = 0; i_9_ < i_7_; i_9_++) {
		int i_10_ = datainputstream.readInt();
		int i_11_ = datainputstream.readInt();
		int i_12_ = datainputstream.readInt();
		int i_13_ = datainputstream.readInt();
		int i_14_ = datainputstream.readInt();
		float f = datainputstream.readFloat();
		if (bool && !bool_5_) {
		    Bridge bridge = new Bridge(i_8_++, i_14_, i_10_, i_11_,
					       i_12_, i_13_, f);
		    Property.set(bridge, "builderSpawn", "");
		    PlMapLoad.bridgeActors.add(bridge);
		}
	    }
	    if (bool_6_) {
		i_7_ = datainputstream.readInt();
		if (i_7_ > 0) {
		    while (i_7_-- > 0) {
			String string_15_ = datainputstream.readUTF();
			Spawn.get_WithSoftClass(string_15_);
		    }
		    i_7_ = datainputstream.readInt();
		    while (i_7_-- > 0) {
			int i_16_ = datainputstream.readInt();
			float f = datainputstream.readFloat();
			float f_17_ = datainputstream.readFloat();
			float f_18_ = datainputstream.readFloat();
			float f_19_ = datainputstream.readFloat();
			float f_20_ = datainputstream.readFloat();
			float f_21_ = datainputstream.readFloat();
			loc.set((double) f, (double) f_17_, (double) f_18_,
				f_19_, f_20_, f_21_);
			ActorSpawn actorspawn = (ActorSpawn) Spawn.get(i_16_);
			if (actorspawn != null) {
			    if (bool_5_) {
				Loc loc_22_ = new Loc(loc);
				_clipSpawns.add(actorspawn);
				_clipLoc.add(loc_22_);
				_clipP0.add(loc_22_.getPoint());
				i++;
			    } else
				insertt(actorspawn, loc, false);
			}
		    }
		}
	    } else {
		i_7_ = datainputstream.readInt();
		Object object = null;
		if (i_7_ > 0) {
		    ActorSpawn[] actorspawns = new ActorSpawn[i_7_];
		    for (int i_23_ = 0; i_23_ < i_7_; i_23_++) {
			String string_24_ = datainputstream.readUTF();
			actorspawns[i_23_]
			    = (ActorSpawn) Spawn.get_WithSoftClass(string_24_);
		    }
		    i_7_ = datainputstream.readInt();
		    while (i_7_-- > 0) {
			int i_25_ = datainputstream.readInt();
			float f = datainputstream.readFloat();
			float f_26_ = datainputstream.readFloat();
			float f_27_ = datainputstream.readFloat();
			loc.set((double) f, (double) f_26_, 0.0, f_27_, 0.0F,
				0.0F);
			if (i_25_ < actorspawns.length
			    && actorspawns[i_25_] != null) {
			    if (bool_5_) {
				Loc loc_28_ = new Loc(loc);
				_clipSpawns.add(actorspawns[i_25_]);
				_clipLoc.add(loc_28_);
				_clipP0.add(loc_28_.getPoint());
				i++;
			    } else
				insertt(actorspawns[i_25_], loc, false);
			}
		    }
		}
		i_7_ = datainputstream.readInt();
		if (i_7_ > 0) {
		    ActorSpawn[] actorspawns = new ActorSpawn[i_7_];
		    for (int i_29_ = 0; i_29_ < i_7_; i_29_++) {
			String string_30_ = datainputstream.readUTF();
			actorspawns[i_29_]
			    = (ActorSpawn) Spawn.get_WithSoftClass(string_30_);
		    }
		    int i_31_ = datainputstream.readInt();
		    while (i_31_-- > 0) {
			int i_32_ = datainputstream.readInt();
			float f = (float) (i_32_ & 0xffff) * 200.0F;
			float f_33_ = (float) (i_32_ >> 16 & 0xffff) * 200.0F;
			int i_34_ = datainputstream.readInt();
			while (i_34_-- > 0) {
			    int i_35_ = datainputstream.readInt();
			    int i_36_ = datainputstream.readInt();
			    int i_37_ = i_35_ & 0x7fff;
			    if (i_37_ < actorspawns.length
				&& actorspawns[i_37_] != null) {
				short i_38_ = (short) (i_35_ >> 16);
				short i_39_ = (short) (i_36_ & 0xffff);
				short i_40_ = (short) (i_36_ >> 16 & 0xffff);
				float f_41_
				    = (float) i_38_ * 360.0F / 32000.0F;
				float f_42_
				    = (float) i_39_ * 200.0F / 32000.0F + f;
				float f_43_
				    = ((float) i_40_ * 200.0F / 32000.0F
				       + f_33_);
				loc.set((double) f_42_, (double) f_43_, 0.0,
					-f_41_, 0.0F, 0.0F);
				if (bool_5_) {
				    Loc loc_44_ = new Loc(loc);
				    _clipSpawns.add(actorspawns[i_37_]);
				    _clipLoc.add(loc_44_);
				    _clipP0.add(loc_44_.getPoint());
				    i++;
				} else
				    insertt(actorspawns[i_37_], loc, false);
			    }
			}
		    }
		}
	    }
	    if (datainputstream.available() > 0) {
		PlMapAirdrome plmapairdrome
		    = (PlMapAirdrome) getPlugin("MapAirdrome");
		Point3d point3d = new Point3d();
		for (int i_45_ = 0; i_45_ < 3; i_45_++) {
		    i_7_ = datainputstream.readInt();
		    while (i_7_-- > 0) {
			PathAirdrome pathairdrome
			    = new PathAirdrome(Plugin.builder.pathes, i_45_);
			Property.set(pathairdrome, "builderPlugin",
				     plmapairdrome);
			pathairdrome.drawing(plmapairdrome.mView.bChecked);
			PAirdrome pairdrome = null;
			int i_46_ = datainputstream.readInt();
			for (int i_47_ = 0; i_47_ < i_46_; i_47_++) {
			    point3d.set((double) datainputstream.readFloat(),
					(double) datainputstream.readFloat(),
					0.0);
			    point3d.z
				= Engine.land().HQ(point3d.x, point3d.y) + 0.2;
			    pairdrome = new PAirdrome(pathairdrome, pairdrome,
						      point3d, i_45_);
			    Property.set(pairdrome, "builderPlugin",
					 plmapairdrome);
			    Property.set(pairdrome, "builderSpawn", "");
			    if (bool_5_) {
				_clipP0.add(point3d);
				i++;
			    }
			}
			if (bool_5_) {
			    _clipAirdroms
				.add(PathAirdrome.toSpawnString(pathairdrome));
			    pathairdrome.destroy();
			}
		    }
		}
	    }
	    datainputstream.close();
	    if (!bool_5_) {
		viewUpdate();
		Engine.drawEnv().staticTrimToSize();
	    }
	} catch (Exception exception) {
	    String string_48_ = ("Actors load from '" + string + "' FAILED: "
				 + exception.getMessage());
	    System.out.println(string_48_);
	    exception.printStackTrace();
	    builder.tip(string_48_);
	}
	if (bool_5_ && i > 0) {
	    _clipP0.x /= (double) i;
	    _clipP0.y /= (double) i;
	    _clipP0.z /= (double) i;
	    paste();
	}
    }
    
    public void save_st() {
	save_st(staticFileName());
	if (bTMapChanged || bBridgeChanged) {
	    int i = PlMapLoad.bridgeActors.size();
	    TexImage teximage = landMapT;
	    for (int i_49_ = 0; i_49_ < i; i_49_++) {
		Bridge bridge = (Bridge) PlMapLoad.bridgeActors.get(i_49_);
		int i_50_ = bridge.__x1;
		int i_51_ = bridge.__y1;
		int i_52_ = bridge.__x2;
		int i_53_ = bridge.__y2;
		int i_54_ = i_52_ - i_50_;
		if (i_54_ < 0)
		    i_54_ = -1;
		if (i_54_ > 0)
		    i_54_ = 1;
		int i_55_ = i_53_ - i_51_;
		if (i_55_ < 0)
		    i_55_ = -1;
		if (i_55_ > 0)
		    i_55_ = 1;
		for (;;) {
		    teximage.I(i_50_, i_51_,
			       teximage.intI(i_50_, i_51_) & ~0xe0);
		    if (i_50_ == i_52_ && i_51_ == i_53_)
			break;
		    i_50_ += i_54_;
		    i_51_ += i_55_;
		}
	    }
	    String string = ("maps/" + PlMapLoad.mapDirName() + "/"
			     + World.land().config.typeMap);
	    try {
		teximage.SaveTGA(string);
		bTMapChanged = false;
	    } catch (Exception exception) {
		String string_56_ = ("Type map '" + string + "' save FAILED: "
				     + exception.getMessage());
		System.out.println(string_56_);
		builder.tip(string_56_);
	    }
	}
	if (bHMapChanged) {
	    String string = ("maps/" + PlMapLoad.mapDirName() + "/"
			     + World.land().config.heightMap);
	    try {
		landMapH.SaveTGA(string);
		bHMapChanged = false;
	    } catch (Exception exception) {
		String string_57_
		    = ("Height map '" + string + "' save FAILED: "
		       + exception.getMessage());
		System.out.println(string_57_);
		builder.tip(string_57_);
	    }
	}
	doSave_st(null);
    }
    
    public void saveAs_st(String string) {
	save_st(string, false);
    }
    
    public void save_st(String string) {
	save_st(string, true);
    }
    
    public void save_st(String string, boolean bool) {
	if (string != null) {
	    try {
		DataOutputStream dataoutputstream
		    = new DataOutputStream(new FileOutputStream(string));
		dataoutputstream.writeInt(-655535);
		int i = PlMapLoad.bridgeActors.size();
		if (i == 0 || !bool)
		    dataoutputstream.writeInt(0);
		else {
		    dataoutputstream.writeInt(i);
		    for (int i_58_ = 0; i_58_ < i; i_58_++) {
			Bridge bridge
			    = (Bridge) PlMapLoad.bridgeActors.get(i_58_);
			dataoutputstream.writeInt(bridge.__x1);
			dataoutputstream.writeInt(bridge.__y1);
			dataoutputstream.writeInt(bridge.__x2);
			dataoutputstream.writeInt(bridge.__y2);
			dataoutputstream.writeInt(bridge.__type);
			dataoutputstream.writeFloat(bridge.__offsetK);
		    }
		}
		_saveCls0Map.clear();
		_saveClsMap.clear();
		HashMapXY16List hashmapxy16list = new HashMapXY16List(7);
		int i_59_ = 0;
		int i_60_ = 0;
		int i_61_ = 0;
		for (Map.Entry entry = allActors.nextEntry(null);
		     entry != null; entry = allActors.nextEntry(entry)) {
		    Actor actor = (Actor) entry.getKey();
		    if (Actor.isValid(actor)) {
			String string_62_ = getFullClassName(actor);
			if (actor instanceof Runaway
			    || actor instanceof Mountain) {
			    if (!_saveCls0Map.containsKey(string_62_)) {
				_saveCls0Map.put(string_62_,
						 new Integer(i_59_));
				i_59_++;
			    }
			    i_60_++;
			} else {
			    if (!_saveClsMap.containsKey(string_62_)) {
				_saveClsMap.put(string_62_,
						new Integer(i_61_));
				i_61_++;
			    }
			    Point3d point3d = actor.pos.getAbsPoint();
			    hashmapxy16list.put((int) (point3d.y / 200.0),
						(int) (point3d.x / 200.0),
						actor);
			}
		    }
		}
		if (i_59_ > 0) {
		    String[] strings = new String[i_59_];
		    for (Map.Entry entry = _saveCls0Map.nextEntry(null);
			 entry != null;
			 entry = _saveCls0Map.nextEntry(entry)) {
			String string_63_ = (String) entry.getKey();
			Integer integer = (Integer) entry.getValue();
			strings[integer.intValue()] = string_63_;
		    }
		    dataoutputstream.writeInt(i_59_);
		    for (int i_64_ = 0; i_64_ < i_59_; i_64_++)
			dataoutputstream.writeUTF(strings[i_64_]);
		    dataoutputstream.writeInt(i_60_);
		    for (Map.Entry entry = allActors.nextEntry(null);
			 entry != null; entry = allActors.nextEntry(entry)) {
			Actor actor = (Actor) entry.getKey();
			if (Actor.isValid(actor)) {
			    String string_65_ = getFullClassName(actor);
			    if (_saveCls0Map.containsKey(string_65_)) {
				int i_66_
				    = ((Integer) _saveCls0Map.get(string_65_))
					  .intValue();
				Point3d point3d = actor.pos.getAbsPoint();
				Orient orient = actor.pos.getAbsOrient();
				dataoutputstream.writeInt(i_66_);
				dataoutputstream.writeFloat((float) point3d.x);
				dataoutputstream.writeFloat((float) point3d.y);
				dataoutputstream.writeFloat(orient.azimut());
			    }
			}
		    }
		} else
		    dataoutputstream.writeInt(0);
		if (i_61_ > 0) {
		    String[] strings = new String[i_61_];
		    for (Map.Entry entry = _saveClsMap.nextEntry(null);
			 entry != null; entry = _saveClsMap.nextEntry(entry)) {
			String string_67_ = (String) entry.getKey();
			Integer integer = (Integer) entry.getValue();
			strings[integer.intValue()] = string_67_;
		    }
		    dataoutputstream.writeInt(i_61_);
		    for (int i_68_ = 0; i_68_ < i_61_; i_68_++)
			dataoutputstream.writeUTF(strings[i_68_]);
		    int i_69_ = 0;
		    int[] is = hashmapxy16list.allKeys();
		    dataoutputstream.writeInt(is.length);
		    for (int i_70_ = 0; i_70_ < is.length; i_70_++) {
			int i_71_ = hashmapxy16list.key2x(is[i_70_]);
			int i_72_ = hashmapxy16list.key2y(is[i_70_]);
			float f = (float) i_71_ * 200.0F;
			float f_73_ = (float) i_72_ * 200.0F;
			dataoutputstream.writeInt(i_72_ << 16 | i_71_);
			List list = hashmapxy16list.get(i_72_, i_71_);
			int i_74_ = list.size();
			i_69_ += i_74_;
			dataoutputstream.writeInt(i_74_);
			for (int i_75_ = 0; i_75_ < i_74_; i_75_++) {
			    Actor actor = (Actor) list.get(i_75_);
			    String string_76_ = getFullClassName(actor);
			    int i_77_ = ((Integer) _saveClsMap.get(string_76_))
					    .intValue();
			    Point3d point3d = actor.pos.getAbsPoint();
			    Orient orient = actor.pos.getAbsOrient();
			    int i_78_ = i_77_ & 0x7fff;
			    float f_79_ = orient.getYaw() % 360.0F;
			    i_78_ |= (int) (f_79_ * 32000.0F / 360.0F) << 16;
			    int i_80_ = ((int) ((point3d.x - (double) f)
						* 32000.0 / 200.0) & 0xffff
					 | (int) ((point3d.y - (double) f_73_)
						  * 32000.0 / 200.0) << 16);
			    dataoutputstream.writeInt(i_78_);
			    dataoutputstream.writeInt(i_80_);
			}
		    }
		    System.out.println("Saved actors: " + i_69_ + " blocks: "
				       + is.length);
		} else
		    dataoutputstream.writeInt(0);
		hashmapxy16list.clear();
		_saveCls0Map.clear();
		_saveClsMap.clear();
		int[] is = { 0, 0, 0 };
		Object[] objects = builder.pathes.getOwnerAttached();
		for (int i_81_ = 0; i_81_ < objects.length; i_81_++) {
		    Actor actor = (Actor) objects[i_81_];
		    if (actor == null)
			break;
		    if (actor instanceof PathAirdrome) {
			PathAirdrome pathairdrome = (PathAirdrome) actor;
			is[pathairdrome._iType]++;
		    }
		}
		for (int i_82_ = 0; i_82_ < 3; i_82_++) {
		    dataoutputstream.writeInt(is[i_82_]);
		    objects = builder.pathes.getOwnerAttached();
		    for (int i_83_ = 0; i_83_ < objects.length; i_83_++) {
			Actor actor = (Actor) objects[i_83_];
			if (actor == null)
			    break;
			if (actor instanceof PathAirdrome) {
			    PathAirdrome pathairdrome = (PathAirdrome) actor;
			    if (pathairdrome._iType == i_82_) {
				int i_84_ = pathairdrome.points();
				dataoutputstream.writeInt(i_84_);
				for (int i_85_ = 0; i_85_ < i_84_; i_85_++) {
				    PPoint ppoint = pathairdrome.point(i_85_);
				    Point3d point3d = ppoint.pos.getAbsPoint();
				    dataoutputstream
					.writeFloat((float) point3d.x);
				    dataoutputstream
					.writeFloat((float) point3d.y);
				}
			    }
			}
		    }
		}
		dataoutputstream.close();
	    } catch (Exception exception) {
		String string_86_ = ("Actors save to '" + string + "' FAILED: "
				     + exception.getMessage());
		System.out.println(string_86_);
		builder.tip(string_86_);
	    }
	}
    }
    
    public void loadSpawn_st(String string) {
	loadSpawnFrom_st(string);
	viewUpdate();
	Engine.drawEnv().staticTrimToSize();
    }
    
    public void loadSpawnFrom_st(SectFile sectfile, String string) {
	int i = sectfile.sectionIndex(string);
	if (i >= 0) {
	    int i_87_ = sectfile.vars(i);
	    for (int i_88_ = 0; i_88_ < i_87_; i_88_++) {
		String string_89_ = sectfile.line(i, i_88_);
		Actor actor = (Actor) CmdEnv.top().exec(string_89_);
		if (Actor.isValid(actor)) {
		    IconDraw.create(actor);
		    if (actor.icon == null)
			actor.icon = IconDraw.get("icons/unknown.mat");
		    Property.set(actor, "builderSpawn", "");
		    Property.set(actor, "builderPlugin", this);
		    allActors.put(actor, null);
		}
	    }
	}
    }
    
    public void loadSpawnFrom_st(String string) {
	try {
	    BufferedReader bufferedreader
		= new BufferedReader(new SFSReader(string));
	    String string_90_ = "";
	    for (;;) {
		string_90_ = bufferedreader.readLine();
		if (string_90_ == null)
		    break;
		Actor actor = (Actor) CmdEnv.top().exec(string_90_);
		if (Actor.isValid(actor) && !(actor instanceof PathAirdrome)) {
		    IconDraw.create(actor);
		    if (actor.icon == null)
			actor.icon = IconDraw.get("icons/unknown.mat");
		    Property.set(actor, "builderSpawn", "");
		    Property.set(actor, "builderPlugin", this);
		    allActors.put(actor, null);
		}
	    }
	    bufferedreader.close();
	} catch (Exception exception) {
	    System.out.println("Load '" + string + "'failed: "
			       + exception.getMessage());
	}
    }
    
    public void saveSpawn_st(String string) {
	saveSpawnTo_st(string);
    }
    
    public void saveSpawnTo_st(SectFile sectfile, String string) {
	int i = sectfile.sectionIndex(string);
	if (i < 0)
	    i = sectfile.sectionAdd(string);
	else
	    sectfile.sectionClear(i);
	Item[] items = null;
	for (int i_91_ = 0; i_91_ < type.length; i_91_++) {
	    if (string.equals(type[i_91_].name)) {
		items = type[i_91_].item;
		break;
	    }
	}
	if (items != null) {
	    for (Map.Entry entry = allActors.nextEntry(null); entry != null; entry = allActors.nextEntry(entry)) {
		Actor actor = (Actor) entry.getKey();
		if (Actor.isValid(actor)) {
		    int i_92_ = getFingerOfFullClassName(actor);
		    for (int i_93_ = 0; i_93_ < items.length; i_93_++) {
			if (i_92_ == items[i_93_].fingerOfFullClassName) {
			    Point3d point3d = actor.pos.getAbsPoint();
			    Orient orient = actor.pos.getAbsOrient();
			    sectfile.lineAdd(i, "spawn",
					     (items[i_93_].fullClassName
					      + " POSP " + (float) point3d.x
					      + " " + (float) point3d.y + " "
					      + (float) point3d.z + " POSO "
					      + orient.azimut() + " "
					      + orient.tangage() + " "
					      + orient.kren()));
			    break;
			}
		    }
		}
	    }
	}
    }
    
    public void saveSpawnTo_st(String string) {
	try {
	    PrintWriter printwriter
		= new PrintWriter(new BufferedWriter(new FileWriter(string)));
	    for (Map.Entry entry = allActors.nextEntry(null); entry != null;
		 entry = allActors.nextEntry(entry)) {
		Actor actor = (Actor) entry.getKey();
		if (Actor.isValid(actor)) {
		    Point3d point3d = actor.pos.getAbsPoint();
		    Orient orient = actor.pos.getAbsOrient();
		    printwriter.println("spawn " + getFullClassName(actor)
					+ " POSP " + (float) point3d.x + " "
					+ (float) point3d.y + " "
					+ (float) point3d.z + " POSO "
					+ orient.azimut() + " "
					+ orient.tangage() + " "
					+ orient.kren());
		}
	    }
	    Object[] objects = builder.pathes.getOwnerAttached();
	    for (int i = 0; i < objects.length; i++) {
		Actor actor = (Actor) objects[i];
		if (actor == null)
		    break;
		if (actor instanceof PathAirdrome) {
		    PathAirdrome pathairdrome = (PathAirdrome) actor;
		    printwriter
			.println(PathAirdrome.toSpawnString(pathairdrome));
		}
	    }
	    printwriter.close();
	} catch (Exception exception) {
	    String string_94_ = ("Actors save as spawns to '" + string
				 + "' FAILED: " + exception.getMessage());
	    System.out.println(string_94_);
	    builder.tip(string_94_);
	}
    }
    
    public void renderMap2D() {
	if (!builder.isFreeView()) {
	    Actor actor = builder.selectedActor();
	    Actor[] actors = builder.selectedActors();
	    IconDraw.setColor(255, 0, 0, 255);
	    for (int i = 0; i < actors.length; i++) {
		Actor actor_95_ = actors[i];
		if (actor_95_ == null)
		    break;
		if (builder.project2d(actor_95_.pos.getAbsPoint(), p2d)) {
		    if (actor_95_ == actor) {
			IconDraw.setColor(255, 255, 0, 255);
			IconDraw.render(actor_95_, p2d.x, p2d.y);
			IconDraw.setColor(255, 0, 0, 255);
		    } else
			IconDraw.render(actor_95_, p2d.x, p2d.y);
		}
	    }
	}
	int i = builder.wSelect_st.comboBox1.getSelected();
	int i_96_ = builder.wSelect_st.comboBox2.getSelected();
	if (i >= 0 && i < type.length && i_96_ >= 0
	    && i_96_ < type[i].item.length) {
	    if (i == type.length - 2 && matLabel != null) {
		Object object = null;
		Point3d point3d;
		if (builder.isFreeView()) {
		    Actor actor = builder.selectedActor();
		    if (!Actor.isValid(actor))
			return;
		    point3d = actor.pos.getAbsPoint();
		} else
		    point3d
			= builder.posScreenToLand(builder.mousePosX,
						  builder.mousePosY, 0.0, 0.1);
		int i_97_ = World.land().WORLD2PIXX(point3d.x);
		int i_98_ = World.land().WORLD2PIXY(point3d.y);
		int i_99_ = squareTile;
		i_99_ |= 0x1;
		int i_100_ = i_97_ - i_99_ / 2;
		int i_101_ = i_98_ - i_99_ / 2;
		World.land();
		int i_102_ = Landscape.getSizeXpix();
		World.land();
		int i_103_ = Landscape.getSizeYpix();
		IconDraw.setColor(255, 255, 255, 255);
		for (int i_104_ = i_101_; i_104_ < i_101_ + i_99_; i_104_++) {
		    for (int i_105_ = i_100_; i_105_ < i_100_ + i_99_;
			 i_105_++) {
			if (i_104_ >= 0 && i_104_ < i_103_ && i_105_ >= 0
			    && i_105_ < i_102_) {
			    double d
				= (double) World.land()
					       .PIX2WORLDX((float) i_105_);
			    double d_106_
				= (double) World.land()
					       .PIX2WORLDY((float) i_104_);
			    double d_107_ = World.land().HQ(d, d_106_);
			    builder.project2d(d, d_106_, d_107_, p2d);
			    IconDraw.render(matLabel, p2d.x, p2d.y);
			}
		    }
		}
	    }
	}
    }
    
    public void changeType() {
	int i = builder.wSelect_st.comboBox1.getSelected();
	int i_108_ = builder.wSelect_st.comboBox2.getSelected();
	if (i == type.length - 4) {
	    newCurType = i;
	    if (setCurBridge()) {
		Bridge bridge = curBridge;
		int i_109_ = 0;
		if (i_108_ == 0)
		    i_109_ = 64;
		if (i_108_ == 1)
		    i_109_ = 32;
		if (i_108_ == 2)
		    i_109_ = 128;
		changeCurBridge(bridge.__indx, i_109_, bridge.__x1,
				bridge.__y1, bridge.__x2, bridge.__y2,
				bridge.__offsetK);
		newCurType = i;
		newCurItem = i_108_;
	    }
	} else if (i >= 0 && i < type.length - 4) {
	    Actor actor = builder.selectedActor();
	    Loc loc = actor.pos.getAbs();
	    insertt(type[i].item[i_108_].spawn_, loc, true);
	    if (builder.selectedActor() != actor) {
		allActors.remove(actor);
		actor.destroy();
	    }
	    newCurType = i;
	    newCurItem = i_108_;
	}
    }
    
    public void changeType(boolean bool, boolean bool_110_) {
	int i = builder.wSelect_st.comboBox1.getSelected();
	int i_111_ = builder.wSelect_st.comboBox2.getSelected();
	if (i == type.length - 4) {
	    newCurType = i;
	    if (bool_110_)
		bridgeType(bool);
	    else
		bridgeLen(bool);
	} else {
	    int i_112_ = getFingerOfFullClassName(builder.selectedActor());
	    if (i < 0 || i >= type.length - 4)
		i = 0;
	    if (i_111_ < 0 || i_111_ >= type[i].item.length
		|| type[i].item[i_111_].fingerOfFullClassName != i_112_) {
		int i_113_ = 0;
		int i_114_;
		for (i_114_ = 0; i_114_ < type.length; i_114_++) {
		    for (i_113_ = 0;
			 (i_113_ < type[i_114_].item.length
			  && (type[i_114_].item[i_113_].fingerOfFullClassName
			      != i_112_));
			 i_113_++) {
			/* empty */
		    }
		    if (i_113_ != type[i_114_].item.length)
			break;
		}
		if (i_114_ != type.length) {
		    i = i_114_;
		    i_111_ = i_113_;
		} else
		    return;
	    }
	    if (bool_110_) {
		if (bool) {
		    if (--i < 0)
			i = 0;
		} else if (++i == type.length - 4)
		    i = type.length - 1 - 4;
		i_111_ = 0;
	    } else if (bool) {
		if (--i_111_ < 0)
		    i_111_ = 0;
	    } else if (++i_111_ == type[i].item.length)
		i_111_ = type[i].item.length - 1;
	    Actor actor = builder.selectedActor();
	    Loc loc = actor.pos.getAbs();
	    insertt(type[i].item[i_111_].spawn_, loc, true);
	    if (builder.selectedActor() != actor)
		actor.destroy();
	    newCurType = i;
	    newCurItem = i_111_;
	    fillComboBox2(newCurType, newCurItem);
	}
    }
    
    private Actor insertt(ActorSpawn actorspawn, Loc loc, boolean bool) {
	spawnArg.clear();
	spawnArg.point = loc.getPoint();
	spawnArg.orient = loc.getOrient();
	Actor actor;
	try {
	    Actor actor_115_ = actorspawn.actorSpawn(spawnArg);
	    IconDraw.create(actor_115_);
	    if (actor_115_.icon == null)
		actor_115_.icon = IconDraw.get("icons/unknown.mat");
	    builder.align(actor_115_);
	    Property.set(actor_115_, "builderSpawn", "");
	    Property.set(actor_115_, "builderPlugin", this);
	    allActors.put(actor_115_, null);
	    if (bool)
		builder.setSelected(actor_115_);
	    actor = actor_115_;
	} catch (Exception exception) {
	    System.out.println(exception.getMessage());
	    exception.printStackTrace();
	    return null;
	}
	return actor;
    }
    
    public void delete(Actor actor) {
	allActors.remove(actor);
	actor.destroy();
    }
    
    public void insertt(Loc loc, boolean bool) {
	int i = builder.wSelect_st.comboBox1.getSelected();
	int i_116_ = builder.wSelect_st.comboBox2.getSelected();
	if (i >= 0 && i < type.length && i_116_ >= 0
	    && i_116_ < type[i].item.length) {
	    if (i == type.length - 4)
		bridgeCreate(loc);
	    else if (i == type.length - 3) {
		bTMapChanged = true;
		int i_117_ = World.land().WORLD2PIXX(loc.getPoint().x);
		int i_118_ = World.land().WORLD2PIXY(loc.getPoint().y);
		int i_119_ = 0;
		if (i_116_ == 0)
		    i_119_ = 64;
		if (i_116_ == 1)
		    i_119_ = 32;
		if (i_116_ == 2)
		    i_119_ = 128;
		int i_120_ = landMapT.intI(i_117_, i_118_) | i_119_;
		landMapT.I(i_117_, i_118_, i_120_);
		World.land();
		Landscape.setPixelMapT(i_117_, i_118_, i_120_);
	    } else if (i == type.length - 2) {
		if (i_116_ == 0)
		    peekHeight(loc.getPoint());
		else if (i_116_ == 1)
		    setHeight(loc.getPoint());
		else if (i_116_ == 2)
		    blurHeight5(loc.getPoint(), 1);
	    } else if (i == type.length - 1)
		changeTile(loc.getPoint(), i_116_);
	    else {
		ActorSpawn actorspawn = type[i].item[i_116_].spawn_;
		insertt(actorspawn, loc, bool);
	    }
	}
    }
    
    private void peekHeight(Point3d point3d) {
	int i = World.land().WORLD2PIXX(point3d.x);
	int i_121_ = World.land().WORLD2PIXY(point3d.y);
	fillHeight = landMapH.intI(i, i_121_);
	builder.tip("Peek Height code = " + fillHeight);
    }
    
    private void fillHeight(Point3d point3d, int i) {
	int i_122_ = World.land().WORLD2PIXX(point3d.x);
	int i_123_ = World.land().WORLD2PIXY(point3d.y);
	i |= 0x1;
	int i_124_ = i_122_ - i / 2;
	int i_125_ = i_123_ - i / 2;
	World.land();
	int i_126_ = Landscape.getSizeXpix();
	World.land();
	int i_127_ = Landscape.getSizeYpix();
	for (int i_128_ = i_125_; i_128_ < i_125_ + i; i_128_++) {
	    for (int i_129_ = i_124_; i_129_ < i_124_ + i; i_129_++) {
		if (i_128_ >= 0 && i_128_ < i_127_ && i_129_ >= 0
		    && i_129_ < i_126_)
		    setHeight(i_129_, i_128_);
	    }
	}
    }
    
    private void setHeight(int i, int i_130_) {
	int i_131_ = landMapT.intI(i, i_130_);
	bHMapChanged = true;
	landMapH.I(i, i_130_, fillHeight);
	World.land();
	Landscape.setPixelMapH(i, i_130_, fillHeight);
    }
    
    private void setHeight(Point3d point3d) {
	int i = World.land().WORLD2PIXX(point3d.x);
	int i_132_ = World.land().WORLD2PIXY(point3d.y);
	setHeight(i, i_132_);
    }
    
    private void incHeight(int i, int i_133_, int i_134_) {
	int i_135_ = landMapT.intI(i, i_133_);
	bHMapChanged = true;
	int i_136_ = landMapH.intI(i, i_133_) + i_134_;
	if (i_136_ < 0)
	    i_136_ = 0;
	if (i_136_ > 255)
	    i_136_ = 255;
	landMapH.I(i, i_133_, i_136_);
	World.land();
	Landscape.setPixelMapH(i, i_133_, i_136_);
    }
    
    private void incHeight(Point3d point3d, int i) {
	int i_137_ = World.land().WORLD2PIXX(point3d.x);
	int i_138_ = World.land().WORLD2PIXY(point3d.y);
	incHeight(i_137_, i_138_, i);
    }
    
    private void incHeight(Point3d point3d, int i, int i_139_) {
	int i_140_ = World.land().WORLD2PIXX(point3d.x);
	int i_141_ = World.land().WORLD2PIXY(point3d.y);
	i |= 0x1;
	int i_142_ = i_140_ - i / 2;
	int i_143_ = i_141_ - i / 2;
	World.land();
	int i_144_ = Landscape.getSizeXpix();
	World.land();
	int i_145_ = Landscape.getSizeYpix();
	for (int i_146_ = i_143_; i_146_ < i_143_ + i; i_146_++) {
	    for (int i_147_ = i_142_; i_147_ < i_142_ + i; i_147_++) {
		if (i_146_ >= 0 && i_146_ < i_145_ && i_147_ >= 0
		    && i_147_ < i_144_)
		    incHeight(i_147_, i_146_, i_139_);
	    }
	}
    }
    
    public void msgMouseMove(int i, int i_148_, int i_149_) {
	int i_150_ = builder.wSelect_st.comboBox1.getSelected();
	int i_151_ = builder.wSelect_st.comboBox2.getSelected();
	if (i_150_ >= 0 && i_150_ < type.length && i_151_ >= 0
	    && i_151_ < type[i_150_].item.length) {
	    if (i_150_ == type.length - 2) {
		if (i_149_ == 0) {
		    if (HotKeyCmdEnv.env(Builder.envName).get("fill")
			    .isActive()) {
			Actor actor = builder.selectedActor();
			if (Actor.isValid(actor)) {
			    Point3d point3d = actor.pos.getAbsPoint();
			    peekHeight(point3d);
			    fillHeight(point3d, squareTile);
			}
		    }
		} else if (builder.isFreeView()) {
		    Actor actor = builder.selectedActor();
		    if (Actor.isValid(actor)) {
			Point3d point3d = actor.pos.getAbsPoint();
			if (i_151_ == 0)
			    incHeight(point3d, squareTile,
				      i_149_ > 0 ? 1 : -1);
			else {
			    peekHeight(point3d);
			    PlMapActors plmapactors_152_ = this;
			    plmapactors_152_.fillHeight
				= plmapactors_152_.fillHeight + (i_149_ > 0 ? 1
								 : -1);
			    if (fillHeight < 0)
				fillHeight = 0;
			    if (fillHeight > 255)
				fillHeight = 255;
			    fillHeight(point3d, squareTile);
			    if (i_151_ == 2)
				blurHeight5(point3d, squareTile);
			}
		    }
		}
	    }
	}
    }
    
    public void msgMouseButton(int i, boolean bool) {
	/* empty */
    }
    
    public void msgMouseAbsMove(int i, int i_153_, int i_154_) {
	/* empty */
    }
    
    private int HCode2M(int i) {
	if (i < 64)
	    return i;
	if (i < 96)
	    return 64 + (i - 64) * 2;
	if (i < 128)
	    return 128 + (i - 96) * 4;
	if (i < 160)
	    return 256 + (i - 128) * 8;
	if (i < 192)
	    return 512 + (i - 160) * 16;
	if (i < 224)
	    return 1024 + (i - 192) * 32;
	return 2048 + (i - 224) * 64;
    }
    
    private int M2HCode(int i) {
	if (i < 63)
	    return i;
	if (i < 126)
	    return (i - 64) / 2 + 64;
	if (i < 252)
	    return (i - 128) / 4 + 96;
	if (i < 504)
	    return (i - 256) / 8 + 128;
	if (i < 1008)
	    return (i - 512) / 16 + 160;
	if (i < 2016)
	    return (i - 1024) / 32 + 192;
	int i_155_ = (i - 2048) / 64 + 224;
	return i_155_ < 256 ? i_155_ : 255;
    }
    
    private void blurHeight5(Point3d point3d, int i) {
	int i_156_ = World.land().WORLD2PIXX(point3d.x);
	int i_157_ = World.land().WORLD2PIXY(point3d.y);
	i |= 0x1;
	int i_158_ = i_156_ - i / 2;
	int i_159_ = i_157_ - i / 2;
	World.land();
	int i_160_ = Landscape.getSizeXpix();
	World.land();
	int i_161_ = Landscape.getSizeYpix();
	for (int i_162_ = i_159_; i_162_ < i_159_ + i; i_162_++) {
	    for (int i_163_ = i_158_; i_163_ < i_158_ + i; i_163_++) {
		if (i_162_ >= 0 && i_162_ < i_161_ && i_163_ >= 0
		    && i_163_ < i_160_) {
		    int i_164_ = HCode2M(landMapH.intI(i_163_, i_162_)) * 4;
		    int i_165_ = 4;
		    if (i_163_ > 0) {
			i_164_ += HCode2M(landMapH.intI(i_163_ - 1, i_162_));
			i_165_++;
		    }
		    if (i_163_ + 1 < i_160_) {
			i_164_ += HCode2M(landMapH.intI(i_163_ + 1, i_162_));
			i_165_++;
		    }
		    if (i_162_ > 0) {
			i_164_ += HCode2M(landMapH.intI(i_163_, i_162_ - 1));
			i_165_++;
		    }
		    if (i_162_ + 1 < i_161_) {
			i_164_ += HCode2M(landMapH.intI(i_163_, i_162_ + 1));
			i_165_++;
		    }
		    if (i_165_ > 4) {
			int i_166_ = fillHeight;
			fillHeight = M2HCode(i_164_ / i_165_);
			setHeight(i_163_, i_162_);
			fillHeight = i_166_;
		    }
		}
	    }
	}
    }
    
    private void changeTiles(Point3d point3d, int i, int i_167_) {
	int i_168_ = World.land().WORLD2PIXX(point3d.x);
	int i_169_ = World.land().WORLD2PIXY(point3d.y);
	i_167_ |= 0x1;
	int i_170_ = i_168_ - i_167_ / 2;
	int i_171_ = i_169_ - i_167_ / 2;
	World.land();
	int i_172_ = Landscape.getSizeXpix();
	World.land();
	int i_173_ = Landscape.getSizeYpix();
	for (int i_174_ = i_171_; i_174_ < i_171_ + i_167_; i_174_++) {
	    for (int i_175_ = i_170_; i_175_ < i_170_ + i_167_; i_175_++) {
		if (i_174_ >= 0 && i_174_ < i_173_ && i_175_ >= 0
		    && i_175_ < i_172_)
		    changeTile(point3d, i_175_, i_174_, i);
	    }
	}
    }
    
    private void changeTile(Point3d point3d, int i) {
	int i_176_ = World.land().WORLD2PIXX(point3d.x);
	int i_177_ = World.land().WORLD2PIXY(point3d.y);
	changeTile(point3d, i_176_, i_177_, i);
    }
    
    private void changeTile(Point3d point3d, int i, int i_178_, int i_179_) {
	bTMapChanged = true;
	int i_180_ = tileType(i_179_);
	if (i_180_ != -1) {
	    int i_181_ = landMapT.intI(i, i_178_);
	    i_181_ = i_181_ & ~0x1f | i_180_;
	    landMapT.I(i, i_178_, i_181_);
	    World.land();
	    Landscape.setPixelMapT(i, i_178_, i_181_);
	    if (!Engine.dreamEnv().isSleep(point3d)) {
		int[] is = { i };
		int[] is_182_ = new int[1];
		int i_183_ = 0;
		World.land();
		is_182_[i_183_] = Landscape.getSizeYpix() - 1 - i_178_;
		int[] is_184_ = is_182_;
		World.cur().statics.msgDreamGlobal(false, 1, is, is_184_);
		World.cur().statics.msgDreamGlobal(true, 1, is, is_184_);
	    }
	}
    }
    
    private int tileType(int i) {
	boolean bool = false;
	int i_185_;
	switch (i) {
	default:
	    i_185_ = 28;
	    break;
	case 1:
	    i_185_ = 0;
	    break;
	case 2:
	    i_185_ = 1;
	    break;
	case 3:
	    i_185_ = 2;
	    break;
	case 4:
	    i_185_ = 3;
	    break;
	case 5:
	    i_185_ = 4;
	    break;
	case 6:
	    i_185_ = 5;
	    break;
	case 7:
	    i_185_ = 6;
	    break;
	case 8:
	    i_185_ = 7;
	    break;
	case 9:
	    i_185_ = 8;
	    break;
	case 10:
	    i_185_ = 9;
	    break;
	case 11:
	    i_185_ = 10;
	    break;
	case 12:
	    i_185_ = 11;
	    break;
	case 13:
	    i_185_ = 12;
	    break;
	case 14:
	    i_185_ = 13;
	    break;
	case 15:
	    i_185_ = 14;
	    break;
	case 16:
	    i_185_ = 15;
	    break;
	case 17:
	    i_185_ = 16;
	    break;
	case 18:
	    i_185_ = 17;
	    break;
	case 19:
	    i_185_ = 18;
	    break;
	case 20:
	    i_185_ = 19;
	    break;
	case 21:
	    i_185_ = 20;
	    break;
	case 22:
	    i_185_ = 21;
	    break;
	case 23:
	    i_185_ = 22;
	    break;
	case 24:
	    i_185_ = 23;
	    break;
	case 25:
	    i_185_ = 24;
	    break;
	case 26:
	    i_185_ = 30;
	    break;
	case 27:
	    i_185_ = 31;
	}
	return i_185_;
    }
    
    private void _doFill(Point3d point3d) {
	int i = builder.wSelect_st.comboBox1.getSelected();
	int i_186_ = builder.wSelect_st.comboBox2.getSelected();
	if (i >= 0 && i < type.length && i_186_ >= 0
	    && i_186_ < type[i].item.length && i == type.length - 1)
	    changeTile(point3d, i_186_);
    }
    
    private void _doFill() {
	int i = builder.wSelect_st.comboBox1.getSelected();
	int i_187_ = builder.wSelect_st.comboBox2.getSelected();
	if (i >= 0 && i < type.length && i_187_ >= 0
	    && i_187_ < type[i].item.length
	    && (i == type.length - 1 || i == type.length - 2)) {
	    _startFill.z = 0.0;
	    _endFill.z = 0.0;
	    double d = _endFill.distance(_startFill);
	    int i_188_ = (int) Math.round(d / 200.0) + 1;
	    float f = 1.0F / (float) i_188_;
	    for (int i_189_ = 0; i_189_ <= i_188_; i_189_++) {
		_stepFill.interpolate(_startFill, _endFill,
				      (float) i_189_ * f);
		if (i == type.length - 1)
		    changeTiles(_stepFill, i_187_, squareTile);
		else if (i_187_ == 1)
		    fillHeight(_stepFill, squareTile);
		else if (i_187_ == 2)
		    blurHeight5(_stepFill, squareTile);
	    }
	}
    }
    
    public void beginFill(Point3d point3d) {
	_startFill.set(point3d);
    }
    
    public void fill(Point3d point3d) {
	_endFill.set(point3d);
	_doFill();
	_startFill.set(point3d);
    }
    
    public void endFill(Point3d point3d) {
	/* empty */
    }
    
    public void fillPopUpMenu(GWindowMenuPopUp gwindowmenupopup,
			      Point3d point3d) {
	int i = builder.wSelect_st.comboBox1.getSelected();
	int i_190_ = builder.wSelect_st.comboBox2.getSelected();
	if (i < 0 || i >= type.length || i_190_ < 0
	    || i_190_ >= type[i].item.length
	    || i != type.length - 2 && i != type.length - 1)
	    gwindowmenupopup.addItem(new GWindowMenuItem(gwindowmenupopup,
							 "&Paste From File...",
							 null) {
		public void execute() {
		    PlMapActors.this.pasteFromFile(root);
		}
	    });
	else {
	    GWindowMenuItem gwindowmenuitem
		= (gwindowmenupopup.addItem
		   (new GWindowMenuItem(gwindowmenupopup, "&Fill Tile Size",
					null)));
	    gwindowmenuitem.subMenu
		= (GWindowMenu) gwindowmenuitem.create(new GWindowMenu());
	    gwindowmenuitem.subMenu.close(false);
	    GWindowMenuItem gwindowmenuitem_193_ = gwindowmenuitem.subMenu
						       .addItem(new GWindowMenuItem(gwindowmenuitem.subMenu, "&1", null) {
		public void execute() {
		    squareTile = 1;
		}
	    });
	    gwindowmenuitem_193_.bChecked = squareTile == 1;
	    gwindowmenuitem_193_ = gwindowmenuitem.subMenu
				       .addItem(new GWindowMenuItem(gwindowmenuitem.subMenu, "&3", null) {
		public void execute() {
		    squareTile = 3;
		}
	    });
	    gwindowmenuitem_193_.bChecked = squareTile == 3;
	    gwindowmenuitem_193_ = gwindowmenuitem.subMenu
				       .addItem(new GWindowMenuItem(gwindowmenuitem.subMenu, "&5", null) {
		public void execute() {
		    squareTile = 5;
		}
	    });
	    gwindowmenuitem_193_.bChecked = squareTile == 5;
	    gwindowmenuitem_193_ = gwindowmenuitem.subMenu
				       .addItem(new GWindowMenuItem(gwindowmenuitem.subMenu, "&7", null) {
		public void execute() {
		    squareTile = 7;
		}
	    });
	    gwindowmenuitem_193_.bChecked = squareTile == 7;
	    gwindowmenuitem_193_ = gwindowmenuitem.subMenu
				       .addItem(new GWindowMenuItem(gwindowmenuitem.subMenu, "&9", null) {
		public void execute() {
		    squareTile = 9;
		}
	    });
	    gwindowmenuitem_193_.bChecked = squareTile == 9;
	    gwindowmenupopup.addItem("-", null);
	    gwindowmenupopup.addItem(new GWindowMenuItem(gwindowmenupopup,
							 "&Paste From File...",
							 null) {
		public void execute() {
		    PlMapActors.this.pasteFromFile(root);
		}
	    });
	    gwindowmenupopup.addItem("-", null);
	    gwindowmenupopup.addItem(new GWindowMenuItem(gwindowmenupopup,
							 "&Insert Pattern As Static...",
							 null) {
		public void execute() {
		    PlMapActors.this.doInsertPattern(root);
		}
	    });
	    gwindowmenupopup.addItem(new GWindowMenuItem(gwindowmenupopup,
							 "&Remove Pattern From Static...",
							 null) {
		public void execute() {
		    PlMapActors.this.doRemovePattern(root);
		}
	    });
	}
    }
    
    public void delete(Loc loc) {
	int i = builder.wSelect_st.comboBox1.getSelected();
	int i_210_ = builder.wSelect_st.comboBox2.getSelected();
	if (i >= 0 && i < type.length && i_210_ >= 0
	    && i_210_ < type[i].item.length) {
	    do {
		if (i != type.length - 4) {
		    if (i == type.length - 3) {
			bTMapChanged = true;
			int i_211_ = World.land().WORLD2PIXX(loc.getPoint().x);
			int i_212_ = World.land().WORLD2PIXY(loc.getPoint().y);
			int i_213_ = 0;
			if (i_210_ == 0)
			    i_213_ = 64;
			if (i_210_ == 1)
			    i_213_ = 32;
			if (i_210_ == 2)
			    i_213_ = 128;
			int i_214_ = (landMapT.intI(i_211_, i_212_)
				      & (i_213_ ^ 0xffffffff));
			landMapT.I(i_211_, i_212_, i_214_);
			World.land();
			Landscape.setPixelMapT(i_211_, i_212_, i_214_);
		    } else if (i == type.length - 1)
			break;
		}
	    } while (false);
	}
    }
    
    public void cut() {
	if (!builder.isFreeView()) {
	    copy(false);
	    Actor[] actors = builder.selectedActors();
	    for (int i = 0; i < actors.length; i++) {
		Actor actor = actors[i];
		if (actor == null)
		    break;
		if (Actor.isValid(actor) && builder.isMiltiSelected(actor)) {
		    if (actor instanceof PAirdrome) {
			PathAirdrome pathairdrome
			    = (PathAirdrome) actor.getOwner();
			if (pathairdrome.pointIndx((PAirdrome) actor) == 0)
			    pathairdrome.destroy();
		    } else
			actor.destroy();
		}
	    }
	    builder.selectedActorsValidate();
	    builder.repaint();
	}
    }
    
    public void copy(boolean bool) {
	if (!builder.isFreeView()) {
	    _clipSpawns.clear();
	    _clipAirdroms.clear();
	    _clipLoc.clear();
	    int i = 0;
	    _clipP0.x = _clipP0.y = _clipP0.z = 0.0;
	    Actor[] actors = builder.selectedActors();
	    for (int i_215_ = 0; i_215_ < actors.length; i_215_++) {
		Actor actor = actors[i_215_];
		if (actor == null)
		    break;
		if (Actor.isValid(actor) && builder.isMiltiSelected(actor)) {
		    if (actor instanceof PAirdrome) {
			PAirdrome pairdrome = (PAirdrome) actor;
			_clipP0.add(actor.pos.getAbsPoint());
			i++;
			PathAirdrome pathairdrome
			    = (PathAirdrome) pairdrome.getOwner();
			if (pathairdrome.pointIndx(pairdrome) == 0)
			    _clipAirdroms
				.add(PathAirdrome.toSpawnString(pathairdrome));
		    } else {
			Loc loc = new Loc();
			actor.pos.getAbs(loc);
			_clipSpawns.add
			    (Spawn.get_WithSoftClass(getFullClassName(actor)));
			_clipLoc.add(loc);
			_clipP0.add(loc.getPoint());
			i++;
		    }
		}
	    }
	    if (i > 1) {
		_clipP0.x /= (double) i;
		_clipP0.y /= (double) i;
		_clipP0.z /= (double) i;
	    }
	    if (bool)
		builder.selectActorsClear();
	    builder.repaint();
	}
    }
    
    public void paste() {
	if (!builder.isFreeView()) {
	    builder.selectActorsClear();
	    int i = _clipSpawns.size();
	    if (i != 0 || _clipAirdroms.size() != 0) {
		Point3d point3d = builder.mouseWorldPos();
		Loc loc = new Loc();
		Point3d point3d_216_ = new Point3d();
		for (int i_217_ = 0; i_217_ < i; i_217_++) {
		    Loc loc_218_ = (Loc) _clipLoc.get(i_217_);
		    point3d_216_.sub(loc_218_.getPoint(), _clipP0);
		    point3d_216_.add(point3d);
		    loc.set(point3d_216_, loc_218_.getOrient());
		    Actor actor = insertt((ActorSpawn) _clipSpawns.get(i_217_),
					 loc, false);
		    builder.selectActorsAdd(actor);
		}
		i = _clipAirdroms.size();
		for (int i_219_ = 0; i_219_ < i; i_219_++) {
		    String string = (String) _clipAirdroms.get(i_219_);
		    PathAirdrome pathairdrome
			= (PathAirdrome) CmdEnv.top().exec(string);
		    int i_220_ = pathairdrome.points();
		    for (int i_221_ = 0; i_221_ < i_220_; i_221_++) {
			PPoint ppoint = pathairdrome.point(i_221_);
			ppoint.pos.getAbs(point3d_216_);
			point3d_216_.sub(_clipP0);
			point3d_216_.add(point3d);
			ppoint.pos.setAbs(point3d_216_);
			ppoint.pos.reset();
			builder.selectActorsAdd(ppoint);
		    }
		}
		builder.repaint();
	    }
	}
    }
    
    private void pasteFromFile(GWindowRoot gwindowroot) {
	if (dlgPasteFrom == null)
	    dlgPasteFrom = new GWindowFileOpen(gwindowroot, true,
					       "Paste From File ...", "maps",
					       (new GFileFilter[]
						{ new GFileFilterName
						  ("All files",
						   new String[] { "*" }) })) {
		public void result(String string) {
		    if (string != null)
			load_st("maps/" + string, false, true);
		}
	    };
	else
	    dlgPasteFrom.activateWindow();
    }
    
    private void fillComboBox1() {
	startComboBox1 = builder.wSelect_st.comboBox1.size();
	for (int i = 0; i < type.length; i++)
	    builder.wSelect_st.comboBox1.add(type[i].name);
	builder.wSelect_st.comboBox1.setSelected(0, true, false);
    }
    
    private void fillComboBox2(int i, int i_224_) {
	if (i >= startComboBox1 && i < startComboBox1 + type.length) {
	    if (builder.wSelect_st.curFilledType != i) {
		builder.wSelect_st.curFilledType = i;
		builder.wSelect_st.comboBox2.clear(false);
		for (int i_225_ = 0; i_225_ < type[i].item.length; i_225_++)
		    builder.wSelect_st.comboBox2.add(type[i].item[i_225_].name);
		builder.wSelect_st.comboBox1.setSelected(i, true, false);
	    }
	    builder.wSelect_st.comboBox2.setSelected(i_224_, true, false);
	}
    }
    
    
    
    
    
    
    public void syncSelector() {
	Actor actor = builder.selectedActor();
	int i = getFingerOfFullClassName(actor);
	for (int i_226_ = 0; i_226_ < type.length; i_226_++) {
	    for (int i_227_ = 0; i_227_ < type[i_226_].item.length; i_227_++) {
		if (i == type[i_226_].item[i_227_].fingerOfFullClassName) {
		    fillComboBox2(i_226_, i_227_);
		    return;
		}
	    }
	}
	if (actor instanceof Bridge) {
	    Bridge bridge = (Bridge) actor;
	    int i_228_ = bridge.type();
	    int i_229_ = 0;
	    switch (i_228_) {
	    case 2:
		i_229_ = 0;
		break;
	    case 1:
		i_229_ = 1;
		break;
	    case 0:
		i_229_ = 2;
		break;
	    }
	    fillComboBox2(type.length - 4, i_229_);
	}
    }
    
    public void configure() {
	matLabel = Mat.New("icons/label.mat");
	builder.bMultiSelect = true;
	if (sectFile == null)
	    throw new RuntimeException
		      ("PlMapActors: field 'sectFile' not defined");
	SectFile sectfile = new SectFile(sectFile, 0);
	int i = sectfile.sections();
	if (i <= 0)
	    throw new RuntimeException("PlMapActors: file '" + sectFile
				       + "' is empty");
	int i_230_ = 0;
	for (int i_231_ = 0; i_231_ < i; i_231_++) {
	    if (sectfile.sectionName(i_231_).equals("***"))
		i_230_++;
	}
	if (i_230_ <= 0)
	    throw new RuntimeException("PlMapActors: No type groups in file '"
				       + sectFile + "'");
	type = new Type[i_230_ + 4];
	int i_232_ = sectfile.sectionIndex("***");
	for (int i_233_ = 0; i_233_ < i_230_; i_233_++) {
	    int i_234_ = ((i_233_ >= i_230_ - 1 ? i
			   : sectfile.sectionIndex("***", i_232_ + 1))
			  - 1 - i_232_);
	    if (i_234_ <= 0)
		throw new RuntimeException("PlMapActors: Empty group in file '"
					   + sectFile + "'");
	    int i_235_ = sectfile.varIndex(i_232_, "Title");
	    if (i_235_ < 0)
		throw new RuntimeException("PlMapActors: No 'Title' in file '"
					   + sectFile + "', section '***' (#"
					   + i_232_ + ")");
	    String string = sectfile.value(i_232_, i_235_);
	    Item[] items = new Item[i_234_];
	    for (int i_236_ = 0; i_236_ < i_234_; i_236_++) {
		String string_237_ = sectfile.sectionName(i_232_ + 1 + i_236_);
		int i_238_ = string_237_.indexOf(' ');
		if (i_238_ > 0)
		    string_237_ = string_237_.substring(0, i_238_);
		String string_239_ = sectfile.get(string_237_, "Title");
		if (string_239_ == null) {
		    string_239_ = sectfile.get(string_237_, "equals");
		    if (string_239_ == null)
			throw new RuntimeException
				  ("PlMapActors: No 'Title' in file '"
				   + sectFile + "', section '" + string_237_
				   + "'");
		    int i_240_ = sectfile.sectionIndex(string_239_);
		    if (i_240_ < 0)
			throw new RuntimeException
				  ("PlMapActors: Unknown 'equals' in file '"
				   + sectFile + "', section '" + string_237_
				   + "'");
		    String string_241_ = sectfile.sectionName(i_240_);
		    string_239_ = sectfile.get(string_241_, "Title");
		    if (string_239_ == null)
			throw new RuntimeException
				  ("PlMapActors: No 'Title' in file '"
				   + sectFile + "', section '" + string_241_
				   + "'");
		}
		String string_242_ = string_237_;
		String string_243_ = "";
		int i_244_ = string_237_.lastIndexOf('$');
		if (i_244_ >= 0) {
		    string_242_ = string_237_.substring(0, i_244_);
		    string_243_ = string_237_.substring(i_244_ + 1);
		}
		Object object = null;
		Class var_class;
		try {
		    var_class = ObjIO.classForName(string_242_);
		} catch (Exception exception) {
		    throw new RuntimeException("PlMapActors: class '"
					       + string_242_ + "' not found");
		}
		if (i_244_ >= 0)
		    string_237_ = var_class.getName() + "$" + string_243_;
		else
		    string_237_ = var_class.getName();
		items[i_236_] = new Item(string_239_, string_237_);
	    }
	    type[i_233_] = new Type(string, items);
	    i_232_ += 1 + i_234_;
	}
	Item[] items = new Item[3];
	items[0] = new Item("Rail");
	items[1] = new Item("Country");
	items[2] = new Item("Highway");
	type[i_230_] = new Type("Bridge", items);
	items = new Item[3];
	items[0] = new Item("Rail");
	items[1] = new Item("Country");
	items[2] = new Item("Highway");
	type[i_230_ + 1] = new Type("Road", items);
	items = new Item[3];
	items[0] = new Item("Peek");
	items[1] = new Item("Fill");
	items[2] = new Item("Blur");
	type[i_230_ + 2] = new Type("Height", items);
	items = new Item[28];
	items[0] = new Item("WATER");
	items[1] = new Item("LowLand");
	items[2] = new Item("LowLand1");
	items[3] = new Item("LowLand2");
	items[4] = new Item("LowLand3");
	items[5] = new Item("MidLand");
	items[6] = new Item("MidLand1");
	items[7] = new Item("MidLand2");
	items[8] = new Item("MidLand3");
	items[9] = new Item("Mount");
	items[10] = new Item("Mount1");
	items[11] = new Item("Mount2");
	items[12] = new Item("Mount3");
	items[13] = new Item("Country");
	items[14] = new Item("Country1");
	items[15] = new Item("Country2");
	items[16] = new Item("Country3");
	items[17] = new Item("City");
	items[18] = new Item("City1");
	items[19] = new Item("City2");
	items[20] = new Item("City3");
	items[21] = new Item("Airfield");
	items[22] = new Item("Airfield1");
	items[23] = new Item("Airfield2");
	items[24] = new Item("Airfield3");
	items[25] = new Item("Wood");
	items[26] = new Item("CoastRiver");
	items[27] = new Item("CoastSea");
	type[i_230_ + 3] = new Type("Tile", items);
    }
    
    public void selectAll() {
	for (Map.Entry entry = allActors.nextEntry(null); entry != null;
	     entry = allActors.nextEntry(entry)) {
	    Actor actor = (Actor) entry.getKey();
	    if (Actor.isValid(actor) && actor.isDrawing())
		builder.selectActorsAdd(actor);
	}
    }
    
    void viewUpdate() {
	for (Map.Entry entry = allActors.nextEntry(null); entry != null;
	     entry = allActors.nextEntry(entry)) {
	    Actor actor = (Actor) entry.getKey();
	    if (Actor.isValid(actor)) {
		Integer integer = new Integer(getFingerOfFullClassName(actor));
		actor.drawing(viewClassFingers.containsKey(integer));
	    }
	}
	if (Actor.isValid(builder.selectedActor())
	    && !builder.selectedActor().isDrawing())
	    builder.setSelected(null);
	builder.selectedActorsValidate();
	if (!builder.isFreeView())
	    builder.repaint();
    }
    
    void viewType(int i, boolean bool) {
	int i_245_ = type[i].item.length;
	for (int i_246_ = 0; i_246_ < i_245_; i_246_++) {
	    Integer integer
		= new Integer(type[i].item[i_246_].fingerOfFullClassName);
	    if (bool)
		viewClassFingers.put(integer, null);
	    else
		viewClassFingers.remove(integer);
	}
	viewUpdate();
    }
    
    void viewType(int i) {
	if (i < type.length - 4 - 1)
	    viewType(i, viewType[i].bChecked);
    }
    
    public void viewTypeAll(boolean bool) {
	if (bool) {
	    for (int i = 0; i < type.length - 4; i++) {
		if (!viewType[i].bChecked) {
		    viewType[i].bChecked = true;
		    viewType(i, true);
		}
	    }
	} else {
	    for (int i = 0; i < type.length - 4; i++) {
		if (viewType[i].bChecked) {
		    viewType[i].bChecked = false;
		    viewType(i, false);
		}
	    }
	}
	viewBridge(bool);
	viewRunaway(bool);
    }
    
    void viewBridge(boolean bool) {
	builder.conf.bViewBridge = bool;
	viewBridge.bChecked = builder.conf.bViewBridge;
    }
    
    void viewBridge() {
	viewBridge(!builder.conf.bViewBridge);
    }
    
    void viewRunaway(boolean bool) {
	builder.conf.bViewRunaway = bool;
	viewRunaway.bChecked = builder.conf.bViewRunaway;
    }
    
    void viewRunaway() {
	viewRunaway(!builder.conf.bViewRunaway);
    }
    
    public void createGUI() {
	fillComboBox1();
	fillComboBox2(0, 0);
	builder.wSelect_st.comboBox1.addNotifyListener(new GNotifyListener() {
	    public boolean notify(GWindow gwindow, int i, int i_248_) {
		int i_249_ = Plugin.builder.wSelect_st.comboBox1.getSelected();
		if (i_249_ >= 0 && i == 2)
		    PlMapActors.this.fillComboBox2(i_249_, 0);
		return false;
	    }
	});
	viewType = new ViewItem[type.length];
	for (int i = 0; i < type.length - 4; i++) {
	    ViewItem viewitem
		= (ViewItem) (builder.mDisplayFilter.subMenu.addItem
			      (new ViewItem(i, builder.mDisplayFilter.subMenu,
					    " " + type[i].name, null)));
	    viewitem.bChecked = true;
	    viewType[i] = viewitem;
	    viewType(i, true);
	}
	builder.mDisplayFilter.subMenu.addItem("-", null);
	viewBridge = builder.mDisplayFilter.subMenu
			 .addItem(new GWindowMenuItem(builder.mDisplayFilter.subMenu, " ", null) {
	    public void execute() {
		viewBridge();
	    }
	});
	viewBridge.bChecked = builder.conf.bViewBridge;
	viewRunaway = builder.mDisplayFilter.subMenu
			  .addItem(new GWindowMenuItem(builder.mDisplayFilter.subMenu, " ", null) {
	    public void execute() {
		viewRunaway();
	    }
	});
	viewRunaway.bChecked = builder.conf.bViewRunaway;
	builder.mDisplayFilter.subMenu.addItem("-", null);
	builder.mDisplayFilter.subMenu.addItem(new GWindowMenuItem((builder
								    .mDisplayFilter
								    .subMenu),
								   "& ",
								   null) {
	    public void execute() {
		viewTypeAll(true);
	    }
	});
	builder.mDisplayFilter.subMenu.addItem(new GWindowMenuItem((builder
								    .mDisplayFilter
								    .subMenu),
								   "& ",
								   null) {
	    public void execute() {
		viewTypeAll(false);
	    }
	});
	mLoad_st = builder.mFile_st.subMenu.addItem(1, new GWindowMenuItem((builder.mFile_st.subMenu),"( )", null) {
	    public void execute() {
		if (PlMapLoad.mapFileName() != null) {
		    PlMapLoad plmapload = (PlMapLoad) Plugin.getPlugin("MapLoad");
		    PlMapLoad.Land land = PlMapLoad.getLandLoaded();
		    plmapload.mapUnload();
		    plmapload.guiMapLoad(land);
		    
		}
	    }
	});
	mSave_st = builder.mFile_st.subMenu.addItem(2, new GWindowMenuItem((builder.mFile_st.subMenu)," ( )", null) {
	    public void execute() {
		save_st();
	    }
	});
	
	
	mapLoaded_st = builder.mFile_st.subMenu.addItem(2, new GWindowMenuItem((builder.mFile_st.subMenu),"", null) {
	    public void execute() {
		mapLoaded_st();
	    }
	});
	
	
	
	
	builder.mFile_st.subMenu.addItem(3, "-", null);
	mLoadAs_st = builder.mFile_st.subMenu.addItem(4, new GWindowMenuItem((builder.mFile_st.subMenu),"  ( )", null) {
	    public void execute() {
		if (dlgLoadAs == null)
		dlgLoadAs = new GWindowFileOpen(root, true, "Load As ...","maps",(new GFileFilter[]{ new GFileFilterName("All files",(new String[]{ "*" })) })) {
			
			public void result(String string) {
			    if (string != null)
				loadAs_st("maps/" + string);
			}
		    };
		else
		    dlgLoadAs.activateWindow();
	    }
	});
	mLoadSpawn_st = builder.mFile_st.subMenu.addItem(5, new GWindowMenuItem((builder.mFile_st.subMenu),"  ( )",
									  null) {
	    public void execute() {
		if (dlgLoadSpawn == null)
		    dlgLoadSpawn = new GWindowFileOpen(root, true,
						       "Load Spawn ...",
						       "maps",
						       (new GFileFilter[]
							{ new GFileFilterName
							  ("All files",
							   (new String[]
							    { "*" })) })) {
			public void result(String string) {
			    if (string != null)
				loadSpawn_st("maps/" + string);
			}
		    };
		else
		    dlgLoadSpawn.activateWindow();
	    }
	});
	mSaveAs_st = builder.mFile_st.subMenu.addItem(6, new GWindowMenuItem((builder.mFile_st.subMenu),"  ( )",
								       null) {
	    public void execute() {
		if (dlgSaveAs == null)
		    dlgSaveAs = new GWindowFileSaveAs(root, true,
						      "Save As ...", "maps",
						      (new GFileFilter[]
						       { new GFileFilterName
							 ("All files",
							  (new String[]
							   { "*" })) })) {
			public void result(String string) {
			    if (string != null)
				saveAs_st("maps/" + string);
			}
		    };
		else
		    dlgSaveAs.activateWindow();
	    }
	});
	
	
	mSaveSpawn_st = builder.mFile_st.subMenu.addItem(7, new GWindowMenuItem((builder.mFile_st.subMenu),"  ( )",
									  null) {
	    public void execute() {
		if (dlgSaveSpawn == null)
		    dlgSaveSpawn = new GWindowFileSaveAs(root, true,
							 "Save As Spawn ...",
							 "maps",
							 (new GFileFilter[]
							  { new GFileFilterName
							    ("All files",
							     (new String[]
							      { "*" })) })) {
			public void result(String string) {
			    if (string != null)
				saveSpawn_st("maps/" + string);
			}
		    };
		else
		    dlgSaveSpawn.activateWindow();
	    }
	});
	builder.mFile_st.subMenu.addItem(8, "-", null);
	mCreateBridges = builder.mFile_st.subMenu
			     .addItem(9, new GWindowMenuItem(builder.mFile_st.subMenu, "  ...", null) {
	    public void execute() {
		new GWindowMessageBox(root, 20.0F, true, "CreateBridges ...",
				      "Start process creating bridges ?", 1,
				      0.0F) {
		    public void result(int i) {
			if (i == 3) {
			    loadAs_st(null);
			    PlMapLoad.bDrawNumberBridge = true;
			}
		    }
		};
	    }
	});
	builder.mFile_st.subMenu.addItem(10, "-", null);
	builder.mFile_st.subMenu.addItem(11, new GWindowMenuItem((builder.mFile_st
							       .subMenu),
							      "  ...",
							      null) {
	    public void execute() {
		new GWindowMessageBox(root, 20.0F, true, "Clear Roads ...",
				      "Start process clear roads ?", 1, 0.0F) {
		    public void result(int i) {
			if (i == 3)
			    PlMapActors.this.doClearRoads();
		    }
		};
	    }
	});
	builder.mFile_st.subMenu.addItem(12, new GWindowMenuItem((builder.mFile_st
							       .subMenu),
							      "  ...",
							      null) {
	    public void execute() {
		new GWindowMessageBox(root, 20.0F, true, "Remove Roads ...",
				      "Start process remove roads ?", 1,
				      0.0F) {
		    public void result(int i) {
			if (i == 3)
			    PlMapActors.this.doRemoveRoads();
		    }
		};
	    }
	});
	builder.mFile_st.subMenu.addItem(13, new GWindowMenuItem((builder.mFile_st
							       .subMenu),
							      "  ...",
							      null) {
	    public void execute() {
		new GWindowMessageBox(root, 20.0F, true, "Clear Water ...",
				      "Start process clear water ?", 1, 0.0F) {
		    public void result(int i) {
			if (i == 3)
			    PlMapActors.this.doClearWater();
		    }
		};
	    }
	});
    }
    
    public void start() {
	MsgAddListener.post(64, RTSConf.cur.mouse, this, null);
	HotKeyCmdEnv.setCurrentEnv(Builder.envName);
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "cut") {
	    public void begin() {
		cut();
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "copy") {
	    public void begin() {
		copy(true);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "paste") {
	    public void begin() {
		paste();
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "bridgeLeft") {
	    public void begin() {
		PlMapActors.this.bridgeRotate(true);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "bridgeRight") {
	    public void begin() {
		PlMapActors.this.bridgeRotate(false);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "bridgeOffset+") {
	    public void begin() {
		PlMapActors.this.bridgeOffset(true);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "bridgeOffset-") {
	    public void begin() {
		PlMapActors.this.bridgeOffset(false);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectLowLand") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 1);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectLowLand1") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 2);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectLowLand2") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 3);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectLowLand3") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 4);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectMidLand") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 5);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectMidLand1") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 6);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectMidLand2") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 7);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectMidLand3") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 8);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectMount") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 9);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectMount1") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 10);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectMount2") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 11);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectMount3") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 12);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCountry") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 13);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCountry1") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 14);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCountry2") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 15);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCountry3") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 16);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCity") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 17);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCity1") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 18);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCity2") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 19);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCity3") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 20);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectAirfield") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 21);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectAirfield1") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 22);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectAirfield2") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 23);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectAirfield3") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 24);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectWood") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 25);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCoastRiver") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 26);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectCoastSea") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 1, 27);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectRoadRail") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 3, 0);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectRoadCountry") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 3, 1);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectRoadHighway") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 3, 2);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectBridgeRail") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 4, 0);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectBridgeCountry") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 4, 1);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectBridgeHighway") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 4, 2);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectHeightPeek") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 2, 0);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectHeightFill") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 2, 1);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "selectHeightBlur") {
	    public void begin() {
		PlMapActors.this.setSelected(sName, type.length - 2, 2);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "incHeight") {
	    public void begin() {
		access$2308(PlMapActors.this);
		if (fillHeight > 255)
		    fillHeight = 255;
		Plugin.builder.tip("Peek Height code = " + fillHeight);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "decHeight") {
	    public void begin() {
		access$2310(PlMapActors.this);
		if (fillHeight < 0)
		    fillHeight = 0;
		Plugin.builder.tip("Peek Height code = " + fillHeight);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "incHeight10") {
	    public void begin() {
		access$2312(PlMapActors.this, 10);
		if (fillHeight > 255)
		    fillHeight = 255;
		Plugin.builder.tip("Peek Height code = " + fillHeight);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "decHeight10") {
	    public void begin() {
		access$2320(PlMapActors.this, 10);
		if (fillHeight < 0)
		    fillHeight = 0;
		Plugin.builder.tip("Peek Height code = " + fillHeight);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "incCurHeight") {
	    public void begin() {
		if (Plugin.builder.isFreeView()) {
		    Actor actor = Plugin.builder.selectedActor();
		    if (Actor.isValid(actor)) {
			Point3d point3d = actor.pos.getAbsPoint();
			PlMapActors.this.peekHeight(point3d);
			access$2308(PlMapActors.this);
			if (fillHeight > 255)
			    fillHeight = 255;
			Plugin.builder
			    .tip("Peek Cur Height code = " + fillHeight);
		    }
		}
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "decCurHeight") {
	    public void begin() {
		if (Plugin.builder.isFreeView()) {
		    Actor actor = Plugin.builder.selectedActor();
		    if (Actor.isValid(actor)) {
			Point3d point3d = actor.pos.getAbsPoint();
			PlMapActors.this.peekHeight(point3d);
			access$2310(PlMapActors.this);
			if (fillHeight < 0)
			    fillHeight = 0;
			Plugin.builder
			    .tip("Peek Cur Height code = " + fillHeight);
		    }
		}
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "incCurHeight10") {
	    public void begin() {
		if (Plugin.builder.isFreeView()) {
		    Actor actor = Plugin.builder.selectedActor();
		    if (Actor.isValid(actor)) {
			Point3d point3d = actor.pos.getAbsPoint();
			PlMapActors.this.peekHeight(point3d);
			access$2312(PlMapActors.this, 10);
			if (fillHeight > 255)
			    fillHeight = 255;
			Plugin.builder
			    .tip("Peek Cur Height code = " + fillHeight);
		    }
		}
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "decCurHeight10") {
	    public void begin() {
		if (Plugin.builder.isFreeView()) {
		    Actor actor = Plugin.builder.selectedActor();
		    if (Actor.isValid(actor)) {
			Point3d point3d = actor.pos.getAbsPoint();
			PlMapActors.this.peekHeight(point3d);
			access$2320(PlMapActors.this, 10);
			if (fillHeight < 0)
			    fillHeight = 0;
			Plugin.builder
			    .tip("Peek Cur Height code = " + fillHeight);
		    }
		}
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "square1") {
	    public void begin() {
		PlMapActors.this.setQuare(0);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "square3") {
	    public void begin() {
		PlMapActors.this.setQuare(1);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "square5") {
	    public void begin() {
		PlMapActors.this.setQuare(2);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "square7") {
	    public void begin() {
		PlMapActors.this.setQuare(3);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "square9") {
	    public void begin() {
		PlMapActors.this.setQuare(4);
	    }
	});
	HotKeyCmdEnv.addCmd(new HotKeyCmd(true, "damage") {
	    public void begin() {
		if (Actor.isValid(Plugin.builder.selectedActor())) {
		    Actor actor = Plugin.builder.selectedActor();
		    actor.setDiedFlag(!actor.getDiedFlag());
		}
	    }
	});
    }
    
    private void setQuare(int i) {
	squareTile = 1 + i * 2;
	builder.tip("Set Square size = " + squareTile);
    }
    
    private void setSelected(String string, int i, int i_355_) {
	builder.wSelect_st.comboBox1.setSelected(i, true, true);
	builder.wSelect_st.comboBox2.setSelected(i_355_, true, true);
	builder.tip(string);
    }
    
    private void bridgeCreate(Loc loc) {
	int i = builder.wSelect_st.comboBox2.getSelected();
	int i_356_ = World.land().WORLD2PIXX(loc.getPoint().x);
	int i_357_ = World.land().WORLD2PIXY(loc.getPoint().y);
	int i_358_ = 0;
	if (i == 0)
	    i_358_ = 64;
	if (i == 1)
	    i_358_ = 32;
	if (i == 2)
	    i_358_ = 128;
	Bridge bridge = new Bridge(newIndxBridge, i_358_, i_356_, i_357_,
				   i_356_ + 1, i_357_, 0.0F);
	Property.set(bridge, "builderSpawn", "");
	PlMapLoad.bridgeActors.add(bridge);
	newIndxBridge++;
	bBridgeChanged = true;
    }
    
    private boolean setCurBridge() {
	if (builder.selectedActor() == null
	    || !(builder.selectedActor() instanceof Bridge))
	    return false;
	curBridge = (Bridge) builder.selectedActor();
	indxBridge = PlMapLoad.bridgeActors.indexOf(curBridge);
	if (!Actor.isValid(curBridge) || indxBridge < 0)
	    return false;
	return true;
    }
    
    private void changeCurBridge(int i, int i_359_, int i_360_, int i_361_,
				 int i_362_, int i_363_, float f) {
	Bridge bridge = curBridge;
	bridge.destroy();
	bridge = new Bridge(i, i_359_, i_360_, i_361_, i_362_, i_363_, f);
	Property.set(bridge, "builderSpawn", "");
	PlMapLoad.bridgeActors.set(indxBridge, bridge);
	builder.setSelected(bridge);
	builder.repaint();
	bBridgeChanged = true;
    }
    
    private void bridgeType(boolean bool) {
	if (setCurBridge()) {
	    Bridge bridge = curBridge;
	    int i = bridge.__type;
	    switch (bridge.__type) {
	    case 64:
		if (bool) {
		    i = 128;
		    newCurItem = 2;
		} else {
		    i = 32;
		    newCurItem = 1;
		}
		break;
	    case 32:
		if (bool) {
		    i = 64;
		    newCurItem = 0;
		} else {
		    i = 128;
		    newCurItem = 2;
		}
		break;
	    case 128:
		if (bool) {
		    i = 32;
		    newCurItem = 1;
		} else {
		    i = 64;
		    newCurItem = 0;
		}
		break;
	    default:
		return;
	    }
	    changeCurBridge(bridge.__indx, i, bridge.__x1, bridge.__y1,
			    bridge.__x2, bridge.__y2, bridge.__offsetK);
	    fillComboBox2(newCurType, newCurItem);
	}
    }
    
    private void bridgeOffset(boolean bool) {
	if (setCurBridge()) {
	    Bridge bridge = curBridge;
	    float f = bridge.__offsetK;
	    if (bool) {
		f += 0.02F;
		if (f > 0.4F)
		    return;
	    } else {
		f -= 0.02F;
		if (f < -0.4F)
		    return;
	    }
	    changeCurBridge(bridge.__indx, bridge.__type, bridge.__x1,
			    bridge.__y1, bridge.__x2, bridge.__y2, f);
	}
    }
    
    private void bridgeLen(boolean bool) {
	if (setCurBridge()) {
	    Bridge bridge = curBridge;
	    int i = bridge.__x2 - bridge.__x1;
	    int i_364_ = bridge.__y2 - bridge.__y1;
	    if (bool) {
		if (i < 0)
		    i = -1;
		else if (i > 0)
		    i = 1;
		if (i_364_ < 0)
		    i_364_ = -1;
		else if (i_364_ > 0)
		    i_364_ = 1;
	    } else {
		if (i < 0)
		    i = 1;
		else if (i > 0)
		    i = -1;
		if (i_364_ < 0)
		    i_364_ = 1;
		else if (i_364_ > 0)
		    i_364_ = -1;
	    }
	    int i_365_ = bridge.__x2 + i;
	    int i_366_ = bridge.__y2 + i_364_;
	    if (i_365_ != bridge.__x1 || i_366_ != bridge.__y1)
		changeCurBridge(bridge.__indx, bridge.__type, bridge.__x1,
				bridge.__y1, i_365_, i_366_, bridge.__offsetK);
	}
    }
    
    private void bridgeRotate(boolean bool) {
	if (setCurBridge()) {
	    Bridge bridge = curBridge;
	    int i = bridge.__x2 - bridge.__x1;
	    int i_367_ = bridge.__y2 - bridge.__y1;
	    if (bool) {
		if (i > 0) {
		    if (i_367_ > 0)
			i_367_ = 0;
		    else if (i_367_ < 0)
			i = 0;
		    else
			i_367_ = -i;
		} else if (i < 0) {
		    if (i_367_ > 0)
			i = 0;
		    else if (i_367_ < 0)
			i_367_ = 0;
		    else
			i_367_ = -i;
		} else if (i_367_ > 0)
		    i = i_367_;
		else if (i_367_ < 0)
		    i = i_367_;
	    } else if (i > 0) {
		if (i_367_ > 0)
		    i = 0;
		else if (i_367_ < 0)
		    i_367_ = 0;
		else
		    i_367_ = i;
	    } else if (i < 0) {
		if (i_367_ > 0)
		    i_367_ = 0;
		else if (i_367_ < 0)
		    i = 0;
		else
		    i_367_ = i;
	    } else if (i_367_ > 0)
		i = -i_367_;
	    else if (i_367_ < 0)
		i = -i_367_;
	    int i_368_ = bridge.__x1 + i;
	    int i_369_ = bridge.__y1 + i_367_;
	    if (i_368_ != bridge.__x1 || i_369_ != bridge.__y1)
		changeCurBridge(bridge.__indx, bridge.__type, bridge.__x1,
				bridge.__y1, i_368_, i_369_, bridge.__offsetK);
	}
    }
    
    private void doClearWater() {
	builder.selectActorsClear();
	builder.setSelected(null);
	Landscape landscape = World.land();
	ArrayList arraylist = new ArrayList();
	for (Map.Entry entry = allActors.nextEntry(null); entry != null;
	     entry = allActors.nextEntry(entry)) {
	    Actor actor = (Actor) entry.getKey();
	    if (Actor.isValid(actor) && actor instanceof ActorMesh) {
		Point3d point3d = actor.pos.getAbsPoint();
		Mesh mesh = ((ActorMesh) actor).mesh();
		double d = 0.0;
		if (mesh instanceof HierMesh)
		    d = (double) (((ActorMesh) actor).mesh().visibilityR()
				  + 2.0F);
		else {
		    mesh.getBoundBox(_clearRoadBound);
		    double d_370_
			= (double) (Math.max(Math.abs(_clearRoadBound[0]),
					     Math.abs(_clearRoadBound[3]))
				    + 2.0F);
		    double d_371_
			= (double) (Math.max(Math.abs(_clearRoadBound[1]),
					     Math.abs(_clearRoadBound[4]))
				    + 2.0F);
		    d = Math.max(d_370_, d_371_);
		}
		d /= 2.0;
		if (landscape.isWater(point3d.x - d, point3d.y - d)
		    || landscape.isWater(point3d.x - d, point3d.y + d)
		    || landscape.isWater(point3d.x + d, point3d.y + d)
		    || landscape.isWater(point3d.x + d, point3d.y - d))
		    arraylist.add(actor);
	    }
	}
	int i = arraylist.size();
	for (int i_372_ = 0; i_372_ < i; i_372_++) {
	    Actor actor = (Actor) arraylist.get(i_372_);
	    allActors.remove(actor);
	    actor.destroy();
	}
    }
    
    private void doRemoveRoads() {
	builder.selectActorsClear();
	builder.setSelected(null);
	bTMapChanged = true;
	Landscape landscape = World.land();
	if (landscape != null) {
	    /* empty */
	}
	int i = Landscape.getSizeXpix();
	if (landscape != null) {
	    /* empty */
	}
	int i_373_ = Landscape.getSizeYpix();
	for (int i_374_ = 1; i_374_ < i_373_ - 1; i_374_++) {
	    int i_375_ = i_373_ - 1 - i_374_;
	    for (int i_376_ = 1; i_376_ < i - 1; i_376_++) {
		int i_377_ = landMapT.intI(i_376_, i_375_);
		if ((i_377_ & 0xe0) != 0) {
		    i_377_ &= ~0xe0;
		    landMapT.I(i_376_, i_375_, i_377_);
		    World.land();
		    Landscape.setPixelMapT(i_376_, i_375_, i_377_);
		}
	    }
	    if (i_374_ % 5 == 0) {
		int i_378_ = i_374_ * 100 / i_373_;
		RTSConf.cur.mainWindow.setTitle("" + i_378_ + "%");
	    }
	}
	RTSConf.cur.mainWindow.setTitle("100% ");
    }
    
    private void doClearRoads() {
	builder.selectActorsClear();
	builder.setSelected(null);
	Landscape landscape = World.land();
	if (landscape != null) {
	    /* empty */
	}
	int i = Landscape.getSizeXpix();
	if (landscape != null) {
	    /* empty */
	}
	int i_379_ = Landscape.getSizeYpix();
	for (int i_380_ = 1; i_380_ < i_379_ - 1; i_380_++) {
	    for (int i_381_ = 1; i_381_ < i - 1; i_381_++) {
		int i_382_ = i_379_ - 1 - i_380_;
		int i_383_ = landMapT.intI(i_381_, i_382_) & 0xe0;
		if (i_383_ != 0) {
		    tryClearRoads(i_383_, i_381_, i_380_, -1, 1, i_379_);
		    tryClearRoads(i_383_, i_381_, i_380_, 0, 1, i_379_);
		    tryClearRoads(i_383_, i_381_, i_380_, 1, 1, i_379_);
		    tryClearRoads(i_383_, i_381_, i_380_, 1, 0, i_379_);
		}
	    }
	    if (i_380_ % 5 == 0) {
		int i_384_ = i_380_ * 100 / i_379_;
		RTSConf.cur.mainWindow.setTitle("" + i_384_ + "%");
	    }
	}
	RTSConf.cur.mainWindow.setTitle("100% ");
    }
    
    private void tryClearRoads(int i, int i_385_, int i_386_, int i_387_,
			       int i_388_, int i_389_) {
	int i_390_ = i_389_ - 1 - i_386_ - i_388_;
	if ((landMapT.intI(i_385_ + i_387_, i_390_) & 0xe0 & i) != 0) {
	    _clearRoadP0.x = (double) ((float) i_385_ * 200.0F + 100.0F);
	    _clearRoadP0.y = (double) ((float) (i_386_ - 1) * 200.0F + 100.0F);
	    _clearRoadP0.z
		= World.land().HQ(_clearRoadP0.x, _clearRoadP0.y) + 1.0;
	    _clearRoadP1.x
		= (double) ((float) (i_385_ + i_387_) * 200.0F + 100.0F);
	    _clearRoadP1.y
		= (double) ((float) (i_386_ - 1 + i_388_) * 200.0F + 100.0F);
	    _clearRoadP1.z
		= World.land().HQ(_clearRoadP1.x, _clearRoadP1.y) + 1.0;
	    Engine.drawEnv().getFiltered(_clearRoadArray,
					 _clearRoadP0.x - 100.0,
					 _clearRoadP0.y - 100.0,
					 _clearRoadP0.x + 100.0,
					 _clearRoadP0.y + 100.0, 15,
					 _clearRoadFilter);
	    Engine.drawEnv().getFiltered(_clearRoadArray,
					 _clearRoadP1.x - 100.0,
					 _clearRoadP1.y - 100.0,
					 _clearRoadP1.x + 100.0,
					 _clearRoadP1.y + 100.0, 15,
					 _clearRoadFilter);
	    if (_clearRoadArray.size() != 0) {
		for (int i_391_ = 0; i_391_ < _clearRoadArray.size();
		     i_391_++) {
		    Actor actor = (Actor) _clearRoadArray.get(i_391_);
		    if (allActors.containsKey(actor)
			&& actor instanceof ActorMesh) {
			Point3d point3d = actor.pos.getAbsPoint();
			Mesh mesh = ((ActorMesh) actor).mesh();
			double d = 0.0;
			if (mesh instanceof HierMesh) {
			    d = (double) (((ActorMesh) actor).mesh()
					      .visibilityR()
					  + 2.0F);
			    d *= d;
			} else {
			    mesh.getBoundBox(_clearRoadBound);
			    double d_392_
				= (double) (Math.max(Math.abs(_clearRoadBound
							      [0]),
						     Math.abs(_clearRoadBound
							      [3]))
					    + 2.0F);
			    double d_393_
				= (double) (Math.max(Math.abs(_clearRoadBound
							      [1]),
						     Math.abs(_clearRoadBound
							      [4]))
					    + 2.0F);
			    d = d_392_ * d_392_ + d_393_ * d_393_;
			}
			if (intersectLineSphere(_clearRoadP0.x, _clearRoadP0.y,
						_clearRoadP1.x, _clearRoadP1.y,
						point3d.x, point3d.y, d)
			    >= 0.0) {
			    allActors.remove(actor);
			    actor.destroy();
			}
		    }
		}
		_clearRoadArray.clear();
	    }
	}
    }
    
    private double intersectLineSphere(double d, double d_394_, double d_395_,
				       double d_396_, double d_397_,
				       double d_398_, double d_399_) {
	double d_400_ = d_395_ - d;
	double d_401_ = d_396_ - d_394_;
	double d_402_ = d_400_ * d_400_ + d_401_ * d_401_;
	if (d_402_ < 1.0E-6) {
	    if (d_399_ >= ((d - d_397_) * (d - d_397_)
			   + (d_394_ - d_398_) * (d_394_ - d_398_)))
		return 0.0;
	    return -1.0;
	}
	double d_403_
	    = ((d_397_ - d) * d_400_ + (d_398_ - d_394_) * d_401_) / d_402_;
	if (d_403_ >= 0.0 && d_403_ <= 1.0) {
	    double d_404_ = d + d_403_ * d_400_;
	    double d_405_ = d_394_ + d_403_ * d_401_;
	    double d_406_ = ((d_404_ - d_397_) * (d_404_ - d_397_)
			     + (d_405_ - d_398_) * (d_405_ - d_398_));
	    double d_407_ = d_399_ - d_406_;
	    if (d_407_ < 0.0)
		return -1.0;
	    if (d_403_ < 0.0)
		d_403_ = 0.0;
	    return d_403_;
	}
	double d_408_ = ((d_395_ - d_397_) * (d_395_ - d_397_)
			 + (d_396_ - d_398_) * (d_396_ - d_398_));
	double d_409_ = ((d - d_397_) * (d - d_397_)
			 + (d_394_ - d_398_) * (d_394_ - d_398_));
	if (d_408_ <= d_399_ || d_409_ <= d_399_) {
	    if (d_408_ < d_409_)
		return 1.0;
	    return 0.0;
	}
	return -1.0;
    }
    
    private void doInsertPattern(GWindow gwindow) {
	int i = builder.wSelect_st.comboBox2.getSelected();
	int i_410_ = tileType(i);
	if (i_410_ == -1)
	    System.out.println("Unknown type of ladscape");
	else {
	    _changedPatternType = i_410_;
	    if (dlgLoadPattern == null)
		dlgLoadPattern = new GWindowFileOpen(gwindow, true,
						     "Load Pattern ...",
						     "maps",
						     (new GFileFilter[]
						      { new GFileFilterName
							("All files",
							 (new String[]
							  { "*" })) })) {
		    public void result(String string) {
			if (string != null)
			    PlMapActors.this.changePattern(true,
							   "maps/" + string);
		    }
		};
	    else
		dlgLoadPattern.activateWindow();
	}
    }
    
    private void doRemovePattern(GWindow gwindow) {
	int i = builder.wSelect_st.comboBox2.getSelected();
	int i_414_ = tileType(i);
	if (i_414_ == -1)
	    System.out.println("Unknown type of ladscape");
	else {
	    _changedPatternType = i_414_;
	    if (dlgRemovePattern == null)
		dlgRemovePattern = new GWindowFileOpen(gwindow, true,
						       "Load Pattern ...",
						       "maps",
						       (new GFileFilter[]
							{ new GFileFilterName
							  ("All files",
							   (new String[]
							    { "*" })) })) {
		    public void result(String string) {
			if (string != null)
			    PlMapActors.this.changePattern(false,
							   "maps/" + string);
		    }
		};
	    else
		dlgRemovePattern.activateWindow();
	}
    }
    
    private int changeOnePattern(ArrayList arraylist, boolean bool, int i,
				 int i_418_, int i_419_) {
	int i_420_ = 0;
	int i_421_ = arraylist.size();
	_changeOffsetXY.x = (float) PIXEL * (float) i;
	_changeOffsetXY.y = (float) PIXEL * (float) (i_418_ - 1);
	for (int i_422_ = 0; i_422_ < i_421_; i_422_++) {
	    ItemPattern itempattern = (ItemPattern) arraylist.get(i_422_);
	    if (i_419_ == 0) {
		if ((double) itempattern.x < PIXELD2
		    || (double) itempattern.y < PIXELD2)
		    continue;
	    } else if (i_419_ == 1) {
		if ((double) itempattern.x > PIXELD2
		    || (double) itempattern.y < PIXELD2)
		    continue;
	    } else if (i_419_ == 2) {
		if ((double) itempattern.x < PIXELD2
		    || (double) itempattern.y > PIXELD2)
		    continue;
	    } else if (i_419_ == 3 && ((double) itempattern.x > PIXELD2
				       || (double) itempattern.y > PIXELD2))
		continue;
	    if (bool) {
		_changeLoc.set((double) (itempattern.x + _changeOffsetXY.x),
			       (double) (itempattern.y + _changeOffsetXY.y),
			       0.0, itempattern.getAzimut(), 0.0F, 0.0F);
		insertt(itempattern.spawn, _changeLoc, false);
		i_420_++;
	    } else {
		Actor actor = findParrtenActor(itempattern, _changeOffsetXY);
		if (actor != null) {
		    allActors.remove(actor);
		    actor.destroy();
		    i_420_++;
		}
	    }
	}
	return i_420_;
    }
    
    private void changePattern(boolean bool, String string) {
	int i = 0;
	builder.selectActorsClear();
	builder.setSelected(null);
	ArrayList[][] arraylists = new ArrayList[TILE][TILE];
	loadPattern(string, arraylists);
	Landscape landscape = World.land();
	if (landscape != null) {
	    /* empty */
	}
	int i_423_ = Landscape.getSizeXpix();
	if (landscape != null) {
	    /* empty */
	}
	int i_424_ = Landscape.getSizeYpix();
	for (int i_425_ = 1; i_425_ < i_424_ - 1; i_425_++) {
	    for (int i_426_ = 1; i_426_ < i_423_ - 1; i_426_++) {
		int i_427_ = i_424_ - 1 - i_425_;
		if (landscape != null) {
		    /* empty */
		}
		int i_428_ = Landscape.getPixelMapT(i_426_, i_427_) & 0x1f;
		if (i_428_ == _changedPatternType) {
		    ArrayList arraylist = (arraylists[i_425_ & TILEMASK]
					   [i_426_ + TILE - 1 & TILEMASK]);
		    if (arraylist != null && arraylist.size() > 0)
			i += changeOnePattern(arraylist, bool, i_426_ - 1,
					      i_425_, 0);
		    arraylist
			= arraylists[i_425_ & TILEMASK][i_426_ & TILEMASK];
		    if (arraylist != null && arraylist.size() > 0)
			i += changeOnePattern(arraylist, bool, i_426_, i_425_,
					      1);
		    arraylist = (arraylists[i_425_ + 1 & TILEMASK]
				 [i_426_ + TILE - 1 & TILEMASK]);
		    if (arraylist != null && arraylist.size() > 0)
			i += changeOnePattern(arraylist, bool, i_426_ - 1,
					      i_425_ + 1, 2);
		    arraylist
			= arraylists[i_425_ + 1 & TILEMASK][i_426_ & TILEMASK];
		    if (arraylist != null && arraylist.size() > 0)
			i += changeOnePattern(arraylist, bool, i_426_,
					      i_425_ + 1, 3);
		}
	    }
	    if (i_425_ % 5 == 0) {
		int i_429_ = i_425_ * 100 / i_424_;
		RTSConf.cur.mainWindow.setTitle("" + i_429_ + "% " + i);
	    }
	}
	RTSConf.cur.mainWindow.setTitle("100% " + i);
	Object object = null;
	String string_430_;
	if (bool)
	    string_430_ = " " + i + " pattern objects inserted as static";
	else
	    string_430_ = " " + i + " pattern objects removed from static";
	System.out.println(string_430_);
	builder.tip(string_430_);
    }
    
    public Actor findParrtenActor(ItemPattern itempattern, Point3f point3f) {
	double d = (double) (itempattern.x + point3f.x);
	double d_431_ = (double) (itempattern.y + point3f.y);
	for (Map.Entry entry = allActors.nextEntry(null); entry != null;
	     entry = allActors.nextEntry(entry)) {
	    Actor actor = (Actor) entry.getKey();
	    if (Actor.isValid(actor)) {
		double d_432_ = actor.pos.getAbsPoint().x;
		double d_433_ = actor.pos.getAbsPoint().y;
		double d_434_ = ((d - d_432_) * (d - d_432_)
				 + (d_431_ - d_433_) * (d_431_ - d_433_));
		if (d_434_ < 1.0
		    && getFingerOfFullClassName(actor) == itempattern.finger)
		    return actor;
	    }
	}
	return null;
    }
    
    private void loadPattern(String string, ArrayList[][] arraylists) {
	try {
	    DataInputStream datainputstream
		= new DataInputStream(new SFSInputStream(string));
	    System.out.println("Read pattern objects ...");
	    boolean bool = true;
	    int i = datainputstream.readInt();
	    if (i == -655535) {
		bool = false;
		i = datainputstream.readInt();
	    }
	    boolean bool_435_ = false;
	    int i_436_ = 0;
	    int i_437_;
	    if (bool) {
		for (int i_438_ = 0; i_438_ < i; i_438_++) {
		    datainputstream.readInt();
		    datainputstream.readInt();
		    datainputstream.readInt();
		    datainputstream.readInt();
		    datainputstream.readInt();
		    datainputstream.readFloat();
		}
		i = datainputstream.readInt();
		i_437_ = i;
		if (i > 0) {
		    while (i-- > 0) {
			String string_439_ = datainputstream.readUTF();
			Spawn.get_WithSoftClass(string_439_);
		    }
		    i = datainputstream.readInt();
		    i_436_ = i;
		    while (i-- > 0) {
			int i_440_ = datainputstream.readInt();
			float f = datainputstream.readFloat();
			float f_441_ = datainputstream.readFloat();
			float f_442_ = datainputstream.readFloat();
			float f_443_ = datainputstream.readFloat();
			float f_444_ = datainputstream.readFloat();
			float f_445_ = datainputstream.readFloat();
			addPattern(i_440_, f, f_441_, f_443_, arraylists);
		    }
		}
	    } else {
		i = datainputstream.readInt();
		i_437_ = i;
		Object object = null;
		if (i > 0) {
		    int[] is = new int[i];
		    for (int i_446_ = 0; i_446_ < i; i_446_++) {
			String string_447_ = datainputstream.readUTF();
			is[i_446_] = Finger.Int(string_447_);
			Spawn.get_WithSoftClass(string_447_);
		    }
		    i = datainputstream.readInt();
		    i_436_ = i;
		    while (i-- > 0) {
			int i_448_ = datainputstream.readInt();
			float f = datainputstream.readFloat();
			float f_449_ = datainputstream.readFloat();
			float f_450_ = datainputstream.readFloat();
			addPattern(is[i_448_], f, f_449_, f_450_, arraylists);
		    }
		}
		i = datainputstream.readInt();
		i_437_ += i;
		if (i > 0) {
		    int[] is = new int[i];
		    for (int i_451_ = 0; i_451_ < i; i_451_++) {
			String string_452_ = datainputstream.readUTF();
			is[i_451_] = Finger.Int(string_452_);
			Spawn.get_WithSoftClass(string_452_);
		    }
		    int i_453_ = datainputstream.readInt();
		    while (i_453_-- > 0) {
			int i_454_ = datainputstream.readInt();
			float f = (float) (i_454_ & 0xffff) * 200.0F;
			float f_455_
			    = (float) (i_454_ >> 16 & 0xffff) * 200.0F;
			int i_456_ = datainputstream.readInt();
			i_436_ += i;
			while (i_456_-- > 0) {
			    int i_457_ = datainputstream.readInt();
			    int i_458_ = datainputstream.readInt();
			    int i_459_ = i_457_ & 0x7fff;
			    if (i_459_ < is.length && is[i_459_] != 0) {
				short i_460_ = (short) (i_457_ >> 16);
				short i_461_ = (short) (i_458_ & 0xffff);
				short i_462_ = (short) (i_458_ >> 16 & 0xffff);
				float f_463_
				    = (float) i_460_ * 360.0F / 32000.0F;
				float f_464_
				    = (float) i_461_ * 200.0F / 32000.0F + f;
				float f_465_
				    = ((float) i_462_ * 200.0F / 32000.0F
				       + f_455_);
				addPattern(is[i_459_], f_464_, f_465_, -f_463_,
					   arraylists);
			    }
			}
		    }
		}
	    }
	    datainputstream.close();
	    System.out.println("" + i_437_ + " class " + i_436_
			       + " actors in pattern");
	} catch (Exception exception) {
	    String string_466_ = ("Pattern actors load from '" + string
				  + "' FAILED: " + exception.getMessage());
	    System.out.println(string_466_);
	    exception.printStackTrace();
	}
    }
    
    private void addPattern(int i, float f, float f_467_, float f_468_,
			    ArrayList[][] arraylists) {
	f_467_ += PIXEL;
	double d = (double) f % QUAD;
	double d_469_ = (double) f_467_ % QUAD;
	int i_470_ = (int) (d / PIXEL);
	int i_471_ = (int) (d_469_ / PIXEL);
	if (arraylists[i_471_][i_470_] == null)
	    arraylists[i_471_][i_470_] = new ArrayList();
	arraylists[i_471_][i_470_].add(new ItemPattern(i, (float) (d % PIXEL),
						       (float) (d_469_
								% PIXEL),
						       f_468_));
    }
    
    public void freeResources() {
	dlgPasteFrom = null;
	dlgLoadAs = null;
	dlgLoadSpawn = null;
	dlgLoadPattern = null;
	dlgRemovePattern = null;
	dlgSaveAs = null;
	dlgSaveSpawn = null;
    }
    
    /*synthetic*/ static int access$2308(PlMapActors plmapactors) {
	return plmapactors.fillHeight++;
    }
    
    /*synthetic*/ static int access$2310(PlMapActors plmapactors) {
	return plmapactors.fillHeight--;
    }
    
    /*synthetic*/ static int access$2312(PlMapActors plmapactors, int i) {
	return plmapactors.fillHeight += i;
    }
    
    /*synthetic*/ static int access$2320(PlMapActors plmapactors, int i) {
	return plmapactors.fillHeight -= i;
    }
    
    /*synthetic*/ static Class class$(String string) {
	Class var_class;
	try {
	    var_class = Class.forName(string);
	} catch (ClassNotFoundException classnotfoundexception) {
	    throw new NoClassDefFoundError(classnotfoundexception
					       .getMessage());
	}
	return var_class;
    }
    
    static {
	Property.set((class$com$maddox$il2$builder$PlMapActors == null
		      ? (class$com$maddox$il2$builder$PlMapActors
			 = class$("com.maddox.il2.builder.PlMapActors"))
		      : class$com$maddox$il2$builder$PlMapActors),
		     "name", "MapActors");
    }
}
