
#if !defined (_ACTORS_IO_H_)
#define _ACTORS_IO_H_

extern "C"
{


bool __stdcall CreateEmptyActors(
		unsigned long *hpActors,	// create new or clear existing
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioCreateEmptyActorsFunc)(
		unsigned long *hpActors, unsigned long *ulpErrCode);


bool __stdcall LoadActors(
		unsigned long *hpActors,	// clear existing or create new
		char *sFileName,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioLoadActorsFunc)(
		unsigned long *hpActors, char *sFileName,
		unsigned long *ulpErrCode);


bool __stdcall SaveActors(
		unsigned long *hpActors,
		char *sFileName,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioSaveActorsFunc)(
		unsigned long *hpActors, char *sFileName,
		unsigned long *ulpErrCode);


bool __stdcall LoadActorsFromMission(
		unsigned long *hpActors,	// clear existing or create new
		char *sFileName,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioLoadActorsFromMissionFunc)(
		unsigned long *hpActors, char *sFileName,
		unsigned long *ulpErrCode);


bool __stdcall SaveActorsAsMission(
		unsigned long *hpActors,
		char *sFileName,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioSaveActorsAsMissionFunc)(
		unsigned long *hpActors, char *sFileName,
		unsigned long *ulpErrCode);


bool __stdcall CloseActors(
		unsigned long *hpActors,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioCloseActorsFunc)(
		unsigned long *hpActors, unsigned long *ulpErrCode);


bool __stdcall CloseAllActors(
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioCloseAllActorsFunc)(
		unsigned long *ulpErrCode);



// MapHeight must be defined if needed Bridges coordinates conversion
//  between Actors and Mission scales, i.e. if you use functions:
//  LoadActorsFromMission(), SaveActorsAsMission(),
//  Get/Add/ReplaceActorsObject(AIO_CNT_BRIDGES) or Split/MergeActors()

bool __stdcall SetActorsMapHeight(
		unsigned long *hpActors,
		unsigned long ulMapHeight,	// in meters, i.e. ( Height of map_t.tga ) * 200
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioSetActorsMapHeightFunc)(
		unsigned long *hpActors, unsigned long ulMapHeight,
		unsigned long *ulpErrCode);



bool __stdcall AllocateActorsObject(
		unsigned long *hpActors,	// pass Actors handle if you want to automatically
									//  deallocate this object when Actors will be closed,
									// or pass the null pointer and you must deallocate
									//  them manually by FreeActorsObject call
									//  or by FreeAllActorsObjects call
		unsigned long *hpObject,	// creates new or reallocate existing
		unsigned char ucStructType,
		unsigned long ulElementsCount, // string length or points count
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioAllocateActorsObjectFunc)(
		unsigned long *hpActors, unsigned long *hpObject,
		unsigned char ucStructType, unsigned long ulElementsCount,
		unsigned long *ulpErrCode);


bool __stdcall FreeActorsObject(
		unsigned long *hpObject,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioFreeActorsObjectFunc)(
		unsigned long *hpObject, unsigned long *ulpErrCode);


bool __stdcall FreeAllActorsObjects(
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioFreeAllActorsObjectsFunc)(
		unsigned long *ulpErrCode);



// objects, created by GetObject... automatically deallocates on CloseActors call
//   or you may manually deallocate these objects by FreeActorsObject call
		

unsigned long __stdcall GetActorsObjectsCount(
		unsigned long *hpActors,
		unsigned char ucContainerId,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);
		
typedef unsigned long (__stdcall *TAioGetActorsObjectsCountFunc)(
		unsigned long *hpActors, unsigned char ucContainerId,
		unsigned long *ulpErrCode);
		

bool __stdcall GetActorsObject(
		unsigned long *hpActors,
		unsigned long *hpObject,	// creates new or reallocate existing
		unsigned char ucContainerId,
		unsigned long ulObjectIdx,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioGetActorsObjectFunc)(
		unsigned long *hpActors, unsigned long *hpObject,
		unsigned char ucContainerId, unsigned long ulObjectIdx,
		unsigned long *ulpErrCode);


bool __stdcall AddActorsObject( // to the end of container
		unsigned long *hpActors,
		unsigned long *hpObject,
		unsigned char ucContainerId,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioAddActorsObjectFunc)(
		unsigned long *hpActors, unsigned long *hpObject,
		unsigned char ucContainerId, unsigned long *ulpErrCode);


bool __stdcall ReplaceActorsObject(
		unsigned long *hpActors,
		unsigned long *hpObject,
		unsigned char ucContainerId,
		unsigned long ulObjectIdx,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioReplaceActorsObjectFunc)(
		unsigned long *hpActors, unsigned long *hpObject,
		unsigned char ucContainerId, unsigned long ulObjectIdx,
		unsigned long *ulpErrCode);


bool __stdcall RemoveActorsObject(
		unsigned long *hpActors,
		unsigned char ucContainerId,
		unsigned long ulObjectIdx,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioRemoveActorsObjectFunc)(
		unsigned long *hpActors, unsigned char ucContainerId,
		unsigned long ulObjectIdx, unsigned long *ulpErrCode);


bool __stdcall RemoveAllActorsObjects(
		unsigned long *hpActors,
		unsigned char ucContainerIds,// combined by binary OR
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioRemoveAllActorsObjectsFunc)(
		unsigned long *hpActors, unsigned char ucContainerIds,
		unsigned long *ulpErrCode);



// Nonstandard mapping needed for LoadActorsFromMission(), SaveActorsAsMission() and you
//  have nonstandad objects in Objects (container AIO_CNT_OBJECTS) and Buildings
//  (container AIO_CNT_BUILDINGS) parts of actors.static file
// Standard objects for Objects container is:
//  "com.maddox.il2.objects.air.Runaway" (mapped to "vehicles.planes.Plane$BI_1" static)
//  "com.maddox.il2.objects.buildings.Mountain$Suribachi" (mapped to "vehicles.planes.Plane$C_47" static)
// Standard objects for Buildings container is "com.maddox.il2.objects.buildings.<SomeName>",
//  mapping to statics absent, that objects mapped to [Buildings] section of mission file
//  with names <SomeName>

bool __stdcall GetActorsObjectsMapping(
		unsigned long *hpActors,
		unsigned long *hpMapping,	// creates new or reallocate existing ( hpObject )
		bool fUnmappedOnly,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioGetActorsObjectsMappingFunc)(
		unsigned long *hpActors, unsigned long *hpMapping,
		bool fUnmappedOnly, unsigned long *ulpErrCode);


bool __stdcall SetActorsObjectMapping(
		unsigned long *hpActors,
		unsigned char ucContainerId, // AIO_CNT_BUILDINGS or AIO_CNT_OBJECTS
		char *sObjTypeName,
		char *sStaticTypeName,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);
// You may pass ContainerId = 0 and ObjTypeName = "" (empty string) or
//  StaticTypeName = "" (empty string) to remove previously set mapping
// Changing of Standard mappings is not supported

typedef bool (__stdcall *TAioSetActorsObjectMappingFunc)(
		unsigned long *hpActors, unsigned char ucContainerId,
		char *sObjTypeName, char *sStaticTypeName,
		unsigned long *ulpErrCode);


bool __stdcall ResetActorsObjectsMapping(
		unsigned long *hpActors,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioResetActorsObjectsMappingFunc)(
		unsigned long *hpActors, unsigned long *ulpErrCode);


bool __stdcall SplitActors(
		unsigned long *hpActors,
		unsigned long *hpActorsPart,// clear existing or create new
		unsigned long *hpActorsRest,// clear existing or create new,
									//  pass null pointer if not needed
									//  (for example if fCutObjects is true)
		bool fCutObjects,			// remove selected objects from hpActors
		unsigned char ucContainerIds,// combined by binary OR
		float dFirstCornerX,	//
		float dFirstCornerY,	// pass very large values for including whole map,
		float dSecondCornerX,	//  for example first = -1.0e+30 and second = 1.0e+30
		float dSecondCornerY,	//
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioSplitActorsFunc)(
		unsigned long *hpActors, unsigned long *hpActorsPart,
		unsigned long *hpActorsRest, bool fCutObjects, unsigned char ucContainerIds, 
		float dFirstCornerX, float dFirstCornerY,
		float dSecondCornerX, float dSecondCornerY,
		unsigned long *ulpErrCode);


bool __stdcall MergeActors(
		unsigned long *hpMainActors,
		unsigned long *hpActorsToAdd,
		bool fCutObjects,		// remove selected objects from hpActorsToAdd
		unsigned char ucContainerIds,// combined by binary OR
		float dFirstCornerX,	//
		float dFirstCornerY,	// pass very large values for including whole map,
		float dSecondCornerX,	//  for example first = -1.0e+30 and second = 1.0e+30
		float dSecondCornerY,	//
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioMergeActorsFunc)(
		unsigned long *hpMainActors, unsigned long *hpActorsToAdd,
		bool fCutObjects, unsigned char ucContainerIds,
		float dFirstCornerX, float dFirstCornerY,
		float dSecondCornerX, float dSecondCornerY,
		unsigned long *ulpErrCode);



bool __stdcall ShiftActorsObjects(
		unsigned long *hpActors,
		unsigned char ucContainerIds,// combined by binary OR
		float dXOffset,
		float dYOffset,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef bool (__stdcall *TAioShiftActorsObjectsFunc)(
		unsigned long *hpActors, unsigned char ucContainerIds,
		float dXOffset, float dYOffset, unsigned long *ulpErrCode);


// Updates only after Load() or LoadFromMission() calls
char * __stdcall GetLastErrorText(
		unsigned long *hpActors,
		unsigned long *ulpErrCode	// optional, pass null pointer if not interesting
	);

typedef char * (__stdcall *TAioGetLastErrorTextFunc)(
		unsigned long *hpActors, unsigned long *ulpErrCode);


}; // extern "C"


enum EAioErrorCodeFlags
{
	AIO_SUCCESS					= 0x00000000,

	AIO_INVALID_ARGUMENTS		= 0x00000001,
	AIO_INVALID_ACTORS_HANDLE	= 0x00000002,
	AIO_INVALID_OBJECT_HANDLE	= 0x00000004,
	AIO_INVALID_FILE_FORMAT		= 0x00000008,
	AIO_OBJECTS_MAPPING_ERROR	= 0x00000010,
	AIO_INVALID_BRIDGE_PARAMS	= 0x00000020,
	AIO_FILE_OPERATION_ERROR	= 0x00000040,
	AIO_NOT_ENOUGHT_MEMORY		= 0x00000080,
	AIO_INTERNAL_ERROR			= 0x00000100,
	AIO_ANY_ERROR				= 0x000001ff
};

enum EAioContainerIds
{
	AIO_CNT_BUILDINGS		= 1, // usually contain "com.maddox.il2.objects.buildings..." objects
	AIO_CNT_OBJECTS			= 2, // usually contain "com.maddox.il2.objects.air.Runaway" objects
	AIO_CNT_AIRFIELD_WAYS	= 4,
	AIO_CNT_BRIDGES			= 8,
	AIO_CNT_ALL_COMMON		= 15, // i.e. ( 1 | 2 | 4 | 8 )
	AIO_CNT_BRIDGES_NATIVE	= 16
};

enum EAioStructureTypes
{
	AIO_STP_OBJECT			= 1, // contained in AIO_CNT_BUILDINGS and AIO_CNT_OBJECTS
	AIO_STP_AIRFIELD_WAY	= 2, // contained in AIO_CNT_AIRFIELD_WAYS
	AIO_STP_BRIDGE			= 3, // contained in AIO_CNT_BRIDGES
	AIO_STP_BRIDGE_NATIVE	= 4, // contained in AIO_CNT_BRIDGES_NATIVE
	AIO_STP_OBJECTS_MAPPING	= 5
};

// AIO_CNT_BRIDGES_NATIVE - same container with AIO_CNT_BRIDGES, but with another interface
//  structure ( SAioBridgeNative )

enum EAioBridgeTypes
{
	AIO_ROAD_BRIDGE		= 1,
	AIO_HIGHWAY_BRIDGE	= 2,
	AIO_RAILWAY_BRIDGE	= 3
};

enum EAioAirfieldWayTypes
{
	AIO_RUNAWAY_POINTS	= 1,
	AIO_TAXI_POINTS		= 2,
	AIO_PARKING_POINTS	= 3
};

enum EAioNativeBridgeColors
{
	AIO_ROAD_COLOR		= 32,
	AIO_HIGHWAY_COLOR	= 128,
	AIO_RAILWAY_COLOR	= 64
};


#pragma pack(push, 1)


typedef struct _SAioCommonHeader {
	unsigned long	_m_ulAllocatedSize;	// DONT change this member !
	unsigned char	_m_ucStructType;	// DONT change this member !
} SAioCommonHeader;


typedef struct _SAioObject {
	unsigned long	_m_ulAllocatedSize;	// DONT change this member !
	unsigned char	_m_ucStructType;	// AIO_STP_OBJECT , DONT change this member !

	char		   *m_cpObjTypeName;
	double			m_dX; // in AIO_CNT_OBJECTS reduced to float
	double			m_dY; // in AIO_CNT_OBJECTS reduced to float
	float			m_dAngle;

	unsigned long	m_ulMaxNameLength;	// DONT change this member !

} SAioObject;


typedef struct _SAioAirfieldPoint {
	float			m_dX;
	float			m_dY;
} SAioAirfieldPoint;

typedef struct _SAioAirfieldWay {
	unsigned long	_m_ulAllocatedSize;	// DONT change this member !
	unsigned char	_m_ucStructType;	// AIO_STP_AIRFIELD_WAY , DONT change this member !

	unsigned char		m_ucWayType;
	unsigned long		m_ulPointsCount;
	SAioAirfieldPoint  *m_opPoints;

	unsigned long	m_ulMaxPointsCount;	// DONT change this member !

} SAioAirfieldWay;


typedef struct _SAioBridge {
	unsigned long	_m_ulAllocatedSize;	// DONT change this member !
	unsigned char	_m_ucStructType;	// AIO_STP_BRIDGE , DONT change this member !

	unsigned char	m_ucBridgeType;
	double			m_dFirstX;
	double			m_dFirstY;
	double			m_dSecondX;
	double			m_dSecondY;

} SAioBridge;


typedef struct _SAioBridgeNative {
	unsigned long	_m_ulAllocatedSize;	// DONT change this member !
	unsigned char	_m_ucStructType;	// AIO_STP_BRIDGE_NATIVE , DONT change this member !

	unsigned char	m_ucColor;
	long			m_lFirstX;
	long			m_lFirstY;
	long			m_lSecondX;
	long			m_lSecondY;
	float			m_dShift;

} SAioBridgeNative;


typedef struct _SAioObjMapping {
	unsigned char	m_ucContainerId; // AIO_CNT_BUILDINGS or AIO_CNT_OBJECTS or 0 for unmapped
	char		   *m_cpObjTypeName;
	char		   *m_cpStaticTypeName;

} SAioObjMapping;

typedef struct _SAioObjectsMapping {
	unsigned long	_m_ulAllocatedSize;	// DONT change this member !
	unsigned char	_m_ucStructType;	// AIO_STP_OBJECTS_MAPPING , DONT change this member !

	unsigned long	m_ulObjectsCount;
	SAioObjMapping *m_opObjects;

} SAioObjectsMapping;


#pragma pack(pop)


#endif // #if !defined (_ACTORS_IO_H_)
