// SimpleCutter.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"


HMODULE g_hLibrary = 0;

TAioCreateEmptyActorsFunc		g_fnpCreateEmptyActors = 0;
TAioSetActorsMapHeightFunc		g_fnpSetActorsMapHeight = 0;
TAioLoadActorsFunc				g_fnpLoadActors = 0;
TAioSaveActorsFunc				g_fnpSaveActors = 0;
TAioLoadActorsFromMissionFunc	g_fnpLoadActorsFromMission = 0;
TAioSaveActorsAsMissionFunc		g_fnpSaveActorsAsMission = 0;
TAioCloseActorsFunc				g_fnpCloseActors = 0;
TAioCloseAllActorsFunc			g_fnpCloseAllActors = 0;

TAioSplitActorsFunc				g_fnpSplitActors = 0;
TAioMergeActorsFunc				g_fnpMergeActors = 0;
TAioShiftActorsObjectsFunc		g_fnpShiftActorsObjects = 0;

TAioFreeAllActorsObjectsFunc	g_fnpFreeAllActorsObjects = 0;

TAioGetActorsObjectsCountFunc	g_fnpGetActorsObjectsCount = 0;
TAioGetActorsObjectFunc			g_fnpGetActorsObject = 0;
TAioAddActorsObjectFunc			g_fnpAddActorsObject = 0;

TAioGetActorsObjectsMappingFunc	g_fnpGetActorsObjectsMapping = 0;

TAioGetLastErrorTextFunc		g_fnpGetLastErrorText = 0;

typedef struct _SConf
{
	string m_soInpFile;
	bool m_fInpFileMis;

	string m_soOutpFile;
	bool m_fOutpFileMis;

	string m_soAddFile;
	bool m_fAddFileMis;

	string m_soRestFile;
	bool m_fRestFileMis;

	unsigned long m_ulMapHeight;

	bool m_fCut;
	long m_lFirstX;
	long m_lFirstY;
	long m_lSecondX;
	long m_lSecondY;

	bool m_fCutBr;

	bool m_fCutAF;
	unsigned long m_ulAFDistance;

	bool m_fShift;
	long m_lXOffset;
	long m_lYOffset;

	void Clear()
		{	m_soInpFile.resize(0); m_fInpFileMis = false;
			m_soOutpFile.resize(0); m_fOutpFileMis = false;
			m_soAddFile.resize(0); m_fAddFileMis = false;
			m_soRestFile.resize(0); m_fRestFileMis = false;
			m_ulMapHeight = 0; m_fCut = false;
			m_lFirstX = m_lFirstY = m_lSecondX = m_lSecondY = 0;
			m_fCutBr = false; m_fCutAF = false; m_ulAFDistance = 0;
			m_fShift = false; m_lXOffset = 0; m_lYOffset = 0;
		};

} SConf;

int PrintUsage(const char *c_sArgV0);

inline long Round(const float c_dValue)
	{ return (long)( c_dValue + ( 0.0 <= c_dValue ? 0.5 : -0.5 ) ); };

bool PrepareLibrary();

bool GetFileType(const char *c_sFileName, bool &frIsMis);
bool GetLong(const char *c_sParm, long &lrValue, const bool c_fUnsigned);

void Process(const SConf &c_orConf);

int main(int argc, char* argv[])
{
	if (! PrepareLibrary())
	{
		printf("Library ActorsIO.dll not found or invalid\n");
		return -1;
	}
	
	if (5 > argc)
		return PrintUsage(argv[0]);

	SConf oConf; oConf.Clear();
	
	int iCurrIdx = 1;
	while (argc > iCurrIdx)
	{
		if ( string("-inp") == argv[iCurrIdx] && argc > iCurrIdx + 1 )
		{
			iCurrIdx++;
			if (! GetFileType(argv[iCurrIdx], oConf.m_fInpFileMis))
				return PrintUsage(argv[0]);
			oConf.m_soInpFile = argv[iCurrIdx];
		}
		else if ( string("-outp") == argv[iCurrIdx] && argc > iCurrIdx + 1 )
		{
			iCurrIdx++;
			if (! GetFileType(argv[iCurrIdx], oConf.m_fOutpFileMis))
				return PrintUsage(argv[0]);
			oConf.m_soOutpFile = argv[iCurrIdx];
		}
		else if ( string("-add") == argv[iCurrIdx] && argc > iCurrIdx + 1 )
		{
			iCurrIdx++;
			if (! GetFileType(argv[iCurrIdx], oConf.m_fAddFileMis))
				return PrintUsage(argv[0]);
			oConf.m_soAddFile = argv[iCurrIdx];
		}
		else if ( string("-rest") == argv[iCurrIdx] && argc > iCurrIdx + 1 )
		{
			iCurrIdx++;
			if (! GetFileType(argv[iCurrIdx], oConf.m_fRestFileMis))
				return PrintUsage(argv[0]);
			oConf.m_soRestFile = argv[iCurrIdx];
		}
		else if ( string("-mh") == argv[iCurrIdx] && argc > iCurrIdx + 1 )
		{
			iCurrIdx++;
			if (! GetLong(argv[iCurrIdx], (long &)oConf.m_ulMapHeight, true))
				return PrintUsage(argv[0]);
		}
		else if ( string("-cut") == argv[iCurrIdx] && argc > iCurrIdx + 4 )
		{
			if ( ! GetLong(argv[iCurrIdx + 1], oConf.m_lFirstX, false)
				 || ! GetLong(argv[iCurrIdx + 2], oConf.m_lFirstY, false)
				 || ! GetLong(argv[iCurrIdx + 3], oConf.m_lSecondX, false)
				 || ! GetLong(argv[iCurrIdx + 4], oConf.m_lSecondY, false) )
				return PrintUsage(argv[0]);
			iCurrIdx += 4;
			oConf.m_fCut = true;
		}
		else if ( string("-cutaf") == argv[iCurrIdx] && argc > iCurrIdx + 1 )
		{
			iCurrIdx++;
			if (! GetLong(argv[iCurrIdx], (long &)oConf.m_ulAFDistance, true))
				return PrintUsage(argv[0]);
			oConf.m_fCutAF = true;
		}
		else if (string("-cutbr") == argv[iCurrIdx])
		{
			oConf.m_fCutBr = true;
		}
		else if ( string("-shift") == argv[iCurrIdx] && argc > iCurrIdx + 2 )
		{
			if ( ! GetLong(argv[iCurrIdx + 1], oConf.m_lXOffset, false)
				 || ! GetLong(argv[iCurrIdx + 2], oConf.m_lYOffset, false) )
				return PrintUsage(argv[0]);
			iCurrIdx += 2;
			if ( oConf.m_lXOffset || oConf.m_lYOffset )
				oConf.m_fShift = true;
		}
		else
			return PrintUsage(argv[0]);

		iCurrIdx++;
	}
	if ( ! oConf.m_soInpFile.size() || ! oConf.m_soOutpFile.size() )
		return PrintUsage(argv[0]);

	Process(oConf);

	g_fnpCloseAllActors(0);
	g_fnpFreeAllActorsObjects(0);

	FreeLibrary(g_hLibrary);

	return 0;
}

int PrintUsage(const char *c_sArgV0)
{
	string soAppName(c_sArgV0);
	long lPos = soAppName.rfind("\\");
	if (string::npos != lPos)
		soAppName = soAppName.substr(lPos + 1, soAppName.size() - 1 - lPos);

	printf("\n"
"Usage:\n\n"
"  %s -inp <inp file name> -outp <outp file name>\n"
"        [-mh <map height in meters>] [-add <file to add>]\n"
"        [-shift <X offeset> <Y offset>]\n"
"        [-cut <X1> <Y1> <X2> <Y2>] [-cutbr]\n"
"        [-cutaf <include distance in meters>]\n"
"        [-rest <outp rest file name>]\n"
"\n"
"   file name must have *.static or *.mis extension\n\n",
			soAppName.c_str());

	FreeLibrary(g_hLibrary);
	
	return -1;
}

typedef struct _SZone
{
	float m_dMinX;
	float m_dMinY;
	float m_dMaxX;
	float m_dMaxY;
} SZone;
typedef vector<SZone> TZones;

void AddZone(TZones &cntrZones, const float c_dX, const float c_dY, const float c_dDistance)
{
	{for (TZones::iterator it = cntrZones.begin(); cntrZones.end() != it; it++)
	{
		if ( c_dX + c_dDistance < it->m_dMinX || c_dX - c_dDistance > it->m_dMaxX
			 || c_dY + c_dDistance < it->m_dMinY || c_dY - c_dDistance > it->m_dMaxY )
			continue;

		if ( c_dX - c_dDistance < it->m_dMinX )
			it->m_dMinX = c_dX - c_dDistance;
		if ( c_dX + c_dDistance > it->m_dMaxX )
			it->m_dMaxX = c_dX + c_dDistance;

		if ( c_dY - c_dDistance < it->m_dMinY )
			it->m_dMinY = c_dY - c_dDistance;
		if ( c_dY + c_dDistance > it->m_dMaxY )
			it->m_dMaxY = c_dY + c_dDistance;

		return;
	}}

	SZone oZone;
	oZone.m_dMinX = c_dX - c_dDistance;
	oZone.m_dMaxX = c_dX + c_dDistance;
	oZone.m_dMinY = c_dY - c_dDistance;
	oZone.m_dMaxY = c_dY + c_dDistance;

	cntrZones.push_back(oZone);
}

void Process(const SConf &c_orConf)
{
	unsigned long ulInp = 0, ulOutp = 0, ulAdd = 0, ulRest = 0;

	printf("\nPreprocessing\n");
	if ( ! g_fnpCreateEmptyActors(&ulInp, 0)
			|| ! g_fnpSetActorsMapHeight(&ulInp, c_orConf.m_ulMapHeight, 0)
		 || ! g_fnpCreateEmptyActors(&ulOutp, 0)
			|| ! g_fnpSetActorsMapHeight(&ulOutp, c_orConf.m_ulMapHeight, 0)
		 || ! g_fnpCreateEmptyActors(&ulAdd, 0)
			|| ! g_fnpSetActorsMapHeight(&ulAdd, c_orConf.m_ulMapHeight, 0) 
		 || ! g_fnpCreateEmptyActors(&ulRest, 0)
			|| ! g_fnpSetActorsMapHeight(&ulRest, c_orConf.m_ulMapHeight, 0) )
	{
		printf("Can't initialize actors\n");
		return;
	}
	printf("Map Height set to %u\n", c_orConf.m_ulMapHeight);

	printf("Loading input file '%s'\n", c_orConf.m_soInpFile.c_str());
	if ( ! c_orConf.m_fInpFileMis
			&& ! g_fnpLoadActors(&ulInp, (char *)c_orConf.m_soInpFile.c_str(), 0)
		 || c_orConf.m_fInpFileMis
			&& ! g_fnpLoadActorsFromMission(&ulInp, (char *)c_orConf.m_soInpFile.c_str(), 0) )
	{
		char *cpText = g_fnpGetLastErrorText(&ulInp, 0);
		printf("Can't load input file '%s' , result:\n%s\n",
				c_orConf.m_soInpFile.c_str(), cpText);
		return;
	}

	if ( c_orConf.m_soAddFile.size() )
	{
		printf("Loading file '%s'\n", c_orConf.m_soAddFile.c_str());
		if ( ! c_orConf.m_fAddFileMis
				&& ! g_fnpLoadActors(&ulAdd, (char *)c_orConf.m_soAddFile.c_str(), 0)
			 || c_orConf.m_fAddFileMis
				&& ! g_fnpLoadActorsFromMission(&ulAdd, (char *)c_orConf.m_soAddFile.c_str(), 0) )
		{
			char *cpText = g_fnpGetLastErrorText(&ulAdd, 0);
			printf("Can't load file to add '%s' , result:\n%s\n",
					c_orConf.m_soAddFile.c_str(), cpText);
			return;
		}

		printf("Merging objects\n");
		if (! g_fnpMergeActors(&ulInp, &ulAdd, false, AIO_CNT_ALL_COMMON,
					(float)-1.0e+30, (float)-1.0e+30, (float)1.0e+30, (float)1.0e+30, 0))
		{
			printf("Can't add objects from file '%s'\n", c_orConf.m_soAddFile.c_str());
			return;
		}
	}

	if (c_orConf.m_fShift)
	{
		printf("Shiting objects to %i by X and %i by Y\n",
				c_orConf.m_lXOffset, c_orConf.m_lYOffset);
		if (! g_fnpShiftActorsObjects(&ulInp, AIO_CNT_ALL_COMMON,
					c_orConf.m_lXOffset, c_orConf.m_lYOffset, 0))
		{
			printf("Can't shit objects\n");
			return;
		}
	}
	
	if (c_orConf.m_fCut)
	{
		printf("Cutting zone ( %i , %i ) - ( %i , %i )\n",
				c_orConf.m_lFirstX, c_orConf.m_lFirstY,
				c_orConf.m_lSecondX, c_orConf.m_lSecondY);
		unsigned long ulPart = 0;
		if ( ! g_fnpSplitActors(&ulInp, &ulPart, &ulRest, false, AIO_CNT_ALL_COMMON,
					c_orConf.m_lFirstX, c_orConf.m_lFirstY,
					c_orConf.m_lSecondX, c_orConf.m_lSecondY, 0)
			 || ! g_fnpCreateEmptyActors(&ulInp, 0)
			 || ! g_fnpMergeActors(&ulInp, &ulPart, false, AIO_CNT_ALL_COMMON,
					(float)-1.0e+30, (float)-1.0e+30, (float)1.0e+30, (float)1.0e+30, 0) )
		{
			printf("Can't cut zone\n");
			return;
		}
		g_fnpCloseActors(&ulPart, 0);
	}

	if (c_orConf.m_fCutAF)
	{
		TZones cntZones;
		unsigned long ulObject = 0;

		printf("Prepearing Airfields zones\n");
		unsigned long ulCount = g_fnpGetActorsObjectsCount(&ulInp, AIO_CNT_OBJECTS, 0);
		{for (unsigned long ul = 0; ulCount > ul; ul++)
		{
			if (! g_fnpGetActorsObject(&ulInp, &ulObject, AIO_CNT_OBJECTS, ul, 0))
			{
				printf("Can't get airfield object\n");
				return;
			}
			SAioObject *opObject = (SAioObject *) ulObject;
			if (string(opObject->m_cpObjTypeName) != "com.maddox.il2.objects.air.Runaway")
				continue;

			AddZone(cntZones, opObject->m_dX, opObject->m_dY, c_orConf.m_ulAFDistance);

//			printf("\n ( %i , %i )\n", Round(opObject->m_dX), Round(opObject->m_dY));
//			{for(TZones::iterator it = cntZones.begin(); cntZones.end() != it; it++)
//			{
//				printf("zone ( %i , %i ) - ( %i , %i )\n",
//						Round(it->m_dMinX), Round(it->m_dMinY),
//						Round(it->m_dMaxX), Round(it->m_dMaxY));
//			}}
		}}
		ulCount = g_fnpGetActorsObjectsCount(&ulInp, AIO_CNT_AIRFIELD_WAYS, 0);
		{for (unsigned long ul = 0; ulCount > ul; ul++)
		{
			if (! g_fnpGetActorsObject(&ulInp, &ulObject, AIO_CNT_AIRFIELD_WAYS, ul, 0))
			{
				printf("Can't get airfield object\n");
				return;
			}
			SAioAirfieldWay *opWay = (SAioAirfieldWay *) ulObject;
			{for (unsigned long ulIdx = 0; opWay->m_ulPointsCount > ulIdx; ulIdx++)
			{
				AddZone(cntZones, opWay->m_opPoints[ulIdx].m_dX,
						opWay->m_opPoints[ulIdx].m_dY, c_orConf.m_ulAFDistance);

//				printf("\n ( %i , %i )\n", Round(opWay->m_opPoints[ulIdx].m_dX),
//						Round(opWay->m_opPoints[ulIdx].m_dY));
//				{for(TZones::iterator it = cntZones.begin(); cntZones.end() != it; it++)
//				{
//					printf("zone ( %i , %i ) - ( %i , %i )\n",
//							Round(it->m_dMinX), Round(it->m_dMinY),
//							Round(it->m_dMaxX), Round(it->m_dMaxY));
//				}}
			}}
		}}

		unsigned long ulAf = 0;
		{for(TZones::iterator it = cntZones.begin(); cntZones.end() != it; it++)
		{
			printf("Cutting Airfield zone ( %i , %i ) - ( %i , %i )\n",
					Round(it->m_dMinX), Round(it->m_dMinY),
					Round(it->m_dMaxX), Round(it->m_dMaxY));
			if ( ! g_fnpSplitActors(&ulInp, &ulAf, 0, true, AIO_CNT_ALL_COMMON,
					it->m_dMinX, it->m_dMinY, it->m_dMaxX, it->m_dMaxY, 0 )
				 || ! g_fnpMergeActors(&ulOutp, &ulAf, false, AIO_CNT_ALL_COMMON,
						(float)-1.0e+30, (float)-1.0e+30, (float)1.0e+30, (float)1.0e+30, 0) )
			{
				printf("Can't cut Airfield zone\n");
				return;
			}
		}}
		if (ulAf)
			g_fnpCloseActors(&ulAf, 0);
	}

	if (c_orConf.m_fCutBr)
	{
		printf("Cutting Bridges\n");
		unsigned long ulBridges = 0;
		if ( ! g_fnpSplitActors(&ulInp, &ulBridges, 0, true, AIO_CNT_BRIDGES,
					(float)-1.0e+30, (float)-1.0e+30, (float)1.0e+30, (float)1.0e+30, 0)
			 || ! g_fnpMergeActors(&ulOutp, &ulBridges, false, AIO_CNT_ALL_COMMON,
					(float)-1.0e+30, (float)-1.0e+30, (float)1.0e+30, (float)1.0e+30, 0) )
		{
			printf("Can't cut Bridges\n");
			return;
		}
		g_fnpCloseActors(&ulBridges, 0);
	}

	printf("Postprocessing\n");

	if ( c_orConf.m_fCutAF || c_orConf.m_fCutBr )
	{
		if ( c_orConf.m_soRestFile.size()
			 && ! g_fnpMergeActors(&ulRest, &ulInp, false, AIO_CNT_ALL_COMMON,
					(float)-1.0e+30, (float)-1.0e+30, (float)1.0e+30, (float)1.0e+30, 0) )
		{
			printf("Can't make rest actors\n");
			return;
		}
	}
	else
		ulOutp = ulInp;

	printf("Saving output file '%s'\n", c_orConf.m_soOutpFile.c_str());
	if ( ! c_orConf.m_fOutpFileMis
			&& ! g_fnpSaveActors(&ulOutp, (char *)c_orConf.m_soOutpFile.c_str(), 0)
		 || c_orConf.m_fOutpFileMis
			&& ! g_fnpSaveActorsAsMission(&ulOutp, (char *)c_orConf.m_soOutpFile.c_str(), 0) )
		printf("Can't save output file '%s'\n", c_orConf.m_soOutpFile.c_str());

	if (c_orConf.m_soRestFile.size())
	{
		printf("Saving rest file '%s'\n", c_orConf.m_soRestFile.c_str());
		if ( ! c_orConf.m_fRestFileMis
				&& ! g_fnpSaveActors(&ulRest, (char *)c_orConf.m_soRestFile.c_str(), 0)
			 || c_orConf.m_fRestFileMis
				&& ! g_fnpSaveActorsAsMission(&ulRest, (char *)c_orConf.m_soRestFile.c_str(), 0) )
			printf("Can't save rest file '%s'\n", c_orConf.m_soRestFile.c_str());
	}

	printf("Done\n");
}

bool GetFileType(const char *c_sFileName, bool &frIsMis)
{
	string soName(c_sFileName);
	long lPos = soName.find_last_of(".");
	if ( string::npos == lPos || soName.size() == lPos + 1 )
		return false;

	soName = soName.substr(lPos + 1, soName.size() - lPos - 1);
	if ("static" == soName)
		frIsMis = false;
	else if ( "mis" == soName || "txt" == soName )
		frIsMis = true;
	else
		return false;

	return true;
}

bool GetLong(const char *c_sParm, long &lrValue, const bool c_fUnsigned)
{
	lrValue = atoi(c_sParm);
	
	char caTmp[16];
	sprintf(caTmp, c_fUnsigned ? "%u" : "%i", lrValue);
	if (string(caTmp) != c_sParm)
		return false;

	return true;
}

bool PrepareLibrary()
{
	if (! (g_hLibrary = LoadLibrary("ActorsIO.dll")))
		return false;

	if ( ! (g_fnpCreateEmptyActors
				= (TAioCreateEmptyActorsFunc)GetProcAddress(g_hLibrary, "CreateEmptyActors"))
		 || ! (g_fnpSetActorsMapHeight
				= (TAioSetActorsMapHeightFunc)GetProcAddress(g_hLibrary, "SetActorsMapHeight"))
		 || ! (g_fnpLoadActors
				= (TAioLoadActorsFunc)GetProcAddress(g_hLibrary, "LoadActors"))
		 || ! (g_fnpSaveActors
				= (TAioSaveActorsFunc)GetProcAddress(g_hLibrary, "SaveActors"))
		 || ! (g_fnpLoadActorsFromMission
				= (TAioLoadActorsFromMissionFunc)GetProcAddress(g_hLibrary, "LoadActorsFromMission"))
		 || ! (g_fnpSaveActorsAsMission
				= (TAioSaveActorsAsMissionFunc)GetProcAddress(g_hLibrary, "SaveActorsAsMission"))
		 || ! (g_fnpCloseActors
				= (TAioCloseActorsFunc)GetProcAddress(g_hLibrary, "CloseActors"))
		 || ! (g_fnpCloseAllActors
				= (TAioCloseAllActorsFunc)GetProcAddress(g_hLibrary, "CloseAllActors"))

		 || ! (g_fnpSplitActors
				= (TAioSplitActorsFunc)GetProcAddress(g_hLibrary, "SplitActors"))
		 || ! (g_fnpMergeActors
				= (TAioMergeActorsFunc)GetProcAddress(g_hLibrary, "MergeActors"))
		 || ! (g_fnpShiftActorsObjects
				= (TAioShiftActorsObjectsFunc)GetProcAddress(g_hLibrary, "ShiftActorsObjects"))

		 || ! (g_fnpFreeAllActorsObjects
				= (TAioFreeAllActorsObjectsFunc)GetProcAddress(g_hLibrary, "FreeAllActorsObjects"))

		 || ! (g_fnpGetActorsObjectsCount
				= (TAioGetActorsObjectsCountFunc)GetProcAddress(g_hLibrary, "GetActorsObjectsCount"))
		 || ! (g_fnpGetActorsObject
				= (TAioGetActorsObjectFunc)GetProcAddress(g_hLibrary, "GetActorsObject"))
		 || ! (g_fnpAddActorsObject
				= (TAioAddActorsObjectFunc)GetProcAddress(g_hLibrary, "AddActorsObject"))

		 || ! (g_fnpGetActorsObjectsMapping
				= (TAioGetActorsObjectsMappingFunc)GetProcAddress(g_hLibrary, "GetActorsObjectsMapping"))

		 || ! (g_fnpGetLastErrorText
				= (TAioGetLastErrorTextFunc)GetProcAddress(g_hLibrary, "GetLastErrorText")) )
		return false;

	return true;
}
