/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public class Actor {
    private boolean replace = true;
    private int nstationary = 0;
    private int buildings = 0;
    private int chiefs = 0;

    public static void main(String[] stringArray) {
        System.out.println("Actors Static Lite v0.93");
        boolean bl = true;
        Actor actor = new Actor();
        if (stringArray.length > 0) {
            if (stringArray.length == 1) {
                if (stringArray[0].equals("create")) {
                    actor.transformBridges();
                    actor.replaceAll();
                } else {
                    bl = false;
                }
            } else if (stringArray.length == 2) {
                String string = stringArray[1];
                if (stringArray[0].equals("extract")) {
                    actor.extractInfo(string);
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            actor.usage();
        } else {
            System.out.println("Done");
        }
    }

    private void usage() {
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("java -jar Act create");
        System.out.println("   creates MWactors.static file from all in***.txt files");
        System.out.println("java -jar Act extract <filename>");
        System.out.println("   extracts info from <filename> in out***.txt files");
    }

    private void transformBridges() {
        System.out.println("Converting bridge file");
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string = null;
            String string2 = System.getProperty("line.separator");
            BufferedReader bufferedReader = new BufferedReader(new FileReader("inWing.txt"));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("inBridgesReal.txt"));
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader("MapSize.txt"));
            bufferedReader2.readLine();
            float f = Float.parseFloat(bufferedReader2.readLine());
            bufferedReader2.close();
            string = bufferedReader.readLine();
            if (string != null) {
                int n;
                do {
                    if ((string = bufferedReader.readLine()) == null || string.endsWith("]")) continue;
                    String[] stringArray = string.split("\\s");
                    arrayList.add(stringArray[2]);
                } while (string != null && !string.endsWith("]"));
                for (n = 0; n < arrayList.size(); ++n) {
                    if (string.contains((String)arrayList.get(n))) {
                        String string3 = bufferedReader.readLine();
                        string3 = bufferedReader.readLine();
                        string3 = bufferedReader.readLine();
                        if (string3.equals("  Class air.A_20C")) {
                            arrayList2.add("32");
                        }
                        if (string3.equals("  Class air.A_20G")) {
                            arrayList2.add("64");
                        }
                        if (string3.equals("  Class air.B_17D")) {
                            arrayList2.add("128");
                        }
                        string3 = bufferedReader.readLine();
                        string3 = bufferedReader.readLine();
                    }
                    string = bufferedReader.readLine();
                }
                n = 32;
                do {
                    if (string.endsWith("]")) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            if (!string.equals("[" + (String)arrayList.get(i) + "_Way]")) continue;
                            n = Integer.parseInt((String)arrayList2.get(i));
                        }
                    } else {
                        String[] stringArray = string.split("\\s");
                        float f2 = Float.parseFloat(stringArray[3]);
                        float f3 = f - Float.parseFloat(stringArray[4]);
                        string = bufferedReader.readLine();
                        stringArray = string.split("\\s");
                        float f4 = Float.parseFloat(stringArray[3]);
                        float f5 = f - Float.parseFloat(stringArray[4]);
                        int n2 = (int)(f4 / 200.0f) - (int)(f2 / 200.0f);
                        int n3 = (int)(f5 / 200.0f - 1.0f) - (int)(f3 / 200.0f - 1.0f);
                        int n4 = 0;
                        int n5 = 0;
                        if (n3 == 0) {
                            n5 = 0;
                            n4 = n2 <= 0 ? -1 : 1;
                        } else if (n2 == 0) {
                            n4 = 0;
                            n5 = n3 <= 0 ? -1 : 1;
                        } else {
                            if (Math.abs(n2) != Math.abs(n3)) {
                                System.out.println("LongBridge: wrong direction");
                            }
                            n4 = n2 <= 0 ? -1 : 1;
                            n5 = n3 <= 0 ? -1 : 1;
                        }
                        float f6 = 0.0f;
                        f6 = n4 != 0 ? (f2 / 200.0f - (float)((int)(f2 / 200.0f)) - 0.5f) / (float)n4 : (f3 / 200.0f - (float)((int)(f3 / 200.0f)) - 0.5f) / (float)n5;
                        bufferedWriter.write((int)(f2 / 200.0f) + " " + (int)(f3 / 200.0f - 1.0f) + " " + (int)(f4 / 200.0f) + " " + (int)(f5 / 200.0f - 1.0f) + " " + n + " " + Float.toString(f6) + string2);
                    }
                } while ((string = bufferedReader.readLine()) != null);
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Error");
            System.exit(-1);
        }
    }

    public void replaceAll() {
        System.out.println("Creating *.static file");
        try {
            int n;
            int n2;
            int n3;
            int n4;
            Object object;
            int n5;
            int n6;
            String[] stringArray;
            int n7;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList arrayList4 = new ArrayList();
            ArrayList<String> arrayList5 = new ArrayList<String>();
            ArrayList<String> arrayList6 = new ArrayList<String>();
            ArrayList<String> arrayList7 = new ArrayList<String>();
            ArrayList<String> arrayList8 = new ArrayList<String>();
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("MWactors.static"));
            BufferedReader bufferedReader = new BufferedReader(new FileReader("inBuildings.txt"));
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader("inChiefs.txt"));
            BufferedReader bufferedReader3 = new BufferedReader(new FileReader("inChiefsRoad.txt"));
            BufferedReader bufferedReader4 = new BufferedReader(new FileReader("inNStationary.txt"));
            dataOutputStream.writeInt(-65535);
            BufferedReader bufferedReader5 = new BufferedReader(new FileReader("inBridgesReal.txt"));
            String string = null;
            System.out.println("Reading bridges");
            do {
                if ((string = bufferedReader5.readLine()) == null) continue;
                arrayList5.add(string);
            } while (string != null);
            dataOutputStream.writeInt(arrayList5.size());
            bufferedReader5.close();
            System.out.println("Writing bridges");
            for (n7 = 0; n7 < arrayList5.size(); ++n7) {
                string = (String)arrayList5.get(n7);
                stringArray = string.split("\\s");
                dataOutputStream.writeInt(Integer.parseInt(stringArray[0]));
                dataOutputStream.writeInt(Integer.parseInt(stringArray[1]));
                dataOutputStream.writeInt(Integer.parseInt(stringArray[2]));
                dataOutputStream.writeInt(Integer.parseInt(stringArray[3]));
                dataOutputStream.writeInt(Integer.parseInt(stringArray[4]));
                dataOutputStream.writeFloat(Float.parseFloat(stringArray[5]));
            }
            System.out.println("Reading takeoff points");
            string = bufferedReader4.readLine();
            do {
                if ((string = bufferedReader4.readLine()) == null) continue;
                arrayList6.add(string);
            } while (string != null);
            bufferedReader4.close();
            System.out.println("Writing takeoff points");
            if (arrayList6.size() > 0) {
                dataOutputStream.writeInt(1);
                dataOutputStream.writeUTF("com.maddox.il2.objects.air.Runaway");
            } else {
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.writeInt(arrayList6.size());
            for (n7 = 0; n7 < arrayList6.size(); ++n7) {
                string = (String)arrayList6.get(n7);
                stringArray = string.split("\\s");
                dataOutputStream.writeInt(0);
                dataOutputStream.writeFloat(Float.parseFloat(stringArray[5]));
                dataOutputStream.writeFloat(Float.parseFloat(stringArray[6]));
                dataOutputStream.writeFloat(Float.parseFloat(stringArray[7]));
            }
            String string2 = null;
            System.out.println("Reading buildings");
            string2 = bufferedReader.readLine();
            do {
                float f;
                if ((string2 = bufferedReader.readLine()) == null) continue;
                int n11 = string2.indexOf("_bld");
                string = string2.substring(n11 + 5, n6 = string2.indexOf(" 1 "));
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                    ++n9;
                }
                n5 = arrayList.indexOf(string);
                string = string2.substring(n6);
                object = new StringTokenizer(string);
                boolean bl = Integer.parseInt(((StringTokenizer)object).nextToken()) == 1;
                double d = Double.parseDouble(((StringTokenizer)object).nextToken());
                double d2 = Double.parseDouble(((StringTokenizer)object).nextToken());
                for (f = Float.parseFloat(((StringTokenizer)object).nextToken()); f >= 360.0f; f -= 360.0f) {
                }
                f = -1.0f * f;
                n4 = (int)(d / 200.0);
                n3 = (int)(d2 / 200.0);
                int n12 = (int)((d / 200.0 - (double)n4) * 32000.0);
                n2 = (int)((d2 / 200.0 - (double)n3) * 32000.0);
                int n13 = (int)(f * 32000.0f / 360.0f);
                int n14 = n13 << 16 | n5 & Short.MAX_VALUE;
                int n15 = n2 << 16 | n12 & 0xFFFF;
                int n16 = n3 << 16 | n4 & 0xFFFF;
                double d3 = (double)n4 * 200.0 + (double)(n12 * 200) / 32000.0;
                double d4 = (double)n3 * 200.0 + (double)(n2 * 200) / 32000.0;
                if (!arrayList3.contains(Integer.toString(n16))) {
                    arrayList3.add(Integer.toString(n16));
                    arrayList2.add(Integer.toString(n14) + " " + Integer.toString(n15));
                    ++n10;
                } else {
                    String string3 = (String)arrayList2.get(arrayList3.indexOf(Integer.toString(n16)));
                    string3 = string3 + " " + Integer.toString(n14) + " " + Integer.toString(n15);
                    arrayList2.set(arrayList3.indexOf(Integer.toString(n16)), string3);
                }
                ++n8;
            } while (string2 != null);
            bufferedReader.close();
            System.out.println("Writing buildings");
            dataOutputStream.writeInt(n9);
            for (n = 0; n < n9; ++n) {
                dataOutputStream.writeUTF("com.maddox.il2.objects.buildings." + (String)arrayList.get(n));
            }
            dataOutputStream.writeInt(n10);
            for (n = 0; n < n10; ++n) {
                dataOutputStream.writeInt(Integer.parseInt((String)arrayList3.get(n)));
                String[] stringArray2 = ((String)arrayList2.get(n)).split("\\s");
                dataOutputStream.writeInt(stringArray2.length / 2);
                for (n5 = 0; n5 < stringArray2.length; n5 += 2) {
                    dataOutputStream.writeInt(Integer.parseInt(stringArray2[n5]));
                    dataOutputStream.writeInt(Integer.parseInt(stringArray2[n5 + 1]));
                }
            }
            System.out.println("Reading airfield points");
            do {
                if ((string = bufferedReader3.readLine()) == null) continue;
                arrayList8.add(string);
            } while (string != null);
            arrayList8.add("[Last_Chief_Road]");
            string = bufferedReader2.readLine();
            n = 0;
            n6 = 0;
            n5 = 0;
            object = new ArrayList();
            ArrayList<String> arrayList9 = new ArrayList<String>();
            ArrayList<String> arrayList10 = new ArrayList<String>();
            do {
                if ((string = bufferedReader2.readLine()) == null) continue;
                arrayList7.add(string);
                if (string.indexOf("Armor.1-BT7") > 0) {
                    ++n;
                    ((ArrayList)object).add(string);
                }
                if (string.indexOf("Vehicles.GAZ67") > 0) {
                    ++n6;
                    arrayList9.add(string);
                }
                if (string.indexOf("Vehicles.WillisMB_US") <= 0) continue;
                ++n5;
                arrayList10.add(string);
            } while (string != null);
            bufferedReader3.close();
            bufferedReader2.close();
            if (n > 0) {
                String[] stringArray3;
                int n17;
                dataOutputStream.writeInt(n);
                System.out.println("Writing runway points");
                for (n17 = 0; n17 < n; ++n17) {
                    String string4 = (String)((ArrayList)object).get(n17);
                    stringArray3 = string4.split("\\s");
                    int n18 = arrayList8.indexOf("[" + stringArray3[2] + "_Road]");
                    n4 = n18 + 1;
                    n3 = 0;
                    ArrayList arrayList11 = new ArrayList();
                    do {
                        arrayList11.add(arrayList8.get(n4));
                    } while (((String)arrayList8.get(++n4)).indexOf("_Chief_Road]") <= 0);
                    dataOutputStream.writeInt(arrayList11.size());
                    for (n2 = n18 + 1; n2 < n4; ++n2) {
                        String[] stringArray4 = ((String)arrayList8.get(n2)).split("\\s");
                        dataOutputStream.writeFloat(Float.parseFloat(stringArray4[2]));
                        dataOutputStream.writeFloat(Float.parseFloat(stringArray4[3]));
                    }
                }
                dataOutputStream.writeInt(n6);
                System.out.println("Writing taxi points");
                for (n17 = 0; n17 < n6; ++n17) {
                    String string5 = (String)arrayList9.get(n17);
                    stringArray3 = string5.split("\\s");
                    int n19 = arrayList8.indexOf("[" + stringArray3[2] + "_Road]");
                    n4 = n19 + 1;
                    n3 = 0;
                    ArrayList arrayList12 = new ArrayList();
                    do {
                        arrayList12.add(arrayList8.get(n4));
                    } while (((String)arrayList8.get(++n4)).indexOf("_Chief_Road]") <= 0);
                    dataOutputStream.writeInt(arrayList12.size());
                    for (n2 = n19 + 1; n2 < n4; ++n2) {
                        String[] stringArray5 = ((String)arrayList8.get(n2)).split("\\s");
                        dataOutputStream.writeFloat(Float.parseFloat(stringArray5[2]));
                        dataOutputStream.writeFloat(Float.parseFloat(stringArray5[3]));
                    }
                }
                dataOutputStream.writeInt(n5);
                System.out.println("Writing parking points");
                for (n17 = 0; n17 < n5; ++n17) {
                    String string6 = (String)arrayList10.get(n17);
                    stringArray3 = string6.split("\\s");
                    int n20 = arrayList8.indexOf("[" + stringArray3[2] + "_Road]");
                    n4 = n20 + 1;
                    n3 = 0;
                    ArrayList arrayList13 = new ArrayList();
                    do {
                        arrayList13.add(arrayList8.get(n4));
                    } while (((String)arrayList8.get(++n4)).indexOf("_Chief_Road]") <= 0);
                    dataOutputStream.writeInt(arrayList13.size());
                    for (n2 = n20 + 1; n2 < n4; ++n2) {
                        String[] stringArray6 = ((String)arrayList8.get(n2)).split("\\s");
                        dataOutputStream.writeFloat(Float.parseFloat(stringArray6[2]));
                        dataOutputStream.writeFloat(Float.parseFloat(stringArray6[3]));
                    }
                }
            }
            dataOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error");
            System.exit(-1);
        }
    }

    public void extractInfo(String string) {
        System.out.println("Reading *.static file");
        try {
            float f;
            short s;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string2 = System.getProperty("line.separator");
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("outBuildings.txt"));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter("outChiefs.txt"));
            BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter("outChiefsRoad.txt"));
            BufferedWriter bufferedWriter4 = new BufferedWriter(new FileWriter("outNStationary.txt"));
            BufferedWriter bufferedWriter5 = new BufferedWriter(new FileWriter("outWing.txt"));
            int n8 = dataInputStream.readInt();
            if (n8 != -65535) {
                throw new IOException("Not supported version");
            }
            int n9 = dataInputStream.readInt();
            System.out.println("Reading bridges");
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (n7 = 0; n7 < n9; ++n7) {
                n6 = dataInputStream.readInt();
                int n10 = dataInputStream.readInt();
                n5 = dataInputStream.readInt();
                int n11 = dataInputStream.readInt();
                n4 = dataInputStream.readInt();
                float f2 = dataInputStream.readFloat();
                if (n4 == 32) {
                    bl = true;
                }
                if (n4 == 64) {
                    bl2 = true;
                }
                if (n4 == 128) {
                    bl3 = true;
                }
                int n12 = n5 - n6;
                n3 = n11 - n10;
                n2 = 0;
                n = 0;
                if (n3 == 0) {
                    n = 0;
                    n2 = n12 <= 0 ? -1 : 1;
                } else if (n12 == 0) {
                    n2 = 0;
                    n = n3 <= 0 ? -1 : 1;
                } else {
                    if (Math.abs(n12) != Math.abs(n3)) {
                        System.out.println("LongBridge: wrong direction");
                    }
                    n2 = n12 <= 0 ? -1 : 1;
                    n = n3 <= 0 ? -1 : 1;
                }
                float f3 = f2;
                s = 0;
                float f4 = n6;
                float f5 = n10;
                float f6 = f3;
                float f7 = f4 + 0.5f + (float)n2 * f6;
                float f8 = f5 + 0.5f + (float)n * f6;
                float f9 = (float)n5 + 0.5f + (float)n2 * f6;
                float f10 = (float)n11 + 0.5f + (float)n * f6;
                f = f7 * 200.0f;
                float f11 = (-1.0f - f8) * 200.0f;
                float f12 = f9 * 200.0f;
                float f13 = (-1.0f - f10) * 200.0f;
                BufferedReader bufferedReader = new BufferedReader(new FileReader("MapSize.txt"));
                bufferedReader.readLine();
                float f14 = Float.parseFloat(bufferedReader.readLine());
                bufferedReader.close();
                arrayList2.add(Integer.toString(n4) + " " + Float.toString(Math.abs(f)) + " " + Float.toString(f14 - Math.abs(f11)) + " " + Float.toString(Math.abs(f12)) + " " + Float.toString(f14 - Math.abs(f13)));
            }
            if (n9 > 0) {
                bufferedWriter5.write("[Wing]" + string2);
                if (bl) {
                    bufferedWriter5.write("  r0100" + string2);
                }
                if (bl2) {
                    bufferedWriter5.write("  r0101" + string2);
                }
                if (bl3) {
                    bufferedWriter5.write("  r0102" + string2);
                }
                if (bl) {
                    bufferedWriter5.write("[r0100]" + string2);
                    bufferedWriter5.write("  Planes 1" + string2 + "  Skill 1" + string2 + "  Class air.A_20C" + string2);
                    bufferedWriter5.write("  Fuel 100" + string2 + "  weapons default" + string2);
                }
                if (bl2) {
                    bufferedWriter5.write("[r0101]" + string2);
                    bufferedWriter5.write("  Planes 1" + string2 + "  Skill 1" + string2 + "  Class air.A_20G" + string2);
                    bufferedWriter5.write("  Fuel 100" + string2 + "  weapons default" + string2);
                }
                if (bl3) {
                    bufferedWriter5.write("[r0102]" + string2);
                    bufferedWriter5.write("  Planes 1" + string2 + "  Skill 1" + string2 + "  Class air.B_17D" + string2);
                    bufferedWriter5.write("  Fuel 100" + string2 + "  weapons default" + string2);
                }
            }
            if (n9 > 0) {
                for (n7 = 0; n7 < 3; ++n7) {
                    n6 = 0;
                    String string3 = "32";
                    if (n7 == 0 && bl) {
                        n6 = 1;
                        bufferedWriter5.write("[r0100_Way]" + string2);
                    }
                    if (n7 == 1 && bl2) {
                        n6 = 1;
                        bufferedWriter5.write("[r0101_Way]" + string2);
                        string3 = "64";
                    }
                    if (n7 == 2 && bl3) {
                        n6 = 1;
                        bufferedWriter5.write("[r0102_Way]" + string2);
                        string3 = "128";
                    }
                    if (n6 == 0) continue;
                    for (n5 = 0; n5 < n9; ++n5) {
                        String string4 = (String)arrayList2.get(n5);
                        if (!string4.startsWith(string3)) continue;
                        String[] stringArray = string4.split("\\s");
                        bufferedWriter5.write("  NORMFLY " + stringArray[1] + " " + stringArray[2] + " 500.00 300.00 &0" + string2);
                        bufferedWriter5.write("  NORMFLY " + stringArray[3] + " " + stringArray[4] + " 500.00 300.00 &0" + string2);
                    }
                }
            }
            bufferedWriter4.write("[NStationary]" + string2);
            System.out.println("Reading takeoff points");
            n9 = dataInputStream.readInt();
            if (n9 > 0) {
                n7 = -1;
                for (n6 = 0; n6 < n9; ++n6) {
                    String string5 = dataInputStream.readUTF();
                    if (!"com.maddox.il2.objects.air.Runaway".equals(string5)) continue;
                    n7 = n6;
                }
                n9 = dataInputStream.readInt();
                while (n9-- > 0) {
                    n6 = dataInputStream.readInt();
                    float f15 = dataInputStream.readFloat();
                    float f16 = dataInputStream.readFloat();
                    float f17 = dataInputStream.readFloat();
                    if (n7 == n6) {
                        // empty if block
                    }
                    bufferedWriter4.write("  " + Integer.toString(this.nstationary) + "_Static vehicles.planes.Plane$BI_1 1 ");
                    bufferedWriter4.write(Float.toString(f15) + " " + Float.toString(f16) + " " + Float.toString(f17) + " 0.0 null" + string2);
                    ++this.nstationary;
                }
            }
            bufferedWriter.write("[Buildings]" + string2);
            System.out.println("Reading buildings");
            n9 = dataInputStream.readInt();
            n7 = -1;
            if (n9 > 0) {
                for (n6 = 0; n6 < n9; ++n6) {
                    String string6 = dataInputStream.readUTF();
                    arrayList.add(string6);
                    if (string6.indexOf("TreeLine") < 0) continue;
                    n7 = n6;
                }
            }
            n6 = dataInputStream.readInt();
            while (n6-- > 0) {
                int n13 = dataInputStream.readInt();
                int n14 = n13 & 0xFFFF;
                int n15 = n13 >> 16 & 0xFFFF;
                n4 = dataInputStream.readInt();
                Block block = new Block();
                block.code = new int[n4 * 2];
                float f18 = 0.0f;
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = dataInputStream.readInt();
                    n = dataInputStream.readInt();
                    int n16 = n2 & 0xFFFF;
                    s = (short)(n2 >> 16);
                    int n17 = n & 0xFFFF;
                    int n18 = n >> 16 & 0xFFFF;
                    block.code[n3 * 2 + 0] = n2;
                    block.code[n3 * 2 + 1] = n;
                    NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                    numberFormat.setGroupingUsed(false);
                    numberFormat.setMaximumFractionDigits(2);
                    numberFormat.setMinimumFractionDigits(2);
                    double d = (double)n14 * 200.0 + (double)(n17 * 200) / 32000.0;
                    double d2 = (double)n15 * 200.0 + (double)(n18 * 200) / 32000.0;
                    f = -((float)s * 360.0f / 32000.0f);
                    bufferedWriter.write("  " + Integer.toString(this.buildings) + "_bld " + ((String)arrayList.get(n16)).substring(33) + " 1 " + numberFormat.format(d));
                    bufferedWriter.write(" " + numberFormat.format(d2) + " " + numberFormat.format(f) + string2);
                    ++this.buildings;
                }
            }
            if (dataInputStream.available() > 0) {
                int n19;
                System.out.println("Reading runway points");
                int n20 = dataInputStream.readInt();
                bufferedWriter2.write("[Chiefs]" + string2);
                for (n19 = 0; n19 < n20; ++n19) {
                    bufferedWriter2.write("  " + Integer.toString(n19) + "_Chief Armor.1-BT7 1" + string2);
                }
                for (n19 = 0; n19 < n20; ++n19) {
                    int n21 = dataInputStream.readInt();
                    bufferedWriter3.write("[" + Integer.toString(this.chiefs) + "_Chief_Road]" + string2);
                    ++this.chiefs;
                    for (n4 = 0; n4 < n21; ++n4) {
                        float f19 = dataInputStream.readFloat();
                        float f20 = dataInputStream.readFloat();
                        if (n4 < n21 - 1) {
                            bufferedWriter3.write("  " + Float.toString(f19) + " " + Float.toString(f20) + " 120.00 0 2 2.3611111640930176" + string2);
                            continue;
                        }
                        bufferedWriter3.write("  " + Float.toString(f19) + " " + Float.toString(f20) + " 120.00" + string2);
                    }
                }
                System.out.println("Reading taxi points");
                n20 = dataInputStream.readInt();
                for (n19 = 0; n19 < n20; ++n19) {
                    bufferedWriter2.write("  " + Integer.toString(n19 + this.chiefs) + "_Chief Vehicles.GAZ67 1" + string2);
                }
                for (n19 = 0; n19 < n20; ++n19) {
                    int n22 = dataInputStream.readInt();
                    bufferedWriter3.write("[" + Integer.toString(this.chiefs) + "_Chief_Road]" + string2);
                    ++this.chiefs;
                    for (n4 = 0; n4 < n22; ++n4) {
                        float f21 = dataInputStream.readFloat();
                        float f22 = dataInputStream.readFloat();
                        if (n4 < n22 - 1) {
                            bufferedWriter3.write("  " + Float.toString(f21) + " " + Float.toString(f22) + " 120.00 0 2 2.3611111640930176" + string2);
                            continue;
                        }
                        bufferedWriter3.write("  " + Float.toString(f21) + " " + Float.toString(f22) + " 120.00" + string2);
                    }
                }
                System.out.println("Reading parking points");
                n20 = dataInputStream.readInt();
                for (n19 = 0; n19 < n20; ++n19) {
                    bufferedWriter2.write("  " + Integer.toString(n19 + this.chiefs) + "_Chief Vehicles.WillisMB_US 1" + string2);
                }
                for (n19 = 0; n19 < n20; ++n19) {
                    int n23 = dataInputStream.readInt();
                    bufferedWriter3.write("[" + Integer.toString(this.chiefs) + "_Chief_Road]" + string2);
                    ++this.chiefs;
                    for (n4 = 0; n4 < n23; ++n4) {
                        float f23 = dataInputStream.readFloat();
                        float f24 = dataInputStream.readFloat();
                        if (n4 < n23 - 1) {
                            bufferedWriter3.write("  " + Float.toString(f23) + " " + Float.toString(f24) + " 120.00 0 2 2.3611111640930176" + string2);
                            continue;
                        }
                        bufferedWriter3.write("  " + Float.toString(f23) + " " + Float.toString(f24) + " 120.00" + string2);
                    }
                }
            }
            bufferedWriter5.close();
            bufferedWriter4.close();
            bufferedWriter3.close();
            bufferedWriter2.close();
            bufferedWriter.close();
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error");
            System.exit(-1);
        }
    }

    public static class Block {
        boolean bExistPlate = false;
        int[] code;
    }
}

