
var oHGLPrevDoc;
var fHGLSamplerExist = false;
var nHGLPrevSamplerX,nHGLPrevSamplerY;

function _HGLInit()
{
	if (! app.documents.length)
		throw("You must open 'HeightsGradient.psd' file for this operation");
		
	oHGLPrevDoc = app.activeDocument;
	try
	{
		app.activeDocument = app.documents.getByName("HeightsGradient.psd");
	}
	catch(e)
	{ throw("You must open 'HeightsGradient.psd' file for this operation"); }
	
	if ( 860 > app.activeDocument.width || 51 > app.activeDocument.height )
		throw("Incorrect 'HeightsGradient.psd' image size");
	
	if (app.activeDocument.colorSamplers.length)
	{
		fHGLSamplerExist = true;
		nHGLPrevSamplerX = app.activeDocument.colorSamplers[0].position[0].value
				/ 4.333333333333333333333333; // 4.3 -  -  ((
		nHGLPrevSamplerY = app.activeDocument.colorSamplers[0].position[1].valueOf()
				/ 4.333333333333333333333333; //   ((
	}
	else
		app.activeDocument.colorSamplers.add(new Array(0,0));
}
function _HGLDeinit()
{
	if (fHGLSamplerExist)
		try //  ,    ))
		{
			app.activeDocument.colorSamplers[0].move(
					new Array(nHGLPrevSamplerX,nHGLPrevSamplerY));
		} catch(e){}
	else
		app.activeDocument.colorSamplers[0].remove();
		
	app.activeDocument = oHGLPrevDoc;
}

var cntHGLHeightsColors = new Array(0);
var fHGLColorsLoaded = false;

function _HGLMakeColor(nRed,nGreen,nBlue)
{
	var oColor = new RGBColor;
	oColor.red = nRed;
	oColor.green = nGreen;
	oColor.blue = nBlue;
	return oColor;
}

function _HGLGetColorFromImage(nIdx)
{
	var oColor = new RGBColor;
	with(app.activeDocument.colorSamplers[0])
	{
		move(new Array(50.5 + nIdx,50.5));
		oColor = color.rgb;
	}
	return oColor;
}

function _HGLCalcColorIdx(nHeightMin,nHeightMax)
{
	var nIdx = Math.round( (nHeightMin + nHeightMax) / 10 - 0.5 );
	if (0 > nIdx)
		nIdx = 0;
	if (809 < nIdx)
		nIdx = 809;
	return nIdx;
}

function HGLGetColorForHeights(nHeightMin,nHeightMax)
{
	var nIdx = _HGLCalcColorIdx(nHeightMin,nHeightMax);
	
	if (fHGLColorsLoaded)
		return cntHGLHeightsColors[nIdx];
	else
	{
		_HGLInit();
		
		var oColor = _HGLGetColorFromImage(nIdx);
		
		_HGLDeinit();
		return oColor;
	}
}

function HGLIsHeightMapNameValid(soMapName)
{
	try
	{
		var cntFound = soMapName.match(
				"^Height[^0-9]+([0-9]+)[^0-9]*([0-9]*)[^0-9]+$");
		var nHeightMin = parseInt(cntFound[2],10);
	}
	catch(e)
	{ return false; }
	
	return true;
}

function HGLGetColorForHeightMap(soMapName)
{
	var nHeightMin = 0;
	var nHeightMax = 0;
	
	try
	{
		var cntFound = soMapName.match(
				"^Height[^0-9]+([0-9]+)[^0-9]*([0-9]*)[^0-9]+$");
		
		nHeightMin = parseInt(cntFound[1],10);

		if (cntFound[2].length)
			nHeightMax = parseInt(cntFound[2],10);
		else
			nHeightMax = nHeightMin;
	}
	catch(e)
	{ return _HGLMakeColor(0,0,0); }
	
	return HGLGetColorForHeights(nHeightMin,nHeightMax);
}

function HGLLoadColorsFromImage()
{
	_HGLInit();
	
	cntHGLHeightsColors.length = 0;
	fHGLColorsLoaded = false;
	
	var oColor = _HGLGetColorFromImage(-1);
	oColor = _HGLGetColorFromImage(810);
	{for (var ul = 0; 810 > ul; ul++)
	{
		cntHGLHeightsColors.push(_HGLGetColorFromImage(ul));
	}}
	fHGLColorsLoaded = true;

	_HGLDeinit();
}

function HGLMakeHardcodedColorsSrc()
{
	var soSrc = "";
	{for (var ul = 0; cntHGLHeightsColors.length > ul; ul++)
	{
		soSrc += "	cntHGLHeightsColors.push(_HGLMakeColor(";
		soSrc += cntHGLHeightsColors[ul].red.toPrecision(6);
		soSrc += ",";
		soSrc += cntHGLHeightsColors[ul].green.toPrecision(6);
		soSrc += ",";
		soSrc += cntHGLHeightsColors[ul].blue.toPrecision(6);
		soSrc += "));\n";
	}}
	return soSrc;
}

function HGLLoadHardcodedColors()
{
	cntHGLHeightsColors.length = 0;
	fHGLColorsLoaded = true;
	
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,247.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,243.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,245.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,243.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,243.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,243.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,243.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,243.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,243.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,243.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,241.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,241.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,241.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,241.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,241.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,239.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,239.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,239.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,239.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,239.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,239.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,239.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,237.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,237.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,237.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,237.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,237.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,235.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,235.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,235.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,235.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,233.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,233.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,233.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,233.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,231.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,231.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,229.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,229.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,227.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,227.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.996,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.996,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.996,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.996,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,255.000,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.996,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,255.000,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.996,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.996,225.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.000,225.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.996,225.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.996,225.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.000,225.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.996,225.000));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.996,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.000,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.000,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.000,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.000,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.000,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(255.000,253.000,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.000,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,223.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.000,223.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,253.000,223.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,223.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,223.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,223.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,221.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,221.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.000,221.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,221.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.996,221.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.000,221.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.000,221.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.000,221.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.000,221.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.000,221.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,249.996,221.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,251.000,221.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,249.996,221.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.996,219.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,251.000,221.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,249.996,219.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.996,219.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,249.996,219.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,249.996,219.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,219.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,249.000,219.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,249.996,219.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,219.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,219.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,219.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,219.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.996,249.000,219.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,219.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,247.996,217.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,247.996,217.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,249.000,217.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.996,215.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.996,215.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,247.000,215.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.000,215.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.996,215.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.000,215.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.996,215.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.996,215.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.000,215.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.000,215.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.000,215.000));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,247.000,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,247.000,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.996,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.996,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.996,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,245.996,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(253.000,245.996,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.996,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.996,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.000,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.996,213.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.000,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.000,213.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.000,213.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,245.000,213.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,245.000,213.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,245.000,213.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.996,211.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,243.996,211.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,243.996,211.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.996,213.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,243.996,211.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,243.996,211.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.996,211.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.000,211.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.000,211.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.996,243.000,211.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.000,211.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.000,211.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.000,209.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.996,209.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,243.000,209.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.996,209.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.996,209.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.000,209.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.996,209.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.996,209.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.000,209.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.000,209.000));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.996,207.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.000,207.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.996,207.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,241.000,207.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.000,207.996));
	cntHGLHeightsColors.push(_HGLMakeColor(251.000,241.000,207.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.996,207.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.996,207.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.996,207.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.996,205.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.996,205.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.000,205.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.000,205.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.000,205.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.000,205.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,237.996,205.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.000,205.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,239.000,205.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,237.996,205.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,237.996,205.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,237.996,205.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.996,205.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.996,203.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,203.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,203.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,203.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,203.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,203.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,201.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,203.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.996,237.000,201.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,201.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,201.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,201.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.996,201.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,237.000,201.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.996,201.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.996,201.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.000,201.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.000,201.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.000,201.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.000,201.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.000,199.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.000,201.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,199.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.000,201.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,235.000,201.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,199.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,199.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,199.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,199.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,199.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,199.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,197.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.996,197.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.000,197.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,233.000,197.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,231.996,197.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,231.996,197.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,231.996,197.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,231.996,197.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,231.996,197.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,231.996,195.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,231.996,195.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,231.000,195.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,231.000,195.996));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,231.000,195.000));
	cntHGLHeightsColors.push(_HGLMakeColor(249.000,229.996,195.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.996,195.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.996,195.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.996,195.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.996,195.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.996,193.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.996,193.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.000,193.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.000,193.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,229.000,193.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.996,193.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,227.996,193.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,229.000,193.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.996,193.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.996,191.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,227.996,191.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,227.996,191.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.000,191.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.996,227.000,191.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.000,191.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.000,191.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.000,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.000,191.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,227.000,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,225.996,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,225.996,189.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,225.996,189.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,189.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,189.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,189.000));
	cntHGLHeightsColors.push(_HGLMakeColor(247.000,225.996,187.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,225.000,187.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,225.000,187.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,225.000,187.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,225.000,187.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,225.000,187.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,223.996,187.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,223.000,185.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,223.996,187.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,223.996,187.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,223.996,185.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,223.000,185.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,223.000,185.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.996,185.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.996,185.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,221.996,185.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.996,183.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.996,183.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.996,183.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.000,183.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.000,183.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.996,221.000,183.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.000,183.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,221.000,183.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,219.996,181.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,219.996,181.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,219.996,181.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,219.000,181.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,219.996,181.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,219.000,181.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,219.000,181.000));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,219.996,179.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,219.000,179.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,217.996,179.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,217.996,179.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,217.996,179.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,217.996,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,217.996,179.996));
	cntHGLHeightsColors.push(_HGLMakeColor(245.000,217.996,179.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,217.000,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,217.000,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,217.000,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,217.000,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,215.996,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,215.996,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,215.996,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,215.996,179.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,215.996,177.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,215.996,177.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,215.000,177.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,215.000,177.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.996,215.000,177.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,215.000,177.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,215.000,175.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,215.000,175.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,175.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,175.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,175.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,175.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,175.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,175.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,175.000));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.000,173.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,173.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,173.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.996,173.996));
	cntHGLHeightsColors.push(_HGLMakeColor(243.000,213.000,173.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.996,173.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.996,171.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.996,173.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.996,171.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.996,171.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.000,171.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.000,171.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.000,171.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.000,171.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,211.000,171.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,209.996,169.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,209.996,169.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,209.996,169.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,209.996,169.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,209.996,169.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,209.000,169.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,209.000,169.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,209.000,167.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,209.000,167.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.996,209.000,167.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,207.996,167.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,207.996,167.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,207.996,167.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,207.996,167.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,207.000,167.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,207.996,167.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,207.996,167.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,207.000,165.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,207.000,165.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,207.000,167.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,207.000,165.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,205.996,165.996));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,205.996,165.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,205.996,165.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,205.000,165.000));
	cntHGLHeightsColors.push(_HGLMakeColor(241.000,205.000,165.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,205.000,165.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,205.000,165.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,205.000,163.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,203.996,163.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,203.996,163.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,203.996,163.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,203.996,163.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,203.996,163.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,203.000,163.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,203.000,161.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,203.000,161.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.996,201.996,161.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,203.000,161.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,161.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,161.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,161.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,159.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,159.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,161.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,159.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,159.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,159.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,159.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.996,159.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.000,159.000));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,201.000,157.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,199.996,157.996));
	cntHGLHeightsColors.push(_HGLMakeColor(239.000,199.996,157.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,199.996,157.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,199.996,157.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,199.996,157.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,199.000,155.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,199.000,155.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,199.000,155.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,199.000,155.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,197.996,155.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,197.996,155.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,197.996,155.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,197.996,155.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,197.996,155.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,197.000,155.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,197.000,155.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,197.996,155.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,197.000,153.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,197.000,153.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,197.000,153.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.996,153.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.996,197.000,153.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.996,153.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.996,153.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.996,153.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.000,153.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.000,151.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.000,151.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,193.996,151.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.000,151.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,195.000,151.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,193.996,151.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,193.996,151.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,193.000,149.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,193.000,149.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,193.000,149.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,193.000,149.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,191.996,149.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,191.996,149.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,191.996,147.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,191.996,147.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,191.996,147.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,191.000,147.000));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,191.000,147.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,191.000,147.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,189.996,145.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,189.996,145.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,189.996,145.996));
	cntHGLHeightsColors.push(_HGLMakeColor(237.000,189.996,145.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,189.996,145.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,189.996,145.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,189.996,143.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,189.000,143.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,189.000,143.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,189.000,143.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,187.996,143.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,187.996,143.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,187.996,143.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,187.996,143.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.996,187.000,143.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,187.000,141.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,187.000,141.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,185.996,141.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,187.000,141.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,187.000,141.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,185.996,141.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,185.996,139.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,185.996,139.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,185.000,141.000));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,185.000,139.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,183.996,139.996));
	cntHGLHeightsColors.push(_HGLMakeColor(235.000,185.000,139.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,183.996,139.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,183.996,139.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,183.996,139.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,183.996,137.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,183.000,137.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,183.000,137.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,181.996,137.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,183.000,137.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,181.996,137.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,181.996,135.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,181.996,137.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,181.000,135.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,181.000,135.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,179.996,135.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,179.996,133.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,181.000,133.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.996,179.996,135.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,179.996,133.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,179.996,133.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,179.000,133.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,179.000,133.000));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,179.000,131.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,179.000,131.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,179.000,131.996));
	cntHGLHeightsColors.push(_HGLMakeColor(233.000,179.000,131.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,179.000,131.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,177.996,131.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,177.996,131.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,177.996,131.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,177.996,131.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,177.000,131.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,177.000,131.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,177.000,129.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,177.000,129.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,175.996,129.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,175.996,129.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,175.000,129.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,175.996,129.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,175.996,127.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,175.996,127.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,173.996,127.996));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,173.996,127.004));
	cntHGLHeightsColors.push(_HGLMakeColor(231.996,175.000,127.004));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,175.000,127.004));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,173.996,127.004));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,173.000,126.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,173.000,126.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,173.000,126.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,173.000,125.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,173.000,125.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,173.000,125.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,171.996,124.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,171.000,124.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,171.000,124.000));
	cntHGLHeightsColors.push(_HGLMakeColor(231.000,171.996,124.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,171.000,123.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,171.000,123.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,169.996,123.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,169.996,123.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,171.000,122.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,169.996,122.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,169.000,122.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,169.000,121.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,169.000,121.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,169.000,121.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,167.996,121.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,169.000,120.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.996,169.000,120.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,167.996,120.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,167.996,120.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,167.996,120.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,167.000,119.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,167.996,119.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,167.000,119.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,167.000,119.004));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,167.000,118.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,167.000,118.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,165.996,117.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,165.996,117.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,165.996,118.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,165.996,117.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,165.996,116.000));
	cntHGLHeightsColors.push(_HGLMakeColor(229.000,165.996,116.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,165.000,116.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,165.000,115.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,165.000,116.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,163.996,116.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,163.996,116.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,163.996,114.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,163.996,114.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,163.996,114.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,163.000,114.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,163.000,114.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,163.996,114.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,163.000,113.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,163.000,113.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.996,161.996,112.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,161.996,112.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,161.996,113.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,161.996,112.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,161.000,112.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,161.996,112.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,161.000,111.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,161.000,111.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,159.996,110.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,161.000,110.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,159.996,109.004));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,159.996,110.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,159.000,109.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,159.000,109.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,159.000,108.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,159.000,108.000));
	cntHGLHeightsColors.push(_HGLMakeColor(227.000,157.996,108.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.996,108.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.996,108.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.996,108.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.996,108.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.000,108.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.000,107.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.000,107.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.000,107.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,157.000,106.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.996,106.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.996,107.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.996,106.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.996,106.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.000,105.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.000,105.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.996,105.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.000,105.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.000,105.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.000,104.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.000,104.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,155.000,104.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,155.000,103.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,153.996,103.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,153.996,103.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,153.996,102.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,153.000,102.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,153.000,102.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,153.996,102.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.996,153.996,102.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,153.000,101.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,153.000,101.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,153.000,100.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,153.000,100.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,151.996,101.004));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,151.996,100.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,151.996,100.000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,151.996,100.000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,151.996,99.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,151.996,99.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,151.000,99.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,151.000,98.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,151.000,98.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,151.000,98.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,151.000,98.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,149.996,97.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,149.996,97.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,149.996,97.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(225.000,149.000,97.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,149.000,97.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,149.000,96.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,149.000,96.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,147.996,96.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,147.996,96.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,149.000,96.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,147.996,96.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,147.996,96.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,147.996,96.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,147.000,95.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,147.000,95.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,147.000,95.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,147.000,94.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,147.000,95.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,147.000,95.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,147.000,94.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,145.996,94.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,145.996,94.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.996,145.996,94.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,145.996,93.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,145.000,93.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,145.996,93.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,145.000,93.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,145.000,92.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,145.000,92.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,143.996,92.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,143.996,91.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,143.996,91.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,143.996,92.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.996,91.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,143.996,91.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,143.996,91.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,91.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(223.000,143.000,90.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,90.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,89.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,90.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,89.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,90.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,89.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,89.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,143.000,89.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.996,89.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,141.996,88.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.996,88.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.996,87.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.996,88.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.996,87.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,141.996,88.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.000,87.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.000,87.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.000,86.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,141.000,86.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.996,86.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,141.000,87.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.996,86.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.996,141.000,86.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.996,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.996,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.996,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.000,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.000,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.000,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.000,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,139.000,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,139.000,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,139.000,84.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,137.996,84.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,137.996,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.996,85.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,137.996,84.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,137.996,84.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.996,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.000,84.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.996,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,137.996,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(221.000,137.000,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.000,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.000,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.000,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.000,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.000,83.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.000,82.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,137.000,82.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.996,82.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.996,82.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.996,82.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,135.996,81.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.000,81.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.000,82.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.996,81.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.000,81.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.000,80.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,135.000,80.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.996,80.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.996,81.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,135.000,80.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.996,79.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,133.996,79.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,133.996,80.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,133.996,79.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.996,79.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.996,79.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,133.996,79.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.996,133.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,78.0000));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,131.996,77.0039));
	cntHGLHeightsColors.push(_HGLMakeColor(219.000,133.000,78.0000));
}
