
function OpenOrCreateDocument(sFileName)
{
	{for (var ul = 0; app.documents.length > ul; ul++)
	{
		if (app.documents[ul].fullName.fullName.toLocaleLowerCase()
				== sFileName.toLocaleLowerCase())
			return app.documents[ul];
	}}

	try
	{
		var oDoc = app.open(File(sFileName));
		return oDoc;
	}
	catch(e){}
	
	var oDoc = app.documents.add(10,10,72,"tmp",NewDocumentMode.RGB,
								DocumentFill.TRANSPARENT);
	var oSaveOptions = new PhotoshopSaveOptions;
	oSaveOptions.alphaChannels = true;
	oSaveOptions.annotations = true;
	oSaveOptions.embedColorProfile = false;
	oSaveOptions.layers = true;
	oSaveOptions.spotColors = true;
	oDoc.saveAs(File(sFileName), oSaveOptions, false, Extension.LOWERCASE);
	return oDoc;
}

function GetPngImagesFileNames(sFolderName)
{
	var cntNamesList = new Array(0);
	
	var oFolder = new Folder(sFolderName);
	if (! oFolder.exists)
		return cntNamesList;
		
	var cntFiles = oFolder.getFiles("*.png");
	{for (var ul = 0; cntFiles.length > ul; ul++)
	{
		if (cntFiles[ul] instanceof File)
			cntNamesList.push(cntFiles[ul].fullName);
	}}

	return cntNamesList;
}

function GetParsedSubfoldersNames(sFolderName)
{
	var cntNamesList = new Array(0);
	
	var oFolder = new Folder(sFolderName);
	if (! oFolder.exists)
		return cntNamesList;
		
	var cntFiles = oFolder.getFiles("*");
	{for (var ul = 0; cntFiles.length > ul; ul++)
	{
		if (! cntFiles[ul] instanceof Folder)
			continue;
			
		var soName = cntFiles[ul].name;
		var lPos = soName.lastIndexOf("_parsed");
		if ( -1 != lPos && soName.length == lPos + 7 )
			cntNamesList.push(cntFiles[ul].path + "/" + soName.slice(0, lPos));
	}}

	return cntNamesList;
}

function CutExt(sFileName)
{
	var lPos = sFileName.lastIndexOf(".");
	if (-1 != lPos)
		return sFileName.slice(0, lPos);
	else
		return sFileName;
}

function RecreateSelectionChannel(sChannelName)
{
	with(app.activeDocument)
	{
		try
		{
			channels.getByName(sChannelName).remove();
		}
		catch(e) {}

		var oChannel = channels.add();
		oChannel.kind = ChannelType.SELECTEDAREA;
		oChannel.name = sChannelName;
	}
}

function AddImagesAsSelectionChannels(sFileNameWoExt, fSaveAndClose)
{
	var cntFiles = GetPngImagesFileNames(sFileNameWoExt + "_parsed");
	if (! cntFiles.length)
		return;
		
	var oDoc = OpenOrCreateDocument(sFileNameWoExt + ".psd");
	app.activeDocument = oDoc;
	
	var cntActiveChannels = oDoc.activeChannels;
	
	{for (var ul = 0; cntFiles.length > ul; ul++)
	{
		var oImage;
		try { oImage = app.open(File(cntFiles[ul])); }
		catch(e){ continue; };
		
		app.activeDocument = oImage;
		oImage.selection.selectAll();
		oImage.selection.copy(false);
		
		app.activeDocument = oDoc;
		
		if ( oImage.width != oDoc.width || oImage.height != oDoc.height )
			oDoc.resizeCanvas(oImage.width, oImage.height, AnchorPosition.MIDDLECENTER);
			
		RecreateSelectionChannel(CutExt(oImage.name));
		oDoc.paste(false);
		
		oImage.close(SaveOptions.DONOTSAVECHANGES);
	}}

	if (fSaveAndClose)
	{
		oDoc.save();
		oDoc.close(SaveOptions.DONOTSAVECHANGES);
		return;
	}

	app.activeDocument = oDoc;
	oDoc.selection.deselect();
	oDoc.activeChannels = cntActiveChannels;
}

function main()
{
	var oActiveDoc = app.activeDocument;
	
	if ("anchor.psd" == oActiveDoc.name.toLocaleLowerCase())
	{
		var cntFolders = GetParsedSubfoldersNames(oActiveDoc.path.fullName);
		{for (var ul = 0; cntFolders.length > ul; ul++)
		{
			AddImagesAsSelectionChannels(cntFolders[ul], true);
		}}
	}
	else
	{
		AddImagesAsSelectionChannels(CutExt(app.activeDocument.fullName.fullName), false);
	}

	app.activeDocument = oActiveDoc;
}

var n_startRullerUnits = app.preferences.rulerUnits;
var n_startTypeUnits = app.preferences.typeUnits;
var e_startDisplayDialogs = app.displayDialogs;

app.preferences.rulerUnits = Units.PIXELS;
app.preferences.typeUnits = TypeUnits.PIXELS;
app.displayDialogs = DialogModes.NO;

if (app.documents.length)
	main();
		
app.preferences.rulerUnits = n_startRullerUnits;
app.preferences.typeUnits = n_startTypeUnits;
app.displayDialogs = e_startDisplayDialogs;
