
//@include "mrn_HeightsGradient_Lib.js"

function FillChannelWithColor(sChannelName,
			ulRed,ulGreen,ulBlue,ulOpacity,sSepLayerName)
{
	var oDoc = app.activeDocument;
	var fResult = false;
	
	try
	{
		var oChannel = oDoc.channels.getByName(sChannelName);
		oDoc.selection.load(oChannel);
		
		if (sSepLayerName.length)
		{
			var oLayer;
			try
			{
				oLayer = oDoc.layers.getByName(sSepLayerName);
				oDoc.activeLayer = oLayer;
				oLayer.clear();
			}
			catch(e)
			{
				oLayer = oDoc.artLayers.add();
				oLayer.name = sSepLayerName;
				oDoc.activeLayer = oLayer;
			}
		}
		
		var oColor = new RGBColor;
		oColor.red = ulRed;
		oColor.green = ulGreen;
		oColor.blue = ulBlue;
		oDoc.selection.fill(oColor, ColorBlendMode.NORMAL, ulOpacity, false);
		fResult = true;
	}
	catch(e) {}
	
	return fResult;
}

function main()
{
	var oDoc = app.activeDocument;
	
	oDoc.activeLayer = oDoc.backgroundLayer;
	oDoc.selection.selectAll();
	var oColor = new RGBColor;
	oColor.red = 255;
	oColor.green = 255;
	oColor.blue = 255;
	oDoc.selection.fill(oColor, ColorBlendMode.NORMAL, 100, false);
	
//	HGLLoadHardcodedColors();
	var fFirst = true;
	{for (var ul = 0; oDoc.channels.length > ul; ul++)
	{
		if (HGLIsHeightMapNameValid(oDoc.channels[ul].name))
		{
			var oColor = HGLGetColorForHeightMap(oDoc.channels[ul].name);
			FillChannelWithColor(oDoc.channels[ul].name,
					oColor.red,oColor.green,oColor.blue,100,
					fFirst ? "Heights" : "");
			if (fFirst)
				fFirst = false;
		}
	}}
	FillChannelWithColor("Isogonics",0,0,0,15,"Isogonics");
	
	FillChannelWithColor("Water",168,224,240,100,"Water");
	FillChannelWithColor("Water_Edges",47,156,240,100,"Water_Edges");
	FillChannelWithColor("Water_Ext",47,156,240,100,"Water_Ext");
/*	
	FillChannelWithColor("Forests",147,173,131,25,"Forests");
	FillChannelWithColor("Forests_Edges",147,173,131,50,"Forests_Edges");
	
	FillChannelWithColor("Railways_First",168,168,168,100,"Railways_First");
	FillChannelWithColor("Railways_Second",50,50,50,100,"Railways_Second");
	FillChannelWithColor("Railways_Edges",41,50,50,100,"Railways_Edges");

	FillChannelWithColor("Highways",255,214,123,100,"Highways");
	FillChannelWithColor("Highways_Edges",64,73,73,100,"Highways_Edges");

	FillChannelWithColor("Roads",255,199,78,100,"Roads");

	FillChannelWithColor("Towns",255,255,0,100,"Towns");
	FillChannelWithColor("Towns_Edges",145,145,145,100,"Towns_Edges");

	FillChannelWithColor("Bridges_Clear",255,255,255,100,"Bridges_Clear");
	FillChannelWithColor("Bridges_ClearExt",255,255,255,100,"Bridges_ClearExt");
	FillChannelWithColor("Bridges",20,20,20,100,"Bridges");
	FillChannelWithColor("Bridges_EarsExt",20,20,20,100,"Bridges_Ext");
*/	
	oDoc.selection.deselect();
}

var n_startRullerUnits = app.preferences.rulerUnits;
var n_startTypeUnits = app.preferences.typeUnits;
var e_startDisplayDialogs = app.displayDialogs;

app.preferences.rulerUnits = Units.PIXELS;
app.preferences.typeUnits = TypeUnits.PIXELS;
app.displayDialogs = DialogModes.NO;

if (app.documents.length)
	main();
		
app.preferences.rulerUnits = n_startRullerUnits;
app.preferences.typeUnits = n_startTypeUnits;
app.displayDialogs = e_startDisplayDialogs;
