
package com.maddox.il2.objects.air;

import com.maddox.JGP.*;
import com.maddox.il2.ai.*;
import com.maddox.il2.ai.air.*;
import com.maddox.il2.ai.ground.Predator;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.*;
import com.maddox.il2.net.*;
import com.maddox.il2.objects.*;
import com.maddox.il2.objects.effects.Explosions;
import com.maddox.il2.objects.ships.BigshipGeneric;
import com.maddox.il2.objects.ships.ShipGeneric;
import com.maddox.il2.objects.sounds.SndAircraft;
import com.maddox.il2.objects.sounds.Voice;
import com.maddox.il2.objects.vehicles.artillery.RocketryRocket;
import com.maddox.il2.objects.weapons.*;
import com.maddox.rts.*;
import com.maddox.util.*;
import java.io.*;
import java.lang.reflect.Method;
import java.util.*;

public abstract class Aircraft extends NetAircraft
    implements MsgCollisionListener, MsgCollisionRequestListener, MsgExplosionListener, MsgShotListener, MsgEndActionListener, Predator
{
    static class CacheItem
    {

        HierMesh mesh;
        boolean bExistTextures;
        int loaded;
        long time;

        CacheItem()
        {
        }
    }

    static class EndActionParam
    {

        Actor initiator;
        Eff3DActor smoke;

        public EndActionParam(Actor actor, Eff3DActor eff3dactor)
        {
            initiator = actor;
            smoke = eff3dactor;
        }
    }

    private static class MsgExplosionPostVarSet
    {

        Actor THIS;
        String chunkName;
        Point3d p;
        Actor initiator;
        float power;
        float radius;

        private MsgExplosionPostVarSet()
        {
            p = new Point3d();
        }

        MsgExplosionPostVarSet(MsgExplosionPostVarSet msgexplosionpostvarset)
        {
            this();
        }
    }

    public static class _WeaponSlot
    {

        public int trigger;
        public Class clazz;
        public int bullets;

        public _WeaponSlot(int i, String s, int j)
            throws Exception
        {
            trigger = i;
            clazz = ObjIO.classForName("weapons." + s);
            bullets = j;
        }
    }


    public static String[] partNames()
    {
        return partNames;
    }

    public int part(String name)
    {
        if(name == null)
            return 43;
        int i = 0;
        for(long b = 1L; i < 44; b <<= 1)
        {
            if(name.startsWith(partNames[i]))
                return i;
            i++;
        }

        return 43;
    }

    public boolean cut(String ChunkNamePrefix)
    {
        super.FM.dryFriction = 1.0F;
        debugprintln(ChunkNamePrefix + " goes off..");
        if(World.Rnd().nextFloat() < bailProbabilityOnCut(ChunkNamePrefix))
        {
            debugprintln("BAILING OUT - " + ChunkNamePrefix + " gone, can't keep on..");
            hitDaSilk();
        }
        if(!isChunkAnyDamageVisible(ChunkNamePrefix))
        {
            debugprintln(ChunkNamePrefix + " is already cut off - operation rejected..");
            return false;
        }
        int chunks[] = hideSubTrees(ChunkNamePrefix + "_D");
        if(chunks == null)
            return false;
        for(int i = 0; i < chunks.length; i++)
        {
            Wreckage a = new Wreckage(this, chunks[i]);
            int n = 0;
            do
            {
                super.FM.getClass();
                if(n < 20)
                {
                    if(hierMesh().chunkName().startsWith(((FlightModelMain) (super.FM)).AS.astateEffectChunks[n + 0]))
                        ((FlightModelMain) (super.FM)).AS.changeTankEffectBase(n, a);
                    n++;
                } else
                {
                    break;
                }
            } while(true);
            for(n = 0; n < ((FlightModelMain) (super.FM)).EI.getNum(); n++)
                if(hierMesh().chunkName().startsWith(((FlightModelMain) (super.FM)).AS.astateEffectChunks[n + 20]))
                {
                    ((FlightModelMain) (super.FM)).AS.changeEngineEffectBase(n, a);
                    ((FlightModelMain) (super.FM)).AS.changeSootEffectBase(n, a);
                }

            for(n = 0; n < 6; n++)
                if(hierMesh().chunkName().startsWith(((FlightModelMain) (super.FM)).AS.astateEffectChunks[n + 28]))
                    ((FlightModelMain) (super.FM)).AS.changeNavLightEffectBase(n, a);

            for(n = 0; n < 4; n++)
                if(hierMesh().chunkName().startsWith(((FlightModelMain) (super.FM)).AS.astateEffectChunks[n + 34]))
                    ((FlightModelMain) (super.FM)).AS.changeLandingLightEffectBase(n, a);

            for(n = 0; n < ((FlightModelMain) (super.FM)).EI.getNum(); n++)
                if(hierMesh().chunkName().startsWith(((FlightModelMain) (super.FM)).AS.astateEffectChunks[n + 38]))
                    ((FlightModelMain) (super.FM)).AS.changeOilEffectBase(n, a);

            if(hierMesh().chunkName().startsWith(ChunkNamePrefix) && World.Rnd().nextInt(0, 99) < 50)
                Eff3DActor.New(a, null, null, 1.0F, Wreckage.SMOKE, 3F);
            Vd.set(((FlightModelMain) (super.FM)).Vwld);
            a.setSpeed(Vd);
        }

        chunks = hierMesh().getSubTrees(ChunkNamePrefix + "_D");
        for(int i = 0; i < chunks.length; i++)
            detachGun(chunks[i]);

        String Cap = ChunkNamePrefix + "_CAP";
        if(hierMesh().chunkFindCheck(Cap) >= 0)
            hierMesh().chunkVisible(Cap, true);
        for(int i = 0; i < chunks.length; i++)
        {
            for(int tt = 3; tt < ((FlightModelMain) (super.FM)).Gears.pnti.length; tt++)
                try
                {
                    if(((FlightModelMain) (super.FM)).Gears.pnti[tt] != -1 && chunks[i] == hierMesh().chunkByHookNamed(((FlightModelMain) (super.FM)).Gears.pnti[tt]))
                        ((FlightModelMain) (super.FM)).Gears.pnti[tt] = -1;
                }
                catch(Exception e)
                {
                    System.out.println("FATAL ERROR: Gear pnti[] cut failed on tt[] = " + tt + " - " + ((FlightModelMain) (super.FM)).Gears.pnti.length);
                }

        }

        hierMesh().setCurChunk(chunks[0]);
        hierMesh().getChunkLocObj(tmpLoc1);
        sfxCrash(tmpLoc1.getPoint());
        return true;
    }

    public boolean cut_Subtrees(String ChunkNamePrefix)
    {
        debugprintln(ChunkNamePrefix + " goes off..");
        if(World.Rnd().nextFloat() < bailProbabilityOnCut(ChunkNamePrefix))
        {
            debugprintln("BAILING OUT - " + ChunkNamePrefix + " gone, can't keep on..");
            hitDaSilk();
        }
        if(!isChunkAnyDamageVisible(ChunkNamePrefix))
        {
            debugprintln(ChunkNamePrefix + " is already cut off - operation rejected..");
            return false;
        }
        int chunkComposite = hierMesh().chunkFindCheck(ChunkNamePrefix + "_D0");
        if(chunkComposite >= 0)
        {
            int i;
            for(i = 0; i <= 9; i++)
            {
                int ch = hierMesh().chunkFindCheck(ChunkNamePrefix + "_D" + i);
                if(ch < 0)
                    continue;
                hierMesh().setCurChunk(ch);
                if(hierMesh().isChunkVisible())
                    break;
            }

            if(i > 9)
                chunkComposite = -1;
        }
        Actor wre = null;
        if(chunkComposite >= 0)
        {
            wre = Wreckage.makeWreck(this, chunkComposite);
            wre.setOwner(this, false, false, false);
        }
        int chunks[] = hideSubTrees(ChunkNamePrefix + "_D");
        if(chunks == null)
            return false;
        for(int i = 0; i < chunks.length; i++)
        {
            if(chunkComposite < 0)
                wre = new Wreckage(this, chunks[i]);
            else
                hierMesh().setCurChunk(chunks[i]);
            int n = 0;
            do
            {
                super.FM.getClass();
                if(n < 20)
                {
                    if(hierMesh().chunkName().startsWith(((FlightModelMain) (super.FM)).AS.astateEffectChunks[n + 0]))
                        ((FlightModelMain) (super.FM)).AS.changeTankEffectBase(n, wre);
                    n++;
                } else
                {
                    break;
                }
            } while(true);
            for(n = 0; n < 4; n++)
                if(hierMesh().chunkName().startsWith(((FlightModelMain) (super.FM)).AS.astateEffectChunks[n + 20]))
                {
                    ((FlightModelMain) (super.FM)).AS.changeEngineEffectBase(n, wre);
                    ((FlightModelMain) (super.FM)).AS.changeSootEffectBase(n, wre);
                }

            if(hierMesh().chunkName().startsWith(ChunkNamePrefix) && World.Rnd().nextInt(0, 99) < 50)
                Eff3DActor.New(wre, null, null, 1.0F, Wreckage.SMOKE, 3F);
            Vd.set(((FlightModelMain) (super.FM)).Vwld);
            if(chunkComposite < 0)
                ((Wreckage)wre).setSpeed(Vd);
            else
                ((Wreck)wre).setSpeed(Vd);
        }

        chunks = hierMesh().getSubTrees(ChunkNamePrefix + "_D");
        for(int i = 0; i < chunks.length; i++)
            detachGun(chunks[i]);

        String Cap = ChunkNamePrefix + "_CAP";
        if(hierMesh().chunkFindCheck(Cap) >= 0)
            hierMesh().chunkVisible(Cap, true);
        for(int i = 0; i < chunks.length; i++)
        {
            for(int tt = 3; tt < ((FlightModelMain) (super.FM)).Gears.pnti.length; tt++)
                try
                {
                    if(((FlightModelMain) (super.FM)).Gears.pnti[tt] != -1 && chunks[i] == hierMesh().chunkByHookNamed(((FlightModelMain) (super.FM)).Gears.pnti[tt]))
                        ((FlightModelMain) (super.FM)).Gears.pnti[tt] = -1;
                }
                catch(Exception e)
                {
                    System.out.println("FATAL ERROR: Gear pnti[] cut failed on tt[] = " + tt + " - " + ((FlightModelMain) (super.FM)).Gears.pnti.length);
                }

        }

        hierMesh().setCurChunk(chunks[0]);
        hierMesh().getChunkLocObj(tmpLoc1);
        sfxCrash(tmpLoc1.getPoint());
        return true;
    }

    protected boolean cutFM(int partChunk, int typeHit, Actor initiator)
    {
        super.FM.dryFriction = 1.0F;
        switch(partChunk)
        {
        default:
            break;

        case 2: // '\002'
            if(isEnablePostEndAction(0.0D))
                postEndAction(0.0D, initiator, 2, null);
            return false;

        case 3: // '\003'
            if(((FlightModelMain) (super.FM)).EI.engines.length > 0)
            {
                hitProp(0, typeHit, initiator);
                ((FlightModelMain) (super.FM)).EI.engines[0].setEngineStuck(initiator);
            }
            break;

        case 4: // '\004'
            if(((FlightModelMain) (super.FM)).EI.engines.length > 1)
            {
                hitProp(1, typeHit, initiator);
                ((FlightModelMain) (super.FM)).EI.engines[1].setEngineStuck(initiator);
            }
            break;

        case 5: // '\005'
            if(((FlightModelMain) (super.FM)).EI.engines.length > 2)
            {
                hitProp(2, typeHit, initiator);
                ((FlightModelMain) (super.FM)).EI.engines[2].setEngineStuck(initiator);
            }
            break;

        case 6: // '\006'
            if(((FlightModelMain) (super.FM)).EI.engines.length > 3)
            {
                hitProp(3, typeHit, initiator);
                ((FlightModelMain) (super.FM)).EI.engines[3].setEngineStuck(initiator);
            }
            break;
        }
        return cut(partNames[partChunk]);
    }

    protected int curDMGLevel(int partChunk)
    {
        return curDMGLevel(partNames[partChunk] + "_D0");
    }

    private int curDMGLevel(String chunk)
    {
        int i = chunk.length() - 1;
        if(i < 2)
            return 0;
        boolean bDamageable = chunk.charAt(i - 2) == '_' && Character.toUpperCase(chunk.charAt(i - 1)) == 'D' && Character.isDigit(chunk.charAt(i));
        if(!bDamageable)
            return 0;
        HierMesh m = hierMesh();
        String chunkPrefix = chunk.substring(0, i);
        int curDLevel;
        for(curDLevel = 0; curDLevel < 10; curDLevel++)
        {
            String cur = chunkPrefix + curDLevel;
            if(m.chunkFindCheck(cur) < 0)
                return 0;
            if(m.isChunkVisible(cur))
                break;
        }

        if(curDLevel == 10)
            return 0;
        else
            return curDLevel;
    }

    protected void nextDMGLevel(String Chunk, int typeHit, Actor initiator)
    {
        int i = Chunk.length() - 1;
        HierMesh M = hierMesh();
        String cur = Chunk;
        boolean damageable = Chunk.charAt(i - 2) == '_' && Character.toUpperCase(Chunk.charAt(i - 1)) == 'D' && Character.isDigit(Chunk.charAt(i));
        super.FM.dryFriction = 1.0F;
        String next;
        if(damageable)
        {
            int curDLevel = Chunk.charAt(i) - 48;
            String chunkPrefix = Chunk.substring(0, i);
            while(!M.isChunkVisible(cur)) 
            {
                if(curDLevel < 9)
                    curDLevel++;
                else
                    return;
                cur = chunkPrefix + curDLevel;
                if(M.chunkFindCheck(cur) < 0)
                    return;
            }
            if(curDLevel < 9)
            {
                curDLevel++;
                next = chunkPrefix + curDLevel;
                if(M.chunkFindCheck(next) < 0)
                    next = null;
            } else
            {
                next = null;
            }
            chunkPrefix = Chunk.substring(0, i - 2);
        } else
        {
            if(!M.isChunkVisible(cur))
                return;
            next = null;
            String chunkPrefix = Chunk;
        }
        if(next == null)
        {
            if(!isNet() || isNetMaster())
                nextCUTLevel(Chunk, typeHit, initiator);
            return;
        } else
        {
            int partChunk = part(Chunk);
            super.FM.hit(partChunk);
            M.chunkVisible(cur, false);
            M.chunkVisible(next, true);
            return;
        }
    }

    protected void nextDMGLevels(int hits, int typeHit, String Chunk, Actor initiator)
    {
        if(hits <= 0)
            return;
        if(hits > 4)
            hits = 4;
        if(this == World.getPlayerAircraft() && !World.cur().diffCur.Vulnerability)
            return;
        if(isNet())
        {
            if(isNetPlayer() && !World.cur().diffCur.Vulnerability)
                return;
            if(!Actor.isValid(initiator))
                return;
            int part = part(Chunk);
            if(!isNetMaster())
                netPutHits(true, null, hits, typeHit, part, initiator);
            netPutHits(false, null, hits, typeHit, part, initiator);
            if(initiator != this && super.FM.isPlayers() && (initiator instanceof Aircraft) && ((Aircraft)initiator).isNetPlayer() && typeHit != 0 && hits > 3)
                if(Chunk.startsWith("Wing"))
                {
                    if(!super.FM.isSentBuryNote())
                        Chat.sendLogRnd(3, "gore_blowwing", (Aircraft)initiator, this);
                    super.FM.setSentWingNote(true);
                } else
                if(Chunk.startsWith("Tail") && !super.FM.isSentBuryNote())
                    Chat.sendLogRnd(3, "gore_blowtail", (Aircraft)initiator, this);
        }
        while(hits-- > 0) 
            nextDMGLevel(Chunk, typeHit, initiator);
    }

    protected void nextCUTLevel(String Chunk, int typeHit, Actor initiator)
    {
        super.FM.dryFriction = 1.0F;
        debugprintln("Detected NCL in " + Chunk + "..");
        if(this == World.getPlayerAircraft() && !World.cur().diffCur.Vulnerability)
            return;
        int i = Chunk.length() - 1;
        HierMesh M = hierMesh();
        String cur = Chunk;
        boolean damageable = Chunk.charAt(i - 2) == '_' && Character.toUpperCase(Chunk.charAt(i - 1)) == 'D' && Character.isDigit(Chunk.charAt(i));
        String chunkPrefix;
        if(damageable)
        {
            chunkPrefix = Chunk.substring(0, i - 2);
        } else
        {
            if(!M.isChunkVisible(cur))
                return;
            chunkPrefix = Chunk;
        }
        int partChunk = part(Chunk);
        if(cutFM(partChunk, typeHit, initiator))
        {
            super.FM.cut(partChunk, typeHit, initiator);
            netPutCut(partChunk, typeHit, initiator);
            if(super.FM.isPlayers() && this != initiator && (initiator instanceof Aircraft) && ((Aircraft)initiator).isNetPlayer() && typeHit == 2 && !super.FM.isSentWingNote() && !super.FM.isSentBuryNote() && (partChunk == 34 || partChunk == 37 || partChunk == 33 || partChunk == 36))
            {
                Chat.sendLogRnd(3, "gore_sawwing", (Aircraft)initiator, this);
                super.FM.setSentWingNote(true);
            }
        }
    }

    public boolean isEnablePostEndAction(double relSec)
    {
        if(timePostEndAction < 0L)
            return true;
        long time = Time.current() + (long)(int)(relSec * 1000D);
        return time < timePostEndAction;
    }

    public void postEndAction(double relSec, Actor initiator, int action, Eff3DActor smoke)
    {
        if(!isEnablePostEndAction(relSec))
        {
            return;
        } else
        {
            timePostEndAction = Time.current() + (long)(int)(relSec * 1000D);
            MsgEndAction.post(0, relSec, this, new EndActionParam(initiator, smoke), action);
            return;
        }
    }

    public void msgEndAction(final Object _param, final int action) {
        final Aircraft.EndActionParam p = (Aircraft.EndActionParam)_param;
        if (((Actor)this).isAlive()) {
            if (((FlightModelMain)((SndAircraft)this).FM).isPlayers() && !((FlightModelMain)((SndAircraft)this).FM).isSentBuryNote()) {
                switch (action) {
                    case 2: {
                        if (Actor.isAlive(p.initiator) && p.initiator instanceof Aircraft && ((Aircraft)p.initiator).isNetPlayer() && ((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).Loc).z - Engine.land().HQ_Air(((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).Loc).x, ((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).Loc).y) > 100.0) {
                            Chat.sendLogRnd(1, "gore_blowup", (Aircraft)p.initiator, this);
                            break;
                        }
                        break;
                    }
                }
            }
            switch (action) {
                case 2: {
                    this.netExplode();
                    if (p.smoke != null) {
                        Eff3DActor.finish(p.smoke);
                        ((SndAircraft)this).sfxSmokeState(0, 0, false);
                    }
                    this.doExplosion();
                    for (int i = 0; i < ((FlightModelMain)((SndAircraft)this).FM).AS.astateEngineStates.length; ++i) {
                        ((FlightModelMain)((SndAircraft)this).FM).AS.hitEngine((Actor)this, i, 1000);
                    }
                    for (int i = 0; i < ((FlightModelMain)((SndAircraft)this).FM).AS.astateTankStates.length; ++i) {
                        ((FlightModelMain)((SndAircraft)this).FM).AS.hitTank((Actor)this, i, 1000);
                    }
                    float mass = cvt(((FlightModelMain)((SndAircraft)this).FM).M.fuel, 100.0f, 2000.0f, 5.0f, 40.0f);
                    Actor a = null;
                    String s = null;
                    if (((FlightModelMain)((SndAircraft)this).FM).Gears.onGround() && ((FlightModelMain)((SndAircraft)this).FM).Vrel.lengthSquared() < 70.0) {
                        mass = 0.0f;
                    }
                    else {
                        final Point3d p2 = new Point3d(((FlightModelMain)((SndAircraft)this).FM).Loc);
                        final Point3d p3 = new Point3d(((FlightModelMain)((SndAircraft)this).FM).Loc);
                        final Point3d pR = new Point3d();
                        ((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).Vrel).set((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).Vwld);
                        ((FlightModelMain)((SndAircraft)this).FM).Vrel.normalize();
                        ((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).Vrel).scale(20.0);
                        ((Tuple3d)p3).add((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).Vrel);
                        a = Engine.collideEnv().getLine(p2, p3, false, (Actor)this, pR);
                        if (Actor.isAlive(a) && a instanceof ActorHMesh) {
                            final Mesh mesh = ((ActorMesh)a).mesh();
                            final Loc _l = a.pos.getAbs();
                            final float t = mesh.detectCollisionLine(_l, p2, p3);
                            if (t >= 0.0f) {
                                s = Mesh.collisionChunk(0);
                            }
                            if (a instanceof BigshipGeneric || a instanceof ShipGeneric) {
                                float speedCoeff = 0.018f * (float)((FlightModelMain)((SndAircraft)this).FM).Vwld.length();
                                if (speedCoeff > 1.0f) {
                                    speedCoeff = 1.0f;
                                }
                                if (speedCoeff < 0.1f) {
                                    speedCoeff = 0.1f;
                                }
                                float fuel = ((FlightModelMain)((SndAircraft)this).FM).M.fuel;
                                if (fuel > 300.0f) {
                                    fuel = 300.0f;
                                }
                                mass = speedCoeff * (50.0f + 0.7f * ((FlightModelMain)((SndAircraft)this).FM).CT.getWeaponMass() + 0.3f * fuel);
                            }
                        }
                    }
                    float R1 = 0.5f * mass;
                    if (R1 < 10.0f) {
                        R1 = 10.0f;
                    }
                    if (R1 > 300.0f) {
                        R1 = 300.0f;
                    }
                    float R2 = 0.7f * mass;
                    if (R2 < 30.0f) {
                        R2 = 30.0f;
                    }
                    if (R2 > 350.0f) {
                        R2 = 350.0f;
                    }
                    MsgExplosion.send(a, s, ((FlightModelMain)((SndAircraft)this).FM).Loc, (Actor)this, mass, 0.9f * mass, 0, R1);
                    MsgExplosion.send(a, s, ((FlightModelMain)((SndAircraft)this).FM).Loc, (Actor)this, 0.5f * mass, 0.25f * mass, 1, R2);
                }
                case 3: {
                    this.explode();
                    break;
                }
            }
            for (int i = 0; i < Math.min(((FlightModelMain)((SndAircraft)this).FM).crew, 9); ++i) {
                if (!((FlightModelMain)((SndAircraft)this).FM).AS.isPilotDead(i)) {
                    ((FlightModelMain)((SndAircraft)this).FM).AS.hitPilot(((Interpolate)((SndAircraft)this).FM).actor, i, 100);
                }
            }
            this.setDamager(p.initiator, 4);
            final Actor damager = this.getDamager();
            World.onActorDied((Actor)this, damager, this.getAssister(damager));
        }
        MsgDestroy.Post(Time.current(), (Object)this);
    }

    protected void doExplosion()
    {
        if(((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).z < Engine.cur.land.HQ_Air(((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).x, ((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).y) + (double)(((FlightModelMain) (super.FM)).Length / 2.0F))
        {
            World.cur();
            if(World.land().isWater(((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).x, ((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).y))
                Explosions.AirDrop_Water(((FlightModelMain) (super.FM)).Loc);
            else
                Explosions.AirDrop_Land(((FlightModelMain) (super.FM)).Loc);
        } else
        {
            Explosions.ExplodeFuel(((FlightModelMain) (super.FM)).Loc);
        }
    }

    public void msgCollisionRequest(Actor other, boolean result[])
    {
        boolean bEnableIgnore = Engine.collideEnv().isDoCollision() && World.getPlayerAircraft() != this;
        if(other instanceof BigshipGeneric)
        {
            ((FlightModelMain) (super.FM)).Gears.bFlatTopGearCheck = true;
            if(bEnableIgnore && (Time.tickCounter() + hashCode() & 0xf) != 0)
                result[0] = false;
        } else
        if(bEnableIgnore && (Time.tickCounter() & 0xf) != 0 && (other instanceof Aircraft) && ((FlightModelMain) (super.FM)).Gears.isUnderDeck())
            result[0] = !((FlightModelMain) (((SndAircraft) ((Aircraft)other)).FM)).Gears.isUnderDeck();
        if(Engine.collideEnv().isDoCollision() && (other instanceof Aircraft) && Mission.isCoop() && other.isNetMirror() && (isMirrorUnderDeck() || ((FlightModelMain) (super.FM)).Gears.isUnderDeck() || Time.tickCounter() <= 2))
            result[0] = false;
    }

    public void msgCollision(Actor other, String thisChunk, String otherChunk)
    {
        if(isNet() && isNetMirror())
            return;
        if(other instanceof ActorCrater)
        {
            if(!thisChunk.startsWith("Gear"))
                return;
            if(netUser() != null && netUser() == ((ActorCrater)other).netOwner)
                return;
        }
        if(this == World.getPlayerAircraft())
            TimeSkip.airAction(1);
        super.FM.dryFriction = 1.0F;
        if(thisChunk.startsWith("Pilot"))
            if(this == World.getPlayerAircraft() && !World.cur().diffCur.Vulnerability)
            {
                return;
            } else
            {
                int i = thisChunk.charAt(5) - 49;
                killPilot(this, i);
                return;
            }
        if(thisChunk.startsWith("Head"))
            if(this == World.getPlayerAircraft() && !World.cur().diffCur.Vulnerability)
            {
                return;
            } else
            {
                int i = thisChunk.charAt(4) - 49;
                killPilot(this, i);
                return;
            }
        if(other instanceof Wreckage)
        {
            if(thisChunk.startsWith("CF_"))
                return;
            if(other.getOwner() == this)
                return;
            if(netUser() != null && netUser() == ((Wreckage)other).netOwner)
            {
                return;
            } else
            {
                other.collide(false);
                nextDMGLevels(3, 0, thisChunk, this);
                return;
            }
        }
        if(other instanceof Paratrooper)
        {
            super.FM.getSpeed(v1);
            other.getSpeed(Vd);
            Vd.x -= ((Tuple3d) (v1)).x;
            Vd.y -= ((Tuple3d) (v1)).y;
            Vd.z -= ((Tuple3d) (v1)).z;
            if(Vd.length() > 30D)
            {
                setDamager(other, 4);
                nextDMGLevels(4, 0, thisChunk, other);
            }
            return;
        }
        if((other instanceof RocketryRocket) && otherChunk.startsWith("Wing"))
        {
            RocketryRocket otherR = (RocketryRocket)other;
            Loc loc = new Loc();
            Point3d p1 = new Point3d();
            Vector3d v1 = new Vector3d();
            Vector3d v2 = new Vector3d();
            super.pos.getAbs(loc);
            p1.set(other.pos.getAbsPoint());
            loc.transformInv(p1);
            boolean bLeftW = ((Tuple3d) (p1)).y > 0.0D;
            v1.set(0.0D, bLeftW ? hierMesh().collisionR() : -hierMesh().collisionR(), 0.0D);
            loc.transform(v1);
            p1.set(((FlightModelMain) (super.FM)).Loc);
            p1.add(v1);
            other.pos.getAbs(loc);
            loc.transformInv(p1);
            v1.set(((FlightModelMain) (super.FM)).Vwld);
            other.pos.speed(v2);
            v1.sub(v2);
            loc.transformInv(v1);
            v1.z += (bLeftW ? 1.0D : -1D) * ((Tuple3d) (super.FM.getW())).x * (double)hierMesh().collisionR();
            if(((Tuple3d) (v1)).x * ((Tuple3d) (v1)).x + ((Tuple3d) (v1)).y * ((Tuple3d) (v1)).y < 4D)
            {
                if(((Tuple3d) (p1)).y * ((Tuple3d) (v1)).z > 0.0D)
                    otherR.sendRocketStateChange('a', this);
                else
                    otherR.sendRocketStateChange('b', this);
                return;
            }
            otherR.sendRocketStateChange(bLeftW ? 'l' : 'r', this);
        }
        if(super.FM.turnOffCollisions && (thisChunk.startsWith("Wing") || thisChunk.startsWith("Arone") || thisChunk.startsWith("Keel") || thisChunk.startsWith("Rudder") || thisChunk.startsWith("Stab") || thisChunk.startsWith("Vator") || thisChunk.startsWith("Nose") || thisChunk.startsWith("Tail")))
            return;
        if((other instanceof Aircraft) && Actor.isValid(other) && getArmy() == other.getArmy())
        {
            double z = Engine.cur.land.HQ(((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).x, ((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).y);
            Aircraft a = (Aircraft)other;
            if(((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).z - (double)(2.0F * ((FlightModelMain) (super.FM)).Gears.H) < z && ((Tuple3d) (((FlightModelMain) (((SndAircraft) (a)).FM)).Loc)).z - (double)(2.0F * ((FlightModelMain) (((SndAircraft) (a)).FM)).Gears.H) < z)
                setDamagerExclude(other);
        }
        if(thisChunk != null && hierMesh().chunkFindCheck(thisChunk) != -1)
        {
            hierMesh().setCurChunk(thisChunk);
            hierMesh().getChunkLocObj(tmpLoc1);
            Vd.set(((FlightModelMain) (super.FM)).Vwld);
            ((FlightModelMain) (super.FM)).Or.transformInv(Vd);
            Vd.normalize();
            Vd.negate();
            Vd.scale(2000F / ((FlightModelMain) (super.FM)).M.mass);
            Vd.cross(tmpLoc1.getPoint(), Vd);
            super.FM.getW().x += (float)((Tuple3d) (Vd)).x;
            super.FM.getW().y += (float)((Tuple3d) (Vd)).y;
            super.FM.getW().z += (float)((Tuple3d) (Vd)).z;
        }
        setDamager(other, 4);
        nextDMGLevels(4, 0, thisChunk, other);
    }

    private void splintersHit(Explosion exp)
    {
        float spl[] = new float[2];
        float r = mesh().collisionR();
        float massX = 1.0F;
        super.pos.getTime(Time.current(), tmpLocExp);
        tmpLocExp.get(Pd);
        exp.computeSplintersHit(Pd, r, 1.0F, spl);
        Shot shot = new Shot();
        shot.chunkName = "CF_D0";
        shot.initiator = exp.initiator;
        shot.tickOffset = Time.tickOffset();
        int n = (int)(spl[0] * 2.0F + 0.5F);
        if(n <= 0)
            return;
        while(n > 192) 
        {
            n = (int)((float)n * 0.5F);
            massX *= 2.0F;
        }
        for(int i = 0; i < n; i++)
        {
            tmpP1.set(exp.p);
            tmpLocExp.get(tmpP2);
            double d = tmpP1.distance(tmpP2);
            tmpP2.add(World.Rnd().nextDouble(-r, r), World.Rnd().nextDouble(-r, r), World.Rnd().nextDouble(-r, r));
            if(d > (double)r)
                tmpP1.interpolate(tmpP1, tmpP2, 1.0D - (double)r / d);
            tmpP2.interpolate(tmpP1, tmpP2, 2D);
            int tmpN = hierMesh().detectCollisionLineMulti(tmpLocExp, tmpP1, tmpP2);
            if(tmpN > 0)
            {
                shot.mass = 0.015F * World.Rnd().nextFloat(0.25F, 1.75F) * massX;
                if(World.Rnd().nextFloat() < 0.1F)
                    shot.mass = 0.015F * World.Rnd().nextFloat(0.1F, 10F) * massX;
                float massThreshold = exp.power * 10F;
                if(shot.mass > massThreshold)
                    shot.mass = massThreshold;
                shot.p.interpolate(tmpP1, tmpP2, hierMesh().collisionDistMulti(0));
                if(World.Rnd().nextFloat() < 0.333333F)
                    shot.powerType = 2;
                else
                if(World.Rnd().nextFloat() < 0.5F)
                    shot.powerType = 3;
                else
                    shot.powerType = 0;
                shot.v.x = (float)(((Tuple3d) (tmpP2)).x - ((Tuple3d) (tmpP1)).x);
                shot.v.y = (float)(((Tuple3d) (tmpP2)).y - ((Tuple3d) (tmpP1)).y);
                shot.v.z = (float)(((Tuple3d) (tmpP2)).z - ((Tuple3d) (tmpP1)).z);
                shot.v.normalize();
                if(World.Rnd().nextFloat() < 0.02F)
                    shot.v.scale(spl[1] * World.Rnd().nextFloat(0.1F, 10F));
                else
                    shot.v.scale(spl[1] * World.Rnd().nextFloat(0.9F, 1.1F));
                msgShot(shot);
            }
        }

    }

    public void msgExplosion(Explosion exp)
    {
        if(this == World.getPlayerAircraft())
            TimeSkip.airAction(3);
        setExplosion(exp);
        super.FM.dryFriction = 1.0F;
        if(exp.power <= 0.0F || exp.chunkName != null && exp.chunkName.equals(partNames[43]))
        {
            debugprintln("Splash hit from " + ((exp.initiator instanceof Aircraft) ? ((Aircraft)exp.initiator).typedName() : exp.initiator.name()) + " in " + exp.chunkName + " is Nill..");
            return;
        }
        if(exp.powerType == 1)
        {
            splintersHit(exp);
            return;
        }
        float powShockwave = exp.power;
        float powSplinters = 0.0F;
        if(exp.powerType == 0)
        {
            powShockwave *= 0.5F;
            powSplinters = powShockwave;
        }
        if(exp.chunkName != null)
        {
            if(exp.chunkName.startsWith("Wing") && exp.chunkName.endsWith("_D3"))
                super.FM.setCapableOfACM(false);
            if(exp.chunkName.startsWith("Wing") && exp.power > 0.0025F)
            {
                if(exp.chunkName.startsWith("WingL"))
                {
                    debugprintln("Large Shockwave Hits the Left Wing - Wing Stalls.");
                    ((FlightModelMain) (super.FM)).AS.setFMSFX(exp.initiator, 2, (int)(exp.power * 20000F));
                }
                if(exp.chunkName.startsWith("WingR"))
                {
                    debugprintln("Large Shockwave Hits the Right Wing - Wing Stalls.");
                    ((FlightModelMain) (super.FM)).AS.setFMSFX(exp.initiator, 3, (int)(exp.power * 20000F));
                }
            }
        }
        float energy;
        if(exp.chunkName == null)
            energy = exp.receivedTNT_1meter(this);
        else
            energy = powShockwave;
        if(energy <= 5.000001E-007F)
            return;
        debugprintln("Splash hit from " + ((exp.initiator instanceof Aircraft) ? ((Aircraft)exp.initiator).typedName() : exp.initiator.name()) + " in " + exp.chunkName + " for " + (int)((100F * energy) / (0.01F + 3F * ((FlightModelMain) (super.FM)).Sq.getToughness(part(exp.chunkName)))) + " % ( " + energy + " kg)..");
        if(exp.chunkName == null)
        {
            energy /= 0.01F;
        } else
        {
            if(exp.chunkName.endsWith("_D0") && !exp.chunkName.startsWith("Gear"))
            {
                if(energy > 0.01F)
                    energy = 1.0F + (energy - 0.01F) / ((FlightModelMain) (super.FM)).Sq.getToughness(part(exp.chunkName));
                else
                    energy /= 0.01F;
            } else
            {
                energy /= ((FlightModelMain) (super.FM)).Sq.getToughness(part(exp.chunkName));
            }
            energy += ((FlightModelMain) (super.FM)).Sq.eAbsorber[part(exp.chunkName)];
        }
        if(energy >= 1.0F)
            setDamager(exp.initiator, (int)energy);
        if(exp.chunkName != null)
        {
            if((int)energy > 0)
            {
                setDamager(exp.initiator, 1);
                if(exp.chunkName.startsWith("Pilot"))
                {
                    killPilot(exp.initiator, exp.chunkName.charAt(5) - 49);
                    return;
                }
                if(exp.chunkName.startsWith("Head"))
                {
                    killPilot(exp.initiator, exp.chunkName.charAt(4) - 49);
                    return;
                }
            }
            nextDMGLevels((int)energy, 1, exp.chunkName, exp.initiator);
        } else
        {
            for(int i = 0; i < partNamesForAll.length; i++)
            {
                int j = World.Rnd().nextInt(partNamesForAll.length);
                if(!isChunkAnyDamageVisible(partNamesForAll[j]))
                    continue;
                nextDMGLevels((int)energy, 1, partNamesForAll[j] + "_D0", exp.initiator);
                break;
            }

        }
        if(exp.chunkName != null)
            ((FlightModelMain) (super.FM)).Sq.eAbsorber[part(exp.chunkName)] = energy - (float)(int)energy;
        if(energy > 8F)
            if(energy / (float)partNamesForAll.length > 1.5F)
            {
                for(int i = 0; i < partNamesForAll.length; i++)
                    if(isChunkAnyDamageVisible(partNamesForAll[i]))
                        nextDMGLevels(3, 1, partNamesForAll[i] + "_D0", exp.initiator);

            } else
            {
                int n = (int)energy / 3 - 1;
                if(n > partNamesForAll.length * 2)
                    n = partNamesForAll.length * 2;
                for(int i = 0; i < n; i++)
                {
                    int j = World.Rnd().nextInt(partNamesForAll.length);
                    if(isChunkAnyDamageVisible(partNamesForAll[j]))
                        nextDMGLevels(3, 1, partNamesForAll[j] + "_D0", exp.initiator);
                }

            }
        if(bWasAlive && super.FM.isTakenMortalDamage() && (getDamager() instanceof Aircraft) && ((Interpolate) (super.FM)).actor.getArmy() != getDamager().getArmy() && World.Rnd().nextInt(0, 99) < 66)
        {
            if(!buried)
                Voice.speakNiceKill((Aircraft)getDamager());
            buried = true;
        }
        bWasAlive = true;
        if(powSplinters > 0.0F)
        {
            MsgExplosionPostVarSet _set = new MsgExplosionPostVarSet(null);
            _set.THIS = this;
            _set.chunkName = exp.chunkName;
            _set.p.set(exp.p);
            _set.initiator = exp.initiator;
            _set.power = powSplinters;
            _set.radius = exp.radius;
            new MsgAction(false, _set) {

                public void doAction(Object obj)
                {
                    MsgExplosionPostVarSet msgexplosionpostvarset = (MsgExplosionPostVarSet)obj;
                    if(!Actor.isValid(msgexplosionpostvarset.THIS))
                    {
                        return;
                    } else
                    {
                        MsgExplosion.send(msgexplosionpostvarset.THIS, msgexplosionpostvarset.chunkName, msgexplosionpostvarset.p, msgexplosionpostvarset.initiator, 48F * msgexplosionpostvarset.power, msgexplosionpostvarset.power, 1, Math.max(msgexplosionpostvarset.radius, 30F));
                        return;
                    }
                }

            }
;
        }
    }

    protected void doRicochet(Shot shot)
    {
        v1.x *= World.Rnd().nextFloat(0.25F, 1.0F);
        v1.y *= World.Rnd().nextFloat(-1F, -0.25F);
        v1.z *= World.Rnd().nextFloat(-1F, -0.25F);
        v1.normalize();
        v1.scale(World.Rnd().nextFloat(10F, 600F));
        ((FlightModelMain) (super.FM)).Or.transform(v1);
        doRicochet(shot.p, v1);
        shot.power = 0.0F;
    }

    protected void doRicochetBack(Shot shot)
    {
        v1.x *= -1D;
        v1.y *= -1D;
        v1.z *= -1D;
        v1.scale(World.Rnd().nextFloat(0.25F, 1.0F));
        ((FlightModelMain) (super.FM)).Or.transform(v1);
        doRicochet(shot.p, v1);
    }

    protected void doRicochet(Point3d p_, Vector3d v_)
    {
        BallisticProjectile b = new BallisticProjectile(p_, v_, 1.0F);
        Eff3DActor.New(b, null, null, 4F, "3DO/Effects/Tracers/TrailRicochet.eff", 1.0F);
        super.pos.getAbs(tmpLoc1);
        tmpLoc1.transformInv(p_);
        Eff3DActor.New(this, null, new Loc(p_), 1.0F, "3DO/Effects/Fireworks/12mmRicochet.eff", 0.2F);
        Eff3DActor.New(this, null, new Loc(p_), 0.5F, "3DO/Effects/Fireworks/20_Sparks.eff", -1F);
    }

    protected void setShot(Shot shot)
    {
        if((this == World.getPlayerAircraft() || isNetPlayer()) && !World.cur().diffCur.Vulnerability)
        {
            shot.chunkName = partNames[43];
            shot.power = 0.0F;
            shot.mass = 0.0F;
        }
        if(bWasAlive)
            bWasAlive = !super.FM.isTakenMortalDamage();
        v1.sub(shot.v, ((FlightModelMain) (super.FM)).Vwld);
        double vrel = v1.length();
        shot.power = (float)((double)shot.mass * vrel * vrel) * 0.5F;
        if(shot.powerType == 0)
            shot.power *= 0.666F;
        ((FlightModelMain) (super.FM)).Or.transformInv(v1);
        v1.normalize();
        tmpLoc1.set(shot.p);
        super.pos.getAbs(tmpLoc2);
        super.pos.getCurrent(tmpLoc3);
        tmpLoc3.interpolate(tmpLoc2, shot.tickOffset);
        tmpLoc1.sub(tmpLoc3);
        tmpLoc1.get(Pd);
        Vd.set(shot.v);
        Vd.normalize();
        Vd.scale(0.10000000149011612D);
        tmpP1.set(shot.p);
        tmpP1.sub(Vd);
        Vd.normalize();
        Vd.scale(48.900001525878906D);
        tmpP2.set(shot.p);
        tmpP2.add(Vd);
        tmpBonesHit = hierMesh().detectCollisionLineMulti(tmpLoc3, tmpP1, tmpP2);
        if(Config.isUSE_RENDER() && World.cur().isArcade())
        {
            ActorSimpleMesh towString = new ActorSimpleMesh("3DO/Arms/MatrixXX/mono.sim");
            ((Actor) (towString)).pos.setBase(this, null, false);
            tmpOr.setAT0(v1);
            ((Actor) (towString)).pos.setRel(Pd, tmpOr);
            float rrtt = (float)Math.sqrt(Math.sqrt(shot.mass));
            towString.mesh().setScaleXYZ(0.75F * rrtt, rrtt, rrtt);
            towString.drawing(true);
            towString.postDestroy(Time.current() + 30000L);
        }
    }

    protected void setExplosion(final Explosion exp) {
        if ((this == World.getPlayerAircraft() || this.isNetPlayer()) && !World.cur().diffCur.Vulnerability) {
            exp.chunkName = Aircraft.partNames[43];
        }
        if (exp.chunkName == null && !this.isChunkAnyDamageVisible("CF")) {
            exp.chunkName = Aircraft.partNames[43];
        }
        if (Aircraft.bWasAlive) {
            Aircraft.bWasAlive = !((FlightModelMain)((SndAircraft)this).FM).isTakenMortalDamage();
        }
    }
    
    protected void msgSndShot(final float mass, final double rel_x, final double rel_y, final double rel_z) {
        if (!Config.isUSE_RENDER()) {
            return;
        }
        ((Tuple3d)Actor._tmpPoint).set(rel_x, rel_y, rel_z);
        ((SndAircraft)this).sfxHit(mass, Actor._tmpPoint);
        if (((Actor)this).isNet() && ((FlightModelMain)((SndAircraft)this).FM).isPlayers() && ((SndAircraft)this).FM instanceof RealFlightModel) {
            ((SndAircraft)this).FM.dryFriction = 1.0f;
            ((RealFlightModel)((SndAircraft)this).FM).producedShakeLevel = 1.0f;
            final float a = 2000.0f * mass / ((FlightModelMain)((SndAircraft)this).FM).M.mass;
            ((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).getW()).add((double)World.Rnd().nextFloat(-a, a), (double)World.Rnd().nextFloat(-a, a), (double)World.Rnd().nextFloat(-a, a));
        }
    }
    
    public void msgShot(final Shot shot) {
        if (this == World.getPlayerAircraft()) {
            TimeSkip.airAction(2);
        }
        this.setShot(shot);
        if (!((Actor)this).isNet()) {
            ((SndAircraft)this).FM.dryFriction = 1.0f;
            if (((FlightModelMain)((SndAircraft)this).FM).isPlayers() && ((SndAircraft)this).FM instanceof RealFlightModel) {
                ((RealFlightModel)((SndAircraft)this).FM).producedShakeLevel = 1.0f;
            }
            final float a = 2000.0f * shot.mass / ((FlightModelMain)((SndAircraft)this).FM).M.mass;
            ((Tuple3d)((FlightModelMain)((SndAircraft)this).FM).getW()).add((double)World.Rnd().nextFloat(-a, a), (double)World.Rnd().nextFloat(-a, a), (double)World.Rnd().nextFloat(-a, a));
        }
        if (shot.chunkName == null) {
            return;
        }
        if (shot.chunkName == Aircraft.partNames[43]) {
            if (((Random)World.Rnd()).nextFloat() < 0.25f) {
                this.doRicochet(shot);
            }
            return;
        }
        if (shot.chunkName.startsWith("Wing") && (shot.chunkName.endsWith("_D3") || (shot.chunkName.endsWith("_D2") && ((FlightModelMain)((SndAircraft)this).FM).Skill >= 2))) {
            ((FlightModelMain)((SndAircraft)this).FM).setCapableOfACM(false);
        }
        if (((SndAircraft)this).FM instanceof Pilot && World.Rnd().nextInt(-1, 8) < ((FlightModelMain)((SndAircraft)this).FM).Skill) {
            ((Pilot)((SndAircraft)this).FM).setAsDanger(shot.initiator);
        }
        if (Config.isUSE_RENDER() && ((SndAircraft)this).FM instanceof RealFlightModel) {
            ((Tuple3d)Actor._tmpPoint).set((Tuple3d)((Actor)this).pos.getAbsPoint());
            ((Tuple3d)Actor._tmpPoint).sub((Tuple3d)shot.p);
            this.msgSndShot(shot.mass, ((Tuple3d)Actor._tmpPoint).x, ((Tuple3d)Actor._tmpPoint).y, ((Tuple3d)Actor._tmpPoint).z);
        }
        shot.bodyMaterial = 2;
        if (this.isNetPlayer()) {
            this.sendMsgSndShot(shot);
        }
        if (Aircraft.tmpBonesHit > 0) {
            this.debuggunnery("");
            this.debuggunnery("New Bullet: E = " + (int)shot.power + " [J], M = " + (int)(1000.0f * shot.mass) + " [g], Type = (" + this.sttp(shot.powerType) + ")");
            if (shot.powerType == 1) {
                Aircraft.tmpBonesHit = Math.min(Aircraft.tmpBonesHit, 2);
            }
            for (int i = 0; i < Aircraft.tmpBonesHit; ++i) {
                ((ActorHMesh)this).hierMesh();
                String str = Mesh.collisionNameMulti(i, 1);
                if (str.length() == 0) {
                    ((ActorHMesh)this).hierMesh();
                    str = Mesh.collisionNameMulti(i, 0);
                }
                if (shot.power > 0.0f) {
                    final Point3d pd = Aircraft.Pd;
                    final Point3d tmpP1 = Aircraft.tmpP1;
                    final Point3d tmpP2 = Aircraft.tmpP2;
                    ((ActorHMesh)this).hierMesh();
                    ((Tuple3d)pd).interpolate((Tuple3d)tmpP1, (Tuple3d)tmpP2, Mesh.collisionDistMulti(i));
                    Aircraft.tmpLoc3.transformInv(Aircraft.Pd);
                    this.debuggunnery("Hit Bone [" + str + "], E = " + (int)shot.power);
                    this.hitBone(str, shot, Aircraft.Pd);
                    if (!str.startsWith("xx")) {
                        final float n = 33.333f;
                        float n2;
                        if (i == Aircraft.tmpBonesHit - 1) {
                            n2 = 0.02f;
                        }
                        else {
                            ((ActorHMesh)this).hierMesh();
                            final float collisionDistMulti = Mesh.collisionDistMulti(i + 1);
                            ((ActorHMesh)this).hierMesh();
                            n2 = collisionDistMulti - Mesh.collisionDistMulti(i);
                        }
                        this.getEnergyPastArmor(n * n2, shot);
                        if (((Random)World.Rnd()).nextFloat() < 0.05f) {
                            shot.power = 0.0f;
                            this.debuggunnery("Inner Ricochet");
                        }
                    }
                    if (((FlightModelMain)((SndAircraft)this).FM).CT.bHasGearControl && (str.toLowerCase().startsWith("xgear") || str.toLowerCase().startsWith("gear")) && this.getEnergyPastArmor(2.0f, shot) > 0.0f && shot.power > 2500.0f) {
                        int gearNro = -1;
                        String lastChar = "";
                        if (str.toLowerCase().startsWith("x")) {
                            lastChar = str.substring(5, 6).toUpperCase();
                        }
                        else {
                            lastChar = str.substring(4, 5).toUpperCase();
                        }
                        int damageType = 0;
                        final int rndI = World.Rnd().nextInt(0, 150);
                        if (((FlightModelMain)((SndAircraft)this).FM).CT.getGear() > 0.99) {
                            if (rndI < 5) {
                                damageType = 8;
                            }
                            else if (rndI < 10) {
                                damageType = 7;
                            }
                            else if (rndI < 15) {
                                damageType = 1;
                            }
                            else if (rndI < 20) {
                                damageType = 2;
                            }
                            else if (rndI < 25) {
                                damageType = 3;
                            }
                            else if (rndI < 30) {
                                damageType = 10;
                            }
                        }
                        else if (str.indexOf("1") != -1) {
                            if (rndI < 5) {
                                damageType = 8;
                            }
                            else if (rndI < 10) {
                                damageType = 7;
                            }
                            else if (rndI < 15) {
                                damageType = 1;
                            }
                            else if (rndI < 20) {
                                damageType = 2;
                            }
                            else if (rndI < 25) {
                                damageType = 3;
                            }
                            else if (rndI < 30) {
                                damageType = 10;
                            }
                        }
                        else if (rndI < 1) {
                            damageType = 6;
                        }
                        else if (rndI < 2) {
                            damageType = 5;
                        }
                        else if (rndI < 3) {
                            damageType = 4;
                        }
                        else if (rndI < 12) {
                            damageType = 2;
                        }
                        else if (rndI < 17) {
                            damageType = 9;
                        }
                        else if (rndI < 27) {
                            damageType = 1;
                        }
                        else if (rndI < 32) {
                            damageType = 10;
                        }
                        else if (rndI < 35) {
                            damageType = 8;
                        }
                        else if (rndI < 37) {
                            damageType = 7;
                        }
                        else if (rndI < 40) {
                            damageType = 3;
                        }
                        if (lastChar.equals("L")) {
                            gearNro = 0;
                        }
                        else if (lastChar.equals("R")) {
                            gearNro = 1;
                        }
                        else if (lastChar.equals("C")) {
                            gearNro = 2;
                        }
                        if ((gearNro == 0 || gearNro == 1) && rndI > 99 && this.chunkDamageVisible("WingLIn") > 1 && this.chunkDamageVisible("WingRIn") > 1) {
                            ((FlightModelMain)((SndAircraft)this).FM).AS.hitGear(shot.initiator, 0, 4);
                            ((FlightModelMain)((SndAircraft)this).FM).AS.hitGear(shot.initiator, 1, 4);
                        }
                        else if (damageType != 0) {
                            if (shot.power > 40000.0f) {
                                gearNro += 3;
                            }
                            if (damageType == 8) {
                                if (((Random)World.Rnd()).nextFloat() < 0.5) {
                                    ((FlightModelMain)((SndAircraft)this).FM).AS.hitGear(shot.initiator, 1, 8);
                                    ((FlightModelMain)((SndAircraft)this).FM).AS.hitGear(shot.initiator, 0, 8);
                                }
                                else {
                                    ((FlightModelMain)((SndAircraft)this).FM).AS.hitGear(shot.initiator, gearNro, damageType);
                                }
                            }
                            else {
                                ((FlightModelMain)((SndAircraft)this).FM).AS.hitGear(shot.initiator, gearNro, damageType);
                            }
                        }
                    }
                }
            }
        }
        boolean bbb = false;
        for (int i = 0; i < Aircraft.tmpBonesHit; ++i) {
            ((ActorHMesh)this).hierMesh();
            if (Mesh.collisionNameMulti(i, 1) != null) {
                ((ActorHMesh)this).hierMesh();
                final String collisionNameMulti = Mesh.collisionNameMulti(i, 1);
                ((ActorHMesh)this).hierMesh();
                if (!collisionNameMulti.equals(Mesh.collisionNameMulti(i, 0))) {
                    continue;
                }
            }
            bbb = true;
        }
        if (bbb) {
            this.debuggunnery("[+++ PROCESS OLD +++]");
            ((ActorHMesh)this).hierMesh();
            shot.chunkName = Mesh.collisionNameMulti(0, 0);
            if (shot.chunkName.startsWith("WingLOut") && World.Rnd().nextInt(0, 99) < 20) {
                shot.chunkName = "AroneL_D0";
            }
            if (shot.chunkName.startsWith("WingROut") && World.Rnd().nextInt(0, 99) < 20) {
                shot.chunkName = "AroneR_D0";
            }
            if (shot.chunkName.startsWith("StabL") && World.Rnd().nextInt(0, 99) < 45) {
                shot.chunkName = "VatorL_D0";
            }
            if (shot.chunkName.startsWith("StabR") && World.Rnd().nextInt(0, 99) < 45) {
                shot.chunkName = "VatorR_D0";
            }
            if (shot.chunkName.startsWith("Keel1") && World.Rnd().nextInt(0, 99) < 33) {
                shot.chunkName = "Rudder1_D0";
            }
            if (shot.chunkName.startsWith("Keel2") && World.Rnd().nextInt(0, 99) < 33) {
                shot.chunkName = "Rudder2_D0";
            }
            float energy = shot.powerToTNT();
            this.debugprintln("Bullet hit from " + ((shot.initiator instanceof Aircraft) ? ((Aircraft)shot.initiator).typedName() : shot.initiator.name()) + " in " + shot.chunkName + " for " + (int)(100.0f * energy / (0.01f + 3.0f * ((FlightModelMain)((SndAircraft)this).FM).Sq.getToughness(this.part(shot.chunkName)))) + " %..");
            shot.bodyMaterial = 2;
            if (((SndAircraft)this).FM instanceof Pilot && World.Rnd().nextInt(-1, 8) < ((FlightModelMain)((SndAircraft)this).FM).Skill) {
                ((Pilot)((SndAircraft)this).FM).setAsDanger(shot.initiator);
            }
            if (energy <= 5.0000006E-7f) {
                return;
            }
            if (shot.chunkName.endsWith("_D0") && !shot.chunkName.startsWith("Gear")) {
                if (energy > 0.01f) {
                    energy = 1.0f + (energy - 0.01f) / ((FlightModelMain)((SndAircraft)this).FM).Sq.getToughness(this.part(shot.chunkName));
                }
                else {
                    energy /= 0.01f;
                }
            }
            else {
                energy /= ((FlightModelMain)((SndAircraft)this).FM).Sq.getToughness(this.part(shot.chunkName));
            }
            energy += ((FlightModelMain)((SndAircraft)this).FM).Sq.eAbsorber[this.part(shot.chunkName)];
            final int nHits = (int)energy;
            ((FlightModelMain)((SndAircraft)this).FM).Sq.eAbsorber[this.part(shot.chunkName)] = energy - nHits;
            if (nHits > 0) {
                this.setDamager(shot.initiator, nHits);
                if (shot.chunkName.startsWith("Pilot")) {
                    this.killPilot(shot.initiator, shot.chunkName.charAt(5) - '1');
                    return;
                }
                if (shot.chunkName.startsWith("Head")) {
                    this.killPilot(shot.initiator, shot.chunkName.charAt(4) - '1');
                    return;
                }
            }
            this.nextDMGLevels(nHits, 2, shot.chunkName, shot.initiator);
        }
        if (Aircraft.bWasAlive && ((FlightModelMain)((SndAircraft)this).FM).isTakenMortalDamage() && this.getDamager() instanceof Aircraft && ((Interpolate)((SndAircraft)this).FM).actor.getArmy() != this.getDamager().getArmy() && World.Rnd().nextInt(0, 99) < 66) {
            if (!this.buried) {
                Voice.speakNiceKill((Aircraft)this.getDamager());
            }
            this.buried = true;
        }
        Aircraft.bWasAlive = true;
    }

    private String sttp(int i)
    {
        switch(i)
        {
        case 2: // '\002'
            return "AP";

        case 3: // '\003'
            return "API/APIT";

        case 1: // '\001'
            return "CUMULATIVE";

        case 0: // '\0'
            return "HE";
        }
        return null;
    }

    public void hitGearPanels(int i, int j)
    {
    }

    protected void hitBone(String s, Shot shot1, Point3d point3d)
    {
    }

    protected void hitChunk(String chunk, Shot shot)
    {
        if(chunk.lastIndexOf("_") == -1)
            chunk = chunk + "_D" + chunkDamageVisible(chunk);
        float energy = shot.powerToTNT();
        if(chunk.endsWith("_D0") && !chunk.startsWith("Gear"))
        {
            if(energy > 0.01F)
                energy = 1.0F + (energy - 0.01F) / ((FlightModelMain) (super.FM)).Sq.getToughness(part(chunk));
            else
                energy /= 0.01F;
        } else
        {
            energy /= ((FlightModelMain) (super.FM)).Sq.getToughness(part(chunk));
        }
        energy += ((FlightModelMain) (super.FM)).Sq.eAbsorber[part(chunk)];
        int nHits = (int)energy;
        ((FlightModelMain) (super.FM)).Sq.eAbsorber[part(chunk)] = energy - (float)nHits;
        if(nHits > 0)
            setDamager(shot.initiator, nHits);
        nextDMGLevels(nHits, 2, chunk, shot.initiator);
    }

    protected void hitFlesh(int pilotNo, Shot shot, int bodyPart)
    {
        int i = (int)(shot.power * 0.0035F * World.Rnd().nextFloat(0.5F, 1.5F));
        switch(bodyPart)
        {
        case 0: // '\0'
            if(World.Rnd().nextFloat() < 0.05F)
                return;
            if(shot.initiator == World.getPlayerAircraft() && World.cur().isArcade())
                HUD.logCenter("H E A D S H O T");
            i = (int)((float)i * 30F);
            break;

        case 2: // '\002'
            i = (int)((float)i / 3F);
            break;
        }
        debuggunnery("*** Pilot " + pilotNo + " hit for " + i + "% (" + (int)shot.power + " J)");
        ((FlightModelMain) (super.FM)).AS.hitPilot(shot.initiator, pilotNo, i);
        if(((FlightModelMain) (super.FM)).AS.astatePilotStates[pilotNo] > 95 && bodyPart == 0)
            debuggunnery("*** Headshot!.");
    }

    protected float getEnergyPastArmor(float thicknessMM, float angle, Shot shot)
    {
        shot.power -= (double)(shot.powerType != 0 ? 1.0F : 2.0F) * ((double)(thicknessMM * 1700F) * Math.cos(angle));
        return shot.power;
    }

    protected float getEnergyPastArmor(float thicknessMM, Shot shot)
    {
        shot.power -= (shot.powerType != 0 ? 1.0F : 2.0F) * (thicknessMM * 1700F);
        return shot.power;
    }

    public static boolean isArmorPenetrated(float thicknessMM, Shot shot)
    {
        return shot.power > (shot.powerType != 0 ? 1.0F : 2.0F) * (thicknessMM * 1700F);
    }

    protected float getEnergyPastArmor(double thicknessMM, float angle, Shot shot)
    {
        shot.power -= (double)(shot.powerType != 0 ? 1.0F : 2.0F) * (thicknessMM * 1700D * Math.cos(angle));
        return shot.power;
    }

    protected float getEnergyPastArmor(double thicknessMM, Shot shot)
    {
        shot.power -= (double)(shot.powerType != 0 ? 1.0F : 2.0F) * (thicknessMM * 1700D);
        return shot.power;
    }

    public static boolean isArmorPenetrated(double thicknessMM, Shot shot)
    {
        return (double)shot.power > (double)(shot.powerType != 0 ? 1.0F : 2.0F) * (thicknessMM * 1700D);
    }

    protected void netHits(int hits, int typeHit, int part, Actor initiator)
    {
        if(isNetMaster())
            setDamager(initiator, hits);
        while(hits-- > 0) 
            nextDMGLevel(partNames[part] + "_D0", typeHit, initiator);
    }

    public int curDMGProp(int prop)
    {
        String chunk = "Prop" + (prop + 1) + "_D1";
        HierMesh m = hierMesh();
        if(m.chunkFindCheck(chunk) < 0)
            return 0;
        return !m.isChunkVisible(chunk) ? 0 : 1;
    }

    protected void addGun(BulletEmitter gun, int trigger)
    {
        if(this == World.getPlayerAircraft() && !World.cur().diffCur.Limited_Ammo)
            gun.loadBullets(-1);
        String hook = gun.getHookName();
        if(hook == null)
            return;
        BulletEmitter guns[] = ((FlightModelMain) (super.FM)).CT.Weapons[trigger];
        int len;
        if(guns == null)
            len = 0;
        else
            len = guns.length;
        BulletEmitter newguns[] = new BulletEmitter[len + 1];
        int i;
        for(i = 0; i < len; i++)
            newguns[i] = guns[i];

        newguns[i] = gun;
        ((FlightModelMain) (super.FM)).CT.Weapons[trigger] = newguns;
        if(gun.isEnablePause())
            super.bGunPodsExist = true;
    }

    public void detachGun(int chunkIndx)
    {
        if(super.FM == null || ((FlightModelMain) (super.FM)).CT == null || ((FlightModelMain) (super.FM)).CT.Weapons == null)
            return;
        for(int i = 0; i < ((FlightModelMain) (super.FM)).CT.Weapons.length; i++)
        {
            BulletEmitter gun[] = ((FlightModelMain) (super.FM)).CT.Weapons[i];
            if(gun != null)
            {
                for(int j = 0; j < gun.length; j++)
                    gun[j] = gun[j].detach(hierMesh(), chunkIndx);

            }
        }

    }

    public Gun getGunByHookName(String hookName)
    {
        for(int i = 0; i < ((FlightModelMain) (super.FM)).CT.Weapons.length; i++)
        {
            BulletEmitter gun[] = ((FlightModelMain) (super.FM)).CT.Weapons[i];
            if(gun != null)
            {
                for(int j = 0; j < gun.length; j++)
                    if(gun[j] instanceof Gun)
                    {
                        Gun g = (Gun)gun[j];
                        if(hookName.equals(g.getHookName()))
                            return g;
                    }

            }
        }

        return GunEmpty.get();
    }

    public BulletEmitter getBulletEmitterByHookName(String hookName)
    {
        for(int i = 0; i < ((FlightModelMain) (super.FM)).CT.Weapons.length; i++)
        {
            BulletEmitter gun[] = ((FlightModelMain) (super.FM)).CT.Weapons[i];
            if(gun != null)
            {
                for(int j = 0; j < gun.length; j++)
                    if(hookName.equals(gun[j].getHookName()))
                        return gun[j];

            }
        }

        return GunEmpty.get();
    }

    public static void moveGear(HierMesh hiermesh, float f)
    {
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
    }

    protected void moveGear(float alpha)
    {
        moveGear(hierMesh(), alpha);
    }

    protected void moveGear(float left, float right, float center)
    {
        moveGear(hierMesh(), left, right, center);
        moveGear(left);
    }

    public void forceGear(float alpha)
    {
        moveGear(alpha, alpha, alpha);
    }

    public static void forceGear(Class airClass, HierMesh hMesh, float alpha)
    {
        try
        {
            Method method = airClass.getMethod("moveGear", new Class[] {
                com.maddox.il2.engine.HierMesh.class, Float.TYPE, Float.TYPE, Float.TYPE
            });
            method.invoke(null, new Object[] {
                hMesh, new Float(alpha), new Float(alpha), new Float(alpha)
            });
            method = airClass.getMethod("moveGear", new Class[] {
                com.maddox.il2.engine.HierMesh.class, Float.TYPE
            });
            method.invoke(null, new Object[] {
                hMesh, new Float(alpha)
            });
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void moveArrestorHook(float f)
    {
    }

    protected void moveWingFold(HierMesh hiermesh, float f)
    {
    }

    public void moveWingFold(float f)
    {
    }

    public void moveCockpitDoor(float f)
    {
    }

    protected void moveRudder(float f)
    {
    }

    protected void moveElevator(float f)
    {
    }

    protected void moveAileron(float f)
    {
    }

    protected void moveFlap(float f)
    {
    }

    protected void moveBayDoor(float f)
    {
    }

    protected void moveAirBrake(float f)
    {
    }

    protected void moveRefuel(float f)
    {
    }

    protected void moveVarWing(float f)
    {
    }

    public void moveSteering(float f)
    {
    }

    public void moveWheelSink()
    {
    }

    public void rareAction(float f, boolean flag)
    {
    }

    public float getBayDoor()
    {
        return BayDoor_;
    }

    protected void moveFan(float dt)
    {
        int tmpProp = 0;
        for(int i = 0; i < ((FlightModelMain) (super.FM)).EI.getNum(); i++)
        {
            if(oldProp[i] < 2)
            {
                tmpProp = Math.abs((int)(((FlightModelMain) (super.FM)).EI.engines[i].getAPropw() * 0.06F));
                if(tmpProp >= 1)
                    tmpProp = 1;
                if(tmpProp != oldProp[i] && hierMesh().isChunkVisible(Props[i][oldProp[i]]))
                {
                    hierMesh().chunkVisible(Props[i][oldProp[i]], false);
                    oldProp[i] = tmpProp;
                    hierMesh().chunkVisible(Props[i][tmpProp], true);
                }
            }
            if(tmpProp == 0)
            {
                propPos[i] = (propPos[i] + 57.3F * ((FlightModelMain) (super.FM)).EI.engines[i].getAPropw() * dt) % 360F;
            } else
            {
                float angV = 57.3F * ((FlightModelMain) (super.FM)).EI.engines[i].getAPropw();
                angV %= 2880F;
                angV /= 2880F;
                if(angV <= 0.5F)
                    angV *= 2.0F;
                else
                    angV = angV * 2.0F - 2.0F;
                angV *= 1200F;
                propPos[i] = (propPos[i] + angV * dt) % 360F;
            }
            hierMesh().chunkSetAngles(Props[i][0], 0.0F, -propPos[i], 0.0F);
        }

    }

    public void hitProp(int prop, int typeHit, Actor initiator)
    {
        if(prop > ((FlightModelMain) (super.FM)).EI.getNum() - 1 || oldProp[prop] == 2)
            return;
        super.hitProp(prop, typeHit, initiator);
        super.FM.cut(part("Engine" + (prop + 1)), typeHit, initiator);
        if(isChunkAnyDamageVisible("Prop" + (prop + 1)) || isChunkAnyDamageVisible("PropRot" + (prop + 1)))
        {
            hierMesh().chunkVisible(Props[prop][0], false);
            hierMesh().chunkVisible(Props[prop][1], false);
            hierMesh().chunkVisible(Props[prop][2], true);
        }
        ((FlightModelMain) (super.FM)).EI.engines[prop].setFricCoeffT(1.0F);
        ((FlightModelMain) (super.FM)).EI.engines[prop].bPropHit = true;
        oldProp[prop] = 2;
    }

    public void updateLLights()
    {
        super.pos.getRender(Actor._tmpLoc);
        if(lLight == null)
        {
            if(Actor._tmpLoc.getX() < 1.0D)
                return;
            lLight = new LightPointWorld[4];
            for(int i = 0; i < 4; i++)
            {
                lLight[i] = new LightPointWorld();
                lLight[i].setColor(0.4941176F, 0.9098039F, 0.9607843F);
                lLight[i].setEmit(0.0F, 0.0F);
                try
                {
                    lLightHook[i] = new HookNamed(this, "_LandingLight0" + i);
                }
                catch(Exception exception) { }
            }

            return;
        }
        for(int i = 0; i < 4; i++)
            if(((FlightModelMain) (super.FM)).AS.astateLandingLightEffects[i] != null)
            {
                lLightLoc1.set(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
                lLightHook[i].computePos(this, Actor._tmpLoc, lLightLoc1);
                lLightLoc1.get(lLightP1);
                lLightLoc1.set(1000D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
                lLightHook[i].computePos(this, Actor._tmpLoc, lLightLoc1);
                lLightLoc1.get(lLightP2);
                Engine.land();
                if(Landscape.rayHitHQ(lLightP1, lLightP2, lLightPL))
                {
                    lLightPL.z++;
                    lLightP2.interpolate(lLightP1, lLightPL, 0.95F);
                    lLight[i].setPos(lLightP2);
                    float d = (float)lLightP1.distance(lLightPL);
                    float r = d * 0.5F + 30F;
                    float in = 0.5F - (0.5F * d) / 1000F;
                    lLight[i].setEmit(in, r);
                } else
                {
                    lLight[i].setEmit(0.0F, 0.0F);
                }
            } else
            if(lLight[i].getR() != 0.0F)
                lLight[i].setEmit(0.0F, 0.0F);

    }

    public boolean isUnderWater()
    {
        Point3d p = super.pos.getAbsPoint();
        if(!Engine.land().isWater(((Tuple3d) (p)).x, ((Tuple3d) (p)).y))
            return false;
        return ((Tuple3d) (p)).z < 0.0D;
    }

    public void update(float dt)
    {
        super.update(dt);
        if(this == World.getPlayerAircraft())
        {
            if(isUnderWater())
                World.doPlayerUnderWater();
            EventLog.flyPlayer(super.pos.getAbsPoint());
            if(this instanceof TypeBomber)
                ((TypeBomber)this).typeBomberUpdate(dt);
        }
        Controls CT = ((FlightModelMain) (super.FM)).CT;
        moveFan(dt);
        if(CT.bHasGearControl)
        {
            float gL = CT.getGearL();
            float gR = CT.getGearR();
            float gC = CT.getGearC();
            if(Math.abs(GearL_ - gL) > 0.003F)
            {
                if(!(this instanceof I_16))
                    if(Math.abs(gL - CT.GearControl) <= 0.003F)
                        sfxGear(false);
                    else
                        sfxGear(true);
                moveGear(GearL_ = gL, GearR_ = gR, GearC_ = gC);
            } else
            if(Math.abs(GearR_ - gR) > 0.003F)
            {
                if(!(this instanceof I_16))
                    if(Math.abs(gR - CT.GearControl) <= 0.003F)
                        sfxGear(false);
                    else
                        sfxGear(true);
                moveGear(GearL_ = gL, GearR_ = gR, GearC_ = gC);
            } else
            if(Math.abs(GearC_ - gC) > 0.003F)
            {
                if(!(this instanceof I_16))
                    if(Math.abs(gC - CT.GearControl) <= 0.003F)
                        sfxGear(false);
                    else
                        sfxGear(true);
                moveGear(GearL_ = gL, GearR_ = gR, GearC_ = gC);
            }
        }
        float f;
        if(CT.bHasArrestorControl)
        {
            f = CT.getArrestor();
            if(Math.abs(arrestor_ - f) > 0.003F)
                moveArrestorHook(arrestor_ = f);
        }
        if(CT.bHasWingControl)
        {
            f = CT.getWing();
            if(Math.abs(wingfold_ - f) > 0.0005F)
                moveWingFold(wingfold_ = f);
        }
        if(CT.bHasCockpitDoorControl)
        {
            f = CT.getCockpitDoor();
            if(Math.abs(cockpitDoor_ - f) > 0.0005F)
                moveCockpitDoor(cockpitDoor_ = f);
        }
        if(CT.bHasFlapsControl)
        {
            f = CT.getFlap();
            if(Math.abs(Flap_ - f) > 0.003F)
            {
                if(Math.abs(f - CT.FlapsControl) <= 0.003F)
                    sfxFlaps(false);
                else
                    sfxFlaps(true);
                moveFlap(Flap_ = f);
            }
        }
        if(CT.bHasVarWingControl)
        {
            float f_102x_ = CT.getVarWing();
            if(Math.abs(VarWing_ - f_102x_) > 0.003F)
            {
                if(Math.abs(f_102x_ - CT.VarWingControl) <= 0.003F)
                    sfxFlaps(false);
                else
                    sfxFlaps(true);
                moveVarWing(VarWing_ = f_102x_);
            }
        }
        f = CT.getRefuel();
        if(Math.abs(Refuel_ - f) > 0.003F)
        {
            moveRefuel(Refuel_ = f);
            if(Math.abs(Refuel_ - 0.5F) >= 0.48F)
                sfxAirBrake();
        }
        if(!isNet() || !isNetMirror())
        {
            f = CT.getRudder();
            if(Math.abs(Rudder_ - f) > 0.003F)
                moveRudder(Rudder_ = f);
            f = CT.getElevator();
            if(Math.abs(Elevator_ - f) > 0.003F)
                moveElevator(Elevator_ = f);
            f = CT.getAileron();
            if(Math.abs(Aileron_ - f) > 0.003F)
                moveAileron(Aileron_ = f);
        }
        f = CT.getBayDoor();
        if(Math.abs(BayDoor_ - f) > 0.025F)
        {
            BayDoor_ += 0.025F * (f <= BayDoor_ ? -1F : 2.0F);
            moveBayDoor(BayDoor_);
        }
        f = CT.getAirBrake();
        if(Math.abs(AirBrake_ - f) > 0.003F)
        {
            moveAirBrake(AirBrake_ = f);
            if(Math.abs(AirBrake_ - 0.5F) >= 0.48F)
                sfxAirBrake();
        }
        f = ((FlightModelMain) (super.FM)).Gears.getSteeringAngle();
        if(Math.abs(Steering_ - f) > 0.003F)
            moveSteering(Steering_ = f);
        if(((FlightModelMain) (super.FM)).Gears.nearGround())
            moveWheelSink();
        if(Mission.isSingle())
        {
            if(this == World.getPlayerAircraft())
            {
                RealFlightModel fm = (RealFlightModel)World.getPlayerFM();
                if(fm.isRealMode() && isAircraftTaxing())
                {
                    Maneuver.updateCollisionMap(fm);
                    taxHlpX -= 1.0F * dt;
                } else
                {
                    showTaxingWay = false;
                }
            }
        } else
        {
            if(Mission.isCoop() && this == World.getPlayerAircraft())
                if(isAircraftTaxing())
                    taxHlpX -= 1.0F * dt;
                else
                    showTaxingWay = false;
            if(Mission.isServer() && isNetPlayer() && isAircraftTaxing())
                Maneuver.updateCollisionMap(super.FM);
        }
    }

    public void setFM(int fmType, boolean bMaster)
    {
        setFM(Property.stringValue(getClass(), "FlightModel", null), fmType, bMaster);
    }

    public void setFM(String fmName, int fmType, boolean bMaster)
    {
        if(this instanceof JU_88MSTL)
            fmType = 1;
        switch(fmType)
        {
        case 0: // '\0'
        default:
            super.FM = new Pilot(fmName);
            break;

        case 1: // '\001'
            super.FM = new RealFlightModel(fmName);
            break;

        case 2: // '\002'
            super.FM = new FlightModel(fmName);
            super.FM.AP = new Autopilotage();
            break;
        }
        super.FM.actor = this;
        ((FlightModelMain) (super.FM)).AS.set(this, bMaster && !NetMissionTrack.isPlaying());
        ((FlightModelMain) (super.FM)).EI.setNotMirror(bMaster && !NetMissionTrack.isPlaying());
        SectFile I = FlightModelMain.sectFile(fmName);
        int ft = 0;
        String fs = I.get("SOUND", "FeedType", "PNEUMATIC");
        if(fs.compareToIgnoreCase("PNEUMATIC") == 0)
            ft = 0;
        else
        if(fs.compareToIgnoreCase("ELECTRIC") == 0)
            ft = 1;
        else
        if(fs.compareToIgnoreCase("HYDRAULIC") == 0)
            ft = 2;
        else
            System.out.println("ERROR: Invalid feed type" + fs);
        super.FM.set(hierMesh());
        forceGear(getClass(), hierMesh(), 1.0F);
        ((FlightModelMain) (super.FM)).Gears.computePlaneLandPose(super.FM);
        forceGear(getClass(), hierMesh(), 0.0F);
        ((FlightModelMain) (super.FM)).EI.set(this);
        initSound(I);
        sfxInit(ft);
        interpPut(super.FM, "FlightModel", Time.current(), null);
    }

    public void destroy()
    {
        if(isAlive() && Mission.isPlaying() && name().charAt(0) != ' ' && super.FM != null)
        {
            Front.checkAircraftCaptured(this);
            World.onActorDied(this, World.remover);
        }
        if(lLight != null)
        {
            for(int i = 0; i < 4; i++)
                ObjState.destroy(lLight[i]);

        }
        if(World.getPlayerAircraft() == this)
            deleteCockpits();
        Wing wing = getWing();
        if(Actor.isValid(wing) && (wing instanceof NetWing))
            wing.destroy();
        detachGun(-1);
        super.destroy();
        _removeMesh();
    }

    public Object getSwitchListener(Message msg)
    {
        return this;
    }

    public Aircraft()
    {
        BT_class = null;
        BT = 0;
        Refuel_ = 0.0F;
        spawnLocSingleCoop = null;
        spawnActorName = null;
        stationarySpawnLocSet = false;
        timePostEndAction = -1L;
        buried = false;
        BayDoor_ = 0.0F;
        AirBrake_ = 0.0F;
        Steering_ = 0.0F;
        wingfold_ = 0.0F;
        cockpitDoor_ = 0.0F;
        arrestor_ = 0.0F;
        oldProp = new int[8];
        lLightHook = new Hook[4];
        typedName = "UNKNOWN";
        wfrGr21dropped = false;
        bombScoreOwner = null;
        hasHumanOnlineBomber = false;
        headingBug = 0.0F;
        idleTimeOnCarrier = 0;
        bSpotter = false;
        currBomb_M = 100F;
        currBomb_Kalibr = 0.32F;
        currBomb_Type = 0;
        currBomb_Crutch = 0.0F;
        checkLoadingCountry();
        if(_loadingCountry == null)
            _setMesh(Property.stringValue(getClass(), "meshName", null));
        else
            _setMesh(Property.stringValue(getClass(), "meshName_" + _loadingCountry, null));
        collide(true);
        drawing(true);
        dreamFire(true);
    }

    private void checkLoadingCountry()
    {
        _loadingCountry = null;
        if(NetAircraft.loadingCountry == null)
            return;
        Class clazz = getClass();
        if(Property.value(clazz, "PaintScheme_" + NetAircraft.loadingCountry) != null && Property.stringValue(clazz, "meshName_" + NetAircraft.loadingCountry, null) != null)
            _loadingCountry = NetAircraft.loadingCountry;
    }

    public static String getPropertyMeshDemo(Class cls, String country)
    {
        String propName = "meshNameDemo";
        String res = Property.stringValue(cls, propName, null);
        if(res != null)
            return res;
        else
            return getPropertyMesh(cls, country);
    }

    public static String getPropertyMesh(Class cls, String country)
    {
        String propName = "meshName";
        String res = null;
        if(country != null)
            res = Property.stringValue(cls, propName + "_" + country, null);
        if(res == null)
            res = Property.stringValue(cls, propName);
        return res;
    }

    public static PaintScheme getPropertyPaintScheme(Class cls, String country)
    {
        String propName = "PaintScheme";
        PaintScheme res = null;
        if(country != null)
            res = (PaintScheme)Property.value(cls, propName + "_" + country, null);
        if(res == null)
            res = (PaintScheme)Property.value(cls, propName);
        return res;
    }

    public String typedName()
    {
        return typedName;
    }

    private void correctTypedName()
    {
        if(typedName != null && typedName.indexOf('_') >= 0)
        {
            StringBuffer buf = new StringBuffer();
            int n = typedName.length();
            for(int i = 0; i < n; i++)
            {
                char ch = typedName.charAt(i);
                if(ch != '_')
                    buf.append(ch);
            }

            typedName = buf.toString();
        }
    }

    public void preparePaintScheme()
    {
        PaintScheme scheme = getPropertyPaintScheme(getClass(), _loadingCountry);
        if(scheme != null)
        {
            scheme.prepare(this, super.bPaintShemeNumberOn);
            typedName = scheme.typedName(this);
            correctTypedName();
        }
    }

    public void preparePaintScheme(int tacticNumber)
    {
        PaintScheme scheme = getPropertyPaintScheme(getClass(), _loadingCountry);
        if(scheme != null)
        {
            scheme.prepareNum(this, tacticNumber, super.bPaintShemeNumberOn);
            typedName = scheme.typedNameNum(this, tacticNumber);
            correctTypedName();
        }
    }

    public void prepareCamouflage()
    {
        String meshName = getPropertyMesh(getClass(), _loadingCountry);
        prepareMeshCamouflage(meshName, hierMesh(), getClass(), getRegiment());
    }

    public static void prepareMeshCamouflage(String meshName, HierMesh hierMesh, Class airClass, Regiment reg)
    {
        prepareMeshCamouflage(meshName, hierMesh, null, airClass, reg);
    }

    public static void prepareMeshCamouflage(String meshName, HierMesh hierMesh, String skinDir, Class airClass, Regiment reg)
    {
        prepareMeshCamouflage(meshName, hierMesh, skinDir, null, airClass, reg);
    }

    public static void prepareMeshCamouflage(String meshName, HierMesh hierMesh, String skinDir, Mat cacheMat[], Class airClass, Regiment reg)
    {
        if(!Config.isUSE_RENDER())
            return;
        String meshDir = meshName.substring(0, meshName.lastIndexOf('/') + 1);
        String customSkinPrefix = "";
        if(airClass != null)
            try
            {
                Method method = airClass.getMethod("getSkinPrefix", new Class[] {
                    java.lang.String.class, com.maddox.il2.ai.Regiment.class
                });
                customSkinPrefix = (String)method.invoke(null, new Object[] {
                    new String(meshName), reg
                });
            }
            catch(Exception e)
            {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        if(skinDir == null)
        {
            String mainCamo;
            switch(World.cur().camouflage)
            {
            case 0: // '\0'
                mainCamo = "summer";
                break;

            case 1: // '\001'
                mainCamo = "winter";
                break;

            case 2: // '\002'
                mainCamo = "desert";
                break;

            case 3: // '\003'
                mainCamo = "pacific";
                break;

            case 4: // '\004'
                mainCamo = "eto";
                break;

            case 5: // '\005'
                mainCamo = "mto";
                break;

            case 6: // '\006'
                mainCamo = "cbi";
                break;

            default:
                mainCamo = "summer";
                break;
            }
            String subDir = customSkinPrefix + mainCamo;
            if(!existSFSFile(meshDir + subDir + "/skin1o.tga"))
                if(World.cur().camouflage == 5)
                {
                    subDir = customSkinPrefix + "desert";
                    if(!existSFSFile(meshDir + subDir + "/skin1o.tga"))
                        subDir = mainCamo;
                    if(!existSFSFile(meshDir + subDir + "/skin1o.tga"))
                        subDir = "desert";
                    if(!existSFSFile(meshDir + subDir + "/skin1o.tga"))
                        subDir = "summer";
                    if(!existSFSFile(meshDir + subDir + "/skin1o.tga"))
                        return;
                } else
                {
                    subDir = customSkinPrefix + "summer";
                    if(!existSFSFile(meshDir + subDir + "/skin1o.tga"))
                        subDir = mainCamo;
                    if(!existSFSFile(meshDir + subDir + "/skin1o.tga"))
                        subDir = "summer";
                    if(!existSFSFile(meshDir + subDir + "/skin1o.tga"))
                        return;
                }
            skinDir = meshDir + subDir;
        }
        String newSkin[] = {
            skinDir + "/skin1o.tga", skinDir + "/skin1p.tga", skinDir + "/skin1q.tga"
        };
        int layer[] = new int[4];
        for(int m = 0; m < _skinMat.length; m++)
        {
            int iMat = hierMesh.materialFind(_skinMat[m]);
            if(iMat >= 0)
            {
                Mat curMat = hierMesh.material(iMat);
                boolean bDoChange = false;
                for(int l = 0; l < 4; l++)
                {
                    layer[l] = -1;
                    if(curMat.isValidLayer(l))
                    {
                        curMat.setLayer(l);
                        String tex = curMat.get('\0');
                        for(int s = 0; s < 3; s++)
                        {
                            if(!tex.regionMatches(true, tex.length() - 10, _curSkin[s], 0, 10))
                                continue;
                            layer[l] = s;
                            bDoChange = true;
                            break;
                        }

                    }
                }

                if(bDoChange)
                {
                    String newMatName = skinDir + "/" + _skinMat[m] + ".mat";
                    Mat newMat;
                    if(FObj.Exist(newMatName))
                    {
                        newMat = (Mat)FObj.Get(newMatName);
                    } else
                    {
                        newMat = (Mat)curMat.Clone();
                        newMat.Rename(newMatName);
                        for(int l = 0; l < 4; l++)
                            if(layer[l] >= 0)
                            {
                                newMat.setLayer(l);
                                newMat.set('\0', newSkin[layer[l]]);
                            }

                    }
                    if(cacheMat != null)
                    {
                        for(int l = 0; l < 4; l++)
                            if(layer[l] >= 0)
                                cacheMat[layer[l]] = newMat;

                    }
                    hierMesh.materialReplace(_skinMat[m], newMat);
                }
            }
        }

    }

    public static String getSkinPrefix(String meshName, Regiment reg)
    {
        return "";
    }

    public static boolean prepareMeshSkin(String meshName, HierMesh hierMesh, String skinBmp, String skinDir, Regiment reg)
    {
        String srcTga;
        srcTga = meshName;
        int i = srcTga.lastIndexOf('/');
        if(i >= 0)
            srcTga = srcTga.substring(0, i + 1) + "summer";
        else
            srcTga = srcTga + "summer";
        try
        {
            File dir = new File(HomePath.toFileSystemName(skinDir, 0));
            if(!dir.isDirectory())
                dir.mkdir();
        }
        catch(Exception e)
        {
            return false;
        }
        if(!BmpUtils.bmp8PalTo4TGA4(skinBmp, srcTga, skinDir))
            return false;
        if(skinDir == null)
            return false;
        try
        {
            prepareMeshCamouflage(meshName, hierMesh, skinDir, null, reg);
        }
        catch(Exception e)
        {
            return false;
        }
        return true;
    }

    public static void prepareMeshPilot(HierMesh hierMesh, int indxPilot, String newMatName, String newTgaName)
    {
        prepareMeshPilot(hierMesh, indxPilot, newMatName, newTgaName, null);
    }

    public static void prepareMeshPilot(HierMesh hierMesh, int indxPilot, String newMatName, String newTgaName, Mat cacheMat[])
    {
        if(!Config.isUSE_RENDER())
            return;
        String matName = "Pilot" + (1 + indxPilot);
        int iMat = hierMesh.materialFind(matName);
        if(iMat < 0)
            return;
        Mat newMat;
        if(FObj.Exist(newMatName))
        {
            newMat = (Mat)FObj.Get(newMatName);
        } else
        {
            Mat curMat = hierMesh.material(iMat);
            newMat = (Mat)curMat.Clone();
            newMat.Rename(newMatName);
            newMat.setLayer(0);
            newMat.set('\0', newTgaName);
        }
        if(cacheMat != null)
            cacheMat[0] = newMat;
        hierMesh.materialReplace(matName, newMat);
    }

    public static void prepareMeshNoseart(HierMesh hierMesh, String newMatName0, String newMatName1, String newTgaName0, String newTgaName1)
    {
        prepareMeshNoseart(hierMesh, newMatName0, newMatName1, newTgaName0, newTgaName1, null);
    }

    public static void prepareMeshNoseart(HierMesh hierMesh, String newMatName0, String newMatName1, String newTgaName0, String newTgaName1, Mat cacheMat[])
    {
        if(!Config.isUSE_RENDER())
            return;
        String matName = "Overlay9";
        int iMat = hierMesh.materialFind(matName);
        if(iMat < 0)
            return;
        Mat newMat;
        if(FObj.Exist(newMatName0))
        {
            newMat = (Mat)FObj.Get(newMatName0);
        } else
        {
            Mat curMat = hierMesh.material(iMat);
            newMat = (Mat)curMat.Clone();
            newMat.Rename(newMatName0);
            newMat.setLayer(0);
            newMat.set('\0', newTgaName0);
        }
        if(cacheMat != null)
            cacheMat[0] = newMat;
        hierMesh.materialReplace(matName, newMat);
        matName = "OverlayA";
        iMat = hierMesh.materialFind(matName);
        if(iMat < 0)
            return;
        if(FObj.Exist(newMatName1))
        {
            newMat = (Mat)FObj.Get(newMatName1);
        } else
        {
            Mat curMat = hierMesh.material(iMat);
            newMat = (Mat)curMat.Clone();
            newMat.Rename(newMatName1);
            newMat.setLayer(0);
            newMat.set('\0', newTgaName1);
        }
        if(cacheMat != null)
            cacheMat[1] = newMat;
        hierMesh.materialReplace(matName, newMat);
    }

    private static boolean existSFSFile(String nameFile)
    {
        try
        {
            SFSInputStream f = new SFSInputStream(nameFile);
            f.close();
        }
        catch(Exception e)
        {
            return false;
        }
        return true;
    }

    public double getSpeed(Vector3d vect)
    {
        if(super.FM == null)
        {
            if(vect != null)
                vect.set(0.0D, 0.0D, 0.0D);
            return 0.0D;
        }
        if(vect != null)
            vect.set(((FlightModelMain) (super.FM)).Vwld);
        return ((FlightModelMain) (super.FM)).Vwld.length();
    }

    public void setSpeed(Vector3d vect)
    {
        super.setSpeed(vect);
        ((FlightModelMain) (super.FM)).Vwld.set(vect);
    }

    public void setOnGround(Point3d p, Orient o, Vector3d v)
    {
        ((FlightModelMain) (super.FM)).CT.setLanded();
        forceGear(getClass(), hierMesh(), ((FlightModelMain) (super.FM)).CT.getGear());
        if(p != null && o != null)
        {
            super.pos.setAbs(p, o);
            super.pos.reset();
        }
        if(v != null)
            setSpeed(v);
    }

    public void load(final SectFile in, final String name, final int indxInWing, final NetChannel channel, final int idRemote) throws Exception {
        if (this == World.getPlayerAircraft()) {
            this.setFM(1, true);
            World.setPlayerFM();
        }
        else if (channel != null) {
            this.setFM(2, false);
        }
        else {
            this.setFM(0, true);
        }
        final String spawActor = in.get(name, "spawn" + indxInWing, "");
        if (!spawActor.equals("")) {
            this.spawnActorName = spawActor;
            final int iSect = in.sectionIndex("NStationary");
            if (iSect >= 0) {
                for (int n = in.vars(iSect), i = 0; i < n; ++i) {
                    final NumberTokenizer t = new NumberTokenizer(in.line(iSect, i));
                    final String stationaryObjectName = t.next("");
                    final String className = t.next("");
                    if (stationaryObjectName.equals(spawActor) && className.startsWith("vehicles.planes.Plane")) {
                        t.next(0);
                        final double x = t.next(0.0);
                        final double y = t.next(0.0);
                        final float azi = t.next(0.0f);
                        this.spawnLocSingleCoop = new Loc(x, y, 0.0, azi, 0.0f, 0.0f);
                        break;
                    }
                }
            }
        }
        if (in.exist(name, "Skill" + indxInWing)) {
            ((SndAircraft)this).FM.setSkill(in.get(name, "Skill" + indxInWing, 1));
        }
        else {
            ((SndAircraft)this).FM.setSkill(in.get(name, "Skill", 1));
        }
        ((FlightModelMain)((SndAircraft)this).FM).M.fuel = in.get(name, "Fuel", 100.0f, 0.0f, 100.0f) * 0.01f * ((FlightModelMain)((SndAircraft)this).FM).M.maxFuel;
        if (in.exist(name, "numberOn" + indxInWing)) {
            super.bPaintShemeNumberOn = (in.get(name, "numberOn" + indxInWing, 1, 0, 1) == 1);
        }
        ((FlightModelMain)((SndAircraft)this).FM).AS.bIsEnableToBailout = (in.get(name, "Parachute", 1, 0, 1) == 1);
        if (Mission.isServer()) {
            this.createNetObject((NetChannel)null, 0);
        }
        else if (channel != null) {
            this.createNetObject(channel, idRemote);
        }
        if (((Actor)this).net != null) {
            ((NetAircraft.AircraftNet)((Actor)this).net).netName = ((Actor)this).name();
            ((NetAircraft.AircraftNet)((Actor)this).net).netUser = null;
        }
        final String section = String.valueOf(name) + "_weapons";
        final int nsect = in.sectionIndex(section);
        if (nsect >= 0) {
            for (int nvars = in.vars(nsect), j = 0; j < nvars; ++j) {
                final NumberTokenizer nt = new NumberTokenizer(in.line(nsect, j));
                final int trigger = nt.next(9, 0, 19);
                final String hook = nt.next();
                final String weapName = nt.next();
                final Class weapClass = ObjIO.classForName("weapons." + weapName);
                final Object obj = weapClass.newInstance();
                if (obj instanceof BulletEmitter) {
                    final BulletEmitter gun = (BulletEmitter)obj;
                    gun.set((Actor)this, hook, dumpName(hook));
                    final int bullets = nt.next(-12345);
                    if (bullets == -12345) {
                        gun.loadBullets();
                    }
                    else {
                        gun._loadBullets(bullets);
                    }
                    this.addGun(gun, trigger);
                }
            }
        }
        else {
            super.thisWeaponsName = in.get(name, "weapons", (String)null);
            if (super.thisWeaponsName != null) {
                this.weaponsLoad(this, super.thisWeaponsName);
            }
        }
        if (this == World.getPlayerAircraft()) {
            this.createCockpits();
        }
        this.onAircraftLoaded();
        ((FlightModelMain)((SndAircraft)this).FM).Gears.zutiCheckPlaneForSkisAndWinterCamo(this.getClass().toString());
    }

    private static String dumpName(String hook)
    {
        int n;
        for(n = hook.length() - 1; n >= 0; n--)
            if(!Character.isDigit(hook.charAt(n)))
                break;

        n++;
        return hook.substring(0, n) + "Dump" + hook.substring(n);
    }

    public boolean turretAngles(int turretID, float angles[])
    {
        for(int i = 0; i < 2; i++)
        {
            angles[i] = (angles[i] + 3600F) % 360F;
            if(angles[i] > 180F)
                angles[i] -= 360F;
        }

        angles[2] = 0.0F;
        return true;
    }

    public int WeaponsMask()
    {
        return -1;
    }

    public int HitbyMask() {
        try {
            return (((FlightModelMain)((SndAircraft)this).FM).Vwld.length() < 2.0) ? -1 : -25;
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public int chooseBulletType(BulletProperties bullet[])
    {
        if(super.FM.isTakenMortalDamage())
            return -1;
        if(bullet.length == 1)
            return 0;
        if(bullet.length <= 0)
            return -1;
        if(bullet[0].power <= 0.0F)
            return 1;
        if(bullet[1].power <= 0.0F)
            return 0;
        if(bullet[0].powerType == 1)
            return 0;
        if(bullet[1].powerType == 1)
            return 1;
        if(bullet[0].powerType == 0)
            return 0;
        if(bullet[1].powerType == 0)
            return 1;
        return bullet[0].powerType != 2 ? 0 : 1;
    }

    public int chooseShotpoint(BulletProperties bullet)
    {
        return !super.FM.isTakenMortalDamage() ? 0 : -1;
    }

    public boolean getShotpointOffset(int shotpointIdx, Point3d offs)
    {
        if(super.FM.isTakenMortalDamage())
            return false;
        if(shotpointIdx != 0)
            return false;
        if(offs != null)
            offs.set(0.0D, 0.0D, 0.0D);
        return true;
    }

    public float AttackMaxDistance()
    {
        return 1500F;
    }

    private static int[] getSwTbl(int f2)
    {
        if(f2 < 0)
            f2 = -f2;
        int len = f2 % 16 + 11;
        int ofs = f2 % Finger.kTable.length;
        if(len < 0)
            len = -len % 16;
        if(len < 10)
            len = 10;
        if(ofs < 0)
            ofs = -ofs % Finger.kTable.length;
        int kt[] = new int[len];
        for(int i = 0; i < len; i++)
            kt[i] = Finger.kTable[(ofs + i) % Finger.kTable.length];

        return kt;
    }

    public static void weapons(Class clazz)
    {
        try
        {
            int fi = Finger.Int("ce" + clazz.getName() + "vd");
            BufferedReader f = new BufferedReader(new InputStreamReader(new KryptoInputFilter(new SFSInputStream(Finger.LongFN(0L, "cod/" + Finger.incInt(fi, "adt"))), getSwTbl(fi))));
            ArrayList lst = weaponsListProperty(clazz);
            HashMapInt map = weaponsMapProperty(clazz);
            do
            {
                String line = f.readLine();
                if(line == null)
                    break;
                StringTokenizer st = new StringTokenizer(line, ",");
                int n = st.countTokens() - 1;
                String weaponsName = st.nextToken();
                _WeaponSlot slot[] = new _WeaponSlot[n];
                for(int i = 0; i < n; i++)
                {
                    String sslot = st.nextToken();
                    if(sslot != null && sslot.length() > 3)
                    {
                        NumberTokenizer nt = new NumberTokenizer(sslot);
                        slot[i] = new _WeaponSlot(nt.next(0), nt.next(null), nt.next(-12345));
                    }
                }

                lst.add(weaponsName);
                map.put(Finger.Int(weaponsName), slot);
            } while(true);
            f.close();
        }
        catch(Exception exception) { }
    }

    public long finger(long f)
    {
        Class clazz = getClass();
        f = FlightModelMain.finger(f, Property.stringValue(clazz, "FlightModel", null));
        f = Finger.incLong(f, Property.stringValue(clazz, "meshName", null));
        Object coc = Property.value(clazz, "cockpitClass", null);
        if(coc != null)
            if(coc instanceof Class)
            {
                f = Finger.incLong(f, ((Class)coc).getName());
            } else
            {
                Class cocs[] = (Class[])coc;
                for(int i = 0; i < cocs.length; i++)
                    f = Finger.incLong(f, cocs[i].getName());

            }
        for(int i = 0; i < ((FlightModelMain) (super.FM)).CT.Weapons.length; i++)
        {
            BulletEmitter gun[] = ((FlightModelMain) (super.FM)).CT.Weapons[i];
            if(gun != null)
            {
                for(int j = 0; j < gun.length; j++)
                {
                    BulletEmitter g = gun[j];
                    f = Finger.incLong(f, Property.intValue(g, "_count", 0));
                    if(g instanceof Gun)
                    {
                        GunProperties prop = ((GunGeneric) ((Gun)g)).prop;
                        if(prop != null)
                        {
                            f = Finger.incLong(f, prop.shotFreq);
                            f = Finger.incLong(f, prop.shotFreqDeviation);
                            f = Finger.incLong(f, prop.maxDeltaAngle);
                            f = Finger.incLong(f, prop.bullets);
                            BulletProperties bullet[] = prop.bullet;
                            if(bullet != null)
                            {
                                for(int k = 0; k < bullet.length; k++)
                                {
                                    f = Finger.incLong(f, bullet[k].massa);
                                    f = Finger.incLong(f, bullet[k].kalibr);
                                    f = Finger.incLong(f, bullet[k].speed);
                                    f = Finger.incLong(f, bullet[k].cumulativePower);
                                    f = Finger.incLong(f, bullet[k].power);
                                    f = Finger.incLong(f, bullet[k].powerType);
                                    f = Finger.incLong(f, bullet[k].powerRadius);
                                    f = Finger.incLong(f, bullet[k].timeLife);
                                }

                            }
                        }
                    } else
                    if(g instanceof RocketGun)
                    {
                        RocketGun r = (RocketGun)g;
                        if(r != null)
                        {
                            Class bc = (Class)Property.value(r.getClass(), "bulletClass", null);
                            f = Finger.incLong(f, Property.intValue(r.getClass(), "bullets", 1));
                            f = Finger.incLong(f, Property.floatValue(r.getClass(), "shotFreq", 0.5F));
                            if(bc != null)
                            {
                                f = Finger.incLong(f, Property.floatValue(bc, "radius", 1.0F));
                                f = Finger.incLong(f, Property.floatValue(bc, "timeLife", 1.0F));
                                f = Finger.incLong(f, Property.floatValue(bc, "timeFire", 1.0F));
                                f = Finger.incLong(f, Property.floatValue(bc, "force", 1.0F));
                                f = Finger.incLong(f, Property.floatValue(bc, "power", 1.0F));
                                f = Finger.incLong(f, Property.intValue(bc, "powerType", 1));
                                f = Finger.incLong(f, Property.floatValue(bc, "kalibr", 1.0F));
                                f = Finger.incLong(f, Property.floatValue(bc, "massa", 1.0F));
                                f = Finger.incLong(f, Property.floatValue(bc, "massaEnd", 1.0F));
                            }
                        }
                    } else
                    if(g instanceof BombGun)
                    {
                        BombGun r = (BombGun)g;
                        if(r != null)
                        {
                            Class bc = (Class)Property.value(r.getClass(), "bulletClass", null);
                            f = Finger.incLong(f, Property.intValue(r.getClass(), "bullets", 1));
                            f = Finger.incLong(f, Property.floatValue(r.getClass(), "shotFreq", 0.5F));
                            if(bc != null)
                            {
                                f = Finger.incLong(f, Property.floatValue(bc, "radius", 1.0F));
                                f = Finger.incLong(f, Property.floatValue(bc, "power", 1.0F));
                                f = Finger.incLong(f, Property.intValue(bc, "powerType", 1));
                                f = Finger.incLong(f, Property.floatValue(bc, "kalibr", 1.0F));
                                f = Finger.incLong(f, Property.floatValue(bc, "massa", 1.0F));
                            }
                        }
                    }
                }

            }
        }

        return f;
    }

    protected static void weaponTriggersRegister(Class clazz, int triggerArray[])
    {
        Property.set(clazz, "weaponTriggers", triggerArray);
    }

    public static int[] getWeaponTriggersRegistered(Class clazz)
    {
        return (int[])Property.value(clazz, "weaponTriggers", null);
    }

    protected static void weaponHooksRegister(Class clazz, String hookArray[])
    {
        if(hookArray.length != getWeaponTriggersRegistered(clazz).length)
        {
            throw new RuntimeException("Sizeof 'weaponHooks' != sizeof 'weaponTriggers'");
        } else
        {
            Property.set(clazz, "weaponHooks", hookArray);
            return;
        }
    }

    public static String[] getWeaponHooksRegistered(Class clazz)
    {
        return (String[])Property.value(clazz, "weaponHooks", null);
    }

    protected static void weaponsRegister(Class class1, String s, String as[])
    {
    }

    protected static void weaponsUnRegister(Class clazz, String weaponsName)
    {
        ArrayList lst = weaponsListProperty(clazz);
        HashMapInt map = weaponsMapProperty(clazz);
        int indx = lst.indexOf(weaponsName);
        if(indx < 0)
        {
            return;
        } else
        {
            lst.remove(indx);
            map.remove(Finger.Int(weaponsName));
            return;
        }
    }

    public static String[] getWeaponsRegistered(Class clazz)
    {
        ArrayList lst = weaponsListProperty(clazz);
        HashMapInt map = weaponsMapProperty(clazz);
        String w[] = new String[lst.size()];
        for(int i = 0; i < w.length; i++)
            w[i] = (String)lst.get(i);

        return w;
    }

    public static _WeaponSlot[] getWeaponSlotsRegistered(Class clazz, String weaponsName)
    {
        HashMapInt map = weaponsMapProperty(clazz);
        return (_WeaponSlot[])map.get(Finger.Int(weaponsName));
    }

    public static boolean weaponsExist(Class airClass, String weaponsName)
    {
        Object obj = Property.value(airClass, "weaponsMap", null);
        if(obj == null)
            return false;
        HashMapInt map = (HashMapInt)obj;
        int key = Finger.Int(weaponsName);
        boolean isValid = isWeaponDateOk(airClass, weaponsName);
        return map.containsKey(key) && isValid;
    }

    public static boolean isWeaponDateOk(Class clazz, String weaponName)
    {
        HashMapInt map = weaponsMapProperty(clazz);
        int key = Finger.Int(weaponName);
        if(!map.containsKey(key))
            return true;
        int curDate = Mission.getMissionDate(false);
        if(curDate == 0)
            return true;
        String cleanACName = "";
        try
        {
            cleanACName = clazz.toString().substring(clazz.toString().lastIndexOf(".") + 1, clazz.toString().length());
        }
        catch(Exception e)
        {
            return true;
        }
        String hook[] = getWeaponHooksRegistered(clazz);
        _WeaponSlot slot[] = (_WeaponSlot[])map.get(key);
        for(int i = 0; i < hook.length; i++)
            if(slot[i] != null)
            {
                int dateOfUse = Property.intValue(slot[i].clazz, "dateOfUse_" + cleanACName, 0);
                if(dateOfUse == 0)
                    dateOfUse = Property.intValue(slot[i].clazz, "dateOfUse", 0);
                if(dateOfUse != 0 && curDate < dateOfUse)
                    return false;
            }

        return true;
    }

    protected void weaponsLoad(String weaponsName)
        throws Exception
    {
        weaponsLoad(this, weaponsName);
    }

    protected void weaponsLoad(Aircraft a, String weaponsName)
        throws Exception
    {
        Class clazz = a.getClass();
        HashMapInt map = weaponsMapProperty(clazz);
        int key = Finger.Int(weaponsName);
        if(!map.containsKey(key))
        {
            throw new RuntimeException("Weapon set '" + weaponsName + "' not registered in " + ObjIO.classGetName(clazz));
        } else
        {
            weaponsLoad(a, key, map);
            return;
        }
    }

    protected void weaponsLoad(Aircraft a, int weaponsNameFinger)
        throws Exception
    {
        HashMapInt map = weaponsMapProperty(a.getClass());
        if(!map.containsKey(weaponsNameFinger))
        {
            throw new RuntimeException("Weapon set '" + weaponsNameFinger + "' not registered in " + ObjIO.classGetName(a.getClass()));
        } else
        {
            weaponsLoad(a, weaponsNameFinger, map);
            return;
        }
    }

    protected void weaponsLoad(Aircraft a, int key, HashMapInt map)
        throws Exception
    {
        if(World.getPlayerAircraft() == a)
        {
            Fuze_EL_AZ.reset();
            AircraftLH.clearInfo();
            Torpedo.clearInfo();
        }
        String hook[] = getWeaponHooksRegistered(a.getClass());
        _WeaponSlot slot[] = (_WeaponSlot[])map.get(key);
        for(int i = 0; i < hook.length; i++)
            if(slot[i] != null)
                if(a.mesh().hookFind(hook[i]) != -1)
                {
                    BulletEmitter gun = (BulletEmitter)slot[i].clazz.newInstance();
                    gun.set(a, hook[i], dumpName(hook[i]));
                    if(a.isNet() && a.isNetMirror())
                    {
                        if(!World.cur().diffCur.Limited_Ammo)
                            gun.loadBullets(-1);
                        else
                        if(slot[i].trigger == 2 || slot[i].trigger == 3 || slot[i].trigger >= 10)
                        {
                            if(slot[i].bullets == -12345)
                                gun.loadBullets();
                            else
                                gun._loadBullets(slot[i].bullets);
                        } else
                        {
                            gun.loadBullets(-1);
                        }
                    } else
                    if(slot[i].bullets == -12345)
                        gun.loadBullets();
                    else
                        gun.loadBullets(slot[i].bullets);
                    a.addGun(gun, slot[i].trigger);
                    Property.set(gun, "_count", slot[i].bullets);
                    switch(slot[i].trigger)
                    {
                    case 0: // '\0'
                        if(gun instanceof MGunAircraftGeneric)
                            if(World.getPlayerAircraft() == a)
                                ((MGunAircraftGeneric)gun).setConvDistance(World.cur().userCoverMashineGun, Property.floatValue(a.getClass(), "LOSElevation", 0.75F));
                            else
                            if(a.isNet() && a.isNetPlayer())
                                ((MGunAircraftGeneric)gun).setConvDistance(400F, Property.floatValue(a.getClass(), "LOSElevation", 0.75F));
                            else
                                ((MGunAircraftGeneric)gun).setConvDistance(super.FM.convAI + super.FM.convAI * 0.25F, Property.floatValue(a.getClass(), "LOSElevation", 0.75F));
                        break;

                    case 1: // '\001'
                        if(gun instanceof MGunAircraftGeneric)
                            if(World.getPlayerAircraft() == a)
                                ((MGunAircraftGeneric)gun).setConvDistance(World.cur().userCoverCannon, Property.floatValue(a.getClass(), "LOSElevation", 0.75F));
                            else
                            if(a.isNet() && a.isNetPlayer())
                                ((MGunAircraftGeneric)gun).setConvDistance(400F, Property.floatValue(a.getClass(), "LOSElevation", 0.75F));
                            else
                                ((MGunAircraftGeneric)gun).setConvDistance(super.FM.convAI, Property.floatValue(a.getClass(), "LOSElevation", 0.75F));
                        break;

                    case 2: // '\002'
                        if(gun instanceof RocketGun)
                            if(World.getPlayerAircraft() == a)
                            {
                                ((RocketGun)gun).setRocketTimeLife(World.cur().userRocketDelay);
                                ((RocketGun)gun).setConvDistance(World.cur().userCoverRocket, Property.floatValue(a.getClass(), "LOSElevation", 0.75F) - 2.81F);
                            } else
                            if(a.isNet() && a.isNetPlayer())
                                ((RocketGun)gun).setConvDistance(400F, Property.floatValue(a.getClass(), "LOSElevation", 0.75F) - 2.81F);
                            else
                            if(a instanceof TypeFighter)
                                ((RocketGun)gun).setConvDistance(400F, -1.8F);
                            else
                            if(((RocketGun)gun).bulletMassa() > 10F)
                            {
                                if(a instanceof IL_2)
                                    ((RocketGun)gun).setConvDistance(400F, -2F);
                                else
                                    ((RocketGun)gun).setConvDistance(400F, -1.65F);
                            } else
                            if(a instanceof IL_2)
                                ((RocketGun)gun).setConvDistance(400F, -2.1F);
                            else
                                ((RocketGun)gun).setConvDistance(400F, -1.9F);
                        break;

                    case 3: // '\003'
                        if((gun instanceof BombGun) && World.getPlayerAircraft() == a)
                        {
                            ((BombGun)gun).setBombDelay(World.cur().userBombDelay);
                            ((BombGun)gun).selectFuzeAutomatically(true);
                            if(gun instanceof TorpedoGun)
                            {
                                Class torpClass = (Class)Property.value(gun.getClass(), "bulletClass", null);
                                Torpedo.setInfo(torpClass);
                            }
                        }
                        break;
                    }
                } else
                {
                    System.err.println("Hook '" + hook[i] + "' NOT found in mesh of " + a.getClass());
                }

        ((FlightModelMain) (((SndAircraft) (a)).FM)).AS.setArmingSeeds();
    }

    public void missionStarting()
    {
        super.missionStarting();
        if(((FlightModelMain) (super.FM)).CT.bHasBombSelect)
            ((FlightModelMain) (super.FM)).CT.registerBombs();
        if(this == World.getPlayerAircraft())
            return;
        boolean isPlayersWing = false;
        if(Mission.isSingle() || Mission.isCoop())
            isPlayersWing = isPlayersWing(this);
        for(int w = 0; w < ((FlightModelMain) (super.FM)).CT.Weapons.length; w++)
        {
            BulletEmitter bulletemitters[] = ((FlightModelMain) (super.FM)).CT.Weapons[w];
            if(bulletemitters != null)
            {
                for(int i = 0; i < bulletemitters.length; i++)
                {
                    BulletEmitter bulletemitter = bulletemitters[i];
                    if(bulletemitter instanceof BombGun)
                    {
                        BombGun aiBomb = (BombGun)bulletemitter;
                        if(isPlayersWing)
                        {
                            aiBomb.setBombDelay(World.cur().userBombDelay);
                            aiBomb.selectFuzeAutomatically(false);
                        } else
                        if(!Mission.isCoop())
                            aiBomb.addGenericFuze();
                    }
                }

            }
        }

    }

    protected static boolean isPlayersWing(final Aircraft ac) {
        if (ac != World.getPlayerAircraft() && (ac.isNetPlayer() || ((Actor)ac).isNetMaster())) {
            return false;
        }
        try {
            final Wing wing = ac.getWing();
            if (wing == null) {
                return false;
            }
            for (int i = 0; i < wing.airc.length; ++i) {
                final Aircraft acInWing = wing.airc[i];
                if (acInWing == World.getPlayerAircraft()) {
                    return true;
                }
                if (acInWing.isNetPlayer() || ((Actor)acInWing).isNetMaster()) {
                    return false;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static ArrayList weaponsListProperty(Class clazz)
    {
        Object obj = Property.value(clazz, "weaponsList", null);
        if(obj != null)
        {
            return (ArrayList)obj;
        } else
        {
            obj = new ArrayList();
            Property.set(clazz, "weaponsList", obj);
            return (ArrayList)obj;
        }
    }

    private static HashMapInt weaponsMapProperty(Class clazz)
    {
        Object obj = Property.value(clazz, "weaponsMap", null);
        if(obj != null)
        {
            return (HashMapInt)obj;
        } else
        {
            obj = new HashMapInt();
            Property.set(clazz, "weaponsMap", obj);
            return (HashMapInt)obj;
        }
    }

    public void hideWingWeapons(boolean bHide)
    {
        for(int i = 0; i < ((FlightModelMain) (super.FM)).CT.Weapons.length; i++)
        {
            BulletEmitter guns[] = ((FlightModelMain) (super.FM)).CT.Weapons[i];
            if(guns != null)
            {
                for(int j = 0; j < guns.length; j++)
                    if(guns[j] instanceof BombGun)
                        ((BombGun)guns[j]).hide(bHide);
                    else
                    if(guns[j] instanceof RocketGun)
                        ((RocketGun)guns[j]).hide(bHide);
                    else
                    if(guns[j] instanceof Pylon)
                        ((Pylon)guns[j]).drawing(!bHide);

            }
        }

    }

    public void createCockpits()
    {
        if(!Config.isUSE_RENDER())
            return;
        deleteCockpits();
        Object prop = Property.value(getClass(), "cockpitClass");
        if(prop == null)
            return;
        Cockpit._newAircraft = this;
        if(prop instanceof Class)
        {
            Class cls = (Class)prop;
            try
            {
                Main3D.cur3D().cockpits = new Cockpit[1];
                Main3D.cur3D().cockpits[0] = (Cockpit)cls.newInstance();
                Main3D.cur3D().cockpitCur = Main3D.cur3D().cockpits[0];
            }
            catch(Exception e)
            {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        } else
        {
            Class clss[] = (Class[])prop;
            try
            {
                int len = clss.length;
                for(int i = 0; i < clss.length; i++)
                {
                    if(!Mission.isSingle() && !Mission.isDogfight() || !com.maddox.il2.objects.air.CockpitCopilot.class.isAssignableFrom(clss[i]))
                        continue;
                    len--;
                    break;
                }

                Main3D.cur3D().cockpits = new Cockpit[len];
                int slot = 0;
                for(int i = 0; i < clss.length; i++)
                    if(!Mission.isSingle() && !Mission.isDogfight() || !com.maddox.il2.objects.air.CockpitCopilot.class.isAssignableFrom(clss[i]))
                    {
                        Main3D.cur3D().cockpits[slot] = (Cockpit)clss[i].newInstance();
                        slot++;
                    }

                Main3D.cur3D().cockpitCur = Main3D.cur3D().cockpits[0];
            }
            catch(Exception e)
            {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
        Cockpit._newAircraft = null;
    }

    protected void deleteCockpits()
    {
        if(!Config.isUSE_RENDER())
            return;
        Cockpit all[] = Main3D.cur3D().cockpits;
        if(all == null)
            return;
        for(int i = 0; i < all.length; i++)
        {
            all[i].destroy();
            all[i] = null;
        }

        Main3D.cur3D().cockpits = null;
        Main3D.cur3D().cockpitCur = null;
    }

    private void explode()
    {
        if(((FlightModelMain) (super.FM)).Wingman != null)
            ((FlightModelMain) (super.FM)).Wingman.Leader = ((FlightModelMain) (super.FM)).Leader;
        if(((FlightModelMain) (super.FM)).Leader != null)
            ((FlightModelMain) (super.FM)).Leader.Wingman = ((FlightModelMain) (super.FM)).Wingman;
        super.FM.Wingman = null;
        super.FM.Leader = null;
        HierMesh M = hierMesh();
        int CF = -1;
        float Speed = 30F;
        int i;
        for(i = 9; i >= 0; i--)
            if((CF = M.chunkFindCheck("CF_D" + i)) >= 0)
                break;

        int chunks[] = hideSubTrees("");
        if(chunks == null)
            return;
        int ch[] = chunks;
        chunks = new int[ch.length + 1];
        for(i = 0; i < ch.length; i++)
            chunks[i] = ch[i];

        chunks[i] = CF;
        for(i = 0; i < chunks.length; i++)
        {
            Wreckage a = new Wreckage(this, chunks[i]);
            if(World.Rnd().nextInt(0, 99) < 30)
            {
                float liveTime = 2.5F + World.Rnd().nextFloat(0.0F, 5F);
                Eff3DActor.New(a, null, null, 1.0F, Wreckage.FIRE, liveTime);
                if(World.Rnd().nextInt(0, 99) < 50)
                    Eff3DActor.New(a, null, null, 1.0F, Wreckage.SMOKE_EXPLODE, liveTime + 1.0F);
            }
            getSpeed(Vd);
            Vd.x += (double)Speed * (World.Rnd().nextDouble(0.0D, 1.0D) - 0.5D);
            Vd.y += (double)Speed * (World.Rnd().nextDouble(0.0D, 1.0D) - 0.5D);
            Vd.z += (double)Speed * (World.Rnd().nextDouble(0.0D, 1.0D) - 0.5D);
            a.setSpeed(Vd);
        }

    }

    public int aircNumber()
    {
        Wing W = (Wing)getOwner();
        if(W == null)
            return -1;
        else
            return W.aircReady();
    }

    public int aircIndex()
    {
        Wing W = (Wing)getOwner();
        if(W == null)
            return -1;
        else
            return W.aircIndex(this);
    }

    public boolean isInPlayerWing()
    {
        if(!Actor.isValid(World.getPlayerAircraft()))
            return false;
        return getWing() == World.getPlayerAircraft().getWing();
    }

    public boolean isInPlayerSquadron()
    {
        if(!Actor.isValid(World.getPlayerAircraft()))
            return false;
        return getSquadron() == World.getPlayerAircraft().getSquadron();
    }

    public boolean isInPlayerRegiment()
    {
        return getRegiment() == World.getPlayerRegiment();
    }

    public boolean isChunkAnyDamageVisible(String chunkNamePrefix)
    {
        if(chunkNamePrefix.lastIndexOf("_") == -1)
            chunkNamePrefix = chunkNamePrefix + "_D";
        for(int i = 0; i < 4; i++)
            if(hierMesh().chunkFindCheck(chunkNamePrefix + i) != -1 && hierMesh().isChunkVisible(chunkNamePrefix + i))
                return true;

        return false;
    }

    protected int chunkDamageVisible(String chunkNamePrefix)
    {
        if(chunkNamePrefix.lastIndexOf("_") == -1)
            chunkNamePrefix = chunkNamePrefix + "_D";
        for(int i = 0; i < 4; i++)
            if(hierMesh().chunkFindCheck(chunkNamePrefix + i) != -1 && hierMesh().isChunkVisible(chunkNamePrefix + i))
                return i;

        return 0;
    }

    public Wing getWing()
    {
        return (Wing)getOwner();
    }

    public Squadron getSquadron()
    {
        Wing W = getWing();
        if(W == null)
            return null;
        else
            return W.squadron();
    }

    public Regiment getRegiment()
    {
        Wing W = getWing();
        if(W == null)
            return null;
        else
            return W.regiment();
    }

    public void hitDaSilk()
    {
        ((FlightModelMain) (super.FM)).AS.hitDaSilk();
        super.FM.setReadyToDie(true);
        if(((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).z - Engine.land().HQ_Air(((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).x, ((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).y) > 20D)
            Voice.speakBailOut(this);
    }

    protected void killPilot(Actor initiator, int pilotIndex)
    {
        ((FlightModelMain) (super.FM)).AS.hitPilot(initiator, pilotIndex, 100);
    }

    public void doWoundPilot(int i, float f)
    {
    }

    public void doMurderPilot(int i)
    {
    }

    public void doRemoveBodyFromPlane(int num)
    {
        doRemoveBodyChunkFromPlane("Pilot" + num);
        doRemoveBodyChunkFromPlane("Head" + num);
        doRemoveBodyChunkFromPlane("HMask" + num);
        doRemoveBodyChunkFromPlane("Pilot" + num + "a");
        doRemoveBodyChunkFromPlane("Head" + num + "a");
        doRemoveBodyChunkFromPlane("Pilot" + num + "FAK");
        doRemoveBodyChunkFromPlane("Head" + num + "FAK");
        doRemoveBodyChunkFromPlane("Pilot" + num + "FAL");
        doRemoveBodyChunkFromPlane("Head" + num + "FAL");
    }

    protected void doRemoveBodyChunkFromPlane(String subchunk)
    {
        if(hierMesh().chunkFindCheck(subchunk + "_D0") != -1)
            hierMesh().chunkVisible(subchunk + "_D0", false);
        if(hierMesh().chunkFindCheck(subchunk + "_D1") != -1)
            hierMesh().chunkVisible(subchunk + "_D1", false);
    }

    public void doSetSootState(int enginenumber, int newstate)
    {
        for(int i = 0; i < 2; i++)
        {
            if(((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][i] != null)
                Eff3DActor.finish(((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][i]);
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][i] = null;
        }

        switch(newstate)
        {
        case 1: // '\001'
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][0] = Eff3DActor.New(this, findHook("_Engine" + (enginenumber + 1) + "ES_01"), null, 1.0F, "3DO/Effects/Aircraft/BlackSmallTSPD.eff", -1F);
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][1] = Eff3DActor.New(this, findHook("_Engine" + (enginenumber + 1) + "ES_02"), null, 1.0F, "3DO/Effects/Aircraft/BlackSmallTSPD.eff", -1F);
            break;

        case 3: // '\003'
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][1] = Eff3DActor.New(this, findHook("_Engine" + (enginenumber + 1) + "EF_01"), null, 1.0F, "3DO/Effects/Aircraft/BlackMediumTSPD.eff", -1F);
            // fall through

        case 2: // '\002'
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][0] = Eff3DActor.New(this, findHook("_Engine" + (enginenumber + 1) + "EF_01"), null, 1.0F, "3DO/Effects/Aircraft/TurboZippo.eff", -1F);
            break;

        case 5: // '\005'
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][0] = Eff3DActor.New(this, findHook("_Engine" + (enginenumber + 1) + "EF_01"), null, 3F, "3DO/Effects/Aircraft/TurboJRD1100F.eff", -1F);
            // fall through

        case 4: // '\004'
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][1] = Eff3DActor.New(this, findHook("_Engine" + (enginenumber + 1) + "EF_01"), null, 1.0F, "3DO/Effects/Aircraft/BlackMediumTSPD.eff", -1F);
            break;

        case 6: // '\006'///added
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][0] = Eff3DActor.New(this, findHook("_Engine" + (enginenumber + 1) + "ES_01"), null, 1.0F, "3DO/Effects/Aircraft/Full_throttle.eff", -1F);
            ((FlightModelMain) (super.FM)).AS.astateSootEffects[enginenumber][1] = Eff3DActor.New(this, findHook("_Engine" + (enginenumber + 1) + "ES_02"), null, 1.0F, "3DO/Effects/Aircraft/Full_throttle.eff", -1F);
            break;
        }
    }

    public void onAircraftLoaded()
    {
        if(super.FM instanceof Maneuver)
        {
            Maneuver m = (Maneuver)super.FM;
            m.takeIntoAccount[0] = 1.0F;
            m.takeIntoAccount[1] = 1.0F;
            m.takeIntoAccount[2] = 0.7F;
            if(this instanceof TypeFighter)
            {
                if(aircIndex() % 2 == 0)
                {
                    m.takeIntoAccount[3] = 0.0F;
                    m.takeIntoAccount[4] = 1.0F;
                } else
                {
                    m.takeIntoAccount[2] = 0.1F;
                    m.takeIntoAccount[3] = 1.0F;
                    m.takeIntoAccount[4] = 0.0F;
                }
                m.takeIntoAccount[5] = 0.3F;
                m.takeIntoAccount[6] = 0.3F;
                m.takeIntoAccount[7] = 0.1F;
            } else
            if(this instanceof TypeStormovik)
            {
                if(aircIndex() != 0)
                    m.takeIntoAccount[2] = 0.5F;
                m.takeIntoAccount[3] = 0.4F;
                m.takeIntoAccount[4] = 0.2F;
                m.takeIntoAccount[5] = 0.1F;
                m.takeIntoAccount[6] = 0.1F;
                m.takeIntoAccount[7] = 0.6F;
            } else
            {
                if(aircIndex() != 0)
                    m.takeIntoAccount[2] = 0.4F;
                m.takeIntoAccount[3] = 0.2F;
                m.takeIntoAccount[4] = 0.0F;
                m.takeIntoAccount[5] = 0.0F;
                m.takeIntoAccount[6] = 0.0F;
                m.takeIntoAccount[7] = 1.0F;
            }
            for(int i = 0; i < 8; i++)
                m.AccountCoeff[i] = 0.0F;

        }
        ((FlightModelMain) (super.FM)).CT.setBombModeDefaults();
        ((FlightModelMain) (super.FM)).CT.setRocketModeDefaults();
        if(super.FM instanceof RealFlightModel)
            ((RealFlightModel)super.FM).calculateBombMomentum();
        loadBallisticTable();
    }

    public static float cvt(float val, float vmin, float vmax, float omin, float omax)
    {
        val = Math.min(Math.max(val, vmin), vmax);
        return omin + ((omax - omin) * (val - vmin)) / (vmax - vmin);
    }

    public static float round3(float number)
    {
        if(number <= 0.0F)
        {
            return number;
        } else
        {
            int pow = 10;
            double tmp = number * (float)pow;
            return (float)(int)(tmp - (double)(int)tmp < 0.5D ? tmp : tmp + 1.0D) / (float)pow;
        }
    }

    public static float round2(float number)
    {
        int pow = 10;
        float tmp = number * (float)pow;
        return (float)(int)(tmp - (float)(int)tmp < 0.5F ? tmp : tmp + 1.0F) / (float)pow;
    }

    protected void debugprintln(String str)
    {
        if(World.cur().isDebugFM())
            System.out.println("<" + name() + "> (" + typedName() + ") " + str);
    }

    public static void debugprintln(Actor ac, String str)
    {
        if(World.cur().isDebugFM())
        {
            if(Actor.isValid(ac))
            {
                System.out.print("<" + ac.name() + ">");
                if(ac instanceof Aircraft)
                    System.out.print(" (" + ((Aircraft)ac).typedName() + ")");
            } else
            {
                System.out.print("<INVALIDACTOR>");
            }
            System.out.println(" " + str);
        }
    }

    public void debuggunnery(String str)
    {
        if(World.cur().isDebugFM())
            System.out.println("<" + name() + "> (" + typedName() + ") *** BULLET *** : " + str);
    }

    protected float bailProbabilityOnCut(String chunk)
    {
        if(chunk.startsWith("Nose"))
            return 0.5F;
        if(chunk.startsWith("Wing"))
            return 0.99F;
        if(chunk.startsWith("Aroone"))
            return 0.05F;
        if(chunk.startsWith("Tail"))
            return 0.99F;
        if(chunk.startsWith("StabL") && !isChunkAnyDamageVisible("VatorR"))
            return 0.99F;
        if(chunk.startsWith("StabR") && !isChunkAnyDamageVisible("VatorL"))
            return 0.99F;
        if(chunk.startsWith("Stab"))
            return 0.33F;
        if(chunk.startsWith("VatorL") && !isChunkAnyDamageVisible("VatorR"))
            return 0.99F;
        if(chunk.startsWith("VatorR") && !isChunkAnyDamageVisible("VatorL"))
            return 0.99F;
        if(chunk.startsWith("Vator"))
            return 0.01F;
        if(chunk.startsWith("Keel"))
            return 0.5F;
        if(chunk.startsWith("Rudder"))
            return 0.05F;
        return !chunk.startsWith("Engine") ? -0F : 0.12F;
    }

    private void _setMesh(String meshName)
    {
        setMesh(meshName);
        CacheItem item = (CacheItem)meshCache.get(meshName);
        if(item == null)
        {
            item = new CacheItem();
            item.mesh = new HierMesh(meshName);
            prepareMeshCamouflage(meshName, item.mesh, null, null);
            item.bExistTextures = true;
            item.loaded = 1;
            meshCache.put(meshName, item);
        } else
        {
            item.loaded++;
            if(!item.bExistTextures)
            {
                item.mesh.destroy();
                item.mesh = new HierMesh(meshName);
                prepareMeshCamouflage(meshName, item.mesh, null, null);
                item.bExistTextures = true;
            }
        }
        airCache.put(this, item);
        checkMeshCache();
    }

    private void _removeMesh()
    {
        CacheItem item = (CacheItem)airCache.get(this);
        if(item == null)
            return;
        airCache.remove(this);
        item.loaded--;
        if(item.loaded == 0)
            item.time = Time.real();
        checkMeshCache();
    }

    public static void checkMeshCache()
    {
        if(!Config.isUSE_RENDER())
            return;
        long time = Time.real();
        for(java.util.Map.Entry entry = meshCache.nextEntry(null); entry != null; entry = meshCache.nextEntry(entry))
        {
            CacheItem item = (CacheItem)entry.getValue();
            if(item.loaded == 0 && item.bExistTextures && time - item.time > 0x2bf20L)
            {
                HierMesh mh = item.mesh;
                int n = mh.materials();
                Mat mat = Mat.New("3do/textures/clear.mat");
                for(int i = 0; i < n; i++)
                    mh.materialReplace(i, mat);

                item.bExistTextures = false;
            }
        }

    }

    public static void resetGameClear()
    {
        meshCache.clear();
        airCache.clear();
    }

    public void setCockpitState(int state)
    {
        if(super.FM.isPlayers() && World.cur().diffCur.Vulnerability && Actor.isValid(Main3D.cur3D().cockpitCur))
            Main3D.cur3D().cockpitCur.doReflectCockitState();
    }

    protected void resetYPRmodifier()
    {
        ypr[0] = ypr[1] = ypr[2] = xyz[0] = xyz[1] = xyz[2] = 0.0F;
    }

    public CellAirPlane getCellAirPlane()
    {
        CellAirPlane cell = (CellAirPlane)Property.value(this, "CellAirPlane", null);
        if(cell != null)
            return cell;
        cell = (CellAirPlane)Property.value(getClass(), "CellObject", null);
        if(cell == null)
        {
            tmpLocCell.set(0.0D, 0.0D, ((FlightModelMain) (super.FM)).Gears.H, 0.0F, ((FlightModelMain) (super.FM)).Gears.Pitch, 0.0F);
            cell = new CellAirPlane(new com.maddox.il2.ai.air.CellObject[1][1], hierMesh(), tmpLocCell, 1.0D);
            cell.blurSiluet8x();
            cell.clampCells();
            Property.set(getClass(), "CellObject", cell);
        }
        cell = (CellAirPlane)cell.getClone();
        Property.set(this, "CellObject", cell);
        return cell;
    }

    public static CellAirPlane getCellAirPlane(Class clsAir)
    {
        CellAirPlane cell = null;
        tmpLocCell.set(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        HierMesh hMesh = new HierMesh(getPropertyMesh(clsAir, null));
        cell = new CellAirPlane(new com.maddox.il2.ai.air.CellObject[1][1], hMesh, tmpLocCell, 1.0D);
        cell.blurSiluet8x();
        cell.clampCells();
        return cell;
    }

    public boolean dropExternalStores(boolean isMaster)
    {
        boolean dropped = false;
        for(int w = 0; w < ((FlightModelMain) (super.FM)).CT.Weapons.length; w++)
        {
            BulletEmitter bulletemitters[] = ((FlightModelMain) (super.FM)).CT.Weapons[w];
            if(bulletemitters != null)
            {
                for(int i = 0; i < bulletemitters.length; i++)
                {
                    BulletEmitter bulletemitter = bulletemitters[i];
                    if((bulletemitter instanceof BombGun) && !(bulletemitter instanceof FuelTankGun))
                    {
                        ((BombGun)bulletemitter).jettisonBomb();
                        if(bulletemitter.countBullets() != 0)
                        {
                            if(bulletemitter.countBullets() == -1)
                                bulletemitter.loadBullets(1);
                            dropped = true;
                            bulletemitter.shots(99);
                            if(bulletemitter.getHookName().startsWith("_BombSpawn"))
                                ((FlightModelMain) (super.FM)).CT.BayDoorControl = 1.0F;
                        }
                    }
                }

            }
        }

        if(!dropped)
            return dropWfrGr21();
        else
            return dropped;
    }

    private boolean dropWfrGr21()
    {
        if(!wfrGr21dropped)
        {
            Object objects[] = super.pos.getBaseAttached();
            if(objects != null)
            {
                for(int i = 0; i < objects.length; i++)
                {
                    if(objects[i] instanceof PylonRO_WfrGr21)
                    {
                        PylonRO_WfrGr21 pylon = (PylonRO_WfrGr21)objects[i];
                        pylon.drawing(false);
                        pylon.visibilityAsBase(false);
                        wfrGr21dropped = true;
                        if(World.getPlayerAircraft() == this)
                            World.cur().scoreCounter.playerDroppedExternalStores(2);
                    }
                    if(objects[i] instanceof PylonRO_WfrGr21Dual)
                    {
                        PylonRO_WfrGr21Dual pylon = (PylonRO_WfrGr21Dual)objects[i];
                        pylon.drawing(false);
                        pylon.visibilityAsBase(false);
                        wfrGr21dropped = true;
                        if(World.getPlayerAircraft() == this)
                            World.cur().scoreCounter.playerDroppedExternalStores(4);
                    }
                }

            }
            if(wfrGr21dropped)
            {
                int WfrGr21Type = 1;
                int WfrGr21DualNumber = 0;
                for(int w = 0; w < ((FlightModelMain) (super.FM)).CT.Weapons.length; w++)
                {
                    BulletEmitter bulletemitters[] = ((FlightModelMain) (super.FM)).CT.Weapons[w];
                    if(bulletemitters != null)
                    {
                        for(int i = 0; i < bulletemitters.length; i++)
                        {
                            BulletEmitter bulletemitter = bulletemitters[i];
                            if(bulletemitter instanceof RocketGunWfrGr21)
                            {
                                RocketGunWfrGr21 rocket = (RocketGunWfrGr21)bulletemitter;
                                ((FlightModelMain) (super.FM)).CT.Weapons[w][i] = GunEmpty.get();
                                rocket.setHookToRel(true);
                                rocket.shots(0);
                                rocket.hide(true);
                                bulletemitter = GunEmpty.get();
                                rocket.doDestroy();
                            }
                            if(bulletemitter instanceof PylonRO_WfrGr21)
                            {
                                ((Pylon)bulletemitter).destroy();
                                ((FlightModelMain) (super.FM)).CT.Weapons[w][i] = GunEmpty.get();
                                bulletemitter = GunEmpty.get();
                            }
                            if(bulletemitter instanceof PylonRO_WfrGr21Dual)
                            {
                                ((Pylon)bulletemitter).destroy();
                                ((FlightModelMain) (super.FM)).CT.Weapons[w][i] = GunEmpty.get();
                                bulletemitter = GunEmpty.get();
                                WfrGr21Type = 2;
                                WfrGr21DualNumber++;
                            }
                        }

                    }
                }

                sfxHit(1.0F, new Point3d(0.0D, 0.0D, -1D));
                Vector3d vector3d1 = new Vector3d();
                vector3d1.set(((FlightModelMain) (super.FM)).Vwld);
                vector3d1.z = ((Tuple3d) (vector3d1)).z - 6D;
                Wreckage wreckageL;
                if(WfrGr21Type == 2)
                    wreckageL = new Wreckage(this, hierMesh().chunkFind("WfrGr21LL"));
                else
                    wreckageL = new Wreckage(this, hierMesh().chunkFind("WfrGr21L"));
                vector3d1.x += Math.random() + 0.5D;
                vector3d1.y += Math.random() + 0.5D;
                vector3d1.z += Math.random() + 0.5D;
                wreckageL.setSpeed(vector3d1);
                wreckageL.collide(true);
                Vector3d vector3d2 = new Vector3d();
                vector3d2.set(((FlightModelMain) (super.FM)).Vwld);
                vector3d2.z = ((Tuple3d) (vector3d2)).z - 7D;
                Wreckage wreckageR;
                if(WfrGr21Type == 2)
                    wreckageR = new Wreckage(this, hierMesh().chunkFind("WfrGr21RR"));
                else
                    wreckageR = new Wreckage(this, hierMesh().chunkFind("WfrGr21R"));
                vector3d2.x += Math.random() + 0.5D;
                vector3d2.y += Math.random() + 0.5D;
                vector3d2.z += Math.random() + 0.5D;
                wreckageR.setSpeed(vector3d2);
                wreckageR.collide(true);
                if(WfrGr21Type == 2 && WfrGr21DualNumber == 3)
                {
                    Vector3d vector3d3 = new Vector3d();
                    vector3d3.set(((FlightModelMain) (super.FM)).Vwld);
                    vector3d3.z = ((Tuple3d) (vector3d3)).z - 7D;
                    Wreckage wreckageC = new Wreckage(this, hierMesh().chunkFind("WfrGr21CC"));
                    vector3d3.x += Math.random() + 0.5D;
                    vector3d3.y += Math.random() + 0.5D;
                    vector3d3.z += Math.random() + 0.5D;
                    wreckageC.setSpeed(vector3d3);
                    wreckageC.collide(true);
                }
                return true;
            } else
            {
                return false;
            }
        } else
        {
            return false;
        }
    }

    public void blisterRemoved(int i)
    {
    }

    public static boolean hasPlaneZBReceiver(Aircraft ac)
    {
        for(int i = 0; i < planesWithZBReceiver.length; i++)
            if(planesWithZBReceiver[i].isInstance(ac))
            {
                String country = ac.getRegiment().country();
                if(country.equals(PaintScheme.countryBritain) || country.equals(PaintScheme.countryUSA) || country.equals(PaintScheme.countryNewZealand))
                    return true;
            }

        return false;
    }

    public boolean isAircraftTaxing()
    {
        return ((FlightModelMain) (super.FM)).Gears.isUnderDeck() || ((FlightModelMain) (super.FM)).Gears.getWheelsOnGround() || ((FlightModelMain) (super.FM)).Gears.onGround();
    }

    public static boolean isPlayerTaxing()
    {
        Aircraft ownAC = World.getPlayerAircraft();
        return ownAC.isDestroyed() || ((FlightModelMain) (((SndAircraft) (ownAC)).FM)).Gears.isUnderDeck() || ((FlightModelMain) (((SndAircraft) (ownAC)).FM)).Gears.getWheelsOnGround() || ((FlightModelMain) (((SndAircraft) (ownAC)).FM)).Gears.onGround();
    }

    public void setHumanControlledTurretAngels(Turret T, float tu[], HierMesh HM, ActorHMesh am)
    {
        tu[0] = tu[1] = tu[2] = 0.0F;
        tu[1] = T.tu[0];
        HM.setCurChunk(T.indexA);
        am.hierMesh().chunkSetAngles(tu);
        tu[1] = T.tu[1];
        HM.setCurChunk(T.indexB);
        am.hierMesh().chunkSetAngles(tu);
    }

    public void initPlayerTaxingWay()
    {
        showTaxingWay = false;
        Aircraft playerAC = World.getPlayerAircraft();
        playerTaxingWay = new ArrayList();
        if(((SndAircraft) (playerAC)).FM == null || ((FlightModelMain) (((SndAircraft) (playerAC)).FM)).AP == null)
            return;
        int cnt = 0;
        do
        {
            if(cnt >= ((FlightModelMain) (((SndAircraft) (playerAC)).FM)).AP.way.size())
                break;
            WayPoint wp = ((FlightModelMain) (((SndAircraft) (playerAC)).FM)).AP.way.look_at_point(cnt);
            if((wp == null || wp.waypointType != 4) && wp.waypointType != 5)
                break;
            World.cur();
            World.land();
            double z = Landscape.HQ_Air(wp.x(), wp.y()) + 0.1F;
            Point3d p3d = new Point3d(wp.x(), wp.y(), z);
            playerTaxingWay.add(p3d);
            cnt++;
        } while(true);
    }

    public void setBombScoreOwner(Aircraft ac)
    {
        bombScoreOwner = ac;
    }

    public Aircraft getBombScoreOwner()
    {
        return bombScoreOwner;
    }

    public Point3d getTankBurnLightPoint(int tankNumber, Hook burnHook)
    {
        Loc _loc1 = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        Loc _loc2 = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        if(burnHook.chunkName().toLowerCase().startsWith("cf"))
        {
            burnHook.computePos(this, _loc1, _loc2);
            Point3d p1 = _loc2.getPoint();
            if(((Tuple3d) (p1)).z > 0.0D)
                _loc1 = new Loc(0.0D, 0.0D, 0.5D, 0.0F, 0.0F, 0.0F);
            else
                _loc1 = new Loc(0.0D, 0.0D, -0.75D, 0.0F, 0.0F, 0.0F);
            _loc2 = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        } else
        {
            _loc1 = new Loc(-1D, 0.0D, 0.5D, 0.0F, 0.0F, 0.0F);
        }
        burnHook.computePos(this, _loc1, _loc2);
        Point3d p2 = _loc2.getPoint();
        return p2;
    }

    public Loc getEngineBurnLightLoc(int engineNumber)
    {
        return engineBurnLightLoc;
    }

    public float getWheelWidth(int gear)
    {
        float width = cvt(((FlightModelMain) (super.FM)).Wingspan, 10F, 40F, 0.12F, 0.42F);
        if(gear == 2)
            width = (float)((double)width * 0.59999999999999998D);
        return width;
    }

    public String getGearOnSnowSim(int gear)
    {
        return "3do/Effects/Aircraft/GearsSnow/track.sim";
    }

    public boolean needsOpenBombBay()
    {
        return true;
    }

    public boolean canOpenBombBay()
    {
        return true;
    }

    public float getEyeLevelCorrection()
    {
        return 0.0F;
    }

    public float[] getTurretRestOrient(int tIndex)
    {
        return defTurretRest;
    }

    public float getExtraParasiteDrag()
    {
        return 0.0F;
    }

    public boolean hasIntervalometer()
    {
        if(!World.cur().diffCur.Limited_Ammo)
            return false;
        else
            return ((Interpolate) (super.FM)).actor instanceof TypeBomber;
    }

    public int[] getBombTrainDelayArray()
    {
        return Controls.bombTrainDelays;
    }

    public int getBombTrainMaxAmount()
    {
        return ((FlightModelMain) (super.FM)).CT.getWeaponCount(3);
    }

    public double getBombDist(float HSbrosa, float Ht, double speedMS)
    {
        float bombdist[] = {
            0.0F, 0.0F, 0.0F, 0.0F
        };
        bombdist = _getBombDist(currBomb_Type, 3.6F * (float)speedMS, HSbrosa, Ht, currBomb_M, currBomb_Kalibr, currBomb_Crutch);
        return (double)bombdist[0];
    }

    public double getBombDist(float HSbrosa, double speedMS)
    {
        float bombdist[] = {
            0.0F, 0.0F, 0.0F, 0.0F
        };
        bombdist = _getBombDist(currBomb_Type, 3.6F * (float)speedMS, HSbrosa, 0.0F, currBomb_M, currBomb_Kalibr, currBomb_Crutch);
        return (double)bombdist[0];
    }

    public boolean isBallisticTableLoaded()
    {
        return (this instanceof TypeBomber) && BT_class != null;
    }

    public void loadBallisticTableAI()
    {
        loadBallisticTable();
    }

    private void loadBallisticTable()
    {
        if(this instanceof TypeBomber)
        {
            BT = 0;
            float f = 0.0F;
            Class var_class = null;
            if(((FlightModelMain) (super.FM)).CT.Weapons[3] != null)
            {
                for(int i = 0; i < ((FlightModelMain) (super.FM)).CT.Weapons[3].length; i++)
                {
                    if(var_class != null)
                        break;
                    if(!((FlightModelMain) (super.FM)).CT.Weapons[3][i].haveBullets() || ((FlightModelMain) (super.FM)).CT.Weapons[3][i].bulletMassa() <= f)
                        continue;
                    var_class = ((FlightModelMain) (super.FM)).CT.Weapons[3][i].getClass();
                    BT = i;
                    if(BT_class != var_class)
                        break;
                    var_class = null;
                }

            }
            if(var_class != null)
            {
                Class bullet_class = (Class)Property.value(var_class, "bulletClass", null);
                if(bullet_class != null && BT_class != var_class && Property.floatValue(bullet_class, "massa", 0.0F) > 0.1F)
                {
                    String s1 = bullet_class.getName();
                    int bomb_type = getBombType(s1.substring(31));
                    if(bomb_type >= 0)
                    {
                        currBomb_M = Property.floatValue(bullet_class, "massa", 250F);
                        currBomb_Kalibr = Property.floatValue(bullet_class, "kalibr", 0.32F);
                        currBomb_Crutch = Property.floatValue(bullet_class, "crutch", 0.0F);
                        currBomb_Type = bomb_type;
                        currBomb_HUD(bomb_type, s1);
                        BT_class = var_class;
                    }
                }
            }
        }
    }

    public void reloadBallisticTable()
    {
        if(World.getPlayerAircraft() == this && (this instanceof TypeBomber))
        {
            float f = -1F;
            Class var_class = null;
            if(((FlightModelMain) (super.FM)).CT.Weapons[3] != null)
            {
                if(BT >= ((FlightModelMain) (super.FM)).CT.Weapons[3].length)
                    BT = 0;
                for(int i = BT; i < ((FlightModelMain) (super.FM)).CT.Weapons[3].length; i++)
                {
                    var_class = ((FlightModelMain) (super.FM)).CT.Weapons[3][i].getClass();
                    if(var_class != null && ((FlightModelMain) (super.FM)).CT.Weapons[3][i].haveBullets() && BT_class != var_class)
                    {
                        Class bullet_class = (Class)Property.value(var_class, "bulletClass", null);
                        if(bullet_class != null && Property.floatValue(bullet_class, "massa", 0.0F) > 0.1F)
                        {
                            String s1 = bullet_class.getName();
                            int bomb_type = getBombType(s1.substring(31));
                            if(bomb_type >= 0)
                            {
                                currBomb_M = Property.floatValue(bullet_class, "massa", 250F);
                                currBomb_Kalibr = Property.floatValue(bullet_class, "kalibr", 0.32F);
                                currBomb_Crutch = Property.floatValue(bullet_class, "crutch", 0.0F);
                                currBomb_Type = bomb_type;
                                currBomb_HUD(bomb_type, s1);
                                BT_class = var_class;
                                BT = i + 1;
                                return;
                            }
                            BT = i + 1;
                        }
                    }
                }

            }
            loadBallisticTable();
        }
    }

    public String getExtraHUDInfo()
    {
        return null;
    }

    private void currBomb_HUD(int type, String s)
    {
        if(World.getPlayerAircraft() != this)
            return;
        if(!(this instanceof TypeBomber))
            return;
        switch(type)
        {
        case 0: // '\0'
        case 3: // '\003'
        case 5: // '\005'
        default:
            HUD.log(I18N.gui("Bomb") + " " + I18N.gui(s.substring(35)));
            break;

        case 1: // '\001'
        case 4: // '\004'
            HUD.log(I18N.gui("Bomb") + " " + I18N.gui(s.substring(37)));
            break;

        case 2: // '\002'
            HUD.log(I18N.gui("Torpedo") + " " + I18N.gui(s.substring(31)));
            break;
        }
    }

    private int getBombType(String s)
    {
        int type = 0;
        if(s.startsWith("RocketFritzX"))
            type = 1;
        else
        if(s.startsWith("BombTorpFFF"))
            type = 2;
        else
        if(s.endsWith("BombTorp45_36AV_A"))
            type = 3;
        else
        if(s.startsWith("RocketHS_293"))
            type = 4;
        else
        if(s.startsWith("BombParafrag8"))
            type = 5;
        else
        if(s.startsWith("BombNull") || s.startsWith("Rocket") || s.startsWith("BombSAB") || s.startsWith("BombTorp") || s.startsWith("Bomb45") || s.startsWith("Bomb53") || s.startsWith("BombCargo") || s.startsWith("Torp") || s.startsWith("Pylon") || s.startsWith("BombStarthilfe"))
            type = -1;
        return type;
    }

    private float[] _getBombDist(int Type, float TAS, float HSbrosa, float Ht, float M, float Kalibr, float BombCrutch)
    {
        return GetBombDLL(Type, TAS, HSbrosa, 0.0F, M, Kalibr, 0.0F, 1.03F, BombCrutch, 0.0F, 0.0F, 0.0F, 0.0F);
    }

    private native float[] GetBombDLL(int i, float f, float f1, float f2, float f3, float f4, float f5, 
            float f6, float f7, float f8, float f9, float f10, float f11);

    private static RangeRandom dec_rnd = new RangeRandom();
    public long tmSearchlighted;
    public static final float MINI_HIT = 5.000001E-007F;
    public static final float defaultUnitHit = 0.01F;
    public static final float powerPerMM = 1700F;
    Class BT_class;
    private int BT;
    public static final int HIT_COLLISION = 0;
    public static final int HIT_EXPLOSION = 1;
    public static final int HIT_SHOT = 2;
    protected static float ypr[] = {
        0.0F, 0.0F, 0.0F
    };
    protected static float xyz[] = {
        0.0F, 0.0F, 0.0F
    };
    public static final int _AILERON_L = 0;
    public static final int _AILERON_R = 1;
    public static final int _FUSELAGE = 2;
    public static final int _ENGINE_1 = 3;
    public static final int _ENGINE_2 = 4;
    public static final int _ENGINE_3 = 5;
    public static final int _ENGINE_4 = 6;
    public static final int _GEAR_C = 7;
    public static final int _FLAP_R = 8;
    public static final int _GEAR_L = 9;
    public static final int _GEAR_R = 10;
    public static final int _VER_STAB_1 = 11;
    public static final int _VER_STAB_2 = 12;
    public static final int _NOSE = 13;
    public static final int _OIL = 14;
    public static final int _RUDDER_1 = 15;
    public static final int _RUDDER_2 = 16;
    public static final int _HOR_STAB_L = 17;
    public static final int _HOR_STAB_R = 18;
    public static final int _TAIL_1 = 19;
    public static final int _TAIL_2 = 20;
    public static final int _TANK_1 = 21;
    public static final int _TANK_2 = 22;
    public static final int _TANK_3 = 23;
    public static final int _TANK_4 = 24;
    public static final int _TURRET_1 = 25;
    public static final int _TURRET_2 = 26;
    public static final int _TURRET_3 = 27;
    public static final int _TURRET_4 = 28;
    public static final int _TURRET_5 = 29;
    public static final int _TURRET_6 = 30;
    public static final int _ELEVATOR_L = 31;
    public static final int _ELEVATOR_R = 32;
    public static final int _WING_ROOT_L = 33;
    public static final int _WING_MIDDLE_L = 34;
    public static final int _WING_END_L = 35;
    public static final int _WING_ROOT_R = 36;
    public static final int _WING_MIDDLE_R = 37;
    public static final int _WING_END_R = 38;
    public static final int _FLAP_01 = 39;
    public static final int _FLAP_02 = 40;
    public static final int _FLAP_03 = 41;
    public static final int _FLAP_04 = 42;
    public static final int _NULLPART = 43;
    public static final int _NOMOREPARTS = 44;
    private static final String partNames[] = {
        "AroneL", "AroneR", "CF", "Engine1", "Engine2", "Engine3", "Engine4", "GearC2", "FlapR", "GearL2", 
        "GearR2", "Keel1", "Keel2", "Nose", "Oil", "Rudder1", "Rudder2", "StabL", "StabR", "Tail1", 
        "Tail2", "Tank1", "Tank2", "Tank3", "Tank4", "Turret1B", "Turret2B", "Turret3B", "Turret4B", "Turret5B", 
        "Turret6B", "VatorL", "VatorR", "WingLIn", "WingLMid", "WingLOut", "WingRIn", "WingRMid", "WingROut", "Flap01", 
        "Flap02", "Flap03", "Flap04", "NullPart", "EXPIRED"
    };
    private static final String partNamesForAll[] = {
        "AroneL", "AroneR", "CF", "GearL2", "GearR2", "Keel1", "Oil", "Rudder1", "StabL", "StabR", 
        "Tail1", "VatorL", "VatorR", "WingLIn", "WingLMid", "WingLOut", "WingRIn", "WingRMid", "WingROut"
    };
    private static final long _HIT = 0x100000000000L;
    private static final long _TOMASTER = 0x200000000000L;
    private float VarWing_;
    private float Refuel_;
    public Loc spawnLocSingleCoop;
    public String spawnActorName;
    public boolean stationarySpawnLocSet;
    public static final int END_EXPLODE = 2;
    public static final int END_FM_DESTROY = 3;
    public static final int END_DISAPPEAR = 4;
    private long timePostEndAction;
    public boolean buried;
    protected static final float EpsCoarse_ = 0.03F;
    protected static final float EpsSmooth_ = 0.003F;
    protected static final float EpsVerySmooth_ = 0.0005F;
    private float GearL_;
    private float GearR_;
    private float GearC_;
    private float Rudder_;
    private float Elevator_;
    private float Aileron_;
    private float Flap_;
    private float BayDoor_;
    private float AirBrake_;
    private float Steering_;
    public float wingfold_;
    public float cockpitDoor_;
    public float arrestor_;
    protected float propPos[] = {
        0.0F, 21.6F, 45.9F, 66.9F, 45F, 9.2F, 0.0F, 0.0F
    };
    protected int oldProp[];
    protected static final String Props[][] = {
        {
            "Prop1_D0", "PropRot1_D0", "Prop1_D1"
        }, {
            "Prop2_D0", "PropRot2_D0", "Prop2_D1"
        }, {
            "Prop3_D0", "PropRot3_D0", "Prop3_D1"
        }, {
            "Prop4_D0", "PropRot4_D0", "Prop4_D1"
        }, {
            "Prop5_D0", "PropRot5_D0", "Prop5_D1"
        }, {
            "Prop6_D0", "PropRot6_D0", "Prop6_D1"
        }, {
            "Prop7_D0", "PropRot7_D0", "Prop7_D1"
        }, {
            "Prop8_D0", "PropRot8_D0", "Prop8_D1"
        }
    };
    private LightPointWorld lLight[];
    private Hook lLightHook[];
    private static Loc lLightLoc1 = new Loc();
    private static Point3d lLightP1 = new Point3d();
    private static Point3d lLightP2 = new Point3d();
    private static Point3d lLightPL = new Point3d();
    private String _loadingCountry;
    private String typedName;
    private static String _skinMat[] = {
        "Gloss1D0o", "Gloss1D1o", "Gloss1D2o", "Gloss2D0o", "Gloss2D1o", "Gloss2D2o", "Gloss1D0p", "Gloss1D1p", "Gloss1D2p", "Gloss2D0p", 
        "Gloss2D1p", "Gloss2D2p", "Gloss1D0q", "Gloss1D1q", "Gloss1D2q", "Gloss2D0q", "Gloss2D1q", "Gloss2D2q", "Matt1D0o", "Matt1D1o", 
        "Matt1D2o", "Matt2D0o", "Matt2D1o", "Matt2D2o", "Matt1D0p", "Matt1D1p", "Matt1D2p", "Matt2D0p", "Matt2D1p", "Matt2D2p", 
        "Matt1D0q", "Matt1D1q", "Matt1D2q", "Matt2D0q", "Matt2D1q", "Matt2D2q", "Gloss1aD0o", "Gloss1aD0p", "Gloss1aD0q", "Gloss1aD1o", 
        "Gloss1aD1p", "Gloss1aD1q", "Gloss1aD2o", "Gloss1aD2p", "Gloss1aD2q", "Matt1aD0o", "MattaD0p", "Matt1aD0q", "Matt1aD1o", "Matt1aD1p", 
        "Matt1aD1q", "Matt1aD2o", "Matt1aD2p", "Matt1aD2q"
    };
    private static final String _curSkin[] = {
        "skin1o.tga", "skin1p.tga", "skin1q.tga"
    };
    private static HashMapExt meshCache = new HashMapExt();
    private static HashMapExt airCache = new HashMapExt();
    protected static Loc tmpLocCell = new Loc();
    private boolean wfrGr21dropped;
    private static final Loc engineBurnLightLoc = new Loc(0.0D, 0.0D, 1.5D, 0.0F, 0.0F, 0.0F);
    private static final float defTurretRest[] = {
        0.0F, 0.0F
    };
    protected static Vector3d v1 = new Vector3d();
    private static Vector3f v2 = new Vector3f();
    private static Vector3d Vd = new Vector3d();
    protected static Point3d Pd = new Point3d();
    protected static Point3d tmpP1 = new Point3d();
    protected static Point3d tmpP2 = new Point3d();
    public static Loc tmpLoc1 = new Loc();
    protected static Loc tmpLoc2 = new Loc();
    protected static Loc tmpLoc3 = new Loc();
    protected static Loc tmpLocExp = new Loc();
    public static Orient tmpOr = new Orient();
    private static int tmpBonesHit;
    private static boolean bWasAlive = true;
    public static boolean showTaxingWay = false;
    public static List playerTaxingWay = null;
    public static float taxHlpX = 1.0F;
    private Aircraft bombScoreOwner;
    public boolean hasHumanOnlineBomber;
    public float headingBug;
    public int idleTimeOnCarrier;
    public boolean bSpotter;
    private static final Class planesWithZBReceiver[];
    private float currBomb_M;
    private float currBomb_Kalibr;
    private int currBomb_Type;
    private float currBomb_Crutch;

    static 
    {
        planesWithZBReceiver = (new Class[] {
            com.maddox.il2.objects.air.F4U.class, com.maddox.il2.objects.air.F4F.class, com.maddox.il2.objects.air.TBF.class, com.maddox.il2.objects.air.SBD.class, com.maddox.il2.objects.air.PBYX.class, com.maddox.il2.objects.air.F6F.class, com.maddox.il2.objects.air.F2A2.class, com.maddox.il2.objects.air.SEAFIRE3.class, com.maddox.il2.objects.air.SEAFIRE3F.class, com.maddox.il2.objects.air.Fulmar.class, 
            com.maddox.il2.objects.air.Swordfish.class, com.maddox.il2.objects.air.MOSQUITO.class, com.maddox.il2.objects.air.B_25.class, com.maddox.il2.objects.air.A_20.class, com.maddox.il2.objects.air.B_17.class, com.maddox.il2.objects.air.B_24.class, com.maddox.il2.objects.air.B_29.class, com.maddox.il2.objects.air.BEAU.class, com.maddox.il2.objects.air.P_80.class, com.maddox.il2.objects.air.P_39.class, 
            com.maddox.il2.objects.air.P_51.class, com.maddox.il2.objects.air.P_47.class, com.maddox.il2.objects.air.P_40.class, com.maddox.il2.objects.air.P_40NEW.class, com.maddox.il2.objects.air.P_38.class, com.maddox.il2.objects.air.P_36.class, com.maddox.il2.objects.air.A_20.class, com.maddox.il2.objects.air.C_47.class, com.maddox.il2.objects.air.P_80.class, com.maddox.il2.objects.air.TypeZBReceiver.class
        });
    }
}