
package com.maddox.il2.fm;

import com.maddox.JGP.*;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.game.*;
import com.maddox.il2.objects.air.*;
import com.maddox.il2.objects.sounds.SndAircraft;
import com.maddox.rts.*;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;

public class Motor extends FMMath
{

    public Motor()
    {
        isnd = null;
        reference = null;
        soundName = null;
        startStopName = null;
        propName = null;
        emdName = null;
        emdSubName = null;
        number = 0;
        type = 0;
        cylinders = 12;
        engineMass = 900F;
        wMin = 20F;
        wNom = 180F;
        wMax = 200F;
        wWEP = 220F;
        wMaxAllowed = 250F;
        wNetPrev = 0;
        engineMoment = 0.0F;
        engineMomentMax = 0.0F;
        engineBoostFactor = 1.0F;
        engineAfterburnerBoostFactor = 1.0F;
        engineDistAM = 0.0F;
        engineDistBM = 0.0F;
        engineDistCM = 0.0F;
        bRan = false;
        enginePos = new Point3f();
        engineVector = new Vector3f();
        engineForce = new Vector3f();
        engineTorque = new Vector3f();
        engineDamageAccum = 0.0F;
        _1_wMaxAllowed = 1.0F / wMaxAllowed;
        _1_wMax = 1.0F / wMax;
        RPMMin = 200F;
        RPMNom = 2000F;
        RPMMax = 2200F;
        Vopt = 90F;
        momForFuel = 0.0D;
        addVflow = 0.0D;
        addVside = 0.0D;
        propPos = new Point3f();
        propReductor = 1.0F;
        ApropReductor = 1.0F;
        PropMomentScale = 1.0F;
        ReactiveMomentScale = 1.0F;
        VsideScale = 1.0F;
        propAngleDeviceType = 0;
        propAngleDeviceMinParam = 0.0F;
        propAngleDeviceMaxParam = 0.0F;
        propAngleDeviceAfterburnerParam = -999.9F;
        propDirection = 0;
        propDiameter = 3F;
        propMass = 30F;
        propI = 1.0F;
        propIW = new Vector3d();
        propSEquivalent = 1.0F;
        propr = 1.125F;
        propPhiMin = (float)Math.toRadians(10D);
        propPhiMax = (float)Math.toRadians(29D);
        propPhi = (float)Math.toRadians(11D);
        propAoA0 = (float)Math.toRadians(11D);
        propAoACrit = (float)Math.toRadians(16D);
        propAngleChangeSpeed = 0.1F;
        propForce = 0.0F;
        propMoment = 0.0F;
        propTarget = 0.0F;
        mixerType = 0;
        mixerLowPressureBar = 0.0F;
        horsePowers = 1200F;
        thrustMax = 10.7F;
        cylindersOperable = 12;
        engineI = 1.0F;
        engineAcceleration = 1.0F;
        bIsAutonomous = true;
        bIsMaster = true;
        bIsStuck = false;
        bIsInoperable = false;
        bIsAngleDeviceOperational = true;
        isPropAngleDeviceHydroOperable = true;
        engineCarburetorType = 0;
        FuelConsumptionP0 = 0.4F;
        FuelConsumptionP05 = 0.24F;
        FuelConsumptionP1 = 0.28F;
        FuelConsumptionPMAX = 0.3F;
        FuelRocketCoeff = 2.5777F;
        RadiatorAlgoritm = 0;
        compressorType = 0;
        compressorMaxStep = 0;
        compressorPMax = 1.0F;
        compressorManifoldPressure = 1.0F;
        compressorAltitudes = null;
        compressorPressure = null;
        compressorAltMultipliers = null;
        compressorBaseMultipliers = null;
        compressorRPMtoP0 = 1500F;
        compressorRPMtoCurvature = -30F;
        compressorRPMtoPMax = 2600F;
        compressorRPMtoWMaxATA = 1.45F;
        compressorSpeedManifold = 0.2F;
        compressorRPM = new float[16];
        compressorATA = new float[16];
        nOfCompPoints = 0;
        compressorStepFound = false;
        compressorManifoldThreshold = 1.0F;
        afterburnerCompressorFactor = 1.0F;
        _1_P0 = 1.0F / Atmosphere.P0();
        compressor1stThrottle = 1.0F;
        compressor2ndThrottle = 1.0F;
        compressorPAt0 = 0.3F;
        afterburnerType = 0;
        afterburnerChangeW = false;
        afterburnerMaxAltitude = -99999F;
        stage = 0;
        oldStage = 0;
        timer = 0L;
        given = 0x3fffffffffffffffL;
        rpm = 0.0F;
        w = 0.0F;
        aw = 0.0F;
        oldW = 0.0F;
        readyness = 1.0F;
        oldReadyness = 1.0F;
        radiatorReadyness = 1.0F;
        tOilIn = 0.0F;
        tOilOut = 0.0F;
        tWaterOut = 0.0F;
        tCylinders = 0.0F;
        bHasThrottleControl = true;
        bHasAfterburnerControl = true;
        bHasPropControl = true;
        bHasRadiatorControl = true;
        bHasMixControl = true;
        bHasMagnetoControl = true;
        bHasExtinguisherControl = false;
        bHasCompressorControl = false;
        bHasFeatherControl = false;
        extinguishers = 0;
        controlThrottle = 0.0F;
        controlRadiator = 0.0F;
        controlAfterburner = false;
        controlFAfterburner = 0.0F;
        controlProp = 1.0F;
        bControlPropAuto = true;
        controlMix = 1.0F;
        controlMagneto = 0;
        controlCompressor = 0;
        controlFeather = 0;
        copControlThrottle = 0.0F;
        copControlProp = 0.0F;
        copControlMix = 0.0F;
        copControlBoost = 0.0F;
        copControlSupercharger = 0;
        copControlRadiator = 0.0F;
        neg_G_Counter = 0.0F;
        bFullT = false;
        bFloodCarb = false;
        starter = 0;
        aircraft = null;
        fastATA = false;
        old_engineForce = new Vector3f();
        old_engineTorque = new Vector3f();
        updateStep = 0.12F;
        updateLast = 0.0F;
        fricCoeffT = 1.0F;
        engineNoFuelHUDLogId = -1;
    }

    public void load(FlightModel fmd, String emd, String subModel, int numberInList)
    {
        reference = fmd;
        String emdFileName = "FlightModels/" + emd + ".emd";
        emdName = emd;
        emdSubName = subModel;
        number = numberInList;
        SectFile i = FlightModelMain.sectFile(emdFileName);
        resolveFromFile(i, "Generic");
        resolveFromFile(i, subModel);
        calcAfterburnerCompressorFactor();
        if(type == 0 || type == 1 || type == 7 || type == 9)
            initializeInline(((FlightModelMain) (fmd)).Vmax);
        if(type == 2)
            initializeJet(((FlightModelMain) (fmd)).Vmax);
        if(type == 10)
            initializeJet(((FlightModelMain) (fmd)).Vmax);
    }

    private void resolveFromFile(SectFile i, String section)
    {
        soundName = i.get(section, "SoundName", soundName);
        propName = i.get(section, "PropName", propName);
        startStopName = i.get(section, "StartStopName", startStopName);
        Aircraft.debugprintln(((Interpolate) (reference)).actor, "Resolving submodel " + section + " from file '" + i.toString() + "'....");
        String s = i.get(section, "Type");
        if(s != null)
            if(s.endsWith("Inline"))
                type = 0;
            else
            if(s.endsWith("Radial"))
                type = 1;
            else
            if(s.endsWith("Jet"))
                type = 2;
            else
            if(s.endsWith("RocketBoost"))
                type = 4;
            else
            if(s.endsWith("Rocket"))
                type = 3;
            else
            if(s.endsWith("Tow"))
                type = 5;
            else
            if(s.endsWith("PVRD"))
                type = 6;
            else
            if(s.endsWith("Unknown"))
                type = 8;
            else
            if(s.endsWith("Azure"))
                type = 8;
            else
            if(s.endsWith("HeloI"))
                type = 7;
            else
            if(s.endsWith("Rotary"))
                type = 9;
            else
            if(s.endsWith("Turboprop"))
                type = 10;
        int t;
        if(type == 0 || type == 1 || type == 7 || type == 9)
        {
            t = i.get(section, "Cylinders", 0xfffe7961);
            if(t != 0xfffe7961)
            {
                cylinders = t;
                cylindersOperable = cylinders;
            }
        }
        s = i.get(section, "Direction");
        if(s != null)
            if(s.endsWith("Left"))
                propDirection = 0;
            else
            if(s.endsWith("Right"))
                propDirection = 1;
        float f = i.get(section, "RPMMin", -99999F);
        if(f != -99999F)
        {
            RPMMin = f;
            wMin = toRadianPerSecond(RPMMin);
        }
        f = i.get(section, "RPMNom", -99999F);
        if(f != -99999F)
        {
            RPMNom = f;
            wNom = toRadianPerSecond(RPMNom);
        }
        f = i.get(section, "RPMMax", -99999F);
        if(f != -99999F)
        {
            RPMMax = f;
            wMax = toRadianPerSecond(RPMMax);
            _1_wMax = 1.0F / wMax;
        }
        f = i.get(section, "RPMMaxAllowed", -99999F);
        if(f != -99999F)
        {
            wMaxAllowed = toRadianPerSecond(f);
            _1_wMaxAllowed = 1.0F / wMaxAllowed;
        }
        f = i.get(section, "Reductor", -99999F);
        if(f != -99999F)
            propReductor = f;
        f = i.get(section, "AnimationReductor", -99999F);
        if(f != -99999F)
            ApropReductor = f;
        else
            ApropReductor = 1.0F;
        f = i.get(section, "PropMomentScale", -99999F);
        if(f != -99999F)
            PropMomentScale = f;
        else
            PropMomentScale = 1.0F;
        f = i.get(section, "ReactiveMomentScale", -99999F);
        if(f != -99999F)
            ReactiveMomentScale = f;
        else
            ReactiveMomentScale = 1.0F;
        f = i.get(section, "VsideScale", -99999F);
        if(f != -99999F)
            VsideScale = f;
        else
            VsideScale = 1.0F;
        if(type == 0 || type == 1 || type == 7 || type == 9)
        {
            f = i.get(section, "HorsePowers", -99999F);
            if(f != -99999F)
                horsePowers = f;
            t = i.get(section, "Carburetor", 0xfffe7961);
            if(t != 0xfffe7961)
                engineCarburetorType = t;
            f = i.get(section, "Mass", -99999F);
            if(f != -99999F)
                engineMass = f;
            else
                engineMass = horsePowers * 0.6F;
        } else
        {
            f = i.get(section, "Thrust", -99999F);
            if(f != -99999F)
                thrustMax = f * 9.81F;
        }
        s = i.get(section, "Starter");
        if(s != null)
        {
            s = s.trim();
            starter = -1;
            for(int starterTypeIndex = 0; starterTypeIndex < starterTypes.length; starterTypeIndex++)
            {
                if(s.indexOf(starterTypes[starterTypeIndex]) == -1)
                    continue;
                starter = starterTypeIndex;
                break;
            }

            if(starter == -1)
            {
                if(type == 9)
                    starter = 1;
                if(starter < 0)
                    starter = 0;
            }
        }
        System.out.println("Motor resolveFromFile starter = " + starter);
        f = i.get(section, "BoostFactor", -99999F);
        if(f != -99999F)
            engineBoostFactor = f;
        f = i.get(section, "WEPBoostFactor", -99999F);
        if(f != -99999F)
            engineAfterburnerBoostFactor = f;
        t = i.get(section, "RadiatorAlgoritm", 0xfffe7961);
        if(t != 0xfffe7961)
            RadiatorAlgoritm = t;
        if(type == 2)
        {
            FuelConsumptionP0 = 0.075F;
            FuelConsumptionP05 = 0.075F;
            FuelConsumptionP1 = 0.1F;
            FuelConsumptionPMAX = 0.11F;
        }
        if(type == 6)
        {
            FuelConsumptionP0 = 0.835F;
            FuelConsumptionP05 = 0.835F;
            FuelConsumptionP1 = 0.835F;
            FuelConsumptionPMAX = 0.835F;
        }
        f = i.get(section, "FuelConsumptionP0", -99999F);
        if(f != -99999F)
            FuelConsumptionP0 = f;
        f = i.get(section, "FuelConsumptionP05", -99999F);
        if(f != -99999F)
            FuelConsumptionP05 = f;
        f = i.get(section, "FuelConsumptionP1", -99999F);
        if(f != -99999F)
            FuelConsumptionP1 = f;
        f = i.get(section, "FuelConsumptionPMAX", -99999F);
        if(f != -99999F)
            FuelConsumptionPMAX = f;
        f = i.get(section, "FuelRocketCoeff", -99999F);
        if(f != -99999F)
            FuelRocketCoeff = f;
        else
        if(type == 4)
            FuelRocketCoeff = 1.432056F;
        else
            FuelRocketCoeff = 2.5777F;
        fuelConsumption0M = (FuelConsumptionP0 - FuelConsumptionP05) * 4F;
        fuelConsumption1M = (FuelConsumptionP1 - FuelConsumptionP05) * 4F;
        t = i.get(section, "Autonomous", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bIsAutonomous = false;
            else
            if(t == 1)
                bIsAutonomous = true;
        t = i.get(section, "cThrottle", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bHasThrottleControl = false;
            else
            if(t == 1)
                bHasThrottleControl = true;
        t = i.get(section, "cAfterburner", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bHasAfterburnerControl = false;
            else
            if(t == 1)
                bHasAfterburnerControl = true;
        t = i.get(section, "cProp", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bHasPropControl = false;
            else
            if(t == 1)
                bHasPropControl = true;
        t = i.get(section, "cMix", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bHasMixControl = false;
            else
            if(t == 1)
                bHasMixControl = true;
        t = i.get(section, "cMagneto", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bHasMagnetoControl = false;
            else
            if(t == 1)
                bHasMagnetoControl = true;
        t = i.get(section, "cCompressor", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bHasCompressorControl = false;
            else
            if(t == 1)
                bHasCompressorControl = true;
        t = i.get(section, "cFeather", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bHasFeatherControl = false;
            else
            if(t == 1)
                bHasFeatherControl = true;
        t = i.get(section, "cRadiator", 0xfffe7961);
        if(t != 0xfffe7961)
            if(t == 0)
                bHasRadiatorControl = false;
            else
            if(t == 1)
                bHasRadiatorControl = true;
        t = i.get(section, "Extinguishers", 0xfffe7961);
        if(t != 0xfffe7961)
        {
            extinguishers = t;
            if(t != 0)
                bHasExtinguisherControl = true;
            else
                bHasExtinguisherControl = false;
        }
        f = i.get(section, "PropDiameter", -99999F);
        if(f != -99999F)
            propDiameter = f;
        propr = 0.5F * propDiameter * 0.75F;
        f = i.get(section, "PropMass", -99999F);
        if(f != -99999F)
            propMass = f;
        propI = propMass * propDiameter * propDiameter * 0.083F;
        bWepRpmInLowGear = false;
        t = i.get(section, "PropAnglerType", 0xfffe7961);
        if(t != 0xfffe7961)
        {
            if(t > 255)
            {
                bWepRpmInLowGear = (t & 0x100) > 1;
                t -= 256;
            }
            propAngleDeviceType = t;
        }
        f = i.get(section, "PropAnglerSpeed", -99999F);
        if(f != -99999F)
            propAngleChangeSpeed = f;
        f = i.get(section, "PropAnglerMinParam", -99999F);
        if(f != -99999F)
        {
            propAngleDeviceMinParam = f;
            if(propAngleDeviceType == 6 || propAngleDeviceType == 5)
                propAngleDeviceMinParam = (float)Math.toRadians(propAngleDeviceMinParam);
            if(propAngleDeviceType == 1 || propAngleDeviceType == 2 || propAngleDeviceType == 11 || propAngleDeviceType == 12 || propAngleDeviceType == 7 || propAngleDeviceType == 8 || propAngleDeviceType == 9)
                propAngleDeviceMinParam = toRadianPerSecond(propAngleDeviceMinParam);
        }
        f = i.get(section, "PropAnglerMaxParam", -99999F);
        if(f != -99999F)
        {
            propAngleDeviceMaxParam = f;
            if(propAngleDeviceType == 6 || propAngleDeviceType == 5)
                propAngleDeviceMaxParam = (float)Math.toRadians(propAngleDeviceMaxParam);
            if(propAngleDeviceType == 1 || propAngleDeviceType == 2 || propAngleDeviceType == 11 || propAngleDeviceType == 12 || propAngleDeviceType == 7 || propAngleDeviceType == 8 || propAngleDeviceType == 9)
                propAngleDeviceMaxParam = toRadianPerSecond(propAngleDeviceMaxParam);
            if(propAngleDeviceAfterburnerParam == -999.9F)
                propAngleDeviceAfterburnerParam = propAngleDeviceMaxParam;
        }
        f = i.get(section, "PropAnglerAfterburnerParam", -99999F);
        if(f != -99999F)
        {
            propAngleDeviceAfterburnerParam = f;
            wWEP = toRadianPerSecond(propAngleDeviceAfterburnerParam);
            if(wWEP != wMax)
                afterburnerChangeW = true;
            if(propAngleDeviceType == 6 || propAngleDeviceType == 5)
                propAngleDeviceAfterburnerParam = (float)Math.toRadians(propAngleDeviceAfterburnerParam);
            if(propAngleDeviceType == 1 || propAngleDeviceType == 2 || propAngleDeviceType == 11 || propAngleDeviceType == 12 || propAngleDeviceType == 7 || propAngleDeviceType == 8 || propAngleDeviceType == 9)
                propAngleDeviceAfterburnerParam = toRadianPerSecond(propAngleDeviceAfterburnerParam);
        } else
        {
            wWEP = wMax;
        }
        f = i.get(section, "PropPhiMin", -99999F);
        if(f != -99999F)
        {
            propPhiMin = (float)Math.toRadians(f);
            if(propPhi < propPhiMin)
                propPhi = propPhiMin;
            if(propTarget < propPhiMin)
                propTarget = propPhiMin;
        }
        f = i.get(section, "PropPhiMax", -99999F);
        if(f != -99999F)
        {
            propPhiMax = (float)Math.toRadians(f);
            if(propPhi > propPhiMax)
                propPhi = propPhiMax;
            if(propTarget > propPhiMax)
                propTarget = propPhiMax;
        }
        f = i.get(section, "PropAoA0", -99999F);
        if(f != -99999F)
            propAoA0 = (float)Math.toRadians(f);
        t = i.get(section, "CompressorType", 0xfffe7961);
        if(t != 0xfffe7961)
            compressorType = t;
        f = i.get(section, "CompressorPMax", -99999F);
        if(f != -99999F)
            compressorPMax = f;
        t = i.get(section, "CompressorSteps", 0xfffe7961);
        if(t != 0xfffe7961)
        {
            compressorMaxStep = t - 1;
            if(compressorMaxStep < 0)
                compressorMaxStep = 0;
        }
        if(compressorAltitudes != null)
            compressorAltitudes.getClass();
        compressorAltitudes = new float[compressorMaxStep + 1];
        compressorPressure = new float[compressorMaxStep + 1];
        compressorAltMultipliers = new float[compressorMaxStep + 1];
        compressorBaseMultipliers = new float[compressorMaxStep + 1];
        if(compressorAltitudes.length > 0)
        {
            for(int q = 0; q < compressorAltitudes.length; q++)
            {
                f = i.get(section, "CompressorAltitude" + q, -99999F);
                if(f != -99999F)
                {
                    compressorAltitudes[q] = f;
                    compressorPressure[q] = Atmosphere.pressure(compressorAltitudes[q]) * _1_P0;
                }
                f = i.get(section, "CompressorMultiplier" + q, -99999F);
                if(f != -99999F)
                    compressorAltMultipliers[q] = f;
                f = i.get(section, "CompressorBaseMultiplier" + q, -99999F);
                if(f != -99999F)
                    compressorBaseMultipliers[q] = f;
                else
                    compressorBaseMultipliers[q] = 0.8F;
            }

        }
        f = i.get(section, "CompressorRPMP0", -99999F);
        if(f != -99999F)
        {
            compressorRPMtoP0 = f;
            insetrPoiInCompressorPoly(compressorRPMtoP0, 1.0F);
        }
        f = i.get(section, "CompressorRPMCurvature", -99999F);
        if(f != -99999F)
            compressorRPMtoCurvature = f;
        f = i.get(section, "CompressorMaxATARPM", -99999F);
        if(f != -99999F)
        {
            compressorRPMtoWMaxATA = f;
            insetrPoiInCompressorPoly(RPMMax, compressorRPMtoWMaxATA);
        }
        f = i.get(section, "CompressorRPMPMax", -99999F);
        if(f != -99999F)
        {
            compressorRPMtoPMax = f;
            insetrPoiInCompressorPoly(compressorRPMtoPMax, compressorPMax);
        }
        f = i.get(section, "CompressorSpeedManifold", -99999F);
        if(f != -99999F)
            compressorSpeedManifold = f;
        f = i.get(section, "CompressorPAt0", -99999F);
        if(f != -99999F)
            compressorPAt0 = f;
        f = i.get(section, "Voptimal", -99999F);
        if(f != -99999F)
            Vopt = f * 0.277778F;
        boolean tryToFind = true;
        float foundRPM = 2000F;
        float foundATA = 1.0F;
        int compRPMCOunter = 0;
        while(tryToFind) 
        {
            f = i.get(section, "CompressorRPM" + compRPMCOunter, -99999F);
            if(f != -99999F)
                foundRPM = f;
            else
                tryToFind = false;
            f = i.get(section, "CompressorATA" + compRPMCOunter, -99999F);
            if(f != -99999F)
                foundATA = f;
            else
                tryToFind = false;
            if(tryToFind)
                insetrPoiInCompressorPoly(foundRPM, foundATA);
            compRPMCOunter++;
            if(nOfCompPoints > 15 || compRPMCOunter > 15)
                tryToFind = false;
        }
        t = i.get(section, "AfterburnerType", 0xfffe7961);
        if(t != 0xfffe7961)
        {
            afterburnerType = t;
            f = i.get(section, "AfterburnerMaxAltitude", -99999F);
            if(f != -99999F)
                afterburnerMaxAltitude = f;
        }
        t = i.get(section, "MixerType", 0xfffe7961);
        if(t != 0xfffe7961)
            mixerType = t;
        f = i.get(section, "MixerAltitude", -99999F);
        if(f != -99999F)
            mixerLowPressureBar = Atmosphere.pressure(f) / Atmosphere.P0();
        f = i.get(section, "EngineI", -99999F);
        if(f != -99999F)
            engineI = f;
        f = i.get(section, "EngineAcceleration", -99999F);
        if(f != -99999F)
            engineAcceleration = f;
        f = i.get(section, "DisP0x", -99999F);
        if(f != -99999F)
        {
            float p0x = i.get(section, "DisP0x", -99999F);
            p0x = toRadianPerSecond(p0x);
            float p0y = i.get(section, "DisP0y", -99999F);
            p0y *= 0.01F;
            float p1x = i.get(section, "DisP1x", -99999F);
            p1x = toRadianPerSecond(p1x);
            float p1y = i.get(section, "DisP1y", -99999F);
            p1y *= 0.01F;
            float n = p0x;
            float y = p0y;
            float nu2 = (p1x - p0x) * (p1x - p0x);
            float xi = p1y - p0y;
            engineDistAM = xi / nu2;
            engineDistBM = (-2F * xi * n) / nu2;
            engineDistCM = y + (xi * n * n) / nu2;
        }
        timeCounter = 0.0F;
        f = i.get(section, "TESPEED", -99999F);
        if(f != -99999F)
            tChangeSpeed = f;
        f = i.get(section, "TWATERMAXRPM", -99999F);
        if(f != -99999F)
            tWaterMaxRPM = f;
        f = i.get(section, "TOILINMAXRPM", -99999F);
        if(f != -99999F)
            tOilInMaxRPM = f;
        f = i.get(section, "TOILOUTMAXRPM", -99999F);
        if(f != -99999F)
            tOilOutMaxRPM = f;
        f = i.get(section, "MAXRPMTIME", -99999F);
        if(f != -99999F)
            timeOverheat = f;
        f = i.get(section, "MINRPMTIME", -99999F);
        if(f != -99999F)
            timeUnderheat = f;
        f = i.get(section, "TWATERMAX", -99999F);
        if(f != -99999F)
            tWaterCritMax = f;
        f = i.get(section, "TWATERMIN", -99999F);
        if(f != -99999F)
            tWaterCritMin = f;
        f = i.get(section, "TOILMAX", -99999F);
        if(f != -99999F)
            tOilCritMax = f;
        f = i.get(section, "TOILMIN", -99999F);
        if(f != -99999F)
            tOilCritMin = f;
        coolMult = 1.0F;
    }

    private void initializeInline(float vmax)
    {
        propSEquivalent = 0.26F * propr * propr;
        engineMomentMax = (horsePowers * 746F * 1.2F) / wMax;
    }

    private void initializeJet(float vmax)
    {
        if(type == 10)
            propSEquivalent = 0.26F * propr * propr;
        else
            propSEquivalent = ((float)(cylinders * cylinders) * (2.0F * thrustMax)) / (getFanCy(propAoA0) * Atmosphere.ro0() * wMax * wMax * propr * propr);
        computePropForces(wMax, 0.0F, 0.0F, propAoA0, 0.0F);
        engineMomentMax = propMoment;
    }

    public void initializeTowString(float curForce)
    {
        propForce = curForce;
    }

    public void setMaster(boolean master)
    {
        bIsMaster = master;
    }

    private void insetrPoiInCompressorPoly(float RPM, float ATA)
    {
        int i;
        for(i = 0; i < nOfCompPoints; i++)
        {
            if(compressorRPM[i] < RPM)
                continue;
            if(compressorRPM[i] == RPM)
                return;
            break;
        }

        for(int j = nOfCompPoints - 1; j >= i; j--)
        {
            compressorRPM[j + 1] = compressorRPM[j];
            compressorATA[j + 1] = compressorATA[j];
        }

        nOfCompPoints++;
        compressorRPM[i] = RPM;
        compressorATA[i] = ATA;
    }

    private void calcAfterburnerCompressorFactor()
    {
        if(afterburnerType == 1 || afterburnerType == 7 || afterburnerType == 8 || afterburnerType == 10 || afterburnerType == 12 || afterburnerType == 11 || afterburnerType == 6 || afterburnerType == 5 || afterburnerType == 9 || afterburnerType == 4)
        {
            float maxRPM = compressorRPM[nOfCompPoints - 1];
            float maxATA = compressorATA[nOfCompPoints - 1];
            nOfCompPoints--;
            int p1 = 0;
            int p2 = 1;
            float ATA = 1.0F;
            float RPM = maxRPM;
            if(nOfCompPoints < 2)
            {
                afterburnerCompressorFactor = 1.0F;
                return;
            }
            if((double)RPM < 0.10000000000000001D)
                ATA = Atmosphere.pressure((float)((Tuple3d) (((FlightModelMain) (reference)).Loc)).z) * _1_P0;
            else
            if(RPM >= compressorRPM[nOfCompPoints - 1])
            {
                ATA = compressorATA[nOfCompPoints - 1];
            } else
            {
                if(RPM < compressorRPM[0])
                {
                    p1 = 0;
                    p2 = 1;
                } else
                {
                    for(int i = 0; i < nOfCompPoints - 1; i++)
                    {
                        if(compressorRPM[i] > RPM || RPM >= compressorRPM[i + 1])
                            continue;
                        p1 = i;
                        p2 = i + 1;
                        break;
                    }

                }
                float dRPM = compressorRPM[p2] - compressorRPM[p1];
                if(dRPM < 0.001F)
                    dRPM = 0.001F;
                ATA = compressorATA[p1] + ((RPM - compressorRPM[p1]) * (compressorATA[p2] - compressorATA[p1])) / dRPM;
            }
            afterburnerCompressorFactor = maxATA / ATA;
        } else
        {
            afterburnerCompressorFactor = 1.0F;
        }
    }

    public float getATA(float RPM)
    {
        int p1 = 0;
        int p2 = 1;
        float ATA = 1.0F;
        if(nOfCompPoints < 2)
            return 1.0F;
        if((double)RPM < 0.10000000000000001D)
            ATA = Atmosphere.pressure((float)((Tuple3d) (((FlightModelMain) (reference)).Loc)).z) * _1_P0;
        else
        if(RPM >= compressorRPM[nOfCompPoints - 1])
        {
            ATA = compressorATA[nOfCompPoints - 1];
        } else
        {
            if(RPM < compressorRPM[0])
            {
                p1 = 0;
                p2 = 1;
            } else
            {
                for(int i = 0; i < nOfCompPoints - 1; i++)
                {
                    if(compressorRPM[i] > RPM || RPM >= compressorRPM[i + 1])
                        continue;
                    p1 = i;
                    p2 = i + 1;
                    break;
                }

            }
            float dRPM = compressorRPM[p2] - compressorRPM[p1];
            if(dRPM < 0.001F)
                dRPM = 0.001F;
            ATA = compressorATA[p1] + ((RPM - compressorRPM[p1]) * (compressorATA[p2] - compressorATA[p1])) / dRPM;
        }
        return ATA;
    }

    public void update(float dt)
    {
        if(!(reference instanceof RealFlightModel) && Time.tickCounter() > 200)
        {
            updateLast += dt;
            if(updateLast >= updateStep)
            {
                dt = updateLast;
            } else
            {
                engineForce.set(old_engineForce);
                engineTorque.set(old_engineTorque);
                return;
            }
        }
        producedDistabilisation = 0.0F;
        pressureExtBar = Atmosphere.pressure(reference.getAltitude()) + compressorSpeedManifold * 0.5F * Atmosphere.density(reference.getAltitude()) * reference.getSpeed() * reference.getSpeed();
        pressureExtBar *= 9.8716682999999996E-006D;
        if(controlThrottle > 1.0F && engineBoostFactor == 1.0F)
        {
            ((FlightModelMain) (reference)).CT.setPowerControl(1.0F);
            if(reference.isPlayers() && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode())
                HUD.log(AircraftHotKeys.hudLogPowerId, "Power", new Object[] {
                    new Integer(100)
                });
        }
        computeForces(dt);
        computeStage(dt);
        if(stage > 0 && stage < 6)
            engineForce.set(0.0F, 0.0F, 0.0F);
        else
        if(stage == 8)
            rpm = w = 0.0F;
        if(reference.isPlayers())
        {
            if(bIsMaster && (reference instanceof RealFlightModel))
            {
                computeTemperature(dt);
                if(World.cur().diffCur.Reliability)
                    computeReliability(dt);
            }
            if(World.cur().diffCur.Limited_Fuel)
                computeFuel(dt);
        } else
        {
            computeFuel(dt);
            if(bIsMaster && reference.isTick(32, 0))
                computeTemperature(dt * 32F);
        }
        old_engineForce.set(engineForce);
        old_engineTorque.set(engineTorque);
        updateLast = 0.0F;
        float newStep = 0.5F / (Math.abs(aw) + 1.0F) - 0.1F;
        if(newStep < 0.025F)
            newStep = 0.025F;
        if(newStep > 0.4F)
            newStep = 0.4F;
        if(newStep < updateStep)
            updateStep = 0.9F * updateStep + 0.1F * newStep;
        else
            updateStep = 0.99F * updateStep + 0.01F * newStep;
    }

    public void netupdate(float dt, boolean isNetTrack)
    {
        computeStage(dt);
        if((double)Math.abs(w) < 1.0000000000000001E-005D)
            propPhiW = 1.570796F;
        else
            propPhiW = (float)Math.atan(((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x / (double)(w * propReductor * propr));
        propAoA = propPhi - propPhiW;
        computePropForces(w * propReductor, (float)((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x, propPhi, propAoA, reference.getAltitude());
        float tw = w;
        float tphi = propPhi;
        float sav = compressorManifoldPressure;
        computeForces(dt);
        if(isNetTrack)
            compressorManifoldPressure = sav;
        w = tw;
        propPhi = tphi;
        rpm = toRPM(w);
    }

    public void setReadyness(Actor initiator, float value)
    {
        if(value > 1.0F)
            value = 1.0F;
        if(value < 0.0F)
            value = 0.0F;
        if(!Actor.isAlive(initiator))
            return;
        if(bIsMaster)
        {
            if(readyness > 0.0F && value == 0.0F)
            {
                readyness = 0.0F;
                setEngineDies(initiator);
                return;
            }
            doSetReadyness(value);
        }
        if(Math.abs(oldReadyness - readyness) > 0.1F)
        {
            ((FlightModelMain) (reference)).AS.setEngineReadyness(initiator, number, (int)(value * 100F));
            oldReadyness = readyness;
        }
    }

    private void setReadyness(float value)
    {
        setReadyness(((Interpolate) (reference)).actor, value);
    }

    public void doSetReadyness(float value)
    {
        readyness = value;
    }

    public void setStage(Actor initiator, int value)
    {
        if(!Actor.isAlive(initiator))
            return;
        if(bIsMaster)
            doSetStage(value);
        ((FlightModelMain) (reference)).AS.setEngineStage(initiator, number, value);
    }

    public void doSetStage(int value)
    {
        stage = value;
    }

    public void setEngineStarts(Actor initiator)
    {
        if(!bIsMaster || !Actor.isAlive(initiator))
            return;
        if(isHasControlMagnetos() && getMagnetoMultiplier() < 0.1F)
        {
            return;
        } else
        {
            ((FlightModelMain) (reference)).AS.setEngineStarts(number);
            return;
        }
    }

    public void doSetEngineStarts()
    {
        if(Airport.distToNearestAirport(((FlightModelMain) (reference)).Loc) < 1200D && reference.isStationedOnGround())
        {
            ((FlightModelMain) (reference)).CT.setMagnetoControl(3);
            setControlMagneto(3);
            stage = 1;
            bRan = false;
            timer = Time.current();
            return;
        }
        if(stage == 0)
        {
            if(type == 9 && bRan)
            {
                if(w > 10F)
                    stage = 5;
                else
                if(w > 150F)
                {
                    stage = 6;
                } else
                {
                    ((FlightModelMain) (reference)).CT.setMagnetoControl(3);
                    setControlMagneto(3);
                    stage = 1;
                    timer = Time.current();
                }
            } else
            if((type == 0 || type == 1 || type == 7) && bRan)
            {
                if(w > 20F)
                    stage = 5;
                else
                if(w > 150F)
                    stage = 6;
            } else
            {
                ((FlightModelMain) (reference)).CT.setMagnetoControl(3);
            }
            setControlMagneto(3);
            stage = 1;
            timer = Time.current();
        }
    }

    public void setEngineStops(Actor initiator)
    {
        if(!Actor.isAlive(initiator))
            return;
        if(stage < 1 || stage > 6)
        {
            return;
        } else
        {
            ((FlightModelMain) (reference)).AS.setEngineStops(number);
            return;
        }
    }

    public void doSetEngineStops()
    {
        if(stage != 0)
        {
            stage = 0;
            setControlMagneto(0);
            timer = Time.current();
        }
    }

    public void setEngineDies(Actor initiator)
    {
        if(stage > 6)
        {
            return;
        } else
        {
            ((FlightModelMain) (reference)).AS.setEngineDies(((Interpolate) (reference)).actor, number);
            return;
        }
    }

    public void doSetEngineDies()
    {
        if(stage < 7)
        {
            bIsInoperable = true;
            reference.setCapableOfTaxiing(false);
            reference.setCapableOfACM(false);
            doSetReadyness(0.0F);
            float EngDem = 0.0F;
            int EngNum = ((FlightModelMain) (reference)).EI.getNum();
            if(EngNum != 0)
            {
                for(int i = 0; i < EngNum; i++)
                    EngDem += ((FlightModelMain) (reference)).EI.engines[i].getReadyness() / (float)EngNum;

                if(EngDem < 0.7F)
                    reference.setReadyToReturn(true);
                if(EngDem < 0.3F)
                    reference.setReadyToDie(true);
            }
            stage = 7;
            if(reference.isPlayers())
                HUD.log("FailedEngine");
            timer = Time.current();
        }
    }

    public void setEngineRunning(Actor initiator)
    {
        if(!bIsMaster || !Actor.isAlive(initiator))
        {
            return;
        } else
        {
            ((FlightModelMain) (reference)).AS.setEngineRunning(number);
            return;
        }
    }

    public void doSetEngineRunning()
    {
        if(stage >= 6)
            return;
        stage = 6;
        ((FlightModelMain) (reference)).CT.setMagnetoControl(3);
        setControlMagneto(3);
        if(reference.isPlayers())
            HUD.log("EngineI1");
        w = wMax * 0.75F;
        tWaterOut = 0.5F * (tWaterCritMin + tWaterMaxRPM);
        tOilOut = 0.5F * (tOilCritMin + tOilOutMaxRPM);
        tOilIn = 0.5F * (tOilCritMin + tOilInMaxRPM);
        propPhi = 0.5F * (propPhiMin + propPhiMax);
        propTarget = propPhi;
        if(isnd != null)
            isnd.onEngineState(stage);
    }

    public void setKillCompressor(Actor initiator)
    {
        ((FlightModelMain) (reference)).AS.setEngineSpecificDamage(initiator, number, 0);
    }

    public void doSetKillCompressor()
    {
        switch(compressorType)
        {
        default:
            break;

        case 2: // '\002'
            compressorAltitudes[0] = 50F;
            compressorAltMultipliers[0] = 1.0F;
            break;

        case 1: // '\001'
            for(int i = 0; i < compressorMaxStep; i++)
            {
                compressorAltitudes[i] = 50F;
                compressorAltMultipliers[i] = 1.0F;
            }

            break;
        }
    }

    public void setKillPropAngleDevice(Actor initiator)
    {
        ((FlightModelMain) (reference)).AS.setEngineSpecificDamage(initiator, number, 3);
    }

    public void doSetKillPropAngleDevice()
    {
        bIsAngleDeviceOperational = false;
    }

    public void setKillPropAngleDeviceSpeeds(Actor initiator)
    {
        ((FlightModelMain) (reference)).AS.setEngineSpecificDamage(initiator, number, 4);
    }

    public void doSetKillPropAngleDeviceSpeeds()
    {
        isPropAngleDeviceHydroOperable = false;
    }

    public void setCyliderKnockOut(Actor initiator, int value)
    {
        ((FlightModelMain) (reference)).AS.setEngineCylinderKnockOut(initiator, number, value);
    }

    public void doSetCyliderKnockOut(int value)
    {
        cylindersOperable -= value;
        if(cylindersOperable < 0)
            cylindersOperable = 0;
        if(bIsMaster)
            if(getCylindersRatio() < 0.12F)
                setEngineDies(((Interpolate) (reference)).actor);
            else
            if(getCylindersRatio() < getReadyness())
                setReadyness(((Interpolate) (reference)).actor, getCylindersRatio());
    }

    public void setMagnetoKnockOut(Actor initiator, int num)
    {
        ((FlightModelMain) (reference)).AS.setEngineMagnetoKnockOut(((Interpolate) (reference)).actor, number, num);
    }

    public void doSetMagnetoKnockOut(int number)
    {
        bMagnetos[number] = false;
        if(number == controlMagneto)
            setEngineStops(((Interpolate) (reference)).actor);
    }

    public void setEngineStuck(Actor initiator)
    {
        ((FlightModelMain) (reference)).AS.setEngineStuck(initiator, number);
    }

    public void doSetEngineStuck()
    {
        bIsInoperable = true;
        reference.setCapableOfTaxiing(false);
        reference.setCapableOfACM(false);
        if(stage != 8)
        {
            setReadyness(0.0F);
            if(reference.isPlayers() && stage != 7)
                HUD.log("FailedEngine");
            stage = 8;
            timer = Time.current();
        }
    }

    public void setw(float value)
    {
        w = value;
        rpm = toRPM(w);
    }

    public void setPropPhi(float value)
    {
        propPhi = value;
    }

    public void setEngineMomentMax(float value)
    {
        engineMomentMax = value;
    }

    public void setPos(Point3d p)
    {
        enginePos.set(p);
    }

    public void setPropPos(Point3d p)
    {
        propPos.set(p);
    }

    public void setVector(Vector3f v)
    {
        engineVector.set(v);
        engineVector.normalize();
    }

    public void setControlThrottle(float value)
    {
        if(bHasThrottleControl)
        {
            if(afterburnerType == 4)
            {
                if(value > 1.0F && controlThrottle <= 1.0F && ((FlightModelMain) (reference)).M.requestNitro(0.0001F))
                {
                    ((FlightModelMain) (reference)).CT.setAfterburnerControl(true);
                    setControlAfterburner(true);
                    if(reference.isPlayers())
                    {
                        Main3D.cur3D().aircraftHotKeys.setAfterburnerForAutoActivation(true);
                        HUD.logRightBottom("BoostWepTP4");
                    }
                }
                if(value < 1.0F && controlThrottle >= 1.0F)
                {
                    ((FlightModelMain) (reference)).CT.setAfterburnerControl(false);
                    setControlAfterburner(false);
                    if(reference.isPlayers())
                    {
                        Main3D.cur3D().aircraftHotKeys.setAfterburnerForAutoActivation(false);
                        HUD.logRightBottom(null);
                    }
                }
            } else
            if(afterburnerType == 8)
            {
                if(value > 1.0F && controlThrottle <= 1.0F)
                {
                    ((FlightModelMain) (reference)).CT.setAfterburnerControl(true);
                    setControlAfterburner(true);
                    if(reference.isPlayers())
                    {
                        Main3D.cur3D().aircraftHotKeys.setAfterburnerForAutoActivation(true);
                        HUD.logRightBottom("BoostWepTP7");
                    }
                }
                if(value < 1.0F && controlThrottle >= 1.0F)
                {
                    ((FlightModelMain) (reference)).CT.setAfterburnerControl(false);
                    setControlAfterburner(false);
                    if(reference.isPlayers())
                    {
                        Main3D.cur3D().aircraftHotKeys.setAfterburnerForAutoActivation(false);
                        HUD.logRightBottom(null);
                    }
                }
            } else
            if(afterburnerType == 10)
            {
                if(value > 1.0F && controlThrottle <= 1.0F)
                {
                    ((FlightModelMain) (reference)).CT.setAfterburnerControl(true);
                    setControlAfterburner(true);
                    if(reference.isPlayers())
                    {
                        Main3D.cur3D().aircraftHotKeys.setAfterburnerForAutoActivation(true);
                        HUD.logRightBottom("BoostWepTP0");
                    }
                }
                if(value < 1.0F && controlThrottle >= 1.0F)
                {
                    ((FlightModelMain) (reference)).CT.setAfterburnerControl(false);
                    setControlAfterburner(false);
                    if(reference.isPlayers())
                    {
                        Main3D.cur3D().aircraftHotKeys.setAfterburnerForAutoActivation(false);
                        HUD.logRightBottom(null);
                    }
                }
            }
            controlThrottle = value;
        }
    }

    public void setManualControlAfterburner(float val)
    {
        controlFAfterburner = val;
    }

    public void setControlAfterburner(boolean val)
    {
        if(bHasAfterburnerControl)
        {
            if(afterburnerType == 1 && !controlAfterburner && val && controlThrottle > 1.0F && World.Rnd().nextFloat() < 0.5F && reference.isPlayers() && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode() && World.cur().diffCur.Vulnerability)
                setCyliderKnockOut(((Interpolate) (reference)).actor, World.Rnd().nextInt(0, 3));
            controlAfterburner = val;
        }
        if(afterburnerType == 4 || afterburnerType == 8 || afterburnerType == 10)
            controlAfterburner = val;
    }

    public void doSetKillControlThrottle()
    {
        bHasThrottleControl = false;
    }

    public void setControlPropDelta(int direction)
    {
        controlPropDirection = direction;
    }

    public int getControlPropDelta()
    {
        return controlPropDirection;
    }

    public void doSetKillControlAfterburner()
    {
        bHasAfterburnerControl = false;
    }

    public void setControlProp(float value)
    {
        if(bHasPropControl)
            controlProp = value;
    }

    public void setControlPropAuto(boolean value)
    {
        if(bHasPropControl)
            bControlPropAuto = value && isAllowsAutoProp();
    }

    public void doSetKillControlProp()
    {
        bHasPropControl = false;
    }

    public void setControlMix(float value)
    {
        if(bHasMixControl)
            switch(mixerType)
            {
            case 0: // '\0'
                controlMix = value;
                break;

            case 1: // '\001'
                controlMix = value;
                if(controlMix < 1.0F)
                    controlMix = 1.0F;
                break;

            default:
                controlMix = value;
                break;
            }
    }

    public int getMixerType()
    {
        return mixerType;
    }

    public void doSetKillControlMix()
    {
        bHasMixControl = false;
    }

    public void setControlMagneto(int value)
    {
        if(bHasMagnetoControl)
        {
            controlMagneto = value;
            if(value == 0)
                setEngineStops(((Interpolate) (reference)).actor);
        }
    }

    public void setControlCompressor(int value)
    {
        if(bHasCompressorControl)
            controlCompressor = value;
    }

    public void setControlFeather(int value)
    {
        if(bHasFeatherControl)
        {
            controlFeather = value;
            if(reference.isPlayers())
                HUD.log("EngineFeather" + controlFeather);
        }
    }

    public void setControlRadiator(float value)
    {
        if(bHasRadiatorControl)
            controlRadiator = value;
    }

    public void setExtinguisherFire()
    {
        if(!bIsMaster)
            return;
        if(bHasExtinguisherControl)
        {
            ((FlightModelMain) (reference)).AS.setEngineSpecificDamage(((Interpolate) (reference)).actor, number, 5);
            if(((FlightModelMain) (reference)).AS.astateEngineStates[number] > 2)
                ((FlightModelMain) (reference)).AS.setEngineState(((Interpolate) (reference)).actor, number, World.Rnd().nextInt(1, 2));
            else
            if(((FlightModelMain) (reference)).AS.astateEngineStates[number] > 0)
                ((FlightModelMain) (reference)).AS.setEngineState(((Interpolate) (reference)).actor, number, 0);
        }
    }

    public void doSetExtinguisherFire()
    {
        if(!bHasExtinguisherControl)
            return;
        if(((FlightModelMain) (reference)).AS.bIsAboutToBailout)
            return;
        extinguishers--;
        if(extinguishers == 0)
            bHasExtinguisherControl = false;
        ((FlightModelMain) (reference)).AS.doSetEngineExtinguisherVisuals(number);
        if(bIsMaster)
        {
            if(((FlightModelMain) (reference)).AS.astateEngineStates[number] > 1 && World.Rnd().nextFloat() < 0.56F)
                ((FlightModelMain) (reference)).AS.repairEngine(number);
            if(((FlightModelMain) (reference)).AS.astateEngineStates[number] > 3 && World.Rnd().nextFloat() < 0.21F)
            {
                ((FlightModelMain) (reference)).AS.repairEngine(number);
                ((FlightModelMain) (reference)).AS.repairEngine(number);
            }
            tWaterOut -= 4F;
            tOilIn -= 4F;
            tOilOut -= 4F;
        }
        if(reference.isPlayers())
            HUD.log("ExtinguishersFired");
    }

    private void computeStage(final float dt) {
        if (this.stage == 6) {
            return;
        }
        Motor.bTFirst = false;
        final float tAir = 20.0f;
        long passed = Time.current() - this.timer;
        if (this.stage > 0 && this.stage < 6 && passed > this.given) {
            ++this.stage;
            this.aircraft = (AircraftLH)World.getPlayerAircraft();
            if (((FlightModelMain)((SndAircraft)this.aircraft).FM).isPlayers()) {
                if ((this.type == 0 || this.type == 7) && this.starter != 1) {
                    if (this.starter == 2 && this.stage > 3 && World.Rnd().nextFloat(0.0f, 10.0f) < 2.0f) {
                        this.stage = 3;
                    }
                    if ((this.starter == 0 || this.starter == 3 || this.starter == 5) && this.stage > 3) {
                        if (World.Rnd().nextFloat(0.0f, 20.0f) < 0.25f && ((FlightModelMain)this.reference).isStationedOnGround()) {
                            this.stage = 0;
                        }
                        else if (World.Rnd().nextFloat(0.0f, 40.0f) < 3.0f) {
                            this.stage = 3;
                        }
                    }
                }
                if (this.type == 1 && this.starter != 1) {
                    if (this.starter == 2) {
                        if (this.stage == 3 && World.Rnd().nextFloat(0.0f, 40.0f) < 2.0f) {
                            this.stage = 2;
                        }
                        else if (this.stage > 3 && World.Rnd().nextFloat(0.0f, 40.0f) < 3.0f) {
                            this.stage = 3;
                        }
                    }
                    if (this.starter == 0 || this.starter == 3 || this.starter == 5) {
                        if (this.stage > 3 && World.Rnd().nextFloat(0.0f, 20.0f) < 0.25f && ((FlightModelMain)this.reference).isStationedOnGround()) {
                            this.stage = 0;
                        }
                        else if (this.stage == 3 && World.Rnd().nextFloat(0.0f, 40.0f) < 1.0f) {
                            this.stage = 2;
                        }
                        else if (this.stage > 3 && World.Rnd().nextFloat(0.0f, 40.0f) < 3.0f) {
                            this.stage = 3;
                        }
                    }
                }
                if (this.starter == 1 || this.type == 9) {
                    if (this.stage > 3 && World.Rnd().nextFloat(0.0f, 30.0f) < 2.0f && ((FlightModelMain)this.reference).isStationedOnGround()) {
                        this.stage = 0;
                    }
                    else if (this.stage == 3 && World.Rnd().nextFloat(0.0f, 40.0f) < 2.0f) {
                        this.stage = 2;
                    }
                    else if (this.stage > 3 && World.Rnd().nextFloat(0.0f, 40.0f) < 3.0f) {
                        this.stage = 3;
                    }
                }
            }
            this.timer = Time.current();
            passed = 0L;
        }
        if (this.oldStage != this.stage) {
            Motor.bTFirst = true;
            this.oldStage = this.stage;
        }
        if (this.stage > 0 && this.stage < 6) {
            this.setControlThrottle(0.2f);
        }
        switch (this.stage) {
            case 0: {
                if (Motor.bTFirst) {
                    this.given = 4611686018427387903L;
                    this.timer = Time.current();
                }
                if (this.isnd != null) {
                    this.isnd.onEngineState(this.stage);
                    break;
                }
                break;
            }
            case 1: {
                if (Motor.bTFirst) {
                    if (this.bIsStuck) {
                        this.stage = 8;
                        return;
                    }
                    if (this.type == 3 || this.type == 4 || this.type == 6) {
                        this.stage = 5;
                        if (((FlightModelMain)this.reference).isPlayers()) {
                            HUD.log("Starting_Engine");
                        }
                        return;
                    }
                    if (this.type == 0 || this.type == 1 || this.type == 7 || this.type == 9) {
                        if (this.w > this.wMin) {
                            this.stage = 3;
                            if (((FlightModelMain)this.reference).isPlayers()) {
                                HUD.log("Starting_Engine");
                            }
                            return;
                        }
                        if (!this.bIsAutonomous) {
                            if (Airport.distToNearestAirport(((FlightModelMain)this.reference).Loc) >= 1200.0 || !((FlightModelMain)this.reference).isStationedOnGround()) {
                                this.doSetEngineStops();
                                if (((FlightModelMain)this.reference).isPlayers()) {
                                    HUD.log("EngineI0");
                                }
                                return;
                            }
                            this.setControlMagneto(3);
                            if (((FlightModelMain)this.reference).isPlayers()) {
                                HUD.log("Starting_Engine");
                            }
                        }
                        else if (((FlightModelMain)this.reference).isPlayers()) {
                            HUD.log("Starting_Engine");
                        }
                    }
                    else if (!this.bIsAutonomous) {
                        if (Airport.distToNearestAirport(((FlightModelMain)this.reference).Loc) < 1200.0 && ((FlightModelMain)this.reference).isStationedOnGround()) {
                            this.setControlMagneto(3);
                            if (((FlightModelMain)this.reference).isPlayers()) {
                                HUD.log("Starting_Engine");
                            }
                        }
                        else {
                            if (((FlightModelMain)this.reference).getSpeedKMH() < 350.0f) {
                                this.doSetEngineStops();
                                if (((FlightModelMain)this.reference).isPlayers()) {
                                    HUD.log("EngineI0");
                                }
                                return;
                            }
                            if (((FlightModelMain)this.reference).isPlayers()) {
                                HUD.log("Starting_Engine");
                            }
                        }
                    }
                    else if (((FlightModelMain)this.reference).isPlayers()) {
                        HUD.log("Starting_Engine");
                    }
                    if (this.type == 9) {
                        this.given = (long)(50.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                    else if (this.type == 0 || this.type == 7) {
                        if (this.starter == 0) {
                            this.given = (long)(1500.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(50.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(50.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(50.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(1500.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else if (this.type == 1) {
                        if (this.starter == 0) {
                            this.given = (long)(2000.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(50.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(50.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(50.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(5000.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else {
                        this.given = (long)(1000.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                }
                if (this.isnd != null) {
                    this.isnd.onEngineState(this.stage);
                }
                ((FlightModelMain)this.reference).CT.setMagnetoControl(3);
                this.setControlMagneto(3);
                if (this.starter == 5) {
                    this.w = 0.0f;
                }
                else {
                    this.w = 0.1047f * (20.0f * passed / this.given);
                }
                this.setControlThrottle(0.0f);
                break;
            }
            case 2: {
                if (Motor.bTFirst) {
                    if (this.type == 9) {
                        this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                    else if (this.type == 0 || this.type == 7) {
                        if (this.starter == 0) {
                            this.given = (long)(5000.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(1500.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else if (this.type == 1) {
                        if (this.starter == 0) {
                            this.given = (long)(8000.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else {
                        this.given = (long)(8000.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                    if (this.bRan) {
                        this.given = (long)(100.0f + (this.tOilOutMaxRPM - this.tOilOut) / (this.tOilOutMaxRPM - tAir) * 7900.0f * World.Rnd().nextFloat(2.0f, 4.2f));
                        if (this.given > 9000L) {
                            this.given = World.Rnd().nextLong(7800L, 9600L);
                        }
                        if (this.bIsMaster && ((Random)World.Rnd()).nextFloat() < 0.5f) {
                            this.stage = 0;
                            ((FlightModelMain)this.reference).AS.setEngineStops(this.number);
                        }
                    }
                }
                final float spin = 0.1047f * (20.0f + 7.0f * passed / this.given);
                if (this.w > spin) {
                    this.w = 12.564f - 0.3547f * (20.0f + 7.0f * passed / this.given);
                }
                else {
                    this.w = spin;
                }
                this.setControlThrottle(0.0f);
                if (this.isnd != null) {
                    this.isnd.onEngineState(this.stage);
                    break;
                }
                break;
            }
            case 3: {
                if (Motor.bTFirst) {
                    if (this.isnd != null) {
                        this.isnd.onEngineState(this.stage);
                    }
                    if (this.bIsInoperable) {
                        this.stage = 0;
                        this.doSetEngineDies();
                        return;
                    }
                    if (this.type == 9) {
                        this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                    else if (this.type == 0 || this.type == 7) {
                        if (this.starter == 0) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(200.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else if (this.type == 1) {
                        if (this.starter == 0) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else {
                        this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                    if (this.bIsMaster && ((Random)World.Rnd()).nextFloat() < 0.12f && (this.tOilOutMaxRPM - this.tOilOut) / (this.tOilOutMaxRPM - tAir) < 0.75f) {
                        ((FlightModelMain)this.reference).AS.setEngineStops(this.number);
                    }
                }
                this.w = 0.1047f * (60.0f + 60.0f * passed / this.given);
                this.setControlThrottle(0.0f);
                if (this.reference != null && this.type != 2 && this.type != 3 && this.type != 4 && this.type != 6 && this.type != 5 && this.type != 10) {
                    for (int t = 1; t < 32; ++t) {
                        try {
                            final Hook hook = ((Interpolate)this.reference).actor.findHook((Object)("_Engine" + (this.number + 1) + "EF_" + ((t < 10) ? ("0" + t) : new StringBuffer().append(t).toString())));
                            if (hook != null) {
                                Eff3DActor.New(((Interpolate)this.reference).actor, hook, (Loc)null, 1.0f, "3DO/Effects/Aircraft/EngineStart" + World.Rnd().nextInt(1, 3) + ".eff", -1.0f);
                            }
                        }
                        catch (Exception ex) {}
                    }
                    break;
                }
                break;
            }
            case 4: {
                if (Motor.bTFirst) {
                    if (this.type == 9) {
                        this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                    else if (this.type == 0 || this.type == 7) {
                        if (this.starter == 0) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else if (this.type == 1) {
                        if (this.starter == 0) {
                            this.given = (long)(1200.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(1200.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(1200.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else {
                        this.given = (long)(1000.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                }
                this.w = 12.564f;
                this.setControlThrottle(0.0f);
                if (this.isnd != null) {
                    this.isnd.onEngineState(this.stage);
                    break;
                }
                break;
            }
            case 5: {
                if (Motor.bTFirst) {
                    if (this.type == 9) {
                        this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                    else if (this.type == 0 || this.type == 7) {
                        if (this.starter == 0) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(100.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else if (this.type == 1) {
                        if (this.starter == 0) {
                            this.given = (long)(800.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 1) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 2) {
                            this.given = (long)(800.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 3) {
                            this.given = (long)(25.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                        else if (this.starter == 5) {
                            this.given = (long)(800.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                        }
                    }
                    else {
                        this.given = (long)(500.0f * World.Rnd().nextFloat(1.0f, 2.0f));
                    }
                    if (this.bRan && (this.type == 0 || this.type == 1 || this.type == 7 || this.type == 9)) {
                        if ((this.tOilOutMaxRPM - this.tOilOut) / (this.tOilOutMaxRPM - tAir) > 0.75f) {
                            if (this.type == 0 || this.type == 7) {
                                if (this.bIsMaster && this.getReadyness() > 0.75f && ((Random)World.Rnd()).nextFloat() < 0.25f) {
                                    this.setReadyness(this.getReadyness() - 0.05f);
                                }
                            }
                            else if (this.type == 1 && this.bIsMaster && ((Random)World.Rnd()).nextFloat() < 0.1f) {
                                ((FlightModelMain)this.reference).AS.setEngineDies(((Interpolate)this.reference).actor, this.number);
                            }
                        }
                        if (this.bIsMaster && ((Random)World.Rnd()).nextFloat() < 0.1f) {
                            ((FlightModelMain)this.reference).AS.setEngineStops(this.number);
                        }
                    }
                    this.bRan = true;
                }
                this.w = 0.1047f * (120.0f + 120.0f * passed / this.given);
                this.setControlThrottle(0.2f);
                if (this.isnd != null) {
                    this.isnd.onEngineState(this.stage);
                    break;
                }
                break;
            }
            case 6: {
                if (Motor.bTFirst) {
                    this.given = -1L;
                    ((FlightModelMain)this.reference).AS.setEngineRunning(this.number);
                }
                if (this.isnd != null) {
                    this.isnd.onEngineState(this.stage);
                    break;
                }
                break;
            }
            case 7:
            case 8: {
                if (Motor.bTFirst) {
                    this.given = -1L;
                }
                this.setReadyness(0.0f);
                this.setControlMagneto(0);
                if (this.isnd != null) {
                    this.isnd.onEngineState(this.stage);
                    break;
                }
                break;
            }
            default: {}
        }
    }

    private void computeFuel(float dt)
    {
        tmpF = 0.0F;
        float relW = w * _1_wMax;
        if(stage == 6)
        {
            float relP;
            double Pcur;
            switch(type)
            {
            case 0: // '\0'
            case 1: // '\001'
            case 7: // '\007'
                Pcur = momForFuel * (double)w * 0.0010499999999999999D;
                relP = (float)Pcur / horsePowers;
                if(Pcur < (double)horsePowers * 0.050000000000000003D)
                    Pcur = (double)horsePowers * 0.050000000000000003D;
                break;

            default:
                Pcur = thrustMax * (relP = getPowerOutput());
                if(Pcur < (double)thrustMax * 0.050000000000000003D)
                    Pcur = (double)thrustMax * 0.050000000000000003D;
                break;
            }
            if(relP < 0.0F)
                relP = 0.0F;
            double FC;
            if(relP <= 0.5F)
            {
                FC = relP - 0.5F;
                FC = FC * FC * (double)fuelConsumption0M + (double)FuelConsumptionP05;
            } else
            if((double)relP <= 1.0D)
            {
                FC = relP - 0.5F;
                FC = FC * FC * (double)fuelConsumption1M + (double)FuelConsumptionP05;
            } else
            {
                float a = relP - 1.0F;
                if(a > 0.1F)
                    a = 0.1F;
                a *= 10F;
                FC = FuelConsumptionP1 + (FuelConsumptionPMAX - FuelConsumptionP1) * a;
            }
            FC /= 3600D;
            switch(type)
            {
            case 5: // '\005'
            case 8: // '\b'
            case 9: // '\t'
            default:
                break;

            case 0: // '\0'
            case 1: // '\001'
            case 7: // '\007'
                FC *= 0.8F + (0.2F * w) / wWEP;
                float fc_sec = (float)(FC * Pcur);
                tmpF = fc_sec * dt;
                double fuelPower = fc_sec * 4.4E+007F;
                double out_air = fc_sec * 15.7F;
                double out_airPower = 1010D * out_air * 700D;
                Pcur *= 746D;
                break;

            case 2: // '\002'
                tmpF = (float)(FC * Pcur * (double)dt);
                break;

            case 10: // '\n'
                tmpF = (float)(FC * Pcur * (double)dt);
                break;

            case 3: // '\003'
                tmpF = FuelRocketCoeff * getPowerOutput() * dt;
                break;

            case 4: // '\004'
                tmpF = FuelRocketCoeff * getPowerOutput() * dt;
                tmpB = ((FlightModelMain) (reference)).M.requestNitro(tmpF);
                tmpF = 0.0F;
                if(tmpB || !bIsMaster)
                    break;
                setEngineStops(((Interpolate) (reference)).actor);
                if(reference.isPlayers() && engineNoFuelHUDLogId == -1)
                {
                    engineNoFuelHUDLogId = HUD.makeIdLog();
                    HUD.log(engineNoFuelHUDLogId, "EngineNoFuel");
                }
                return;

            case 6: // '\006'
                tmpF = (float)(FC * Pcur * (double)dt);
                tmpB = ((FlightModelMain) (reference)).M.requestNitro(tmpF);
                tmpF = 0.0F;
                if(tmpB || !bIsMaster)
                    break;
                setEngineStops(((Interpolate) (reference)).actor);
                if(reference.isPlayers() && engineNoFuelHUDLogId == -1)
                {
                    engineNoFuelHUDLogId = HUD.makeIdLog();
                    HUD.log(engineNoFuelHUDLogId, "EngineNoFuel");
                }
                return;
            }
        }
        tmpB = ((FlightModelMain) (reference)).M.requestFuel(tmpF);
        if(!tmpB && bIsMaster)
        {
            setEngineStops(((Interpolate) (reference)).actor);
            reference.setCapableOfACM(false);
            reference.setCapableOfTaxiing(false);
            if(reference.isPlayers() && engineNoFuelHUDLogId == -1)
            {
                engineNoFuelHUDLogId = HUD.makeIdLog();
                HUD.log(engineNoFuelHUDLogId, "EngineNoFuel");
            }
        }
        if(controlAfterburner)
            switch(afterburnerType)
            {
            case 3: // '\003'
            case 6: // '\006'
            case 7: // '\007'
            case 8: // '\b'
            default:
                break;

            case 1: // '\001'
                if(controlThrottle > 1.0F && !((FlightModelMain) (reference)).M.requestNitro(0.044872F * dt) && reference.isPlayers() && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode() && World.cur().diffCur.Vulnerability)
                    setReadyness(((Interpolate) (reference)).actor, getReadyness() - 0.01F * dt);
                break;

            case 2: // '\002'
                ((FlightModelMain) (reference)).M.requestNitro(0.044872F * dt);
                break;

            case 5: // '\005'
                ((FlightModelMain) (reference)).M.requestNitro(0.044872F * dt);
                break;

            case 9: // '\t'
                ((FlightModelMain) (reference)).M.requestNitro(0.044872F * dt);
                break;

            case 4: // '\004'
                if(((FlightModelMain) (reference)).M.requestNitro(0.044872F * dt))
                    break;
                ((FlightModelMain) (reference)).CT.setAfterburnerControl(false);
                if(reference.isPlayers())
                {
                    Main3D.cur3D().aircraftHotKeys.setAfterburnerForAutoActivation(false);
                    HUD.logRightBottom(null);
                }
                break;
            }
    }

    private void computeReliability(float f)
    {
        if(stage != 6)
            return;
        float cT = controlThrottle;
        if(engineBoostFactor > 1.0F)
            cT *= 0.9090909F;
        switch(type)
        {
        default:
            zatizeni = cT;
            zatizeni *= zatizeni;
            zatizeni *= zatizeni;
            zatizeni *= (double)f * 6.1984262178699901E-005D;
            if(zatizeni > World.Rnd().nextDouble(0.0D, 1.0D))
            {
                int rnd = World.Rnd().nextInt(0, 9);
                if(rnd < 2)
                {
                    ((FlightModelMain) (reference)).AS.hitEngine(((Interpolate) (reference)).actor, number, 3);
                    Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - smoke");
                } else
                {
                    setCyliderKnockOut(((Interpolate) (reference)).actor, World.Rnd().nextInt(0, 3));
                    Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - power loss");
                }
            }
            break;

        case 0: // '\0'
        case 1: // '\001'
        case 7: // '\007'
            zatizeni = coolMult * cT;
            zatizeni *= w / wWEP;
            zatizeni *= zatizeni;
            zatizeni *= zatizeni;
            double zatizeni2 = zatizeni * (double)f * 1.4248134284734321E-005D;
            if(zatizeni2 <= World.Rnd().nextDouble(0.0D, 1.0D))
                break;
            int rnd = World.Rnd().nextInt(0, 19);
            if(rnd < 10)
            {
                ((FlightModelMain) (reference)).AS.setEngineCylinderKnockOut(((Interpolate) (reference)).actor, number, 1);
                Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - cylinder");
                break;
            }
            if(rnd < 12)
            {
                if(rnd < 11)
                {
                    ((FlightModelMain) (reference)).AS.setEngineMagnetoKnockOut(((Interpolate) (reference)).actor, number, 0);
                    Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - mag1");
                } else
                {
                    ((FlightModelMain) (reference)).AS.setEngineMagnetoKnockOut(((Interpolate) (reference)).actor, number, 1);
                    Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - mag2");
                }
                break;
            }
            if(rnd < 14)
            {
                ((FlightModelMain) (reference)).AS.setEngineDies(((Interpolate) (reference)).actor, number);
                Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - dead");
                break;
            }
            if(rnd < 15)
            {
                ((FlightModelMain) (reference)).AS.setEngineStuck(((Interpolate) (reference)).actor, number);
                Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - stuck");
                break;
            }
            if(rnd < 17)
            {
                setKillPropAngleDevice(((Interpolate) (reference)).actor);
                Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - propAngler");
            } else
            {
                ((FlightModelMain) (reference)).AS.hitOil(((Interpolate) (reference)).actor, number);
                Aircraft.debugprintln(((Interpolate) (reference)).actor, "Malfunction #" + number + " - oil");
            }
            break;
        }
    }

    private void computeTemperature(final float dt) {
        final float spd = Math.max(0.0f, ((FlightModelMain)this.reference).getSpeedKMH());
        final float airTemp = Atmosphere.temperature((float)((Tuple3d)((FlightModelMain)this.reference).Loc).z) - 273.15f;
        float throttle = this.controlThrottle;
        if (!((FlightModelMain)this.reference).isPlayers()) {
            throttle *= 1.1f;
        }
        float maxThrottleAdjust = throttle;
        final float jspeedfactor = 0.8f + 60.0f / (50.0f + spd);
        float jDensity = 0.45f;
        if (this.engineBoostFactor > 1.0f) {
            maxThrottleAdjust = (throttle + Math.max(throttle - 1.0f, 0.0f) * (this.engineBoostFactor - 1.1f) * 10.0f) / this.engineBoostFactor;
        }
        if (!this.controlAfterburner && this.engineAfterburnerBoostFactor > 1.0f && this.afterburnerType != 1 && this.afterburnerType != 9 && this.afterburnerType != 4) {
            maxThrottleAdjust /= this.engineAfterburnerBoostFactor;
        }
        float jrpmratio = maxThrottleAdjust;
        if (this.type == 0 || this.type == 1 || this.type == 7) {
            jDensity = 0.45f / Atmosphere.density((float)((Tuple3d)((FlightModelMain)this.reference).Loc).z);
        }
        final float jtotalboost = this.coolMult * maxThrottleAdjust;
        if (World.cur().diffCur.ComplexEManagement && ((FlightModelMain)this.reference).isPlayers() && ((RealFlightModel)this.reference).isRealMode()) {
            jrpmratio = this.w / this.wWEP;
        }
        if (!((FlightModelMain)this.reference).isPlayers()) {
            jrpmratio = this.w * 1.02f / this.wWEP;
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.stage == 6) {
            if (this.type == 2) {
                jDensity = 0.35f + 0.1f / Atmosphere.density((float)((Tuple3d)((FlightModelMain)this.reference).Loc).z);
            }
            f3 = airTemp + this.tOilOutMaxRPM * (1.0f - 0.15f * this.controlRadiator) * (0.65f + 0.45f / Atmosphere.density((float)((Tuple3d)((FlightModelMain)this.reference).Loc).z)) * (1.0f + ((FlightModelMain)this.reference).AS.astateOilStates[this.number] * 0.35f) * 1.2f * jrpmratio * jrpmratio * (0.7f + 0.3f * jtotalboost) * jspeedfactor;
            this.tOilOut += (f3 - this.tOilOut) * dt * this.tChangeSpeed;
            f4 = this.tOilOut * 0.8f;
            this.tOilIn += (f4 - this.tOilIn) * dt * 0.5f;
            f4 = airTemp + this.tWaterMaxRPM * (1.0f - 0.15f * this.controlRadiator) * (0.65f + jDensity) * (0.6f + 0.4f * jrpmratio) * (0.1f + 1.1f * jtotalboost) * jspeedfactor * (1.1f - 0.1f * this.controlMix);
            this.tWaterOut += (f4 - this.tWaterOut) * dt * this.tChangeSpeed;
        }
        else {
            final float f5 = airTemp;
            this.tOilOut += (f5 - this.tOilOut) * dt * this.tChangeSpeed * (0.2f + 0.2f * this.controlRadiator);
            f4 = this.tOilOut;
            this.tOilIn += (f4 - this.tOilIn) * dt * 0.5f;
            f4 = airTemp;
            this.tWaterOut += (f4 - this.tWaterOut) * dt * this.tChangeSpeed * (0.2f + 0.2f * this.controlRadiator);
        }
        if (!((FlightModelMain)this.reference).isPlayers()) {
            return;
        }
        if (World.cur().diffCur.Engine_Overheat && (this.tWaterOut > this.tWaterCritMax || this.tOilOut > this.tOilCritMax)) {
            if (Motor.heatStringID == -1) {
                Motor.heatStringID = HUD.makeIdLog();
            }
            if (((FlightModelMain)this.reference).isPlayers()) {
                HUD.log(Motor.heatStringID, "EngineOverheat");
            }
            this.timeCounter += dt;
            if (this.tWaterOut > this.tWaterCritMax) {
                float jWaterOverheat = this.tWaterOut / this.tWaterCritMax - 1.0f;
                jWaterOverheat *= jWaterOverheat * jWaterOverheat * dt * 1000.0f;
                final float jWaterDamage = ((Random)World.Rnd()).nextFloat() * this.timeOverheat;
                if (jWaterOverheat > jWaterDamage) {
                    switch (this.type) {
                        default: {
                            final int i = World.Rnd().nextInt(0, 9);
                            if (i < 2) {
                                ((FlightModelMain)this.reference).AS.hitEngine(((Interpolate)this.reference).actor, this.number, 3);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - smoke");
                                break;
                            }
                            this.setCyliderKnockOut(((Interpolate)this.reference).actor, World.Rnd().nextInt(0, 3));
                            Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - power loss");
                            break;
                        }
                        case 0:
                        case 1:
                        case 7: {
                            final int j = World.Rnd().nextInt(0, 99);
                            if (j < 50) {
                                ((FlightModelMain)this.reference).AS.setEngineCylinderKnockOut(((Interpolate)this.reference).actor, this.number, 1);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - cylinder");
                                break;
                            }
                            if (j < 65) {
                                ((FlightModelMain)this.reference).AS.hitOil(((Interpolate)this.reference).actor, this.number);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - oil");
                                break;
                            }
                            if (j < 94) {
                                ((FlightModelMain)this.reference).AS.setEngineCylinderKnockOut(((Interpolate)this.reference).actor, this.number, 1);
                                for (int t = 1; t < 11; ++t) {
                                    if (((Random)World.Rnd()).nextFloat() >= 0.8f) {
                                        try {
                                            final Hook hook = ((Interpolate)this.reference).actor.findHook((Object)("_Engine" + (this.number + 1) + "EF_" + ((t < 10) ? ("0" + t) : new StringBuffer().append(t).toString())));
                                            if (hook != null) {
                                                Eff3DActor.New(((Interpolate)this.reference).actor, hook, (Loc)null, 1.0f, "3DO/Effects/Aircraft/EngineStart" + World.Rnd().nextInt(1, 3) + ".eff", -1.0f);
                                            }
                                        }
                                        catch (Exception ex) {}
                                        break;
                                    }
                                }
                                ((FlightModelMain)this.reference).AS.setSootState(((Interpolate)this.reference).actor, this.number, 1);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - cylinder&smoke");
                                break;
                            }
                            if (j < 95) {
                                ((FlightModelMain)this.reference).AS.setEngineCylinderKnockOut(((Interpolate)this.reference).actor, this.number, 1);
                                ((FlightModelMain)this.reference).AS.hitEngine(((Interpolate)this.reference).actor, this.number, 10);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - fire");
                                break;
                            }
                            if (j < 97) {
                                this.setKillCompressor(((Interpolate)this.reference).actor);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - Supercharger");
                                break;
                            }
                            if (j < 98) {
                                ((FlightModelMain)this.reference).AS.setEngineDies(((Interpolate)this.reference).actor, this.number);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - dead");
                                break;
                            }
                            ((FlightModelMain)this.reference).AS.setEngineStuck(((Interpolate)this.reference).actor, this.number);
                            Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - stuck");
                            break;
                        }
                    }
                }
            }
            if (this.tOilOut > this.tOilCritMax) {
                float jOilOverheat = this.tOilOut / this.tOilCritMax - 1.0f;
                jOilOverheat *= jOilOverheat * jOilOverheat * dt * 1000.0f;
                final float jOilDamage = ((Random)World.Rnd()).nextFloat() * this.timeOverheat;
                if (jOilOverheat > jOilDamage) {
                    switch (this.type) {
                        default: {
                            final int i = World.Rnd().nextInt(0, 9);
                            if (i < 2) {
                                ((FlightModelMain)this.reference).AS.hitEngine(((Interpolate)this.reference).actor, this.number, 3);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - smoke");
                                break;
                            }
                            this.setCyliderKnockOut(((Interpolate)this.reference).actor, World.Rnd().nextInt(0, 3));
                            Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - power loss");
                            break;
                        }
                        case 0:
                        case 1:
                        case 7: {
                            final int j = World.Rnd().nextInt(0, 99);
                            if (j < 10) {
                                ((FlightModelMain)this.reference).AS.setEngineCylinderKnockOut(((Interpolate)this.reference).actor, this.number, 1);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - cylinder");
                                break;
                            }
                            if (j < 60) {
                                ((FlightModelMain)this.reference).AS.hitOil(((Interpolate)this.reference).actor, this.number);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - oil");
                                break;
                            }
                            if (j < 94) {
                                this.setReadyness(this.readyness * 0.95f);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - damaged bearing or something");
                                break;
                            }
                            if (j < 95) {
                                ((FlightModelMain)this.reference).AS.hitOil(((Interpolate)this.reference).actor, this.number);
                                ((FlightModelMain)this.reference).AS.hitEngine(((Interpolate)this.reference).actor, this.number, 3);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - fire");
                                break;
                            }
                            if (j < 96) {
                                this.setKillCompressor(((Interpolate)this.reference).actor);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - Supercharger");
                                break;
                            }
                            if (j < 97) {
                                ((FlightModelMain)this.reference).AS.setEngineDies(((Interpolate)this.reference).actor, this.number);
                                Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - dead");
                                break;
                            }
                            ((FlightModelMain)this.reference).AS.setEngineStuck(((Interpolate)this.reference).actor, this.number);
                            Aircraft.debugprintln(((Interpolate)this.reference).actor, "Malfunction #" + this.number + " - stuck");
                            break;
                        }
                    }
                }
            }
        }
        else if (this.timeCounter > 0.0f) {
            this.timeCounter = 0.0f;
            if (Motor.heatStringID == -1) {
                Motor.heatStringID = HUD.makeIdLog();
            }
            if (((FlightModelMain)this.reference).isPlayers()) {
                HUD.log(Motor.heatStringID, "EngineRestored");
            }
        }
    }

    public void updateRadiator(float dt)
    {
        if(RadiatorAlgoritm == 1)
        {
            controlRadiator = 0.0F;
            return;
        }
        if(RadiatorAlgoritm == 2)
        {
            if(tOilOut > tOilOutMaxRPM)
            {
                controlRadiator += 0.1F * dt;
                if(controlRadiator > 1.0F)
                    controlRadiator = 1.0F;
            } else
            {
                controlRadiator = 1.0F - reference.getSpeed() / ((FlightModelMain) (reference)).VmaxH;
                if(controlRadiator < 0.0F)
                    controlRadiator = 0.0F;
            }
            return;
        }
        if(RadiatorAlgoritm == 3)
        {
            controlRadiator = ((tWaterOut - tWaterCritMax) + 20F) / 20F;
            if(controlRadiator < 0.0F)
                controlRadiator = 0.0F;
            if(controlRadiator > 1.0F)
                controlRadiator = 1.0F;
            return;
        }
        switch(propAngleDeviceType)
        {
        case 3: // '\003'
        case 4: // '\004'
        case 9: // '\t'
        case 10: // '\n'
        default:
            controlRadiator = 1.0F - getPowerOutput();
            break;

        case 5: // '\005'
        case 6: // '\006'
            controlRadiator = 1.0F - reference.getSpeed() / ((FlightModelMain) (reference)).VmaxH;
            if(controlRadiator < 0.0F)
                controlRadiator = 0.0F;
            break;

        case 1: // '\001'
        case 2: // '\002'
        case 11: // '\013'
        case 12: // '\f'
            if(controlRadiator > 1.0F - getPowerOutput())
            {
                controlRadiator -= 0.15F * dt;
                if(controlRadiator < 0.0F)
                    controlRadiator = 0.0F;
            } else
            {
                controlRadiator += 0.15F * dt;
            }
            break;

        case 8: // '\b'
            if(type == 0)
            {
                if(tOilOut > tOilOutMaxRPM)
                {
                    controlRadiator += 0.1F * dt;
                    if(controlRadiator > 1.0F)
                        controlRadiator = 1.0F;
                    break;
                }
                if(tOilOut >= tOilOutMaxRPM - 10F)
                    break;
                controlRadiator -= 0.1F * dt;
                if(controlRadiator < 0.0F)
                    controlRadiator = 0.0F;
                break;
            }
            if(controlRadiator > 1.0F - getPowerOutput())
            {
                controlRadiator -= 0.15F * dt;
                if(controlRadiator < 0.0F)
                    controlRadiator = 0.0F;
            } else
            {
                controlRadiator += 0.15F * dt;
            }
            break;

        case 7: // '\007'
            if(tOilOut > tOilOutMaxRPM)
            {
                controlRadiator += 0.1F * dt;
                if(controlRadiator > 1.0F)
                    controlRadiator = 1.0F;
                break;
            }
            controlRadiator = 1.0F - reference.getSpeed() / ((FlightModelMain) (reference)).VmaxH;
            if(controlRadiator < 0.0F)
                controlRadiator = 0.0F;
            break;
        }
    }

    private void computeForces(float dt)
    {
        switch(type)
        {
        case 0: // '\0'
        case 1: // '\001'
        case 7: // '\007'
        case 9: // '\t'
        {
            if(Math.abs(w) < 1E-005F)
                propPhiW = 1.570796F;
            else
            if(type == 7)
                propPhiW = (float)Math.atan(Math.abs(((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x) / (double)(w * propReductor * propr));
            else
                propPhiW = (float)Math.atan(((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x / (double)(w * propReductor * propr));
            propAoA = propPhi - propPhiW;
            if(type == 7)
                computePropForces(w * propReductor, (float)Math.abs(((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x), propPhi, propAoA, reference.getAltitude());
            else
                computePropForces(w * propReductor, (float)((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x, propPhi, propAoA, reference.getAltitude());
            switch(propAngleDeviceType)
            {
            case 3: // '\003'
            case 4: // '\004'
            {
                float compThrot = controlThrottle;
                if(compThrot > 1.0F)
                    compThrot = 1.0F;
                compressorManifoldThreshold = 0.5F + (compressorRPMtoWMaxATA - 0.5F) * compThrot;
                if(isPropAngleDeviceOperational())
                {
                    if(bControlPropAuto)
                        propTarget = propPhiW + propAoA0;
                    else
                        propTarget = propPhiMax - controlProp * (propPhiMax - propPhiMin);
                } else
                if(propAngleDeviceType == 3)
                    propTarget = 0.0F;
                else
                    propTarget = 3.141593F;
                break;
            }

            case 9: // '\t'
            {
                if(bControlPropAuto)
                {
                    float f15 = propAngleDeviceMaxParam;
                    if(controlAfterburner)
                        f15 = propAngleDeviceAfterburnerParam;
                    if(isHasControlBoost())
                        f15 = Aircraft.cvt(controlFAfterburner, 0.0F, 1.0F, propAngleDeviceMaxParam, propAngleDeviceAfterburnerParam);
                    controlProp += ((float)controlPropDirection * dt) / 5F;
                    if(controlProp > 1.0F)
                        controlProp = 1.0F;
                    else
                    if(controlProp < 0.0F)
                        controlProp = 0.0F;
                    float f1 = propAngleDeviceMinParam + (f15 - propAngleDeviceMinParam) * controlProp;
                    float f10 = controlThrottle;
                    if(f10 > 1.0F)
                        f10 = 1.0F;
                    compressorManifoldThreshold = getATA(toRPM(propAngleDeviceMinParam + (propAngleDeviceMaxParam - propAngleDeviceMinParam) * f10));
                    if(isPropAngleDeviceOperational())
                    {
                        if(w < f1)
                        {
                            f1 = Math.min(1.0F, 0.01F * (f1 - w) - 0.012F * aw);
                            propTarget -= f1 * getPropAngleDeviceSpeed() * dt;
                        } else
                        {
                            f1 = Math.min(1.0F, 0.01F * (w - f1) + 0.012F * aw);
                            propTarget += f1 * getPropAngleDeviceSpeed() * dt;
                        }
                        if(stage == 6 && propTarget < propPhiW - 0.12F)
                        {
                            propTarget = propPhiW - 0.12F;
                            if(propPhi < propTarget)
                                propPhi += 0.2F * dt;
                        }
                    } else
                    {
                        propTarget = propPhi;
                    }
                } else
                {
                    compressorManifoldThreshold = 0.5F + (compressorRPMtoWMaxATA - 0.5F) * (controlThrottle <= 1.0F ? controlThrottle : 1.0F);
                    propTarget = propPhi;
                    if(isPropAngleDeviceOperational())
                        if(controlPropDirection > 0)
                            propTarget = propPhiMin;
                        else
                        if(controlPropDirection < 0)
                            propTarget = propPhiMax;
                }
                break;
            }

            case 1: // '\001'
            case 2: // '\002'
            case 11: // '\013'
            case 12: // '\f'
            {
                if(bControlPropAuto)
                    if(engineBoostFactor > 1.0F)
                        controlProp = 0.75F + 0.227272F * controlThrottle;
                    else
                        controlProp = 0.75F + 0.25F * controlThrottle;
                float propMax = propAngleDeviceMaxParam;
                if(controlAfterburner && (!bWepRpmInLowGear || controlCompressor != compressorMaxStep))
                    propMax = propAngleDeviceAfterburnerParam;
                if(isHasControlBoost())
                    propMax = Aircraft.cvt(controlFAfterburner, 0.0F, 1.0F, propAngleDeviceMaxParam, propAngleDeviceAfterburnerParam);
                float f = propAngleDeviceMinParam + (propMax - propAngleDeviceMinParam) * controlProp;
                float compThrot = controlThrottle;
                if(compThrot > 1.0F)
                    compThrot = 1.0F;
                compressorManifoldThreshold = getATA(toRPM(propAngleDeviceMinParam + (propAngleDeviceMaxParam - propAngleDeviceMinParam) * compThrot));
                if(isPropAngleDeviceOperational())
                {
                    if(w < f)
                    {
                        f = Math.min(1.0F, 0.01F * (f - w) - 0.012F * aw);
                        propTarget -= f * getPropAngleDeviceSpeed() * dt;
                    } else
                    {
                        f = Math.min(1.0F, 0.01F * (w - f) + 0.012F * aw);
                        propTarget += f * getPropAngleDeviceSpeed() * dt;
                    }
                    if(stage == 6 && propTarget < propPhiW - 0.12F)
                    {
                        propTarget = propPhiW - 0.12F;
                        if(propPhi < propTarget)
                            propPhi += 0.2F * dt;
                    }
                } else
                if(propAngleDeviceType == 1 || propAngleDeviceType == 11)
                    propTarget = 0.0F;
                else
                    propTarget = 1.5708F;
                break;
            }

            case 7: // '\007'
            {
                float propC = controlThrottle;
                if(engineBoostFactor > 1.0F)
                    propC = 0.9090909F * controlThrottle;
                float propMax = propAngleDeviceMaxParam;
                if(controlAfterburner)
                    if(afterburnerType == 1)
                    {
                        if(controlThrottle > 1.0F)
                            propMax = propAngleDeviceMaxParam + 10F * (controlThrottle - 1.0F) * (propAngleDeviceAfterburnerParam - propAngleDeviceMaxParam);
                    } else
                    {
                        propMax = propAngleDeviceAfterburnerParam;
                    }
                float f = propAngleDeviceMinParam + (propMax - propAngleDeviceMinParam) * propC;
                float compThrot = controlThrottle;
                if(compThrot > 1.0F)
                    compThrot = 1.0F;
                compressorManifoldThreshold = getATA(toRPM(propAngleDeviceMinParam + (propMax - propAngleDeviceMinParam) * compThrot));
                if(isPropAngleDeviceOperational())
                    if(bControlPropAuto)
                    {
                        if(w < f)
                        {
                            f = Math.min(1.0F, 0.01F * (f - w) - 0.012F * aw);
                            propTarget -= f * getPropAngleDeviceSpeed() * dt;
                        } else
                        {
                            f = Math.min(1.0F, 0.01F * (w - f) + 0.012F * aw);
                            propTarget += f * getPropAngleDeviceSpeed() * dt;
                        }
                        if(stage == 6 && propTarget < propPhiW - 0.12F)
                        {
                            propTarget = propPhiW - 0.12F;
                            if(propPhi < propTarget)
                                propPhi += 0.2F * dt;
                        }
                        if(propTarget < propPhiMin + (float)Math.toRadians(3D))
                            propTarget = propPhiMin + (float)Math.toRadians(3D);
                    } else
                    {
                        propTarget = (1.0F - dt * 0.1F) * propTarget + dt * 0.1F * (propPhiMax - controlProp * (propPhiMax - propPhiMin));
                        if(w > 1.02F * wMax)
                            wMaxAllowed = (1.0F - 4E-007F * (w - 1.02F * wMax)) * wMaxAllowed;
                        if(w > wMax)
                        {
                            float dec = w - wMax;
                            dec *= dec;
                            float messerFact = 1.0F - 0.001F * dec;
                            if(messerFact < 0.0F)
                                messerFact = 0.0F;
                            propForce *= messerFact;
                        }
                    }
                break;
            }

            case 8: // '\b'
            {
                float propC = controlThrottle;
                if(engineBoostFactor > 1.0F)
                    propC = 0.9090909F * controlThrottle;
                float propMax = propAngleDeviceMaxParam;
                if(controlAfterburner)
                    if(afterburnerType == 1)
                    {
                        if(controlThrottle > 1.0F)
                            propMax = propAngleDeviceMaxParam + 10F * (controlThrottle - 1.0F) * (propAngleDeviceAfterburnerParam - propAngleDeviceMaxParam);
                    } else
                    {
                        propMax = propAngleDeviceAfterburnerParam;
                    }
                float f = propAngleDeviceMinParam + (propMax - propAngleDeviceMinParam) * propC + (bControlPropAuto ? 0.0F : -25F + 50F * controlProp);
                float compThrot = controlThrottle;
                if(compThrot > 1.0F)
                    compThrot = 1.0F;
                compressorManifoldThreshold = getATA(toRPM(propAngleDeviceMinParam + (propMax - propAngleDeviceMinParam) * compThrot));
                if(isPropAngleDeviceOperational())
                {
                    if(w < f)
                    {
                        f = Math.min(1.0F, 0.01F * (f - w) - 0.012F * aw);
                        propTarget -= f * getPropAngleDeviceSpeed() * dt;
                    } else
                    {
                        f = Math.min(1.0F, 0.01F * (w - f) + 0.012F * aw);
                        propTarget += f * getPropAngleDeviceSpeed() * dt;
                    }
                    if(stage == 6 && propTarget < propPhiW - 0.12F)
                    {
                        propTarget = propPhiW - 0.12F;
                        if(propPhi < propTarget)
                            propPhi += 0.2F * dt;
                    }
                    if(propTarget < propPhiMin + (float)Math.toRadians(3D))
                        propTarget = propPhiMin + (float)Math.toRadians(3D);
                }
                break;
            }

            case 6: // '\006'
            {
                float compThrot = controlThrottle;
                if(compThrot > 1.0F)
                    compThrot = 1.0F;
                compressorManifoldThreshold = 0.5F + (compressorRPMtoWMaxATA - 0.5F) * compThrot;
                if(isPropAngleDeviceOperational())
                    if(bControlPropAuto)
                    {
                        float f = 25F + (wMax - 25F) * (0.25F + 0.75F * controlThrottle);
                        if(w < f)
                        {
                            f = Math.min(1.0F, 0.01F * (f - w) - 0.012F * aw);
                            propTarget -= f * getPropAngleDeviceSpeed() * dt;
                        } else
                        {
                            f = Math.min(1.0F, 0.01F * (w - f) + 0.012F * aw);
                            propTarget += f * getPropAngleDeviceSpeed() * dt;
                        }
                        if(stage == 6 && propTarget < propPhiW - 0.12F)
                        {
                            propTarget = propPhiW - 0.12F;
                            if(propPhi < propTarget)
                                propPhi += 0.2F * dt;
                        }
                        controlProp = (propAngleDeviceMaxParam - propTarget) / (propAngleDeviceMaxParam - propAngleDeviceMinParam);
                        if(controlProp < 0.0F)
                            controlProp = 0.0F;
                        if(controlProp > 1.0F)
                            controlProp = 1.0F;
                    } else
                    {
                        propTarget = propAngleDeviceMaxParam - controlProp * (propAngleDeviceMaxParam - propAngleDeviceMinParam);
                    }
                break;
            }

            case 5: // '\005'
            {
                float compThrot = controlThrottle;
                if(compThrot > 1.0F)
                    compThrot = 1.0F;
                compressorManifoldThreshold = 0.5F + (compressorRPMtoWMaxATA - 0.5F) * compThrot;
                if(bControlPropAuto)
                    if(reference.isPlayers() && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode())
                    {
                        if(World.cur().diffCur.ComplexEManagement)
                            controlProp = -controlThrottle;
                        else
                            controlProp = -Aircraft.cvt(reference.getSpeed(), ((FlightModelMain) (reference)).Vmin, ((FlightModelMain) (reference)).Vmax, 0.0F, 1.0F);
                    } else
                    {
                        controlProp = -Aircraft.cvt(reference.getSpeed(), ((FlightModelMain) (reference)).Vmin, ((FlightModelMain) (reference)).Vmax, 0.0F, 1.0F);
                    }
                propTarget = propAngleDeviceMaxParam - controlProp * (propAngleDeviceMaxParam - propAngleDeviceMinParam);
                propPhi = propTarget;
                break;
            }
            }
            if(controlFeather == 1 && bHasFeatherControl && isPropAngleDeviceOperational())
                propTarget = 1.55F;
            if(propPhi > propTarget)
            {
                float f = Math.min(1.0F, 157.2958F * (propPhi - propTarget));
                propPhi -= f * getPropAngleDeviceSpeed() * dt;
            } else
            if(propPhi < propTarget)
            {
                float f = Math.min(1.0F, 157.2958F * (propTarget - propPhi));
                propPhi += f * getPropAngleDeviceSpeed() * dt;
            }
            if(propTarget > propPhiMax)
                propTarget = propPhiMax;
            else
            if(propTarget < propPhiMin)
                propTarget = propPhiMin;
            if(propPhi > propPhiMax && controlFeather == 0)
                propPhi = propPhiMax;
            else
            if(propPhi < propPhiMin)
                propPhi = propPhiMin;
            engineMoment = getN();
            float cm = 1.0F;
            if(!((Interpolate) (reference)).actor.net.isMirror())
                cm = getCompressorMultiplier(dt);
            engineMoment *= cm;
            momForFuel = engineMoment;
            engineMoment *= getReadyness();
            engineMoment *= getMagnetoMultiplier();
            engineMoment *= getMixMultiplier();
            engineMoment *= getStageMultiplier();
            engineMoment *= getDistabilisationMultiplier();
            engineMoment += getFrictionMoment(dt);
            float deltaM = engineMoment - propMoment;
            aw = deltaM / (propI + engineI);
            if(aw > 0.0F)
                aw *= engineAcceleration;
            oldW = w;
            w += aw * dt;
            if(w < 0.0F)
                w = 0.0F;
            if(w > wMaxAllowed + wMaxAllowed)
                w = wMaxAllowed + wMaxAllowed;
            if(oldW == 0.0F)
            {
                if(w < 10F * fricCoeffT)
                    w = 0.0F;
            } else
            if(w < 2.0F * fricCoeffT)
                w = 0.0F;
            if(reference.isPlayers() && World.cur().diffCur.Torque_N_Gyro_Effects && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode())
            {
                propIW.set(propI * w * propReductor, 0.0D, 0.0D);
                if(propDirection == 1)
                    propIW.x = -((Tuple3d) (propIW)).x;
                engineTorque.set(0.0F, 0.0F, 0.0F);
                float reactive = propI * aw * propReductor * ReactiveMomentScale;
                if(propDirection == 0)
                {
                    engineTorque.x += propMoment * PropMomentScale;
                    engineTorque.x += reactive;
                } else
                {
                    engineTorque.x -= propMoment * PropMomentScale;
                    engineTorque.x -= reactive;
                }
            } else
            {
                engineTorque.set(0.0F, 0.0F, 0.0F);
            }
            engineForce.set(engineVector);
            engineForce.scale(propForce);
            tmpV3f.cross(propPos, engineForce);
            engineTorque.add(tmpV3f);
            rearRush = 0.0F;
            rpm = toRPM(w);
            double summVflow = ((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x + addVflow;
            if(summVflow < 1.0D)
                summVflow = 1.0D;
            double flowFactor = 1.0D / ((double)(Atmosphere.density(reference.getAltitude()) * 6F) * summVflow);
            addVflow = 0.94999999999999996D * addVflow + 0.050000000000000003D * (double)propForce * flowFactor;
            addVside = 0.94999999999999996D * addVside + 0.050000000000000003D * (double)(propMoment / propr) * flowFactor * (double)VsideScale;
            if(addVside < 0.0D)
                addVside = 0.0D;
            break;
        }

        case 2: // '\002'
        {
            float pexternal = pressureExtBar;
            engineMoment = propAngleDeviceMinParam + getControlThrottle() * (propAngleDeviceMaxParam - propAngleDeviceMinParam);
            engineMoment /= propAngleDeviceMaxParam;
            engineMoment *= engineMomentMax;
            engineMoment *= getReadyness();
            engineMoment *= getDistabilisationMultiplier();
            engineMoment *= getStageMultiplier();
            engineMoment += getJetFrictionMoment(dt);
            computePropForces(w, 0.0F, 0.0F, propAoA0, 0.0F);
            float wRel = w * _1_wMax;
            float airConsumption = wRel * pressureExtBar;
            float thrustFromW = wRel * wRel;
            float tempCoeff = 1.0F - 0.006F * (Atmosphere.temperature((float)((Tuple3d) (((FlightModelMain) (reference)).Loc)).z) - 290F);
            float forceUD = 1.0F - 0.0011F * reference.getSpeed();
            propForce = thrustMax * airConsumption * thrustFromW * tempCoeff * forceUD * getStageMultiplier();
            float deltaM = engineMoment - propMoment;
            aw = (deltaM / (propI + engineI)) * 1.0F;
            if(aw > 0.0F)
                aw *= engineAcceleration;
            w += aw * dt;
            if(w < -wMaxAllowed)
                w = -wMaxAllowed;
            if(w > wMaxAllowed + wMaxAllowed)
                w = wMaxAllowed + wMaxAllowed;
            engineForce.set(engineVector);
            engineForce.scale(propForce);
            engineTorque.cross(enginePos, engineForce);
            rpm = toRPM(w);
            break;
        }

        case 10: // '\n'
        {
            engineMoment = propAngleDeviceMinParam + getControlThrottle() * (propAngleDeviceMaxParam - propAngleDeviceMinParam);
            controlProp = 0.75F + 0.25F * controlThrottle;
            if(Math.abs(w) < 1E-005F)
                propPhiW = 1.570796F;
            else
                propPhiW = (float)Math.atan(((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x / (double)(w * propReductor * propr));
            propAoA = propPhi - propPhiW;
            computePropForces(w * propReductor, (float)((Tuple3d) (((FlightModelMain) (reference)).Vflow)).x, propPhi, propAoA, reference.getAltitude());
            if(isPropAngleDeviceOperational())
            {
                if(w < engineMoment)
                {
                    engineMoment = Math.min(1.0F, 0.01F * (engineMoment - w) - 0.012F * aw);
                    propTarget -= engineMoment * getPropAngleDeviceSpeed() * dt;
                } else
                {
                    engineMoment = Math.min(1.0F, 0.01F * (w - engineMoment) + 0.012F * aw);
                    propTarget += engineMoment * getPropAngleDeviceSpeed() * dt;
                }
                if(stage == 6 && propTarget < propPhiW - 0.12F)
                {
                    propTarget = propPhiW - 0.12F;
                    if(propPhi < propTarget)
                        propPhi += 0.2F * dt;
                }
            } else
            {
                propTarget = 0.0F;
            }
            engineMoment /= propAngleDeviceMaxParam;
            engineMoment *= engineMomentMax;
            engineMoment *= getReadyness();
            engineMoment *= getDistabilisationMultiplier();
            engineMoment *= getStageMultiplier();
            engineMoment += getJetFrictionMoment(dt);
            computePropForces(w, 0.0F, 0.0F, propAoA0, 0.0F);
            float f291 = w * _1_wMax;
            float f301 = f291 * pressureExtBar;
            float f311 = f291 * f291;
            float f321 = 1.0F - 0.006F * (Atmosphere.temperature((float)((Tuple3d) (((FlightModelMain) (reference)).Loc)).z) - 290F);
            float f331 = 1.0F - 0.0011F * reference.getSpeed();
            propForce = thrustMax * f301 * f311 * f321 * f331 * getStageMultiplier();
            float f201 = engineMoment - propMoment;
            aw = (f201 / (propI + engineI)) * 1.0F;
            if(aw > 0.0F)
                aw *= engineAcceleration;
            w += aw * dt;
            if(w < -wMaxAllowed)
                w = -wMaxAllowed;
            if(w > wMaxAllowed + wMaxAllowed)
                w = wMaxAllowed + wMaxAllowed;
            engineForce.set(engineVector);
            engineForce.scale(propForce);
            engineTorque.cross(enginePos, engineForce);
            rpm = toRPM(w);
            break;
        }

        case 3: // '\003'
        case 4: // '\004'
        {
            w = wMin + (wMax - wMin) * controlThrottle;
            if(w < wMin || w < 0.0F || ((FlightModelMain) (reference)).M.fuel == 0.0F || stage != 6)
                w = 0.0F;
            propForce = (w / wMax) * thrustMax;
            propForce *= getStageMultiplier();
            propForce *= compressorPMax / (compressorPMax + 1E-005F * Atmosphere.pressure((float)((Tuple3d) (((FlightModelMain) (reference)).Loc)).z));
            engineForce.set(engineVector);
            engineForce.scale(propForce);
            engineTorque.cross(enginePos, engineForce);
            rpm = toRPM(w);
            break;
        }

        case 6: // '\006'
        {
            w = wMin + (wMax - wMin) * controlThrottle;
            if(w < wMin || w < 0.0F || stage != 6)
                w = 0.0F;
            float cq = reference.getSpeed() / 94F;
            if(cq < 1.0F)
                w = 0.0F;
            else
                cq = (float)Math.sqrt(cq);
            propForce = (w / wMax) * thrustMax * cq;
            propForce *= getStageMultiplier();
            float f = (float)((FlightModelMain) (reference)).Vwld.length();
            if(f > 208.333F)
                if(f > 291.666F)
                    propForce = 0.0F;
                else
                    propForce *= (float)Math.sqrt((291.666F - f) / 83.33299F);
            engineForce.set(engineVector);
            engineForce.scale(propForce);
            engineTorque.cross(enginePos, engineForce);
            rpm = toRPM(w);
            if(!(reference instanceof RealFlightModel))
                break;
            RealFlightModel r = (RealFlightModel)reference;
            f = Aircraft.cvt(propForce, 0.0F, thrustMax, 0.0F, 0.21F);
            if(r.producedShakeLevel < f)
                r.producedShakeLevel = f;
            break;
        }

        case 5: // '\005'
        {
            engineForce.set(engineVector);
            engineForce.scale(propForce);
            engineTorque.cross(enginePos, engineForce);
            break;
        }

        case 8: // '\b'
        default:
        {
            return;
        }
        }
    }

    private void computePropForces(float omega, float vAir, float phi, float alpha, float alt)
    {
        float vProp = omega * propr;
        float wAirSq = vAir * vAir + vProp * vProp;
        float wAir = (float)Math.sqrt(wAirSq);
        float p = 0.5F * getFanCy((float)Math.toDegrees(alpha)) * Atmosphere.density(alt) * wAirSq * propSEquivalent;
        float q = 0.5F * getFanCx((float)Math.toDegrees(alpha)) * Atmosphere.density(alt) * wAirSq * propSEquivalent;
        if(wAir > 300F)
        {
            float waveResCoeff = 1.0F + 0.02F * (wAir - 300F);
            if(waveResCoeff > 2.0F)
                waveResCoeff = 2.0F;
            q *= waveResCoeff;
        }
        if(wAir < 0.001F)
            wAir = 0.001F;
        float normV = 1.0F / wAir;
        float sinTheta = vAir * normV;
        float cosTheta = vProp * normV;
        float forceCoeff = 1.0F;
        if(vAir < Vopt)
        {
            float dV = Vopt - vAir;
            forceCoeff = 1.0F - 5E-005F * dV * dV;
        }
        propForce = forceCoeff * (p * cosTheta - q * sinTheta);
        propMoment = (q * cosTheta + p * sinTheta) * propr;
    }

    public void toggle()
    {
        if(stage == 0)
        {
            setEngineStarts(((Interpolate) (reference)).actor);
            return;
        }
        if(stage < 7)
        {
            setEngineStops(((Interpolate) (reference)).actor);
            if(reference.isPlayers())
                HUD.log("EngineI0");
            return;
        } else
        {
            return;
        }
    }

    public float getPowerOutput()
    {
        if(stage == 0 || stage > 6)
            return 0.0F;
        else
            return controlThrottle * readyness;
    }

    public float getThrustOutput()
    {
        if(stage == 0 || stage > 6)
            return 0.0F;
        float thr = w * _1_wMax * readyness;
        if(thr > 1.1F)
            thr = 1.1F;
        return thr;
    }

    public float getReadyness()
    {
        return readyness;
    }

    public float getPropPhi()
    {
        return propPhi;
    }

    private float getPropAngleDeviceSpeed()
    {
        if(isPropAngleDeviceHydroOperable)
            return propAngleChangeSpeed;
        else
            return propAngleChangeSpeed * 10F;
    }

    public int getPropDir()
    {
        return propDirection;
    }

    public float getPropAoA()
    {
        return propAoA;
    }

    public Vector3f getForce()
    {
        return engineForce;
    }

    public float getRearRush()
    {
        return rearRush;
    }

    public float getw()
    {
        return w;
    }

    public float getRPM()
    {
        return rpm;
    }

    public float getPropw()
    {
        return w * propReductor;
    }

    public float getPropRPM()
    {
        return rpm * propReductor;
    }

    public float getAPropw()
    {
        return w * ApropReductor;
    }

    public float getAPropRPM()
    {
        return rpm * ApropReductor;
    }

    public int getType()
    {
        return type;
    }

    public int getStarter()
    {
        return starter;
    }

    public float getControlThrottle()
    {
        return controlThrottle;
    }

    public float getCoPControlThrottle()
    {
        return copControlThrottle;
    }

    public boolean getControlAfterburner()
    {
        return controlAfterburner;
    }

    public float getControlManualAfterburner()
    {
        return controlFAfterburner;
    }

    public float getCoPontrolManualAfterburner()
    {
        return copControlBoost;
    }

    public boolean isHasControlThrottle()
    {
        return bHasThrottleControl;
    }

    public boolean isHasControlAfterburner()
    {
        return bHasAfterburnerControl;
    }

    public float getControlProp()
    {
        return controlProp;
    }

    public float getCoPControlProp()
    {
        return copControlProp;
    }

    public float getElPropPos()
    {
        float value;
        if(bControlPropAuto)
            value = controlProp;
        else
            value = (propPhiMax - propPhi) / (propPhiMax - propPhiMin);
        if(value < 0.1F)
            return 0.0F;
        if(value > 0.9F)
            return 1.0F;
        else
            return value;
    }

    public boolean getControlPropAuto()
    {
        return bControlPropAuto;
    }

    public boolean isHasControlProp()
    {
        return bHasPropControl;
    }

    public boolean isAllowsAutoProp()
    {
        if(reference.isPlayers() && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode())
            if(World.cur().diffCur.ComplexEManagement)
                switch(propAngleDeviceType)
                {
                case 0: // '\0'
                    return false;

                case 5: // '\005'
                    return true;

                case 6: // '\006'
                    return false;

                case 3: // '\003'
                case 4: // '\004'
                    return false;

                case 1: // '\001'
                case 2: // '\002'
                    return false;

                case 11: // '\013'
                case 12: // '\f'
                    return true;

                case 7: // '\007'
                case 8: // '\b'
                    return true;
                }
            else
                return bHasPropControl;
        return true;
    }

    public float getControlMix()
    {
        return controlMix;
    }

    public float getCoPControlMix()
    {
        return copControlMix;
    }

    public boolean isHasControlMix()
    {
        return bHasMixControl;
    }

    public int getControlMagnetos()
    {
        return controlMagneto;
    }

    public int getControlCompressor()
    {
        return controlCompressor;
    }

    public int getCoPControlCompressor()
    {
        return copControlSupercharger;
    }

    public boolean isHasControlMagnetos()
    {
        return bHasMagnetoControl;
    }

    public boolean isHasControlCompressor()
    {
        return bHasCompressorControl;
    }

    public boolean isHasControlBoost()
    {
        return afterburnerType == 12;
    }

    public int getControlFeather()
    {
        return controlFeather;
    }

    public boolean isHasControlFeather()
    {
        return bHasFeatherControl;
    }

    public boolean isAllowsAutoRadiator()
    {
        if(World.cur().diffCur.ComplexEManagement)
        {
            switch(RadiatorAlgoritm)
            {
            case 2: // '\002'
            case 3: // '\003'
                return true;
            }
            switch(propAngleDeviceType)
            {
            case 7: // '\007'
                return true;

            case 8: // '\b'
                return type == 0;
            }
            return false;
        } else
        {
            return true;
        }
    }

    public boolean isHasControlRadiator()
    {
        return bHasRadiatorControl;
    }

    public float getControlRadiator()
    {
        return controlRadiator;
    }

    public float getCoPControlRadiator()
    {
        return copControlRadiator;
    }

    public int getExtinguishers()
    {
        return extinguishers;
    }

    private float getFanCy(float degrees)
    {
        if(degrees > 34F)
            degrees = 34F;
        if(degrees < -8F)
            degrees = -8F;
        if(degrees < 16F)
            return -0.004688F * degrees * degrees + 0.15F * degrees + 0.4F;
        float addCy = 0.0F;
        if(degrees > 22F)
        {
            addCy = 0.01F * (degrees - 22F);
            degrees = 22F;
        }
        return (0.00097222F * degrees * degrees - 0.070833F * degrees) + 2.4844F + addCy;
    }

    private float getFanCx(float degrees)
    {
        if(degrees < -4F)
            degrees = -8F - degrees;
        if(degrees > 34F)
            degrees = 34F;
        if((double)degrees < 16D)
            return 0.00035F * degrees * degrees + 0.0028F * degrees + 0.0256F;
        float addCx = 0.0F;
        if(degrees > 22F)
        {
            addCx = 0.04F * (degrees - 22F);
            degrees = 22F;
        }
        return ((-0.00555F * degrees * degrees + 0.24444F * degrees) - 2.32888F) + addCx;
    }

    public int getCylinders()
    {
        return cylinders;
    }

    public int getCylindersOperable()
    {
        return cylindersOperable;
    }

    public float getCylindersRatio()
    {
        return (float)cylindersOperable / (float)cylinders;
    }

    public int getStage()
    {
        return stage;
    }

    public float getBoostFactor()
    {
        return engineBoostFactor;
    }

    public float getManifoldPressure()
    {
        return compressorManifoldPressure;
    }

    public void setManifoldPressure(float value)
    {
        compressorManifoldPressure = value;
    }

    public boolean getSootState()
    {
        return false;
    }

    public Point3f getEnginePos()
    {
        return enginePos;
    }

    public Point3f getPropPos()
    {
        return propPos;
    }

    public Vector3f getEngineVector()
    {
        return engineVector;
    }

    public float rangeAndFuel(float momForFuel, float w, boolean Boost, float throttle)
    {
        tmpF = 0.0F;
        return 3600F * tmpF;
    }

    public float forcePropAOA(float vel, float alt, float Throt, boolean Boost)
    {
        return forcePropAOA(vel, alt, Throt, Boost, 1.0F);
    }

    public float forcePropAOA(float vel, float alt, float Throt, boolean Boost, float rpmPct)
    {
        switch(type)
        {
        case 9: // '\t'
        default:
            return -1F;

        case 0: // '\0'
        case 1: // '\001'
        case 7: // '\007'
            float safeControlThrottle = controlThrottle;
            boolean safeControlAfterburner = controlAfterburner;
            float safeControlFAfterburner = controlFAfterburner;
            int safeStage = stage;
            safeLoc.set(((FlightModelMain) (reference)).Loc);
            safeVwld.set(((FlightModelMain) (reference)).Vwld);
            safeVflow.set(((FlightModelMain) (reference)).Vflow);
            if(Boost)
                w = wWEP;
            else
                w = wMax;
            w *= rpmPct;
            controlThrottle = Throt;
            if((double)engineBoostFactor <= 1.0D && controlThrottle > 1.0F)
                controlThrottle = 1.0F;
            if(afterburnerType > 0 && Boost)
            {
                controlAfterburner = true;
                controlFAfterburner = 1.0F;
            }
            stage = 6;
            fastATA = true;
            ((FlightModelMain) (reference)).Loc.set(0.0D, 0.0D, alt);
            ((FlightModelMain) (reference)).Vwld.set(vel, 0.0D, 0.0D);
            ((FlightModelMain) (reference)).Vflow.set(vel, 0.0D, 0.0D);
            pressureExtBar = Atmosphere.pressure(reference.getAltitude()) + compressorSpeedManifold * 0.5F * Atmosphere.density(reference.getAltitude()) * vel * vel;
            pressureExtBar *= 9.8716682999999996E-006D;
            maxMoment = getCompressorMultiplier(0.033F);
            maxMoment *= getN();
            if(Boost && bWepRpmInLowGear && controlCompressor == compressorMaxStep)
            {
                w = wMax * rpmPct;
                float maxMoment2 = getCompressorMultiplier(0.033F);
                maxMoment2 *= getN();
                maxMoment = maxMoment2;
            }
            maxW = w;
            int j = 0;
            float propAngle = propPhiMin;
            float propForceBak = -1E+008F;
            boolean twoPitch = false;
            if((Aircraft)((Interpolate) (reference)).actor instanceof TypeTwoPitchProp)
                twoPitch = true;
            while(propAngleDeviceType == 0 || twoPitch) 
            {
                float dir = 2.0F;
                j = 0;
                float step = 0.1F;
                float f8 = 0.5F;
                do
                {
                    if(Boost)
                        w = wWEP * f8;
                    else
                        w = wMax * f8;
                    float bs = (float)Math.sqrt(vel * vel + w * propr * propReductor * w * propr * propReductor);
                    float aoa = propAngle - (float)Math.asin(vel / bs);
                    computePropForces(w * propReductor, vel, 0.0F, aoa, alt);
                    maxMoment = getN() * getCompressorMultiplier(0.033F);
                    maxW = w;
                    if(j > 32 || (double)step <= 1.0000000000000001E-005D)
                        break;
                    if(propMoment < maxMoment)
                    {
                        if(dir == 1.0F)
                            step /= 2.0F;
                        f8 *= 1.0F + step;
                        dir = 0.0F;
                    } else
                    {
                        if(dir == 0.0F)
                            step /= 2.0F;
                        f8 /= 1.0F + step;
                        dir = 1.0F;
                    }
                    j++;
                } while(true);
                if(!twoPitch)
                    break;
                if(propAngle == propPhiMin)
                {
                    propForceBak = propForce;
                    propAngle = propPhiMax;
                    continue;
                }
                if(propForceBak > propForce)
                    propForce = propForceBak;
                break;
            }
            controlThrottle = safeControlThrottle;
            controlAfterburner = safeControlAfterburner;
            controlFAfterburner = safeControlFAfterburner;
            stage = safeStage;
            ((FlightModelMain) (reference)).Loc.set(safeLoc);
            ((FlightModelMain) (reference)).Vwld.set(safeVwld);
            ((FlightModelMain) (reference)).Vflow.set(safeVflow);
            fastATA = false;
            w = 0.0F;
            if(twoPitch || propAngleDeviceType == 0)
                return propForce;
            float maxAOA = 1.5F;
            float minAOA = -0.06F;
            float aoa = 0.5F * (maxAOA + minAOA);
            int N = 0;
            do
            {
                aoa = 0.5F * (maxAOA + minAOA);
                if(Boost && (!bWepRpmInLowGear || controlCompressor != compressorMaxStep))
                    computePropForces(wWEP * rpmPct * propReductor, vel, 0.0F, aoa, alt);
                else
                    computePropForces(wMax * rpmPct * propReductor, vel, 0.0F, aoa, alt);
                if((propForce <= 0.0F || Math.abs(propMoment - maxMoment) >= 1E-005F) && N <= 32)
                {
                    if(propForce > 0.0F && propMoment > maxMoment)
                        maxAOA = aoa;
                    else
                        minAOA = aoa;
                    N++;
                } else
                {
                    return propForce;
                }
            } while(true);

        case 10: // '\n'
            float f5 = getCompressorMultiplier(0.033F);
            f5 *= getN();
            w = 0.0F;
            float f7 = 1.5F;
            float f9x = -0.06F;
            int kx = 0;
            do
            {
                float f13 = 0.5F * (f7 + f9x);
                if(Boost)
                    computePropForces(wWEP * propReductor, vel, 0.0F, f13, alt);
                else
                    computePropForces(wMax * propReductor, vel, 0.0F, f13, alt);
                if((propForce <= 0.0F || Math.abs(propMoment - f5) >= 1E-005F) && kx <= 32)
                {
                    if(propForce > 0.0F && propMoment > f5)
                        f7 = f13;
                    else
                        f9x = f13;
                    kx++;
                } else
                {
                    propForce = (float)Math.toDegrees(Math.atan(vel / (wMax * propReductor * propr)) + (double)f13);
                    return propForce;
                }
            } while(true);

        case 2: // '\002'
            pressureExtBar = Atmosphere.pressure(alt) + compressorSpeedManifold * 0.5F * Atmosphere.density(alt) * vel * vel;
            pressureExtBar *= 9.8716682999999996E-006D;
            float airConsumption = pressureExtBar;
            float tempCoeff = 1.0F - 0.006F * (Atmosphere.temperature(alt) - 290F);
            float forceUD = 1.0F - 0.0011F * vel;
            propForce = thrustMax * airConsumption * tempCoeff * forceUD;
            if(Throt > 1.0F)
                Throt = 1.0F;
            propForce *= Throt;
            return propForce;

        case 3: // '\003'
        case 4: // '\004'
        case 6: // '\006'
            propForce = thrustMax;
            propForce *= compressorPMax / (compressorPMax + 1E-005F * Atmosphere.pressure(alt));
            return propForce;

        case 5: // '\005'
            return thrustMax;

        case 8: // '\b'
            return -1F;
        }
    }

    public float getEngineLoad()
    {
        float t = 0.1F + getControlThrottle() * 0.8181818F;
        float r = getw() / wMax;
        return r / t;
    }

    private void overrevving()
    {
        if((reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode() && World.cur().diffCur.ComplexEManagement && World.cur().diffCur.Engine_Overheat && w > wMaxAllowed && bIsMaster)
        {
            wMaxAllowed *= 0.999965F;
            _1_wMaxAllowed = 1.0F / wMaxAllowed;
            tmpF *= 1.0F - (wMaxAllowed - w) * 0.01F;
            engineDamageAccum += 0.01F + 0.05F * (w - wMaxAllowed) * _1_wMaxAllowed;
            if(engineDamageAccum > 1.0F)
            {
                if(heatStringID == -1)
                    heatStringID = HUD.makeIdLog();
                if(reference.isPlayers())
                    HUD.log(heatStringID, "EngineOverheat");
                setReadyness(getReadyness() - (engineDamageAccum - 1.0F) * 0.005F);
            }
            if(getReadyness() < 0.2F)
                setEngineDies(((Interpolate) (reference)).actor);
        }
    }

    public float getN()
    {
        if(stage == 6)
        {
            switch(engineCarburetorType)
            {
            case 0: // '\0'
            {
                float control = 0.05F + 0.95F * getControlThrottle();
                float wCoeff = w / wMax;
                tmpF = engineMomentMax * ((-1F / control) * wCoeff * wCoeff + 2.0F * wCoeff);
                if(getControlThrottle() > 1.0F)
                    tmpF *= engineBoostFactor;
                overrevving();
                break;
            }

            case 3: // '\003'
            {
                float control = 0.1F + 0.9F * getControlThrottle();
                float wCoeff = w / wNom;
                tmpF = engineMomentMax * ((-1F / control) * wCoeff * wCoeff + 2.0F * wCoeff);
                if(getControlThrottle() > 1.0F)
                    tmpF *= engineBoostFactor;
                float redCoeff = getControlThrottle() - neg_G_Counter * 0.1F;
                if(redCoeff <= 0.3F)
                    redCoeff = 0.3F;
                if(reference.getOverload() < 0.0F && neg_G_Counter >= 0.0F)
                {
                    neg_G_Counter += 0.03F;
                    producedDistabilisation += 10F + 5F * neg_G_Counter;
                    tmpF *= redCoeff;
                    if(reference.isPlayers() && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode() && bIsMaster && neg_G_Counter > World.Rnd().nextFloat(5F, 8F))
                        setEngineStops(((Interpolate) (reference)).actor);
                } else
                if(reference.getOverload() >= 0.0F && neg_G_Counter > 0.0F)
                {
                    neg_G_Counter -= 0.015F;
                    producedDistabilisation += 10F + 5F * neg_G_Counter;
                    tmpF *= redCoeff;
                    bFloodCarb = true;
                } else
                {
                    bFloodCarb = false;
                    neg_G_Counter = 0.0F;
                }
                overrevving();
                break;
            }

            case 1: // '\001'
            case 2: // '\002'
            {
                float control = 0.1F + 0.9F * getControlThrottle();
                if(control > 1.0F)
                    control = 1.0F;
                float Navail = engineMomentMax * (-0.5F * control * control + 1.0F * control + 0.5F);
                float wCoeff;
                if(controlAfterburner)
                    wCoeff = w / (wWEP * control);
                else
                if(isHasControlBoost())
                {
                    float f = Aircraft.cvt(controlFAfterburner, 0.0F, 1.0F, wNom, wWEP);
                    wCoeff = w / (f * control);
                } else
                {
                    wCoeff = w / (wNom * control);
                }
                tmpF = Navail * (2.0F * wCoeff - 1.0F * wCoeff * wCoeff);
                if(getControlThrottle() > 1.0F)
                    tmpF *= 1.0F + (getControlThrottle() - 1.0F) * 10F * (engineBoostFactor - 1.0F);
                overrevving();
                break;
            }

            case 4: // '\004'
            {
                float control = 0.1F + 0.9F * getControlThrottle();
                if(control > 1.0F)
                    control = 1.0F;
                float Navail = engineMomentMax * (-0.5F * control * control + 1.0F * control + 0.5F);
                float wCoeff;
                if(controlAfterburner)
                {
                    wCoeff = w / (wWEP * control);
                    if(control >= 0.95F)
                        bFullT = true;
                    else
                        bFullT = false;
                } else
                if(isHasControlBoost())
                {
                    float f = Aircraft.cvt(controlFAfterburner, 0.0F, 1.0F, wNom, wWEP);
                    wCoeff = w / (f * control);
                    if(control >= 0.95F)
                        bFullT = true;
                    else
                        bFullT = false;
                } else
                {
                    wCoeff = w / (wNom * control);
                    bFullT = false;
                }
                tmpF = Navail * (2.0F * wCoeff - 1.0F * wCoeff * wCoeff);
                if(getControlThrottle() > 1.0F)
                    tmpF *= 1.0F + (getControlThrottle() - 1.0F) * 10F * (engineBoostFactor - 1.0F);
                float redCoeff = getControlThrottle() - neg_G_Counter * 0.2F;
                if(redCoeff <= 0.0F)
                    redCoeff = 0.1F;
                if(reference.getOverload() < 0.0F && neg_G_Counter >= 0.0F)
                {
                    neg_G_Counter += 0.03F;
                    if(bFullT && neg_G_Counter < 0.5F)
                    {
                        producedDistabilisation += 15F + 5F * neg_G_Counter;
                        tmpF *= 0.52F - neg_G_Counter;
                    } else
                    if(bFullT && neg_G_Counter >= 0.5F && neg_G_Counter <= 0.8F)
                    {
                        neg_G_Counter = 0.51F;
                        bFloodCarb = false;
                    } else
                    if(bFullT && neg_G_Counter > 0.8F)
                    {
                        neg_G_Counter -= 0.045F;
                        producedDistabilisation += 10F + 5F * neg_G_Counter;
                        tmpF *= redCoeff;
                        bFloodCarb = true;
                    } else
                    {
                        producedDistabilisation += 10F + 5F * neg_G_Counter;
                        tmpF *= redCoeff;
                        if(reference.isPlayers() && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode() && bIsMaster && neg_G_Counter > World.Rnd().nextFloat(7.5F, 9.5F))
                            setEngineStops(((Interpolate) (reference)).actor);
                    }
                } else
                if(reference.getOverload() >= 0.0F && neg_G_Counter > 0.0F)
                {
                    neg_G_Counter -= 0.03F;
                    if(!bFullT)
                    {
                        producedDistabilisation += 10F + 5F * neg_G_Counter;
                        tmpF *= redCoeff;
                    }
                    bFloodCarb = true;
                } else
                {
                    neg_G_Counter = 0.0F;
                    bFloodCarb = false;
                }
                overrevving();
                break;
            }
            }
            if(controlAfterburner)
                if(afterburnerType == 1)
                {
                    if(controlThrottle > 1.0F && ((FlightModelMain) (reference)).M.nitro > 0.0F)
                        tmpF *= engineAfterburnerBoostFactor;
                } else
                if(afterburnerType == 8 || afterburnerType == 7)
                {
                    if(afterburnerMaxAltitude > 0.0F)
                    {
                        if(reference.getAltitude() < afterburnerMaxAltitude)
                            tmpF *= engineAfterburnerBoostFactor;
                    } else
                    if(controlCompressor < compressorMaxStep)
                        tmpF *= engineAfterburnerBoostFactor;
                } else
                {
                    tmpF *= engineAfterburnerBoostFactor;
                }
            if(isHasControlBoost())
                tmpF *= Aircraft.cvt(controlFAfterburner, 0.0F, 1.0F, 1.0F, engineAfterburnerBoostFactor);
            if(engineDamageAccum > 0.0F)
                engineDamageAccum -= 0.01F;
            if(engineDamageAccum < 0.0F)
                engineDamageAccum = 0.0F;
            if(tmpF < 0.0F)
                tmpF = Math.max(tmpF, -0.8F * w * _1_wMax * engineMomentMax);
            return tmpF;
        }
        tmpF = -1500F * w * _1_wMax * engineMomentMax;
        if(stage == 8)
            w = 0.0F;
        return tmpF;
    }

    private float getDistabilisationMultiplier()
    {
        if(engineMoment < 0.0F)
            return 1.0F;
        float f = 1.0F + World.Rnd().nextFloat(-1F, 0.1F) * getDistabilisationAmplitude();
        if(f < 0.0F && w < 0.5F * (wMax + wMin))
            return 0.0F;
        else
            return f;
    }

    public float getDistabilisationAmplitude()
    {
        if(getCylindersOperable() > 2)
        {
            float cOpc = 1.0F - getCylindersRatio();
            return engineDistAM * w * w + engineDistBM * w + engineDistCM + 9.25F * cOpc * cOpc + producedDistabilisation;
        } else
        {
            return 11.25F;
        }
    }

    private float getCompressorMultiplier(float dt)
    {
        float compThrot = controlThrottle;
        if(compThrot > 1.0F)
            compThrot = 1.0F;
        float needManifold;
        switch(propAngleDeviceType)
        {
        case 1: // '\001'
        case 2: // '\002'
        case 7: // '\007'
        case 8: // '\b'
        case 11: // '\013'
        case 12: // '\f'
            needManifold = getATA(toRPM(propAngleDeviceMinParam + (propAngleDeviceMaxParam - propAngleDeviceMinParam) * compThrot));
            break;

        case 0: // '\0'
        case 3: // '\003'
        case 4: // '\004'
        case 5: // '\005'
        case 6: // '\006'
        case 9: // '\t'
        case 10: // '\n'
        default:
            needManifold = compressorRPMtoWMaxATA * (0.55F + 0.45F * compThrot);
            break;
        }
        coolMult = 1.0F;
        compressorManifoldThreshold = needManifold;
        switch(compressorType)
        {
        case 0: // '\0'
        {
            float pexternal = Atmosphere.pressure(reference.getAltitude()) + 0.5F * Atmosphere.density(reference.getAltitude()) * reference.getSpeed() * reference.getSpeed();
            float f = pexternal / Atmosphere.P0();
            coolMult = f;
            return f;
        }

        case 1: // '\001'
        {
            float pexternal = pressureExtBar;
            if((!bHasCompressorControl || !reference.isPlayers() || !(reference instanceof RealFlightModel) || !((RealFlightModel)reference).isRealMode() || !World.cur().diffCur.ComplexEManagement || fastATA) && (reference.isTick(128, 0) || fastATA))
            {
                compressorStepFound = false;
                controlCompressor = 0;
            }
            float maxCompFactor = -1F;
            float maxCompMultiplier = -1F;
            int maxCompStep = -1;
            float f;
            if(fastATA)
            {
                for(controlCompressor = 0; controlCompressor <= compressorMaxStep; controlCompressor++)
                {
                    compressorManifoldThreshold = needManifold;
                    float pcomp = compressorPressure[controlCompressor];
                    float compressionCoeff = compressorRPMtoWMaxATA / pcomp;
                    float compMultiplier = 1.0F;
                    float compFactor = 1.0F;
                    if(pexternal > pcomp)
                    {
                        float dPcomp = 1.0F - pcomp;
                        if(dPcomp < 0.0001F)
                            dPcomp = 0.0001F;
                        float dPcur = 1.0F - pexternal;
                        float groundMultiplier = 1.0F;
                        for(int i = 1; i <= controlCompressor; i++)
                            if(compressorAltMultipliers[controlCompressor] >= 1.0F)
                                groundMultiplier *= compressorBaseMultipliers[controlCompressor];
                            else
                                groundMultiplier *= compressorBaseMultipliers[controlCompressor] * compressorAltMultipliers[controlCompressor];

                        compMultiplier = groundMultiplier + (dPcur / dPcomp) * (compressorAltMultipliers[controlCompressor] - groundMultiplier);
                    } else
                    {
                        compMultiplier = compressorAltMultipliers[controlCompressor];
                    }
                    compressorManifoldPressure = (compressorPAt0 + (1.0F - compressorPAt0) * w * _1_wMax) * pexternal * compressionCoeff;
                    float need2ndThrottle = compressorRPMtoWMaxATA / compressorManifoldPressure;
                    if(controlAfterburner && (afterburnerType != 8 && afterburnerType != 7 || controlCompressor != compressorMaxStep) && (afterburnerType != 1 || controlThrottle <= 1.0F || ((FlightModelMain) (reference)).M.nitro > 0.0F))
                    {
                        need2ndThrottle *= afterburnerCompressorFactor;
                        compressorManifoldThreshold *= afterburnerCompressorFactor;
                    }
                    if(isHasControlBoost())
                    {
                        float boostF = Aircraft.cvt(controlFAfterburner, 0.0F, 1.0F, 1.0F, afterburnerCompressorFactor);
                        need2ndThrottle *= boostF;
                        compressorManifoldThreshold *= boostF;
                    }
                    compressor2ndThrottle = need2ndThrottle;
                    if(compressor2ndThrottle > 1.0F)
                        compressor2ndThrottle = 1.0F;
                    compressorManifoldPressure *= compressor2ndThrottle;
                    compressor1stThrottle = needManifold / compressorRPMtoWMaxATA;
                    if(compressor1stThrottle > 1.0F)
                        compressor1stThrottle = 1.0F;
                    compressorManifoldPressure *= compressor1stThrottle;
                    compFactor = (compMultiplier * compressorManifoldPressure) / compressorManifoldThreshold;
                    if(controlAfterburner && (afterburnerType == 8 || afterburnerType == 7) && controlCompressor == compressorMaxStep)
                    {
                        if(compFactor / engineAfterburnerBoostFactor > maxCompFactor)
                        {
                            maxCompFactor = compFactor;
                            maxCompStep = controlCompressor;
                        }
                    } else
                    if(compFactor > maxCompFactor)
                    {
                        maxCompFactor = compFactor;
                        maxCompStep = controlCompressor;
                    }
                }

                f = maxCompFactor;
                controlCompressor = maxCompStep;
            } else
            {
                float maxATA = needManifold;
                if(controlAfterburner)
                    maxATA *= afterburnerCompressorFactor;
                if(isHasControlBoost())
                    maxATA *= Aircraft.cvt(controlFAfterburner, 0.0F, 1.0F, 1.0F, afterburnerCompressorFactor);
                float pcomp;
                float compressionCoeff;
                do
                {
                    pcomp = compressorPressure[controlCompressor];
                    compressionCoeff = compressorRPMtoWMaxATA / pcomp;
                    float compMultiplier = 1.0F;
                    float compFactor = 1.0F;
                    if(pexternal > pcomp)
                    {
                        float dPcomp = 1.0F - pcomp;
                        if(dPcomp < 0.0001F)
                            dPcomp = 0.0001F;
                        float dPcur = 1.0F - pexternal;
                        float groundMultiplier = 1.0F;
                        for(int i = 1; i <= controlCompressor; i++)
                            if(compressorAltMultipliers[controlCompressor] >= 1.0F)
                                groundMultiplier *= compressorBaseMultipliers[controlCompressor];
                            else
                                groundMultiplier *= compressorBaseMultipliers[controlCompressor] * compressorAltMultipliers[controlCompressor];

                        compMultiplier = groundMultiplier + (dPcur / dPcomp) * (compressorAltMultipliers[controlCompressor] - groundMultiplier);
                        compFactor = compMultiplier;
                    } else
                    {
                        compMultiplier = compressorAltMultipliers[controlCompressor];
                        compFactor = (compMultiplier * pexternal * needManifold * (compressorPAt0 + (1.0F - compressorPAt0) * w * _1_wMax)) / (pcomp * maxATA);
                    }
                    if(compFactor > maxCompFactor)
                    {
                        maxCompFactor = compFactor;
                        maxCompMultiplier = compMultiplier;
                        maxCompStep = controlCompressor;
                    }
                    if(!compressorStepFound)
                    {
                        controlCompressor++;
                        if(controlCompressor == compressorMaxStep + 1)
                            compressorStepFound = true;
                    }
                } while(!compressorStepFound);
                if(maxCompStep < 0)
                    maxCompStep = 0;
                controlCompressor = maxCompStep;
                pcomp = compressorPressure[controlCompressor];
                compressionCoeff = compressorRPMtoWMaxATA / pcomp;
                compressorManifoldPressure = (compressorPAt0 + (1.0F - compressorPAt0) * w * _1_wMax) * pexternal * compressionCoeff;
                float need2ndThrottle = compressorRPMtoWMaxATA / compressorManifoldPressure;
                if(controlAfterburner && (afterburnerType != 8 && afterburnerType != 7 || controlCompressor != compressorMaxStep) && (afterburnerType != 1 || controlThrottle <= 1.0F || ((FlightModelMain) (reference)).M.nitro > 0.0F))
                {
                    need2ndThrottle *= afterburnerCompressorFactor;
                    compressorManifoldThreshold *= afterburnerCompressorFactor;
                }
                if(isHasControlBoost())
                {
                    float boostF = Aircraft.cvt(controlFAfterburner, 0.0F, 1.0F, 1.0F, afterburnerCompressorFactor);
                    need2ndThrottle *= boostF;
                    compressorManifoldThreshold *= boostF;
                }
                if(fastATA)
                    compressor2ndThrottle = need2ndThrottle;
                else
                    compressor2ndThrottle -= 3F * dt * (compressor2ndThrottle - need2ndThrottle);
                if(compressor2ndThrottle > 1.0F)
                    compressor2ndThrottle = 1.0F;
                compressorManifoldPressure *= compressor2ndThrottle;
                compressor1stThrottle = needManifold / compressorRPMtoWMaxATA;
                if(compressor1stThrottle > 1.0F)
                    compressor1stThrottle = 1.0F;
                compressorManifoldPressure *= compressor1stThrottle;
                f = compressorManifoldPressure / compressorManifoldThreshold;
                coolMult = f;
                f *= maxCompMultiplier;
            }
            if(w < 20F)
                compressorManifoldPressure = pexternal * (1.0F - w * 0.03F);
            if(mixerType == 1 && stage == 6)
                compressorManifoldPressure *= getMixMultiplier();
            return f;
        }

        case 2: // '\002'
        {
            float pexternal = pressureExtBar;
            if((!bHasCompressorControl || !reference.isPlayers() || !(reference instanceof RealFlightModel) || !((RealFlightModel)reference).isRealMode() || !World.cur().diffCur.ComplexEManagement || fastATA) && (reference.isTick(128, 0) || fastATA))
            {
                compressorStepFound = false;
                controlCompressor = 0;
            }
            float maxCompFactor = -1F;
            float maxCompMultiplier = -1F;
            int maxCompStep = -1;
            float f;
            if(fastATA)
            {
                float Jneed2ndThrottle0 = 0.0F;
                float JcompMultiplier0 = 0.0F;
                for(controlCompressor = 0; controlCompressor <= compressorMaxStep; controlCompressor++)
                {
                    compressorManifoldThreshold = needManifold;
                    float pcomp = compressorPressure[controlCompressor];
                    float compressionCoeff = compressorRPMtoWMaxATA / pcomp;
                    float compMultiplier = 1.0F;
                    float compFactor = 1.0F;
                    float groundMultiplier = 1.0F;
                    float dPcomp = 1.0F - pcomp;
                    float dPcur = 1.0F - pexternal;
                    if(pexternal > pcomp)
                    {
                        if(dPcomp < 0.0001F)
                            dPcomp = 0.0001F;
                        for(int i = 1; i <= controlCompressor; i++)
                            if(compressorAltMultipliers[controlCompressor] >= 1.0F)
                                groundMultiplier *= compressorBaseMultipliers[controlCompressor];
                            else
                                groundMultiplier *= compressorBaseMultipliers[controlCompressor] * compressorAltMultipliers[controlCompressor];

                        compMultiplier = groundMultiplier + (dPcur / dPcomp) * (compressorAltMultipliers[controlCompressor] - groundMultiplier);
                    } else
                    {
                        compMultiplier = compressorAltMultipliers[controlCompressor];
                    }
                    compressorManifoldPressure = (compressorPAt0 + (1.0F - compressorPAt0) * w * _1_wMax) * pexternal * compressionCoeff;
                    float need2ndThrottle = compressorRPMtoWMaxATA / compressorManifoldPressure;
                    if(controlAfterburner && (afterburnerType != 1 || controlThrottle <= 1.0F || ((FlightModelMain) (reference)).M.nitro > 0.0F))
                    {
                        need2ndThrottle *= afterburnerCompressorFactor;
                        compressorManifoldThreshold *= afterburnerCompressorFactor;
                    }
                    compressor2ndThrottle = need2ndThrottle;
                    if(compressor2ndThrottle > 1.0F)
                        compressor2ndThrottle = 1.0F;
                    compressorManifoldPressure *= compressor2ndThrottle;
                    if(controlCompressor == 0)
                    {
                        JcompMultiplier0 = compMultiplier;
                        Jneed2ndThrottle0 = compressor2ndThrottle;
                    }
                    compressor1stThrottle = needManifold / compressorRPMtoWMaxATA;
                    if(compressor1stThrottle > 1.0F)
                        compressor1stThrottle = 1.0F;
                    compressorManifoldPressure *= compressor1stThrottle;
                    compFactor = (compMultiplier * compressorManifoldPressure) / compressorManifoldThreshold;
                    if((float)controlCompressor == 1.0F && Jneed2ndThrottle0 == 1.0F && need2ndThrottle < 1.0F)
                    {
                        float Jcompressionratio = compressorPressure[1] / (compressorPressure[0] - compressorPressure[1]);
                        compFactor *= 1.0F + (JcompMultiplier0 / compMultiplier - 1.0F) * (Jneed2ndThrottle0 / need2ndThrottle - 1.0F) * Jcompressionratio;
                    }
                    if(compFactor > maxCompFactor)
                    {
                        maxCompFactor = compFactor;
                        maxCompStep = controlCompressor;
                    }
                }

                f = maxCompFactor;
                controlCompressor = maxCompStep;
            } else
            {
                float maxATA = needManifold;
                if(controlAfterburner)
                    maxATA *= afterburnerCompressorFactor;
                float groundMultiplier = 1.0F;
                float dPcur = 1.0F - pexternal;
                float pcomp0 = compressorPressure[0];
                float GearFull0 = (pexternal * (compressorPAt0 + (1.0F - compressorPAt0)) * w * _1_wMax * compressorRPMtoWMaxATA) / pcomp0 + 0.001F;
                float compMultiplier = 1.0F;
                float compFactor = 1.0F;
                float pcomp;
                if(GearFull0 < maxATA && compressorMaxStep == 1)
                {
                    controlCompressor = 1;
                    pcomp = compressorPressure[1];
                    float dPcomp = 1.0F - pcomp;
                    if(dPcomp < 0.0001F)
                        dPcomp = 0.0001F;
                    float GearFull1 = (pexternal * (compressorPAt0 + (1.0F - compressorPAt0)) * w * _1_wMax * compressorRPMtoWMaxATA) / pcomp + 0.001F;
                    if(GearFull1 > maxATA)
                    {
                        if(compressorAltMultipliers[1] >= 1.0F)
                            groundMultiplier *= compressorBaseMultipliers[1];
                        else
                            groundMultiplier *= compressorBaseMultipliers[1] * compressorAltMultipliers[1];
                        compMultiplier = groundMultiplier + (dPcur / dPcomp) * (compressorAltMultipliers[1] - groundMultiplier);
                        compMultiplier += ((compressorAltMultipliers[0] - compMultiplier) * (GearFull1 - 1.0F)) / ((pcomp0 * maxATA) / pcomp - 1.0F);
                        compFactor = compMultiplier;
                    } else
                    {
                        compMultiplier = compressorAltMultipliers[controlCompressor];
                        compFactor = (compMultiplier * pexternal * needManifold * (compressorPAt0 + (1.0F - compressorPAt0) * w * _1_wMax)) / (pcomp * maxATA);
                    }
                } else
                {
                    controlCompressor = 0;
                    float dPcomp = 1.0F - pcomp0;
                    if(dPcomp < 0.0001F)
                        dPcomp = 0.0001F;
                    compMultiplier = 1.0F + (dPcur / dPcomp) * (compressorAltMultipliers[0] - 1.0F);
                    compFactor = compMultiplier;
                }
                maxCompFactor = compFactor;
                maxCompMultiplier = compMultiplier;
                if(maxCompStep < 0)
                    maxCompStep = 0;
                pcomp = compressorPressure[controlCompressor];
                float compressionCoeff = compressorRPMtoWMaxATA / pcomp;
                compressorManifoldPressure = (compressorPAt0 + (1.0F - compressorPAt0) * w * _1_wMax) * pexternal * compressionCoeff;
                float need2ndThrottle = compressorRPMtoWMaxATA / compressorManifoldPressure;
                if(controlAfterburner && (afterburnerType != 1 || controlThrottle <= 1.0F || ((FlightModelMain) (reference)).M.nitro > 0.0F))
                {
                    need2ndThrottle *= afterburnerCompressorFactor;
                    compressorManifoldThreshold *= afterburnerCompressorFactor;
                }
                compressor2ndThrottle = need2ndThrottle;
                if(compressor2ndThrottle > 1.0F)
                    compressor2ndThrottle = 1.0F;
                compressorManifoldPressure *= compressor2ndThrottle;
                compressor1stThrottle = needManifold / compressorRPMtoWMaxATA;
                if(compressor1stThrottle > 1.0F)
                    compressor1stThrottle = 1.0F;
                compressorManifoldPressure *= compressor1stThrottle;
                f = compressorManifoldPressure / compressorManifoldThreshold;
                coolMult = f;
                f *= maxCompMultiplier;
            }
            if(w < 20F)
                compressorManifoldPressure = pexternal * (1.0F - w * 0.03F);
            return f;
        }

        case 3: // '\003'
        {
            float pexternal = pressureExtBar;
            controlCompressor = 0;
            float maxCompMultiplier = -1F;
            float pcomp = compressorPressure[controlCompressor];
            float compressionCoeff = compressorRPMtoWMaxATA / pcomp;
            float compMultiplier = 1.0F;
            float compFactor = 1.0F;
            if(pexternal > pcomp)
            {
                float dPcomp = 1.0F - pcomp;
                if(dPcomp < 0.0001F)
                    dPcomp = 0.0001F;
                float dPcur = 1.0F - pexternal;
                if(dPcur < 0.0F)
                    dPcur = 0.0F;
                float groundMultiplier = 1.0F;
                compMultiplier = groundMultiplier + (dPcur / dPcomp) * (compressorAltMultipliers[controlCompressor] - groundMultiplier);
            } else
            {
                compMultiplier = compressorAltMultipliers[controlCompressor];
            }
            maxCompMultiplier = compMultiplier;
            compressionCoeff = compressorRPMtoWMaxATA / pcomp;
            if(pexternal < pcomp)
                pexternal = 0.1F * pexternal + 0.9F * pcomp;
            float decCoeff = pexternal * compressionCoeff;
            compressorManifoldPressure = (compressorPAt0 + (1.0F - compressorPAt0) * w * _1_wMax) * decCoeff;
            float need2ndThrottle = compressorRPMtoWMaxATA / compressorManifoldPressure;
            if(fastATA)
                compressor2ndThrottle = need2ndThrottle;
            else
                compressor2ndThrottle -= 3F * dt * (compressor2ndThrottle - need2ndThrottle);
            if(compressor2ndThrottle > 1.0F)
                compressor2ndThrottle = 1.0F;
            compressorManifoldPressure *= compressor2ndThrottle;
            compressor1stThrottle = needManifold / compressorRPMtoWMaxATA;
            if(compressor1stThrottle > 1.0F)
                compressor1stThrottle = 1.0F;
            compressorManifoldPressure *= compressor1stThrottle;
            float f = compressorManifoldPressure / compressorManifoldThreshold;
            f *= maxCompMultiplier;
            if(w < 20F)
                compressorManifoldPressure = pexternal * (1.0F - w * 0.03F);
            return f;
        }
        }
        return 1.0F;
    }

    private float getMagnetoMultiplier()
    {
        switch(controlMagneto)
        {
        case 0: // '\0'
            return 0.0F;

        case 1: // '\001'
            return bMagnetos[0] ? 0.87F : 0.0F;

        case 2: // '\002'
            return bMagnetos[1] ? 0.87F : 0.0F;

        case 3: // '\003'
            float sum = 0.0F;
            sum += bMagnetos[0] ? 0.87F : 0.0F;
            sum += bMagnetos[1] ? 0.87F : 0.0F;
            if(sum > 1.0F)
                sum = 1.0F;
            return sum;
        }
        return 1.0F;
    }

    private float getMixMultiplier()
    {
        float amps = 0.0F;
        switch(mixerType)
        {
        case 0: // '\0' ///addded
            if(((FlightModelMain) (reference)).CT.PowerControl > 0.95F && ((FlightModelMain) (reference)).EI.engines[0].getRPM() > 2000F)
                ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 6);
            else
                ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 0);
            return 1.0F;

        case 1: // '\001'
            if(controlMix == 1.0F)
            {
                if(bFloodCarb)
                    ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 1);
                else
                    ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 0);
                return 1.0F;
            }
            // fall through

        case 2: // '\002'
        case 3: // '\003'
            float f;
            if(reference.isPlayers() && (reference instanceof RealFlightModel) && ((RealFlightModel)reference).isRealMode())
            {
                if(!World.cur().diffCur.ComplexEManagement)
                    return 1.0F;
                f = mixerLowPressureBar * controlMix;
                if(f < pressureExtBar - amps)
                {
                    if(f < 0.03F)
                        setEngineStops(((Interpolate) (reference)).actor);
                    if(bFloodCarb || mixerType == 3 && controlMix > 1.1F)
                        ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 1);
                    else
                        ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 0);
                    if(f > (pressureExtBar - amps) * 0.25F)
                    {
                        return 1.0F;
                    } else
                    {
                        float g = f / ((pressureExtBar - amps) * 0.25F);
                        return g;
                    }
                }
                if(f > pressureExtBar)
                    if(mixerType == 3 && controlMix <= 1.0F)
                    {
                        return 1.0F;
                    } else
                    {
                        producedDistabilisation += 0.0F + 35F * (1.0F - (pressureExtBar + amps) / (f + 0.0001F));
                        ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 1);
                        float g = (pressureExtBar + amps) / (f + 0.0001F);
                        return g;
                    }
                if(bFloodCarb)
                    ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 1);
                else
                    ((FlightModelMain) (reference)).AS.setSootState(((Interpolate) (reference)).actor, number, 0);
                return 1.0F;
            }
            f = mixerLowPressureBar * controlMix;
            if(f < pressureExtBar - amps && f < 0.03F)
                setEngineStops(((Interpolate) (reference)).actor);
            return 1.0F;

        default:
            return 1.0F;
        }
    }

    private float getStageMultiplier()
    {
        return stage != 6 ? 0.0F : 1.0F;
    }

    public void setFricCoeffT(float FC)
    {
        fricCoeffT = FC;
    }

    private float getFrictionMoment(float f)
    {
        float f1 = 0.0F;
        if(!bPropHit && (bIsInoperable || stage == 0 || controlMagneto == 0))
        {
            if((super.actor instanceof BF_109) || (super.actor instanceof BF_110) || (super.actor instanceof JU_87) || (super.actor instanceof JU_88) || (super.actor instanceof JU_88NEW) || (super.actor instanceof FW_190) && type == 0)
            {
                fricCoeffT += 0.09F * f;
                if(fricCoeffT > 0.25F)
                    fricCoeffT = 0.25F;
            } else
            if((super.actor instanceof P_51) || (super.actor instanceof P_47) || (super.actor instanceof P_38) || (super.actor instanceof P_39) || (super.actor instanceof P_40) || (super.actor instanceof P_40SUKAISVOLOCH) || (super.actor instanceof SPITFIRE) || (super.actor instanceof Hurricane) || (super.actor instanceof FW_190) && type == 1 || type == 1)
            {
                fricCoeffT += 0.08F * f;
                if(fricCoeffT > 0.2F)
                    fricCoeffT = 0.2F;
            } else
            if(type == 9)
            {
                fricCoeffT += 0.07F * f;
                if(fricCoeffT > 0.05F)
                    fricCoeffT = 0.05F;
            } else
            {
                fricCoeffT += 0.09F * f;
                if(fricCoeffT > 0.3F)
                    fricCoeffT = 0.3F;
            }
            float f2 = w * _1_wMax;
            f1 = (-fricCoeffT * (6F + 3.8F * f2) * (propI + engineI)) / f;
            float f3 = (-0.99F * w * (propI + engineI)) / f;
            if(f1 < f3)
                f1 = f3;
        } else
        if(bPropHit && (bIsInoperable || stage == 0 || controlMagneto == 0))
        {
            fricCoeffT += 0.2F * f;
            if(fricCoeffT > 2.0F)
                fricCoeffT = 2.0F;
            float f2 = w * _1_wMax;
            f1 = (-fricCoeffT * (6F + 3.8F * f2) * (propI + engineI)) / f;
            float f3 = (-0.99F * w * (propI + engineI)) / f;
            if(f1 < f3)
                f1 = f3;
        } else
        {
            fricCoeffT = 0.0F;
        }
        if(stage == 0 && w > wMaxAllowed)
            doSetEngineStuck();
        return f1;
    }

    private float getJetFrictionMoment(float dt)
    {
        float fricM = 0.0F;
        if(bIsInoperable || stage == 0)
            fricM = (-0.002F * w * (propI + engineI)) / dt;
        return fricM;
    }

    public Vector3f getEngineForce()
    {
        return engineForce;
    }

    public Vector3f getEngineTorque()
    {
        return engineTorque;
    }

    public Vector3d getEngineGyro()
    {
        tmpV3d1.cross(reference.getW(), propIW);
        return tmpV3d1;
    }

    public float getEngineMomentRatio()
    {
        return engineMoment / engineMomentMax;
    }

    public boolean isPropAngleDeviceOperational()
    {
        return bIsAngleDeviceOperational;
    }

    public float getCriticalW()
    {
        return wMaxAllowed;
    }

    public float getPropPhiMin()
    {
        return propPhiMin;
    }

    public float getPropPhiMax()
    {
        return propPhiMax;
    }

    public int getAfterburnerType()
    {
        return afterburnerType;
    }

    private float toRadianPerSecond(float omega)
    {
        return (omega * 3.141593F * 2.0F) / 60F;
    }

    private float toRPM(float omega)
    {
        return (omega * 60F) / 2.0F / 3.141593F;
    }

    private float getKforH(float v0, float vH, float h)
    {
        float kFH = (Atmosphere.density(h) * (vH * vH)) / (Atmosphere.density(0.0F) * (v0 * v0));
        if(type != 2)
            kFH = (kFH * kV(v0)) / kV(vH);
        return kFH;
    }

    private float kV(float V)
    {
        return 1.0F - 0.0032F * V;
    }

    public final void setAfterburnerType(int type)
    {
        afterburnerType = type;
    }

    public final void setPropReductorValue(float val)
    {
        propReductor = val;
    }

    public void replicateToNet(NetMsgGuaranted out)
        throws IOException
    {
        out.writeByte(controlMagneto | stage << 4);
        out.writeByte(cylinders);
        out.writeByte(cylindersOperable);
        out.writeByte((int)(255F * readyness));
        out.writeByte((int)(255F * ((propPhi - propPhiMin) / (propPhiMax - propPhiMin))));
        out.writeFloat(w);
    }

    public void replicateFromNet(NetMsgInput in)
        throws IOException
    {
        int i = in.readUnsignedByte();
        stage = (i & 0xf0) >> 4;
        controlMagneto = i & 0xf;
        cylinders = in.readUnsignedByte();
        cylindersOperable = in.readUnsignedByte();
        readyness = (float)in.readUnsignedByte() / 255F;
        propPhi = ((float)in.readUnsignedByte() / 255F) * (propPhiMax - propPhiMin) + propPhiMin;
        w = in.readFloat();
    }

    private static final boolean ___debug___ = false;
    public static final int _E_TYPE_INLINE = 0;
    public static final int _E_TYPE_RADIAL = 1;
    public static final int _E_TYPE_JET = 2;
    public static final int _E_TYPE_ROCKET = 3;
    public static final int _E_TYPE_ROCKETBOOST = 4;
    public static final int _E_TYPE_TOW = 5;
    public static final int _E_TYPE_PVRD = 6;
    public static final int _E_TYPE_HELO_INLINE = 7;
    public static final int _E_TYPE_UNIDENTIFIED = 8;
    public static final int _E_PROP_DIR_LEFT = 0;
    public static final int _E_PROP_DIR_RIGHT = 1;
    public static final int _E_STAGE_NULL = 0;
    public static final int _E_STAGE_WAKE_UP = 1;
    public static final int _E_STAGE_STARTER_ROLL = 2;
    public static final int _E_STAGE_CATCH_UP = 3;
    public static final int _E_STAGE_CATCH_ROLL = 4;
    public static final int _E_STAGE_CATCH_FIRE = 5;
    public static final int _E_STAGE_NOMINAL = 6;
    public static final int _E_STAGE_DEAD = 7;
    public static final int _E_STAGE_STUCK = 8;
    public static final int _E_PROP_FIXED = 0;
    public static final int _E_PROP_RETAIN_RPM_1 = 1;
    public static final int _E_PROP_RETAIN_RPM_2 = 2;
    public static final int _E_PROP_RETAIN_AOA_1 = 3;
    public static final int _E_PROP_RETAIN_AOA_2 = 4;
    public static final int _E_PROP_FRICTION = 5;
    public static final int _E_PROP_MANUALDRIVEN = 6;
    public static final int _E_PROP_WM_KOMANDGERAT = 7;
    public static final int _E_PROP_FW_KOMANDGERAT = 8;
    public static final int _E_PROP_CSP_EL = 9;
    public static final int _E_PROP_RETAIN_RPM_11 = 11;
    public static final int _E_PROP_RETAIN_RPM_12 = 12;
    public static final int _E_CARB_SUCTION = 0;
    public static final int _E_CARB_CARBURETOR = 1;
    public static final int _E_CARB_INJECTOR = 2;
    public static final int _E_CARB_FLOAT = 3;
    public static final int _E_CARB_SHILLING = 4;
    public static final int _E_COMPRESSOR_NONE = 0;
    public static final int _E_COMPRESSOR_MANUALSTEP = 1;
    public static final int _E_COMPRESSOR_WM_KOMANDGERAT = 2;
    public static final int _E_COMPRESSOR_TURBO = 3;
    public static final int _E_MIXER_GENERIC = 0;
    public static final int _E_MIXER_BRIT_FULLAUTO = 1;
    public static final int _E_MIXER_LIMITED_PRESSURE = 2;
    public static final int _E_MIXER_FOUR_STAGE = 3;
    public static final int _E_AFTERBURNER_GENERIC = 0;
    public static final int _E_AFTERBURNER_MW50 = 1;
    public static final int _E_AFTERBURNER_GM1 = 2;
    public static final int _E_AFTERBURNER_FIRECHAMBER = 3;
    public static final int _E_AFTERBURNER_WATER = 4;
    public static final int _E_AFTERBURNER_NO2 = 5;
    public static final int _E_AFTERBURNER_FUEL_INJECTION = 6;
    public static final int _E_AFTERBURNER_FUEL_ILA5 = 7;
    public static final int _E_AFTERBURNER_FUEL_ILA5AUTO = 8;
    public static final int _E_AFTERBURNER_WATERMETHANOL = 9;
    public static final int _E_AFTERBURNER_P51 = 10;
    public static final int _E_AFTERBURNER_SPIT = 11;
    public static final int _E_AFTERBURNER_MANUALBOOST = 12;
    private static int heatStringID = -1;
    public static final int _E_RADIATOR_ALGORITM_DEFAULT = 0;
    public static final int _E_RADIATOR_ALGORITM_1 = 1;
    public static final int _E_RADIATOR_ALGORITM_2 = 2;
    public static final int _E_RADIATOR_ALGORITM_3 = 3;
    public FmSounds isnd;
    private FlightModel reference;
    private static boolean bTFirst;
    public String soundName;
    public String startStopName;
    public String propName;
    public String emdName;
    public String emdSubName;
    private int number;
    private int type;
    private int cylinders;
    private float engineMass;
    private float wMin;
    private float wNom;
    public float wMax;
    private float wWEP;
    private float wMaxAllowed;
    public int wNetPrev;
    public float engineMoment;
    private float engineMomentMax;
    private float engineBoostFactor;
    private float engineAfterburnerBoostFactor;
    private float engineDistAM;
    private float engineDistBM;
    private float engineDistCM;
    private float producedDistabilisation;
    private boolean bRan;
    private Point3f enginePos;
    private Vector3f engineVector;
    private Vector3f engineForce;
    private Vector3f engineTorque;
    private float engineDamageAccum;
    private float _1_wMaxAllowed;
    private float _1_wMax;
    private float RPMMin;
    private float RPMNom;
    public float RPMMax;
    private float Vopt;
    private float pressureExtBar;
    private double momForFuel;
    public double addVflow;
    public double addVside;
    private Point3f propPos;
    private float propReductor;
    private float ApropReductor;
    private float PropMomentScale;
    private float ReactiveMomentScale;
    private float VsideScale;
    private int propAngleDeviceType;
    private float propAngleDeviceMinParam;
    private float propAngleDeviceMaxParam;
    private float propAngleDeviceAfterburnerParam;
    private int propDirection;
    private float propDiameter;
    private float propMass;
    private float propI;
    public Vector3d propIW;
    private float propSEquivalent;
    private float propr;
    private float propPhiMin;
    private float propPhiMax;
    private float propPhi;
    private float propPhiW;
    private float propAoA;
    private float propAoA0;
    private float propAoACrit;
    private float propAngleChangeSpeed;
    private float propForce;
    public float propMoment;
    private float propTarget;
    private int mixerType;
    private float mixerLowPressureBar;
    private float horsePowers;
    public float thrustMax;
    private int cylindersOperable;
    private float engineI;
    private float engineAcceleration;
    private boolean bMagnetos[] = {
        true, true
    };
    private boolean bIsAutonomous;
    private boolean bIsMaster;
    private boolean bIsStuck;
    private boolean bIsInoperable;
    private boolean bIsAngleDeviceOperational;
    private boolean isPropAngleDeviceHydroOperable;
    private int engineCarburetorType;
    private float FuelConsumptionP0;
    private float FuelConsumptionP05;
    private float FuelConsumptionP1;
    private float FuelConsumptionPMAX;
    private float FuelRocketCoeff;
    private float fuelConsumption0M;
    private float fuelConsumption1M;
    private int RadiatorAlgoritm;
    private int compressorType;
    public int compressorMaxStep;
    private float compressorPMax;
    private float compressorManifoldPressure;
    public float compressorAltitudes[];
    private float compressorPressure[];
    private float compressorAltMultipliers[];
    private float compressorBaseMultipliers[];
    private float compressorRPMtoP0;
    private float compressorRPMtoCurvature;
    private float compressorRPMtoPMax;
    public float compressorRPMtoWMaxATA;
    private float compressorSpeedManifold;
    private float compressorRPM[];
    private float compressorATA[];
    private int nOfCompPoints;
    private boolean compressorStepFound;
    private float compressorManifoldThreshold;
    private float afterburnerCompressorFactor;
    private float _1_P0;
    private float compressor1stThrottle;
    private float compressor2ndThrottle;
    private float compressorPAt0;
    private int afterburnerType;
    private boolean afterburnerChangeW;
    private float afterburnerMaxAltitude;
    private int stage;
    private int oldStage;
    private long timer;
    private long given;
    private float rpm;
    public float w;
    private float aw;
    private float oldW;
    private float readyness;
    private float oldReadyness;
    private float radiatorReadyness;
    private float rearRush;
    public float tOilIn;
    public float tOilOut;
    public float tWaterOut;
    public float tCylinders;
    private float tWaterCritMin;
    public float tWaterCritMax;
    private float tOilCritMin;
    public float tOilCritMax;
    private float tWaterMaxRPM;
    public float tOilOutMaxRPM;
    private float tOilInMaxRPM;
    private float tChangeSpeed;
    private float timeOverheat;
    private float timeUnderheat;
    private float timeCounter;
    private boolean bHasThrottleControl;
    private boolean bHasAfterburnerControl;
    private boolean bHasPropControl;
    private boolean bHasRadiatorControl;
    private boolean bHasMixControl;
    private boolean bHasMagnetoControl;
    private boolean bHasExtinguisherControl;
    private boolean bHasCompressorControl;
    private boolean bHasFeatherControl;
    private int extinguishers;
    private float controlThrottle;
    public float controlRadiator;
    private boolean controlAfterburner;
    private float controlFAfterburner;
    private float controlProp;
    private boolean bControlPropAuto;
    private float controlMix;
    private int controlMagneto;
    private int controlCompressor;
    private int controlFeather;
    public float copControlThrottle;
    public float copControlProp;
    public float copControlMix;
    public float copControlBoost;
    public int copControlSupercharger;
    public float copControlRadiator;
    public double zatizeni;
    public float coolMult;
    private int controlPropDirection;
    private float neg_G_Counter;
    private boolean bFullT;
    private boolean bFloodCarb;
    private boolean bWepRpmInLowGear;
    public static final int _S_TYPE_INERTIA = 0;
    public static final int _S_TYPE_MANUAL = 1;
    public static final int _S_TYPE_ELECTRIC = 2;
    public static final int _S_TYPE_CARTRIDGE = 3;
    public static final int _S_TYPE_PNEUMATIC = 4;
    public static final int _S_TYPE_BOSCH = 5;
    public static final int _E_TYPE_ROTARY = 9;
    public static final int _E_TYPE_TURBOPROP = 10;
    private static String starterTypes[] = {
        "Inertia", "Manual", "Electric", "Cartridge", "Pneumatic", "Bosch"
    };
    private int starter;
    public boolean bPropHit;
    public AircraftLH aircraft;
    public boolean fastATA;
    private Vector3f old_engineForce;
    private Vector3f old_engineTorque;
    private float updateStep;
    private float updateLast;
    public float relP;
    public float maxMoment;
    public float maxW;
    private float fricCoeffT;
    private static Vector3f tmpV3f = new Vector3f();
    private static Vector3d tmpV3d1 = new Vector3d();
    private static Vector3d tmpV3d2 = new Vector3d();
    private static Point3f safeloc = new Point3f();
    private static Point3d safeLoc = new Point3d();
    private static Vector3f safeVwld = new Vector3f();
    private static Vector3f safeVflow = new Vector3f();
    private static boolean tmpB;
    public static float tmpF;
    private int engineNoFuelHUDLogId;

}