# -*- coding: cp1251 -*-
import re, string, os, datetime, mx, math, kinterbasdb, shutil
from threading import Thread, Timer
from ini import IniFile
from gameevents import *
from commandHandle import *
from telnetCommunicator import *
from dbconn import KinderbasFacade

if __name__== "__main__":
    from daemonLogger import LogFactory
    logger = LogFactory.getLogger()
    
    conn_param = IniFile('PowerFBDaemon.ini')

    rest_pilots=[]
    lang_pilots={}
    factor_ft = {'wagon':2, 'aaa':3,'tank':10, 'art':6, 'car':2, 'ship':30,'sair':2,'other':1}
    
    translate = IniFile('Messages.ini')
    lost_before={}

        
# Interfaces    
class Scorable:
    def score(self, theScored, thePosition):
        raise NotImplementedError(self.score)

class Damageable:
    def getType(self):
        raise NotImplementedError(self.getType)
    def getTeam(self):
        raise NotImplementedError(self.getTeam)
    def damage(self, theDamager, thePosition):
        raise NotImplementedError(self.damage)
    def destroy(self, theDestroyer, thePosition):
        raise NotImplementedError(self.destroy)

class PilotManager:
    def connect(self, theWho):
        raise NotImplementedError(self.connect)
        
    def getActivePilots(self):
        raise NotImplementedError(self.getActivePilots)
        
    def findPilot(self, theName):
        raise NotImplementedError(self.findPilot)
    
    def updatePilotInfos(self):
        raise NotImplementedError(self.updatePilotInfos)
    
    def disconnectAll(self):
        raise NotImplementedError(self.disconnectAll)
    
# Implementations
class Type:
    def __init__(self, theName):
        self.__name = theName
    def getName(self):
        return self.__name
    def __ne__(self, other):
        return not(self.__eq__(other))
    def __eq__(self, other):
        return self.__cmp__(other)
    def __cmp__(self, other):
        if not isinstance(other, Type):
            return False
        if not self.__name == other.__name:
            return False
        return True
    def __hash__(self):
        hashCode = hash(self.__name)
        return hashCode
    
class Rank:
    def __init__(self, theRankID, theRankName):
        self.__id = theRankID
        self.__name = theRankName
        
    def getID(self):
        return self.__id
        
    def getName(self):
        return self.__name

class Team:
    def __init__(self, theID, theName):
        self.__id = theID
        self.__name = theName
        
    def getID(self):
        return self.__id
        
    def getName(self):
        return self.__name
    def __ne__(self, other):
        return not(self.__eq__(other))
    def __eq__(self, other):
        return self.__cmp__(other)
    def __cmp__(self, other):
        if not isinstance(other, Team):
            return False
        if not self.__name == other.__name:
            return False
        if not self.__id == other.__id:
            return False
        return True
    def __hash__(self):
        hashCode = hash(self.__name) + self.__id
        return hashCode

class TeamManager:
    def __init__(self):
        self.__teams = []
        
    def addTeam(self, theTeam):
        self.__teams.append(theTeam)
        
    def removeTeam(self, theTeam):
        if self.__teams.count(theTeam):
            self.__teams.remove(theTeam)
        
    def listTeams(self):
        return self.__teams
    
    def findTeamByID(self, theID):
        res = filter(lambda x: x.getID() == theID, self.__teams)
        if len(res) > 1:
            logger.error('There is two teams with same ID!')
        if len(res) == 1:
            return res[0]
            
    def findTeamByName(self, theName):
        res = filter(lambda x: x.getName() == theName, self.__teams)
        if len(res) > 1:
            logger.error('There is two teams with same name!')
        if len(res) == 1:
            return res[0]

# Heavily modified by Solar
class ActionLogger:
    def __init__(self, theMissionID, theDaemonDBFacade, theRatioProviderF):
        self.__missionID = theMissionID
        self.__dbFacade = theDaemonDBFacade
        self.__ratioProviderF = theRatioProviderF
        
    def log(self, theWhoCaused, theWho, theAction):
        if isinstance(theWhoCaused, Static) and isinstance(theWho, Static):
            raise Exception('Cannot log action with two statics involved in action')
        if not theWhoCaused:
            raise Exception('Cannot log action with unknown actor')
        times = int(time.time())
        action = theAction
        obj = None
        amount = None
        no_parse = 0
        killed_static = 0
        
        plane = pilot = pilotID = army = sortieID = planeType = None
        objPlane = objPilot = objPilotID = objArmy = objSortieID = objPlaneType = None
        
        if isinstance(theWhoCaused, Pilot):
            pilot = theWhoCaused
            plane = pilot.getPlane()
            if (theWhoCaused.getTeam() is None):
                logger.debug('CL1: Do not log events with newbie name=%s' % pilot.getName())
                no_parse = 1
                return                
        elif isinstance(theWhoCaused, Plane):
            pilot = theWhoCaused.getPilot()
            plane = theWhoCaused
            if (theWhoCaused.getTeam() is None):
                logger.debug('CL2: Do not log events with newbie name=%s' % pilot.getName())
                no_parse = 1
                return                            
        elif isinstance(theWhoCaused, Static):
            obj = theWhoCaused.getType().getName()
            
        if pilot:
            pilotID = pilot.getID()
            army = pilot.getTeam().getName() # Brrr
        
        if plane:
            sortieID = plane.getSortieID()
            planeType = plane.getPlaneName()

        if isinstance(theWho, Pilot):
            objPilot = theWho
            objPlane = objPilot.getPlane()
            if (theWho.getTeam() is None):
                logger.debug('CL3: Do not log events with newbie name=%s' % objPilot.getName())
                no_parse = 1
                return                            
        elif isinstance(theWho, Plane):
            objPilot = theWho.getPilot()
            objPlane = theWho
            if (theWho.getTeam() is None):
                logger.debug('CL4: Do not log events with newbie name=%s' % objPilot.getName())
                no_parse = 1
                return                            
        elif isinstance(theWho, Static):
            obj = theWho.getType().getName()
            if theWho.getTeam() == theWhoCaused.getTeam(): # Rename to match old daemon's stupid naming
                obj = 'f' + obj
            else:
                obj = 'e' + obj
            amount = 1
            no_parse = 1
            killed_static = 1
            
        if objPilot:
            objPilotID = objPilot.getID()
            objArmy = objPilot.getTeam().getName() # Brrr
        
        if objPlane:
            objSortieID = objPlane.getSortieID()
            objPlaneType = objPlane.getPlaneName()
        '''    
        print (self.__missionID, times, sortieID, pilotID, army, planeType, \
            action, obj, amount, objSortieID, objPilotID, objArmy, \
            objPlaneType, ratio)
        '''
        if not (no_parse):
            ratio = self.__ratioProviderF(theWhoCaused.getTeam())
            self.__dbFacade.logAction(self.__missionID, times, sortieID, pilotID, army, planeType, \
                action, obj, amount, objSortieID, objPilotID, objArmy, \
                objPlaneType, ratio)
            
        if killed_static:
            ratio = self.__ratioProviderF(theWhoCaused.getTeam())
            static_id = theWho.getID()
            static_name = int(static_id.split('_')[0])
            self.__dbFacade.logAction2(self.__missionID, times, sortieID, pilotID, army, planeType, \
                action, obj, amount, objSortieID, objPilotID, objArmy, \
                objPlaneType, ratio, static_name)            

    def logTwoStaticsAction(self, theStatic1, theStatic2, thePosition):
        times = int(time.time())
        unit = theStatic1.getType().getName()
        army = theStatic1.getTeam().getName()
        objunit = theStatic2.getType().getName()
        objarmy = theStatic2.getTeam().getName()
            
        self.__dbFacade.logTwoStaticsAction(self.__missionID, thePosition, unit, army, objunit, objarmy, 1, times)
    
    
class DaemonDBFacade:
    def __init__(self, theSimpleDBFacade):
        self.__simpleDBFacade = theSimpleDBFacade
        
    def logAction(self, theMISID, theTIMES, theSORTIEID, thePILOTID, theARMY, thePLANE, theACTIONS, \
                  theOBJECT, theOBJAMOUNT, theOBJSORTID, theOBJPILOTID, theOBJARMY, theOBJPLANE, theRATIO):
        self.__simpleDBFacade.executeUpdate(\
            "insert into log_action(MISID, TIMES, SORTIEID, PILOTID, ARMY, PLANE, ACTIONS, \
                OBJECT, OBJAMOUNT, OBJSORTID, OBJPILOTID, OBJARMY, OBJPLANE, RATIO) \
                values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", \
                (theMISID, theTIMES, theSORTIEID, thePILOTID, theARMY, thePLANE, theACTIONS, \
                theOBJECT, theOBJAMOUNT, theOBJSORTID, theOBJPILOTID, theOBJARMY, theOBJPLANE, theRATIO))

    # ADDED by Solar
    def logAction2(self, theMISID, theTIMES, theSORTIEID, thePILOTID, theARMY, thePLANE, theACTIONS, \
                  theOBJECT, theOBJAMOUNT, theOBJSORTID, theOBJPILOTID, theOBJARMY, theOBJPLANE, theRATIO, theStaticNumber):
        self.__simpleDBFacade.executeUpdate(\
            "insert into log_action(MISID, TIMES, SORTIEID, PILOTID, ARMY, PLANE, ACTIONS, \
                OBJECT, OBJAMOUNT, OBJSORTID, OBJPILOTID, OBJARMY, OBJPLANE, RATIO, NOMER) \
                values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", \
                (theMISID, theTIMES, theSORTIEID, thePILOTID, theARMY, thePLANE, theACTIONS, \
                theOBJECT, theOBJAMOUNT, theOBJSORTID, theOBJPILOTID, theOBJARMY, theOBJPLANE, theRATIO, theStaticNumber))
        
    def logTwoStaticsAction(self, theMissionID, thePosition, theUnit, theArmy, theObjUnit, theObjArmy, theAmount, theTimes):
        self.__simpleDBFacade.executeUpdate(\
            "insert into two_static_log_action(MISID, XY, UNIT, ARMY, OBJUNIT, OBJARMY, AMOUNT, TIMES) values (?,?,?,?,?,?,?,?)",\
                (theMissionID, thePosition, theUnit, theArmy, theObjUnit, theObjArmy, theAmount, theTimes))

    def logReport(self, theMissionID, theTargetName, theArmy, theState):
        self.__simpleDBFacade.executeUpdate2(\
            "execute procedure ins_mis_target(?,?,?,?)", \
            (theMissionID, theTargetName, theArmy, theState))
                
    def getPilotProfile(self, thePilotName):
        res = self.__simpleDBFacade.executeQuery(\
            "select id_players.PILOTID, rang.ID, rang.LITTLE, id_players.PILOTPASS, id_players.ARMY \
            from id_players, rang \
            where id_players.RANG=rang.NAME and id_players.PILOTNAME=?" , (thePilotName,))
        if len(res) > 0:
            return res[0]

    def addActivePilot(self, thePilotID, theArmyID):
        self.__simpleDBFacade.executeUpdate("insert into active_players(PILOTID, ARMY) values (?, ?)", (thePilotID, theArmyID))
        
    def checkActivePilot(self, thePilotID):
        res = self.__simpleDBFacade.executeQuery("select PILOTID from active_players where PILOTID=?" , thePilotID)
        return len(res)
        
    def removeActivePilot(self, thePilotID):
        self.__simpleDBFacade.executeUpdate("delete from active_players where PILOTID=?", (thePilotID,))
        
    def removeAllActivePilots(self):
        self.__simpleDBFacade.executeUpdate("delete from active_players")
        
    def updateActivePilot(self, thePilotID, theArmyID):
        self.__simpleDBFacade.executeUpdate("update active_players set ARMY=? WHERE PILOTID=?", (theArmyID, thePilotID))
        
    def startMission(self, theMissionName, theMISID, theMIS_NAME, thePARAM_R, thePARAM_B):
        query = "insert into mission (MISID, FILE_NAME, START_TIME, MIS_NAME, PARAM_R, PARAM_B) values(?, ?, ?, ?, ?, ?)"
        self.__simpleDBFacade.executeUpdate(query, (theMISID, theMissionName, self.__currTime(), theMIS_NAME, thePARAM_R, thePARAM_B))
    '''
    def endMission(self, theMisID, theLooser):
        query = "update mission set END_TIME=?, LOOSER=? where MISID=?"
        self.__simpleDBFacade.executeUpdate(query, (self.__currTime(), theLooser, theMisID))
    '''
    def endMission(self, theMisID, theLooser):
        query = "update mission set END_TIME=?, WINNER=? where MISID=?"
        if theLooser is None:
            winner = 'None'
        elif theLooser == 'Red':
            winner = 'Blue'
        else:
            winner = 'Red'
        self.__simpleDBFacade.executeUpdate(query, (self.__currTime(), winner, theMisID))
        
    def __currTime(self):
        return mx.DateTime.now()

class StatisticsCollector:
    def __init__(self, theConfig, theAllObjOfTypeDestroyedCallbackF, theConsole):
        self.__lossedObjects = None
        self.__tempLossedObjects = None # Added by Solar
        self.__losses = None
        self.__tempLosses = None # Added by Solar
        self.__totals = None
        self.__teamManager = None
        self.__console = theConsole
        self.__destrCallback = theAllObjOfTypeDestroyedCallbackF
        # New generator object types by Solar
        self.__missionRedTargetTypes = ['abRed','faRed','ftRed','mtRed','rtRed','stRed']
        self.__missionBlueTargetTypes = ['abBlue','faBlue','ftBlue','mtBlue','rtBlue','stBlue']
        self.__redTargetTotals = None
        self.__blueTargetTotals = None
        self.__redTargetLosses = None
        self.__blueTargetLosses = None
        self.__loadConfig(theConfig)
        
        self.__collectedCacheC = Condition()
        self.__collectedCache = []
        self.__cacheEmptyTimer = None
        
        
    def getTeamManager(self):
        return self.__teamManager
        
    def collectLoss(self, theDamageable):
        team = theDamageable.getTeam()
        if team is None:
            logger.warning('Team of object (%s) is unknown!' % type.getName())
            return
        
        type = theDamageable.getType()
            
        self.__collectedCacheC.acquire()
        self.__collectedCache.append(theDamageable)
        self.__collectedCacheC.release()
        if (self.__cacheEmptyTimer is None) or not self.__cacheEmptyTimer.isAlive():
            self.__cacheEmptyTimer =  Timer(5, self.__collectCached)
            self.__cacheEmptyTimer.start()
        
        self.__lossedObjects[team].append(theDamageable)    
        
        logger.debug('\'%s\' team loose a %s' % (team.getName(), type.getName()))
        ## Added by Solar = Filling new dictionaries
        if isinstance(theDamageable, Static):
            obj_code = theDamageable.getCode()            
            if (team.getName() == 'Red'):
                if self.__redTargetLosses.has_key(obj_code):
                    if self.__redTargetLosses[obj_code].has_key(type.getName()):
                        self.__redTargetLosses[obj_code][type.getName()] += 1
                        logger.debug('Incrementing loss for the Red team + 1 %s' % type.getName())
                    else:
                        logger.warning('There is no such a loss type in the red %s dictionary = %s' % (obj_code, type.getName()))
                else:
                    logger.warning('There is no such a obj_code = %s' % obj_code)
            if (team.getName() == 'Blue'):
                if self.__blueTargetLosses.has_key(obj_code):
                    if self.__blueTargetLosses[obj_code].has_key(type.getName()):
                        self.__blueTargetLosses[obj_code][type.getName()] += 1
                        logger.debug('Incrementing loss for the Blue team + 1 %s' % type.getName())
                    else:
                        logger.warning('There is no such a loss type in the blue %s dictionary = %s' % (obj_code, type.getName()))
                else:
                    logger.warning('There is no such a obj_code = %s' % obj_code)
            
    def collectTempLoss(self, theDamageable): #added by Solar
        team = theDamageable.getTeam()
        if team is None:
            logger.warning('Team of object (%s) is unknown!' % type.getName())
            return
        type = theDamageable.getType()
        self.__tempLossedObjects[team].append(theDamageable)
        logger.debug('\'%s\' team temporarily loose a %s' % (team.getName(), type.getName()))
        self.__tempLossType(team,type)

        
    def __collectCached(self):
        self.__collectedCacheC.acquire()
        teams = dict(map(lambda x: (x.getTeam(), 1), self.__collectedCache)).keys() # Create unique list of teams
        for team in teams:
            teamLosses = filter(lambda x: x.getTeam() == team, self.__collectedCache)
            processedTypes = []
            types = map(lambda x: x.getType(), teamLosses)
            for type in types:
                if not processedTypes.count(type):
                    processedTypes.append(type)
                    self.__lossType(team, type, len(filter(lambda x: x.getType() == type, teamLosses)))
        # by SOLAR: we need warning messages here
        for team in teams:
            teamname = team.getName()
            teamStaticLosses = filter(lambda x: (x.getTeam() == team) and (isinstance(x, Static)), self.__collectedCache)
            processedSquares = []
            squares = map(lambda x: x.getDestrCoords(), teamStaticLosses)
            for square in squares:
                if not processedSquares.count(square):
                    processedSquares.append(square)
                    self.__console.writeMessage('under_attack', (teamname, square), teamname)
        self.__collectedCache = []
        self.__collectedCacheC.release()
        
    def __lossType(self, theTeam, theType, theAmount = 1):
        if self.__losses.has_key(theTeam):
            if self.__losses[theTeam].has_key(theType):
                self.__losses[theTeam][theType] += theAmount
                if self.__totals[theTeam].has_key(theType):
                    typeLoss = self.__losses[theTeam][theType]
                    if self.__tempLosses[theTeam].has_key(theType):
                        typeLoss += self.__tempLosses[theTeam][theType]
                    typeTotals = self.__totals[theTeam][theType]
                    if  typeLoss >= typeTotals:
                        logger.info('Team %s lost all objects of type %s' % (theTeam.getName(), theType.getName()))
                        self.__destrCallback(theTeam, theType)
                    else:
                        self.__console.writeMessage('team_lost', (theTeam.getName(), theAmount, theType.getName(), (typeTotals - typeLoss), typeTotals), None)
            else:
                logger.warning('Looses dictionary does not contains key for object type = \'%s\' of theTeam %s' % (theType.getName(), theTeam.getName()))
        else:
            logger.warning('Looses dictionary does not contains key for %s theTeam' % theTeam.getName())

    def __tempLossType(self, theTeam, theType, theAmount = 1): #added by Solar
        if self.__tempLosses.has_key(theTeam):
            if self.__tempLosses[theTeam].has_key(theType):
                self.__tempLosses[theTeam][theType] += theAmount
                if self.__totals[theTeam].has_key(theType):
                    typeLoss = self.__tempLosses[theTeam][theType]
                    if self.__losses[theTeam].has_key(theType):
                        typeLoss += self.__losses[theTeam][theType]
                    typeTotals = self.__totals[theTeam][theType]
                    if  typeLoss >= typeTotals:
                        logger.info('Team %s lost all objects of type %s' % (theTeam.getName(), theType.getName()))
                        self.__destrCallback(theTeam, theType)
                    else:
                        self.__console.writeMessage('team_temporarily_lost', (theTeam.getName(), theAmount, theType.getName(), (typeTotals - typeLoss), typeTotals), None)
            else:
                logger.warning('Looses dictionary does not contains key for object type = \'%s\' of theTeam %s' % (theType.getName(), theTeam.getName()))
        else:
            logger.warning('Looses dictionary does not contains key for %s theTeam' % theTeam.getName())
        
    def getTotals(self, theTeam):
        if self.__totals.has_key(theTeam):
            return self.__totals[theTeam]
        
    def getLosses(self, theTeam):
        if self.__losses.has_key(theTeam):
            return self.__losses[theTeam]

    def getTempLosses(self, theTeam):
        if self.__tempLosses.has_key(theTeam):
            return self.__tempLosses[theTeam]
        
    def getLossedObjects(self, theTeam):
        if self.__lossedObjects.has_key(theTeam):
            return self.__lossedObjects[theTeam]

    def getRedTargetLosses(self):
        return self.__redTargetLosses
    
    def getRedTargetTotals(self):
        return self.__redTargetTotals
    
    def getBlueTargetLosses(self):
        return self.__blueTargetLosses
    
    def getBlueTargetTotals(self):
        return self.__blueTargetTotals
        
    def __loadConfig(self, theConfig):
        self.__totals = {}
        self.__losses = {}
        self.__lossedObjects = {}
        self.__tempLosses = {}
        self.__tempLossedObjects = {}
        self.__redTargetTotals = {}
        self.__blueTargetTotals = {}
        self.__redTargetLosses = {}
        self.__blueTargetLosses = {}
        teamManager = TeamManager()
        teams = filter(None, theConfig['MAIN']['teams'].split(',')) # Fetch all teams in the mission
        for teamName in teams:
            if theConfig[teamName].has_key('id'):
                teamID = int(theConfig[teamName]['id'].strip())       # Get Team ID
                team = Team(teamID, teamName)
                lost_before[teamName]=int(theConfig[teamName]['lost_before'])
                if theConfig[teamName].has_key('targets'):
                    targetsSect = theConfig[teamName]['targets']      # Get name of target section for this team
                    if targetsSect and theConfig.has_key(targetsSect):
                        teamManager.addTeam(team)
                        targetsSect = theConfig[targetsSect]      # Get dictionary of these targets
                        self.__lossedObjects[team] = []
                        self.__tempLossedObjects[team] = []
                        self.__losses[team] = {}                # Init looses section for this team
                        self.__tempLosses[team] = {}
                        self.__totals[team] = {}                # Init totals section for this team
                        for targetType in targetsSect.keys():
                            total = int(targetsSect[targetType])
                            if total > 0:
                                self.__losses[team][Type(targetType)] = 0 # Init place for this type of target
                                self.__tempLosses[team][Type(targetType)] = 0 #AAAArghhh! -Solar
                                self.__totals[team][Type(targetType)] = total # Store totals
                    else:
                        logger.warning('Targets section ''%s'' was not found' % targetsSect)
                else:
                    logger.warning('No targets specified for team ''%s'' with id=%s' % (teamName, teamID))
            else:
                logger.warning('Team id was not specified for Team ''%s''' % Team)
        self.__teamManager = teamManager
        logger.debug('Loading new gen.ini with different target types:')
        #Processing RED targets
        for newTargetType in self.__missionRedTargetTypes:
            logger.debug('Processing: [%s] section' % newTargetType)
            if theConfig.has_key(newTargetType):
                typeSect = theConfig[newTargetType]
                self.__redTargetTotals[newTargetType] = {}
                self.__redTargetLosses[newTargetType] = {}
                for targetType in typeSect.keys():
                    targetcount = int(typeSect[targetType])
                    self.__redTargetTotals[newTargetType][targetType] = targetcount
                    self.__redTargetLosses[newTargetType][targetType] = 0
                    logger.debug('Amount of %s = %s' % (targetType, targetcount))
            else:
                logger.debug('Section is absent')
        #Processing BLUE targets                
        for newTargetType in self.__missionBlueTargetTypes:
            logger.debug('Processing: [%s] section' % newTargetType)
            if theConfig.has_key(newTargetType):
                typeSect = theConfig[newTargetType]
                self.__blueTargetTotals[newTargetType] = {}
                self.__blueTargetLosses[newTargetType] = {}
                for targetType in typeSect.keys():
                    targetcount = int(typeSect[targetType])
                    self.__blueTargetTotals[newTargetType][targetType] = targetcount
                    self.__blueTargetLosses[newTargetType][targetType] = 0                    
                    logger.debug('Amount of %s = %s' % (targetType, targetcount))
            else:
                logger.debug('Section is absent')                

class MyTimer(Thread):
    def __init__(self, theConsole, theMisController, report_period, interval, function, args = (), kwargs = {}):
        self.__timer = Timer(interval, function, args, kwargs)
        self.__interval = interval
        self.__console = theConsole
        self.__consoleMsgTimer = None
        self.__reportMsgTimer = None
        self.__period = report_period
        self.__misController = theMisController
        self.__when = None
        Thread.__init__(self)
        
    def run(self):
        now = datetime.datetime.now()
        self.__when = now + datetime.timedelta(seconds=self.__interval)
        self.__timer.start()
        def sendConsoleMessage():
            if not self.__timer.isAlive():
                self.cancel()
            left = self.left()
            if left:
                self.__console.writeMessage('time_left', str(left).split('.')[0], None)
            self.__consoleMsgTimer = Timer(300, sendConsoleMessage)
            self.__consoleMsgTimer.start()
        def sendConsoleReport():
            if not self.__timer.isAlive():
                self.cancel()
            left = self.left()
            if left:
                self.__misController.reportLosses()
            self.__reportMsgTimer = Timer(self.__period, sendConsoleReport)
            self.__reportMsgTimer.start()
        sendConsoleMessage()
        sendConsoleReport()
        while(self.__timer.isAlive()):
            time.sleep(0.1)
        
    def cancel(self):
        self.__consoleMsgTimer.cancel()
        self.__reportMsgTimer.cancel()
        self.__timer.cancel()
        self.__when = None
        
    def left(self):
        if self.__when:
            now = datetime.datetime.now()
            return self.__when - now

class MissionController:
    def __init__(self, theConfig, theConsole, theDaemonDBFacade):
        self.__missionID = None
        self.__missionName = None
        self.__mission = None
        self.__missionFilename = None
        self.__missionConf = None
        self.__config = theConfig
        self.__groundObjectManager = None
        self.__statisticCollector = None
        self.__actionLogger = None
        
        self.__missionCompleted = False
        self.__missionCompletedCallbacks = []
        self.__looser = None
        
        self.__timeForMission = None
        self.__missionTimer = None
        self.__reportPeriod = 480  # ADDED by Solar:   
        self.__console = theConsole
        self.__planeManager = PlaneManager(self, theConsole)
        self.__daemonDBFacade = theDaemonDBFacade
     
        self.__targetConf = IniFile(self.__config['MAIN']['target.config'])
        self.__reportConf = IniFile(self.__config['MAIN']['report.config'])
        self.__frontmarkers_b = {} # ADDED by Solar:     
        self.__frontmarkers_r = {} # ADDED by Solar:   
        self.__redPlanesLimit = {} # ADDED by Solar:    
        self.__bluePlanesLimit = {}# ADDED by Solar:      
        self.__discoType = 3       # ADDED by Solar: disco processing flag

    def getBluePlanesLimit(self, thePlaneType): #ADDED by Solar:   -  .  
        planes_b = {}
        if self.__bluePlanesLimit:
            logger.debug('Found blue planes limit in cache, returning amount of %s = %s' % (thePlaneType, self.__bluePlanesLimit[thePlaneType]))
            return self.__bluePlanesLimit[thePlaneType]
        else:
            readconn = kinterbasdb.connect(host=conn_param['Database']['host'],
                database=conn_param['Database']['path'],
                user=conn_param['Database']['user'],
                password=conn_param['Database']['pass'],dialect=1)
            readcursor = readconn.cursor()
            readcursor.execute('select plane, kolvo from now_planes where army="Blue" and kolvo>0')
            for ptype in readcursor.fetchall():
                planes_b[ptype[0]] = int(ptype[1])
                logger.debug('Inserting %s planes of type %s into avail list for BLUE' % (ptype[1], ptype[0]))
            readconn.commit()
            self.__bluePlanesLimit = planes_b
            logger.debug('Returning amount of %s = %s' % (thePlaneType, self.__bluePlanesLimit[thePlaneType]))
            return self.__bluePlanesLimit[thePlaneType]

    def getRedPlanesLimit(self, thePlaneType): #ADDED by Solar:   -  .  
        planes_r = {}
        if self.__redPlanesLimit:
            logger.debug('Found red planes limit in cache, returning amount of %s = %s' % (thePlaneType, self.__redPlanesLimit[thePlaneType]))
            return self.__redPlanesLimit[thePlaneType]
        else:
            readconn = kinterbasdb.connect(host=conn_param['Database']['host'],
                database=conn_param['Database']['path'],
                user=conn_param['Database']['user'],
                password=conn_param['Database']['pass'],dialect=1)
            readcursor = readconn.cursor()
            readcursor.execute('select plane, kolvo from now_planes where army="Red" and kolvo>0')
            for ptype in readcursor.fetchall():
                planes_r[ptype[0]] = int(ptype[1])
                logger.debug('Inserting %s planes of type %s into avail list for BLUE' % (ptype[1], ptype[0]))
            readconn.commit()
            self.__redPlanesLimit = planes_r
            logger.debug('Returning amount of %s = %s' % (thePlaneType, self.__redPlanesLimit[thePlaneType]))
            return self.__redPlanesLimit[thePlaneType]

    def decBluePlanesLimit(self, thePlaneType): #ADDED by Solar:         
        if self.__bluePlanesLimit.has_key(thePlaneType):
            logger.debug('decrementing 1 craft of type %s for BLUE team' % thePlaneType)
            self.__bluePlanesLimit[thePlaneType] -= 1
        else:
            logger.debug('cant find the avail plane of type %s' % thePlaneType)
        
    def decRedPlanesLimit(self, thePlaneType): #ADDED by Solar:         
        if self.__redPlanesLimit.has_key(thePlaneType):
            logger.debug('decrementing 1 craft of type %s for RED team' % thePlaneType)
            self.__redPlanesLimit[thePlaneType] -= 1
        else:
            logger.debug('cant find the avail plane of type %s' % thePlaneType)

    def incBluePlanesLimit(self, thePlaneType): #ADDED by Solar:         
        if self.__bluePlanesLimit.has_key(thePlaneType):
            logger.debug('incrementing 1 craft of type %s for BLUE team' % thePlaneType)
            self.__bluePlanesLimit[thePlaneType] += 1
        else:
            logger.debug('cant find the avail plane of type %s' % thePlaneType)
        
    def incRedPlanesLimit(self, thePlaneType): #ADDED by Solar:         
        if self.__redPlanesLimit.has_key(thePlaneType):
            logger.debug('incrementing 1 craft of type %s for RED team' % thePlaneType)
            self.__redPlanesLimit[thePlaneType] += 1
        else:
            logger.debug('cant find the avail plane of type %s' % thePlaneType)
            
    def getBlueFrontMarkers(self): # ADDED by Solar:    
        mark_b = {}
        mark_b_count = 0
        if self.__frontmarkers_b:
            mark_b = self.__frontmarkers_b
#            logger.debug('Found blue markers in cache')
        else:
            logger.debug('No blue markers in cache. Trying to load')
            cur_mission = self.__mission
            for i in cur_mission['FrontMarker'].keys():
                tmp_str = string.split(cur_mission['FrontMarker'][i])
                if (int(tmp_str[2]) == 2):
                    mark_b[mark_b_count] = [tmp_str[0] + ' ' + tmp_str[1]]
                    mark_b_count += 1
                    logger.debug('Here is blue marker number %s = %s , %s' % (str(mark_b_count),tmp_str[0],tmp_str[1]))
            self.__frontmarkers_b = mark_b
            logger.debug('Found %s blue frontline markers, inserting to cache' % str(mark_b_count))
        return mark_b

    def getRedFrontMarkers(self):  # ADDED by Solar:    
        mark_r = {}
        mark_r_count = 0
        if self.__frontmarkers_r:
            mark_r = self.__frontmarkers_r
#            logger.debug('Found red markers in cache')            
        else:
            logger.debug('No red markers in cache. Trying to load')
            cur_mission = self.__mission
            for i in cur_mission['FrontMarker'].keys():
                tmp_str = string.split(cur_mission['FrontMarker'][i])
                if (int(tmp_str[2]) == 1):
                    mark_r[mark_r_count] = [tmp_str[0] + ' ' + tmp_str[1]]
                    mark_r_count += 1
                    logger.debug('Here is red marker number %s = %s , %s' % (str(mark_r_count),tmp_str[0],tmp_str[1]))                    
            self.__frontmarkers_r = mark_r
            logger.debug('Found %s red frontline markers, inserting to cache' % str(mark_r_count))
        return mark_r

    def getDiscoType(self): #ADDED by Solar
        return self.__discoType

    def getMissionID(self):
        return self.__missionID
        
    def getMission(self):
        return self.__mission

    def getActionLogger(self):
        if not self.__actionLogger:
            self.__actionLogger = ActionLogger(self.__missionID, self.__daemonDBFacade, self.__getRatio)
        return self.__actionLogger
    
    def __getRatio(self, theTeam):
        return self.getPlaneManager().getRatio(theTeam)
    
    def __createParamString(self, theTotals, thePatternKeys):
        resList = []
        for key in map(lambda x: Type(x), thePatternKeys):
            if theTotals.has_key(key):
                resList.append(theTotals[key])
            else:
                resList.append(0)
        return ":".join(map(str, resList))
        
    def loadMission(self, theMissionName, theMission, theMissionConfig, theTimeForMission):
        self.__missionName = theMissionName
        self.__timeForMission = theTimeForMission
        self.__missionConf = IniFile(self.__config['MAIN']['mission.dir'] + '/' + theMissionConfig)
        self.__mission = IniFile(self.__config['MAIN']['mission.dir'] + '/' + theMission)
        if self.__config['DiscoControl'].has_key('disco_type'):
            self.__discoType = int(self.__config['DiscoControl']['disco_type'])
        if self.__config['MAIN'].has_key('ReportPeriod'):
            self.__reportPeriod = int(self.__config['MAIN']['ReportPeriod'])
        self.__planeManager.setPlaneSelectionControl(PlaneSelectionControl(self.__missionConf))
        self.__missionFilename = theMission
        self.restartMission()
        
    def missionTimeLeft(self):
        if self.__missionTimer:
            return self.__missionTimer.left()
        
    def getTargetStatus(self):
        report = {}
        logger.debug("Creating report, Loading Red Team losses and totals:")
        redTargLosses = self.__statisticCollector.getRedTargetLosses()
        redTargTotals = self.__statisticCollector.getRedTargetTotals()
        blueTargLosses = self.__statisticCollector.getBlueTargetLosses()
        blueTargTotals = self.__statisticCollector.getBlueTargetTotals()
        report['Red'] = {}
        report['Blue'] = {}
        for targType in self.__reportConf['Red'].keys():
            logger.debug("Processing %s section", targType)
            if redTargTotals.has_key(targType):
                targ_total = 0.0
                if targType=='ftRed':
                    targ_losses = lost_before['Red']
                else:
                    targ_losses = 0.0
                for staticType in redTargTotals[targType].keys():
                    targ_total += float(redTargTotals[targType][staticType])*factor_ft[staticType]
                    targ_losses += float(redTargLosses[targType][staticType])*factor_ft[staticType]
                logger.debug("Got total for this section = %s", targ_total)
                logger.debug("Got losses for this section = %s", targ_losses)
                if targ_total > 0:
                    if targType=='ftRed':
                        targState = int(targ_total-targ_losses)
                    else:
                        targState = int((1.0 - targ_losses/targ_total)*100.0)
                    logger.debug("Target status = %s", targState)
                    if targState<0:
                        targState=0
                    report['Red'][self.__reportConf['Red'][targType]] = targState
        for targType in self.__reportConf['Blue'].keys():
            logger.debug("Processing %s section", targType)
            if blueTargTotals.has_key(targType):
                targ_total = 0.0
                if targType=='ftBlue':
                    targ_losses = lost_before['Blue']
                else:
                    targ_losses = 0.0
                for staticType in blueTargTotals[targType].keys():
                    targ_total += float(blueTargTotals[targType][staticType])*factor_ft[staticType]
                    targ_losses += float(blueTargLosses[targType][staticType])*factor_ft[staticType]
                logger.debug("Got total for this section = %s", targ_total)
                logger.debug("Got losses for this section = %s", targ_losses)
                if targ_total > 0:                
                    if targType=='ftBlue':
                        targState = int(targ_total-targ_losses)
                    else:
                        targState = int((1.0 - targ_losses/targ_total)*100.0)
                    if targState<0:
                        targState=0
                    logger.debug("Target status = %s", targState)                    
                    report['Blue'][self.__reportConf['Blue'][targType]] = targState            
        return report

    def reportLosses(self):
        status_report = self.getTargetStatus()
        self.__console.writeMessage('status_report', None, None)
        for curArmy in status_report.keys():
            message = []
            intro = curArmy + ' forces'
            for curTarg in status_report[curArmy].keys():
                try:
                    self.__daemonDBFacade.logReport(self.__missionID, curTarg, curArmy, status_report[curArmy][curTarg])
                except:
                    logger.debug("Problems with BD query - execute of INS_MIS_TARGET procedure")
                if curTarg=='front':
                    message.append("%s:%s" % (curTarg, status_report[curArmy][curTarg]))
                else:
                    message.append("%s:%s%%" % (curTarg, status_report[curArmy][curTarg]))
            self.__console.writeMessage('%s:%s', (intro,' '.join(message)), None)
        
    def skipTime(self):
        if self.__missionTimer:
            self.__missionTimer.cancel()
            self.__missionTimer = MyTimer(self.__console, self, self.__reportPeriod, 600, self.__completeCurrentMission)
            self.__missionTimer.start()
            self.__console.writeMessage('time_left', self.__missionTimer.left(), None)
            
    def restartMission(self):
        if self.__missionTimer:
            self.__missionTimer.cancel()
            self.__missionTimer = None
            
        self.__missionID = int(self.__missionName)
        self.__groundObjectManager = None
        self.__statisticCollector = None
        self.__actionLogger = None
        
        # Compatibility code to match behavior of old daemon
        compat = self.__config['Compatibility']            
        
        paramR_army = compat['PARAM_R_ARMY']
        paramB_army = compat['PARAM_B_ARMY']
        patternKeys = compat['PARAM_RB_PATTERN_KEYS'].split(':')
        
        teamR = self.getTeamManager().findTeamByName(paramR_army)
        totalsR = self.getStatisticsCollector().getTotals(teamR)
        paramR = self.__createParamString(totalsR, patternKeys)
        
        teamB = self.getTeamManager().findTeamByName(paramB_army)
        totalsB = self.getStatisticsCollector().getTotals(teamB)
        paramB = self.__createParamString(totalsB, patternKeys)
        # End of compatibility code
        
        self.__console.startMission(self.__getCurrentMissionUrl())
        self.__looser = None
        self.__missionCompleted = False
        self.__frontmarkers_b = {} # ADDED by Solar:  
        self.__frontmarkers_r = {} # ADDED by Solar:  
        self.__redPlanesLimit = {} # ADDED by Solar:  
        self.__bluePlanesLimit = {}# ADDED by Solar:  
        if self.__timeForMission:
            self.__missionTimer = MyTimer(self.__console, self, self.__reportPeriod, self.__timeForMission, self.__completeCurrentMission)
            self.__missionTimer.start()

        
    def getTeamManager(self):
        statCollector = self.getStatisticsCollector()
        return statCollector.getTeamManager()
    
    def getPlaneManager(self):
        return self.__planeManager
        
    def getStatisticsCollector(self):
        if self.__missionConf is None:
            raise Exception('Mission not loaded')
        if self.__statisticCollector is None:
            self.__statisticCollector = StatisticsCollector(self.__missionConf, self.__allObjectsDestroyed, self.__console)
        return self.__statisticCollector
    
    def getGroundObjectManager(self):
        if self.__groundObjectManager is None:
            self.__groundObjectManager = GroundObjectManager(self, self.__targetConf)
        return self.__groundObjectManager
    
    def shutdown(self):
        if self.__missionTimer:
            self.__missionTimer.cancel()
    
    def addMissionCompletedCallback(self, theCallback):
        if not self.__missionCompletedCallbacks.count(theCallback):
            self.__missionCompletedCallbacks.append(theCallback)
            
    def removeMissionCompletedCallback(self, theCallback):
        if self.__missionCompletedCallbacks.count(theCallback):
            self.__missionCompletedCallbacks.remove(theCallback)
        
    def __completeCurrentMission(self, theLooserTeam = None):
        if self.__mission:
            self.__missionCompleted = True
            if len(self.__missionCompletedCallbacks) == 0:
                logger.warning('No mission completed callbacks!')
            for callback in self.__missionCompletedCallbacks:
                try:
                    callback(theLooserTeam)
                except Exception:
                    logger.exception('Exception raised')
            self.__looser = theLooserTeam
            self.__planeManager.landAll()            
        else:
            logger.warn('There is no mission to end')
            
    def endCurrentMission(self):
        self.__completeCurrentMission(None)
            
    def endMission(self):
        if self.__missionCompleted:
            looserTeamName = None
            if self.__looser:
                looserTeamName = self.__looser.getName()
            self.__daemonDBFacade.endMission(self.__missionID, looserTeamName)
        
    def __allObjectsDestroyed(self, theTeam, theType):
        if self.__missionCompleted:
            logger.debug('Mission already completed')
            return
        self.__console.writeMessage('lost_all_objects', (theTeam.getName(), theType.getName()), None)
        lossesKey = 'TeamLosses.%s' % theTeam.getName()
        if not self.__mission.has_key(lossesKey):
            self.__mission[lossesKey] = []
        teamLosses = self.__mission[lossesKey]
        if not teamLosses.count(theType):
            teamLosses.append(theType)
        if self.__isTeamLoosed(theTeam, teamLosses):
            self.__completeCurrentMission(theTeam)
        
    def __isTeamLoosed(self, theTeam, theTeamLosses):
        teamLosses = map(lambda x: x.getName(), theTeamLosses)
        logger.debug('Team looses = %s' % str(teamLosses))
        def TARGET(theTypes):
            counter = 0
            for type in theTypes:
                counter += teamLosses.count(type)
            return counter == len(theTypes)
        def ANY_TARGET(theAmount):
            return len(teamLosses) >= int(theAmount)
        teamLooseStrategies = self.__missionConf[theTeam.getName()]['looseIfLost'].split('|')
        
        target = re.compile('TARGET\((.+)\)')
        anyTarget = re.compile('ANY_TARGET\((\d+)\)')
        result = False
        for teamLooseStrategy in teamLooseStrategies:
            if target.match(teamLooseStrategy):
                targetTypes = target.findall(teamLooseStrategy)[0].split(',')
                targetTypes = filter(None, map(str.strip, targetTypes))
                result = result or TARGET(targetTypes)
                logger.debug('target result = %s' % result)
            if anyTarget.match(teamLooseStrategy):
                result = result or ANY_TARGET(*anyTarget.findall(teamLooseStrategy))
                logger.debug('any target result = %s' % result)
            if result: break
        return result
    
    def __getCurrentMissionUrl(self):
        return self.__config['MAIN']['mission.base.url'] + self.__missionFilename
        

class PlaneSelectionControl:
    def __init__(self, theConfig):
        self.__conf = theConfig
    
    def canRequest(self, thePlayer, thePlaneType):
        logger.debug('%s' % thePlaneType)
        if (not thePlayer) or (not thePlaneType): return 0
        result = 1
        rankName = thePlayer.getRank().getName()
        key = 'PlaneControl.%s' % rankName
        logger.debug('Has key [%s]? %s' % (key, self.__conf.has_key(key)))
        if self.__conf.has_key(key) \
            and self.__conf[key].has_key(thePlaneType):
                value = self.__conf[key][thePlaneType].lower()
                logger.debug('Value = ' + value)
                if value == 'no' or value == 'false':
                    result = 0
        logger.debug('Result = ' + str(result))
        return result
    
class Static(Damageable, Scorable):
    def __init__(self, theStaticID, theType, theTeam, theActionLogger, theDestroyCallback):
        self.__id = theStaticID
        self.__type = theType
        self.__team = theTeam
        self.__destrCoords = None
        self.__actionLogger = theActionLogger
        self.__destroyCallback = theDestroyCallback
        
    def getID(self):
        return self.__id
    
    def getTeam(self):
        return self.__team
        
    def getType(self):
        return self.__type

    #ADDED by Solar: setting statics destroy coords, for later warning messages
    def __setDestrCoords(self, theCoords):
        destrX,destrY = map(float, theCoords.split(' '))
        intX = int(destrX/10000)
        intY = int(destrY/10000)+1
        logger.info('Calculating static coords x,y = %s,%s km' % (str(intX),str(intY)))
        charY = str(intY)
        if intX > 25:
            intX -= 26
            charX = 'A' + chr(ord('A') + intX)
        else:
            charX = chr(ord('A') + intX)
        self.__destrCoords = charX + charY
        logger.info('Static was destroyed at %s', self.__destrCoords)

    def getDestrCoords(self):
        return self.__destrCoords

    #Added by Solar for new generator log
    def getCode(self):
        teamsuffix = self.__team.getName()
        idcode = int(self.__id.split('_')[0])
        if (idcode < 1000):
            prefix = 'ab'
            finalcode = prefix + teamsuffix
            return finalcode
        if (idcode < 2000):
            prefix = 'fa'
            finalcode = prefix + teamsuffix
            return finalcode
        if (idcode < 3000):
            prefix = 'ft'
            finalcode = prefix + teamsuffix
            return finalcode
        if (idcode < 4000):
            prefix = 'mt'
            finalcode = prefix + teamsuffix
            return finalcode
        if (idcode < 5000):
            prefix = 'rt'
            finalcode = prefix + teamsuffix
            return finalcode
        if (idcode < 6000):
            prefix = 'st'
            finalcode = prefix + teamsuffix
            return finalcode        
        
    def damage(self, theDamager, thePosition):
        # Statics damage not supported by IL-2, they can only be destroyed
        pass
        
    def destroy(self, theDestroyer, thePosition):
        if not(None is theDestroyer):
            if isinstance(theDestroyer, Scorable):
                theDestroyer.score(self, thePosition) # Let the destroyer grab its trophy first
        if self.__destroyCallback:
            logger.info('Setting destroy coords')
            self.__setDestrCoords(thePosition)            
            self.__destroyCallback(self) # Notify that this static was destroyed
            
    def score(self, theDamageable, thePosition):
        logger.info('SCORED BY %s (%s)' % (self.getID(), theDamageable.getType().getName()))
        self.__setDestrCoords(thePosition)
        if isinstance(theDamageable, Static):
            #pass # TBD 4to delat' kogda Static ugrobil Static?
            self.__actionLogger.logTwoStaticsAction(self, theDamageable, thePosition)
        else:
            event = 'KILLED'
            if theDamageable.getTeam() == self.__team:
                event = 'TKILLED'
            self.__actionLogger.log(self, theDamageable, event)


class Plane(Damageable, Scorable):
    _sortieCounter = int(time.time())
    def __init__(self, theID, thePlaneName, thePlaneType,  theActionLogger, theBornLocation, theConsole):
        self.__id = theID
        self.__planeName = thePlaneName
        self.__planeType = thePlaneType
        self.__pilot = None
        self.__equipment = None
        self.__bornLocation = theBornLocation
        self.__takeoffLocation = False
        self.__landLocation = None
        self.__seats = {}
        self.__damagers = []
        self.__shuttedDownBy = None
        self.__crashed = False
        self.__ditched = False
        self.__landedTime = None
        self.__sortieID = Plane._generateSortieID()
        self.__actionLogger = theActionLogger
        self.__notAffectLimit = 0 #ADDED BY SOLAR: affectlimit FLAG
#        self.__bannedEquipment = [] #ADDED BY SOLAR
        self.__console = theConsole        
        
        self.__destroyCallbacks = []
        self.__takeOffCallbacks = []
        
    def _generateSortieID():
        Plane._sortieCounter += 1
        return Plane._sortieCounter
    _generateSortieID = staticmethod(_generateSortieID)
        
    def getID(self):
        return self.__id
    
    def getSortieID(self):
        return self.__sortieID
    
    def getType(self):
        return self.__planeType
        
    def getPlaneName(self):
        return self.__planeName
    
    def getTeam(self):
        if self.__pilot:
            return self.__pilot.getTeam()
        
    def getPilot(self):
        return self.__pilot
        
    def setPilot(self, thePilot):
        self.__pilot = thePilot

    def dontAffectLimit(self): #ADDED BY SOLAR
        self.__notAffectLimit = 1

    def doesAffectLimit(self): #ADDED BY SOLAR
        ans = True
        if (self.__notAffectLimit == 1):
            ans = False
        return ans

    def getBornLocation(self):
        return self.__bornLocation
    
    def getLandLocation(self):
        return self.__landLocation
        
    def takeOff(self, theLocation): #MODIFIED BY SOLAR
        if rest_pilots.count(self.__pilot.getName())>0:
            logger.debug('Pilot %s kicked for incorrect equipment (used %s on craft %s)' % (self.__pilot.getName(), self.__equipment, self.__planeName))
            self.__console.executeCommand('kick \"%s\"' % self.__pilot.getName())
            return            
        self.__takeoffLocation = theLocation
        self.__landLocation = None
        self.__landedTime = None
        for callback in self.__takeOffCallbacks:
            callback(self)
        if (self.__pilot.getTeam() is None):
            logger.debug('Newbie %s tried to takeoff... kicking' % self.__pilot.getName())
            self.__console.executeCommand('kick \"%s\"' % self.__pilot.getName())
            return
        self.__actionLogger.log(self, None, 'TAKEOFF')
        
    def land(self, theLocation):
        if self.isInAir():
            self.__landedTime = time.time()
            self.__landLocation = theLocation
            self.__actionLogger.log(self, None, 'LAND')

    def landNoLog(self, theLocation):
        if self.isInAir():
            self.__landedTime = time.time()
            self.__landLocation = theLocation
        
    def isInAir(self):
        return (self.__takeoffLocation and not(self.__landLocation) and not(self.__crashed))
        
    def isCrashed(self):
        return self.__crashed
    
    def occupySeat(self, theSeatNum, theActor):
        for key in self.__seats.keys():
            if self.__seats[key] is theActor:
                self.__seats[key] = None
        self.__seats[theSeatNum] = theActor
        
    def freeSeat(self, theSeatNum):
        if self.__seats.has_key(theSeatNum):
            del self.__seats[theSeatNum]
        else: # it is probably the bot freed the seat, so just ignore him
            pass
        
    def getActorAtSeat(self, theSeatNum):
        if self.__seats.has_key(theSeatNum):
            return self.__seats[theSeatNum]
        
    def bailOut(self, theSeatNum):
        if self.__seats.has_key(theSeatNum):
            actor = self.__seats[theSeatNum]
            if not(actor is None):
                actor.bail()
        # else: it was probably the bot bailed, so just ignore him
        
    def damage(self, theDamager, thePosition):
        if theDamager:
            self.__actionLogger.log(theDamager, self, 'DAMAGED')
            self.__damagers.append(theDamager)
        else:
            self.__actionLogger.log(self, None, 'DAMAGED')
            
    def getLastDamager(self):
        if self.__shuttedDownBy:
            return self.__shuttedDownBy
        elif self.__pilot and self.__pilot.getKiller():
            return self.__pilot.getKiller()
        elif len(self.__damagers) > 0:
            return self.__damagers[-1]
        
    def destroy(self, theDestroyer, theLocation):
        if not(self.__crashed):
            self.__shuttedDownBy = theDestroyer
            # the plane not crashed yet
            isDitched = not self.__ditched \
                and not self.isInAir() \
                and self.__landedTime # SOLAR: removed following clause:   and (time.time() - self.__landedTime) > 5
            if not(isDitched):
                self.__crashed = True
                # Do not use action logger here to log 'CRASHED', do it in plane manager,
                # because unauthenticated pilot may destroy plane
                for callback in self.__destroyCallbacks:
                    callback(self)                         # Notify that plane was destroyed
                destroyer = self.getLastDamager()
                if destroyer and isinstance(destroyer, Scorable):
                    destroyer.score(self, theLocation) # Let destroyer grab the prise
            elif not(self.__ditched):
                self.__ditched = True
                self.__actionLogger.log(self, None, 'DITCHED')
                if self.__shuttedDownBy and isinstance(self.__shuttedDownBy, Scorable):
                    self.__shuttedDownBy.scoreDitched(self, theLocation)
            self.__landLocation = theLocation # even if plane crashed it is on the ground now
        
    def score(self, theSource, thePosition):
        # Give plane score to its pilot
        if not(theSource is self):
            self.getPilot().score(theSource, thePosition)
        
    def scoreDitched(self, theSource, thePosition):
        # Give plane score to its pilot
        if not(theSource is self):
            self.getPilot().scoreDitched(theSource, thePosition)

    def addTakeoffCallback(self, theCallback):
        self.__takeOffCallbacks.append(theCallback)
        
    def removeTakeoffCallback(self, theCallback):
        if self.__takeOffCallbacks.count(theCallback):
            logger.debug('removing takeoff callback: one of %s', str(self.__takeOffCallbacks.count(theCallback)))
            self.__takeOffCallbacks.remove(theCallback)
        
    def addDestroyCallback(self, theCallback):
        if not self.__destroyCallbacks.count(theCallback):
            self.__destroyCallbacks.append(theCallback)
        
    def removeDestroyCallback(self, theCallback):
        if self.__destroyCallbacks.count(theCallback):
            self.__destroyCallbacks.remove(theCallback)

class Pilot(Damageable, Scorable):
    _pilotType = Type('pilot')
    def __init__(self, theID, theName, thePassword, theRank, theTeam, thePlaneManager, theActionLogProvider, theConsole, theKilledCallback, theCapturedCallback):
        self.__auth = 0
        self.__auth_cb_ok = 0
        self.__authFailCount = 0
        self.__console = theConsole
        # todo think about user role
        # General pilot info
        self.__id = theID
        self.__name = theName
        self.__password = thePassword
        self.__team = theTeam 
        self.__rank = theRank
        self.__connected = False
        self.__bailed = False
        
        self.__scoreStat = {}
        
        self.__deathCount = 0
        
        self.__plane = None
        self.__reset()
        
        self.__killedCallback = theKilledCallback
        self.__capturedCallback = theCapturedCallback
        self.__planeManager = thePlaneManager
        self.__actionLogProvider = theActionLogProvider
        
        self.__authCallbacks = []
        self.__noTakeOff = 0 #Added by Solar: pilot should wait for takeoff
        self.__killer = None
        self.__captured = None
        
    def getID(self):
        return self.__id
        
    def getName(self):
        return self.__name
    
    def getKiller(self):
        return self.__killer
    
    def setTeam(self, theTeam):
        self.__team =theTeam
        
    def getTeam(self):
        return self.__team
    
    def setRank(self, theRank):
        self.__rank = theRank
    
    def getRank(self):
        return self.__rank
        
    def getType(self): # Damageable interface
        return Pilot._pilotType
    
    def isAuthenticated(self):
        return self.__auth
    
    def authenticate(self, thePass):
        if thePass == self.__password:
            self.__auth = 1
            if not (self.__auth_cb_ok):
                for callback in self.__authCallbacks:
                    callback(self)
                self.__auth_cb_ok = 1
            return 1
        else:
            self.__authFailCount += 1
            if self.__authFailCount >= 3:
                self.__console.executeCommand('kick \"%s\"' % self.__name)
            return 0
    
    def __reset(self):
        self.__releaseResources()
        self.__bailed = False
        self.__killer = None
        self.__captured = False
        
    def __releaseResources(self):
        if not(self.__plane is None):
            self.__planeManager.releasePlane(self.__plane)
            self.__plane = None
        
    def connect(self):
        self.__connected = True
        self.__actionLogProvider().log(self, None, 'CONN')
        
    def disconnect(self):
        self.__reset()
        self.__connected = False
        self.__actionLogProvider().log(self, None, 'DISCONN')
        
    def isConnected(self):
        return self.__connected
    
    def score(self, theDamageable, thePosition):
        if not(theDamageable is self) and not(theDamageable is self.__plane):
            logger.info('SCORED BY %s (%s)' % (self.getName(), theDamageable.getType().getName()))
            event = 'KILLED'
            if theDamageable.getTeam() == self.__team:
                event = 'TKILLED'
            self.__actionLogProvider().log(self, theDamageable, event)
            #if isinstance(theDamageable, Plane):
            #    self.__console.writeMessage('shot_down', (self.getName(), theDamageable.getPilot().getName()), None)
            type = theDamageable.getType().getName()
            if not self.__scoreStat.has_key(type):
                self.__scoreStat[type] = 1
            else:
                self.__scoreStat[type] += 1
                
    def scoreDitched(self, theDamageable, thePosition):
        if not(theDamageable is self) and not(theDamageable is self.__plane):
            logger.info('SCORED(DITCH) BY %s (%s)' % (self.getName(), theDamageable.getType().getName()))
            event = 'KILLED'
            if theDamageable.getTeam() == self.__team:
                event = 'TKILLED'
            self.__actionLogProvider().log(self, theDamageable, event)
            #if isinstance(theDamageable, Plane):
            #    self.__console.writeMessage('forced_to_ditch', (self.getName(), theDamageable.getPilot().getName()), None)
            type = theDamageable.getType().getName()
            if not self.__scoreStat.has_key(type):
                self.__scoreStat[type] = 1
            else:
                self.__scoreStat[type] += 1

    def getScoreStat(self):
        return self.__scoreStat
        
    def bail(self):
        self.__bailed = True
        self.__actionLogProvider().log(self, None, 'BAIL')
        
    def kill(self, theKiller):
        if self.__auth and self.isAlive(): # Don't like 'self.__auth' here, but life is important thing
            self.__deathCount += 1
            if (self == theKiller) or (None is theKiller):
                self.__killer = self
                self.__actionLogProvider().log(self, None, 'DIED')
            else:
                self.__killer = theKiller
                self.__actionLogProvider().log(self, None, 'DIED') # Don't log the killer
        if self.__killedCallback:
            self.__killedCallback(self)
        
    def getDeathCount(self):
        return self.__deathCount

    def resetDeathCount(self):
        logger.debug('Player %s death counter reset' % self.__name)
        self.__deathCount = 0
        
    def respawn(self, theResetScoreStat = False):
        self.__reset()
        if theResetScoreStat:
            self.__scoreStat = {}
        
    def capture(self):
        if not self.__captured:
            self.__actionLogProvider().log(self, None, 'CAPTURED')
            if self.__capturedCallback:
                self.__capturedCallback(self)
            self.__captured = True
        
    def isAlive(self):
        return not(self.__killer)

    def isBailed(self):
        return self.__bailed
        
    def requestPlane(self, thePlaneID, thePlaneName, theBornLocation):
        plane = self.__planeManager.requestPlane(thePlaneID, thePlaneName, self, theBornLocation)
        if plane:
            def planeDestroyed(plane):
                if (self.__team is None):
                    self.__console.writeMessage('newbie_crashed', self.__name, None)
                else:
                    self.__console.writeMessage('plane_crashed', (self.__rank.getName(), self.__name), self.__team)
            plane.setPilot(self)
            plane.addDestroyCallback(planeDestroyed)
            self.__plane = plane
        else:
            raise Exception('Pilot does not receive a plane!')
        
    def getPlane(self):
        return self.__plane
    
    def damageChute(self, theDamager = None):
        self.__actionLogProvider().log(self, None, 'TCKILLED')
        
    def wound(self, theWounder = None):
        self.__actionLogProvider().log(self, None, 'WOUNDED')
        
    def damage(self, theDamager, thePosition): # Damageable interface
        self.__wound(theDamager)
        
    def destroy(self, theDestroyer, thePosition): # Damageable interface
        self.kill(theDestroyer)
        
    def addAuthorizationCallback(self, theAuthorizationCallback):
        self.__authCallbacks.append(theAuthorizationCallback)
    ## Added by Solar : check if takeoff allowed
    def isTakeOffAllowed(self):
        answer = True
        if (self.__noTakeOff == 1):
            answer = False
        return answer
    ## Added by Solar : prohibit takeoff    
    def restrictTakeOff(self):
        self.__noTakeOff = 1
        self.__console.writeMessage('takeoff_prohibited', None, self.__name)
    ## Added by Solar : allowing takeoff, removing callback
    def allowTakeOff(self):
        self.__noTakeOff = 0
        self.__console.writeMessage('takeoff_granted', None, self.__name)
        if self.__plane:
            self.__planeManager.clearanceGranted(self.__plane)
           
        
class _StaticsTypeResolver:
    def __init__(self, theConfigFileName):
        self.__conf = theConfigFileName
        
    def resolve(self, theStatObjClazz):
        for type in self.__conf.keys():
            d = self.__conf[type]
            for clazz in d:
                if clazz == theStatObjClazz:
                    return Type(type)
        logger.warning('Unknown type of object ' + theStatObjClazz)
        return Type('unknwn')
    
class BornPlace:
    def __init__(self, theLocation):
        self.__location = theLocation
        
    def getLocation(self):
        return self.__location

class GroundObjectManager:
    def __init__(self, theMissionController, theConfigFileName):
        self.__misController = theMissionController
        self.__staticsTypeResolver = _StaticsTypeResolver(theConfigFileName)
        self.__bornPlaces = {}
        self.__resolvedStatics = {}
      
    def __getTeamManager(self):
        return self.__misController.getTeamManager()

    def findStatic(self, theStaticID):
        if self.__resolvedStatics.has_key(theStaticID):
            return self.__resolvedStatics[theStaticID]
        mission = self.__misController.getMission()
        if mission.has_key('NStationary') and mission['NStationary'].has_key(theStaticID):
            static = self.__misController.getMission()['NStationary'][theStaticID]
            staticClazz, teamID = static.split()[:2]
            teamID = int(teamID)
            type = self.__staticsTypeResolver.resolve(staticClazz)
            team = self.__getTeamManager().findTeamByID(teamID)
            self.__resolvedStatics[theStaticID] = Static(theStaticID, type, team, self.__misController.getActionLogger(), self.__destroyed)
            return self.__resolvedStatics[theStaticID]
        
    def getBornPlaces(self, theTeam):
        res = []
        if self.__bornPlaces.has_key(theTeam):
            # Get from cache
            res = self.__bornPlaces[theTeam]
        else:
            mission = self.__misController.getMission()
            if mission.has_key('BornPlace'):
                teamID = str(theTeam.getID())
                if mission['BornPlace'].has_key(teamID):
                    bornPlaces = mission['BornPlace'][teamID]
                    if not(type(bornPlaces) == type([])):
                        bornPlaces = (bornPlaces,)
                    for bornPlace in bornPlaces:
                        res.append(BornPlace(' '.join(bornPlace.split(' ')[1:])))
            self.__bornPlaces[theTeam] = res # Caching...
        return res
        
    def __destroyed(self, theStatic):
        self.__misController.getStatisticsCollector().collectLoss(theStatic) # Notify statistics collector that static was destroyed
        logger.debug('%s destroyed' % theStatic.getID())

class PlaneManager:
    _genericPlaneType = Type('craft')
    _bomberPlaneType = Type('bomber')
    def __init__(self, theMissionController, theConsole):
        self.__misController = theMissionController
        self.__console = theConsole
        self.__planeControl = None
        self.__planes = {}
        
    def setPlaneSelectionControl(self, theSelectionControl):
        self.__planeControl = theSelectionControl
        
    def requestPlane(self, thePlaneID, thePlaneName, thePilot, theBornLocation):
        #todo Check if user can request this plane
        # if user not allowed to take this plane send him warning message 
        # and add takeoff listener to this plane to kick him out
        if thePlaneID is None:
            raise ValueError(thePlaneID)
        may_use = 0
        authed = 0
        planeType=  PlaneManager._genericPlaneType
        ## ADDED BY SOLAR: checking newbies
        if (thePilot.getTeam() is None):
            plane = Plane(thePlaneID, thePlaneName, planeType, self.__misController.getActionLogger(), theBornLocation, self.__console)            
            plane.addTakeoffCallback(self.__kickUnregistered)
            toWho = thePilot.getName()
            self.__console.writeMessage('you_not_registered', None, toWho)
            self.__planes[thePlaneID] = plane
            logger.debug('giving a plane to a newbie %s' % toWho)
            return plane
        plane = Plane(thePlaneID, thePlaneName, planeType, self.__misController.getActionLogger(), theBornLocation, self.__console)
        if not thePilot.isAuthenticated():
            plane.addTakeoffCallback(self.__kickUnauthenticated)
            thePilot.addAuthorizationCallback(self.__pilotAuthorized)
            toWho = thePilot.getName()
            self.__console.writeMessage('you_not_authenticated', None, toWho)
        if self.__planeControl:
            if not self.__planeControl.canRequest(thePilot, thePlaneName):
                plane.addTakeoffCallback(self.__kickOnTakeoff)
                toWho = thePilot.getName()
                self.__console.writeMessage('choosed_plane_not_allowed', None, toWho)
            elif thePilot.isAuthenticated():
                authed = 1
                may_use = 1
                plane.addDestroyCallback(self.__destroyed)
        if not thePilot.isTakeOffAllowed():
            logger.debug('Player %s has no takeoff clearance: adding takeoff callback', thePilot.getName())
            toWho = thePilot.getName()
            self.__console.writeMessage('still_no_takeoff', None, toWho)
            self.__console.writeMessage('if_you_try_takeoff', None, toWho)
            plane.addTakeoffCallback(self.__kickOnTakeoffA)
        ##ADDED BY SOLAR: checking plane availibility for RED
        if ((may_use == 1) and (authed == 1)):
            if (thePilot.getTeam().getID() == 1):
                craft_left = self.__misController.getRedPlanesLimit(plane.getPlaneName())
                if (craft_left > 0):
                    self.__misController.decRedPlanesLimit(plane.getPlaneName())
                else:
                    toWho = thePilot.getName()
                    plane.addTakeoffCallback(self.__kickByLimit)
                    plane.dontAffectLimit()
                    self.__console.writeMessage('plane_no_longer_available', None, toWho)
                    self.__console.writeMessage('if_you_try_takeoff', None, toWho)
            ##ADDED BY SOLAR: checking plane availibility for BLUE
            if (thePilot.getTeam().getID() == 2):
                craft_left = self.__misController.getBluePlanesLimit(plane.getPlaneName())
                if (craft_left > 0):
                    self.__misController.decBluePlanesLimit(plane.getPlaneName())
                else:
                    toWho = thePilot.getName()
                    plane.addTakeoffCallback(self.__kickByLimit)
                    plane.dontAffectLimit()                    
                    self.__console.writeMessage('plane_no_longer_available', None, toWho)
                    self.__console.writeMessage('if_you_try_takeoff', None, toWho)
        ##############        
        self.__planes[thePlaneID] = plane
#        plane.checkEquipment()
        return plane

    def clearanceGranted(self, thePlane):
        logger.debug('Player %s now has takeoff clearance: removing callback', thePlane.getPilot().getName())
        thePlane.removeTakeoffCallback(self.__kickOnTakeoffA)        
    
    def releasePlane(self, thePlane): #Solar: Metod prishlos perepisat'
        try:
            print 'LANDED LOCATION: ', thePlane.getLandLocation()
            processed = False # SOLAR: Processed flag :) i was too lazy
            returned = True
            act_log = self.__misController.getActionLogger() # SOLAR: Getting action logger to feed events to DB
            logger.debug('Player %s releasing a plane %s' % (thePlane.getPilot().getName(), thePlane.getPlaneName()))
            if (thePlane.getPilot().getTeam() is None):
                logger.debug('Player is newbie - just releasing plane');
                planeID = thePlane.getID()
                if self.__planes.has_key(planeID):
                    del self.__planes[planeID]
                return        
            if thePlane.isInAir():
                if thePlane.getPilot().isAlive():
                    logger.debug('The plane released in the air. Possible player disconnect')
                    discoPenalty = self.__misController.getDiscoType()
                    logger.debug('Processing disco with type=%s' % discoPenalty)
                    try:
                        act_log.log(thePlane, None, 'DISCOFLY')
                    except:
                        logger.debug('could not set DISCOFLY event to DB')
                    logger.debug('Setting DISCO in THE FLIGHT event')
                    if discoPenalty == 0:
                        thePlane.land(thePlane.getBornLocation())
                        returned = True
                    if discoPenalty == 1:
                        self.__misController.getStatisticsCollector().collectTempLoss(thePlane)
                        returned = False
                        act_log.log(thePlane, None, 'DITCHED')
                    if discoPenalty == 2:
                        self.__misController.getStatisticsCollector().collectTempLoss(thePlane)
                        returned = False
                        act_log.log(thePlane, None, 'CRASHED')                    
                    if discoPenalty == 3:
                        thePlane.destroy(thePlane.getLastDamager(), thePlane.getLandLocation())
                        returned = False
                    if discoPenalty == 4:
                        thePlane.getPilot().kill(thePlane.getLastDamager())
                        thePlane.destroy(thePlane.getLastDamager(), thePlane.getLandLocation())
                        returned = False
                    processed = True
                else:
                    thePlane.destroy(thePlane.getLastDamager(), thePlane.getLandLocation())
                    returned = False
                    processed = True
            if not(thePlane.isCrashed()) and not(processed) and not(thePlane.getPilot().isAlive()):
                thePlane.destroy(thePlane.getLastDamager(), thePlane.getLandLocation())
                returned = False
                processed = True
            if not(thePlane.isCrashed()) and not(processed) and thePlane.getLandLocation() and not(self.__isOnTeamSide(thePlane, thePlane.getLandLocation())):
            # MODIFIED BY SOLAR: Now this event should read:
            # If plane was landed on the enemies side of map it will be destroyed and pilot should be captured
            # TODO: add function to check if pilot can run away... depending on distance to frontline
                logger.debug('Plane was landed on the enemies side. Thus it will be destroyed')
                self.__console.writeMessage('landed_enemies_territory', thePlane.getPilot().getName(), None)
                thePlane.destroy(thePlane.getLastDamager(), thePlane.getLandLocation())
                if thePlane.getPilot().isAlive():
                    self.__console.writeMessage('captured_by_enemies', thePlane.getPilot().getName(), None)
                    thePlane.getPilot().capture()
                processed = True
                returned = False
            if not(thePlane.isCrashed()) and not(processed) and thePlane.getLandLocation() and not(self.__isNearTeamBase(thePlane, thePlane.getLandLocation())):
            # ADDED BY SOLAR: If plane was landed on the team side of map but
            # too far from team fields we will consider it ditched
                logger.debug('Plane was landed on the team side. But too far from base. Thus it will be considered DITCHED')
                self.__console.writeMessage('ditched_allied_territory', thePlane.getPilot().getName(), thePlane.getPilot().getTeam())
                if not (self.__isNotFarFromTeamBase(thePlane, thePlane.getLandLocation())):
                    # If landed on team side, but too far from base - team temporarily looses craft
                    self.__misController.getStatisticsCollector().collectTempLoss(thePlane)
                    returned = False
                act_log.log(thePlane, None, 'DITCHED')
                processed = True
            if not(thePlane.isCrashed()) and not(processed) and thePlane.getLandLocation():
            ## SOLAR: Putting extra LANDED EVENT for testing                
                act_log.log(thePlane, None, 'LAND')
                
            ## Check if we have to return plane to avail list
            if (not(thePlane.isCrashed()) and returned and thePlane.doesAffectLimit()):
                if (thePlane.getPilot().getTeam().getID() == 1):
                    self.__misController.incRedPlanesLimit(thePlane.getPlaneName())
                if (thePlane.getPilot().getTeam().getID() == 2):
                    self.__misController.incBluePlanesLimit(thePlane.getPlaneName())                
#Catching exception                
        except:
            logger.exception('Exception raised: %s' % detail)
        planeID = thePlane.getID()
        if self.__planes.has_key(planeID):
            del self.__planes[planeID]
        else:
            raise Exception('[ERROR] Something broked...')
        
        
    def __isNearTeamBase(self, thePlane, theLocation):
        result = False
        groundObjMan = self.__misController.getGroundObjectManager()
        bornPlaces = groundObjMan.getBornPlaces(thePlane.getTeam())
#        logger.debug('Born places = ' + str(map(lambda x: x.getLocation(), bornPlaces)))
        landX,landY = map(float, theLocation.split(' '))
        for bornPlace in bornPlaces:
            x,y = map(float, bornPlace.getLocation().split(' '))
            distance = math.sqrt(math.pow(x - landX, 2) + math.pow(y - landY, 2))
#            logger.debug('Distance = %s' % distance)
            if distance < 4000:
                result = True
                break
        return result

    def __isNotFarFromTeamBase(self, thePlane, theLocation): #Solar - lenivo moddit' funkciju vishe
        result = False
        groundObjMan = self.__misController.getGroundObjectManager()
        bornPlaces = groundObjMan.getBornPlaces(thePlane.getTeam())
#        logger.debug('Born places = ' + str(map(lambda x: x.getLocation(), bornPlaces)))
        landX,landY = map(float, theLocation.split(' '))
        for bornPlace in bornPlaces:
            x,y = map(float, bornPlace.getLocation().split(' '))
            distance = math.sqrt(math.pow(x - landX, 2) + math.pow(y - landY, 2))
#            logger.debug('Distance = %s' % distance)
            if distance < 20000:
                result = True
                break
        return result
        
    def __isOnTeamSide(self, thePlane, theLocation): #Solar : Dobavil etu funkciju dlya rascheta storoni prizemlenia crafta
        result = False
        landed_side = 0
        logger.debug('Calculating if the landing location is on correct FrontSide')
        # let us get markers
        blue_markers = self.__misController.getBlueFrontMarkers()
        red_markers = self.__misController.getRedFrontMarkers()
        logger.debug('Ok. Have front markers now!')
        # landing coords
        landX,landY = map(float, theLocation.split(' '))
        logger.debug('Landed coords: %s %s' % (str(landX),str(landY)))        
        dist_to_blue = []
        dist_to_red = []
        #Filling distances
        logger.debug('Calculating distances now:')
        for i in blue_markers:
            dX  = float(blue_markers[i][0].split()[0])-landX
            dY  = float(blue_markers[i][0].split()[1])-landY
            dXY = int(math.sqrt(math.pow(dX,2)+math.pow(dY,2)))
            dist_to_blue.append(dXY)
        for i in red_markers:
            dX  = float(red_markers[i][0].split()[0])-landX
            dY  = float(red_markers[i][0].split()[1])-landY
            dXY = int(math.sqrt(math.pow(dX,2)+math.pow(dY,2)))
            dist_to_red.append(dXY)
        #Getting nearest markers
        min_dist_blue = min(dist_to_blue)
        min_dist_red = min(dist_to_red)
#        logger.debug('Ok, got minimal distances blue = %s , red = %s' % (str(min_dist_blue),str(min_dist_red)))
#        logger.debug('And the player team is %s' % thePlane.getTeam().getName())
        #So, we've landed to....
        if min_dist_blue < min_dist_red:
            landed_side = 2
            logger.debug('Plane is on BLUE side')            
        else:
            landed_side = 1
            logger.debug('Plane is on RED side')                        
        #Finally, answering...
        if (landed_side == thePlane.getTeam().getID()):
            logger.debug('Player have landed the his team side')
            result = True
        return result
        
    def findPlane(self, planeID):
        if self.__planes.has_key(planeID):
            return self.__planes[planeID]
        
    def getRatio(self, theTeam):
        allPlanesCount = len(self.__planes.values())
        totalPlanes = 0
        teamCount = 0
        if allPlanesCount > 0:
            for curplane in self.__planes.values():
                if (curplane.getTeam() <> None):
                    totalPlanes += 1
                    if (curplane.getTeam().getID() == theTeam.getID()):
                        teamCount += 1
            #teamCount = len(filter(lambda x: x.getTeam().getID() == theTeam.getID(),self.__planes.values()))
            if teamCount == 0:
                return 2.0 # Napr zena sbila kogda pilotov ee komandy ne bylo na servere
            elif allPlanesCount == teamCount:
                return 0.2
            else:
                return 1.0 * (allPlanesCount - teamCount)/teamCount
        return 1.0
        
        
    def landAll(self):
        logger.debug('Landing all planes...')
        for plane in self.__planes.values():
            if plane.isInAir():
                if (plane.getTeam() is None):
                    plane.landNoLog(plane.getBornLocation())
                else:
                    plane.landNoLog(plane.getBornLocation()) # Return plane to its base
            '''
            pilot = plane.getPilot()
            if pilot:
                pilot.respawn()
            '''
        if len(self.__planes):
            logger.warning('Not all planes were released! Unreleased plane count is ' + str(len(self.__planes)))
        
    def __pilotAuthorized(self, thePilot):
        plane = thePilot.getPlane()
        if plane:
            plane.addDestroyCallback(self.__destroyed)
            plane.removeTakeoffCallback(self.__kickUnauthenticated)
            ##
            if (thePilot.getTeam().getID() == 1):
                craft_left = self.__misController.getRedPlanesLimit(plane.getPlaneName())
                if (craft_left > 0):
                    self.__misController.decRedPlanesLimit(plane.getPlaneName())
                else:
                    toWho = thePilot.getName()
                    plane.addTakeoffCallback(self.__kickByLimit)
                    plane.dontAffectLimit()
                    self.__console.writeMessage('plane_no_longer_available', None, toWho)
                    self.__console.writeMessage('if_you_try_takeoff', None, toWho)
            ##ADDED BY SOLAR: checking plane availibility for BLUE
            if (thePilot.getTeam().getID() == 2):
                craft_left = self.__misController.getBluePlanesLimit(plane.getPlaneName())
                if (craft_left > 0):
                    self.__misController.decBluePlanesLimit(plane.getPlaneName())
                else:
                    toWho = thePilot.getName()
                    plane.addTakeoffCallback(self.__kickByLimit)
                    plane.dontAffectLimit()                    
                    self.__console.writeMessage('plane_no_longer_available', None, toWho)
                    self.__console.writeMessage('if_you_try_takeoff', None, toWho)
            
    def __kickUnauthenticated(self, thePlane):
        pilotName = thePlane.getPilot().getName()
        thePlane.land(thePlane.getBornLocation())
        self.__kickPilot(pilotName)

    def __kickUnregistered(self, thePlane):
        pilotName = thePlane.getPilot().getName()
        thePlane.landNoLog(thePlane.getBornLocation())
        self.__kickPilot(pilotName)
        
    def __kickByLimit(self, thePlane):
        pilotName = thePlane.getPilot().getName()
        thePlane.land(thePlane.getBornLocation())
        self.__kickPilot(pilotName)
        
    def __kickOnTakeoff(self, thePlane):
        pilotName = thePlane.getPilot().getName()
        thePlane.land(thePlane.getBornLocation())
        self.__kickPilot(pilotName)

    def __kickOnTakeoffA(self, thePlane):
        pilotName = thePlane.getPilot().getName()
        thePlane.land(thePlane.getBornLocation())
        self.__kickPilot(pilotName)
    
    def __kickPilot(self, pilotName):
        self.__console.executeCommand('kick \"%s\"' % pilotName)
        
    def __destroyed(self, thePlane):
        self.__misController.getStatisticsCollector().collectLoss(thePlane) # Notify statistics collector that plane was destroyed
        self.__misController.getActionLogger().log(thePlane, None, 'CRASHED')
        if thePlane.getType() == PlaneManager._bomberPlaneType:
            # If plane is a bomber we should collect loss of plane too thus create fake plane and destroy it
            class FakePlane(Damageable):
                def getType(self):
                    return PlaneManager._genericPlaneType
                def getTeam(self):
                    return thePlane.getTeam()
                def damage(self, theDamager, thePosition):
                    pass
                def destroy(self, theDestroyer, thePosition):
                    pass
            self.__misController.getStatisticsCollector().collectLoss(FakePlane())
        logger.debug('%s destroyed' % thePlane.getID())
    
# Evetlog event handlers
class TimeableEventHandler(EventHandler):
    def __init__(self, d):
        d = dict(zip(d.keys(), map(lambda x: '^\[([^\]]+)\] ' + x, d.values())))
        EventHandler.__init__(self, d)

class ConnectionHandler(TimeableEventHandler, PilotManager):
    '''
    Handles user connections
    '''
    def __init__(self, theMissionController, theDeamonDBFacade, theConsole):
        d = {self.__playerConnected:'(.+) has connected',\
             self.__playerDisconnected:'(.+) has disconnected',}
        TimeableEventHandler.__init__(self, d)
        
        self.__planeManager = theMissionController.getPlaneManager()
        self.__misController = theMissionController
        self.__console = theConsole
        self.__deamonDBFacade = theDeamonDBFacade
        
        self.__players = {}
        ## added by Solar: spisok pilotov, kotorie ozhidajut razreshenie na vlzet.
        self.__waitingPlayers = {}
        
    def handle(self, theMethod, theMatches):
        for match in theMatches:
            theMethod(match[1])
        
    def connect(self, theWho):
        return self.__playerConnected(theWho)
    
        
    def __playerConnected(self, theUserName):
        player = None
        def actionLogProvider():
            return self.__misController.getActionLogger()
        notok=0
        for i in range(len(theUserName)):
            if ord(theUserName[i]) not in range(33,127) or ord(theUserName[i]) in (60,62):
                notok=1
                break
        if notok==1 or string.find(theUserName,' ')>0 or theUserName=='' or theUserName[-1]=='0':
            logger.info('player %s with wrong name!' % theUserName)
            self.__playerDisconnected(theUserName) # Disconnect him first
            self.__console.executeCommand('kick \"%s\"' % theUserName)
            
        if self.__players.has_key(theUserName):
            logger.warning('Pilot [%s] is already connected' % (theUserName))
            self.__playerDisconnected(theUserName) # Disconnect him first
            
        pilotID, team, rank, password = self.__getPilotProfile(theUserName)
        if not pilotID or not team or not rank:
            logger.info('unknown player %s connected' % theUserName)
            self.__console.writeMessage('have_newbie', theUserName, None)
            player = Pilot(0000, theUserName, 'unreg', None, None, self.__planeManager, \
                       actionLogProvider, self.__console, self.__playerKilled, self.__playerCaptured)
            self.__players[theUserName] = player
            return player
        player = Pilot(pilotID, theUserName, password, rank, team, self.__planeManager, \
                       actionLogProvider, self.__console, self.__playerKilled, self.__playerCaptured)
        self.__players[theUserName] = player
        self.__deamonDBFacade.addActivePilot(pilotID, team.getName())
        logger.info('Pilot [%s] has connected' % (theUserName))
        player.connect()
        ## added by Solar: proveryaem ne zapreshen li igroku vzlet
        if self.__waitingPlayers.has_key(theUserName):
            if (self.__waitingPlayers[theUserName] == 1):
                player.restrictTakeOff()
                logger.info('Pilot [%s] still has restriction to take off' % (theUserName))
        else:
            logger.info('Pilot [%s] is allowed to take off' % (theUserName))            
            self.__waitingPlayers[theUserName] = 0
            #player.allowTakeOff()
        return player
    
    def __getPilotProfile(self, theUserName):
        profile = self.__deamonDBFacade.getPilotProfile(theUserName)
        if not profile:
            return (None, None, None, None)
        pilotID, rankID, rankShortname, userPass, teamName = profile
        team = self.__misController.getTeamManager().findTeamByName(teamName)
        rank = Rank(rankID, rankShortname)
        return (pilotID, team, rank, userPass)
    
    def __playerCaptured(self, thePilot):
        self.__misController.getStatisticsCollector().collectLoss(thePilot)
        
    def __playerKilled(self, thePilot): #Zhutkij rewrite by Solar
        if thePilot.isAuthenticated():
            self.__misController.getStatisticsCollector().collectLoss(thePilot) # Notify statistics collector that plane was destroyed
            name = thePilot.getName()
            self.__console.writeMessage('you_killed', None, name)
            #self.__console.executeCommand('kick \"%s\"' % name)
       
    def __playerDisconnected(self, theUserName):
        if self.__players.has_key(theUserName):
            pilotID = self.__players[theUserName].getID()
            self.__players[theUserName].disconnect()
            del self.__players[theUserName]
            ## Added by Solar: check and delete player from waitingPlayers list
            if self.__waitingPlayers.has_key(theUserName):
                if (self.__waitingPlayers[theUserName] == 0):
                    del self.__waitingPlayers[theUserName]
            if (pilotID == 0000): #Solar: do not log newbies
                return
            self.__deamonDBFacade.removeActivePilot(pilotID)
        logger.info('Pilot [' + theUserName + '] has disconnected')
        
    def getActivePilots(self):
        return filter(lambda x: x.isConnected(), self.__players.values())
        
    def findPilot(self, theName):
        if self.__players.has_key(theName):
            return self.__players[theName]
        
    def updatePilotInfos(self):
        for player in self.__players.values():
            pilotID, team, rank, password = self.__getPilotProfile(player.getName())
            if not pilotID or not team or not rank:
                self.__playerDisconnected(player.getName())
                logger.warning('Cannot update info for pilot named %s' % player.getName())
            player.setRank(rank)
            player.setTeam(team)
            
    def disconnectAll(self):
        self.__players = {}
        self.__waitingPlayers = {}
        self.__deamonDBFacade.removeAllActivePilots()

    def dropWaitList(self):
        self.__waitingPlayers = {}
        for cur_player in self.__players.keys():
            self.__players[cur_player].resetDeathCount()
    
class PilotEventHandler(TimeableEventHandler):
    def __init__(self, thePilotManager, theMissionController, theConsole):
        d = {self.__takeoff: '(.+) in flight at ([\d\.]+ [\d\.]+)',\
             self.__crashed: '(.+) crashed at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__landed: '(.+) landed at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__equipped:'(.+) loaded weapons \'([^\']+)\' fuel (\d+)%',\
             self.__damaged: '(.+) damaged by (.+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',
             self.__shotDown: '(.+) shot down by (.+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__chuteDestroyed: '(.+) has chute destroyed by (.+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__planeDestroyed: '(.+:\S+) destroyed by (.+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__staticDestroyed: '(\S+) destroyed by (.+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__damagedOnTheGround: '(.+) damaged on the ground at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__wingtipSmokes: '(.+) turned wingtip smokes (\S+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__landingLights: '(.+) turned landing lights (\S+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__enteredRefyMenu: '(.+) entered refly menu',\
             self.__bailedOutSuccessfully: '(.+:\S+) successfully bailed out at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__occupiedSeat:'(.+:\S+) seat occupied by (.+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',
             self.__killedBy: '(.+:\S+) was killed by (.+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__killed: '(.+:\S+) was killed at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__bailedOut: '(.+:\S+) bailed out at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__captured: '(.+:\S+) was captured at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__wounded: '(.+:\S+) was wounded at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__heavilyWounded: '(.+:\S+) was heavily wounded at ([+-]?[\d\.]+ [+-]?[\d\.]+)',\
             self.__killedInShute: '(.+:\S+) was killed in his chute by (.+) at ([+-]?[\d\.]+ [+-]?[\d\.]+)'}
        TimeableEventHandler.__init__(self, d)
        
        self.__playerManager = thePilotManager
        self.__planeManager = theMissionController.getPlaneManager()
        self.__misController = theMissionController
        self.__planePattern = re.compile('(.*:(\S+))\((\d+)\)')
        self.__console = theConsole
        
    def handle(self, theMethod, theMatches):
        for match in theMatches:
            theMethod(*(match[1:]))
        
    def __getPilot(self, theName):
        return self.__playerManager.findPilot(theName)
        
    def __isPilot(self, theWho):
        return string.find(theWho, ':') > 0
        
    def __resolveStatic(self, theStaticID):
        return self.__misController.getGroundObjectManager().findStatic(theStaticID)
        
    def __takeoff(self, theWho, theLocation):
        plane = self.__planeManager.findPlane(theWho)
        if plane:
            plane.takeOff(theLocation)
        else:
            logger.warning('Cannot find plane named [%s]!' % theWho)
        
    def __findOutWho(self, theWho):
        res = None
        if not(theWho is None or theWho == 'landscape' or theWho == 'NONAME'):
            res = self.__playerManager.findPilot(theWho)
            if res is None:
                # it is not a player
                res = self.__planeManager.findPlane(theWho)
                if res is None:
                    #it is not a plane either, try static
                    res = self.__resolveStatic(theWho)
        if not res:
            logger.warning('Cannot find resolve object named [%s]!' % theWho)
        return res
        
    def __shotDown(self, theWho, theByWho, theLocation):
        plane = self.__planeManager.findPlane(theWho)
        scorer = self.__findOutWho(theByWho)
        if plane:
            plane.destroy(scorer, theLocation)
            logger.info('SHOT DOWN by %s: %s' % (theByWho, theWho))
        else:
            logger.warning('DUNG!Cannot find plane named [%s]!' % theWho)
        
    def __damaged(self, theWho, theByWho, theLocation):
        who, byWho = map(self.__findOutWho,(theWho, theByWho))
        if who:
            who.damage(byWho, theLocation)
        else:
            logger.warning('Cannot find [%s]!' % theWho)
        
    def __killedBy(self, theWho, theByWho, theLocation):
        planeID, planeType, seatNum = self.__parsePlane(theWho)
        plane = self.__planeManager.findPlane(planeID)
        if not plane:
            logger.warning('%s was killed by %s but its plane was not found, so let him live for now' % (theWho, theByWho))
        else:
            victim = plane.getActorAtSeat(seatNum)
            if not(victim is None): # Pilot killed not bot
                murderer = self.__findOutWho(theByWho)
                victim.kill(murderer)
        
    def __killedInShute(self, theWho, theByWho, theLocation):
        self.__chuteDestroyed(theWho, theByWho, theLocation)
        
    def __chuteDestroyed(self, theWho, theByWho, theLocation):
        planeID, planeType, seatNum = self.__parsePlane(theWho)
        plane = self.__planeManager.findPlane(planeID)
        if not plane:
            logger.warning('%s was killed by %s but its plane was not found, so let him live for now' % (theWho, theByWho))
        else:
            victim = plane.getActorAtSeat(seatNum)
            if not(victim is None): # Pilot killed not bot
                damager = self.__findOutWho(theByWho)
                victim.damageChute(damager)
        
    def __killed(self, theWho, theLocation):
        self.__killedBy(theWho, None, theLocation) # Crashed
        
    def __crashed(self, theWho, theLocation):
        plane = self.__planeManager.findPlane(theWho)
        if plane:
            plane.destroy(None, theLocation)
        else:
            logger.warning('Cannot find plane named [%s]!' % theWho)
        
    def __staticDestroyed(self, theWho, theByWho, theLocation):
        who, byWho = map(self.__findOutWho,(theWho, theByWho))
        if who:
            who.destroy(byWho, theLocation)
            logger.info('DESTROYED by %s: %s' % (theByWho, theWho))
        else:
            logger.warning('Cannot find [%s]!' % theWho)
        
    def __planeDestroyed(self, theWho, theByWho, theLocation):
        who, byWho = map(self.__findOutWho,(theWho, theByWho))
        if who:
            who.destroy(byWho, theLocation)
            logger.info('DESTROYED by %s: %s' % (theByWho, theWho))
        else:
            logger.warning('Cannot find [%s]!' % theWho)
    
    def __landed(self, theWho, theLocation):
        plane = self.__planeManager.findPlane(theWho)
        if plane:
            plane.land(theLocation)
        else:
            logger.warning('Cannot find plane named [%s]!' % theWho)
        
    def __equipped(self, theWho, theWeapon, theFuel):
        thePilotName = string.split(theWho,':')[0]
        plane = string.split(theWho,':')[1]
        if plane:
            readconn = kinterbasdb.connect(host=conn_param['Database']['host'],
                database=conn_param['Database']['path'],
                user=conn_param['Database']['user'],
                password=conn_param['Database']['pass'],dialect=1)
            readcursor = readconn.cursor()
            readcursor.execute("select allow, verdikt from weapon_rest('%s','%s','%s', %s)" % (thePilotName, plane, theWeapon, int(theFuel)))
            weapAllowed = readcursor.fetchone()
            readconn.commit()
            if len(weapAllowed)<1:
                weapAllowed = [0,'Error!']
            logger.debug('Database returned allow=%s' % str(weapAllowed[0]))
            if (weapAllowed[0] == 0):
                if rest_pilots.count(thePilotName)==0:
                    rest_pilots.append(thePilotName)
                mess = thePilotName+'! '+weapAllowed[1]
                self.__console.writeMessage(mess, None, thePilotName)
            else:
                if rest_pilots.count(thePilotName)>0:
                    rest_pilots.remove(thePilotName)
            logger.info("%s equipped with '%s' and filled tankes with %s percent of fuel" % (theWho, theWeapon, theFuel))
        else:
            logger.warning('Cannot find plane named [%s]!' % theWho)
        
    def __damagedOnTheGround(self, theWho, theLocation):
        damagedPlane = self.__planeManager.findPlane(theWho)
        if damagedPlane:
            damagedPlane.damage(None, theLocation)
        else:
            logger.warning('Cannot find plane named [%s]!' % theWho)
    
    def __wingtipSmokes(self, theWho, theSmokeState, theLocation):
        pass # todo
    
    def __landingLights(self, theWho, theLightsState, theLocation):
        pass # todo
    
    def __parsePlane(self, theWhere):
        if theWhere:
            if self.__planePattern.match(theWhere):
                result = self.__planePattern.findall(theWhere)[-1]
                logger.debug('Parse plane (%s) result: %s' % (theWhere, str(result)))
                return result
        
    def __occupiedSeat(self, theWhere, theWho, theLocation):
        planeID, planeType, seatNum = self.__parsePlane(theWhere)
        
        player = self.__getPilot(theWho)
        if None is player:
            # Its strange... The player has not connected. Connect him manually
            player = self.__playerManager.connect(theWho)
            logger.debug('Artificially connecting player %s!' % player.getName())
            if None is player:
                # The player manager not allowed player to join the game
                return
        
        plane = player.getPlane()
        if not(plane) or plane.getID() != planeID: # Pilot without plane or he is changed one
            info = None
            tries = 0
            while (info is None) and (tries < 10):
                info = self.__console.getUserInfo(player.getName())
                tries += 1
            logger.debug('User info: %s' % str(info))
            if info is None:
                logger.warning('Team of pilot %s cannot be resolved' % player.getName())
            else:
                team = self.__misController.getTeamManager().findTeamByID(int(info[2]))
                playerTeam = player.getTeam()
                if (playerTeam is None): #Solar: do not touch newbies
                    player.requestPlane(planeID, planeType, theLocation)
                    plane.occupySeat(seatNum, player)                    
                    self.__console.writeMessage('please_register', player.getName(), player.getName())
                    return
                if not(team is playerTeam):
                    self.__console.writeMessage('wrong_team', player.getName(), None)
                    timer = Timer(10, self.__console.executeCommand, ['kick \"%s\"' % player.getName()])
                    timer.start()
                    #self.__console.executeCommand('kick %s' % player.getName())
            player.requestPlane(planeID, planeType, theLocation)                    
        plane = player.getPlane()
        plane.occupySeat(seatNum, player)
        
    def __bailedOut(self, theWho, theLocation):
        planeID, planeType, seatNum = self.__parsePlane(theWho)
        plane = self.__planeManager.findPlane(planeID)
        if plane:
            plane.bailOut(seatNum)
        else:
            logger.warning('Cannot find plane named [%s]!' % planeID)
    
    def __bailedOutSuccessfully(self, theWho, theLocation):
        # That is great that the pilot will return to his family! :)
        pass
    
    def __captured(self, theWho, theLocation):
        # Very sad :(
        planeID, planeType, seatNum = self.__parsePlane(theWho)
        plane = self.__planeManager.findPlane(planeID)
        if plane:
            pilot = plane.getActorAtSeat(seatNum)
            if not(pilot is None):
                #Pilot captured
                pilot.capture()
        else:
            logger.warning('Cannot find plane named [%s]!' % planeID)
    
    def __wounded(self, theWho, theLocation):
        planeID, planeType, seatNum = self.__parsePlane(theWho)
        plane = self.__planeManager.findPlane(planeID)
        if plane:
            pilot = plane.getActorAtSeat(seatNum)
            if not(pilot is None):
                #Pilot wounded
                pilot.wound()
        else:
            logger.warning('Cannot find plane named [%s]!' % planeID)
    
    def __heavilyWounded(self, theWho, theLocation):
        self.__wounded(theWho, theLocation)
    
    def __enteredRefyMenu(self, theWho):
        pilot = self.__getPilot(theWho)
        if pilot:
            pilot.respawn()
        else:
            logger.warning('Cannot find [%s] pilot!' % theWho)

class MissionEventHandler(TimeableEventHandler):
    def __init__(self, thePilotManager, theStrategy):
        self.__strategy = theStrategy
        d = {self.__missionPlaying: 'Mission: (.*) is Playing',\
             self.__missionBegin: 'Mission BEGIN',
             self.__missionEnd: 'Mission END'}
        TimeableEventHandler.__init__(self, d)
        
        self.__listeners = []
        
        self.__playerManager = thePilotManager
        
    def handle(self, theId, theMatches):
        if theId == self.__missionEnd or theId == self.__missionBegin:
            theId()
        elif theId == self.__missionPlaying:
            pass # todo implement
        
    def __missionPlaying(self):
        logger.info('Mission is playing...')
        pass
        
    def __missionBegin(self):
        self.__strategy.missionStarted()
        for listener in self.__listeners[0:]:
            listener.missionStarted()
        
    def __missionEnd(self):
        self.__strategy.missionEnded()
        for listener in self.__listeners[0:]:
            listener.missionEnded()
        #Solar added: dropping list of pilots who are waiting for
        #takeoff clearance and reseting deathcount counters in pilot instances
        self.__playerManager.dropWaitList()

        
    def addEventListener(self, theListener):
        if not self.__listeners.count(theListener):
            self.__listeners.append(theListener)
            
    def removeEventListener(self, theListener):
        if self.__listeners.count(theListener):
            self.__listeners.remove(theListener)

# Command Executors
class VersionCommandExecutor(CommandExecutor):
    def __init__(self, theConsole):
        CommandExecutor.__init__(self, "ver")
        self.__console = theConsole
    
    def execute(self, theParams, theByWho):
        self.__console.writeMessage('PowerFBDaemon v0.9 by IvanoBulo, Solar, McFris', None, theByWho)
        

class SecondTargetCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "secondtarget")
        self.__console = theConsole

    def execute(self, theParams, theByWho):
        mt=theParams[0]
        if mt in('mt','rt','st'):
            try:
                writeconn = kinterbasdb.connect(host=conn_param['Database']['host'],
                    database=conn_param['Database']['path'],
                    user=conn_param['Database']['user'],
                    password=conn_param['Database']['pass'],dialect=1)
        
                writecursor = writeconn.cursor()
                writecursor.execute("select res from set_main_target('%s','%s')" % (mt, theByWho))
                res = int(writecursor.fetchone()[0])
                writeconn.commit()
            except:
                res=0
            if res==1:
                self.__console.writeMessage('maintarget', None, theByWho)
            else:
                self.__console.writeMessage('dont_permition', None, theByWho)
        else:
                self.__console.writeMessage('only_ft', None, theByWho)

class WinMissionCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole, theMissionController):
        CommandExecutor.__init__(self, "win")
        self.__console = theConsole
        self.__misController = theMissionController

    def execute(self, theParams, theByWho):
        try:
            writeconn = kinterbasdb.connect(host=conn_param['Database']['host'],
                database=conn_param['Database']['path'],
                user=conn_param['Database']['user'],
                password=conn_param['Database']['pass'],dialect=1)
        
            writecursor = writeconn.cursor()
            writecursor.execute("select res from win_mission('%s')" % (theByWho))
            res = int(writecursor.fetchone()[0])
            writeconn.commit()
        except:
            res=0
        if res==1:
            self.__misController.skipTime()
            self.__console.writeMessage('endmission', theByWho, None)
        else:
            self.__console.writeMessage('dont_permition', None, theByWho)

class flytimeCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "flytime")
        self.__console = theConsole

    def execute(self, theParams, theByWho):
        writeconn = kinterbasdb.connect(host=conn_param['Database']['host'],
            database=conn_param['Database']['path'],
            user=conn_param['Database']['user'],
            password=conn_param['Database']['pass'],dialect=1)
        
        writecursor = writeconn.cursor()
        writecursor.execute("select summ_time from flytime('%s')" % theByWho)
        res = writecursor.fetchone()[0]
        writeconn.commit()
        self.__console.writeMessage('flytime', res, theByWho)

class ShowTargetCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "showtarget")
        self.__console = theConsole

    def execute(self, theParams, theByWho):
        writeconn = kinterbasdb.connect(host=conn_param['Database']['host'],
            database=conn_param['Database']['path'],
            user=conn_param['Database']['user'],
            password=conn_param['Database']['pass'],dialect=1)
        
        writecursor = writeconn.cursor()
        writecursor.execute("select res from get_main_target('%s')" % theByWho)
        res = writecursor.fetchone()[0]
        writeconn.commit()
        self.__console.writeMessage('showtarget', res, theByWho)

class DisallowCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "disallow")
        self.__console = theConsole

    def execute(self, theParams, theByWho):
        user=theParams[0]
        try:
            writeconn = kinterbasdb.connect(host=conn_param['Database']['host'],
                database=conn_param['Database']['path'],
                user=conn_param['Database']['user'],
                password=conn_param['Database']['pass'],dialect=1)
        
            writecursor = writeconn.cursor()
            writecursor.execute("select res from set_allow('%s','%s',-1)" % (user, theByWho))
            res = int(writecursor.fetchone()[0])
            writeconn.commit()
        except:
            res=0
        if res==1:
            self.__console.writeMessage('disallowed', (user, theByWho), user)
            self.__console.writeMessage('disallowed', (user, theByWho), theByWho)
        else:
            self.__console.writeMessage('dont_permition', None, theByWho)

class AllowCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "allow")
        self.__console = theConsole

    def execute(self, theParams, theByWho):
        user=theParams[0]
        try:
            writeconn = kinterbasdb.connect(host=conn_param['Database']['host'],
                database=conn_param['Database']['path'],
                user=conn_param['Database']['user'],
                password=conn_param['Database']['pass'],dialect=1)
        
            writecursor = writeconn.cursor()
            writecursor.execute("select res from set_allow('%s','%s',1)" % (user, theByWho))
            res = int(writecursor.fetchone()[0])
            writeconn.commit()
        except:
            res=0
        if res==1:
            self.__console.writeMessage('allowed', (user, theByWho), user)
            self.__console.writeMessage('allowed', (user, theByWho), theByWho)
        else:
            self.__console.writeMessage('dont_permition', None, theByWho)

class TargstatCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "targstat")
        self.__pilotManager = thePilotManager
        self.__console = theConsole
    
    def execute(self, theParams, theByWho):
        pilot = self.__pilotManager.findPilot(theByWho)
        if pilot:
            msg = ''
            scoreStat = pilot.getScoreStat()
            for statObj in scoreStat.keys():
                msg += ', %s: %s' % (statObj, scoreStat[statObj])
            if len(msg) == 0:
                msg = ', 0.'
            self.__console.writeMessage(msg[2:], None, theByWho)

class GunstatCommandExecutor(CommandExecutor):
    class _GunstatDataReceiver(DataReceiver):
        def __init__(self):
            self.__collectedData = []
            self.__sutisfiedRank = 0
            self.__sepLine = ('-' * 55) + '\\n'
            self.__endComandPattern = re.compile('<consoleN><(\d+)>')
        def isSutisfied(self):
            #logger.debug('self.__sutisfiedRank = ' + str(self.__sutisfiedRank))
            return (self.__sutisfiedRank >= 2)
        def dataReceived(self, theString):
            self.__collectedData.append(theString)
            if theString[:len(self.__sepLine)] == self.__sepLine or self.__endComandPattern.match(theString):
                self.__sutisfiedRank += 1
        def getCollectedData(self):
            return self.__collectedData
    def __init__(self, theTelnetCommunicator, theConsole):
        CommandExecutor.__init__(self, "gunstat")
        self.__tc = theTelnetCommunicator
        self.__console = theConsole
        self.__fireP = re.compile('Fire (\w+)[^\d]+(\d+)')
        self.__hitP = re.compile('Hit (\w+)[^\d]+(\d+)')
    def execute(self, theParams, theByWho = None):
        if theByWho:
            datareceiver = GunstatCommandExecutor._GunstatDataReceiver()
            self.__tc.writeAndWaitUntilSatisfy('user %s STAT' % theByWho, datareceiver)
            data = datareceiver.getCollectedData()
            logger.debug(data)
            hitD = {}
            fireD = {}
            for dataLine in data:
                if self.__fireP.match(dataLine):
                    fireRes = self.__fireP.findall(dataLine)[0]
                    fireD[fireRes[0]] = fireRes[1]
                if self.__hitP.match(dataLine):
                    hitRes = self.__hitP.findall(dataLine)[0]
                    hitD[hitRes[0]] = hitRes[1]
            logger.debug(fireD)
            logger.debug(hitD)
            res = ''
            for key in fireD.keys():
                if hitD.has_key(key):
                    hit = int(hitD[key])
                    fire = int(fireD[key])
                    if fire > 0:
                        if key == 'Bullets' and hitD.has_key('Air'):
                            res += ', %s: %s (%s(incl. %s air hits)/%s)' % (str(key), str(round(float(hit)/fire * 100, 2)) + '%', hitD[key], hitD['Air'], fireD[key])
                        else:
                            res += ', %s: %s (%s/%s)' % (str(key), str(round(float(hit)/fire * 100, 2)) + '%', hitD[key], fireD[key])
            if len(res) == 0:
                res = ', 0.'
            self.__console.writeMessage(res[2:], None, theByWho)
            math

class RestartCommandExecutor(CommandExecutor):
    def __init__(self, theMissionController):
        CommandExecutor.__init__(self, "restart")
        self.__misController = theMissionController
    
    def execute(self, theParams, theByWho = None):
        missionName = self.__misController.restartMission()
        
class AuthCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "pass")
        self.__pilotManager = thePilotManager
        self.__console = theConsole
    
    def execute(self, theParams, theByWho):
        pilot = self.__pilotManager.findPilot(theByWho)
        if pilot:
            msg = None
            if len(theParams) > 0:
                if pilot.authenticate(theParams[0]):
                    msg = 'password_accepted'
                else:
                    msg = 'incorrect_password'
            else:
                msg = 'no_password'
            self.__console.writeMessage(msg, None, theByWho)
    
class KickCommandExecutor(CommandExecutor): #SOLAR: edited to check officer's team
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "kick")
        self.__pilotManager = thePilotManager
        self.__console = theConsole

    def execute(self, theParams, theByWho):
        for user in theParams:
            kicker = self.__pilotManager.findPilot(theByWho)
            kicker_victim =  self.__pilotManager.findPilot(user)
            if (kicker.getTeam().getID() == kicker_victim.getTeam().getID()):
                self.__console.executeCommand("kick \"%s\"" % user)
                self.__console.writeMessage('kicked', (user, theByWho), None)
            else:
                self.__console.writeMessage('cant_kick_player', None, theByWho)

class BanUserCommandExecutor(CommandExecutor):
    def __init__(self, theConsole):
        CommandExecutor.__init__(self, "ban")
        self.__console = theConsole
        self.__console.executeCommand("ban LOAD userban.list")
    
    def execute(self, theParams, theByWho = None):
        for user in theParams:
            self.__console.executeCommand("ban ADD NAME \"%s\"" % user)
        self.__console.executeCommand("ban SAVE userban.list")

class PilotListCommandExecutor(CommandExecutor):
    def __init__(self, thePilotManager, theConsole):
        CommandExecutor.__init__(self, "players")
        self.__pilotManager = thePilotManager
        self.__console = theConsole
    
    def execute(self, theParams, theByWho):
        pilots = self.__pilotManager.getActivePilots()
        for pilot in pilots:
            parts = [pilot.getName()]
            team = 'None'
            if pilot.getTeam():
                team = pilot.getTeam().getName()
            parts.append(team)
            parts.append(pilot.getRank().getName())
            self.__console.writeMessage(':'.join(parts), None, theByWho)


class TargetListCommandExecutor(CommandExecutor):
    def __init__(self, theMissionController, theConsole, thePilotManager):
        CommandExecutor.__init__(self, "targets")
        self.__console = theConsole
        self.__misController = theMissionController
        self.__pilotManager = thePilotManager
        
    def __getTeamManager(self):
        return self.__misController.getTeamManager()
            
    def execute(self, theParams, theByWho):
        teams = self.__getTeamManager().listTeams()
        pilot = self.__pilotManager.findPilot(theByWho)
        if pilot.getTeam().getID() == 1:
            blueLosses = self.__misController.getStatisticsCollector().getBlueTargetLosses()
            blueTotals = self.__misController.getStatisticsCollector().getBlueTargetTotals()
            redLosses = self.__misController.getStatisticsCollector().getRedTargetLosses()
            redTotals = self.__misController.getStatisticsCollector().getRedTargetTotals()
            resList = []
            for type in blueTotals['ftBlue'].keys():
                if blueTotals['ftBlue'][type] > 0:
                    total = blueTotals['ftBlue'][type]
                    loss = blueLosses['ftBlue'][type]
                    resList.append(" %s:%s" % (type, loss))
            self.__console.writeMessage('%s:%s', ('blue front losses', ','.join(resList)), theByWho)
            resList = []
            for type in redTotals['ftRed'].keys():
                if redTotals['ftRed'][type] > 0:
                    total = redTotals['ftRed'][type]
                    loss = redLosses['ftRed'][type]
                    resList.append(" %s:%s/%s" % (type, total - loss, total))
            self.__console.writeMessage('%s:%s', ('red front state', ','.join(resList)), theByWho)
            
        if pilot.getTeam().getID() == 2:
            redLosses = self.__misController.getStatisticsCollector().getRedTargetLosses()
            redTotals = self.__misController.getStatisticsCollector().getRedTargetTotals()
            blueLosses = self.__misController.getStatisticsCollector().getBlueTargetLosses()
            blueTotals = self.__misController.getStatisticsCollector().getBlueTargetTotals()
            resList = []
            for type in redTotals['ftRed'].keys():
                if redTotals['ftRed'][type] > 0:
                    total = redTotals['ftRed'][type]
                    loss = redLosses['ftRed'][type]
                    resList.append(" %s:%s" % (type, loss))
            self.__console.writeMessage('%s:%s', ('red front losses', ','.join(resList)), theByWho)
            resList = []
            for type in blueTotals['ftBlue'].keys():
                if blueTotals['ftBlue'][type] > 0:
                    total = blueTotals['ftBlue'][type]
                    loss = blueLosses['ftBlue'][type]
                    resList.append(" %s:%s/%s" % (type, total-loss, total))
            self.__console.writeMessage('%s:%s', ('blue front state', ','.join(resList)), theByWho)

class MissionTimeLeft(CommandExecutor):
    def __init__(self, theMissionController, theConsole):
        CommandExecutor.__init__(self, "time")
        self.__misController = theMissionController
        self.__console = theConsole
        
    def execute(self, theParams, theByWho):
        timeLeft = str(self.__misController.missionTimeLeft()).split('.')[0]
        self.__console.writeMessage('time_left', timeLeft, None)

# Console emulator
class Console(Thread):
    def __init__(self, theTelnetCommunicator):
        self.__tc = theTelnetCommunicator
        self.__commandListeners = []
        self.__msgListeners = []
        self.__shouldStop = False
        Thread.__init__(self)
        
    def writeMessage(self, theMsg, param, ToWho):
        def get_lang(key, thePilotName):
            if not lang_pilots.has_key(thePilotName):
                readlang = kinterbasdb.connect(host=conn_param['Database']['host'],
                database=conn_param['Database']['path'],
                user=conn_param['Database']['user'],
                password=conn_param['Database']['pass'],dialect=1)
                read_lang_cursor = readlang.cursor()
                read_lang_cursor.execute("select pilotname, lang from id_players")
                for i in read_lang_cursor.fetchall():
                    lang_pilots[i[0]]=int(i[1])
                readlang.commit()
            lang=lang_pilots.get(thePilotName,0)
            if translate.has_key(key):
                return translate[key][str(lang)]
            else:
                return key

        def get_msg(msg):
            msgs = []
            while len(msg) > 70:
                msgs.append(msg[:70])
                msg = '\t' + msg[70:]
            msgs.append(msg)
            return msgs
            
        def send_msg(msgs, who):
            for msg in msgs:
                msg = 'chat %s %s' % (msg, 'TO \"%s\" ' % who)
                self.__tc.write(`unicode(msg,'CP1251')`[2:-1])
        
        if ToWho in('ALL', None): # send message to all
            readconn = kinterbasdb.connect(host=conn_param['Database']['host'],
            database=conn_param['Database']['path'],
            user=conn_param['Database']['user'],
            password=conn_param['Database']['pass'],dialect=1)
            readactive = readconn.cursor()
            readactive.execute("select i.pilotname, i.army from id_players i, active_players a where i.pilotid=a.pilotid")
            for pilot in readactive.fetchall():
                if param != None:
                    send_msg(get_msg(get_lang(theMsg, pilot[0]) % param), pilot[0])
                else:
                    send_msg(get_msg(get_lang(theMsg, pilot[0])), pilot[0])
            readconn.commit()
        elif ToWho in('Red', 'Blue'): # send message to Army
            readconn = kinterbasdb.connect(host=conn_param['Database']['host'],
            database=conn_param['Database']['path'],
            user=conn_param['Database']['user'],
            password=conn_param['Database']['pass'],dialect=1)
            readactive = readconn.cursor()
            readactive.execute("select i.pilotname, i.army from id_players i, active_players a where i.pilotid=a.pilotid")
            for pilot in readactive.fetchall():
                if pilot[1] == ToWho:
                    if param != None:
                        send_msg(get_msg(get_lang(theMsg, pilot[0]) % param), pilot[0])
                    else:
                        send_msg(get_msg(get_lang(theMsg, pilot[0])), pilot[0])
            readconn.commit()
        else: # send message to player
            if param != None:
                send_msg(get_msg(get_lang(theMsg, ToWho) % param), ToWho)
            else:
                send_msg(get_msg(get_lang(theMsg, ToWho)), ToWho)
        logger.debug('Message "%s" was sent to console' % theMsg)

    def executeCommand(self, theCommand):
        self.__tc.write(theCommand)
        
    def startMission(self, theUri):
        self.endMission()
        self.executeCommand("mission LOAD %s BEGIN" % theUri)
        
    def endMission(self):
        self.executeCommand("mission END")
        
    def getUserInfo(self, theNick):
        p = re.compile('\s+(\d+)\s+(\d+)\s+\((\d+)\)')
        res = self.__tc.writeAndWaitFor('user \"%s\"' % theNick, p)
        if not(res is None):
            result = p.findall(res)
            logger.debug(str(result))
            return result[0]
    
    def addCommandReceivedListener(self, theListener):
        self.__commandListeners.append(theListener)
        
    def removeCommandReceivedListener(self, theListener):
        if self.__commandListeners.count(theListener):
            self.__commandListeners.remove(theListener)
        
    def addMessageReceivedListener(self, theListener):
        self.__msgListeners.append(theListener)
        
    def removeMessageReceivedListener(self, theListener):
        if self.__msgListeners.count(theListener):
            self.__msgListeners.remove(theListener)
        
    def __notifyCommandListeners(self, theCommandResList):
        for listener in self.__commandListeners:
            listener.commandReceived(*theCommandResList[0])
            
    def __notifyMsgListeners(self, theMsg):
        for listener in self.__msgListeners:
            listener.msgReceived(theMsg)
        
    def shutdown(self):
        self.__shouldStop = True
        
    def run(self):
        commandP = re.compile('Chat: (.+): [\\\]t<(\w+)\s?[\\\]n')
        commandP2 = re.compile('Chat: (.+): [\\\]t<(\w+)<(.+)[\\\]n')
        logger.info('Console emulator is running...')
        while self.__tc.isAlive() and not(self.__shouldStop):
            if self.__tc.isDataAvailable():
                line = self.__tc.read().strip()
                if commandP.match(line):
                    self.__notifyCommandListeners(commandP.findall(line))
                elif commandP2.match(line):
                    self.__notifyCommandListeners(commandP2.findall(line))
                else:
                    self.__notifyMsgListeners(line)
            else:
                time.sleep(0.1)
        logger.info('Console emulator stoped')

# Console message and command listeners
class MessageListener:
    def msgReceived(self, theMessage):
        #logger.debug('Message received ''%s'' ' % theMessage)
        pass

class CommandListener:
    def __init__(self, theCommandChainHandler):
        self.__chain = theCommandChainHandler
    def commandReceived(self, theFromWho, theCommandName, theParameters = None):
        params = ()
        if not(theParameters is None):
            params = theParameters.split('<')
        logger.debug('Command ''%s'' received from ''%s'' with parameters %s' % (theCommandName, theFromWho, params))
        self.__chain.handle(Command(theFromWho, theCommandName, params))
        
# Mission start and end strategy
class MissionStartEndStrategy:
    def __init__(self, thePilotEventHandler, theEventChainHandler, thePilotManager, theMissionController):
        self.__pilotEventHandler = thePilotEventHandler
        self.__eventChainHandler = theEventChainHandler
        self.__pilotManager = thePilotManager
        self.__misController = theMissionController
        
    def missionStarted(self):
        self.__eventChainHandler.addEventHandler(self.__pilotEventHandler) # Start to handle game events
        self.__pilotManager.updatePilotInfos()
        logger.info('Mission started')
        
    def missionEnded(self):
        for pilot in self.__pilotManager.getActivePilots():
            pilot.respawn(True)
        self.__eventChainHandler.removeEventHandler(self.__pilotEventHandler) # Do not handle game events
        self.__misController.endMission()
        logger.info('Mission ended')

class EventLogReader(Thread):
    def __init__(self, theLogFilename, theEventHandler):
        self.__log = theLogFilename
        self.__evHandler = theEventHandler
        self.__shouldStop = False
        Thread.__init__(self)
        
    def shutdown(self):
        self.__shouldStop = True
        
    def run(self):
        #Set the filename and open the file
        file = open(self.__log,'r')
        
        #Find the size of the file and move to the end
        st_results = os.stat(self.__log)
        st_size = st_results[6]
        file.seek(st_size)
        
        while not self.__shouldStop:
            where = file.tell()
            line = file.readline()
            if not line:
                time.sleep(1)
                file.seek(where)
            else:
                self.__evHandler.handleEventLine(line)
                
        file.close()
        logger.info('Eventlog reader stopped')
        
def main(config):
    
    eventChainHandler = EventChainHandler()
    logReader = EventLogReader(config['MAIN']['event.log'], eventChainHandler)
    tc = TelnetCommunicator(config['Telnet']['host'], int(config['Telnet']['port']))
    console = Console(tc)
    dbconn = KinderbasFacade(config['Database']['host'],\
                             config['Database']['path'],\
                             config['Database']['user'], \
                             config['Database']['pass'], 1)
    daemonDB = DaemonDBFacade(dbconn)
    
    try:
        try:
            tc.start()
            console.start()
            dbconn.connect()
            
            daemonDB.removeAllActivePilots()
            
            misController = MissionController(config, console, daemonDB)
            connectionHandler = ConnectionHandler(misController, daemonDB, console)
            eventChainHandler.addEventHandler(connectionHandler)
            
            pilotEventHandler = PilotEventHandler(connectionHandler, misController, console)
            
            strategy = MissionStartEndStrategy(pilotEventHandler, eventChainHandler, connectionHandler, misController)
            
            misEventHandler = MissionEventHandler(connectionHandler, strategy)
            eventChainHandler.addEventHandler(misEventHandler)
            
            class DaemonSecurityChecker(SecurityChecker):
                def __init__(self, theConfIni):
                    self.__conf = theConfIni
                    
                def isAllowed(self, theCommandName, theExecutorName):
                    pilot = connectionHandler.findPilot(theExecutorName)
                    #logger.debug('Does %s is authorized to perform %s command?' % (theExecutorName, theCommandName))
                    if pilot and pilot.isAuthenticated():
                            pilotName = pilot.getName()
                            pilotRankName = pilot.getRank().getName()
                            #logger.debug('Pilot %s is authenticated' % pilotName)
                            groups = self.__conf['MAIN']['groups'].split(',')
                            groups = filter(None, map(str.strip, groups))
                            for group in groups:
                                #logger.debug('Looking in group %s' % group)
                                if self.__conf.has_key(group):
                                    permCommands = self.__conf[group]['permitions'].split(',')
                                    permCommands = filter(None, map(str.strip, permCommands))
                                    #logger.debug('Permitions in group: %s' % str(permCommands))
                                    if not permCommands.count(theCommandName):
                                        #Group does not contain given command
                                        continue
                                    if self.__conf[group].has_key('names'):
                                        names = self.__conf[group]['names'].split(',')
                                        names = filter(None, map(str.strip, names))
                                        if names.count(pilotName):
                                            return 1
                                    if self.__conf[group].has_key('pattern'):
                                        p = re.compile(self.__conf[group]['pattern'])
                                        if p.match(pilotName):
                                            return 1
                                    if self.__conf[group].has_key('ranks'):
                                        ranks = self.__conf[group]['ranks'].split(',')
                                        ranks = filter(None, map(str.strip, ranks))
                                        if ranks.count(pilotRankName):
                                            return 1
                    else:
                        # Pilot not authenticated yet
                        guestPerm = self.__conf['MAIN']['guest.permitions'].split(',')
                        guestPerm = filter(None, map(str.strip, guestPerm))
                        if guestPerm.count(theCommandName):
                            return 1
                    console.writeMessage('dont_permition', None, theExecutorName)

            flytimeExecutor = flytimeCommandExecutor(connectionHandler, console)
            showTargetExecutor = ShowTargetCommandExecutor(connectionHandler, console)
            secondTargetExecutor = SecondTargetCommandExecutor(connectionHandler, console)
            winMissionExecutor = WinMissionCommandExecutor(connectionHandler, console, misController)
            allowExecutor = AllowCommandExecutor(connectionHandler, console)
            disallowExecutor = DisallowCommandExecutor(connectionHandler, console)
            pilotExecutor = PilotListCommandExecutor(connectionHandler, console)
            restartExecutor = RestartCommandExecutor(misController)
            targetsExecutor = TargetListCommandExecutor(misController, console, connectionHandler)
            targstatExecutor = TargstatCommandExecutor(connectionHandler, console)
            kickExecutor = KickCommandExecutor(connectionHandler, console)
            banExecutor = BanUserCommandExecutor(console)
            authExecutor = AuthCommandExecutor(connectionHandler, console)
            versionExecutor = VersionCommandExecutor(console)
            timeExecutor = MissionTimeLeft(misController, console)
            gunstatExecutor = GunstatCommandExecutor(tc, console)
            commandChainHandler = CommandChainHandler(\
                                    DaemonSecurityChecker(IniFile(config['MAIN']['permitions'])),
                                    (versionExecutor,\
                                    gunstatExecutor,\
                                    targstatExecutor,\
                                    timeExecutor,\
                                    authExecutor,\
                                    pilotExecutor,\
                                    restartExecutor,\
                                    targetsExecutor,\
                                    kickExecutor,\
                                    banExecutor,
                                    allowExecutor,
                                    disallowExecutor,
                                    secondTargetExecutor,
                                    showTargetExecutor,
                                    winMissionExecutor,
                                    flytimeExecutor))
            
            console.addCommandReceivedListener(CommandListener(commandChainHandler))
            console.addMessageReceivedListener(MessageListener())
            
            logReader.start()
            
            class MissionLoader:
                def start(self):
                    self.__load()
                def loadNextMission(self, theCurrMisLooser):
                    statCollector = misController.getStatisticsCollector()
                    teams = misController.getTeamManager().listTeams()
                    amoutOfTargetsDict = {}
                    planeLossDict = {}
                    teamLossesDict = {}
                    teamOnStartDict = {}
                    for team in teams:
                        loosedPlanes = filter(lambda x: isinstance(x, Plane), statCollector.getLossedObjects(team))
                        planeNames = map(lambda x: x.getPlaneName(), loosedPlanes)
                        planeLossDict[team] = {}
                        for planeName in planeNames:
                            if not planeLossDict[team].has_key(planeName):
                                planeLossDict[team][planeName] = planeNames.count(planeName)
                        _losses = statCollector.getLosses(team)
                        _totals = statCollector.getTotals(team)
                        teamLossesDict[team] = dict(map(lambda x: (x.getName(), _losses[x]), _losses.keys()))
                        teamOnStartDict[team] = dict(map(lambda x: (x.getName(), _totals[x]), _totals.keys()))
                        amoutOfTargetsDict[team] = 1 # TODO
                    ##Added by Solar: New log format
                    ##################################
                    logger.debug('Collecting losses by target types')
                    _blueTotals = statCollector.getBlueTargetTotals()
                    _blueLosses = statCollector.getBlueTargetLosses()
                    _redTotals = statCollector.getRedTargetTotals()
                    _redLosses = statCollector.getRedTargetLosses()
                    targMap = ('wagon','aaa','tank','art','car','ship','sair','other')
                    logSects = ('ab','fa','ft','mt','rt','st')
                    # 
                    def losses_str(lossDict):
                        tmp_arr = []
                        for targ in targMap:
                            if lossDict.has_key(targ):
                                tmp_arr.append(lossDict[targ])
                            else:
                                tmp_arr.append(0)
                        result = ':'.join(map(str,tmp_arr))
                        return  result
                    #
                    log_new_data = []
                    log_new_data.append('[info]')
                    log_new_data.append('MisID %s' % str(misController.getMissionID()))
                    m_teams = teamOnStartDict.keys()
                    m_winner = 'None'
                    if theCurrMisLooser:
                        m_winners = filter(lambda x: x != theCurrMisLooser, m_teams)
                        if len(m_winners):
                            m_winner = m_winners[0].getName()
                    log_new_data.append('Winner ' + m_winner)
                    log_new_data.append('')
                    log_new_data.append('[c&p]')
                    for team in teams:
                        log_new_data.append('%s %s:%s' % (team.getName(), str(teamOnStartDict[team]['craft']), str(teamOnStartDict[team]['pilot'])))
                        log_new_data.append('%sLost %s:%s' % (team.getName(),teamLossesDict[team]['craft'], teamLossesDict[team]['pilot']))                        
                    log_new_data.append('')                    
                    for sect in logSects:
                        logger.debug('Parsing [%s] losses' % sect)                        
                        log_new_data.append('[%s]' % sect)
                        #PARSE BLUE
                        cur_targtype = sect + 'Blue'
                        if _blueTotals.has_key(cur_targtype):
                            log_new_data.append('Blue %s' % losses_str(_blueTotals[cur_targtype]))
                        else:
                            logger.warning('Error while parsing [%s] totals for Blue team' % cur_targtype)
                        if _blueLosses.has_key(cur_targtype):
                            log_new_data.append('BlueLost %s' % losses_str(_blueLosses[cur_targtype]))
                        else:
                            logger.warning('Error while parsing [%s] losses for Blue team' % cur_targtype)
                        #PARSE RED
                        cur_targtype = sect + 'Red'
                        if _redTotals.has_key(cur_targtype):
                            log_new_data.append('Red %s' % losses_str(_redTotals[cur_targtype]))
                        else:
                            logger.warning('Error while parsing [%s] totals for Red team' % cur_targtype)
                        if _redLosses.has_key(cur_targtype):
                            log_new_data.append('RedLost %s' % losses_str(_redLosses[cur_targtype]))
                        else:
                            logger.warning('Error while parsing [%s] losses for Red team' % cur_targtype)
                        log_new_data.append('')
                    log_new_data.append('[plane]')
                    for team in planeLossDict.keys():
                        for lostPlane in planeLossDict[team].keys():
                            log_new_data.append('PlaneLoss%s %s:%s' % (team.getName(), planeLossDict[team][lostPlane], lostPlane))
                    final_log = '\n'.join(log_new_data)
                    logger.debug('Parsing done. Writing down...')                                            
                    log2_new = open(config['FBMission']['gen.dir'] + '/fbd_log.txt', 'w')
                    log2_new.write(final_log)
                    log2_new.close()
                    ## Phew....#######################
                    logger.debug('Running FBMission...')
                    execResult = os.spawnv(os.P_WAIT, config['FBMission']['executable'], ())
                    logger.debug('FBMission finished. Loading mission...')
                    self.__load()
                def __load(self):
                    readconn = kinterbasdb.connect(host=conn_param['Database']['host'],
                        database=conn_param['Database']['path'],
                        user=conn_param['Database']['user'],
                        password=conn_param['Database']['pass'],dialect=1)
                    readcursor = readconn.cursor()
                    readcursor.execute("select first 1 misid from mission order by misid desc")
                    misName = str(readcursor.fetchone())[1:-2]
                    readconn.commit()
                    
                    if not os.path.exists(config['FBMission']['gen.dir'] + '/'+misName+'.mis'):
                        raise Exception('Not found generated mission!')
                    
                    log_src = config['FBMission']['gen.dir'] + '/fbd_log.txt'
                    log_dst = config['FBMission']['gen.dir'] + '/'+misName+ '.txt'
                    
                    #Backing up mission log
                    if os.path.exists(log_src):
                        shutil.copyfile(log_src, log_dst)
                    else:
                        logger.warning('File \'%s\'not found' % log_src)                       
                    iniFile = IniFile(config['FBMission']['gen.dir'] + '/' + misName+'.ini')
                    misController.loadMission(misName, misName + '.mis', misName + '.ini', int(iniFile['MAIN']['mission.time']))
                    logger.debug('Mission loaded')
                
            missionLoader = MissionLoader()
            
            def missionCompleted(theLooser = None):
                class MissionEvListener:
                    def missionStarted(self):
                        pass
                    def missionEnded(self):
                        # Server end the mission, lets load next mission now
                        misEventHandler.removeEventListener(self) # Not forgetting to remove ourselfs
                        missionLoader.loadNextMission(theLooser)
                if theLooser:
                    console.writeMessage('team_lost_mission', theLooser.getName(), None)
                else:
                    console.writeMessage('MISSION ENDED!', None, None)
                misEventHandler.addEventListener(MissionEvListener()) # Wait for server when it end mission
                console.endMission()
                
            misController.addMissionCompletedCallback(missionCompleted)
            
            missionLoader.start()
            
            while logReader.isAlive() and console.isAlive() and tc.isAlive():
                time.sleep(1) # Waiting for eventlog reader
            
        except Exception, detail:
            logger.error('Deamon interrupted!')
            logger.exception('Exception raised: %s' % detail)
    finally:
        logger.info('Stopping deamon...')
        connectionHandler.disconnectAll()
        misController.shutdown()
        dbconn.disconnect()
        logReader.shutdown()
        console.shutdown()
        tc.shutdown()
        logger.info('Deamon stopped')
        
if __name__== "__main__":
    cfg_ini = IniFile('PowerFBDaemon.ini')
    logger.info('Starting daemon...')
    main(cfg_ini)                    
