from daemonLogger import LogFactory
logger = LogFactory.getLogger()

class Command:
    def __init__(self, theExecutorName, theName, theParams = {}):
        self.__executorName = theExecutorName
        self.__name = theName
        self.__params = theParams
        
    def getName(self):
        return self.__name
    
    def getParameters(self):
        return self.__params
    
    def getExecutorName(self):
        return self.__executorName
    

class CommandExecutor:
    '''
    Abstract class to implement real executors
    '''
    def __init__(self, theMyCommand):
        self.__myCommand = theMyCommand
        
    def handle(self, theCommand):
        if self.__myCommand == theCommand.getName():
            self.execute(theCommand.getParameters(), theCommand.getExecutorName())
            return True
    def execute(self, theParams, theExecutor = None):
        # This is abstract method. Always override in concrete classes or you'll get error
        raise NotImplementedError(execute)
    
class SecurityChecker:
    def isAllowed(self, theCommandName, theExecutorName):
        raise NotImplementedError(execute)

class CommandChainHandler:
    def __init__(self, theSecurityChecker, executors):
        self.__executors = ()
        self.__secCheck = theSecurityChecker
        if not(executors is None):
            self.__executors = executors
    
    def handle(self, theCommand):
        if self.__secCheck and self.__secCheck.isAllowed(theCommand.getName(), theCommand.getExecutorName()):
            for executor in self.__executors:
                try:
                    if executor.handle(theCommand): break
                except Exception, detail:
                    logger.exception('Executor %s raised exception: %s' % (str(executor), detail))
