#!/usr/bin/env python
class LogFactory:
    _logger = None
    def getLogger():
        if LogFactory._logger is None:
            import logging
            logging.basicConfig()
            LogFactory._logger = logging.getLogger("Daemon")
            hdlr = logging.FileHandler('daemon.log')
            formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
            hdlr.setFormatter(formatter)
            LogFactory._logger.addHandler(hdlr) 
            LogFactory._logger.setLevel(logging.DEBUG)
        return LogFactory._logger
    getLogger = staticmethod(getLogger)
