import sys, kinterbasdb
from daemonLogger import LogFactory

logger = LogFactory.getLogger()

class KinderbasFacade:
  def __init__(self, theHost, thePath, theUser, thePassword, theDialect):
    self.__host = theHost
    self.__database = thePath
    self.__user = theUser
    self.__password = thePassword
    self.__dialect = theDialect
    self.__dbConn = None

  def connect(self):
    self.__dbConn = kinterbasdb.connect(host=self.__host, \
                      database = self.__database, \
                      user = self.__user,\
                      password = self.__password,\
                      dialect = self.__dialect)
    self.__dbConn2 = kinterbasdb.connect(host=self.__host, \
                      database = self.__database, \
                      user = self.__user,\
                      password = self.__password,\
                      dialect = self.__dialect)    
    logger.info("Connected to database")

  def disconnect(self):
    try:
      self.__dbConn.close()
      self.__dbConn2.close()      
    except Exception:
      pass
    logger.info("Disconnected from database")

  def executeQuery(self, queryString, values = ()):
    if self.__dbConn:
      logger.debug('Executing query [%s] with parameters %s' % (queryString, values))
      cursor = self.__dbConn.cursor()
      cursor.execute(queryString, values)
      rows = cursor.fetchall()
      cursor.close()
      return rows

  def executeUpdate(self, queryString, values = ()):
    if self.__dbConn:
      logger.debug('Executing query (conn1) [%s] with parameters %s' % (queryString, values))
      try:
          cursor = self.__dbConn.cursor()          
          cursor.execute(queryString, values)
          self.__dbConn.commit()
          cursor.close()
      except:
          logger.debug('Got YA!')

  def executeUpdate2(self, queryString, values = ()):
    if self.__dbConn2:
      logger.debug('Executing query (conn2) [%s] with parameters %s' % (queryString, values))
      try:
          cursor = self.__dbConn2.cursor()          
          cursor.execute(queryString, values)
          self.__dbConn2.commit()
          cursor.close()
      except:
          logger.debug('Got YA!')