import re
from UserDict import UserDict
from daemonLogger import LogFactory
logger = LogFactory.getLogger()


class EventHandler:
    '''
    Abstract class to implement real event handlers
    '''
    def __init__(self, theDictOfRegexp):
        self.__rexprs = zip(theDictOfRegexp.keys(), map(re.compile, theDictOfRegexp.values()))
        
    def evaluate(self, theEventLine):
        for key, expr in self.__rexprs:
            if expr.match(theEventLine):
                res = expr.findall(theEventLine)
                return (key, res)
    
    def handle(self, theId, theMatches):
        # This is abstract method. Always override in concrete classes or you'll get error
        raise NotImplementedError(execute)

class EventChainHandler:
    def __init__(self, theEventHandlers = []):
        self.__eventHandlers = [] # todo they should be synchronized
        if not(theEventHandlers is None):
            self.__eventHandlers = theEventHandlers
    
    def addEventHandler(self, theEventHandler):
        if self.__eventHandlers.count(theEventHandler) == 0:
            self.__eventHandlers.append(theEventHandler)
    
    def removeEventHandler(self, theEventHandler):
        if self.__eventHandlers.count(theEventHandler):
            self.__eventHandlers.remove(theEventHandler)
    
    def handleEventLine(self, theEventLine):
        for handler in self.__eventHandlers:
            res = handler.evaluate(theEventLine)
            try:
                if res:
                    handler.handle(res[0], res[1])
                    return None
            except Exception, detail:
                logger.exception('Handler %s raised exception: %s' % (str(handler), detail))
        logger.warning('EventLine:\n\t' + theEventLine + '\nnot handled!')
