from string import find, strip, split
from UserDict import UserDict

class IniFile(UserDict):
    '''
    Author Ivan Luzyanin
    '''
    def __init__(self, theFilename = None):
        UserDict.__init__(self) #Init parent class
        if theFilename:
            txt = open(theFilename).read()
            dict = self.__parse(txt)
            if not(dict is None): self.data = dict
        else:
            self.data = {}
        
    def save(self, theFileName):
        if theFileName is None:
            raise ValueError('FileName cannot be None')
        keys = self.data.keys()
        s = ""
        for sectionName in keys:
            s += "[" + sectionName + "]\n"
            keyValueParts = self.data[sectionName]
            s += "\n".join(["%s %s" % (k,v) for k,v in zip(keyValueParts.keys(), keyValueParts.values())]) + "\n"
        fileObj = open(theFileName, 'w')
        fileObj.write(s)
        fileObj.close()
        
    def __parse(self, theIniText):
        #Parse ini file content
        
        #But define helper functions first
        def listOfValuesToDict(list):
            subSectionKeys = map(lambda li: li[0], list)
            subSectionValues = map(lambda li: li[1], list)
            zipped = zip(subSectionKeys, subSectionValues)
            res = {}
            for item in zipped:
                if not res.has_key(item[0]):
                    res[item[0]] = item[1]
                else:
                    value = res[item[0]]
                    if not type(value) == type([]):
                        res[item[0]] = [value]
                    res[item[0]].append(item[1])
            return res
        
        def stripComments(s):
            return s[0] != ';'
        
        def parseValue(s): # value -> pair
            s = strip(s)
            pos = find(s, " ")
            if pos == -1:
                return (s, '') #Only the key without value
            curField = s[0:pos].strip()
            curData = s[pos + 1:].strip()
            return (curField, curData)      
        
        def parseSector(section):
            sectName, sectBody = split(section,']') # identify name, body
            values = split(sectBody,'\n')           # find assign lines
            values = filter(strip, values)          # remove outside space
            values = filter(None, values)           # remove empty lines
            values = filter(stripComments, values)  # remove comment lines
            values = map(parseValue, values)        # make name/val pairs
            fieldsDict = listOfValuesToDict(values) # create dictionary instead of value pair list
            return (sectName, fieldsDict)
        
        #Start parsing
        sects = split(theIniText,'[')         # divide named sects
        sects = map(strip, sects)             # remove outside newlines
        sects = filter(None, sects)           # remove empty sectors
        config = map(parseSector, sects)      # parse sector and find key/value parts
        return listOfValuesToDict(config)     # return dictionary instead of value pair ilst
#config = IniFile('D:\\Games\\IL2 DS\\Missions\\Net\\dogfight\\daemon\\test.mis')