import telnetlib, re, time
from threading import Thread, Condition
from daemonLogger import LogFactory
logger = LogFactory.getLogger()

class DataReceiver:
    def isSutisfied(self):
        raise NotImplementedError(self.isSutisfied)
    def dataReceived(self, theString):
        raise NotImplementedError(self.received)

class TelnetCommunicator(Thread):
    def __init__(self, host, port):
        self.__host = host
        self.__port = port
        
        self.__shouldStop = False
        self.__connected = False
        
        self.__chatBufferC = Condition()
        self.__buffer = []
        
        self.__tnC = Condition()
        self.__tn = None
        
        Thread.__init__(self)
        
        self.__connect()
        
    def __connect(self):
        self.__tn = telnetlib.Telnet()
        self.__tn.open(self.__host, self.__port)
        self.__connected = True
        
    def __disconnect(self):
        if self.__connected:
            self.__connected = False
            self.__tn.close()
        
    def shutdown(self):
        self.__shouldStop = True
        
    def isDataAvailable(self):
        self.__chatBufferC.acquire()
        res = len(self.__buffer)
        self.__chatBufferC.release()
        return res
        
    def writeAndWaitFor(self, theString, theCompiledRegexp):
        if self.__connected:
            self.__tnC.acquire()
            self.__tn.write(theString + '\n')
            s = ''
            while not theCompiledRegexp.search(s):
                s = self.__tn.read_until('\n', 1)  # Wait 1 second for new data
                if s is None or len(s) == 0:
                    logger.debug('Timeout')
                    break
            #res = self.__tn.expect((theCompiledRegexp,), 0.5)
            self.__tnC.release()
            if s and len(s) > 0:
                return s
        else:
            raise IOError('Telnet communicator not connected')
        
    def writeAndWaitUntilSatisfy(self, theString, theDataReceiver):
        if self.__connected:
            self.__tnC.acquire()
            self.__tn.write(theString + '\n')
            while not(theDataReceiver.isSutisfied()):
                s = self.__tn.read_until('\n', 0.5)  # Wait 0.5 second for new data
                if s is None or len(s) == 0:
                    logger.debug('Timeout')
                    break
                satisfied = theDataReceiver.dataReceived(s)
            self.__tnC.release()
            if not(theDataReceiver.isSutisfied()):
                logger.warning('DataReceiver left unsatisfied')
        else:
            raise IOError('Telnet communicator not connected')
        
    def write(self, theLine):
        if self.__connected:
            self.__tnC.acquire()
            self.__tn.write(theLine + '\n')
            self.__tnC.release()
        else:
            raise IOError('Telnet communicator not connected')
        
    def read(self):
        if len(self.__buffer) > 0:
            self.__chatBufferC.acquire()
            res = self.__buffer.pop(0)
            self.__chatBufferC.release()
            return res
        
    def run(self):
        try:
            while not(self.__shouldStop):
                try:
                    self.__tnC.acquire()                 # Lock access to telnet
                    s = self.__tn.read_until('\n', 0.2)  # Wait 0.2 second for new data
                    self.__tnC.release()                 # Unlock access to telnet
                    
                    if not(s is None) and len(s) > 0:
                        self.__chatBufferC.acquire()     # Lock access to buffer
                        if len(self.__buffer) > 200:     # Check buffer length
                            self.__buffer = []           # Buffer is too big. Clear buffer.
                            logger.warning('Buffer overrun! Cleaned.')
                        self.__buffer.append(s)          # Adding received data to buffer
                        self.__chatBufferC.release()     # Unlock access to buffer
                except Exception, detail:
                    logger.exception('Exception raised: %s' % detail)
                    break
            self.__disconnect()                           # Close connection
        except Exception, detail:
            logger.exception('Exception raised: %s' % detail)
        logger.info('Telnet communicator stopped')
