// =============================================================================

	  protected boolean doFocusEnter() 
	  {
	    if(super.doFocusEnter()) 
	    {
	      HookPilot hook = HookPilot.current;
	      hook.doAim(false);
	/*MW 6DoF BEGIN*/
	      Point3d p3d = new Point3d();
	      p3d.set(0.24F, -0.05F, -0.03F);
	      hook.setTubeSight(p3d);
	/*MW 6DoF END*/
	      return true;
	    }else {
	      return false;
	    }
	  }
	  
	  protected void    doFocusLeave() 
	  {
	    if(!isFocused()) return;
	    leave();
	    super.doFocusLeave();
	  }

// =============================================================================

	  private float   saveFov;
	  private boolean bEntered = false;

	  private void prepareToEnter()
	  {
	    HookPilot hook = HookPilot.current;
	    if(hook.isPadlock())
	      hook.stopPadlock();
	    hook.doAim(true);
	    hook.setSimpleAimOrient(0F, 0F, 0F);
	    enteringAim = true;
	  }
	  
	  private void enter() 
	  {
	    HookPilot hook = HookPilot.current;
	    hook.setSimpleUse(true);
	    doSetSimpleUse(true);
	    HotKeyEnv.enable("PanView",false);
	    HotKeyEnv.enable("SnapView",false);    
	  }
	  
	  public void doSetSimpleUse(boolean simple) //Viikate
	  {
		  super.doSetSimpleUse(simple);
		  if (simple)
		  {
			  saveFov = Main3D.FOVX;
			  CmdEnv.top().exec("fov 31");
			  Main3D.cur3D().aircraftHotKeys.setEnableChangeFov(false);
			  bEntered = true;
			  mesh.chunkVisible("SuperReticle", true);		  
		  }
	  }
	  
	  private void leave() 
	  {
	    if(enteringAim)
	    {
	      HookPilot hook = HookPilot.current;
	      hook.doAim(false);
	      hook.setSimpleAimOrient(0.0f, 0.0f, 0.0f);
	      return;
	    }
	    
	    if(!bEntered) return;
	    Main3D.cur3D().aircraftHotKeys.setEnableChangeFov(true);
	    CmdEnv.top().exec("fov "+saveFov);
	    HookPilot hook = HookPilot.current;
	    hook.doAim(false);
	    hook.setSimpleAimOrient(0.0f, 0.0f, 0.0f);
	    hook.setSimpleUse(false);
	    doSetSimpleUse(false);
	    boolean bEnable = HotKeyEnv.isEnabled("aircraftView");
	    HotKeyEnv.enable("PanView", bEnable);
	    HotKeyEnv.enable("SnapView", bEnable);
	    bEntered = false;
	    mesh.chunkVisible("SuperReticle", false);
	  }
	  
	  public void destroy() 
	  {
	    leave();
	    super.destroy();
	  }

	  public void doToggleAim( boolean bToggleAim ) 
	  {
	    if(!isFocused()) return;
	    if(isToggleAim() == bToggleAim) return;
	    if(bToggleAim) prepareToEnter();
	    else           leave();
	  }
	  
// =============================================================================