/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;

public abstract class MidiMessage
implements Cloneable {
    protected byte[] data;
    protected int length = 0;

    protected MidiMessage(byte[] byArray) {
        this.data = byArray;
        this.length = byArray.length;
    }

    protected void setMessage(byte[] byArray, int n) throws InvalidMidiDataException {
        this.length = n;
        if (this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        System.arraycopy(byArray, 0, this.data, 0, n);
    }

    public byte[] getMessage() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        return byArray;
    }

    public int getStatus() {
        int n = 0;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data, 0, this.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            n = dataInputStream.readUnsignedByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public int getLength() {
        return this.length;
    }

    public abstract Object clone();
}

