/*
 * Decompiled with CFR 0.152.
 */
package com.maddox.rts;

import com.maddox.rts.Compress;
import com.maddox.util.HashMapExt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InOutStreams {
    private RandomAccessFile randomAccessFile;
    private InputStream inputFile;
    private OutputStream outputFile;
    private long outputOffset;
    private Header header;
    private Tailer tailer;
    private ArrayList indexLst;
    private HashMapExt entryHash;
    private HashMapExt entryNewHash;
    private Block listBlocks = null;
    private int readCacheSize = 32768;

    private void freeResorces() {
        this.header = null;
        this.tailer = null;
        this.indexLst.clear();
        this.indexLst = null;
        this.entryHash.clear();
        this.entryHash = null;
        while (this.listBlocks != null) {
            Block block = this.listBlocks;
            this.listBlocks = block.next;
            block.next = null;
        }
        if (this.entryNewHash != null) {
            this.entryNewHash.clear();
            this.entryNewHash = null;
        }
    }

    private void readBlock(Entry entry, int n, byte[] byArray) throws IOException {
        this.inputFile.reset();
        this.inputFile.mark(this.inputFile.available());
        IndexEntry indexEntry = (IndexEntry)this.indexLst.get(entry.index[n]);
        this.inputFile.skip(indexEntry.offsetInFile);
        this.inputFile.read(byArray, 0, indexEntry.lenInFile);
        int n2 = this.header.blockSize;
        if (this.header.blockSize * (n + 1) > entry.len) {
            n2 = entry.len % this.header.blockSize;
        }
        if (this.header.compressMethod != 0 && n2 > indexEntry.lenInFile) {
            Compress.decode(this.header.compressMethod, byArray, indexEntry.lenInFile);
        }
    }

    /*
     * Unable to fully structure code
     */
    private byte[] getBlock(Entry var1_1, int var2_2) throws IOException {
        block5: {
            var3_3 = this.listBlocks;
            var4_4 = null;
            if (var3_3 != null) ** GOTO lbl19
            var5_5 = this.readCacheSize / this.header.blockSize;
            if (var5_5 < 1) {
                var5_5 = 1;
            }
            var6_6 = 0;
            while (var6_6 < var5_5) {
                var3_3 = new Block();
                var3_3.buf = new byte[this.header.blockSize];
                var3_3.next = this.listBlocks;
                this.listBlocks = var3_3;
                ++var6_6;
            }
            break block5;
            while (var3_3.entry != var1_1 || var3_3.index != var2_2) {
                var4_4 = var3_3;
                var3_3 = var3_3.next;
lbl19:
                // 2 sources

                if (var3_3.next != null) continue;
            }
            if (var4_4 != null) {
                var4_4.next = var3_3.next;
                var3_3.next = this.listBlocks;
                this.listBlocks = var3_3;
            }
        }
        if (var3_3.entry != var1_1 || var3_3.index != var2_2) {
            this.readBlock(var1_1, var2_2, var3_3.buf);
            var3_3.entry = var1_1;
            var3_3.index = var2_2;
        }
        return var3_3.buf;
    }

    public InputStream openStream(String string) {
        Entry entry = (Entry)this.entryHash.get(string);
        if (entry == null) {
            return null;
        }
        return new InputStreamThread(entry);
    }

    public OutputStream createStream(String string) throws IOException {
        return new OutputStreamThread(string);
    }

    public void getEntryNames(List list) {
        if (list == null) {
            return;
        }
        if (this.entryHash == null) {
            return;
        }
        Map.Entry entry = this.entryHash.nextEntry(null);
        while (entry != null) {
            list.add(entry.getKey());
            entry = this.entryHash.nextEntry(entry);
        }
    }

    private void outputFlush() throws IOException {
        Object object;
        OutputStream outputStream;
        Map.Entry entry = this.entryNewHash.nextEntry(null);
        while (entry != null) {
            outputStream = (OutputStreamThread)entry.getValue();
            ((OutputStreamThread)outputStream)._close();
            entry = this.entryNewHash.nextEntry(entry);
        }
        this.entryNewHash.clear();
        outputStream = new DataOutputStream(this.outputFile);
        this.tailer = new Tailer();
        int n = this.indexLst.size();
        int n2 = 0;
        while (n2 < n) {
            object = (IndexEntry)this.indexLst.get(n2);
            ((DataOutputStream)outputStream).writeInt(((IndexEntry)object).lenInFile);
            ++n2;
        }
        this.tailer.indexesSizeInFile = n * IndexEntry.sizeInFile();
        this.tailer.entrysSizeInFile = ((DataOutputStream)outputStream).size();
        entry = this.entryHash.nextEntry(null);
        while (entry != null) {
            object = (Entry)entry.getValue();
            ((DataOutputStream)outputStream).writeUTF(((Entry)object).name);
            ((DataOutputStream)outputStream).writeInt(((Entry)object).len);
            ((DataOutputStream)outputStream).writeInt(((Entry)object).index.length);
            int n3 = 0;
            while (n3 < ((Entry)object).index.length) {
                ((DataOutputStream)outputStream).writeInt(((Entry)object).index[n3]);
                ++n3;
            }
            entry = this.entryHash.nextEntry(entry);
        }
        this.tailer.entrysSizeInFile = ((DataOutputStream)outputStream).size() - this.tailer.entrysSizeInFile;
        ((DataOutputStream)outputStream).writeInt(this.tailer.indexesSizeInFile);
        ((DataOutputStream)outputStream).writeInt(this.tailer.entrysSizeInFile);
        ((DataOutputStream)outputStream).flush();
    }

    private void open() throws IOException {
        Object object;
        DataInputStream dataInputStream = new DataInputStream(this.inputFile);
        this.header = new Header();
        this.header.signature = dataInputStream.readInt();
        if (this.header.signature != 1245391901) {
            throw new IOException("File corrupted: bad signature");
        }
        this.header.version = dataInputStream.readInt();
        if (this.header.version != 101) {
            throw new IOException("File corrupted: unknown version");
        }
        this.header.compressMethod = dataInputStream.readInt();
        if (this.header.compressMethod < 0 || this.header.compressMethod > 2) {
            throw new IOException("File corrupted: unknown compression method");
        }
        this.header.blockSize = dataInputStream.readInt();
        if (this.header.blockSize < 2048 || this.header.blockSize > 131072) {
            throw new IOException("File corrupted: bad block size");
        }
        this.inputFile.mark(this.inputFile.available());
        this.inputFile.skip(this.inputFile.available() - Tailer.sizeInFile());
        this.tailer = new Tailer();
        this.tailer.indexesSizeInFile = dataInputStream.readInt();
        this.tailer.entrysSizeInFile = dataInputStream.readInt();
        this.inputFile.reset();
        this.inputFile.mark(this.inputFile.available());
        this.inputFile.skip(this.inputFile.available() - Tailer.sizeInFile() - this.tailer.entrysSizeInFile - this.tailer.indexesSizeInFile);
        int n = this.tailer.indexesSizeInFile / IndexEntry.sizeInFile();
        this.indexLst = new ArrayList(n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            object = new IndexEntry();
            ((IndexEntry)object).offsetInFile = n2;
            ((IndexEntry)object).lenInFile = dataInputStream.readInt();
            n2 += ((IndexEntry)object).lenInFile;
            this.indexLst.add(object);
            ++n3;
        }
        this.entryHash = new HashMapExt();
        while (this.inputFile.available() > Tailer.sizeInFile()) {
            object = new Entry();
            ((Entry)object).name = dataInputStream.readUTF();
            ((Entry)object).len = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            ((Entry)object).index = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                ((Entry)object).index[n5] = dataInputStream.readInt();
                ++n5;
            }
            this.entryHash.put(((Entry)object).name, object);
        }
    }

    private void create(int n, int n2) throws IOException {
        if (n < 0 || n > 2) {
            throw new IOException("unknown compression method");
        }
        if (n2 < 2048 || n2 > 131072) {
            throw new IOException("bad block size");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(this.outputFile);
        this.header = new Header();
        this.header.signature = 1245391901;
        this.header.version = 101;
        this.header.compressMethod = n;
        this.header.blockSize = n2;
        dataOutputStream.writeInt(this.header.signature);
        dataOutputStream.writeInt(this.header.version);
        dataOutputStream.writeInt(this.header.compressMethod);
        dataOutputStream.writeInt(this.header.blockSize);
        dataOutputStream.flush();
        this.outputOffset = 0L;
        this.indexLst = new ArrayList();
        this.entryHash = new HashMapExt();
        this.entryNewHash = new HashMapExt();
    }

    public void open(InputStream inputStream) throws IOException {
        if (this.randomAccessFile != null || this.inputFile != null || this.outputFile != null) {
            throw new IOException("file alredy opened");
        }
        if (!inputStream.markSupported()) {
            throw new IOException("inputFile mark/reset not supported");
        }
        this.inputFile = inputStream;
        this.open();
    }

    public void create(OutputStream outputStream, int n, int n2) throws IOException {
        if (this.randomAccessFile != null || this.inputFile != null || this.outputFile != null) {
            throw new IOException("file alredy opened");
        }
        this.outputFile = outputStream;
        this.create(n, n2);
    }

    public void create(OutputStream outputStream) throws IOException {
        this.create(outputStream, 2, 32768);
    }

    public void open(File file, boolean bl) throws IOException {
        if (this.randomAccessFile != null || this.inputFile != null || this.outputFile != null) {
            throw new IOException("file alredy opened");
        }
        if (bl) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            if (randomAccessFile.length() == 0L) {
                OutputStreamOfRandomAccessFile outputStreamOfRandomAccessFile = new OutputStreamOfRandomAccessFile(randomAccessFile);
                this.create(outputStreamOfRandomAccessFile);
            } else {
                InputStreamOfRandomAccessFile inputStreamOfRandomAccessFile = new InputStreamOfRandomAccessFile(randomAccessFile);
                this.open(inputStreamOfRandomAccessFile);
                randomAccessFile.seek(randomAccessFile.length() - (long)Tailer.sizeInFile() - (long)this.tailer.entrysSizeInFile - (long)this.tailer.indexesSizeInFile);
                this.outputFile = new OutputStreamOfRandomAccessFile(randomAccessFile);
                this.outputOffset = randomAccessFile.length() - (long)Header.sizeInFile() - (long)Tailer.sizeInFile() - (long)this.tailer.entrysSizeInFile - (long)this.tailer.indexesSizeInFile;
                this.entryNewHash = new HashMapExt();
            }
            this.randomAccessFile = randomAccessFile;
        } else {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            InputStreamOfRandomAccessFile inputStreamOfRandomAccessFile = new InputStreamOfRandomAccessFile(randomAccessFile);
            this.open(inputStreamOfRandomAccessFile);
            this.randomAccessFile = randomAccessFile;
        }
    }

    public void close() throws IOException {
        if (this.randomAccessFile == null && this.inputFile == null && this.outputFile == null) {
            return;
        }
        if (this.randomAccessFile != null) {
            if (this.outputFile != null) {
                this.outputFlush();
            }
            this.randomAccessFile.close();
        } else if (this.outputFile != null) {
            this.outputFlush();
            this.outputFile.close();
        } else {
            this.inputFile.close();
        }
        this.randomAccessFile = null;
        this.inputFile = null;
        this.outputFile = null;
        this.freeResorces();
    }

    static class OutputStreamOfRandomAccessFile
    extends OutputStream {
        private RandomAccessFile file;
        private long curPos;

        public void write(int n) throws IOException {
            this.file.seek(this.curPos);
            this.file.write(n);
            ++this.curPos;
        }

        public void write(byte[] byArray) throws IOException {
            this.file.seek(this.curPos);
            this.file.write(byArray);
            this.curPos += (long)byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.file.seek(this.curPos);
            this.file.write(byArray, n, n2);
            this.curPos += (long)n2;
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            this.file.close();
        }

        public OutputStreamOfRandomAccessFile(RandomAccessFile randomAccessFile) throws IOException {
            this.file = randomAccessFile;
            this.curPos = randomAccessFile.getFilePointer();
        }
    }

    static class InputStreamOfRandomAccessFile
    extends InputStream {
        private RandomAccessFile file;
        private long curPos;
        private long markPos;

        public int read() throws IOException {
            this.file.seek(this.curPos);
            int n = this.file.read();
            if (n >= 0) {
                ++this.curPos;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.file.seek(this.curPos);
            int n3 = this.file.read(byArray, n, n2);
            if (n3 >= 0) {
                this.curPos += (long)n3;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = this.file.length() - this.curPos;
            if (l > l2) {
                l = l2;
            }
            this.curPos += l;
            return l;
        }

        public int available() throws IOException {
            return (int)(this.file.length() - this.curPos);
        }

        public void reset() throws IOException {
            if (this.markPos < 0L) {
                throw new IOException("Method mark() not invoked");
            }
            this.curPos = this.markPos;
            this.markPos = -1L;
        }

        public void mark(int n) {
            this.markPos = this.curPos;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            this.file.close();
        }

        public InputStreamOfRandomAccessFile(RandomAccessFile randomAccessFile) {
            this.file = randomAccessFile;
            this.curPos = 0L;
            this.markPos = -1L;
        }
    }

    class OutputStreamThread
    extends OutputStream {
        public String name;
        public int len;
        public ArrayList index;
        public byte[] buf;

        private void flushBlock(boolean bl) throws IOException {
            int n = bl ? ((InOutStreams)InOutStreams.this).header.blockSize : this.len % ((InOutStreams)InOutStreams.this).header.blockSize;
            int n2 = Compress.code(((InOutStreams)InOutStreams.this).header.compressMethod, this.buf, n);
            IndexEntry indexEntry = new IndexEntry();
            indexEntry.offsetInFile = (int)InOutStreams.this.outputOffset;
            indexEntry.lenInFile = n2;
            InOutStreams.this.outputFile.write(this.buf, 0, n2);
            InOutStreams.this.outputOffset += n2;
            InOutStreams.this.indexLst.add(indexEntry);
            this.index.add(new Integer(InOutStreams.this.indexLst.size() - 1));
        }

        public void write(int n) throws IOException {
            this.buf[this.len % ((InOutStreams)InOutStreams.this).header.blockSize] = (byte)n;
            ++this.len;
            if (this.len % ((InOutStreams)InOutStreams.this).header.blockSize == 0) {
                this.flushBlock(true);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            int n3 = this.len % ((InOutStreams)InOutStreams.this).header.blockSize;
            while (n2 > 0) {
                int n4 = n2;
                int n5 = ((InOutStreams)InOutStreams.this).header.blockSize - n3;
                if (n4 > n5) {
                    n4 = n5;
                }
                System.arraycopy(byArray, n, this.buf, n3, n4);
                n2 -= n4;
                n += n4;
                this.len += n4;
                n3 = this.len % ((InOutStreams)InOutStreams.this).header.blockSize;
                if (n3 != 0) continue;
                this.flushBlock(true);
            }
        }

        public void flush() throws IOException {
        }

        public void _close() throws IOException {
            if (this.len % ((InOutStreams)InOutStreams.this).header.blockSize != 0) {
                this.flushBlock(false);
            }
            Entry entry = new Entry();
            entry.name = this.name;
            entry.len = this.len;
            int n = this.index.size();
            entry.index = new int[n];
            int n2 = 0;
            while (n2 < n) {
                entry.index[n2] = (Integer)this.index.get(n2);
                ++n2;
            }
            InOutStreams.this.entryHash.put(this.name, entry);
        }

        public void close() throws IOException {
            this._close();
            InOutStreams.this.entryNewHash.remove(this.name);
            this.buf = null;
        }

        public OutputStreamThread(String string) throws IOException {
            if (InOutStreams.this.entryNewHash.containsKey(string)) {
                throw new IOException("Stream '" + string + "' alredy creating");
            }
            this.name = string;
            this.len = 0;
            this.index = new ArrayList();
            this.buf = new byte[((InOutStreams)InOutStreams.this).header.blockSize];
            InOutStreams.this.entryNewHash.put(this.name, this);
        }
    }

    class InputStreamThread
    extends InputStream {
        public Entry entry;
        public int curPos;
        public int markPos;

        public int read() throws IOException {
            if (this.curPos >= this.entry.len) {
                return -1;
            }
            byte[] byArray = InOutStreams.this.getBlock(this.entry, this.curPos / ((InOutStreams)InOutStreams.this).header.blockSize);
            byte by = byArray[this.curPos % ((InOutStreams)InOutStreams.this).header.blockSize];
            ++this.curPos;
            return by & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.curPos >= this.entry.len) {
                return -1;
            }
            if (n2 > this.entry.len - this.curPos) {
                n2 = this.entry.len - this.curPos;
            }
            int n3 = n2;
            int n4 = this.curPos % ((InOutStreams)InOutStreams.this).header.blockSize;
            while (n2 > 0) {
                byte[] byArray2 = InOutStreams.this.getBlock(this.entry, this.curPos / ((InOutStreams)InOutStreams.this).header.blockSize);
                int n5 = n2;
                if (n5 > ((InOutStreams)InOutStreams.this).header.blockSize - n4) {
                    n5 = ((InOutStreams)InOutStreams.this).header.blockSize - n4;
                }
                System.arraycopy(byArray2, n4, byArray, n, n5);
                n += n5;
                n2 -= n5;
                this.curPos += n5;
                n4 = 0;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = this.entry.len - this.curPos;
            if (l > l2) {
                l = l2;
            }
            this.curPos += (int)l;
            return l;
        }

        public int available() throws IOException {
            if (this.entry == null) {
                return 0;
            }
            return this.entry.len - this.curPos;
        }

        public void reset() throws IOException {
            if (this.markPos < 0) {
                throw new IOException("Method mark() not invoked");
            }
            this.curPos = this.markPos;
            this.markPos = -1;
        }

        public void mark(int n) {
            this.markPos = this.curPos;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            this.entry = null;
        }

        public InputStreamThread(Entry entry) {
            this.entry = entry;
            this.curPos = 0;
            this.markPos = -1;
        }
    }

    static class Block {
        public Block next;
        public Entry entry;
        public int index = -1;
        public byte[] buf;

        Block() {
        }
    }

    static class Entry {
        public String name;
        public int len;
        public int[] index;

        Entry() {
        }
    }

    static class IndexEntry {
        public int offsetInFile;
        public int lenInFile;

        IndexEntry() {
        }

        public static int sizeInFile() {
            return 4;
        }
    }

    static class Tailer {
        public int indexesSizeInFile;
        public int entrysSizeInFile;

        Tailer() {
        }

        public static int sizeInFile() {
            return 8;
        }
    }

    static class Header {
        public int signature;
        public int version;
        public int compressMethod;
        public int blockSize;

        Header() {
        }

        public static int sizeInFile() {
            return 16;
        }
    }
}

