/*
 * Decompiled with CFR 0.152.
 */
package com.maddox.rts;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KryptoInputFilter
extends FilterInputStream {
    private int[] key = new int[]{255, 170};
    private int sw = 0;

    public KryptoInputFilter(InputStream inputStream, int[] nArray) {
        super(inputStream);
        this.key = nArray;
        if (nArray != null && nArray.length == 0) {
            this.key = null;
        }
        this.sw = 0;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (this.key == null) {
            return n;
        }
        this.sw = (this.sw + 1) % this.key.length;
        if (n != -1) {
            n ^= this.key[this.sw];
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (this.key == null || n3 <= 0) {
            return n3;
        }
        int n4 = 0;
        while (n4 < n3) {
            this.sw = (this.sw + 1) % this.key.length;
            byArray[n + n4] = (byte)(byArray[n + n4] ^ this.key[this.sw]);
            ++n4;
        }
        return n3;
    }
}

