/*
 * Decompiled with CFR 0.152.
 */
package com.maddox.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMapExt
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static int _entryHash = 0;
    private transient Entry head;
    private transient Entry tail;
    private transient int nextEntryLock;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private Entry freeEntryList = null;

    public HashMapExt(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
        this.head = this.allocEntry(_entryHash++, null, null, null);
        this.head.lNext = this.tail = this.allocEntry(0, null, null, null);
        this.tail.lPrev = this.head;
    }

    public HashMapExt() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int hashCode() {
        return this.head.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public Map.Entry nextEntry(Map.Entry entry) {
        if (this.count == 0) {
            return null;
        }
        Entry entry2 = (Entry)entry;
        if (entry2 == null) {
            this.nextEntryLock = this.modCount;
            entry2 = this.head.lNext;
        } else {
            if (this.modCount != this.nextEntryLock) {
                throw new ConcurrentModificationException();
            }
            entry2 = entry2.lNext;
        }
        if (entry2 == this.tail) {
            return null;
        }
        return entry2;
    }

    /*
     * Unable to fully structure code
     */
    public boolean containsValue(Object var1_1) {
        block4: {
            var2_2 = this.head.lNext;
            if (var1_1 != null) ** GOTO lbl12
            while (var2_2 != this.tail) {
                if (var2_2.value == null) {
                    return true;
                }
                var2_2 = var2_2.lNext;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (var1_1.equals(var2_2.value)) {
                    return true;
                }
                var2_2 = var2_2.lNext;
lbl12:
                // 2 sources

                ** while (var2_2 != this.tail)
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        if (object != null) {
            Entry[] entryArray = this.table;
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.head.lNext;
            while (entry != this.tail) {
                if (entry.key == null) {
                    return true;
                }
                entry = entry.lNext;
            }
        }
        return false;
    }

    public Object get(Object object) {
        if (object != null) {
            Entry[] entryArray = this.table;
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    return entry.value;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.head.lNext;
            while (entry != this.tail) {
                if (entry.key == null) {
                    return entry.value;
                }
                entry = entry.lNext;
            }
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length * 2 + 1;
        Entry[] entryArray = new Entry[n];
        ++this.modCount;
        this.threshold = (int)((float)n * this.loadFactor);
        this.table = entryArray;
        Entry entry = this.head.lNext;
        while (entry != this.tail) {
            int n2 = (entry.hash & Integer.MAX_VALUE) % n;
            entry.next = entryArray[n2];
            entryArray[n2] = entry;
            entry = entry.lNext;
        }
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = object.hashCode();
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    Object object3 = entry.value;
                    entry.value = object2;
                    return object3;
                }
                entry = entry.next;
            }
        } else {
            entry = this.head.lNext;
            while (entry != this.tail) {
                if (entry.key == null) {
                    Object object4 = entry.value;
                    entry.value = object2;
                    return object4;
                }
                entry = entry.lNext;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = this.allocEntry(n, object, object2, entryArray[n2]);
        entry.lPrev = this.head;
        entry.lNext = this.head.lNext;
        entry.lNext.lPrev = entry;
        this.head.lNext = entry;
        entryArray[n2] = entry;
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    ++this.modCount;
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                    Object object2 = entry.value;
                    this.freeEntry(entry);
                    return object2;
                }
                entry2 = entry;
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            Entry entry3 = null;
            while (entry != null) {
                if (entry.key == null) {
                    ++this.modCount;
                    if (entry3 != null) {
                        entry3.next = entry.next;
                    } else {
                        entryArray[0] = entry.next;
                    }
                    --this.count;
                    Object object3 = entry.value;
                    this.freeEntry(entry);
                    return object3;
                }
                entry3 = entry;
                entry = entry.next;
            }
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        Entry[] entryArray;
        if (this.count == 0) {
            return;
        }
        ++this.modCount;
        Object object = this.head.lNext;
        while (object != this.tail) {
            entryArray = object;
            object = entryArray.lNext;
            this.freeEntry((Entry)entryArray);
        }
        entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            HashMapExt hashMapExt = (HashMapExt)super.clone();
            hashMapExt.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                hashMapExt.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
                Entry entry = hashMapExt.table[n];
                while (entry != null) {
                    entry.lPrev = hashMapExt.head;
                    entry.lNext = hashMapExt.head.lNext;
                    entry.lNext.lPrev = entry;
                    hashMapExt.head.lNext = entry;
                    entry = entry.next;
                }
            }
            hashMapExt.keySet = null;
            hashMapExt.entrySet = null;
            hashMapExt.values = null;
            hashMapExt.modCount = 0;
            return hashMapExt;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new HashIterator(0);
                }

                public int size() {
                    return HashMapExt.this.count;
                }

                public boolean contains(Object object) {
                    return HashMapExt.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    return HashMapExt.this.remove(object) != null;
                }

                public void clear() {
                    HashMapExt.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return new HashIterator(1);
                }

                public int size() {
                    return HashMapExt.this.count;
                }

                public boolean contains(Object object) {
                    return HashMapExt.this.containsValue(object);
                }

                public void clear() {
                    HashMapExt.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new HashIterator(2);
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = HashMapExt.this.table;
                    int n = k == null ? 0 : k.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            return true;
                        }
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = HashMapExt.this.table;
                    int n = k == null ? 0 : k.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    Entry entry3 = null;
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            HashMapExt.this.modCount++;
                            if (entry3 != null) {
                                entry3.next = entry2.next;
                            } else {
                                entryArray[n2] = entry2.next;
                            }
                            HashMapExt.this.count--;
                            HashMapExt.this.freeEntry(entry2);
                            return true;
                        }
                        entry3 = entry2;
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public int size() {
                    return HashMapExt.this.count;
                }

                public void clear() {
                    HashMapExt.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private Entry allocEntry(int n, Object object, Object object2, Entry entry) {
        if (this.freeEntryList == null) {
            return new Entry(n, object, object2, entry);
        }
        Entry entry2 = this.freeEntryList;
        this.freeEntryList = this.freeEntryList.next;
        entry2.hash = n;
        entry2.key = object;
        entry2.value = object2;
        entry2.next = entry;
        return entry2;
    }

    private void freeEntry(Entry entry) {
        entry.key = null;
        entry.value = null;
        entry.next = this.freeEntryList;
        this.freeEntryList = entry;
        entry.lPrev.lNext = entry.lNext;
        entry.lNext.lPrev = entry.lPrev;
        entry.lPrev = null;
        entry.lNext = null;
    }

    private class HashIterator
    implements Iterator {
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int n) {
            this.entry = HashMapExt.this.head;
            this.lastReturned = null;
            this.expectedModCount = HashMapExt.this.modCount;
            this.type = n;
        }

        public boolean hasNext() {
            return this.entry.lNext != HashMapExt.this.tail;
        }

        public Object next() {
            if (HashMapExt.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.entry.lNext == HashMapExt.this.tail) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry = this.entry.lNext;
            return this.type == 0 ? this.entry.key : (this.type == 1 ? this.entry.value : this.entry);
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (HashMapExt.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = HashMapExt.this.table;
            int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturned) {
                    HashMapExt.this.modCount++;
                    ++this.expectedModCount;
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    HashMapExt.this.count--;
                    this.lastReturned = null;
                    this.entry = entry.lPrev;
                    HashMapExt.this.freeEntry(entry);
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;
        Entry lNext;
        Entry lPrev;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }
}

