package com.maddox.il2.objects.air;

import com.maddox.JGP.Tuple3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.game.AircraftHotKeys;
import com.maddox.il2.objects.sounds.SndAircraft;
import com.maddox.il2.objects.Wreckage;
import com.maddox.rts.Property;

public class BF_109G2 extends BF_109Gx
    implements TypeBNZFighter
{

    public BF_109G2()
    {
        maxSpeedForOpeningCanopyRandomFactor = 1.0F;
        cockpitDoor_ = 0.0F;
        bHasBlister = true;
        kangle = 0.0F;
        maxSpeedForOpeningCanopyRandomFactor = World.Rnd().nextFloat(0.89F, 1.04F);
    }

    public void update(float f)
    {
        afterburnerhud();
        super.update(f);
        if(super.FM.getSpeed() > 5F)
        {
            hierMesh().chunkSetAngles("SlatL_D0", 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F), 0.0F);
            hierMesh().chunkSetAngles("SlatR_D0", 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F), 0.0F);
        }
        hierMesh().chunkSetAngles("Flap01L_D0", 0.0F, -16F * kangle, 0.0F);
        hierMesh().chunkSetAngles("Flap01U_D0", 0.0F, 16F * kangle, 0.0F);
        hierMesh().chunkSetAngles("Flap02L_D0", 0.0F, -16F * kangle, 0.0F);
        hierMesh().chunkSetAngles("Flap02U_D0", 0.0F, 16F * kangle, 0.0F);
        if(((FlightModelMain) (super.FM)).CT.getCockpitDoor() > 0.2F && bHasBlister && super.FM.getSpeedKMH() > 330F * maxSpeedForOpeningCanopyRandomFactor && hierMesh().chunkFindCheck("Blister1_D0") != -1)
        {
            try
            {
                if(this == World.getPlayerAircraft())
                    ((CockpitBF_109G2)Main3D.cur3D().cockpitCur).removeCanopy();
            }
            catch(Exception exception) { }
            playSound("aircraft.arrach", true);
            hierMesh().hideSubTrees("Blister1_D0");
            Wreckage wreckage = new Wreckage(this, hierMesh().chunkFind("Blister1_D0"));
            wreckage.collide(true);
            Vector3d vector3d = new Vector3d();
            vector3d.set(((FlightModelMain) (super.FM)).Vwld);
            wreckage.setSpeed(vector3d);
            bHasBlister = false;
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx += 0.08F;
        }
        if(super.FM.getSpeedKMH() > 280F && bHasBlister && ((FlightModelMain) (super.FM)).CT.cockpitDoorControl > 0.1F && ((FlightModelMain) (super.FM)).CT.getCockpitDoor() < 0.99F)
        {
            ((FlightModelMain) (super.FM)).CT.cockpitDoorControl = 0.0F;
            ((FlightModelMain) (super.FM)).AS.setCockpitDoor(((Interpolate) (super.FM)).actor, 0);
            float f1 = ((FlightModelMain) (super.FM)).CT.getCockpitDoor();
            if(Math.abs(cockpitDoor_ - f1) > 0.05F)
                moveCockpitDoor(cockpitDoor_ = f1);
            HUD.log("CockpitDoorCLS");
        }
    }

    public static void moveGear(HierMesh hiermesh, float f)
    {
        float f1 = 0.8F;
        float f2 = -0.5F * (float)Math.cos((double)(f / f1) * 3.1415926535897931D) + 0.5F;
        if(f <= f1 || f == 1.0F)
        {
            hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -77.5F * f2, 0.0F);
            hiermesh.chunkSetAngles("GearL2_D0", -33.5F * f2, 0.0F, 0.0F);
        }
        f2 = -0.5F * (float)Math.cos((double)((f - (1.0F - f1)) / f1) * 3.1415926535897931D) + 0.5F;
        if(f >= 1.0F - f1)
        {
            hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 77.5F * f2, 0.0F);
            hiermesh.chunkSetAngles("GearR2_D0", 33.5F * f2, 0.0F, 0.0F);
        }
        hiermesh.chunkSetAngles("GearC3_D0", 70F * f, 0.0F, 0.0F);
        if(f > 0.99F)
        {
            hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -77.5F, 0.0F);
            hiermesh.chunkSetAngles("GearL2_D0", -33.5F, 0.0F, 0.0F);
            hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 77.5F, 0.0F);
            hiermesh.chunkSetAngles("GearR2_D0", 33.5F, 0.0F, 0.0F);
        }
        if(f < 0.01F)
        {
            hiermesh.chunkSetAngles("GearL3_D0", 0.0F, 0.0F, 0.0F);
            hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 0.0F, 0.0F);
            hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 0.0F, 0.0F);
            hiermesh.chunkSetAngles("GearR2_D0", 0.0F, 0.0F, 0.0F);
        }
    }

    protected void moveGear(float f)
    {
        float f1 = 0.9F - (float)((Wing)getOwner()).aircIndex(this) * 0.1F;
        float f2 = -0.5F * (float)Math.cos((double)(f / f1) * 3.1415926535897931D) + 0.5F;
        if(f <= f1 || f == 1.0F)
        {
            hierMesh().chunkSetAngles("GearL3_D0", 0.0F, -77.5F * f2, 0.0F);
            hierMesh().chunkSetAngles("GearL2_D0", -33.5F * f2, 0.0F, 0.0F);
        }
        f2 = -0.5F * (float)Math.cos((double)((f - (1.0F - f1)) / f1) * 3.1415926535897931D) + 0.5F;
        if(f >= 1.0F - f1)
        {
            hierMesh().chunkSetAngles("GearR3_D0", 0.0F, 77.5F * f2, 0.0F);
            hierMesh().chunkSetAngles("GearR2_D0", 33.5F * f2, 0.0F, 0.0F);
        }
        hierMesh().chunkSetAngles("GearC3_D0", 70F * f, 0.0F, 0.0F);
        if(f > 0.99F)
        {
            hierMesh().chunkSetAngles("GearL3_D0", 0.0F, -77.5F, 0.0F);
            hierMesh().chunkSetAngles("GearL2_D0", -33.5F, 0.0F, 0.0F);
            hierMesh().chunkSetAngles("GearR3_D0", 0.0F, 77.5F, 0.0F);
            hierMesh().chunkSetAngles("GearR2_D0", 33.5F, 0.0F, 0.0F);
        }
    }

    public void moveSteering(float f)
    {
        if(((FlightModelMain) (super.FM)).CT.getGear() < 0.98F)
        {
            return;
        } else
        {
            hierMesh().chunkSetAngles("GearC2_D0", 0.0F, -f, 0.0F);
            return;
        }
    }

    public static String getSkinPrefix(String s, Regiment regiment)
    {
        if(regiment == null || regiment.country() == null)
            return "";
        if(regiment.country().equals(PaintScheme.countryRomania))
            return PaintScheme.countryRomania + "_";
        if(regiment.country().equals(PaintScheme.countryItaly))
            return PaintScheme.countryItaly + "_";
        if(regiment.country().equals(PaintScheme.countryFinland))
            return PaintScheme.countryFinland + "_";
        if(regiment.country().equals(PaintScheme.countrySlovakia))
            return PaintScheme.countrySlovakia + "_";
        if(regiment.country().equals(PaintScheme.countryHungary))
            return PaintScheme.countryHungary + "_";
        else
            return "";
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("Hochleistung inbegriffen!");
    }

    protected void nextDMGLevel(String s, int i, Actor actor)
    {
        super.nextDMGLevel(s, i, actor);
        if(super.FM.isPlayers())
            bChangedPit = true;
    }
    
    protected void nextCUTLevel(String s, int i, Actor actor)
    {
        super.nextCUTLevel(s, i, actor);
        if(super.FM.isPlayers())
            bChangedPit = true;
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    public float cockpitDoor_;
    private static final float MAX_SPEED_KMH_FOR_OPENING_CANOPY = 280F;
    private static final float MAX_SPEED_KMH_FOR_KEEPING_CANOPY = 330F;
    private float maxSpeedForOpeningCanopyRandomFactor;
    private float kangle;
    public boolean bHasBlister;
    public static boolean bChangedPit = false;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.BF_109G2.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Bf-109G-2");
        Property.set(class1, "meshName", "3DO/Plane/Bf-109G-2/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar03());
        Property.set(class1, "meshName_fi", "3DO/Plane/Bf-109G-2(fi)/hier.him");
        Property.set(class1, "PaintScheme_fi", new PaintSchemeFCSPar02());
        Property.set(class1, "meshName_hu", "3DO/Plane/Bf-109G-2(hu)/hier.him");
        Property.set(class1, "PaintScheme_hu", new PaintSchemeFMPar03());
        Property.set(class1, "meshName_sk", "3DO/Plane/Bf-109G-2(sk)/hier.him");
        Property.set(class1, "PaintScheme_sk", new PaintSchemeFMPar03());
        Property.set(class1, "yearService", 1942F);
        Property.set(class1, "yearExpired", 1945.5F);
        Property.set(class1, "FlightModel", "FlightModels/Bf-109G-2.fmd:Bf");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitBF_109G2.class
        });
        Property.set(class1, "LOSElevation", 0.7498F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 0, 1, 1, 1, 1, 1, 9, 9, 
            9, 9, 3, 3, 3, 3, 3, 9, 9, 9
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_CANNON01", "_CANNON02", "_CANNON03", "_CANNON04", "_CANNON05", "_ExternalDev01", "_ExternalDev01", 
            "_ExternalDev02", "_ExternalDev03", "_ExternalBomb01", "_ExternalBomb02", "_ExternalBomb03", "_ExternalBomb04", "_ExternalBomb05", "_ExternalDev04", "_ExternalDev05", "_ExternalDev06"
        });
/*         String as[] = new String[20];
        as[0] = "MGunMG17si 500";
        as[1] = "MGunMG17si 500";
        as[3] = "MGunMG15120MGki 200";
        Aircraft.weaponsRegister(class1, "default", as);
        String as1[] = new String[20];
        as1[0] = "MGunMG17si 500";
        as1[1] = "MGunMG17si 500";
        as1[3] = "MGunMG15120MGki 200";
        as1[8] = "PylonETC900";
        as1[12] = "BombGunSC250 1";
        Aircraft.weaponsRegister(class1, "R1-SC250", as1);
        String as2[] = new String[20];
        as2[0] = "MGunMG17si 500";
        as2[1] = "MGunMG17si 500";
        as2[3] = "MGunMG15120MGki 200";
        as2[8] = "PylonETC900";
        as2[12] = "BombGunAB250 1";
        Aircraft.weaponsRegister(class1, "R1-AB250", as2);
        String as3[] = new String[20];
        as3[0] = "MGunMG17si 500";
        as3[1] = "MGunMG17si 500";
        as3[3] = "MGunMG15120MGki 200";
        as3[8] = "PylonETC900";
        as3[12] = "BombGunSC500 1";
        Aircraft.weaponsRegister(class1, "R1-SC500", as3);
        String as4[] = new String[20];
        as4[0] = "MGunMG17si 500";
        as4[1] = "MGunMG17si 500";
        as4[3] = "MGunMG15120MGki 200";
        as4[8] = "PylonETC900";
        as4[12] = "BombGunAB500 1";
        Aircraft.weaponsRegister(class1, "R1-AB500", as4);
        String as5[] = new String[20];
        as5[0] = "MGunMG17si 500";
        as5[1] = "MGunMG17si 500";
        as5[3] = "MGunMG15120MGki 200";
        as5[8] = "PylonETC50Bf109";
        as5[13] = "BombGunSC50 1";
        as5[14] = "BombGunSC50 1";
        as5[15] = "BombGunSC50 1";
        as5[16] = "BombGunSC50 1";
        Aircraft.weaponsRegister(class1, "R2-SC50", as5);
        String as6[] = new String[20];
        as6[0] = "MGunMG17si 500";
        as6[1] = "MGunMG17si 500";
        as6[3] = "MGunMG15120MGki 200";
        as6[8] = "PylonETC50Bf109";
        as6[13] = "BombGunAB23 1";
        as6[14] = "BombGunAB23 1";
        as6[15] = "BombGunAB23 1";
        as6[16] = "BombGunAB23 1";
        Aircraft.weaponsRegister(class1, "R2-AB23", as6);
        String as7[] = new String[20];
        as7[0] = "MGunMG17si 500";
        as7[1] = "MGunMG17si 500";
        as7[3] = "MGunMG15120MGki 200";
        as7[8] = "PylonETC900";
        as7[9] = "FuelTankGun_Type_D";
        Aircraft.weaponsRegister(class1, "R3-DROPTANK", as7);
        String as8[] = new String[20];
        as8[0] = "MGunMG17si 500";
        as8[1] = "MGunMG17si 500";
        as8[3] = "MGunMG15120MGki 200";
        as8[4] = "MGunMG15120kh 135";
        as8[5] = "MGunMG15120kh 135";
        as8[10] = "PylonMG15120";
        as8[11] = "PylonMG15120";
        Aircraft.weaponsRegister(class1, "R6-MG151-20", as8);
        String as9[] = new String[20];
        as9[0] = "MGunMG17si 500";
        as9[1] = "MGunMG17si 500";
        as9[3] = "MGunMG15120MGki 200";
        as9[4] = "MGunMG15120kh 135";
        as9[5] = "MGunMG15120kh 135";
        as9[8] = "PylonETC900";
        as9[9] = "FuelTankGun_Type_D";
        as9[10] = "PylonMG15120";
        as9[11] = "PylonMG15120";
        Aircraft.weaponsRegister(class1, "R3R6-MG151-20", as9);
        String as10[] = new String[20];
        as10[0] = "MGunMG17si 500";
        as10[1] = "MGunMG17si 500";
        as10[3] = "MGunMG15120MGki 200";
        as10[17] = "FuelTankGun_Type_D 1";
        as10[18] = "FuelTankGun_Type_D 1";
        Aircraft.weaponsRegister(class1, "R1-2XDROPTANK", as10);
        String as11[] = new String[20];
        as11[0] = "MGunMG17si 500";
        as11[1] = "MGunMG17si 500";
        as11[3] = "MGunMG15120MGki 200";
        as11[8] = "PylonETC900 1";
        as11[12] = "BombGunSC500 1";
        as11[17] = "FuelTankGun_Type_D 1";
        as11[18] = "FuelTankGun_Type_D 1";
        Aircraft.weaponsRegister(class1, "R1-2XDROPTANK_SC500", as11);
        String as13[] = new String[20];
        as13[0] = "MGunMG17si 500";
        as13[1] = "MGunMG17si 500";
        as13[3] = "MGunMG15120MGki 200";
        as13[19] = "PylonRECO1BF109 1";
        Aircraft.weaponsRegister(class1, "R2-RECON", as13);
        String as14[] = new String[20];
        as14[0] = "MGunMG17si 500";
        as14[1] = "MGunMG17si 500";
        as14[3] = "MGunMG15120MGki 200";
        as14[8] = "PylonETC900 1";
        as14[9] = "FuelTankGun_Type_D 1";
        as14[19] = "PylonRECO1BF109 1";
        Aircraft.weaponsRegister(class1, "R2-RECON-DROPTANK", as14);
        String as12[] = new String[20];
        as12[0] = "MGunMG17si 500";
        as12[1] = "MGunMG17si 500";
        as12[3] = "MGunMG15120MGki 200";
        as12[17] = "FuelTankGun_Type_D 1";
        as12[18] = "FuelTankGun_Type_D 1";
        as12[19] = "PylonRECO1BF109 1";
        Aircraft.weaponsRegister(class1, "R2-RECON-2xDROPTANK", as12);
        Aircraft.weaponsRegister(class1, "none", new String[20]); */
    }
}