package com.maddox.il2.objects.air;

import com.maddox.JGP.Point3d;
import com.maddox.JGP.Tuple3d;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Mission;
import com.maddox.rts.Property;
import java.util.Random;

public abstract class BF_109 extends Scheme1
    implements TypeFighter
{

    public BF_109()
    {
        trimElevator = 0.0F;
        bHasElevatorControl = true;
        X = 1.0F;
        GlassState = 0;
        s17 = s18 = 0.15F;
        s31 = s32 = 0.35F;
        kl = 1.0F;
        kr = 1.0F;
        kc = 1.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.1F;
    }

    protected void moveFlap(float f)
    {
        float f1 = -45F * f;
        hierMesh().chunkSetAngles("Flap01_D0", 0.0F, f1, 0.0F);
        hierMesh().chunkSetAngles("Flap02_D0", 0.0F, f1, 0.0F);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.4F)  //this and below for gear dmg; in gearDamageFX: ((FlightModelMain) (super.FM)).CT.GearControl = 0.4F;
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
        }
    }

    public void moveWheelSink()
    {
        resetYPRmodifier();
        Aircraft.xyz[2] = Aircraft.cvt(((FlightModelMain) (super.FM)).Gears.gWheelSinking[0], 0.0F, 0.3F, 0.0F, 0.3F);
        hierMesh().chunkSetLocate("GearL99_D0", Aircraft.xyz, Aircraft.ypr);
        Aircraft.xyz[2] = Aircraft.cvt(((FlightModelMain) (super.FM)).Gears.gWheelSinking[1], 0.0F, 0.3F, 0.0F, 0.3F);
        hierMesh().chunkSetLocate("GearR99_D0", Aircraft.xyz, Aircraft.ypr);
    }

    public void doWoundPilot(int i, float f)
    {
    }

    public void doMurderPilot(int i)
    {
        switch(i)
        {
        case 0: // '\0'
            hierMesh().chunkVisible("Pilot1_D0", false);
            hierMesh().chunkVisible("Head1_D0", false);
            hierMesh().chunkVisible("Pilot1_D1", true);
            hierMesh().chunkVisible("HMask1_D0", false);
            if(!((FlightModelMain) (super.FM)).AS.bIsAboutToBailout && World.cur().isHighGore())
            {
                if(hierMesh().isChunkVisible("Blister1_D0"))
                    hierMesh().chunkVisible("Gore1_D0", true);
                hierMesh().chunkVisible("Gore2_D0", true);
            }
            break;
        }
    }

    public boolean cut(String s)
    {
        if(s.startsWith("Tail1"))
            ((FlightModelMain) (super.FM)).AS.hitTank(this, 2, 100);
        return super.cut(s);
    }

    public void rareAction(float f, boolean flag)
    {
        super.rareAction(f, flag);
        if(flag && ((FlightModelMain) (super.FM)).AS.astateTankStates[0] > 5)
            ((FlightModelMain) (super.FM)).AS.repairTank(0);
        if(super.FM.getAltitude() < 3000F)
            hierMesh().chunkVisible("HMask1_D0", false);
        else
            hierMesh().chunkVisible("HMask1_D0", hierMesh().isChunkVisible("Head1_D0"));
    }

    public void update(float f)
    {
        super.update(f);
        if(!getOp(31) || !getOp(32))
            ((FlightModelMain) (super.FM)).CT.trimAileron = ((((FlightModelMain) (super.FM)).CT.ElevatorControl * (s32 - s31) + ((FlightModelMain) (super.FM)).CT.trimElevator * (s18 - s17)) * ((FlightModelMain) (super.FM)).SensPitch) / 3F;
        if(!bHasElevatorControl)
            ((FlightModelMain) (super.FM)).CT.ElevatorControl = 0.0F;
        if(trimElevator != ((FlightModelMain) (super.FM)).CT.trimElevator)
        {
            trimElevator = ((FlightModelMain) (super.FM)).CT.trimElevator;
            hierMesh().chunkSetAngles("StabL_D0", 0.0F, 0.0F, -16F * trimElevator);
            hierMesh().chunkSetAngles("StabR_D0", 0.0F, 0.0F, -16F * trimElevator);
        }
    }

    protected void moveElevator(float f)
    {
        f -= trimElevator;
        hierMesh().chunkSetAngles("VatorL_D0", 0.0F, -30F * f, 0.0F);
        hierMesh().chunkSetAngles("VatorR_D0", 0.0F, -30F * f, 0.0F);
    }

    private void reflectGlassState(int i)
    {
        GlassState |= i;
        switch(GlassState & 3)
        {
        case 1: // '\001'
            hierMesh().materialReplace("Glass2", "ZBulletsHoles");
            break;

        case 2: // '\002'
            hierMesh().materialReplace("Glass2", "GlassOil");
            break;

        case 3: // '\003'
            hierMesh().materialReplace("Glass2", "GlassOilHoles");
            break;
        }
        switch(GlassState & 0xc)
        {
        case 4: // '\004'
            hierMesh().materialReplace("GlassW", "ZBulletsHoles");
            break;

        case 8: // '\b'
            hierMesh().materialReplace("GlassW", "Wounded");
            hierMesh().chunkVisible("Gore2_D0", true);
            break;

        case 12: // '\f'
            hierMesh().materialReplace("GlassW", "WoundedHoles");
            hierMesh().chunkVisible("Gore2_D0", true);
            break;
        }
    }

    protected void hitBone(String s, Shot shot, Point3d point3d)
    {
        if(s.startsWith("xx"))
        {
            if(s.startsWith("xxarmor"))
            {
                Aircraft.debugprintln(this, "*** Armor: Hit..");
                if(s.endsWith("p1"))
                {
                    getEnergyPastArmor(World.Rnd().nextFloat(20F, 30F), shot);
                    ((FlightModelMain) (super.FM)).AS.setCockpitState(shot.initiator, ((FlightModelMain) (super.FM)).AS.astateCockpitState | 2);
                    reflectGlassState(5);
                    Aircraft.debugprintln(this, "*** Armor Glass: Hit..");
                    if(shot.power <= 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Armor Glass: Bullet Stopped..");
                        if(World.Rnd().nextFloat() < 0.5F)
                            doRicochetBack(shot);
                    }
                } else
                if(s.endsWith("p2"))
                    getEnergyPastArmor(0.5F, shot);
                else
                if(s.endsWith("p3"))
                {
                    if(((Tuple3d) (point3d)).z < -0.27000000000000002D)
                        getEnergyPastArmor(4.0999999046325684D / (Math.abs(((Tuple3d) (Aircraft.v1)).z) + 9.9999997473787516E-006D), shot);
                    else
                        getEnergyPastArmor(8.1000003814697266D / (Math.abs(((Tuple3d) (Aircraft.v1)).x) + 9.9999997473787516E-006D), shot);
                } else
                if(s.endsWith("p4"))
                    getEnergyPastArmor(9D / (Math.abs(((Tuple3d) (Aircraft.v1)).z) + 9.9999997473787516E-006D), shot);
                else
                if(s.endsWith("p5"))
                    getEnergyPastArmor(9D / (Math.abs(((Tuple3d) (Aircraft.v1)).x) + 9.9999997473787516E-006D), shot);
                else
                if(s.endsWith("p6"))
                    getEnergyPastArmor(9D / (Math.abs(((Tuple3d) (Aircraft.v1)).x) + 9.9999997473787516E-006D), shot);
                else
                if(s.endsWith("a1"))
                {
                    if(World.Rnd().nextFloat() < 0.5F)
                        shot.powerType = 0;
                    getEnergyPastArmor(World.Rnd().nextFloat(1.0F, 3F), shot);
                }
                return;
            }
            if(s.startsWith("xxcontrols"))
            {
                int i = s.charAt(10) - 48;
                switch(i)
                {
                default:
                    break;

                case 1: // '\001'
                case 4: // '\004'
                    if(getEnergyPastArmor(0.1F, shot) > 0.0F)
                    {
                        ((FlightModelMain) (super.FM)).AS.setControlsDamage(shot.initiator, 0);
                        Aircraft.debugprintln(this, "*** Aileron Controls: Control Crank Destroyed..");
                    }
                    break;

                case 2: // '\002'
                case 3: // '\003'
                    if(getEnergyPastArmor(0.12F, shot) > 0.0F && World.Rnd().nextFloat() < 0.1F)
                    {
                        ((FlightModelMain) (super.FM)).AS.setControlsDamage(shot.initiator, 0);
                        Aircraft.debugprintln(this, "*** Aileron Controls: Disabled..");
                    }
                    break;

                case 5: // '\005'
                case 6: // '\006'
                    if(getEnergyPastArmor(0.002F, shot) > 0.0F && World.Rnd().nextFloat() < 0.1F)
                    {
                        ((FlightModelMain) (super.FM)).AS.setControlsDamage(shot.initiator, 1);
                        Aircraft.debugprintln(this, "*** Elevator Controls: Disabled / Strings Broken..");
                    }
                    break;

                case 7: // '\007'
                    if(getEnergyPastArmor(2.3F, shot) > 0.0F && World.Rnd().nextFloat() < 0.2F)
                    {
                        ((FlightModelMain) (super.FM)).AS.setControlsDamage(shot.initiator, 2);
                        Aircraft.debugprintln(this, "*** Rudder Controls: Disabled..");
                    }
                    break;

                case 8: // '\b'
                    if(getEnergyPastArmor(3.2F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Control Column: Hit, Controls Destroyed..");
                        ((FlightModelMain) (super.FM)).AS.setControlsDamage(shot.initiator, 2);
                        ((FlightModelMain) (super.FM)).AS.setControlsDamage(shot.initiator, 1);
                        ((FlightModelMain) (super.FM)).AS.setControlsDamage(shot.initiator, 0);
                    }
                    break;

                case 9: // '\t'
                    if(getEnergyPastArmor(0.1F, shot) > 0.0F)
                    {
                        ((FlightModelMain) (super.FM)).AS.setCockpitState(shot.initiator, ((FlightModelMain) (super.FM)).AS.astateCockpitState | 8);
                        ((FlightModelMain) (super.FM)).AS.setEngineSpecificDamage(shot.initiator, 0, 1);
                        ((FlightModelMain) (super.FM)).AS.setEngineSpecificDamage(shot.initiator, 0, 6);
                        Aircraft.debugprintln(this, "*** Throttle Quadrant: Hit, Engine Controls Disabled..");
                    }
                    break;
                }
            }
            if(s.startsWith("xxspar"))
            {
                Aircraft.debugprintln(this, "*** Spar Construction: Hit..");
                if(s.startsWith("xxspart") && chunkDamageVisible("Tail1") > 2 && getEnergyPastArmor(3.5F / (float)Math.sqrt(((Tuple3d) (Aircraft.v1)).y * ((Tuple3d) (Aircraft.v1)).y + ((Tuple3d) (Aircraft.v1)).z * ((Tuple3d) (Aircraft.v1)).z), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Tail1 Spars Broken in Half..");
                    nextDMGLevels(1, 2, "Tail1_D3", shot.initiator);
                }
                if(s.startsWith("xxsparli") && chunkDamageVisible("WingLIn") > 2 && getEnergyPastArmor(9.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLIn Spars Damaged..");
                    nextDMGLevels(1, 2, "WingLIn_D3", shot.initiator);
                }
                if(s.startsWith("xxsparri") && chunkDamageVisible("WingRIn") > 2 && getEnergyPastArmor(9.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingRIn Spars Damaged..");
                    nextDMGLevels(1, 2, "WingRIn_D3", shot.initiator);
                }
                if(s.startsWith("xxsparlm") && chunkDamageVisible("WingLMid") > 2 && getEnergyPastArmor(9.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLMid Spars Damaged..");
                    nextDMGLevels(1, 2, "WingLMid_D3", shot.initiator);
                }
                if(s.startsWith("xxsparrm") && chunkDamageVisible("WingRMid") > 2 && getEnergyPastArmor(9.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingRMid Spars Damaged..");
                    nextDMGLevels(1, 2, "WingRMid_D3", shot.initiator);
                }
                if(s.startsWith("xxsparlo") && chunkDamageVisible("WingLOut") > 2 && getEnergyPastArmor(9.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLOut Spars Damaged..");
                    nextDMGLevels(1, 2, "WingLOut_D3", shot.initiator);
                }
                if(s.startsWith("xxsparro") && chunkDamageVisible("WingROut") > 2 && getEnergyPastArmor(9.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingROut Spars Damaged..");
                    nextDMGLevels(1, 2, "WingROut_D3", shot.initiator);
                }
            }
            if(s.startsWith("xxwj") && getEnergyPastArmor(12.5F, shot) > 0.0F)
                if(s.endsWith("l"))
                {
                    Aircraft.debugprintln(this, "*** WingL Console Lock Destroyed..");
                    nextDMGLevels(4, 2, "WingLIn_D" + chunkDamageVisible("WingLIn"), shot.initiator);
                } else
                {
                    Aircraft.debugprintln(this, "*** WingR Console Lock Destroyed..");
                    nextDMGLevels(4, 2, "WingRIn_D" + chunkDamageVisible("WingRIn"), shot.initiator);
                }
            if(s.startsWith("xxlock"))
            {
                Aircraft.debugprintln(this, "*** Lock Construction: Hit..");
                if(s.startsWith("xxlockr") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Rudder Lock Shot Off..");
                    nextDMGLevels(3, 2, "Rudder1_D" + chunkDamageVisible("Rudder1"), shot.initiator);
                }
                if(s.startsWith("xxlockvl") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** VatorL Lock Shot Off..");
                    nextDMGLevels(3, 2, "VatorL_D" + chunkDamageVisible("VatorL"), shot.initiator);
                }
                if(s.startsWith("xxlockvr") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** VatorR Lock Shot Off..");
                    nextDMGLevels(3, 2, "VatorR_D" + chunkDamageVisible("VatorR"), shot.initiator);
                }
            }
            if(s.startsWith("xxeng"))
            {
                Aircraft.debugprintln(this, "*** Engine Module: Hit..");
                if(s.endsWith("pipe"))
                {
                    if(World.Rnd().nextFloat() < 0.1F && ((FlightModelMain) (super.FM)).CT.Weapons[1] != null && ((FlightModelMain) (super.FM)).CT.Weapons[1].length != 2)
                    {
                        ((FlightModelMain) (super.FM)).AS.setJamBullets(1, 0);
                        Aircraft.debugprintln(this, "*** Engine Module: Nose Nozzle Pipe Bent..");
                    }
                    getEnergyPastArmor(0.3F, shot);
                } else
                if(s.endsWith("prop"))
                {
                    if(getEnergyPastArmor(0.1F, shot) > 0.0F && World.Rnd().nextFloat() < 0.8F)
                        if(World.Rnd().nextFloat() < 0.5F)
                        {
                            ((FlightModelMain) (super.FM)).AS.setEngineSpecificDamage(shot.initiator, 0, 3);
                            Aircraft.debugprintln(this, "*** Engine Module: Prop Governor Hit, Disabled..");
                        } else
                        {
                            ((FlightModelMain) (super.FM)).AS.setEngineSpecificDamage(shot.initiator, 0, 4);
                            Aircraft.debugprintln(this, "*** Engine Module: Prop Governor Hit, Damaged..");
                        }
                } else
                if(s.endsWith("gear"))
                {
                    if(getEnergyPastArmor(4.6F, shot) > 0.0F)
                        if(World.Rnd().nextFloat() < 0.5F)
                        {
                            ((FlightModelMain) (super.FM)).EI.engines[0].setEngineStuck(shot.initiator);
                            Aircraft.debugprintln(this, "*** Engine Module: Bullet Jams Reductor Gear..");
                        } else
                        {
                            ((FlightModelMain) (super.FM)).AS.setEngineSpecificDamage(shot.initiator, 0, 3);
                            ((FlightModelMain) (super.FM)).AS.setEngineSpecificDamage(shot.initiator, 0, 4);
                            Aircraft.debugprintln(this, "*** Engine Module: Reductor Gear Damaged, Prop Governor Failed..");
                        }
                } else
                if(s.endsWith("supc"))
                {
                    if(getEnergyPastArmor(0.1F, shot) > 0.0F)
                    {
                        ((FlightModelMain) (super.FM)).AS.setEngineSpecificDamage(shot.initiator, 0, 0);
                        Aircraft.debugprintln(this, "*** Engine Module: Supercharger Disabled..");
                    }
                } else
                if(s.endsWith("feed"))
                {
                    if(getEnergyPastArmor(3.2F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F && ((FlightModelMain) (super.FM)).EI.engines[0].getPowerOutput() > 0.7F)
                    {
                        ((FlightModelMain) (super.FM)).AS.hitEngine(shot.initiator, 0, 100);
                        Aircraft.debugprintln(this, "*** Engine Module: Pressurized Fuel Line Pierced, Fuel Flamed..");
                    }
                } else
                if(s.endsWith("fuel"))
                {
                    if(getEnergyPastArmor(1.1F, shot) > 0.0F)
                    {
                        ((FlightModelMain) (super.FM)).EI.engines[0].setEngineStops(shot.initiator);
                        Aircraft.debugprintln(this, "*** Engine Module: Fuel Line Stalled, Engine Stalled..");
                    }
                } else
                if(s.endsWith("case"))
                {
                    if(getEnergyPastArmor(2.1F, shot) > 0.0F)
                    {
                        if(World.Rnd().nextFloat() < shot.power / 175000F)
                        {
                            ((FlightModelMain) (super.FM)).AS.setEngineStuck(shot.initiator, 0);
                            Aircraft.debugprintln(this, "*** Engine Module: Bullet Jams Crank Ball Bearing..");
                        }
                        if(World.Rnd().nextFloat() < shot.power / 50000F)
                        {
                            ((FlightModelMain) (super.FM)).AS.hitEngine(shot.initiator, 0, 2);
                            Aircraft.debugprintln(this, "*** Engine Module: Crank Case Hit, Readyness Reduced to " + ((FlightModelMain) (super.FM)).EI.engines[0].getReadyness() + "..");
                        }
                        ((FlightModelMain) (super.FM)).EI.engines[0].setReadyness(shot.initiator, ((FlightModelMain) (super.FM)).EI.engines[0].getReadyness() - World.Rnd().nextFloat(0.0F, shot.power / 48000F));
                        Aircraft.debugprintln(this, "*** Engine Module: Crank Case Hit, Readyness Reduced to " + ((FlightModelMain) (super.FM)).EI.engines[0].getReadyness() + "..");
                    }
                    getEnergyPastArmor(22.5F, shot);
                } else
                if(s.startsWith("xxeng1cyl"))
                {
                    if(getEnergyPastArmor(0.1F, shot) > 0.0F && World.Rnd().nextFloat() < ((FlightModelMain) (super.FM)).EI.engines[0].getCylindersRatio() * 1.75F)
                    {
                        ((FlightModelMain) (super.FM)).EI.engines[0].setCyliderKnockOut(shot.initiator, World.Rnd().nextInt(1, (int)(shot.power / 4800F)));
                        Aircraft.debugprintln(this, "*** Engine Module: Cylinders Hit, " + ((FlightModelMain) (super.FM)).EI.engines[0].getCylindersOperable() + "/" + ((FlightModelMain) (super.FM)).EI.engines[0].getCylinders() + " Left..");
                        if(World.Rnd().nextFloat() < shot.power / 24000F)
                        {
                            ((FlightModelMain) (super.FM)).AS.hitEngine(shot.initiator, 0, 3);
                            Aircraft.debugprintln(this, "*** Engine Module: Cylinders Hit, Engine Fires..");
                        }
                        if(World.Rnd().nextFloat() < 0.01F)
                        {
                            ((FlightModelMain) (super.FM)).AS.setEngineStuck(shot.initiator, 0);
                            Aircraft.debugprintln(this, "*** Engine Module: Bullet Jams Piston Head..");
                        }
                        getEnergyPastArmor(22.5F, shot);
                    }
                } else
                if(s.startsWith("xxeng1mag"))
                {
                    int j = s.charAt(9) - 49;
                    ((FlightModelMain) (super.FM)).EI.engines[0].setMagnetoKnockOut(shot.initiator, j);
                    Aircraft.debugprintln(this, "*** Engine Module: Magneto " + j + " Destroyed..");
                } else
                if(s.endsWith("sync"))
                {
                    if(getEnergyPastArmor(2.1F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                    {
                        Aircraft.debugprintln(this, "*** Engine Module: Gun Synchronized Hit, Nose Guns Lose Authority..");
                        ((FlightModelMain) (super.FM)).AS.setJamBullets(0, 0);
                        ((FlightModelMain) (super.FM)).AS.setJamBullets(0, 1);
                    }
                } else
                if(s.endsWith("oil1"))
                {
                    ((FlightModelMain) (super.FM)).AS.hitOil(shot.initiator, 0);
                    reflectGlassState(2);
                    Aircraft.debugprintln(this, "*** Engine Module: Oil Radiator Hit..");
                }
            }
            if(s.startsWith("xxoil"))
            {
                ((FlightModelMain) (super.FM)).AS.hitOil(shot.initiator, 0);
                getEnergyPastArmor(0.22F, shot);
                reflectGlassState(2);
                Aircraft.debugprintln(this, "*** Engine Module: Oil Tank Pierced..");
            }
            if(s.startsWith("xxtank"))
            {
                int k = s.charAt(6) - 48;
                switch(k)
                {
                default:
                    break;

                case 1: // '\001'
                case 2: // '\002'
                    if(getEnergyPastArmor(0.1F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 0)
                        {
                            Aircraft.debugprintln(this, "*** Fuel Tank: Pierced..");
                            ((FlightModelMain) (super.FM)).AS.hitTank(shot.initiator, 2, 1);
                            ((FlightModelMain) (super.FM)).AS.doSetTankState(shot.initiator, 2, 1);
                        }
                        if(shot.powerType == 3 && World.Rnd().nextFloat() < 0.5F)
                        {
                            ((FlightModelMain) (super.FM)).AS.hitTank(shot.initiator, 2, 2);
                            Aircraft.debugprintln(this, "*** Fuel Tank: Hit..");
                        }
                    }
                    break;

                case 3: // '\003'
                    if(World.Rnd().nextFloat() < 0.05F)
                    {
                        Aircraft.debugprintln(this, "*** MW50 Tank: Pierced..");
                        ((FlightModelMain) (super.FM)).AS.setInternalDamage(shot.initiator, 2);
                    }
                    break;

                case 4: // '\004'
                    if(getEnergyPastArmor(1.7F, shot) > 0.0F && (shot.powerType == 3 && World.Rnd().nextFloat() < 0.5F || World.Rnd().nextFloat() < 0.25F))
                    {
                        Aircraft.debugprintln(this, "*** Nitrogen Oxyde Tank: Pierced, Nitros Flamed..");
                        ((FlightModelMain) (super.FM)).AS.hitTank(shot.initiator, 0, 100);
                        ((FlightModelMain) (super.FM)).AS.hitTank(shot.initiator, 1, 100);
                        ((FlightModelMain) (super.FM)).AS.hitTank(shot.initiator, 2, 100);
                    }
                    break;
                }
            }
            if(s.startsWith("xxmgun"))
            {
                if(s.endsWith("01"))
                {
                    Aircraft.debugprintln(this, "*** Cowling Gun: Disabled..");
                    ((FlightModelMain) (super.FM)).AS.setJamBullets(0, 0);
                }
                if(s.endsWith("02"))
                {
                    Aircraft.debugprintln(this, "*** Cowling Gun: Disabled..");
                    ((FlightModelMain) (super.FM)).AS.setJamBullets(0, 1);
                }
                if(s.endsWith("l"))
                {
                    Aircraft.debugprintln(this, "*** Wing Gun (L): Disabled..");
                    ((FlightModelMain) (super.FM)).AS.setJamBullets(1, 0);
                }
                if(s.endsWith("r"))
                {
                    Aircraft.debugprintln(this, "*** Wing Gun (L): Disabled..");
                    ((FlightModelMain) (super.FM)).AS.setJamBullets(1, 1);
                }
                getEnergyPastArmor(World.Rnd().nextFloat(3.3F, 12.96F), shot);
            }
            if(s.startsWith("xxcannon"))
            {
                Aircraft.debugprintln(this, "*** Nose Cannon: Disabled..");
                ((FlightModelMain) (super.FM)).AS.setJamBullets(1, 0);
                getEnergyPastArmor(World.Rnd().nextFloat(3.3F, 24.6F), shot);
            }
            if(s.startsWith("xxammo"))
            {
                if(World.Rnd().nextFloat(3800F, 30000F) < shot.power)
                {
                    if(s.endsWith("01"))
                    {
                        Aircraft.debugprintln(this, "*** Cowling Gun: Ammo Feed Chain Broken..");
                        ((FlightModelMain) (super.FM)).AS.setJamBullets(0, 0);
                    }
                    if(s.endsWith("02"))
                    {
                        Aircraft.debugprintln(this, "*** Cowling Gun: Ammo Feed Chain Broken..");
                        ((FlightModelMain) (super.FM)).AS.setJamBullets(0, 1);
                    }
                    if(s.endsWith("l"))
                    {
                        Aircraft.debugprintln(this, "*** Wing Gun (L): Ammo Feed Drum Damaged..");
                        ((FlightModelMain) (super.FM)).AS.setJamBullets(1, 0);
                    }
                    if(s.endsWith("r"))
                    {
                        Aircraft.debugprintln(this, "*** Wing Gun (R): Ammo Feed Drum Damaged..");
                        ((FlightModelMain) (super.FM)).AS.setJamBullets(1, 1);
                    }
                }
                getEnergyPastArmor(World.Rnd().nextFloat(0.0F, 28.33F), shot);
            }
            return;
        }
        if(s.startsWith("xcf") || s.startsWith("xcockpit"))
        {
            if(chunkDamageVisible("CF") < 3)
                hitChunk("CF", shot);
            if(s.startsWith("xcockpit"))
            {
                if(((Tuple3d) (point3d)).z > 0.40000000000000002D)
                {
                    ((FlightModelMain) (super.FM)).AS.setCockpitState(shot.initiator, ((FlightModelMain) (super.FM)).AS.astateCockpitState | 1);
                    reflectGlassState(5);
                    if(World.Rnd().nextFloat() < 0.1F)
                    {
                        ((FlightModelMain) (super.FM)).AS.setCockpitState(shot.initiator, ((FlightModelMain) (super.FM)).AS.astateCockpitState | 0x20);
                        reflectGlassState(5);
                    }
                } else
                if(((Tuple3d) (point3d)).y > 0.0D)
                {
                    ((FlightModelMain) (super.FM)).AS.setCockpitState(shot.initiator, ((FlightModelMain) (super.FM)).AS.astateCockpitState | 4);
                } else
                {
                    ((FlightModelMain) (super.FM)).AS.setCockpitState(shot.initiator, ((FlightModelMain) (super.FM)).AS.astateCockpitState | 0x10);
                    reflectGlassState(5);
                }
                if(((Tuple3d) (point3d)).x > 0.20000000000000001D)
                    ((FlightModelMain) (super.FM)).AS.setCockpitState(shot.initiator, ((FlightModelMain) (super.FM)).AS.astateCockpitState | 0x40);
            }
        } else
        if(s.startsWith("xeng"))
        {
            if(chunkDamageVisible("Engine1") < 2)
                hitChunk("Engine1", shot);
        } else
        if(s.startsWith("xtail"))
        {
            if(chunkDamageVisible("Tail1") < 3)
                hitChunk("Tail1", shot);
        } else
        if(s.startsWith("xkeel"))
        {
            if(chunkDamageVisible("Keel1") < 2)
                hitChunk("Keel1", shot);
        } else
        if(s.startsWith("xrudder"))
        {
            if(chunkDamageVisible("Rudder1") < 1)
                hitChunk("Rudder1", shot);
        } else
        if(s.startsWith("xstab"))
        {
            if(s.startsWith("xstabl") && chunkDamageVisible("StabL") < 2)
                hitChunk("StabL", shot);
            if(s.startsWith("xstabr") && chunkDamageVisible("StabR") < 1)
                hitChunk("StabR", shot);
        } else
        if(s.startsWith("xvator"))
        {
            if(s.startsWith("xvatorl") && chunkDamageVisible("VatorL") < 1)
                hitChunk("VatorL", shot);
            if(s.startsWith("xvatorr") && chunkDamageVisible("VatorR") < 1)
                hitChunk("VatorR", shot);
        } else
        if(s.startsWith("xwing"))
        {
            if(s.startsWith("xwinglin") && chunkDamageVisible("WingLIn") < 3)
                hitChunk("WingLIn", shot);
            if(s.startsWith("xwingrin") && chunkDamageVisible("WingRIn") < 3)
                hitChunk("WingRIn", shot);
            if(s.startsWith("xwinglmid") && chunkDamageVisible("WingLMid") < 3)
                hitChunk("WingLMid", shot);
            if(s.startsWith("xwingrmid") && chunkDamageVisible("WingRMid") < 3)
                hitChunk("WingRMid", shot);
            if(s.startsWith("xwinglout") && chunkDamageVisible("WingLOut") < 3)
                hitChunk("WingLOut", shot);
            if(s.startsWith("xwingrout") && chunkDamageVisible("WingROut") < 3)
                hitChunk("WingROut", shot);
        } else
        if(s.startsWith("xarone"))
        {
            if(s.startsWith("xaronel"))
                hitChunk("AroneL", shot);
            if(s.startsWith("xaroner"))
                hitChunk("AroneR", shot);
        } else
        if(s.startsWith("xpilot") || s.startsWith("xhead"))
        {
            byte byte0 = 0;
            int l;
            if(s.endsWith("a"))
            {
                byte0 = 1;
                l = s.charAt(6) - 49;
            } else
            if(s.endsWith("b"))
            {
                byte0 = 2;
                l = s.charAt(6) - 49;
            } else
            {
                l = s.charAt(5) - 49;
            }
            hitFlesh(l, shot, byte0);
            if(((FlightModelMain) (super.FM)).AS.getPilotHealth(0) < 1.0F)
                reflectGlassState(8);
        } else
        if(s.startsWith("xgear") && World.Rnd().nextFloat() < 0.05F)
        {
            debuggunnery("Hydro System: Disabled..");
            FM.AS.setInternalDamage(shot.initiator, 0);
            gearDamageFX(s);
        }
		if(s.startsWith("xxwater"))
		{
			if(getEnergyPastArmor(0.1F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
			{
				debuggunnery("Engine Module: Water Radiator Pierced..");
				if(super.FM.isPlayers())
				HUD.log("\u0412\u043E\u0434\u043E\u0440\u0430\u0434\u0438\u0430\u0442\u043E\u0440 \u043F\u0440\u043E\u0431\u0438\u0442");
				FM.AS.hitEngine(shot.initiator, 0, 1);
				FM.AS.doSetEngineState(shot.initiator, 0, 2);
			}
			getEnergyPastArmor(0.22F, shot);
		}
    }

    private void cutOp(int i)
    {
        super.FM.Operate &= ~(1L << i);
    }

    protected boolean getOp(int i)
    {
        return (((FlightModelMain) (super.FM)).Operate & 1L << i) != 0L;
    }

    private float Op(int i)
    {
        return getOp(i) ? 1.0F : 0.0F;
    }

    protected boolean cutFM(int i, int i_2_, Actor actor)
    {
        if(!getOp(i))
            return false;
        switch(i)
        {
        case 17: // '\021'
            cut("StabL");
            cutOp(17);
            super.FM.setCapableOfACM(false);
            if(World.Rnd().nextInt(-1, 8) < ((FlightModelMain) (super.FM)).Skill)
                super.FM.setReadyToReturn(true);
            if(World.Rnd().nextInt(-1, 16) < ((FlightModelMain) (super.FM)).Skill)
                super.FM.setReadyToDie(true);
            ((FlightModelMain) (super.FM)).Sq.liftStab *= 0.5F * Op(18) + 0.1F;
            ((FlightModelMain) (super.FM)).Sq.liftWingLIn *= 1.1F;
            ((FlightModelMain) (super.FM)).Sq.liftWingRIn *= 0.9F;
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx -= 0.06F;
            if(Op(18) == 0.0F)
            {
                super.FM.SensPitch = 0.0F;
                super.FM.setGCenter(0.2F);
            } else
            {
                super.FM.setGCenter(0.1F);
                s17 = 0.0F;
                super.FM.SensPitch *= s17 + s18 + s31 + s32;
                X = 1.0F / (s17 + s18 + s31 + s32);
                s18 *= X;
                s31 *= X;
                s32 *= X;
            }
            // fall through

        case 31: // '\037'
            if(Op(31) == 0.0F)
                return false;
            cut("VatorL");
            cutOp(31);
            if(Op(32) == 0.0F)
            {
                bHasElevatorControl = false;
                super.FM.setCapableOfACM(false);
                if(Op(18) == 0.0F)
                    super.FM.setReadyToDie(true);
            }
            ((FlightModelMain) (super.FM)).Sq.squareElevators *= 0.5F * Op(32);
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx += 0.06F;
            s31 = 0.0F;
            super.FM.SensPitch *= s17 + s18 + s31 + s32;
            X = 1.0F / (s17 + s18 + s31 + s32);
            s17 *= X;
            s18 *= X;
            s32 *= X;
            return false;

        case 18: // '\022'
            cut("StabR");
            cutOp(18);
            super.FM.setCapableOfACM(false);
            if(World.Rnd().nextInt(-1, 8) < ((FlightModelMain) (super.FM)).Skill)
                super.FM.setReadyToReturn(true);
            if(World.Rnd().nextInt(-1, 16) < ((FlightModelMain) (super.FM)).Skill)
                super.FM.setReadyToDie(true);
            ((FlightModelMain) (super.FM)).Sq.liftStab *= 0.5F * Op(17) + 0.1F;
            ((FlightModelMain) (super.FM)).Sq.liftWingLIn *= 0.9F;
            ((FlightModelMain) (super.FM)).Sq.liftWingRIn *= 1.1F;
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx -= 0.06F;
            if(Op(17) == 0.0F)
            {
                super.FM.SensPitch = 0.0F;
                super.FM.setGCenter(0.2F);
            } else
            {
                super.FM.setGCenter(0.1F);
                s18 = 0.0F;
                super.FM.SensPitch *= s17 + s18 + s31 + s32;
                X = 1.0F / (s17 + s18 + s31 + s32);
                s17 *= X;
                s31 *= X;
                s32 *= X;
            }
            // fall through

        case 32: // ' '
            if(Op(32) == 0.0F)
                return false;
            cut("VatorR");
            cutOp(32);
            if(Op(31) == 0.0F)
            {
                bHasElevatorControl = false;
                super.FM.setCapableOfACM(false);
                if(Op(17) == 0.0F)
                    super.FM.setReadyToDie(true);
            }
            ((FlightModelMain) (super.FM)).Sq.squareElevators *= 0.5F * Op(31);
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx += 0.06F;
            s32 = 0.0F;
            super.FM.SensPitch *= s17 + s18 + s31 + s32;
            X = 1.0F / (s17 + s18 + s31 + s32);
            s17 *= X;
            s18 *= X;
            s31 *= X;
            return false;

        default:
            return super.cutFM(i, i_2_, actor);
        }
    }

    public void msgExplosion(Explosion explosion)
    {
        setExplosion(explosion);
        if(explosion.chunkName != null && explosion.power > 0.0F && explosion.chunkName.startsWith("Tail1"))
        {
            if(World.Rnd().nextFloat(0.0F, 0.038F) < explosion.power)
                ((FlightModelMain) (super.FM)).AS.setControlsDamage(explosion.initiator, 1);
            if(World.Rnd().nextFloat(0.0F, 0.042F) < explosion.power)
                ((FlightModelMain) (super.FM)).AS.setControlsDamage(explosion.initiator, 2);
        }
        super.msgExplosion(explosion);
    }

    private void CombustionFlame()
    {
        int i = World.Rnd().nextInt(0, 100);
        int j = World.Rnd().nextInt(1, 12);
        switch(i)
        {
        case 1: // '\001'
            random = "01";
            break;

        case 8: // '\b'
            random = "02";
            break;

        case 14: // '\016'
            random = "03";
            break;

        case 21: // '\025'
            random = "04";
            break;

        case 30: // '\036'
            random = "05";
            break;

        case 38: // '&'
            random = "06";
            break;

        case 44: // ','
            random = "07";
            break;

        case 68: // 'D'
            random = "08";
            break;

        case 70: // 'F'
            random = "09";
            break;

        case 81: // 'Q'
            random = "10";
            break;

        case 89: // 'Y'
            random = "11";
            break;

        case 94: // '^'
            random = "12";
            break;
        }
        switch(j)
        {
        case 1: // '\001'
            random3 = "01";
            break;

        case 2: // '\002'
            random3 = "03";
            break;

        case 3: // '\003'
            random3 = "05";
            break;

        case 4: // '\004'
            random3 = "07";
            break;

        case 5: // '\005'
            random3 = "09";
            break;

        case 6: // '\006'
            random3 = "11";
            break;

        case 7: // '\007'
            random3 = "02";
            break;

        case 8: // '\b'
            random3 = "04";
            break;

        case 9: // '\t'
            random3 = "06";
            break;

        case 10: // '\n'
            random3 = "08";
            break;

        case 11: // '\013'
            random3 = "10";
            break;

        case 12: // '\f'
            random3 = "12";
            break;
        }
        if(((FlightModelMain) (super.FM)).EI.engines[0].getStage() == 6 && ((FlightModelMain) (super.FM)).EI.engines[0].getPowerOutput() > 0.85F)
            Eff3DActor.New(this, findHook("_Engine1EF_" + random3), null, 1.0F, "3DO/Effects/Fireworks/HolyGrail2.eff", -1F);
        if(((FlightModelMain) (super.FM)).EI.engines[0].getStage() > 1 && ((FlightModelMain) (super.FM)).EI.engines[0].getStage() < 3 && super.FM.getSpeedKMH() < 10F)
            Eff3DActor.New(this, findHook("_Engine1EF_" + random), null, 1.0F, "3DO/Effects/Aircraft/HolyGrail1.eff", -1F);
    }

    private void gearDamageFX(String s)
    {
        if(s.startsWith("xgearl"))
        {
            if(super.FM.isPlayers())
            HUD.log("\u041B\u0435\u0432\u0430\u044F \u0441\u0442\u043E\u0439\u043A\u0430: \u043E\u0442\u043A\u0430\u0437 \u0433\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u044B");
            kl = World.Rnd().nextFloat();
            kr = World.Rnd().nextFloat() * kl;
        } else
        {
            if(super.FM.isPlayers())
            HUD.log("\u041F\u0440\u0430\u0432\u0430\u044F \u0441\u0442\u043E\u0439\u043A\u0430: \u043E\u0442\u043A\u0430\u0437 \u0433\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u044B");
            kr = World.Rnd().nextFloat();
            kl = World.Rnd().nextFloat() * kr;
        }
        kc = 0.0F;
        ((FlightModelMain) (super.FM)).CT.GearControl = 0.4F;
    }

    private static float kl = 1.0F;
    private static float kr = 1.0F;
    private static float kc = 1.0F;
    private float trimElevator;
    private boolean bHasElevatorControl;
    private float X;
    private float s17;
    private float s18;
    private float s31;
    private float s32;
    private String random;
    private String random3;
    private int GlassState;

    static 
    {
        Class var_class = com.maddox.il2.objects.air.BF_109.class;
        Property.set(var_class, "originCountry", PaintScheme.countryGermany);
    }
}