package com.maddox.il2.objects.air;

import com.maddox.il2.ai.Regiment;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.objects.weapons.GunEmpty;
import com.maddox.rts.Property;

public class BF_109K14 extends BF_109Kx
    implements TypeFighter, TypeBNZFighter, TypeStormovik
{

    public BF_109K14()
    {
    }

    public void update(float f)
    {
        super.update(f);
        afterburnerhud();
    }
    public void onAircraftLoaded()
    {
        super.onAircraftLoaded();
        if(getGunByHookName("_MGUN01") instanceof GunEmpty)
        {
            hierMesh().chunkVisible("GunL_D0", false);
            hierMesh().chunkVisible("GunR_D0", false);
        }
        if(getGunByHookName("_CANNON02") instanceof GunEmpty)
            hierMesh().chunkVisible("GunL_D0", false);
        if(getGunByHookName("_CANNON03") instanceof GunEmpty)
            hierMesh().chunkVisible("GunR_D0", false);
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("Sonder hochleistung MW 50 inbegriffen!");
    }

    public static String getSkinPrefix(String s, Regiment regiment)
    {
        return "k14_";
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    static 
    {
        Class class1 = com.maddox.il2.objects.air.BF_109K14.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Bf109K-14");
        Property.set(class1, "meshName", "3do/plane/Bf-109K-4/hier_k14.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar06());
        Property.set(class1, "yearService", 1944.11F);
        Property.set(class1, "yearExpired", 1955F);
        Property.set(class1, "FlightModel", "FlightModels/Bf-109K-14.fmd:Bf");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitBF_109K4.class
        });
        Property.set(class1, "LOSElevation", 0.7498F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 1, 1, 1, 9, 3, 3, 3, 3, 
            3
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_CANNON02", "_CANNON03", "_ExternalDev01", "_ExternalBomb01", "_ExternalBomb02", "_ExternalBomb03", "_ExternalBomb04", 
            "_ExternalBomb05"
        });
/*         String as[] = new String[11];
        as[0] = "MGunMG131si 300";
        as[1] = "MGunMG131si 300";
        as[2] = "MGunMK108ki 67";
        as[3] = "MGunMK108ki 57";
        as[4] = "MGunMK108ki 57";
        AircraftLH.XweaponsRegister(class1, "default", as);
        String as1[] = new String[11];
        as1[0] = "MGunMG131si 300";
        as1[1] = "MGunMG131si 300";
        as1[2] = "MGunMG15120MGki 200";
        as1[3] = "MGunMK108ki 57";
        as1[4] = "MGunMK108ki 57";
        AircraftLH.XweaponsRegister(class1, "1xMG151", as1);
        String as2[] = new String[11];
        as2[0] = "MGunMG131si 300";
        as2[1] = "MGunMG131si 300";
        as2[2] = "MGunMK108ki 67";
        as2[3] = "MGunMK108ki 57";
        as2[4] = "MGunMK108ki 57";
        as2[5] = "PylonETC900 1";
        as2[6] = "BombGunSC250 1";
        AircraftLH.XweaponsRegister(class1, "1xSC250", as2);
        String as3[] = new String[11];
        as3[0] = "MGunMG131si 300";
        as3[1] = "MGunMG131si 300";
        as3[2] = "MGunMK108ki 67";
        as3[3] = "MGunMK108ki 57";
        as3[4] = "MGunMK108ki 57";
        as3[5] = "PylonETC900 1";
        as3[6] = "BombGunSC500 1";
        AircraftLH.XweaponsRegister(class1, "1xSC500", as3);
        String as4[] = new String[11];
        as4[0] = "MGunMG131si 300";
        as4[1] = "MGunMG131si 300";
        as4[2] = "MGunMK108ki 67";
        as4[3] = "MGunMK108ki 57";
        as4[4] = "MGunMK108ki 57";
        as4[5] = "PylonETC900 1";
        as4[6] = "BombGunAB250 1";
        AircraftLH.XweaponsRegister(class1, "1xAB250", as4);
        String as5[] = new String[11];
        as5[0] = "MGunMG131si 300";
        as5[1] = "MGunMG131si 300";
        as5[2] = "MGunMK108ki 67";
        as5[3] = "MGunMK108ki 57";
        as5[4] = "MGunMK108ki 57";
        as5[5] = "PylonETC900 1";
        as5[6] = "BombGunAB500 1";
        AircraftLH.XweaponsRegister(class1, "1xAB500", as5);
        String as6[] = new String[11];
        as6[0] = "MGunMG131si 300";
        as6[1] = "MGunMG131si 300";
        as6[2] = "MGunMK108ki 67";
        as6[3] = "MGunMK108ki 57";
        as6[4] = "MGunMK108ki 57";
        as6[5] = "PylonETC900 1";
        as6[6] = "BombGunSD500 1";
        AircraftLH.XweaponsRegister(class1, "1xSD500", as6);
        String as7[] = new String[11];
        as7[0] = "MGunMG131si 300";
        as7[1] = "MGunMG131si 300";
        as7[2] = "MGunMG15120MGki 200";
        as7[3] = "MGunMG15120MGki 60";
        as7[4] = "MGunMG15120MGki 60";
        AircraftLH.XweaponsRegister(class1, "light", as7);
        AircraftLH.XweaponsRegister(class1, "none", new String[11]); */
    }
}