package com.maddox.il2.objects.air;

import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.objects.Wreckage;
import com.maddox.rts.Property;

public class BF_109W2 extends BF_109
    implements TypeSailPlane
{

    public BF_109W2()
    {
        kangle = 0.0F;
        flapps = 0.0F;
        fMaxKMHSpeedForOpenCanopy = 250F;
        bHasBlister = true;
    }

    protected void moveRudder(float f)
    {
        hierMesh().chunkSetAngles("Rudder1_D0", 0.0F, -35F * f, 0.0F);
        hierMesh().chunkSetAngles("Rudder2_D0", 0.0F, -35F * f, 0.0F);
    }

    protected void moveElevator(float f)
    {
        hierMesh().chunkSetAngles("VatorL_D0", 0.0F, -20F * f, 0.0F);
        hierMesh().chunkSetAngles("VatorR_D0", 0.0F, -20F * f, 0.0F);
    }

    public void moveWheelSink()
    {
    }

    public void update(float f)
    {
        if(FM.getSpeed() > 5F)
        {
            hierMesh().chunkSetAngles("SlatL_D0", 0.0F, Aircraft.cvt(FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F), 0.0F);
            hierMesh().chunkSetAngles("SlatR_D0", 0.0F, Aircraft.cvt(FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F), 0.0F);
        }
        if(Math.abs(flapps - kangle) > 0.01F)
        {
            flapps = kangle;
            hierMesh().chunkSetAngles("Flap01L_D0", 0.0F, -16F * kangle, 0.0F);
            hierMesh().chunkSetAngles("Flap01U_D0", 0.0F, 16F * kangle, 0.0F);
            hierMesh().chunkSetAngles("Flap02L_D0", 0.0F, -16F * kangle, 0.0F);
            hierMesh().chunkSetAngles("Flap02U_D0", 0.0F, 16F * kangle, 0.0F);
        }
        kangle = 0.95F * kangle + 0.05F * FM.EI.engines[0].getControlRadiator();
        if(kangle > 1.0F)
            kangle = 1.0F;
        afterburnerhud();
        super.update(f);
        if(FM.isPlayers() && FM.Sq.squareElevators > 0.0F)
        {
            RealFlightModel realflightmodel = (RealFlightModel)FM;
            if(realflightmodel.RealMode && realflightmodel.fullMach > 0.7F)
            {
                float f2 = 1.0F + 3.84237F * (0.7F - realflightmodel.fullMach);
                if(f2 < 0.0F)
                    f2 = 0.0F;
                FM.SensPitch = 0.68F * f2;
                if(realflightmodel.fullMach > 0.636F)
                {
                    shake = 0.636F - realflightmodel.fullMach * f2;
                    realflightmodel.producedShakeLevel += shake * shake;
                    FM.producedAM.y += 6000F * shake * shake * 750F;
                    FM.producedAM.x -= 300F * ((0.636F - realflightmodel.fullMach) * 400F);
                }
            } else
            {
                FM.SensPitch = 0.68F;
            }
        }
        if(FM.CT.getCockpitDoor() > 0.2F && bHasBlister && FM.getSpeedKMH() > fMaxKMHSpeedForOpenCanopy && hierMesh().chunkFindCheck("Blister1_D0") != -1)
        {
            try
            {
                if(this == World.getPlayerAircraft())
                    ((CockpitBF_109G2)Main3D.cur3D().cockpitCur).removeCanopy();
            }
            catch(Exception exception) { }
            hierMesh().hideSubTrees("Blister1_D0");
            Wreckage wreckage = new Wreckage(this, hierMesh().chunkFind("Blister1_D0"));
            wreckage.collide(true);
            Vector3d vector3d = new Vector3d();
            vector3d.set(FM.Vwld);
            wreckage.setSpeed(vector3d);
            bHasBlister = false;
            FM.CT.bHasCockpitDoorControl = false;
            FM.setGCenter(-0.5F);
        }
    }

    public void moveCockpitDoor(float f)
    {
        if(bHasBlister)
        {
            resetYPRmodifier();
            hierMesh().chunkSetAngles("Blister1_D0", 0.0F, 100F * f, 0.0F);
            if(Config.isUSE_RENDER())
            {
                if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                    Main3D.cur3D().cockpits[0].onDoorMoved(f);
                setDoorSnd(f);
            }
        }
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("Hochleistung inbegriffen!");
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private float kangle;
    private float flapps;
    private float fMaxKMHSpeedForOpenCanopy;
    public boolean bHasBlister;
    private float shake;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.BF_109W2.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Bf109W-2");
        Property.set(class1, "meshName", "3DO/Plane/Bf-109W2/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar03());
        Property.set(class1, "yearService", 1942F);
        Property.set(class1, "yearExpired", 1947.5F);
        Property.set(class1, "FlightModel", "FlightModels/Bf-109W.fmd:Bf");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitBF_109G2.class
        });
        Property.set(class1, "LOSElevation", 0.7498F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 1, 1, 1, 0, 0, 0, 9, 9, 
            9, 9, 3, 3, 3, 3, 9, 9, 9, 9, 
            9, 9
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_CANNON02", "_CANNON03", "_CANNON04", "_CANNON05", "_CANNON06", "_ExternalDev01", "_ExternalDev02", 
            "_ExternalDev03", "_ExternalDev04", "_ExternalBomb01", "_ExternalBomb02", "_ExternalBomb03", "_ExternalBomb04", "_ExternalDev05", "_ExternalDev06", "_ExternalDev07", "_ExternalDev08", 
            "_ExternalDev09", "_ExternalDev10"
        });
/*         try
        {
            ArrayList arraylist = new ArrayList();
            Property.set(class1, "weaponsList", arraylist);
            HashMapInt hashmapint = new HashMapInt();
            Property.set(class1, "weaponsMap", hashmapint);
            byte byte0 = 22;
            Aircraft._WeaponSlot a_lweaponslot[] = new Aircraft._WeaponSlot[byte0];
            String s = "default";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMG15120MGki", 200);
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            a_lweaponslot[17] = null;
            a_lweaponslot[18] = null;
            a_lweaponslot[19] = null;
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "2xMG17+Mk103";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            a_lweaponslot[17] = null;
            a_lweaponslot[18] = null;
            a_lweaponslot[19] = null;
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "2xMG17+2xMG151-20+Mk103";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[11] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            a_lweaponslot[17] = null;
            a_lweaponslot[18] = null;
            a_lweaponslot[19] = null;
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "4xMG151-20+Mk103";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG15120ki", 200);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG15120ki", 200);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[11] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            a_lweaponslot[17] = null;
            a_lweaponslot[18] = null;
            a_lweaponslot[19] = null;
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "2xMG17+Mk103+2DT";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[17] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[18] = new Aircraft._WeaponSlot(9, "FuelTankGun_Type_D", 1);
            a_lweaponslot[19] = new Aircraft._WeaponSlot(9, "FuelTankGun_Type_D", 1);
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "2xMG151-20+Mk103+2DT";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG15120ki", 200);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG15120ki", 200);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[17] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[18] = new Aircraft._WeaponSlot(9, "FuelTankGun_Type_D", 1);
            a_lweaponslot[19] = new Aircraft._WeaponSlot(9, "FuelTankGun_Type_D", 1);
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "2xMG17+Mk103+2xSC250";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = new Aircraft._WeaponSlot(3, "BombGunSC250", 1);
            a_lweaponslot[13] = new Aircraft._WeaponSlot(3, "BombGunSC250", 1);
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[17] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[18] = null;
            a_lweaponslot[19] = null;
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "2xMG17+2xMG151-20+Mk103+2DT";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[11] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[17] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[18] = new Aircraft._WeaponSlot(9, "FuelTankGun_Type_D", 1);
            a_lweaponslot[19] = new Aircraft._WeaponSlot(9, "FuelTankGun_Type_D", 1);
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "2xMG17+2xMG151-20+Mk103+2xSC250";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG17si", 500);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[11] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[12] = new Aircraft._WeaponSlot(3, "BombGunSC250", 1);
            a_lweaponslot[13] = new Aircraft._WeaponSlot(3, "BombGunSC250", 1);
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[17] = new Aircraft._WeaponSlot(9, "PylonETC900", 1);
            a_lweaponslot[18] = null;
            a_lweaponslot[19] = null;
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "6xMG151-20+Mk103";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunMG15120ki", 200);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunMG15120ki", 200);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunMK103ki", 70);
            a_lweaponslot[3] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(1, "MGunMG15120kh", 150);
            a_lweaponslot[5] = new Aircraft._WeaponSlot(0, "MGunMG15120kh", 150);
            a_lweaponslot[6] = new Aircraft._WeaponSlot(0, "MGunMG15120kh", 150);
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[11] = new Aircraft._WeaponSlot(9, "PylonMG15120Internal", 1);
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            a_lweaponslot[17] = null;
            a_lweaponslot[18] = null;
            a_lweaponslot[19] = null;
            a_lweaponslot[20] = new Aircraft._WeaponSlot(9, "PylonMG15120", 1);
            a_lweaponslot[21] = new Aircraft._WeaponSlot(9, "PylonMG15120", 1);
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "none";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = null;
            a_lweaponslot[1] = null;
            a_lweaponslot[2] = null;
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            a_lweaponslot[17] = null;
            a_lweaponslot[18] = null;
            a_lweaponslot[19] = null;
            a_lweaponslot[20] = null;
            a_lweaponslot[21] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
        }
        catch(Exception exception) { } */
    }
}