package com.maddox.il2.objects.air;

import com.maddox.il2.ai.Regiment;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.rts.Property;
import com.maddox.rts.Finger;
import com.maddox.util.HashMapInt;
import java.util.ArrayList;

public class YAK_1series99 extends YAK
    implements TypeTNBFighter
{

    public YAK_1series99()
    {
        kl = 1.0F;  //NEW
        kr = 1.0F;  //NEW
        kc = 1.0F;  //NEW
        flapps = 0.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.1F;
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        float f3 = Math.max(-f2 * 1500F, -80F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, f3 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, f3 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC99_D0", 0.0F, 80F * f2 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC2_D0", 0.0F, 0.0F, 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, Math.max(-f * kl * 1500F, -65F), 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, Math.max(-f1 * kr * 1500F, -65F), 0.0F);
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 82.5F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, 82.5F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -85F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, -85F * f1 * kr, 0.0F);
		Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
		hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

/*     protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
    } */

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void moveSteering(float f)
    {
        hierMesh().chunkSetAngles("GearC2_D0", f, 0.0F, 0.0F);
    }

    public void update(float f)
    {
        float f1 = FM.EI.engines[0].getControlRadiator();
        if(Math.abs(flapps - f1) > 0.01F)
        {
            flapps = f1;
            hierMesh().chunkSetAngles("Wind_luk", 0.0F, f1 * 19F, 0.0F);
            hierMesh().chunkSetAngles("Water_luk", 0.0F, f1 * 15F, 0.0F);
        }
        super.update(f);
		hierMesh().chunkSetAngles("ZfuelL", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 0.0F, 160F, 0.0F, 130F), 0.0F);
        hierMesh().chunkSetAngles("ZfuelR", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 0.0F, 160F, 0.0F, 130F), 0.0F);

    }

    public void update_windluk(float f)
    {
        super.update(f);
    }

    public static String getSkinPrefix(String s, Regiment regiment)
    {
        if(regiment == null || regiment.country() == null)
            return "";
        if(regiment.country().equals(PaintScheme.countryFrance))
            return PaintScheme.countryFrance + "_";
        else
            return "";
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private static float kl = 1.0F;  //NEW
    private static float kr = 1.0F;  //NEW
    private static float kc = 1.0F;  //NEW
    private float flapps;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.YAK_1series99.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Yak");
        Property.set(class1, "meshName", "3DO/Plane/Yak-1B(Multi1)/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar02());
        Property.set(class1, "yearService", 1942.6F);
        Property.set(class1, "yearExpired", 1945.5F);
        Property.set(class1, "FlightModel", "FlightModels/Yak-1series99.fmd:YAK");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitYAK_1series99.class
        });
        Property.set(class1, "LOSElevation", 0.6759F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 1, 9, 9, 9, 9, 9, 9, 2, 2, 
            2, 2, 2, 2, 3, 3
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_CANNON01", "_ExternalDev01", "_ExternalDev02", "_ExternalDev03", "_ExternalDev04", "_ExternalDev05", "_ExternalDev06", "_ExternalRock01", "_ExternalRock02", 
            "_ExternalRock03", "_ExternalRock04", "_ExternalRock05", "_ExternalRock06", "_ExternalBomb01", "_ExternalBomb02"
        });
/*         try
        {
            ArrayList arraylist = new ArrayList();
            Property.set(class1, "weaponsList", arraylist);
            HashMapInt hashmapint = new HashMapInt();
            Property.set(class1, "weaponsMap", hashmapint);
            byte byte0 = 17;
            Aircraft._WeaponSlot a_lweaponslot[] = new Aircraft._WeaponSlot[byte0];
            String s = "default";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunUBsi", 200);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunShVAKki", 120);
            a_lweaponslot[2] = null;
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            String s1 = "6rs82";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunUBsi", 200);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunShVAKki", 120);
            a_lweaponslot[2] = null;
            a_lweaponslot[3] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[5] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[6] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[7] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[8] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[9] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[10] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[11] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[12] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[13] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[14] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            arraylist.add(s1);
            hashmapint.put(Finger.Int(s1), a_lweaponslot);
            String s2 = "2fab50";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunUBsi", 200);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunShVAKki", 120);
            a_lweaponslot[2] = null;
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = new Aircraft._WeaponSlot(3, "BombGunFAB50", 1);
            a_lweaponslot[16] = new Aircraft._WeaponSlot(3, "BombGunFAB50", 1);
            arraylist.add(s2);
            hashmapint.put(Finger.Int(s2), a_lweaponslot);
            String s3 = "2fab100";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunUBsi", 200);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunShVAKki", 120);
            a_lweaponslot[2] = null;
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = new Aircraft._WeaponSlot(3, "BombGunFAB100", 1);
            a_lweaponslot[16] = new Aircraft._WeaponSlot(3, "BombGunFAB100", 1);
            arraylist.add(s3);
            hashmapint.put(Finger.Int(s3), a_lweaponslot);
            s = "none";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = null;
            a_lweaponslot[1] = null;
            a_lweaponslot[2] = null;
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            a_lweaponslot[15] = null;
            a_lweaponslot[16] = null;
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
        }
        catch(Exception exception) { } */
    }
}