package com.maddox.il2.objects.air;

import com.maddox.JGP.Tuple3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.rts.Property;

public class YAK_3R extends YAK
{

    public YAK_3R()
    {
        bHasEngine = true;
        flame = null;
        dust = null;
        trail = null;
        sprite = null;
        kl = 1.0F;  //NEW
        kr = 1.0F;  //NEW
        kc = 1.0F;  //NEW
        flapps = 0.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.1F;
    }

    public void destroy()
    {
        if(Actor.isValid(flame))
            flame.destroy();
        if(Actor.isValid(dust))
            dust.destroy();
        if(Actor.isValid(trail))
            trail.destroy();
        if(Actor.isValid(sprite))
            sprite.destroy();
        super.destroy();
    }

    public void onAircraftLoaded()
    {
        super.onAircraftLoaded();
        ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = true;
        ((FlightModelMain) (super.FM)).CT.dvCockpitDoor = 0.65F;
        if(Config.isUSE_RENDER())
        {
            flame = Eff3DActor.New(this, findHook("_Engine2EF_01"), null, 1.0F, "3DO/Effects/Aircraft/TurboJRD1100F.eff", -1F);
            dust = Eff3DActor.New(this, findHook("_Engine2EF_01"), null, 1.0F, "3DO/Effects/Aircraft/TurboJRD1100D.eff", -1F);
            trail = Eff3DActor.New(this, findHook("_Engine2EF_01"), null, 1.0F, "3DO/Effects/Aircraft/TurboJRD1100T.eff", -1F);
            sprite = Eff3DActor.New(this, findHook("_Engine2EF_01"), null, 1.0F, "3DO/Effects/Aircraft/TurboJRD1100S.eff", -1F);
            Eff3DActor.setIntesity(flame, 0.0F);
            Eff3DActor.setIntesity(dust, 0.0F);
            Eff3DActor.setIntesity(trail, 0.0F);
            Eff3DActor.setIntesity(sprite, 0.0F);
        }
    }

    protected void moveFan(float dt)
    {
        if(!Config.isUSE_RENDER())
            return;
        super.moveFan(dt);
        if(isNetMirror())
        {
            if(((FlightModelMain) (super.FM)).EI.engines[1].getStage() == 6)
            {
                Eff3DActor.setIntesity(flame, 1.0F);
                Eff3DActor.setIntesity(dust, 1.0F);
                Eff3DActor.setIntesity(trail, 1.0F);
                Eff3DActor.setIntesity(sprite, 1.0F);
            } else
            {
                Eff3DActor.setIntesity(flame, 0.0F);
                Eff3DActor.setIntesity(dust, 0.0F);
                Eff3DActor.setIntesity(trail, 0.0F);
                Eff3DActor.setIntesity(sprite, 0.0F);
            }
        } else
        if(bHasEngine && ((FlightModelMain) (super.FM)).EI.engines[1].getControlThrottle() > 0.0F && ((FlightModelMain) (super.FM)).EI.engines[1].getStage() == 6)
        {
            Eff3DActor.setIntesity(flame, 1.0F);
            Eff3DActor.setIntesity(dust, 1.0F);
            Eff3DActor.setIntesity(trail, 1.0F);
            Eff3DActor.setIntesity(sprite, 1.0F);
        } else
        {
            Eff3DActor.setIntesity(flame, 0.0F);
            Eff3DActor.setIntesity(dust, 0.0F);
            Eff3DActor.setIntesity(trail, 0.0F);
            Eff3DActor.setIntesity(sprite, 0.0F);
        }
    }

    protected boolean cutFM(int partChunk, int typeHit, Actor initiator)
    {
        switch(partChunk)
        {
        case 19: // '\023'
            bHasEngine = false;
            ((FlightModelMain) (super.FM)).AS.setEngineDies(this, 1);
            return cut(Aircraft.partNames()[partChunk]);

        case 3: // '\003'
        case 4: // '\004'
            return false;
        }
        return super.cutFM(partChunk, typeHit, initiator);
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        float f3 = Math.max(-f2 * 1500F, -80F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, f3 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, f3 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC99_D0", 0.0F, 80F * f2 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC2_D0", 0.0F, 0.0F, 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, Math.max(-f * kl * 1500F, -60F), 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, Math.max(-f1 * kr * 1500F, -60F), 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -85F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, -85F * f1 * kr, 0.0F);
        f3 = -f1 + 0.01F * (float)Math.sin((double)f1 * 3.1415926535897931D);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, 82.5F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearR51_D0", 0.0F, 63F * f3 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearR52_D0", 0.0F, -180F * f3 * kr, 0.0F);
        f3 = Math.min(-f + 0.01F * (float)Math.sin((double)(f * 1.24F) * 3.1415926535897931D), 1.0F);
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 82.5F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearL51_D0", 0.0F, 63F * f3 * kl, 0.0F);
        hiermesh.chunkSetAngles("GearL52_D0", 0.0F, -180F * f3 * kl, 0.0F);
		Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
		hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

/*     protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
    } */

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void update(float dt)
    {
        super.update(dt);
        if(isNetMirror())
            return;
        bPowR = this == World.getPlayerAircraft();
        if((double)super.FM.getAltitude() - Engine.land().HQ(((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).x, ((Tuple3d) (((FlightModelMain) (super.FM)).Loc)).y) > 5D && ((FlightModelMain) (super.FM)).M.fuel > 0.0F)
        {
            if(((FlightModelMain) (super.FM)).EI.engines[1].getControlThrottle() > (bPowR ? 0.4120879F : 0.77F) && (((FlightModelMain) (super.FM)).EI.engines[1].getStage() == 0 && ((FlightModelMain) (super.FM)).M.nitro > 0.0F))
            {
                ((FlightModelMain) (super.FM)).EI.engines[1].setStage(this, 6);
                if(bPowR)
                    HUD.log("EngineI" + (((FlightModelMain) (super.FM)).EI.engines[1].getStage() != 6 ? 48 : '1'));
            }
            if(((FlightModelMain) (super.FM)).EI.engines[1].getControlThrottle() < (bPowR ? 0.4120879F : 0.77F) && ((FlightModelMain) (super.FM)).EI.engines[1].getStage() > 0)
            {
                ((FlightModelMain) (super.FM)).EI.engines[1].setEngineStops(this);
                if(bPowR)
                    HUD.log("EngineI" + (((FlightModelMain) (super.FM)).EI.engines[1].getStage() != 6 ? 48 : '1'));
            }
        }
        float f = ((FlightModelMain) (super.FM)).EI.engines[0].getControlRadiator();
        if(Math.abs(flapps - f) > 0.01F)
        {
            flapps = f;
            hierMesh().chunkSetAngles("OilRad_D0", 0.0F, f * 25F, 0.0F);
            hierMesh().chunkSetAngles("Water_luk", 0.0F, f * 12F, 0.0F);
        }
        hierMesh().chunkSetAngles("ZfuelL", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 12F, 274F, 0.0F, 124F), 0.0F);
        hierMesh().chunkSetAngles("ZfuelR", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 12F, 274F, 0.0F, 124F), 0.0F);
    }

    public void moveCockpitDoor(float f)
    {
        resetYPRmodifier();
        Aircraft.xyz[0] = -Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 0.55F);
        hierMesh().chunkSetLocate("Blister1_D0", Aircraft.xyz, Aircraft.ypr);
        if(Config.isUSE_RENDER())
        {
            if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                Main3D.cur3D().cockpits[0].onDoorMoved(f);
            setDoorSnd(f);
        }
    }

    private static final float powR = 0.4120879F;
    private static final float powA = 0.77F;
    private boolean bHasEngine;
    private Eff3DActor flame;
    private Eff3DActor dust;
    private Eff3DActor trail;
    private Eff3DActor sprite;
    private boolean bPowR;
    private static Vector3d v = new Vector3d();
    private static float kl = 1.0F;  //NEW
    private static float kr = 1.0F;  //NEW
    private static float kc = 1.0F;  //NEW
    private float flapps;

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    static 
    {
        Class class1 = com.maddox.il2.objects.air.YAK_3R.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Yak");
        Property.set(class1, "meshName", "3DO/Plane/Yak-3R(Multi1)/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar05());
        Property.set(class1, "yearService", 1944F);
        Property.set(class1, "yearExpired", 1948.5F);
        Property.set(class1, "FlightModel", "FlightModels/Yak-3R.fmd:YAK");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitYAK_3R.class
        });
        Property.set(class1, "LOSElevation", 0.6576F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            1
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_CANNON01"
        });
/*         Aircraft.weaponsRegister(class1, "default", new String[] {
            "MGunNS23si 60"
        });
        Aircraft.weaponsRegister(class1, "none", new String[1]); */
    }
}