package com.maddox.il2.objects.air;

import com.maddox.il2.engine.Config;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.Main3D;
/* import com.maddox.il2.objects.sounds.SndAircraft; */
/* import com.maddox.util.HashMapInt;
import java.io.IOException;
import java.util.ArrayList; */
import com.maddox.rts.*;
/* import com.maddox.rts.Finger; */
import com.maddox.rts.Property;

public class YAK_3U extends YAK_M82
{

    public YAK_3U()
    {
    }

    public void moveCockpitDoor(float f)
    {
        resetYPRmodifier();
        Aircraft.xyz[0] = -Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 0.50F);
        hierMesh().chunkSetLocate("Blister1_D0", Aircraft.xyz, Aircraft.ypr);
        if(Config.isUSE_RENDER())
        {
            if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                Main3D.cur3D().cockpits[0].onDoorMoved(f);
            setDoorSnd(f);
        }
    }

    public static void moveGear(HierMesh hiermesh, float f)
    {
        hiermesh.chunkSetAngles("GearC99_D0", 0.0F, Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 70F), 0.0F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, Aircraft.cvt(f, 0.0F, 0.2F, 0.0F, -60F), 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, Aircraft.cvt(f, 0.0F, 0.2F, 0.0F, 60F), 0.0F);
        hiermesh.chunkSetAngles("GearC5_D0", 0.0F, Aircraft.cvt(f, 0.0F, 0.5F, 0.0F, -8F), 0.0F);
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, Aircraft.cvt(f, 0.1F, 0.99F, 0.0F, -83F), 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, Aircraft.cvt(f, 0.1F, 0.8F, 0.0F, -2F), 0.0F);
        hiermesh.chunkSetAngles("GearL29_D0", 0.0F, Aircraft.cvt(f, 0.1F, 0.14F, 0.0F, -54F), 0.0F);
        hiermesh.chunkSetAngles("GearL5_D0", 0.0F, Aircraft.cvt(f, 0.14F, 0.22F, 0.0F, -28F), 0.0F);
        hiermesh.chunkSetAngles("GearL8_D0", 0.0F, Aircraft.cvt(f, 0.1F, 0.14F, 0.0F, 33F), 0.0F);
        hiermesh.chunkSetAngles("GearL7_D0", 0.0F, Aircraft.cvt(f, 0.14F, 0.18F, 0.0F, 1.0F), 0.0F);
        hiermesh.chunkSetAngles("GearL6_D0", 0.0F, Aircraft.cvt(f, 0.18F, 0.22F, 0.0F, -22F), 0.0F);
        hiermesh.chunkSetAngles("GearL11_D0", 0.0F, Aircraft.cvt(f, 0.1F, 0.14F, 0.0F, -28F), 0.0F);
        hiermesh.chunkSetAngles("GearL10_D0", 0.0F, Aircraft.cvt(f, 0.14F, 0.18F, 0.0F, -6F), 0.0F);
        hiermesh.chunkSetAngles("GearL9_D0", 0.0F, Aircraft.cvt(f, 0.18F, 0.22F, 0.0F, -16F), 0.0F);
        hiermesh.chunkSetAngles("GearL13_D0", 0.0F, Aircraft.cvt(f, 0.1F, 0.25F, 0.0F, 16F), 0.0F);
        hiermesh.chunkSetAngles("GearL14_D0", 0.0F, Aircraft.cvt(f, 0.25F, 0.4F, 0.0F, 18.6F), 0.0F);
        hiermesh.chunkSetAngles("GearL21_D0", 0.0F, Aircraft.cvt(f, 0.4F, 0.55F, 0.0F, 21.5F), 0.0F);
        hiermesh.chunkSetAngles("GearL22_D0", 0.0F, Aircraft.cvt(f, 0.55F, 0.7F, 0.0F, 23.5F), 0.0F);
        hiermesh.chunkSetAngles("GearL23_D0", 0.0F, Aircraft.cvt(f, 0.7F, 0.85F, 0.0F, 28F), 0.0F);
        hiermesh.chunkSetAngles("GearL24_D0", 0.0F, Aircraft.cvt(f, 0.85F, 0.9F, 0.0F, 12.5F), 0.0F);
        hiermesh.chunkSetAngles("GearL12_D0", 0.0F, Aircraft.cvt(f, 0.9F, 0.99F, 0.0F, 43F), 0.0F);
        hiermesh.chunkSetAngles("GearL16_D0", 0.0F, Aircraft.cvt(f, 0.1F, 0.25F, 0.0F, 11.5F), 0.0F);
        hiermesh.chunkSetAngles("GearL17_D0", 0.0F, Aircraft.cvt(f, 0.25F, 0.4F, 0.0F, 0.6F), 0.0F);
        hiermesh.chunkSetAngles("GearL25_D0", 0.0F, Aircraft.cvt(f, 0.4F, 0.55F, 0.0F, -2.5F), 0.0F);
        hiermesh.chunkSetAngles("GearL26_D0", 0.0F, Aircraft.cvt(f, 0.55F, 0.7F, 0.0F, -5F), 0.0F);
        hiermesh.chunkSetAngles("GearL27_D0", 0.0F, Aircraft.cvt(f, 0.7F, 0.85F, 0.0F, -7F), 0.0F);
        hiermesh.chunkSetAngles("GearL28_D0", 0.0F, Aircraft.cvt(f, 0.85F, 0.9F, 0.0F, -4.5F), 0.0F);
        hiermesh.chunkSetAngles("GearL15_D0", 0.0F, Aircraft.cvt(f, 0.9F, 0.99F, 0.0F, -19.8F), 0.0F);
        hiermesh.chunkSetAngles("GearL20_D0", 0.0F, Aircraft.cvt(f, 0.1F, 0.8F, 0.0F, -6F), 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, Aircraft.cvt(f, 0.01F, 0.89F, 0.0F, -83F), 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, Aircraft.cvt(f, 0.01F, 0.7F, 0.0F, -2F), 0.0F);
        hiermesh.chunkSetAngles("GearR29_D0", 0.0F, Aircraft.cvt(f, 0.01F, 0.04F, 0.0F, -54F), 0.0F);
        hiermesh.chunkSetAngles("GearR5_D0", 0.0F, Aircraft.cvt(f, 0.04F, 0.12F, 0.0F, -28F), 0.0F);
        hiermesh.chunkSetAngles("GearR8_D0", 0.0F, Aircraft.cvt(f, 0.01F, 0.04F, 0.0F, 33F), 0.0F);
        hiermesh.chunkSetAngles("GearR7_D0", 0.0F, Aircraft.cvt(f, 0.04F, 0.08F, 0.0F, 1.0F), 0.0F);
        hiermesh.chunkSetAngles("GearR6_D0", 0.0F, Aircraft.cvt(f, 0.08F, 0.12F, 0.0F, -22F), 0.0F);
        hiermesh.chunkSetAngles("GearR11_D0", 0.0F, Aircraft.cvt(f, 0.01F, 0.04F, 0.0F, 28F), 0.0F);
        hiermesh.chunkSetAngles("GearR10_D0", 0.0F, Aircraft.cvt(f, 0.04F, 0.08F, 0.0F, 6F), 0.0F);
        hiermesh.chunkSetAngles("GearR9_D0", 0.0F, Aircraft.cvt(f, 0.08F, 0.12F, 0.0F, 16F), 0.0F);
        hiermesh.chunkSetAngles("GearR13_D0", 0.0F, Aircraft.cvt(f, 0.01F, 0.15F, 0.0F, -16F), 0.0F);
        hiermesh.chunkSetAngles("GearR14_D0", 0.0F, Aircraft.cvt(f, 0.15F, 0.3F, 0.0F, -18.6F), 0.0F);
        hiermesh.chunkSetAngles("GearR21_D0", 0.0F, Aircraft.cvt(f, 0.3F, 0.45F, 0.0F, -21.5F), 0.0F);
        hiermesh.chunkSetAngles("GearR22_D0", 0.0F, Aircraft.cvt(f, 0.45F, 0.6F, 0.0F, -23.5F), 0.0F);
        hiermesh.chunkSetAngles("GearR23_D0", 0.0F, Aircraft.cvt(f, 0.6F, 0.75F, 0.0F, -28F), 0.0F);
        hiermesh.chunkSetAngles("GearR24_D0", 0.0F, Aircraft.cvt(f, 0.75F, 0.8F, 0.0F, -12.5F), 0.0F);
        hiermesh.chunkSetAngles("GearR12_D0", 0.0F, Aircraft.cvt(f, 0.8F, 0.89F, 0.0F, -43F), 0.0F);
        hiermesh.chunkSetAngles("GearR16_D0", 0.0F, Aircraft.cvt(f, 0.01F, 0.15F, 0.0F, -11.5F), 0.0F);
        hiermesh.chunkSetAngles("GearR17_D0", 0.0F, Aircraft.cvt(f, 0.15F, 0.3F, 0.0F, -0.6F), 0.0F);
        hiermesh.chunkSetAngles("GearR25_D0", 0.0F, Aircraft.cvt(f, 0.3F, 0.45F, 0.0F, 2.5F), 0.0F);
        hiermesh.chunkSetAngles("GearR26_D0", 0.0F, Aircraft.cvt(f, 0.45F, 0.6F, 0.0F, 5F), 0.0F);
        hiermesh.chunkSetAngles("GearR27_D0", 0.0F, Aircraft.cvt(f, 0.6F, 0.75F, 0.0F, 7F), 0.0F);
        hiermesh.chunkSetAngles("GearR28_D0", 0.0F, Aircraft.cvt(f, 0.75F, 0.8F, 0.0F, 4.5F), 0.0F);
        hiermesh.chunkSetAngles("GearR15_D0", 0.0F, Aircraft.cvt(f, 0.8F, 0.89F, 0.0F, 19.8F), 0.0F);
        hiermesh.chunkSetAngles("GearR20_D0", 0.0F, Aircraft.cvt(f, 0.01F, 0.7F, 0.0F, -6F), 0.0F);
    }

    protected void moveGear(float f)
    {
        moveGear(hierMesh(), f);
        resetYPRmodifier();
        Aircraft.xyz[1] = Aircraft.cvt(f, 0.1F, 0.99F, 0.0F, 0.12F);
        hierMesh().chunkSetLocate("GearL18_D0", Aircraft.xyz, Aircraft.ypr);
        Aircraft.xyz[1] = Aircraft.cvt(f, 0.01F, 0.85F, 0.0F, -0.12F);
        hierMesh().chunkSetLocate("GearR18_D0", Aircraft.xyz, Aircraft.ypr);
        resetYPRmodifier();
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
        hierMesh().chunkSetLocate("GearL19_D0", Aircraft.xyz, Aircraft.ypr);
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
        hierMesh().chunkSetLocate("GearR19_D0", Aircraft.xyz, Aircraft.ypr);
        resetYPRmodifier();
        Aircraft.xyz[0] = Aircraft.cvt(f, 0.01F, 1.0F, 0.0F, -0.2F);
        hierMesh().chunkSetLocate("GearC6_D0", Aircraft.xyz, Aircraft.ypr);
    }

    public void moveWheelSink()
    {
        resetYPRmodifier();
        Aircraft.xyz[2] = Aircraft.cvt(((FlightModelMain) (super.FM)).Gears.gWheelSinking[0], 0.01F, 0.22F, 0.0F, 0.2F);
        hierMesh().chunkSetLocate("GearL3_D0", Aircraft.xyz, Aircraft.ypr);
        Aircraft.xyz[2] = Aircraft.cvt(((FlightModelMain) (super.FM)).Gears.gWheelSinking[1], 0.01F, 0.22F, 0.0F, 0.2F);
        hierMesh().chunkSetLocate("GearR3_D0", Aircraft.xyz, Aircraft.ypr);
    }

    public void moveSteering(float f)
    {
        hierMesh().chunkSetAngles("GearC2_D0", f, 0.0F, 0.0F);
    }

    protected void moveFlap(float f)
    {
        hierMesh().chunkSetAngles("Flap01_D0", 0.0F, -50F * f, 0.0F);
        hierMesh().chunkSetAngles("Flap02_D0", 0.0F, -50F * f, 0.0F);
    }

    public void onAircraftLoaded()
    {
        super.onAircraftLoaded();
        ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = true;
        ((FlightModelMain) (super.FM)).CT.dvCockpitDoor = 0.65F;
    }

    public void update(float f)
    {
        hierMesh().chunkSetAngles("OilRad_D0", 0.0F, FM.EI.engines[0].getControlRadiator() * 25F, 0.0F);
        hierMesh().chunkSetAngles("Water_luk", 0.0F, FM.EI.engines[0].getControlRadiator() * 25F, 0.0F);
        super.update(f);
        hierMesh().chunkSetAngles("ZfuelL", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 6F, 277F, 0.0F, 130F), 0.0F);
        hierMesh().chunkSetAngles("ZfuelR", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 6F, 277F, 0.0F, 130F), 0.0F);
    }

/*     private static Aircraft._WeaponSlot[] GenerateDefaultConfig(int i)
    {
        Aircraft._WeaponSlot a_lweaponslot[] = new Aircraft._WeaponSlot[i];
        try
        {
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunB20si", 140);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunB20si", 140);
            a_lweaponslot[2] = null; 
        }
        catch(Exception exception) { }
        return a_lweaponslot;
    } */

    static java.lang.Class _mthclass$(java.lang.String s)
    {
        java.lang.Class class1;
        try
        {
            class1 = java.lang.Class.forName(s);
        }
        catch(java.lang.ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    static 
    {
        Class class1 = com.maddox.il2.objects.air.YAK_3U.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Yak-3U");
        Property.set(class1, "meshName", "3DO/Plane/Yak-3U/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar05());
        Property.set(class1, "yearService", 1944F);
        Property.set(class1, "yearExpired", 1948.5F);
        Property.set(class1, "FlightModel", "FlightModels/Yak-3U.fmd:YAK");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitYAK_3U.class
        });
        Property.set(class1, "LOSElevation", 0.6576F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 1
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01"
        });
/*         try
        {
           ArrayList arraylist = new ArrayList();
            Property.set(class1, "weaponsList", arraylist);
            HashMapInt hashmapint = new HashMapInt();
            Property.set(class1, "weaponsMap", hashmapint);
            byte byte0 = 3;
            Aircraft._WeaponSlot a_lweaponslot[] = new Aircraft._WeaponSlot[byte0];
            String s = "default";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunB20si", 140);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunB20si", 140);
            a_lweaponslot[2] = null; 
            for(int i = 3; i < byte0; i++)
                a_lweaponslot[i] = null;  

            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "2xShVAK";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunShVAKki", 140);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(0, "MGunShVAKki", 140);
            a_lweaponslot[2] = null;
            for(int i1 = 3; i1 < byte0; i1++)
                a_lweaponslot[i1] = null;
                        
            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "None";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = null;
            a_lweaponslot[1] = null;
            a_lweaponslot[2] = null;
            for(int l = 0; l < byte0; l++)
                a_lweaponslot[l] = null;

            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
        }
        catch(Exception exception) { } */
    }
}