package com.maddox.il2.objects.air;

import com.maddox.il2.ai.Regiment;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.rts.Property;

public class YAK_7AEarly extends YAK
    implements TypeTNBFighter
{

    public YAK_7AEarly()
    {
        kl = 1.0F;  //NEW
        kr = 1.0F;  //NEW
        kc = 1.0F;  //NEW
        flapps = 0.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.05F;
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, Math.max(-f * kl * 1500F, -75F), 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, Math.max(-f1 * kr * 1500F, -75F), 0.0F);
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, -82.5F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, -82.5F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -85F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, -85F * f1 * kr, 0.0F);
		Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
		hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

/*     protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
    } */

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void moveSteering(float f)
    {
        hierMesh().chunkSetAngles("GearC2_D0", f, 0.0F, 0.0F);
    }

    public void update(float f)
    {
        float f1 = FM.EI.engines[0].getControlRadiator();
        if(Math.abs(flapps - f1) > 0.01F)
        {
            flapps = f1;
            hierMesh().chunkSetAngles("Water_luk", 0.0F, 20F * f1, 0.0F);
            hierMesh().chunkSetAngles("Oil_luk", 0.0F, 24F * f1, 0.0F);
        }
        super.update(f);
		hierMesh().chunkSetAngles("ZfuelL", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 0.0F, 260F, 0.0F, 130F), 0.0F);
        hierMesh().chunkSetAngles("ZfuelR", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 0.0F, 260F, 0.0F, 130F), 0.0F);
    }

    public static String getSkinPrefix(String s, Regiment regiment)
    {
        return "AE_";
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private static float kl = 1.0F;  //NEW
    private static float kr = 1.0F;  //NEW
    private static float kc = 1.0F;  //NEW
    private float flapps;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.YAK_7AEarly.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Yak");
        Property.set(class1, "meshName", "3DO/Plane/Yak-7B(Multi1)/hier_AEarly.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar02());
        Property.set(class1, "yearService", 1941F);
        Property.set(class1, "yearExpired", 1945.5F);
        Property.set(class1, "FlightModel", "FlightModels/Yak-7A.fmd:YAK");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitYAK_7AE.class
                    });
        Property.set(class1, "LOSElevation", 0.6116F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 1, 9, 9, 9, 9, 9, 9, 2, 
            2, 2, 2, 2, 2, 3, 3
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_ExternalDev01", "_ExternalDev02", "_ExternalDev03", "_ExternalDev04", "_ExternalDev05", "_ExternalDev06", "_ExternalRock01", 
            "_ExternalRock02", "_ExternalRock03", "_ExternalRock04", "_ExternalRock05", "_ExternalRock06", "_ExternalBomb01", "_ExternalBomb02"
        });
/*         Aircraft.weaponsRegister(class1, "default", new String[] {
            "MGunShKASsi 750", "MGunShKASsi 750", "MGunShVAKki 120", null, null, null, null, null, null, null, 
            null, null, null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "6xRS82", new String[] {
            "MGunShKASsi 750", "MGunShKASsi 750", "MGunShVAKki 120", "PylonRO_82_1", "PylonRO_82_1", "PylonRO_82_1", "PylonRO_82_1", "PylonRO_82_1", "PylonRO_82_1", "RocketGunRS82", 
            "RocketGunRS82", "RocketGunRS82", "RocketGunRS82", "RocketGunRS82", "RocketGunRS82", null, null
        });
        Aircraft.weaponsRegister(class1, "none", new String[] {
            null, null, null, null, null, null, null, null, null, null, 
            null, null, null, null, null, null, null
        }); */
    }
}