package com.maddox.il2.objects.air;

import com.maddox.il2.engine.Config;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.il2.game.Main3D;
import com.maddox.rts.Property;

public class YAK_7M_82 extends YAK_M82
    implements TypeFighter, TypeBNZFighter
{

    public YAK_7M_82()
    {
        flapps = 0.0F;
        kl = 1.0F;
        kr = 1.0F;
        kc = 1.0F;
    }

    public void moveCockpitDoor(float f)
    {
        resetYPRmodifier();
        Aircraft.xyz[0] = -Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 0.52F);
        hierMesh().chunkSetLocate("Blister1_D0", Aircraft.xyz, Aircraft.ypr);
        if(Config.isUSE_RENDER())
        {
            if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                Main3D.cur3D().cockpits[0].onDoorMoved(f);
            setDoorSnd(f);
        }
    }

    public void moveSteering(float f)
    {
    }

    public void moveWheelSink()
    {
    }

    protected void moveFlap(float f)
    {
        hierMesh().chunkSetAngles("Flap01_D0", 0.0F, -45F * f, 0.0F);
        hierMesh().chunkSetAngles("Flap02_D0", 0.0F, -45F * f, 0.0F);
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        float f3 = Math.max(-f2 * 1500F, -80F);
        hiermesh.chunkSetAngles("GearC2_D0", 0.0F, 80F * f2 *kc, 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, Math.max(-f * kl * 1500F, -60F), 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, Math.max(-f1 * kr * 1500F, -60F), 0.0F);
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, -82.5F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, -82.5F * f1, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -85F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, -85F * f1 * kr, 0.0F);
		Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
		hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void update(float f)
    {
        float f1 = ((FlightModelMain) (super.FM)).EI.engines[0].getControlRadiator();
        if(Math.abs(flapps - f1) > 0.01F)
        {
            flapps = f1;
            hierMesh().chunkSetAngles("Water_luk", 0.0F, 12F * f1, 0.0F);
            hierMesh().chunkSetAngles("Oil_luk", 0.0F, 24F * f1, 0.0F);
        }
        super.update(f);
		hierMesh().chunkSetAngles("ZfuelL", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 6F, 266F, 0.0F, 130F), 0.0F);
        hierMesh().chunkSetAngles("ZfuelR", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 6F, 266F, 0.0F, 130F), 0.0F);
    }

    static java.lang.Class _mthclass$(java.lang.String s)
    {
        java.lang.Class class1;
        try
        {
            class1 = java.lang.Class.forName(s);
        }
        catch(java.lang.ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private float flapps;
    private static float kl = 1.0F;
    private static float kr = 1.0F;
    private static float kc = 1.0F;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.YAK_7M_82.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Yak-7M-82");
        Property.set(class1, "meshName", "3DO/Plane/Yak-7M82/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar04());
        Property.set(class1, "yearService", 1944F);
        Property.set(class1, "yearExpired", 1945.5F);
        Property.set(class1, "FlightModel", "FlightModels/Yak-7M-82.fmd:YAK");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitYAK_7M_82.class
        });
        Property.set(class1, "LOSElevation", 0.6576F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            1, 1, 0, 9, 9, 9, 9, 9, 9, 2, 
            2, 2, 2, 2, 2
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_CANNON01", "_CANNON02", "_MGUN01", "_ExternalDev01", "_ExternalDev02", "_ExternalDev03", "_ExternalDev04", "_ExternalDev05", "_ExternalDev06", "_ExternalRock01", 
            "_ExternalRock02", "_ExternalRock03", "_ExternalRock04", "_ExternalRock05", "_ExternalRock06"
        });
/*         try
        {
            ArrayList arraylist = new ArrayList();
            Property.set(class1, "weaponsList", arraylist);
            HashMapInt hashmapint = new HashMapInt();
            Property.set(class1, "weaponsMap", hashmapint);
            byte byte0 = 15;
            String s = "default";
            Aircraft._WeaponSlot a_lweaponslot[] = new Aircraft._WeaponSlot[byte0];
            s = "default";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunUBsi", 260);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(1, "MGunShVAKk", 120);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunShVAKk", 120);
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            for(int i = 15; i < byte0; i++)
                a_lweaponslot[i] = null;

            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "6xRS82";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = new Aircraft._WeaponSlot(0, "MGunUBsi", 260);
            a_lweaponslot[1] = new Aircraft._WeaponSlot(1, "MGunShVAKk", 120);
            a_lweaponslot[2] = new Aircraft._WeaponSlot(1, "MGunShVAKk", 120);
            a_lweaponslot[3] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[4] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[5] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[6] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[7] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[8] = new Aircraft._WeaponSlot(9, "PylonRO_82_1", 1);
            a_lweaponslot[9] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[10] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[11] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[12] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[13] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            a_lweaponslot[14] = new Aircraft._WeaponSlot(2, "RocketGunRS82", 1);
            for(int j = 15; j < byte0; j++)
                a_lweaponslot[j] = null;

            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
            s = "none";
            a_lweaponslot = new Aircraft._WeaponSlot[byte0];
            a_lweaponslot[0] = null;
            a_lweaponslot[1] = null;
            a_lweaponslot[2] = null;
            a_lweaponslot[3] = null;
            a_lweaponslot[4] = null;
            a_lweaponslot[5] = null;
            a_lweaponslot[6] = null;
            a_lweaponslot[7] = null;
            a_lweaponslot[8] = null;
            a_lweaponslot[9] = null;
            a_lweaponslot[10] = null;
            a_lweaponslot[11] = null;
            a_lweaponslot[12] = null;
            a_lweaponslot[13] = null;
            a_lweaponslot[14] = null;
            for(int l = 0; l < byte0; l++)
                a_lweaponslot[l] = null;

            arraylist.add(s);
            hashmapint.put(Finger.Int(s), a_lweaponslot);
        }
        catch(Exception exception) { } */
    }
}