package com.maddox.il2.objects.air;

import com.maddox.il2.engine.Config;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.il2.game.Main3D;
import com.maddox.rts.Property;

public class YAK_9B extends YAK
    implements TypeBNZFighter, TypeStormovik
{
    public YAK_9B()
    {
        kl = 1.0F;  //NEW
        kr = 1.0F;  //NEW
        kc = 1.0F;  //NEW
        flapps = 0.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.05F;
    }

    public void moveCockpitDoor(float f)
    {
        resetYPRmodifier();
        Aircraft.xyz[0] = -Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 0.50F);
        hierMesh().chunkSetLocate("Blister1_D0", Aircraft.xyz, Aircraft.ypr);
        if(Config.isUSE_RENDER())
        {
            if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                Main3D.cur3D().cockpits[0].onDoorMoved(f);
            setDoorSnd(f);
        }
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        float f3 = Math.max(-f2 * 1500F, -80F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, f3 *kc, 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, f3 *kc, 0.0F);
        hiermesh.chunkSetAngles("GearC2_D0", 0.0F, 80F * f2 *kc, 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, Math.max(-f * kl * 1500F, -75F), 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, Math.max(-f1 * kr * 1500F, -75F), 0.0F);
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 82.5F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, 82.5F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -85F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, -85F * f1 * kr, 0.0F);
		Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
		hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

/*     protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
    } */

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void moveSteering(float f)
    {
    }

    protected void moveBayDoor(float f)
    {
        hierMesh().chunkSetAngles("Bay1_D0", 0.0F, -90F * f, 0.0F);
        hierMesh().chunkSetAngles("Bay2_D0", 0.0F, -90F * f, 0.0F);
    }

    public void update(float f)
    {
        float f1 = FM.EI.engines[0].getControlRadiator();
        if(Math.abs(flapps - f1) > 0.01F)
        {
            flapps = f1;
            hierMesh().chunkSetAngles("Wind_luk", 0.0F, 12F * f1, 0.0F);
            hierMesh().chunkSetAngles("Water_luk", 0.0F, 12F * f1, 0.0F);
        }
		hierMesh().chunkSetAngles("ZfuelL", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 50F, 550F, -25F, 155F), 0.0F);
        hierMesh().chunkSetAngles("ZfuelR", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 50F, 550F, -25F, 155F), 0.0F);
        super.update(f);
        int i = 0;
        if(FM.CT.Weapons[3] != null)
        {
            for(int j = 0; j < FM.CT.Weapons[3].length; j++)
                if(FM.CT.Weapons[3][j] != null && FM.CT.Weapons[3][j].haveBullets())
                    i++;

        }
        float f2 = 0.14F;
        switch(i)
        {
        case 0: // '\0'
        default:
            FM.setGCenter(0.1F);
            FM.setGC_Gear_Shift(0.0F);
            break;

        case 1: // '\001'
            FM.setGCenter(0.1F - f2);
            FM.setGC_Gear_Shift(0.0F + f2);
            // fall through

        case 2: // '\002'
            FM.setGCenter(0.1F - 2.0F * f2);
            FM.setGC_Gear_Shift(0.0F + 2.0F * f2);
            break;

        case 3: // '\003'
            FM.setGCenter(0.1F - 3F * f2);
            FM.setGC_Gear_Shift(0.0F + 3F * f2);
            break;

        case 4: // '\004'
            FM.setGCenter(0.1F - 4F * f2);
            FM.setGC_Gear_Shift(0.0F + 4F * f2);
            break;
        }
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private static float kl = 1.0F;  //NEW
    private static float kr = 1.0F;  //NEW
    private static float kc = 1.0F;  //NEW
    private float flapps;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.YAK_9B.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Yak");
        Property.set(class1, "meshName", "3DO/Plane/Yak-9B(Multi1)/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar05());
        Property.set(class1, "yearService", 1944F);
        Property.set(class1, "yearExpired", 1952.8F);
        Property.set(class1, "FlightModel", "FlightModels/Yak-9B.fmd:YAK");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitYAK_9B.class
        });
        Property.set(class1, "LOSElevation", 0.6432F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 
            9, 9, 9, 9
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_CANNON01", "_BombSpawn01", "_BombSpawn02", "_BombSpawn03", "_BombSpawn04", "_BombSpawn05", "_BombSpawn06", "_BombSpawn07", "_BombSpawn08", 
            "_ExternalDev01", "_ExternalDev02", "_ExternalDev03", "_ExternalDev04"
        });
/*         Aircraft.weaponsRegister(class1, "default", new String[] {
            "MGunUBsi 200", "MGunShVAKki 120", null, null, null, null, null, null, null, null, 
            null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "2fab100", new String[] {
            "MGunUBsi 200", "MGunShVAKki 120", null, null, "BombGunFAB100 1", "BombGunFAB100 1", null, null, null, null, 
            null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "3fab100", new String[] {
            "MGunUBsi 200", "MGunShVAKki 120", "BombGunFAB100 1", "BombGunNull 1", "BombGunFAB100 1", "BombGunFAB100 1", null, null, null, null, 
            null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "4fab100", new String[] {
            "MGunUBsi 200", "MGunShVAKki 120", "BombGunFAB100 1", "BombGunFAB100 1", "BombGunFAB100 1", "BombGunFAB100 1", null, null, null, null, 
            null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "2ptab", new String[] {
            "MGunUBsi 200", "MGunShVAKki 120", null, null, null, null, null, null, "BombGunPTAB25", "BombGunPTAB25", 
            "PylonKMB", "PylonKMB", "PylonKMB", "PylonKMB"
        });
        Aircraft.weaponsRegister(class1, "4ptab", new String[] {
            "MGunUBsi 200", "MGunShVAKki 120", null, null, null, null, "BombGunPTAB25", "BombGunPTAB25", "BombGunPTAB25", "BombGunPTAB25", 
            "PylonKMB", "PylonKMB", "PylonKMB", "PylonKMB"
        });
        Aircraft.weaponsRegister(class1, "none", new String[] {
            null, null, null, null, null, null, null, null, null, null, 
            null, null, null, null
        }); */
    }
}