package com.maddox.il2.objects.air;

import com.maddox.il2.engine.Config;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.il2.game.Main3D;

public abstract class YAK_9TX extends YAK
    implements TypeStormovik
{

    public YAK_9TX()
    {
        kl = 1.0F;  //NEW
        kr = 1.0F;  //NEW
        kc = 1.0F;  //NEW
        flapps = 0.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.05F;
    }

    public void moveCockpitDoor(float f)
    {
        resetYPRmodifier();
        Aircraft.xyz[0] = -Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 0.50F);
        hierMesh().chunkSetLocate("Blister1_D0", Aircraft.xyz, Aircraft.ypr);
        if(Config.isUSE_RENDER())
        {
            if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                Main3D.cur3D().cockpits[0].onDoorMoved(f);
            setDoorSnd(f);
        }
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        float f3 = Math.max(-f2 * 1500F, -80F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, f3 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, f3 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC2_D0", 0.0F, 80F * f2 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, Math.max(-f * kl * 1500F, -75F), 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, Math.max(-f1 * kr * 1500F, -75F), 0.0F);
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 82.5F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, 82.5F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -85F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, -85F * f1 * kr, 0.0F);
		Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
		hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

/*     protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
    } */

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void moveSteering(float f)
    {
    }

    public void update(float f)
    {
        float f1 = FM.EI.engines[0].getControlRadiator();
        if(Math.abs(flapps - f1) > 0.01F)
        {
            flapps = f1;
            hierMesh().chunkSetAngles("Wind_luk", 0.0F, 12F * f1, 0.0F);
            hierMesh().chunkSetAngles("Water_luk", 0.0F, 12F * f1, 0.0F);
        }
        super.update(f);
		hierMesh().chunkSetAngles("ZfuelL", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 50F, 550F, -25F, 155F), 0.0F);
        hierMesh().chunkSetAngles("ZfuelR", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 50F, 550F, -25F, 155F), 0.0F);
    }

    private static float kl = 1.0F;  //NEW
    private static float kr = 1.0F;  //NEW
    private static float kc = 1.0F;  //NEW
    private float flapps;

}
