package com.maddox.il2.objects.air;

import com.maddox.JGP.*;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.rts.*;

public class CockpitYAK_1series60 extends CockpitPilot
{
    class Interpolater extends InterpolateRef
    {

        public boolean tick()
        {
            if(fm != null)
            {
                setTmp = setOld;
                setOld = setNew;
                setNew = setTmp;
                setNew.throttle = (10F * setOld.throttle + ((FlightModelMain) (fm)).CT.PowerControl) / 11F;
                setNew.prop = (10F * setOld.prop + ((FlightModelMain) (fm)).EI.engines[0].getControlProp()) / 11F;
                setNew.altimeter = fm.getAltitude();
                if(Math.abs(((FlightModelMain) (fm)).Or.getKren()) < 30F)
                    setNew.azimuth = (35F * setOld.azimuth + ((FlightModelMain) (fm)).Or.azimut()) / 36F;
                if(setOld.azimuth > 270F && setNew.azimuth < 90F)
                    setOld.azimuth -= 360F;
                if(setOld.azimuth < 90F && setNew.azimuth > 270F)
                    setOld.azimuth += 360F;
                setNew.vspeed = (199F * setOld.vspeed + fm.getVertSpeed()) / 200F;
                setNew.mix1 = 0.8F * setOld.mix1 + 0.2F * fm.EI.engines[0].getControlMix();
            }
            return true;
        }

        Interpolater()
        {
        }
    }

    private class Variables
    {
        float mix1;
        float throttle;
        float prop;
        float altimeter;
        float azimuth;
        float vspeed;

        private Variables()
        {
        }
    }

    public CockpitYAK_1series60()
    {
        super("3DO/Cockpit/Yak-1(Fairing)/hier_60.him", "bf109");
        setOld = new Variables();
        setNew = new Variables();
        w = new Vector3f();
        pictAiler = 0.0F;
        pictElev = 0.0F;
        light1 = new LightPointActor(new LightPoint(), new Point3d(1.1984999999999999D, 0.34960000000000002D, 0.2414D));
        light2 = new LightPointActor(new LightPoint(), new Point3d(1.3078999999999998D, 0.29460000000000003D, 0.20129999999999998D));
        light3 = new LightPointActor(new LightPoint(), new Point3d(1.4803999999999999D, 0.2114D, 0.14029999999999998D));
        light4 = new LightPointActor(new LightPoint(), new Point3d(1.1984999999999999D, -0.34960000000000002D, 0.2414D));
        light5 = new LightPointActor(new LightPoint(), new Point3d(1.3078999999999998D, -0.29460000000000003D, 0.20129999999999998D));
        light6 = new LightPointActor(new LightPoint(), new Point3d(1.4803999999999999D, -0.2114D, 0.14029999999999998D));
        light1.light.setColor(245F, 221F, 189F);
        light2.light.setColor(245F, 221F, 189F);
        light3.light.setColor(245F, 221F, 189F);
        light4.light.setColor(245F, 221F, 189F);
        light5.light.setColor(245F, 221F, 189F);
        light6.light.setColor(245F, 221F, 189F);
        light1.light.setEmit(0.0F, 0.0F);
        light2.light.setEmit(0.0F, 0.0F);
        light3.light.setEmit(0.0F, 0.0F);
        light4.light.setEmit(0.0F, 0.0F);
        light5.light.setEmit(0.0F, 0.0F);
        light6.light.setEmit(0.0F, 0.0F);
        super.pos.base().draw.lightMap().put("LAMPHOOK1", light1);
        super.pos.base().draw.lightMap().put("LAMPHOOK2", light2);
        super.pos.base().draw.lightMap().put("LAMPHOOK3", light3);
        super.pos.base().draw.lightMap().put("LAMPHOOK4", light4);
        super.pos.base().draw.lightMap().put("LAMPHOOK5", light5);
        super.pos.base().draw.lightMap().put("LAMPHOOK6", light6);
        super.cockpitNightMats = (new String[] {
            "prib_one", "prib_two", "prib_four", "prib_five", "shkala", "prib_one_dd", "prib_two_dd"
        });
        setNightMats(false);
        interpPut(new Interpolater(), null, Time.current(), null);
/*         super.limits6DoF = (new float[] {
            0.7F, 0.055F, -0.07F, 0.11F, 0.15F, -0.11F, 0.04F, -0.025F
        }); */
    }

    public void reflectWorldToInstruments(float f)
    {
        resetYPRmodifier();
        Cockpit.xyz[1] = cvt(((FlightModelMain) (super.fm)).CT.getCockpitDoor(), 0.01F, 0.99F, 0.0F, 0.58F);
        super.mesh.chunkSetLocate("Blister", Cockpit.xyz, Cockpit.ypr);
        super.mesh.chunkSetAngles("richag", 0.0F, (pictAiler = 0.85F * pictAiler + 0.15F * ((FlightModelMain) (super.fm)).CT.AileronControl) * 15F, (pictElev = 0.85F * pictElev + 0.15F * ((FlightModelMain) (super.fm)).CT.ElevatorControl) * 10F);
        super.mesh.chunkSetAngles("Ped_Base", 0.0F, -((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F);
        super.mesh.chunkSetAngles("PedalL", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F);
        super.mesh.chunkSetAngles("PedalR", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F);
        super.mesh.chunkSetAngles("norm_gaz", 0.0F, -13F + interp(setNew.throttle, setOld.throttle, f) * 33.8F, 0.0F);
        super.mesh.chunkSetAngles("shag_vinta", 0.0F, interp(setNew.prop, setOld.prop, f) * 33.8F - 13F, 0.0F);
        super.mesh.chunkSetAngles("r_one", 0.0F, -20F * (((FlightModelMain) (super.fm)).CT.WeaponControl[0] ? 1.0F : 0.0F), 0.0F);
        super.mesh.chunkSetAngles("r_two", 0.0F, -20F * (((FlightModelMain) (super.fm)).CT.WeaponControl[1] ? 1.0F : 0.0F), 0.0F);
        super.mesh.chunkSetAngles("r_turn", 0.0F, 20F * ((FlightModelMain) (super.fm)).CT.BrakeControl, 0.0F);
        super.mesh.chunkSetAngles("nadduv", 0.0F, -19F + 39F * (float)((FlightModelMain) (super.fm)).EI.engines[0].getControlCompressor(), 0.0F);
        if(((FlightModelMain) (super.fm)).CT.GearControl == 0.0F && ((FlightModelMain) (super.fm)).CT.getGear() != 0.0F)
            super.mesh.chunkSetAngles("shassy", 0.0F, 24F, 0.0F);
        else
        if(((FlightModelMain) (super.fm)).CT.GearControl == 1.0F && ((FlightModelMain) (super.fm)).CT.getGear() != 1.0F)
            super.mesh.chunkSetAngles("shassy", 0.0F, -24F, 0.0F);
        else
            super.mesh.chunkSetAngles("shassy", 0.0F, 0.0F, 0.0F);
        if(Math.abs(((FlightModelMain) (super.fm)).CT.FlapsControl - ((FlightModelMain) (super.fm)).CT.getFlap()) > 0.02F)
        {
            if(((FlightModelMain) (super.fm)).CT.FlapsControl - ((FlightModelMain) (super.fm)).CT.getFlap() > 0.0F)
                super.mesh.chunkSetAngles("shitki", 0.0F, -24F, 0.0F);
            else
                super.mesh.chunkSetAngles("shitki", 0.0F, 24F, 0.0F);
        } else
        {
            super.mesh.chunkSetAngles("shitki", 0.0F, 0.0F, 0.0F);
        }
        super.mesh.chunkSetAngles("zAzimuth1a", 0.0F, cvt(((FlightModelMain) (super.fm)).Or.getTangage(), -40F, 40F, -40F, 40F), 0.0F);
        super.mesh.chunkSetAngles("zAzimuth1b", 0.0F, -interp(setNew.azimuth, setOld.azimuth, f), 0.0F);
        super.mesh.chunkSetAngles("zManifold1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].getManifoldPressure(), 0.4F, 2.133F, 0.0F, 334.286F), 0.0F);
        super.mesh.chunkSetAngles("zSpeed1a", 0.0F, floatindex(cvt(Pitot.Indicator((float)((Tuple3d) (((FlightModelMain) (super.fm)).Loc)).z, super.fm.getSpeedKMH()), 0.0F, 800F, 0.0F, 16F), speedometerScale), 0.0F);
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 4) == 0 && (((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x10) == 0)
        {
            w.set(super.fm.getW());
            ((FlightModelMain) (super.fm)).Or.transform(w);
            super.mesh.chunkSetAngles("zTurn1a", 0.0F, cvt(((Tuple3f) (w)).z, -0.23562F, 0.23562F, 30F, -30F), 0.0F);
            super.mesh.chunkSetAngles("zSlide1a", 0.0F, cvt(getBall(8D), -8F, 8F, 24F, -24F), 0.0F);
            super.mesh.chunkSetAngles("zAlt1a", 0.0F, cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 3600F), 0.0F);
            super.mesh.chunkSetAngles("zAlt1b", 0.0F, cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 360F), 0.0F);
        }
        super.mesh.chunkSetAngles("zRPM1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 10000F, 0.0F, 3600F), 0.0F);
        super.mesh.chunkSetAngles("zRPM1b", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 10000F, 0.0F, 360F), 0.0F);
        super.mesh.chunkSetAngles("zClock1a", 0.0F, cvt(World.getTimeofDay() % 1.0F, 0.0F, 1.0F, 0.0F, 360F), 0.0F);
        super.mesh.chunkSetAngles("zClock1b", 0.0F, cvt(World.getTimeofDay(), 0.0F, 24F, 0.0F, 720F), 0.0F);
        super.mesh.chunkSetAngles("zTOilOut1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].tOilOut, 0.0F, 125F, 0.0F, 180F), 0.0F);
        super.mesh.chunkSetAngles("zOilPrs1a", 0.0F, -cvt(((FlightModelMain) (super.fm)).M.fuel > 1.0F ? cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 3050F, 0.0F, 4F) : 0.0F, 0.0F, 8F, 0.0F, -180F), 0.0F);
        super.mesh.chunkSetAngles("zGasPrs1a", 0.0F, cvt(((FlightModelMain) (super.fm)).M.fuel > 1.0F ? cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 3050F, 0.0F, 4F) : 0.0F, 0.0F, 8F, 0.0F, -180F), 0.0F);
		if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x40) == 0)
            super.mesh.chunkSetAngles("zTWater1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].tWaterOut, 0.0F, 125F, 0.0F, 270F), 0.0F);
        super.mesh.chunkVisible("Z_Red1", ((FlightModelMain) (super.fm)).CT.getGearL() == 0.0F);
        super.mesh.chunkVisible("Z_Red2", ((FlightModelMain) (super.fm)).CT.getGearR() == 0.0F);
        super.mesh.chunkVisible("Z_Green1", ((FlightModelMain) (super.fm)).CT.getGearL() == 1.0F);
        super.mesh.chunkVisible("Z_Green2", ((FlightModelMain) (super.fm)).CT.getGearR() == 1.0F);
        super.mesh.chunkSetAngles("Magneto", cvt(fm.EI.engines[0].getControlMagnetos(), 0.0F, 3F, 0.0F, 85F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("vysot_gaz", -30 * interp(setNew.mix1, setOld.mix1, f), 0.0F, 0.0F);
    }

    public void reflectCockpitState()
    {
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x40) != 0)
        {
            super.mesh.chunkVisible("pribors1", false);
            super.mesh.chunkVisible("pribors1_d1", true);
            super.mesh.chunkVisible("zSpeed1a", false);
            super.mesh.chunkVisible("Z_Holes1_1_D1", true);
            super.mesh.chunkVisible("Z_Holes1_2_D1", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 4) != 0 || (((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x10) != 0)
        {
            super.mesh.chunkVisible("pribors2", false);
            super.mesh.chunkVisible("pribors2_d1", true);
            super.mesh.chunkVisible("zAzimuth1a", false);
            super.mesh.chunkVisible("zAzimuth1b", false);
            super.mesh.chunkVisible("zRPM1a", false);
            super.mesh.chunkVisible("zRPM1b", false);
            super.mesh.chunkVisible("zTOilOut1a", false);
            super.mesh.chunkVisible("zOilPrs1a", false);
            super.mesh.chunkVisible("zGasPrs1a", false);
            super.mesh.chunkVisible("zSlide1a", false);
            super.mesh.chunkVisible("panel", false);
            super.mesh.chunkVisible("panel_d1", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 2) != 0 || (((FlightModelMain) (super.fm)).AS.astateCockpitState & 1) != 0)
        {
            super.mesh.chunkVisible("Z_Holes2_1_D1", true);
            super.mesh.chunkVisible("Z_Holes2_2_D1", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x80) != 0)
            super.mesh.chunkVisible("Z_OilSplats_D1", true);
    }

    public void toggleLight()
    {
        super.cockpitLightControl = !super.cockpitLightControl;
        if(super.cockpitLightControl)
        {
            light1.light.setEmit(0.09F, 0.1F);
            light2.light.setEmit(0.02F, 0.2F);
            light3.light.setEmit(0.02F, 0.5F);
            light4.light.setEmit(0.09F, 0.1F);
            light5.light.setEmit(0.02F, 0.2F);
            light6.light.setEmit(0.02F, 0.5F);
            setNightMats(true);
        } else
        {
            light1.light.setEmit(0.0F, 0.0F);
            light2.light.setEmit(0.0F, 0.0F);
            light3.light.setEmit(0.0F, 0.0F);
            light4.light.setEmit(0.0F, 0.0F);
            light5.light.setEmit(0.0F, 0.0F);
            light6.light.setEmit(0.0F, 0.0F);
            setNightMats(false);
        }
    }

    private Variables setOld;
    private Variables setNew;
    private Variables setTmp;
    public Vector3f w;
    private LightPointActor light1;
    private LightPointActor light2;
    private LightPointActor light3;
    private LightPointActor light4;
    private LightPointActor light5;
    private LightPointActor light6;
    private float pictAiler;
    private float pictElev;
    private static final float speedometerScale[] = {
        0.0F, 0.0F, 13F, 45F, 89F, 137F, 186.5F, 205.5F, 220F, 234F, 
        249F, 264F, 279F, 293F, 308.5F, 326F, 340F
    };

    static 
    {
        Property.set(CLASS.THIS(), "normZNs", new float[] {
            1.0F, 0.67F, 0.67F, 0.67F
        });
    }
}