package com.maddox.il2.objects.air;

import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.il2.game.HUD;
import com.maddox.rts.Property;

public class YAK_1Late extends YAK_1x
    implements TypeTNBFighter
{

    public YAK_1Late()
    {
        flapps = 0.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.1F;
    }

    public void update(float f)
    {
        float f1 = FM.EI.engines[0].getControlRadiator();
        if(Math.abs(flapps - f1) > 0.01F)
        {
            flapps = f1;
            hierMesh().chunkSetAngles("Wind_luk", 0.0F, f1 * 32F, 0.0F);
            hierMesh().chunkSetAngles("Water_luk", 0.0F, f1 * 32F, 0.0F);
        }
		afterburnerhud();
        super.update(f);
		hierMesh().chunkSetAngles("ZfuelL", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 0F, 160F, 10F, 117F), 0.0F);
        hierMesh().chunkSetAngles("ZfuelR", 0.0F, Aircraft.cvt(((FlightModelMain) (super.FM)).M.fuel / 0.72F, 0F, 160F, 10F, 117F), 0.0F);
    }

    public void update_windluk(float f)
    {
        super.update(f);
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("\u041D\u0430\u0434\u0434\u0443\u0432 950 \u043C\u043C!");
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private float flapps;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.YAK_1Late.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Yak-1 49 ser");
        Property.set(class1, "meshName", "3DO/Plane/Yak-1(Multi1)/hier_49.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar02());
        Property.set(class1, "meshName_fr", "3DO/Plane/Yak-1(Multi1)/hier_49.him");
        Property.set(class1, "PaintScheme_fr", new PaintSchemeFCSPar05());
        Property.set(class1, "yearService", 1941F);
        Property.set(class1, "yearExpired", 1945.5F);
        Property.set(class1, "FlightModel", "FlightModels/Yak-1series49.fmd:YAK");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitYAK_1series49.class
                    });
        Property.set(class1, "LOSElevation", 0.6609F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 1, 9, 9, 9, 9, 9, 9, 2, 
            2, 2, 2, 2, 2, 3, 3
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_ExternalDev01", "_ExternalDev02", "_ExternalDev03", "_ExternalDev04", "_ExternalDev05", "_ExternalDev06", "_ExternalRock01", 
            "_ExternalRock02", "_ExternalRock03", "_ExternalRock04", "_ExternalRock05", "_ExternalRock06", "_ExternalBomb01", "_ExternalBomb02"
        });
    }
}