package com.maddox.il2.objects.air;

import com.maddox.JGP.Point3d;
import com.maddox.JGP.Tuple3d;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.ActorHMesh;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.rts.Property;

public abstract class YAK_7Vx extends Scheme1
    implements TypeFighter
{

    public YAK_7Vx()
    {
    }

    protected void moveAileron(float f)
    {
        if(f < 0.0F)
        {
            hierMesh().chunkSetAngles("AroneL_D0", 0.0F, -22F * f, 0.0F);
            hierMesh().chunkSetAngles("AroneR_D0", 0.0F, -12F * f, 0.0F);
        } else
        {
            hierMesh().chunkSetAngles("AroneL_D0", 0.0F, -12F * f, 0.0F);
            hierMesh().chunkSetAngles("AroneR_D0", 0.0F, -22F * f, 0.0F);
        }
    }

    protected void moveRudder(float f)
    {
        hierMesh().chunkSetAngles("Rudder1_D0", 0.0F, -26F * f, 0.0F);
    }

    protected void moveElevator(float f)
    {
        if(f < 0.0F)
        {
            hierMesh().chunkSetAngles("VatorL_D0", 0.0F, -22F * f, 0.0F);
            hierMesh().chunkSetAngles("VatorR_D0", 0.0F, -22F * f, 0.0F);
        } else
        {
            hierMesh().chunkSetAngles("VatorL_D0", 0.0F, -26F * f, 0.0F);
            hierMesh().chunkSetAngles("VatorR_D0", 0.0F, -26F * f, 0.0F);
        }
    }

    protected void moveFlap(float f)
    {
        hierMesh().chunkSetAngles("Flap01_D0", 0.0F, -55F * f, 0.0F);
        hierMesh().chunkSetAngles("Flap02_D0", 0.0F, -55F * f, 0.0F);
    }
    protected void hitBone(String s, Shot shot, Point3d point3d)
    {
        if(s.startsWith("xblister1") && World.Rnd().nextFloat() < 0.05F && ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl)
        {
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            if(((FlightModelMain) (super.FM)).CT.cockpitDoorControl == 0.0F)
            {
                if(((FlightModelMain) (super.FM)).AS.bIsEnableToBailout)
                    ((FlightModelMain) (super.FM)).AS.bIsEnableToBailout = false;
                if(super.FM.isPlayers())
                    HUD.log("\u041A\u0440\u044B\u0448\u043A\u0443 \u0444\u043E\u043D\u0430\u0440\u044F \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E, \u0432\u044B\u043F\u0440\u044B\u0433\u043D\u0443\u0442\u044C \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u043D\u043E");
/*                     HUD.log("canopy jammed... bail out not available"); */
			}
        }
        if(s.startsWith("xx"))
        {
            if(s.startsWith("xxarmor"))
            {
                debuggunnery("Armor: Hit..");
                if(s.endsWith("p1"))
                    getEnergyPastArmor((double)World.Rnd().nextFloat(5F, 12.7F) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot);
                else
                if(s.endsWith("p2"))
                    getEnergyPastArmor((double)World.Rnd().nextFloat(0.0F, 12.7F) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot);
                else
                if(s.endsWith("g1"))
                {
                    getEnergyPastArmor((double)World.Rnd().nextFloat(20F, 30F) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot);
                    if(World.Rnd().nextFloat() < 0.2F)
                        FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 2);
                    if(shot.power <= 0.0F)
                        doRicochetBack(shot);
                } else
                if(s.endsWith("g2"))
                {
                    getEnergyPastArmor((double)World.Rnd().nextFloat(20F, 30F) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot);
                    if(shot.power <= 0.0F)
                        doRicochetBack(shot);
                }
                return;
            }
            if(s.startsWith("xxcontrols"))
            {
                debuggunnery("Controls: Hit..");
                int i = s.charAt(10) - 48;
                switch(i)
                {
                default:
                    break;

                case 1: // '\001'
                    if(getEnergyPastArmor(0.1F, shot) > 0.0F)
                    {
                        if(World.Rnd().nextFloat() < 0.1F)
                            FM.AS.setEngineSpecificDamage(shot.initiator, 0, 1);
                        if(World.Rnd().nextFloat() < 0.1F)
                            FM.AS.setEngineSpecificDamage(shot.initiator, 0, 6);
                        if(World.Rnd().nextFloat() < 0.1F)
                            FM.AS.setEngineSpecificDamage(shot.initiator, 0, 7);
                    }
                    break;

                case 2: // '\002'
                    if(getEnergyPastArmor(3.75F, shot) > 0.0F && World.Rnd().nextFloat() < 0.4F)
                    {
                        Aircraft.debugprintln(this, "*** Control Column: Hit, Controls Destroyed..");
                        FM.AS.setControlsDamage(shot.initiator, 1);
                        FM.AS.setControlsDamage(shot.initiator, 0);
                    }
                    break;

                case 3: // '\003'
                case 4: // '\004'
                    if(getEnergyPastArmor(1.75F, shot) > 0.0F && World.Rnd().nextFloat() < 0.4F)
                    {
                        debuggunnery("Controls: Ailerones Controls: Out..");
                        FM.AS.setControlsDamage(shot.initiator, 0);
                    }
                    break;

                case 5: // '\005'
                    if(getEnergyPastArmor(0.5F, shot) > 0.0F && World.Rnd().nextFloat() < 0.125F)
                    {
                        debuggunnery("Controls: Rudder Controls: Disabled / Strings Broken..");
                        FM.AS.setControlsDamage(shot.initiator, 2);
                    }
                    break;

                case 6: // '\006'
                    if(getEnergyPastArmor(3.2F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        debuggunnery("Controls: Rudder Controls: Disabled / Strings Broken..");
                        FM.AS.setControlsDamage(shot.initiator, 2);
                    }
                    break;

                case 7: // '\007'
                    if(getEnergyPastArmor(1.75F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        debuggunnery("Controls: Elevator Controls: Disabled..");
                        FM.AS.setControlsDamage(shot.initiator, 1);
                    }
                    break;

                case 8: // '\b'
                    if(getEnergyPastArmor(2.25F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        FM.AS.setEngineSpecificDamage(shot.initiator, 0, 1);
                        FM.AS.setEngineSpecificDamage(shot.initiator, 0, 6);
                        Aircraft.debugprintln(this, "*** Throttle Quadrant: Hit, Engine Controls Disabled..");
                    }
                    break;
                }
                return;
            }
            if(s.startsWith("xxeng1"))
            {
                if(s.endsWith("prop") && getEnergyPastArmor(2.0F, shot) > 0.0F && World.Rnd().nextFloat() < 0.8F)
                {
                    FM.EI.engines[0].setKillPropAngleDevice(shot.initiator);
                    Aircraft.debugprintln(this, "*** Engine Prop Governor Failed..");
					if(super.FM.isPlayers())
					HUD.log("\u041F\u0440\u043E\u043F\u0435\u043B\u043B\u0435\u0440 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D, \u043E\u0442\u043A\u0430\u0437 \u043F\u0440\u043E\u043F\u0435\u043B\u043B\u0435\u0440\u0430");
                }
                if(s.endsWith("gear") && getEnergyPastArmor(4.6F, shot) > 0.0F && World.Rnd().nextFloat() < 0.4F)
                {
                    FM.EI.engines[0].setKillPropAngleDeviceSpeeds(shot.initiator);
                    Aircraft.debugprintln(this, "*** Engine Prop Governor Damaged..");
					if(super.FM.isPlayers())
					HUD.log("\u041F\u0440\u043E\u043F\u0435\u043B\u043B\u0435\u0440 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D");
                }
                if(s.endsWith("supc"))
                {
                    if(getEnergyPastArmor(2.0F, shot) > 0.0F && World.Rnd().nextFloat() < 0.7F)
                    {
                        Aircraft.debugprintln(this, "*** Engine Module: Supercharger Disabled..");
                        FM.AS.setEngineSpecificDamage(shot.initiator, 0, 0);
						if(super.FM.isPlayers())
						HUD.log("\u041D\u0430\u0434\u0434\u0443\u0432 \u043D\u0435\u0438\u0441\u043F\u0440\u0430\u0432\u0435\u043D");
                    }
                } else
                if(s.endsWith("feed"))
                {
                    if(getEnergyPastArmor(2.2F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F && ((FlightModelMain) (super.FM)).EI.engines[0].getPowerOutput() > 0.5F)
                    {
                        ((FlightModelMain) (super.FM)).AS.hitEngine(shot.initiator, 0, 100);
                        Aircraft.debugprintln(this, "*** Engine Module: Pressurized Fuel Line Pierced, Fuel Flamed..");
						if(super.FM.isPlayers())
						HUD.log("\u0422\u043E\u043F\u043B\u0438\u0432\u043E\u043F\u0440\u043E\u0432\u043E\u0434 \u043F\u0440\u043E\u0431\u0438\u0442, \u0442\u043E\u043F\u043B\u0438\u0432\u043E \u0432\u043E\u0441\u043F\u043B\u0430\u043C\u0435\u043D\u0438\u043B\u043E\u0441\u044C");
                    }
                } else
                if(s.endsWith("fuel"))
                {
                    if(getEnergyPastArmor(2.2F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                    {
                        ((FlightModelMain) (super.FM)).EI.engines[0].setEngineStops(shot.initiator);
                        Aircraft.debugprintln(this, "*** Engine Module: Fuel Line Stalled, Engine Stalled..");
						if(super.FM.isPlayers())
						HUD.log("\u0422\u043E\u043F\u043B\u0438\u0432\u043E\u043F\u0440\u043E\u0432\u043E\u0434 \u043F\u0440\u043E\u0431\u0438\u0442, \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044C \u0437\u0430\u0433\u043B\u043E\u0445");
                    }
                } else
                if(s.endsWith("mag1"))
                {
                    if(getEnergyPastArmor(2.1F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                    {
						FM.EI.engines[0].setMagnetoKnockOut(shot.initiator, 0);
						Aircraft.debugprintln(this, "*** Engine Module: Magneto #0 Destroyed..");
						if(super.FM.isPlayers())
						HUD.log("\u041C\u0430\u0433\u043D\u0435\u0442\u043E 1 \u043D\u0435\u0438\u0441\u043F\u0440\u0430\u0432\u043D\u043E");
                    }
                }
                if(s.endsWith("mag2"))
                {
                    if(getEnergyPastArmor(2.1F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                    {
						FM.EI.engines[0].setMagnetoKnockOut(shot.initiator, 1);
						Aircraft.debugprintln(this, "*** Engine Module: Magneto #1 Destroyed..");
						if(super.FM.isPlayers())
						HUD.log("\u041C\u0430\u0433\u043D\u0435\u0442\u043E 2 \u043D\u0435\u0438\u0441\u043F\u0440\u0430\u0432\u043D\u043E");
                    }
                }
                if(s.endsWith("case"))
                {
                    if(getEnergyPastArmor(World.Rnd().nextFloat(0.0F, 6.8F), shot) > 0.0F)
                    {
                        if(World.Rnd().nextFloat() < shot.power / 175000F)
                        {
                            FM.AS.setEngineStuck(shot.initiator, 0);
                            Aircraft.debugprintln(this, "*** Engine Crank Case Hit - Engine Stucks..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044C \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u0432\u0430\u0435\u0442");
                        }
                        if(World.Rnd().nextFloat() < shot.power / 50000F)
                        {
                            FM.AS.hitEngine(shot.initiator, 0, 2);
                            Aircraft.debugprintln(this, "*** Engine Crank Case Hit - Engine Damaged..");
							if(super.FM.isPlayers())
							HUD.log("\u041A\u0430\u0440\u0442\u0435\u0440: \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D");
                        }
                        if(World.Rnd().nextFloat() < shot.power / 48000F)
                        {
                            FM.EI.engines[0].setCyliderKnockOut(shot.initiator, 1);
                            Aircraft.debugprintln(this, "*** Engine Crank Case Hit - Cylinder Feed Out, " + FM.EI.engines[0].getCylindersOperable() + "/" + FM.EI.engines[0].getCylinders() + " Left..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u043D\u0430\u0440\u0443\u0448\u0435\u043D\u0438\u0435 \u0440\u0430\u0431\u043E\u0442\u044B \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432");
						}
                        if(World.Rnd().nextFloat() < 0.08F)
                        {
                            FM.EI.engines[0].setEngineStuck(shot.initiator);
                            Aircraft.debugprintln(this, "*** Engine Crank Case Hit - Ball Bearing Jammed - Engine Stuck..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u043E\u043F\u043E\u0440\u043D\u044B\u0439 \u043F\u043E\u0434\u0448\u0438\u043F\u043D\u0438\u043A \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E");
                        }
                        FM.EI.engines[0].setReadyness(shot.initiator, FM.EI.engines[0].getReadyness() - World.Rnd().nextFloat(0.0F, shot.power / 48000F));
                        Aircraft.debugprintln(this, "*** Engine Crank Case Hit - Readyness Reduced to " + FM.EI.engines[0].getReadyness() + "..");
						if(super.FM.isPlayers())
						HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u0440\u0430\u0431\u043E\u0442\u043E\u0441\u043F\u043E\u0441\u043E\u0431\u043D\u043E\u0441\u0442\u044C \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F \u0441\u043D\u0438\u0436\u0435\u043D\u0430");
                    }
                    if(World.Rnd().nextFloat() < 0.01F)
                    {
                        FM.EI.engines[0].setEngineStops(shot.initiator);
                        Aircraft.debugprintln(this, "*** Engine Crank Case Hit - Engine Stalled..");
						if(super.FM.isPlayers())
						HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044C \u0437\u0430\u0433\u043B\u043E\u0445");
                    }
/*                     if(World.Rnd().nextFloat() < 0.01F)
                    {
                        FM.AS.hitEngine(shot.initiator, 0, 10);
                        Aircraft.debugprintln(this, "*** Engine Crank Case Hit - Fuel Feed Hit - Engine Flamed..");
						if(super.FM.isPlayers())
						HUD.log("\u0411\u0435\u043D\u0437\u043E\u043F\u0440\u043E\u0432\u043E\u0434 \u043F\u0440\u043E\u0431\u0438\u0442, \u043F\u043E\u0436\u0430\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F");
                    } */
                    getEnergyPastArmor(6F, shot);
                }
                if((s.endsWith("cyl1") || s.endsWith("cyl2")) && getEnergyPastArmor(World.Rnd().nextFloat(0.5F, 2.542F), shot) > 0.0F && World.Rnd().nextFloat() < FM.EI.engines[0].getCylindersRatio() * 1.72F)
                {
                    FM.EI.engines[0].setCyliderKnockOut(shot.initiator, World.Rnd().nextInt(1, (int)(shot.power / 4800F)));
                    Aircraft.debugprintln(this, "*** Engine Cylinders Hit, " + FM.EI.engines[0].getCylindersOperable() + "/" + FM.EI.engines[0].getCylinders() + " Left..");
					if(super.FM.isPlayers())
					HUD.log("\u0411\u043B\u043E\u043A \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D, " + FM.EI.engines[0].getCylindersOperable() + " \u0438\u0437 " + FM.EI.engines[0].getCylinders() + " \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432 \u043E\u0441\u0442\u0430\u043B\u043E\u0441\u044C");
                    if(World.Rnd().nextFloat() < 0.01F)
                    {
                        FM.EI.engines[0].setEngineStuck(shot.initiator);
                        Aircraft.debugprintln(this, "*** Engine Cylinder Case Broken - Engine Stuck..");
						if(super.FM.isPlayers())
						HUD.log("\u0411\u043B\u043E\u043A \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432 \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043D, \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044C \u0437\u0430\u0433\u043B\u043E\u0445");
                    }
                    if(World.Rnd().nextFloat() < shot.power / 24000F)
                    {
                        FM.AS.hitEngine(shot.initiator, 0, 3);
                        Aircraft.debugprintln(this, "*** Engine Cylinders Hit - Engine Fires..");
						if(super.FM.isPlayers())
						HUD.log("\u0411\u043B\u043E\u043A \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D, \u043F\u043E\u0436\u0430\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F");
                    }
                    getEnergyPastArmor(World.Rnd().nextFloat(3F, 46.7F), shot);
                }
                return;
            }
            if(s.startsWith("xxlock"))
            {
                debuggunnery("Lock Construction: Hit..");
                if(s.startsWith("xxlockr") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    debuggunnery("Lock Construction: Rudder1 Lock Shot Off..");
                    nextDMGLevels(3, 2, "Rudder1_D" + chunkDamageVisible("Rudder1"), shot.initiator);
                }
                if(s.startsWith("xxlockvl") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    debuggunnery("Lock Construction: VatorL Lock Shot Off..");
                    nextDMGLevels(3, 2, "VatorL_D" + chunkDamageVisible("VatorL"), shot.initiator);
                }
                if(s.startsWith("xxlockvr") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    debuggunnery("Lock Construction: VatorR Lock Shot Off..");
                    nextDMGLevels(3, 2, "VatorR_D" + chunkDamageVisible("VatorR"), shot.initiator);
                }
                if(s.startsWith("xxlockal") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    debuggunnery("Lock Construction: AroneL Lock Shot Off..");
                    nextDMGLevels(3, 2, "AroneL_D" + chunkDamageVisible("AroneL"), shot.initiator);
                }
                if(s.startsWith("xxlockar") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    debuggunnery("Lock Construction: AroneR Lock Shot Off..");
                    nextDMGLevels(3, 2, "AroneR_D" + chunkDamageVisible("AroneR"), shot.initiator);
                }
                return;
            }
            if(s.startsWith("xxmgun0"))
            {
                int j = s.charAt(7) - 49;
                if(getEnergyPastArmor(0.5F, shot) > 0.0F)
                {
                    debuggunnery("Armament: Machine Gun (" + j + ") Disabled..");
                    FM.AS.setJamBullets(0, j);
                    getEnergyPastArmor(World.Rnd().nextFloat(0.5F, 23.325F), shot);
                }
                return;
            }
            if(s.startsWith("xxcannon"))
            {
                if(getEnergyPastArmor(0.5F, shot) > 0.0F)
                {
                    debuggunnery("Armament: Cannon (0) Disabled..");
                    FM.AS.setJamBullets(1, 0);
                    getEnergyPastArmor(World.Rnd().nextFloat(0.5F, 23.325F), shot);
                }
                return;
            }
            if(s.startsWith("xxoiltank"))
            {
                if(getEnergyPastArmor(0.25F, shot) > 0.0F && World.Rnd().nextFloat() < 0.125F)
                {
                    ((FlightModelMain) (super.FM)).AS.hitOil(shot.initiator, 0);
                    getEnergyPastArmor(0.25F, shot);
                    debuggunnery("Engine Module: Oil Tank Pierced..");
					if(super.FM.isPlayers())
					HUD.log("\u041C\u0430\u0441\u043B\u043E\u0431\u0430\u043A \u043F\u0440\u043E\u0431\u0438\u0442");
                }
                return;
            }
            if(s.startsWith("xxoil"))
            {
                if(getEnergyPastArmor(0.25F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                {
                    FM.AS.hitOil(shot.initiator, 0);
                    getEnergyPastArmor(0.25F, shot);
                    debuggunnery("Engine Module: Oil Radiator Pierced..");
					if(super.FM.isPlayers())
					HUD.log("\u041C\u0430\u0441\u043B\u043E\u0440\u0430\u0434\u0438\u0430\u0442\u043E\u0440 \u043F\u0440\u043E\u0431\u0438\u0442");
                }
                return;
            }
            if(s.startsWith("xxtank"))
            {
                int k = s.charAt(6) - 49;
                if(getEnergyPastArmor(1.45F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                {
                    if(FM.AS.astateTankStates[k] == 0)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Pierced..");
                        FM.AS.hitTank(shot.initiator, k, 1);
                        FM.AS.doSetTankState(shot.initiator, k, 1);
                    }else
                    if(FM.AS.astateTankStates[k] == 1)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Pierced..");
                        FM.AS.hitTank(shot.initiator, k, 2);
                        FM.AS.doSetTankState(shot.initiator, k, 2);  
                    }
                    if(World.Rnd().nextFloat() < 0.01F || shot.powerType == 3 && World.Rnd().nextFloat() < 0.8F)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Hit..");
                        FM.AS.doSetTankState(shot.initiator, k, 5);
                    }
                }
                return;
            }
            if(s.startsWith("xxpnm") && getEnergyPastArmor(4.8F, shot) > 0.0F)//пробитие баллона пневмосистемы
            {
                FM.AS.setInternalDamage(shot.initiator, 1);//выпуск щитков невозможен
				((FlightModelMain) (super.FM)).CT.bHasBrakeControl = false;//отказ тормозов
				if(super.FM.isPlayers())
				HUD.log("\u041F\u043D\u0435\u0432\u043C\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u0430 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0435\u043D\u0430");
				return;
            }
            if(s.startsWith("xxspar"))
            {
                Aircraft.debugprintln(this, "*** Spar Construction: Hit..");
                if(s.startsWith("xxsparlm") && chunkDamageVisible("WingLMid") > 2 && World.Rnd().nextFloat(0.0F, 0.115F) < shot.mass && getEnergyPastArmor(6.8F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLMid Spar Damaged..");
                    nextDMGLevels(1, 2, "WingLMid_D" + chunkDamageVisible("WingLMid"), shot.initiator);
                }
                if(s.startsWith("xxsparrm") && chunkDamageVisible("WingRMid") > 2 && World.Rnd().nextFloat(0.0F, 0.115F) < shot.mass && getEnergyPastArmor(6.8F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingRMid Spar Damaged..");
                    nextDMGLevels(1, 2, "WingRMid_D" + chunkDamageVisible("WingRMid"), shot.initiator);
                }
                if(s.startsWith("xxsparlo") && chunkDamageVisible("WingLOut") > 2 && World.Rnd().nextFloat(0.0F, 0.115F) < shot.mass && getEnergyPastArmor(6.8F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLOut Spar Damaged..");
                    nextDMGLevels(1, 2, "WingLOut_D" + chunkDamageVisible("WingLOut"), shot.initiator);
                }
                if(s.startsWith("xxsparro") && chunkDamageVisible("WingROut") > 2 && World.Rnd().nextFloat(0.0F, 0.115F) < shot.mass && getEnergyPastArmor(6.8F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingROut Spar Damaged..");
                    nextDMGLevels(1, 2, "WingROut_D" + chunkDamageVisible("WingROut"), shot.initiator);
                }
                if(s.startsWith("xxspark") && World.Rnd().nextFloat() < 0.5F && getEnergyPastArmor((double)(6.8F * World.Rnd().nextFloat(1.0F, 1.5F)) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Keel Spars Damaged..");
                    nextDMGLevels(1, 2, "Keel1_D" + chunkDamageVisible("Keel1"), shot.initiator);
                }
                if(s.startsWith("xxspart") && chunkDamageVisible("Tail1") > 2 && getEnergyPastArmor(3.86F / (float)Math.sqrt(Aircraft.v1.y * Aircraft.v1.y + Aircraft.v1.z * Aircraft.v1.z), shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                {
                    debuggunnery("Spar Construction: Tail1 Ribs Hit, Breaking in Half..");
                    nextDMGLevels(1, 2, "Tail1_D3", shot.initiator);
                }
                if(s.startsWith("xxsparsl") && World.Rnd().nextFloat() < 0.5F && getEnergyPastArmor((double)(6.8F * World.Rnd().nextFloat(1.0F, 1.5F)) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** StabL Spars Damaged..");
                    nextDMGLevels(1, 2, "StabL_D" + chunkDamageVisible("StabL"), shot.initiator);
                }
                if(s.startsWith("xxsparsr") && World.Rnd().nextFloat() < 0.5F && getEnergyPastArmor((double)(6.8F * World.Rnd().nextFloat(1.0F, 1.5F)) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** StabR Spars Damaged..");
                    nextDMGLevels(1, 2, "StabR_D" + chunkDamageVisible("StabR"), shot.initiator);
                }
                return;
            }
			if(s.startsWith("xxwater1"))
			{
				if(getEnergyPastArmor(0.1F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
				{
					debuggunnery("Engine Module: Water Radiator Pierced..");
					if(super.FM.isPlayers())
					HUD.log("\u0412\u043E\u0434\u043E\u0440\u0430\u0434\u0438\u0430\u0442\u043E\u0440 \u043F\u0440\u043E\u0431\u0438\u0442");
					FM.AS.hitEngine(shot.initiator, 0, 1);
					FM.AS.doSetEngineState(shot.initiator, 0, 2);
				}
				getEnergyPastArmor(0.22F, shot);
                return;
			}
            if(s.startsWith("xxwater2") && getEnergyPastArmor(0.1F, shot) > 0.0F)
            {
                Aircraft.debugprintln(this, "*** Engine Module: Water Tank Pierced..");
				if(super.FM.isPlayers())
				HUD.log("\u0420\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u0435\u043B\u044C\u043D\u044B\u0439 \u0431\u0430\u0447\u043E\u043A \u043F\u0440\u043E\u0431\u0438\u0442");
				FM.AS.hitEngine(shot.initiator, 0, 1);
				FM.AS.doSetEngineState(shot.initiator, 0, 2);
                getEnergyPastArmor(4.96F, shot);
                return;
            }
        }
        if(s.startsWith("xcf") || s.startsWith("xcockpit"))
        {
            if(chunkDamageVisible("CF") < 3)
				hitChunk("CF", shot);
            if(s.startsWith("xcockpit"))
            {
                if(point3d.z > 0.7160000205039978D && World.Rnd().nextFloat() < 0.25F && World.Rnd().nextFloat() < 0.2F)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 1);
                if(point3d.z > 0.7160000205039978D && World.Rnd().nextFloat() < 0.25F && World.Rnd().nextFloat() < 0.2F)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 8);
                if(point3d.x > -0.5D && World.Rnd().nextFloat() < 0.2F)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 0x40);
                if(point3d.x > -0.5D && World.Rnd().nextFloat() < 0.2F)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 0x20);
            }
            return;
        } else
        if(s.startsWith("xeng"))
        {
            if(chunkDamageVisible("Engine1") < 2)
                hitChunk("Engine1", shot);
        } else
        if(s.startsWith("xtail"))
        {
            if(chunkDamageVisible("Tail1") < 3)
                hitChunk("Tail1", shot);
        } else
        if(s.startsWith("xkeel"))
        {
            if(chunkDamageVisible("Keel1") < 2)
                hitChunk("Keel1", shot);
        } else
        if(s.startsWith("xrudder"))
        {
            if(chunkDamageVisible("Rudder1") < 1)
                hitChunk("Rudder1", shot);
        } else
        if(s.startsWith("xstab"))
        {
            if(s.startsWith("xstabl"))
                hitChunk("StabL", shot);
            if(s.startsWith("xstabr"))
                hitChunk("StabR", shot);
        } else
        if(s.startsWith("xvator"))
        {
            if(s.startsWith("xvatorl") && chunkDamageVisible("VatorL") < 1)
                hitChunk("VatorL", shot);
            if(s.startsWith("xvatorr") && chunkDamageVisible("VatorR") < 1)
                hitChunk("VatorR", shot);
        } else
        if(s.startsWith("xwing"))
        {
            if(s.startsWith("xwinglin") && chunkDamageVisible("WingLIn") < 3)
                hitChunk("WingLIn", shot);
            if(s.startsWith("xwingrin") && chunkDamageVisible("WingRIn") < 3)
                hitChunk("WingRIn", shot);
            if(s.startsWith("xwinglmid") && chunkDamageVisible("WingLMid") < 3)
                hitChunk("WingLMid", shot);
            if(s.startsWith("xwingrmid") && chunkDamageVisible("WingRMid") < 3)
                hitChunk("WingRMid", shot);
            if(s.startsWith("xwinglout") && chunkDamageVisible("WingLOut") < 3)
                hitChunk("WingLOut", shot);
            if(s.startsWith("xwingrout") && chunkDamageVisible("WingROut") < 3)
                hitChunk("WingROut", shot);
        } else
        if(s.startsWith("xarone"))
        {
            if(s.startsWith("xaronel") && chunkDamageVisible("AroneL") < 1)
                hitChunk("AroneL", shot);
            if(s.startsWith("xaroner") && chunkDamageVisible("AroneR") < 1)
                hitChunk("AroneR", shot);
        } else
        if(s.startsWith("xgear"))
        {
            if(s.endsWith("1") && World.Rnd().nextFloat() < 0.05F)
            {
                debuggunnery("Hydro System: Disabled..");
				if(super.FM.isPlayers())
				HUD.log("\u0413\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u0430 \u043D\u0435\u0438\u0441\u043F\u0440\u0430\u0432\u043D\u0430");
                FM.AS.setInternalDamage(shot.initiator, 0);
            }
            if(s.endsWith("2") && World.Rnd().nextFloat() < 0.1F && getEnergyPastArmor(World.Rnd().nextFloat(1.2F, 3.435F), shot) > 0.0F)
            {
                debuggunnery("Undercarriage: Stuck..");
				if(super.FM.isPlayers())
				HUD.log("\u0428\u0430\u0441\u0441\u0438 \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E");
                FM.AS.setInternalDamage(shot.initiator, 3);
            }
        } else
        if(s.startsWith("xpilot") || s.startsWith("xhead"))
        {
            byte byte0 = 0;
            int l;
            if(s.endsWith("a"))
            {
                byte0 = 1;
                l = s.charAt(6) - 49;
            } else
            if(s.endsWith("b"))
            {
                byte0 = 2;
                l = s.charAt(6) - 49;
            } else
            {
                l = s.charAt(5) - 49;
            }
            hitFlesh(l, shot, byte0);
        }
    }

    public void rareAction(float paramFloat, boolean paramBoolean)
    {
        super.rareAction(paramFloat, paramBoolean);
        if(paramBoolean)
        {
			//Код затухания, вероятность затухания белого дыма 0.01%, после затухания остаётся течь
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 2 && World.Rnd().nextFloat() < 0.001F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 2 && World.Rnd().nextFloat() < 0.001F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 2 && World.Rnd().nextFloat() < 0.001F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 2 && World.Rnd().nextFloat() < 0.001F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания чёрного дыма 3%, после затухания остаётся белый дым
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 3 && World.Rnd().nextFloat() < 0.03F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 3 && World.Rnd().nextFloat() < 0.03F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 3 && World.Rnd().nextFloat() < 0.03F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 3 && World.Rnd().nextFloat() < 0.03F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания огня без дыма 2%, после затухания остаётся чёрный дым (чёрный дым может снова загореться, вероятность зашита где-то в базовых классах)
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 4 && World.Rnd().nextFloat() < 0.02F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 4 && World.Rnd().nextFloat() < 0.02F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 4 && World.Rnd().nextFloat() < 0.02F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 4 && World.Rnd().nextFloat() < 0.02F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания огня с дымом 0.5%, после затухания остаётся огонь без дыма (огонь без дыма может снова стать с дымом, вероятность зашита где-то в базовых классах)
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 5 && World.Rnd().nextFloat() < 0.005F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 5 && World.Rnd().nextFloat() < 0.005F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 5 && World.Rnd().nextFloat() < 0.005F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 5 && World.Rnd().nextFloat() < 0.005F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
			//Код перекидывания огня на соседний бак, вероятность 14%
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 1, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 0, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 3, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 2, 1);
        }
        if(super.FM.getAltitude() < 3000F)
            hierMesh().chunkVisible("HMask1_D0", false);
        else
            hierMesh().chunkVisible("HMask1_D0", hierMesh().isChunkVisible("Head1_D0"));
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    static 
    {
        Class class1 = com.maddox.il2.objects.air.YAK_7Vx.class;
        Property.set(class1, "originCountry", PaintScheme.countryRussia);
    }
}