//Без протектора и нейтрального газа
package com.maddox.il2.objects.air;

import com.maddox.JGP.Point3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.rts.Property;

public abstract class MIG_1xyz extends Scheme1
    implements TypeFighter
{

    public MIG_1xyz()
    {
        kl = 1.0F;
        kr = 1.0F;
        kc = 1.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.05F;
    }

    protected void moveFlap(float f)
    {
        hierMesh().chunkSetAngles("Flap01_D0", 0.0F, -50F * f, 0.0F);
        hierMesh().chunkSetAngles("Flap02_D0", 0.0F, -50F * f, 0.0F);
        hierMesh().chunkSetAngles("Flap03_D0", 0.0F, -50F * f, 0.0F);
        hierMesh().chunkSetAngles("Flap04_D0", 0.0F, -50F * f, 0.0F);
    }

    protected void moveAileron(float f)
    {
        if(f < 0.0F)
        {
            hierMesh().chunkSetAngles("AroneL_D0", 0.0F, -23F * f, 0.0F);
            hierMesh().chunkSetAngles("AroneR_D0", 0.0F, -18F * f, 0.0F);
        } else
        {
            hierMesh().chunkSetAngles("AroneL_D0", 0.0F, -18F * f, 0.0F);
            hierMesh().chunkSetAngles("AroneR_D0", 0.0F, -23F * f, 0.0F);
        }
    }

    protected void moveRudder(float f)
    {
        hierMesh().chunkSetAngles("Rudder1_D0", 0.0F, -25F * f, 0.0F);
    }

    protected void moveElevator(float f)
    {
        if(f < 0.0F)
        {
            hierMesh().chunkSetAngles("VatorL_D0", 0.0F, -30F * f, 0.0F);
            hierMesh().chunkSetAngles("VatorR_D0", 0.0F, -30F * f, 0.0F);
        } else
        {
            hierMesh().chunkSetAngles("VatorL_D0", 0.0F, -25F * f, 0.0F);
            hierMesh().chunkSetAngles("VatorR_D0", 0.0F, -25F * f, 0.0F);
        }
    }

    public void doMurderPilot(int i)
    {
        switch(i)
        {
        case 0: // '\0'
            hierMesh().chunkVisible("Pilot1_D0", false);
            hierMesh().chunkVisible("Head1_D0", false);
            hierMesh().chunkVisible("Pilot1_D1", true);
            if(!FM.AS.bIsAboutToBailout && World.cur().isHighGore())
            {
                if(hierMesh().isChunkVisible("Blister1_D0"))
                    hierMesh().chunkVisible("Gore1_D0", true);
                hierMesh().chunkVisible("Gore2_D0", true);
            }
            break;
        }
    }

    protected void hitBone(String s, Shot shot, Point3d point3d)
    {
        if(s.startsWith("xblister1") && World.Rnd().nextFloat() < 0.05F && ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl)
        {
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            if(((FlightModelMain) (super.FM)).CT.cockpitDoorControl == 0.0F)
            {
                if(((FlightModelMain) (super.FM)).AS.bIsEnableToBailout)
                    ((FlightModelMain) (super.FM)).AS.bIsEnableToBailout = false;
                if(super.FM.isPlayers())
                    HUD.log("\u041A\u0440\u044B\u0448\u043A\u0443 \u0444\u043E\u043D\u0430\u0440\u044F \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E, \u0432\u044B\u043F\u0440\u044B\u0433\u043D\u0443\u0442\u044C \u043D\u0435\u0432\u043E\u0437\u043C\u043E\u0436\u043D\u043E");
/*                     HUD.log("canopy jammed... bail out not available"); */
			}
        }
        if(s.startsWith("xx"))
        {
            if(s.startsWith("xxarmor"))
            {
                Aircraft.debugprintln(this, "*** Armor: Hit..");
                if(s.endsWith("p1"))
                    getEnergyPastArmor(9.1000003814697266D / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot);
                else
                if(s.endsWith("p2"))
                    getEnergyPastArmor(9.1000003814697266D / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot);
                else
                if(s.endsWith("p3"))
                    getEnergyPastArmor(5.6F, shot);
                else
                if(s.endsWith("t3"))
                    getEnergyPastArmor(6.1999998092651367D / (Math.abs(Aircraft.v1.z) + 9.9999997473787516E-006D), shot);
                else
                if(s.endsWith("t4"))
                    getEnergyPastArmor(6.1999998092651367D / (Math.abs(Aircraft.v1.z) + 9.9999997473787516E-006D), shot);
                return;
            }
            if(s.startsWith("xxcontrols"))
            {
                int i = s.charAt(10) - 48;
                switch(i)
                {
                default:
                    break;

                case 1: // '\001'
                    if(getEnergyPastArmor(2.2F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Control Column: Hit, Controls Destroyed..");
                        FM.AS.setControlsDamage(shot.initiator, 1);
                        FM.AS.setControlsDamage(shot.initiator, 0);
                    }
                    break;

                case 2: // '\002'
                    if(getEnergyPastArmor(2.2F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Rudder Controls: Disabled / Strings Broken..");
                        FM.AS.setControlsDamage(shot.initiator, 2);
                    }
                    break;

                case 3: // '\003'
                    if(getEnergyPastArmor(0.3F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Rudder Controls: Disabled / Strings Broken..");
                        FM.AS.setControlsDamage(shot.initiator, 2);
                    }
                    break;

                case 4: // '\004'
                    if(getEnergyPastArmor(9.6F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Elevator Controls: Disabled..");
                        FM.AS.setControlsDamage(shot.initiator, 1);
                    }
                    break;

                case 5: // '\005'
                case 7: // '\007'
                    if(getEnergyPastArmor(2.1F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                    {
                        Aircraft.debugprintln(this, "*** Aileron Controls: Disabled..");
                        FM.AS.setControlsDamage(shot.initiator, 0);
                    }
                    break;

                case 6: // '\006'
                case 8: // '\b'
                    if(getEnergyPastArmor(1.45F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Aileron Controls: Control Crank Link Destroyed..");
                        FM.AS.setControlsDamage(shot.initiator, 0);
                    }
                    break;
                }
            }
            if(s.startsWith("xxspar"))
            {
                Aircraft.debugprintln(this, "*** Spar Construction: Hit..");
                if(s.startsWith("xxsparlm") && World.Rnd().nextFloat(0.0F, 0.115F) < shot.mass && getEnergyPastArmor(6.8F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLMid Spar Damaged..");
                    nextDMGLevels(1, 2, "WingLMid_D" + chunkDamageVisible("WingLMid"), shot.initiator);
                }
                if(s.startsWith("xxsparrm") && World.Rnd().nextFloat(0.0F, 0.115F) < shot.mass && getEnergyPastArmor(6.8F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingRMid Spar Damaged..");
                    nextDMGLevels(1, 2, "WingRMid_D" + chunkDamageVisible("WingRMid"), shot.initiator);
                }
                if(s.startsWith("xxsparlo") && World.Rnd().nextFloat(0.0F, 0.115F) < shot.mass && getEnergyPastArmor(6.8F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingLOut Spar Damaged..");
                    nextDMGLevels(1, 2, "WingLOut_D" + chunkDamageVisible("WingLOut"), shot.initiator);
                }
                if(s.startsWith("xxsparro") && World.Rnd().nextFloat(0.0F, 0.115F) < shot.mass && getEnergyPastArmor(6.8F * World.Rnd().nextFloat(1.0F, 1.5F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** WingROut Spar Damaged..");
                    nextDMGLevels(1, 2, "WingROut_D" + chunkDamageVisible("WingROut"), shot.initiator);
                }
                if(s.startsWith("xxsparsl") && World.Rnd().nextFloat() < 0.5F && getEnergyPastArmor((double)(6.8F * World.Rnd().nextFloat(1.0F, 1.5F)) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** StabL Spars Damaged..");
                    nextDMGLevels(1, 2, "StabL_D" + chunkDamageVisible("StabL"), shot.initiator);
                }
                if(s.startsWith("xxsparsr") && World.Rnd().nextFloat() < 0.5F && getEnergyPastArmor((double)(6.8F * World.Rnd().nextFloat(1.0F, 1.5F)) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** StabR Spars Damaged..");
                    nextDMGLevels(1, 2, "StabR_D" + chunkDamageVisible("StabR"), shot.initiator);
                }
                if(s.startsWith("xxspark") && World.Rnd().nextFloat() < 0.5F && getEnergyPastArmor((double)(6.8F * World.Rnd().nextFloat(1.0F, 1.5F)) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Keel Spars Damaged..");
                    nextDMGLevels(1, 2, "Keel1_D" + chunkDamageVisible("Keel1"), shot.initiator);
                }
                if(s.startsWith("xxspart") && World.Rnd().nextFloat() < 0.5F && getEnergyPastArmor((double)(6.8F * World.Rnd().nextFloat(1.0F, 1.5F)) / (Math.abs(Aircraft.v1.x) + 9.9999997473787516E-005D), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Tail Spars Damaged..");
                    nextDMGLevels(1, 2, "Tsil1_D" + chunkDamageVisible("Tsil1"), shot.initiator);
                }
            }
            if(s.startsWith("xxlock"))
            {
                Aircraft.debugprintln(this, "*** Lock Construction: Hit..");
                if(s.startsWith("xxlockr") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Rudder Lock Shot Off..");
                    nextDMGLevels(3, 2, "Rudder1_D" + chunkDamageVisible("Rudder1"), shot.initiator);
                }
                if(s.startsWith("xxlockvl") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** VatorL Lock Shot Off..");
                    nextDMGLevels(3, 2, "VatorL_D" + chunkDamageVisible("VatorL"), shot.initiator);
                }
                if(s.startsWith("xxlockvr") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** VatorR Lock Shot Off..");
                    nextDMGLevels(3, 2, "VatorR_D" + chunkDamageVisible("VatorR"), shot.initiator);
                }
                if(s.startsWith("xxlockal") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    debuggunnery("Lock Construction: AroneL Lock Shot Off..");
                    nextDMGLevels(3, 2, "AroneL_D" + chunkDamageVisible("AroneL"), shot.initiator);
                }
                if(s.startsWith("xxlockar") && getEnergyPastArmor(5.5F * World.Rnd().nextFloat(1.0F, 1.2F), shot) > 0.0F)
                {
                    debuggunnery("Lock Construction: AroneR Lock Shot Off..");
                    nextDMGLevels(3, 2, "AroneR_D" + chunkDamageVisible("AroneR"), shot.initiator);
                }
            }
            if(s.startsWith("xxeng"))
            {
                Aircraft.debugprintln(this, "*** Engine Module: Hit..");
                if(s.endsWith("prop"))
                {
                    if(getEnergyPastArmor(3.6F, shot) > 0.0F && World.Rnd().nextFloat() < 0.8F)
                        if(World.Rnd().nextFloat() < 0.5F)
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Prop Governor Hit, Disabled..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u0440\u043E\u043F\u0435\u043B\u043B\u0435\u0440 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D, \u043E\u0442\u043A\u0430\u0437 \u043F\u0440\u043E\u043F\u0435\u043B\u043B\u0435\u0440\u0430");
                            FM.AS.setEngineSpecificDamage(shot.initiator, 0, 3);
                        } else
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Prop Governor Hit, Damaged..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u0440\u043E\u043F\u0435\u043B\u043B\u0435\u0440 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D");
                            FM.AS.setEngineSpecificDamage(shot.initiator, 0, 4);
                        }
                } else
                if(s.endsWith("gear"))
                {
                    if(getEnergyPastArmor(4.6F, shot) > 0.0F && World.Rnd().nextFloat() < 0.25F)
                    {
                        Aircraft.debugprintln(this, "*** Engine Module: Bullet Jams Reductor Gear..");
						if(super.FM.isPlayers())
						HUD.log("\u041F\u0440\u043E\u043F\u0435\u043B\u043B\u0435\u0440 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D");
                        FM.EI.engines[0].setEngineStuck(shot.initiator);
                    }
                } else
                if(s.endsWith("supc"))
                {
                    if(getEnergyPastArmor(2.0F, shot) > 0.0F && World.Rnd().nextFloat() < 0.89F)
                    {
                        Aircraft.debugprintln(this, "*** Engine Module: Supercharger Disabled..");
						if(super.FM.isPlayers())
						HUD.log("\u041D\u0430\u0434\u0434\u0443\u0432 \u043D\u0435\u0438\u0441\u043F\u0440\u0430\u0432\u0435\u043D");
                        FM.AS.setEngineSpecificDamage(shot.initiator, 0, 0);
                    }
                } else
                if(s.endsWith("fue1"))
                {
                    if(getEnergyPastArmor(1.1F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Engine Module: Fuel Line Pierced, Engine Fired..");
						if(super.FM.isPlayers())
						HUD.log("\u0422\u043E\u043F\u043B\u0438\u0432\u043E\u043F\u0440\u043E\u0432\u043E\u0434 \u043F\u0440\u043E\u0431\u0438\u0442, \u0442\u043E\u043F\u043B\u0438\u0432\u043E \u0432\u043E\u0441\u043F\u043B\u0430\u043C\u0435\u043D\u0438\u043B\u043E\u0441\u044C");
                        FM.AS.hitEngine(shot.initiator, 0, 100);
                    }
                } else
                if(s.endsWith("fue2"))
                {
                    if(getEnergyPastArmor(1.1F, shot) > 0.0F)
                    {
                        Aircraft.debugprintln(this, "*** Engine Module: Fuel Line Stalled, Engine Stalled..");
						if(super.FM.isPlayers())
						HUD.log("\u0422\u043E\u043F\u043B\u0438\u0432\u043E\u043F\u0440\u043E\u0432\u043E\u0434 \u043F\u0440\u043E\u0431\u0438\u0442, \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044C \u0437\u0430\u0433\u043B\u043E\u0445");
                        ((FlightModelMain) (super.FM)).EI.engines[0].setEngineStops(shot.initiator);
                    }
                } else
                if(s.endsWith("case"))
                {
                    if(getEnergyPastArmor(2.2F, shot) > 0.0F)
                    {
                        if(World.Rnd().nextFloat() < shot.power / 175000F)
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Bullet Jams Crank Ball Bearing..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u043E\u043F\u043E\u0440\u043D\u044B\u0439 \u043F\u043E\u0434\u0448\u0438\u043F\u043D\u0438\u043A \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E");
                            FM.AS.setEngineStuck(shot.initiator, 0);
                        }
                        if(World.Rnd().nextFloat() < shot.power / 50000F)
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Crank Case Hit, Readyness Reduced to " + FM.EI.engines[0].getReadyness() + "..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u0440\u0430\u0431\u043E\u0442\u043E\u0441\u043F\u043E\u0441\u043E\u0431\u043D\u043E\u0441\u0442\u044C \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F \u0441\u043D\u0438\u0436\u0435\u043D\u0430");
                            FM.AS.hitEngine(shot.initiator, 0, 2);
                        }
                    }
                    FM.EI.engines[0].setReadyness(shot.initiator, FM.EI.engines[0].getReadyness() - World.Rnd().nextFloat(0.0F, shot.power / 48000F));
                    Aircraft.debugprintln(this, "*** Engine Module: Crank Case Hit, Readyness Reduced to " + FM.EI.engines[0].getReadyness() + "..");
					if(super.FM.isPlayers())
					HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u0440\u0430\u0431\u043E\u0442\u043E\u0441\u043F\u043E\u0441\u043E\u0431\u043D\u043E\u0441\u0442\u044C \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F \u0441\u043D\u0438\u0436\u0435\u043D\u0430");
                    getEnergyPastArmor(22.5F, shot);
                } else
                if(s.endsWith("cyl1"))
                {
                    if(getEnergyPastArmor(1.3F, shot) > 0.0F && World.Rnd().nextFloat() < FM.EI.engines[0].getCylindersRatio() * 1.75F)
                    {
                        FM.EI.engines[0].setCyliderKnockOut(shot.initiator, World.Rnd().nextInt(1, (int)(shot.power / 4800F)));
                        Aircraft.debugprintln(this, "*** Engine Module: Cylinders Hit, " + FM.EI.engines[0].getCylindersOperable() + "/" + FM.EI.engines[0].getCylinders() + " Left..");
						if(super.FM.isPlayers())
						HUD.log("\u0411\u043B\u043E\u043A \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D, " + FM.EI.engines[0].getCylindersOperable() + " \u0438\u0437 " + FM.EI.engines[0].getCylinders() + " \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432 \u043E\u0441\u0442\u0430\u043B\u043E\u0441\u044C");
                        if(World.Rnd().nextFloat() < shot.power / 48000F)
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Cylinders Hit, Engine Fires..");
							if(super.FM.isPlayers())
							HUD.log("\u0411\u043B\u043E\u043A \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0451\u043D, \u043F\u043E\u0436\u0430\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F");
                            FM.AS.hitEngine(shot.initiator, 0, 3);
                        }
                        if(World.Rnd().nextFloat() < 0.01F)
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Bullet Jams Piston Head..");
							if(super.FM.isPlayers())
							HUD.log("\u0413\u043E\u043B\u043E\u0432\u043A\u0430 \u0431\u043B\u043E\u043A\u0430 \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0435\u043D\u0430");
                            FM.AS.setEngineStuck(shot.initiator, 0);
                        }
                        getEnergyPastArmor(22.5F, shot);
                    }
                    if(Math.abs(point3d.y) < 0.1379999965429306D && getEnergyPastArmor(3.2F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                    {
                        if(World.Rnd().nextFloat() < 0.1F)
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Feed Gear Hit, Engine Stalled..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044C \u0437\u0430\u0433\u043B\u043E\u0445");
                            FM.EI.engines[0].setEngineStops(shot.initiator);
                        }
                        if(World.Rnd().nextFloat() < 0.05F)
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Feed Gear Hit, Engine Jams..");
							if(super.FM.isPlayers())
							HUD.log("\u0414\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044C \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E");
                            FM.AS.setEngineStuck(shot.initiator, 0);
                        }
                        if(World.Rnd().nextFloat() < 0.1F)
                        {
                            Aircraft.debugprintln(this, "*** Engine Module: Feed Gear Hit, Cylinders Feed Cut..");
							if(super.FM.isPlayers())
							HUD.log("\u041F\u043E\u043F\u0430\u0434\u0430\u043D\u0438\u0435 \u0432 \u043A\u0430\u0440\u0442\u0435\u0440 \u0434\u0432\u0438\u0433\u0430\u0442\u0435\u043B\u044F, \u043D\u0430\u0440\u0443\u0448\u0435\u043D\u0438\u0435 \u0440\u0430\u0431\u043E\u0442\u044B \u0446\u0438\u043B\u0438\u043D\u0434\u0440\u043E\u0432");
                            FM.EI.engines[0].setCyliderKnockOut(shot.initiator, 6);
                        }
                    }
                } else
                if(s.startsWith("xxeng1mag1"))
                {
                    int j = s.charAt(9) - 49;
                    Aircraft.debugprintln(this, "*** Engine Module: Magneto #1 Destroyed..");
						if(super.FM.isPlayers())
						HUD.log("\u041C\u0430\u0433\u043D\u0435\u0442\u043E 1 \u043D\u0435\u0438\u0441\u043F\u0440\u0430\u0432\u043D\u043E");
                    FM.EI.engines[0].setMagnetoKnockOut(shot.initiator, 0);
                } else
                if(s.startsWith("xxeng1mag2"))
                {
                    int j = s.charAt(9) - 49;
                    Aircraft.debugprintln(this, "*** Engine Module: Magneto #2 Destroyed..");
						if(super.FM.isPlayers())
						HUD.log("\u041C\u0430\u0433\u043D\u0435\u0442\u043E 2 \u043D\u0435\u0438\u0441\u043F\u0440\u0430\u0432\u043D\u043E");
                    FM.EI.engines[0].setMagnetoKnockOut(shot.initiator, 1);
                } else
                if(s.startsWith("xxeng1oil") && getEnergyPastArmor(0.5F, shot) > 0.0F)
                {
                    Aircraft.debugprintln(this, "*** Engine Module: Oil Radiator Hit..");
					if(super.FM.isPlayers())
					HUD.log("\u041C\u0430\u0441\u043B\u043E\u0440\u0430\u0434\u0438\u0430\u0442\u043E\u0440 \u043F\u0440\u043E\u0431\u0438\u0442");
                    FM.AS.hitOil(shot.initiator, 0);
                }
            }
            if(s.startsWith("xxoil") && getEnergyPastArmor(2.1F, shot) > 0.0F)
            {
                Aircraft.debugprintln(this, "*** Engine Module: Oil Tank Pierced..");
				if(super.FM.isPlayers())
				HUD.log("\u041C\u0430\u0441\u043B\u043E\u0431\u0430\u043A \u043F\u0440\u043E\u0431\u0438\u0442");
                FM.AS.hitOil(shot.initiator, 0);
                getEnergyPastArmor(4.96F, shot);
            }
            if(s.startsWith("xxw1") && getEnergyPastArmor(0.1F, shot) > 0.0F)
            {
                Aircraft.debugprintln(this, "*** Engine Module: Water Filter Pierced..");
				if(super.FM.isPlayers())
				HUD.log("\u0412\u043E\u0434\u043E\u0440\u0430\u0434\u0438\u0430\u0442\u043E\u0440 \u043F\u0440\u043E\u0431\u0438\u0442");
				FM.AS.hitEngine(shot.initiator, 0, 1);
				FM.AS.doSetEngineState(shot.initiator, 0, 2);
                getEnergyPastArmor(4.96F, shot);
            }
            if(s.startsWith("xxw2") && getEnergyPastArmor(0.1F, shot) > 0.0F)
            {
                Aircraft.debugprintln(this, "*** Engine Module: Water Tank Pierced..");
				if(super.FM.isPlayers())
				HUD.log("\u0420\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u0435\u043B\u044C\u043D\u044B\u0439 \u0431\u0430\u0447\u043E\u043A \u043F\u0440\u043E\u0431\u0438\u0442");
				FM.AS.hitEngine(shot.initiator, 0, 1);
				FM.AS.doSetEngineState(shot.initiator, 0, 2);
                getEnergyPastArmor(4.96F, shot);
            }
            if(s.startsWith("xxtank"))
            {
                int k = s.charAt(6) - 49;
                if(getEnergyPastArmor(1.45F, shot) > 0.0F && World.Rnd().nextFloat() < 0.5F)
                {
                    if(FM.AS.astateTankStates[k] == 0)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Pierced..");
                        FM.AS.hitTank(shot.initiator, k, 1);
                        FM.AS.doSetTankState(shot.initiator, k, 1);
                    }else
                    if(FM.AS.astateTankStates[k] == 1)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Pierced..");
                        FM.AS.hitTank(shot.initiator, k, 2);
                        FM.AS.doSetTankState(shot.initiator, k, 2);  
                    }
                    if(World.Rnd().nextFloat() < 0.01F || shot.powerType == 3 && World.Rnd().nextFloat() < 0.8F)
                    {
                        debuggunnery("Fuel Tank (" + k + "): Hit..");
                        FM.AS.doSetTankState(shot.initiator, k, 5);
                    }
                }
                return;
            }
            if(s.startsWith("xxmgun"))
            {
                if(s.endsWith("01"))
                {
                    Aircraft.debugprintln(this, "*** Cowling Gun: Disabled..");
                    FM.AS.setJamBullets(0, 0);
                }
                if(s.endsWith("02"))
                {
                    Aircraft.debugprintln(this, "*** Cowling Gun: Disabled..");
                    FM.AS.setJamBullets(0, 1);
                }
                if(s.endsWith("03"))
                {
                    Aircraft.debugprintln(this, "*** Cowling Gun: Disabled..");
                    FM.AS.setJamBullets(1, 0);
                }
                getEnergyPastArmor(World.Rnd().nextFloat(3.3F, 12.96F), shot);
            }
            if(s.startsWith("xxcannon"))
            {
                if(s.endsWith("01"))
                {
                    Aircraft.debugprintln(this, "*** Cowling Cannon: Disabled..");
                    FM.AS.setJamBullets(1, 0);
                }
                if(s.endsWith("02"))
                {
                    Aircraft.debugprintln(this, "*** Cowling Cannon: Disabled..");
                    FM.AS.setJamBullets(1, 1);
                }
                getEnergyPastArmor(World.Rnd().nextFloat(3.3F, 24.6F), shot);
            }
            if(s.startsWith("xxpnm") && getEnergyPastArmor(4.8F, shot) > 0.0F)//пробитие баллона пневмосистемы
            {
                Aircraft.debugprintln(this, "*** Pneumo System: Off-Line..");
				if(super.FM.isPlayers())
				HUD.log("\u041F\u043D\u0435\u0432\u043C\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u0430 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0435\u043D\u0430");
                FM.AS.setInternalDamage(shot.initiator, 0);//выпуск шасси невозможен
                FM.AS.setInternalDamage(shot.initiator, 1);//выпуск щитков невозможен
				((FlightModelMain) (super.FM)).CT.bHasBrakeControl = false;//отказ тормозов
            }
            if(s.startsWith("xxhyd") && getEnergyPastArmor(4.8F, shot) > 0.0F)//пробитие пневмоцилиндра шасси
            {
                Aircraft.debugprintln(this, "*** Hydro System: Off-Line..");
				if(super.FM.isPlayers())
				HUD.log("\u041F\u043D\u0435\u0432\u043C\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u0430 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0435\u043D\u0430");
                FM.AS.setInternalDamage(shot.initiator, 0);//выпуск шасси невозможен
            }
            if(s.startsWith("xxins1"))
                FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 0x40);
            return;
        }
        if(s.startsWith("xcf") || s.startsWith("xcockpit") || s.startsWith("xwater"))
        {
            if(chunkDamageVisible("CF") < 3)
                hitChunk("CF", shot);
            if(s.startsWith("xcockpit"))
                if(point3d.z > 0.59999999999999998D)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 1);
                else
                if(point3d.y > 0.0D)
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 4);
                else
                    FM.AS.setCockpitState(shot.initiator, FM.AS.astateCockpitState | 0x10);
        } else
        if(s.startsWith("xeng"))
            hitChunk("Engine1", shot);
        else
        if(s.startsWith("xtail"))
        {
            if(chunkDamageVisible("Tail1") < 3)
                hitChunk("Tail1", shot);
        } else
        if(s.startsWith("xkeel"))
            hitChunk("Keel1", shot);
        else
        if(s.startsWith("xrudder"))
        {
            if(chunkDamageVisible("Rudder1") < 1)
                hitChunk("Rudder1", shot);
        } else
        if(s.startsWith("xstab"))
        {
            if(s.startsWith("xstabl") && chunkDamageVisible("StabL") < 2)
                hitChunk("StabL", shot);
            if(s.startsWith("xstabr") && chunkDamageVisible("StabR") < 1)
                hitChunk("StabR", shot);
        } else
        if(s.startsWith("xvator"))
        {
            if(s.startsWith("xvatorl") && chunkDamageVisible("VatorL") < 1)
                hitChunk("VatorL", shot);
            if(s.startsWith("xvatorr") && chunkDamageVisible("VatorR") < 1)
                hitChunk("VatorR", shot);
        } else
        if(s.startsWith("xwing"))
        {
            if(s.startsWith("xwinglin") && chunkDamageVisible("WingLMid") < 2)
                hitChunk("WingLMid", shot);
            if(s.startsWith("xwingrin") && chunkDamageVisible("WingRMid") < 2)
                hitChunk("WingRMid", shot);
            if(s.startsWith("xwinglmid") && chunkDamageVisible("WingLMid") < 3)
                hitChunk("WingLMid", shot);
            if(s.startsWith("xwingrmid") && chunkDamageVisible("WingRMid") < 3)
                hitChunk("WingRMid", shot);
            if(s.startsWith("xwinglout") && chunkDamageVisible("WingLOut") < 3)
                hitChunk("WingLOut", shot);
            if(s.startsWith("xwingrout") && chunkDamageVisible("WingROut") < 3)
                hitChunk("WingROut", shot);
        } else
        if(s.startsWith("xarone"))
        {
            if(s.startsWith("xaronel"))
                hitChunk("AroneL", shot);
            if(s.startsWith("xaroner"))
                hitChunk("AroneR", shot);
        } else
        if(s.startsWith("xgear"))
        {
            if(s.endsWith("1") && World.Rnd().nextFloat() < 0.05F)
            {
                Aircraft.debugprintln(this, "*** Hydro System (Wheel): Off-Line..");
				if(super.FM.isPlayers())
				HUD.log("\u0413\u0438\u0434\u0440\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u0430 \u043F\u043E\u0432\u0440\u0435\u0436\u0434\u0435\u043D\u0430");
                FM.AS.setInternalDamage(shot.initiator, 0);
                gearDamageFX(s);
            }
            if(s.endsWith("2") && World.Rnd().nextFloat() < 0.1F)
            {
                Aircraft.debugprintln(this, "*** Gears: Stuck..");
				if(super.FM.isPlayers())
				HUD.log("\u0428\u0430\u0441\u0441\u0438 \u0437\u0430\u043A\u043B\u0438\u043D\u0438\u043B\u043E");
                FM.AS.setInternalDamage(shot.initiator, 3);
            }
        } else
        if(s.startsWith("xpilot") || s.startsWith("xhead"))
        {
            byte byte0 = 0;
            int l;
            if(s.endsWith("a"))
            {
                byte0 = 1;
                l = s.charAt(6) - 49;
            } else
            if(s.endsWith("b"))
            {
                byte0 = 2;
                l = s.charAt(6) - 49;
            } else
            {
                l = s.charAt(5) - 49;
            }
            hitFlesh(l, shot, byte0);
        }
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, -88F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, -88F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, -40F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, -40F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -78F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, -78F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL5_D0", 0.0F, Math.max(-f * kl * 1500F, -90F), 0.0F);
        hiermesh.chunkSetAngles("GearR5_D0", 0.0F, Math.max(-f1 * kr * 1500F, -90F), 0.0F);
        hiermesh.chunkSetAngles("GearC2_D0", 0.0F, 70F * f2 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, -80F * f2 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, -80F * f2 * kc, 0.0F);
		Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
		hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void rareAction(float f, boolean flag)
    {
        super.rareAction(f, flag);
        if(flag)
        {
			//Код затухания, вероятность затухания белого дыма 0.01%, после затухания остаётся течь
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 2 && World.Rnd().nextFloat() < 0.001F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 2 && World.Rnd().nextFloat() < 0.001F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 2 && World.Rnd().nextFloat() < 0.001F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 2 && World.Rnd().nextFloat() < 0.001F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания чёрного дыма 3%, после затухания остаётся белый дым
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 3 && World.Rnd().nextFloat() < 0.03F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 3 && World.Rnd().nextFloat() < 0.03F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 3 && World.Rnd().nextFloat() < 0.03F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 3 && World.Rnd().nextFloat() < 0.03F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания огня без дыма 2%, после затухания остаётся чёрный дым (чёрный дым может снова загореться, вероятность зашита где-то в базовых классах)
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 4 && World.Rnd().nextFloat() < 0.02F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 4 && World.Rnd().nextFloat() < 0.02F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 4 && World.Rnd().nextFloat() < 0.02F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 4 && World.Rnd().nextFloat() < 0.02F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
 			//Код затухания, вероятность затухания огня с дымом 0.5%, после затухания остаётся огонь без дыма (огонь без дыма может снова стать с дымом, вероятность зашита где-то в базовых классах)
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] == 5 && World.Rnd().nextFloat() < 0.005F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 0, ((FlightModelMain) (super.FM)).AS.astateTankStates[0] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] == 5 && World.Rnd().nextFloat() < 0.005F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 1, ((FlightModelMain) (super.FM)).AS.astateTankStates[1] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] == 5 && World.Rnd().nextFloat() < 0.005F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 2, ((FlightModelMain) (super.FM)).AS.astateTankStates[2] - 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] == 5 && World.Rnd().nextFloat() < 0.005F)
				((FlightModelMain) (super.FM)).AS.setTankState(this, 3, ((FlightModelMain) (super.FM)).AS.astateTankStates[3] - 1);
        }
        if(FM.getAltitude() < 3000F)
            hierMesh().chunkVisible("HMask1_D0", false);
        else
            hierMesh().chunkVisible("HMask1_D0", hierMesh().isChunkVisible("Head1_D0"));
    }

    private void gearDamageFX(String s)
    {
        if(s.startsWith("xgearl") || s.startsWith("GearL"))
        {
            if(super.FM.isPlayers())
            HUD.log("\u041B\u0435\u0432\u0430\u044F \u0441\u0442\u043E\u0439\u043A\u0430 \u0448\u0430\u0441\u0441\u0438: \u043E\u0442\u043A\u0430\u0437 \u043F\u043D\u0435\u0432\u043C\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u044B");
/* 			HUD.log("Left Gear:  Hydraulic system Failed"); */
			kl = World.Rnd().nextFloat();
            kr = World.Rnd().nextFloat() * kl;
        } else
        if(s.startsWith("xgearr") || s.startsWith("GearR"))
        {
            if(super.FM.isPlayers())
            HUD.log("\u041F\u0440\u0430\u0432\u0430\u044F \u0441\u0442\u043E\u0439\u043A\u0430 \u0448\u0430\u0441\u0441\u0438: \u043E\u0442\u043A\u0430\u0437 \u043F\u043D\u0435\u0432\u043C\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u044B");
/*             HUD.log("Right Gear:  Hydraulic system Failed"); */
			kr = World.Rnd().nextFloat();
            kl = World.Rnd().nextFloat() * kr;
        }
        {
            if(super.FM.isPlayers())
            HUD.log("\u0425\u0432\u043E\u0441\u0442\u043E\u0432\u043E\u0435 \u043A\u043E\u043B\u0435\u0441\u043E: \u043E\u0442\u043A\u0430\u0437 \u043F\u043D\u0435\u0432\u043C\u043E\u0441\u0438\u0441\u0442\u0435\u043C\u044B");
/*             HUD.log("Center Gear:  Hydraulic system Failed"); */
			kc = World.Rnd().nextFloat();
            kl = World.Rnd().nextFloat() * kc;
            kr = World.Rnd().nextFloat() * kc;
        }
        ((FlightModelMain) (super.FM)).CT.GearControl = 1.0F;
        ((FlightModelMain) (super.FM)).Gears.setHydroOperable(false);
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private static float kl = 1.0F;
    private static float kr = 1.0F;
    private static float kc = 1.0F;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.MIG_1xyz.class;
        Property.set(class1, "originCountry", PaintScheme.countryRussia);
    }
}