package com.maddox.il2.objects.air;

import com.maddox.JGP.*;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.rts.*;

public class CockpitMIG_3UB extends CockpitPilot
{
    class Interpolater extends InterpolateRef
    {

        public boolean tick()
        {
            if(bNeedSetUp)
            {
                reflectPlaneMats();
                bNeedSetUp = false;
            }
            if(fm != null)
            {
                setTmp = setOld;
                setOld = setNew;
                setNew = setTmp;
                setNew.throttle = (10F * setOld.throttle + ((FlightModelMain) (fm)).CT.PowerControl) / 11F;
                setNew.prop = (10F * setOld.prop + ((FlightModelMain) (fm)).EI.engines[0].getControlProp()) / 11F;
                setNew.mix = 0.8F * setOld.mix + 0.2F * ((FlightModelMain) (fm)).EI.engines[0].getControlMix();
                setNew.altimeter = fm.getAltitude();
                if(Math.abs(((FlightModelMain) (fm)).Or.getKren()) < 30F)
                    setNew.azimuth = (35F * setOld.azimuth + ((FlightModelMain) (fm)).Or.azimut()) / 36F;
                if(setOld.azimuth > 270F && setNew.azimuth < 90F)
                    setOld.azimuth -= 360F;
                if(setOld.azimuth < 90F && setNew.azimuth > 270F)
                    setOld.azimuth += 360F;
                setNew.vspeed = (199F * setOld.vspeed + fm.getVertSpeed()) / 200F;
            }
            return true;
        }

        Interpolater()
        {
        }
    }

    private class Variables
    {

        float throttle;
        float prop;
        float altimeter;
        float azimuth;
        float vspeed;
        float mix;
        float xyz[] = {
            0.0F, 0.0F, 0.0F
        };
        float ypr[] = {
            0.0F, 0.0F, 0.0F
        };

        private Variables()
        {
        }

        Variables(Variables variables)
        {
            this();
        }
    }

    public CockpitMIG_3UB()
    {
        super("3do/cockpit/MiG-3/hier_UB.him", "bf109");
        setOld = new Variables(null);
        setNew = new Variables(null);
        w = new Vector3f();
        bNeedSetUp = true;
        pictAiler = 0.0F;
        pictElev = 0.0F;
        pictFlap = 0.0F;
        pictGear = 0.0F;
        pictDoor = 0.0F;
        pictRadiator = 0.0F;
        super.cockpitNightMats = (new String[] {
            "prib1", "prib2", "prib3", "prib4", "prib5", "arrow", "prib1_dd", "prib2_dd", "prib3_dd"
        });
        setNightMats(false);
        interpPut(new Interpolater(), null, Time.current(), null);
    }

    public void reflectWorldToInstruments(float f)
    {
        if(bNeedSetUp)
        {
            reflectPlaneMats();
            bNeedSetUp = false;
        }
        resetYPRmodifier();
        float f1 = Cockpit.xyz[0];
        Cockpit.xyz[0] = -cvt(((FlightModelMain) (super.fm)).CT.getCockpitDoor(), 0.11F, 0.99F, 0.0F, 0.6F);
        super.mesh.chunkSetLocate("Blister", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
        if(((FlightModelMain) (super.fm)).CT.saveWeaponControl[2])
            Cockpit.xyz[2] = -0.004F;
        super.mesh.chunkSetLocate("r_three", Cockpit.xyz, Cockpit.ypr);
        super.mesh.chunkSetAngles("richag", 0.0F, (pictElev = 0.85F * pictElev + 0.12F * ((FlightModelMain) (super.fm)).CT.ElevatorControl) * 10F, (pictAiler = 0.85F * pictAiler + 0.15F * ((FlightModelMain) (super.fm)).CT.AileronControl) * 15F);
        super.mesh.chunkSetAngles("Ped_Base", 0.0F, -((FlightModelMain) (super.fm)).CT.getRudder() * 18F, 0.0F);
        super.mesh.chunkSetAngles("LightK", 0.0F, super.cockpitLightControl ? 60F : 0.0F, 0.0F);
        super.mesh.chunkSetAngles("LightD", 0.0F, super.cockpitLightControl ? 60F : 0.0F, 0.0F);
        super.mesh.chunkSetAngles("PedalL", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 18F, 0.0F);
        super.mesh.chunkSetAngles("PedalR", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 18F, 0.0F);
        super.mesh.chunkSetAngles("TrubkaR", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 18F, 0.0F);
        super.mesh.chunkSetAngles("TrosR", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 18F, 0.0F);
        super.mesh.chunkSetAngles("TrosL", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 18F, 0.0F);
        super.mesh.chunkSetAngles("ANO", 0.0F, ((FlightModelMain) (super.fm)).AS.bNavLightsOn ? -40F : 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Fara", 0.0F, ((FlightModelMain) (super.fm)).AS.bLandingLightOn ? -40F : 0.0F, 0.0F);
        super.mesh.chunkSetAngles("ZamokR", -85F * (pictDoor = 0.89F * pictDoor + 0.11F * ((FlightModelMain) (super.fm)).CT.getCockpitDoor()), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Flaps", -153F * (pictFlap = 0.89F * pictFlap + 0.11F * ((FlightModelMain) (super.fm)).CT.FlapsControl), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Radiator", 60F * (pictRadiator = 0.89F * pictRadiator + 0.11F * ((FlightModelMain) (super.fm)).EI.engines[0].getControlRadiator()), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Drossel", 0.0F, interp(setNew.throttle, setOld.throttle, f) * -45F * 0.91F, 0.0F);
        super.mesh.chunkSetAngles("Forsaj", 0.0F, interp(setNew.mix, setOld.mix, f) * -37F * 0.91F, 0.0F);
        super.mesh.chunkSetAngles("r_one", 0.0F, -20F * (float)(((FlightModelMain) (super.fm)).CT.WeaponControl[0] ? 1 : 0), 0.0F);
        super.mesh.chunkSetAngles("r_two", 0.0F, -20F * (float)(((FlightModelMain) (super.fm)).CT.WeaponControl[1] ? 1 : 0), 0.0F);
        super.mesh.chunkSetAngles("r_turn", 0.0F, -20F * ((FlightModelMain) (super.fm)).CT.BrakeControl, 0.0F);
        if(((FlightModelMain) (super.fm)).Gears.isHydroOperable())
            super.mesh.chunkSetAngles("Gear", -150F * (pictGear = 0.89F * pictGear + 0.11F * ((FlightModelMain) (super.fm)).CT.GearControl), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zAlt1a", 0.0F, cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 3600F), 0.0F);
        super.mesh.chunkSetAngles("zAlt1b", 0.0F, cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 360F), 0.0F);
        super.mesh.chunkSetAngles("zAzimuth1b", 0.0F, interp(setNew.azimuth, setOld.azimuth, f), 0.0F);
        super.mesh.chunkSetLocate("zHorizon1a", setOld.xyz, setOld.ypr);
        super.mesh.chunkSetAngles("zHorizon1b", 0.0F, ((FlightModelMain) (super.fm)).Or.getKren(), 0.0F);
        super.mesh.chunkSetAngles("zManifold1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].getManifoldPressure(), 0.4F, 2.133F, 0.0F, 334.286F), 0.0F);
        super.mesh.chunkSetAngles("zGas1a", 0.0F, cvt(((FlightModelMain) (super.fm)).M.fuel / 0.72F, 0.0F, 300F, 0.0F, 171F), 0.0F);
        super.mesh.chunkSetAngles("zSpeed1a", 0.0F, floatindex(cvt(Pitot.Indicator((float)((Tuple3d) (((FlightModelMain) (super.fm)).Loc)).z, super.fm.getSpeedKMH()), 0.0F, 800F, 0.0F, 16F), speedometerScale), 0.0F);
        w.set(super.fm.getW());
        ((FlightModelMain) (super.fm)).Or.transform(w);
        super.mesh.chunkSetAngles("zTurn1a", 0.0F, cvt(((Tuple3f) (w)).z, -0.23562F, 0.23562F, 30F, -30F), 0.0F);
        super.mesh.chunkSetAngles("zSlide1a", 0.0F, cvt(getBall(8D), -8F, 8F, -28F, 28F), 0.0F);
        super.mesh.chunkSetAngles("zVariometer1a", 0.0F, cvt(setNew.vspeed, -10F, 10F, -180F, 180F), 0.0F);
        super.mesh.chunkSetAngles("zRPM1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 10000F, 0.0F, 3600F), 0.0F);
        super.mesh.chunkSetAngles("zRPM1b", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 10000F, 0.0F, 360F), 0.0F);
        super.mesh.chunkSetAngles("zTOilOut1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].tOilOut, 0.0F, 125F, 0.0F, 180F), 0.0F);
        super.mesh.chunkSetAngles("zOilPrs1a", 0.0F, -cvt(((FlightModelMain) (super.fm)).M.fuel > 1.0F ? cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 3050F, 0.0F, 4F) : 0.0F, 0.0F, 8F, 0.0F, -180F), 0.0F);
        super.mesh.chunkSetAngles("zGasPrs1a", 0.0F, cvt(((FlightModelMain) (super.fm)).M.fuel > 1.0F ? cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 3050F, 0.0F, 4F) : 0.0F, 0.0F, 8F, 0.0F, -180F), 0.0F);
        super.mesh.chunkSetAngles("zTWater1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].tWaterOut, 0.0F, 120F, 0.0F, 92F), 0.0F);
        super.mesh.chunkSetAngles("zTOilIn1a", 0.0F, cvt(((FlightModelMain) (super.fm)).EI.engines[0].tOilIn, 0.0F, 120F, 0.0F, 92F), 0.0F);
        super.mesh.chunkSetAngles("zClock1a", 0.0F, cvt(World.getTimeofDay() % 1.0F, 0.0F, 1.0F, 0.0F, 360F), 0.0F);
        super.mesh.chunkSetAngles("zClock1b", 0.0F, cvt(World.getTimeofDay(), 0.0F, 24F, 0.0F, 720F), 0.0F);
        super.mesh.chunkVisible("Z_GearLGreen1", ((FlightModelMain) (super.fm)).CT.getGear() == 1.0F);
        super.mesh.chunkVisible("Z_GearRGreen1", ((FlightModelMain) (super.fm)).CT.getGear() == 1.0F);
        super.mesh.chunkVisible("Z_GearLRed1", ((FlightModelMain) (super.fm)).CT.getGear() == 0.0F);
        super.mesh.chunkVisible("Z_GearRRed1", ((FlightModelMain) (super.fm)).CT.getGear() == 0.0F);
        super.mesh.chunkSetAngles("Magneto1", cvt(fm.EI.engines[0].getControlMagnetos(), 0.0F, 3F, 0.0F, -85F), 0.0F, 0.0F);
    }

    public void reflectCockpitState()
    {
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 4) != 0 || (((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x10) != 0)
        {
            super.mesh.chunkVisible("Z_Z_MASK", false);
            super.mesh.chunkVisible("Z_Z_RETICLE", false);
            super.mesh.chunkVisible("prib1", false);
            super.mesh.chunkVisible("prib1_d1", true);
            super.mesh.chunkVisible("zAlt1a", false);
            super.mesh.chunkVisible("zAlt1b", false);
            super.mesh.chunkVisible("zAzimuth1b", false);
            super.mesh.chunkVisible("zHorizon1a", false);
            super.mesh.chunkVisible("zHorizon1b", false);
            super.mesh.chunkVisible("zSpeed1a", false);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 8) != 0 || (((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x20) != 0)
        {
            super.mesh.chunkVisible("prib3", false);
            super.mesh.chunkVisible("prib3_d1", true);
            super.mesh.chunkVisible("zManifold1a", false);
            super.mesh.chunkVisible("zVariometer1a", false);
            super.mesh.chunkVisible("zGas1a", false);
            super.mesh.chunkVisible("zTurn1a", false);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x40) != 0)
            super.mesh.chunkVisible("zTWater1a", false);
            super.mesh.chunkVisible("zTOilIn1a", false);
            super.mesh.chunkVisible("zRPM1a", false);
            super.mesh.chunkVisible("zRPM1b", false);
            super.mesh.chunkVisible("zOilPrs1a", false);
            super.mesh.chunkVisible("zTOilOut1a", false);
            super.mesh.chunkVisible("zGasPrs1a", false);
            super.mesh.chunkVisible("prib2", false);
            super.mesh.chunkVisible("prib2_d1", true);
    }

    protected void reflectPlaneMats()
    {
        HierMesh hiermesh = aircraft().hierMesh();
        com.maddox.il2.engine.Mat mat = hiermesh.material(hiermesh.materialFind("Gloss1D0o"));
        super.mesh.materialReplace("Gloss1D0o", mat);
        if(aircraft() instanceof MIG_3EARLY)
            super.mesh.chunkVisible("Engine1_D0_E", true);
        else
            super.mesh.chunkVisible("Engine1_D0", true);
    }

    public void toggleLight()
    {
        cockpitLightControl = !cockpitLightControl;
        if(cockpitLightControl)
            setNightMats(true);
        else
            setNightMats(false);
    }

    private void retoggleLight()
    {
        if(cockpitLightControl)
        {
            setNightMats(false);
            setNightMats(true);
        } else
        {
            setNightMats(true);
            setNightMats(false);
        }
    }

    public void doToggleDim()
    {
    }

    private Variables setOld;
    private Variables setNew;
    private Variables setTmp;
    public Vector3f w;
    private boolean bNeedSetUp;
    private float pictAiler;
    private float pictElev;
    private float pictFlap;
    private float pictGear;
    private float pictDoor;
    private float pictRadiator;
    private static final float speedometerScale[] = {
        0.0F, 0.0F, 14F, 48.7F, 90.5F, 136F, 184F, 213F, 235F, 239F, 
        256F, 268F, 280F, 292F, 305F, 317F, 330F
    };

    static 
    {
        Property.set(CLASS.THIS(), "normZNs", new float[] {
            0.8F, 0.7F, 0.8F, 0.7F
        });
    }
}