package com.maddox.il2.objects.air;

import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.rts.Property;

public class MIG_3U extends MIG_3
{

    public MIG_3U()
    {
        kangle = 0.0F;
        flapps = 0.0F;
        kl = 1.0F;
        kr = 1.0F;
        kc = 1.0F;
    }

    public float getEyeLevelCorrection()
    {
        return 0.2F;
    }

    public void update(float f)
    {
        if(Math.abs(flapps - kangle) > 0.01F)
        {
            flapps = kangle;
            hierMesh().chunkSetAngles("FlapWater_D0", 0.0F, 0.0F, 40.5F * kangle);
            hierMesh().chunkSetAngles("FlapOil_D0", 0.0F, 0.0F, 12.5F * kangle);
        }
        kangle = 0.95F * kangle + 0.05F * FM.EI.engines[0].getControlRadiator();
		afterburnerhud();
        super.update(f);
    }

    public static void moveGear(HierMesh hiermesh, float f, float f1, float f2)
    {
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 88F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, -88F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearC2_D0", 0.0F, 70F * f2 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, 93F * f * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, -93F * f1 * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL4_D0", 0.0F, Math.max(-f * kl * 1500F, -90F), 0.0F);
        hiermesh.chunkSetAngles("GearR4_D0", 0.0F, -Math.max(-f1 * kr * 1500F, -90F), 0.0F);
        float f3 = Math.max(-f2 * 1500F, -90F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, f3 * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, -f3 * kc, 0.0F);
		Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(f, 0.0F, 1.0F, 0.0F, 0.1F);
		hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

    protected void moveGear(float f, float f1, float f2)
    {
        moveGear(hierMesh(), f, f1, f2);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    public void msgShot(Shot shot)
    {
        setShot(shot);
        if((shot.chunkName.startsWith("CF") || shot.chunkName.startsWith("Tail")) && World.Rnd().nextFloat(0.0F, 1.0F) < 0.1F)
            FM.AS.hitTank(shot.initiator, 0, 2);
        if(World.Rnd().nextFloat(0.0F, 1.0F) < 0.1F)
            FM.AS.hitTank(shot.initiator, 1, 1);
        if(shot.chunkName.startsWith("WingLIn") && World.Rnd().nextFloat(0.0F, 1.0F) < 0.1F)
            FM.AS.hitTank(shot.initiator, 2, 1);
        if(shot.chunkName.startsWith("WingRIn") && World.Rnd().nextFloat(0.0F, 1.0F) < 0.1F)
            FM.AS.hitTank(shot.initiator, 3, 1);
        if(shot.chunkName.startsWith("Engine1") && World.Rnd().nextFloat(0.0F, 1.0F) < 0.2F)
            FM.AS.hitEngine(shot.initiator, 0, 2);
        super.msgShot(shot);
    }

    protected boolean cutFM(int i, int j, Actor actor)
    {
        switch(i)
        {
        case 33: // '!'
            FM.AS.hitTank(this, 2, 7);
            return super.cutFM(34, j, actor);

        case 36: // '$'
            FM.AS.hitTank(this, 3, 7);
            return super.cutFM(37, j, actor);
        }
        return super.cutFM(i, j, actor);
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("\u041D\u0430\u0434\u0434\u0443\u0432 1240 \u043C\u043C!");
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private float kangle;
    private float flapps;
    private static float kl = 1.0F;
    private static float kr = 1.0F;
    private static float kc = 1.0F;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.MIG_3U.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "MiG-3U");
        Property.set(class1, "meshName", "3DO/Plane/MIG-3U(Multi1)/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar02());
        Property.set(class1, "yearService", 1942F);
        Property.set(class1, "yearExpired", 1943F);
        Property.set(class1, "FlightModel", "FlightModels/MiG-3U.fmd:MiG");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitMIG_3U.class
        });
        Property.set(class1, "LOSElevation", 0.906F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02"
        });
        Aircraft.weaponsRegister(class1, "default", new String[] {
            "MGunShVAKs 150", "MGunShVAKs 150"
        });
        Aircraft.weaponsRegister(class1, "none", new String[] {
            null, null
        });
    }
}