package com.maddox.il2.objects.air;

import com.maddox.JGP.Tuple3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.*;
import com.maddox.il2.ai.Wing;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.objects.Wreckage;
import com.maddox.il2.objects.sounds.SndAircraft;

public class BF_109Bx extends BF_109
{

    public BF_109Bx()
    {
        sideWindowOpened = false;
        slideRWindow = false;
        sideWindow = false;
        pit = null;
        bChangedPit = true;
        canopyF = 0.0F;
        fMaxKMHSpeedForOpenCanopy = 250F;
        kangle = 0.0F;
        tiltCanopyOpened = false;
        bHasBlister = true;
    }

    public void registerPit(CockpitBF_109Bx cockpitbf_109bx)
    {
        pit = cockpitbf_109bx;
    }

    public void update(float f)
    {
        if(super.FM.getSpeed() > 5F)
        {
            hierMesh().chunkSetAngles("SlatL_D0", 0.0F, 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F));
            hierMesh().chunkSetAngles("SlatR_D0", 0.0F, 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F));
        }
        hierMesh().chunkSetAngles("WaterL_D0", 0.0F, -38F * kangle, 0.0F);
        kangle = 0.95F * kangle + 0.05F * ((FlightModelMain) (super.FM)).EI.engines[0].getControlRadiator();
        if(kangle > 1.0F)
            kangle = 1.0F;
        super.update(f);
        if((double)((FlightModelMain) (super.FM)).CT.getCockpitDoor() > 0.20000000000000001D && bHasBlister && super.FM.getSpeedKMH() > fMaxKMHSpeedForOpenCanopy && hierMesh().chunkFindCheck("Blister1_D0") != -1 && !sideWindowOpened)
        {
            try
            {
                if(this == World.getPlayerAircraft())
                    ((CockpitBF_109Bx)Main3D.cur3D().cockpitCur).removeCanopy();
            }
            catch(Exception exception) { }
            hierMesh().hideSubTrees("Blister1_D0");
            Wreckage wreckage = new Wreckage(this, hierMesh().chunkFind("Blister1_D0"));
            wreckage.collide(true);
            Vector3d vector3d = new Vector3d();
            vector3d.set(((FlightModelMain) (super.FM)).Vwld);
            wreckage.setSpeed(vector3d);
            bHasBlister = false;
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx += 0.04F;
            super.FM.setGCenter(-0.0F);
        }
        if(FM.isPlayers() && FM.Sq.squareElevators > 0.0F)
        {
            RealFlightModel realflightmodel = (RealFlightModel)FM;
            if(realflightmodel.RealMode && realflightmodel.fullMach > 0.7F)
            {
                float f2 = 1.0F + 3.84237F * (0.7F - realflightmodel.fullMach);
                if(f2 < 0.0F)
                    f2 = 0.0F;
                FM.SensPitch = 0.68F * f2;
                if(realflightmodel.fullMach > 0.636F)
                {
                    shake = 0.636F - realflightmodel.fullMach * f2;
                    realflightmodel.producedShakeLevel += shake * shake;
                    FM.producedAM.y += 6000F * shake * shake * 750F;
                    FM.producedAM.x -= 300F * ((0.636F - realflightmodel.fullMach) * 400F);
                }
            } else
            {
                FM.SensPitch = 0.68F;
            }
        }
    }

    public static void moveGear(HierMesh hiermesh, float f)
    {
        float f1 = 0.8F;
        float f2 = -0.5F * (float)Math.cos((double)(f / f1) * 3.1415926535897931D) + 0.5F;
        if(f <= f1)
        {
            hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -78F * f2, 0.0F);
            hiermesh.chunkSetAngles("GearL2_D0", -24F * f2, 0.0F, 0.0F);
        }
        f2 = -0.5F * (float)Math.cos((double)((f - (1.0F - f1)) / f1) * 3.1415926535897931D) + 0.5F;
        if(f >= 1.0F - f1)
        {
            hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 78F * f2, 0.0F);
            hiermesh.chunkSetAngles("GearR2_D0", 24F * f2, 0.0F, 0.0F);
        }
        if(f > 0.99F)
        {
            hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -78F, 0.0F);
            hiermesh.chunkSetAngles("GearL2_D0", -24F, 0.0F, 0.0F);
            hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 78F, 0.0F);
            hiermesh.chunkSetAngles("GearR2_D0", 24F, 0.0F, 0.0F);
        }
        if(f < 0.01F)
        {
            hiermesh.chunkSetAngles("GearL3_D0", 0.0F, 0.0F, 0.0F);
            hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 0.0F, 0.0F);
            hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 0.0F, 0.0F);
            hiermesh.chunkSetAngles("GearR2_D0", 0.0F, 0.0F, 0.0F);
        }
    }

    protected void moveGear(float f)
    {
        float f1 = 0.9F - (float)((Wing)getOwner()).aircIndex(this) * 0.1F;
        float f2 = -0.5F * (float)Math.cos((double)(f / f1) * 3.1415926535897931D) + 0.5F;
        if(f <= f1)
        {
            hierMesh().chunkSetAngles("GearL3_D0", 0.0F, -78F * f2, 0.0F);
            hierMesh().chunkSetAngles("GearL2_D0", -24F * f2, 0.0F, 0.0F);
        }
        f2 = -0.5F * (float)Math.cos((double)((f - (1.0F - f1)) / f1) * 3.1415926535897931D) + 0.5F;
        if(f >= 1.0F - f1)
        {
            hierMesh().chunkSetAngles("GearR3_D0", 0.0F, 78F * f2, 0.0F);
            hierMesh().chunkSetAngles("GearR2_D0", 24F * f2, 0.0F, 0.0F);
        }
        if(f > 0.99F)
        {
            hierMesh().chunkSetAngles("GearL3_D0", 0.0F, -78F, 0.0F);
            hierMesh().chunkSetAngles("GearL2_D0", -24F, 0.0F, 0.0F);
            hierMesh().chunkSetAngles("GearR3_D0", 0.0F, 78F, 0.0F);
            hierMesh().chunkSetAngles("GearR2_D0", 24F, 0.0F, 0.0F);
        }
    }

    public void moveSteering(float f)
    {
        if(f > 77.5F)
        {
            f = 77.5F;
            ((FlightModelMain) (super.FM)).Gears.steerAngle = f;
        }
        if(f < -77.5F)
        {
            f = -77.5F;
            ((FlightModelMain) (super.FM)).Gears.steerAngle = f;
        }
        hierMesh().chunkSetAngles("GearC2_D0", 0.0F, -f, 0.0F);
    }

    public void moveCockpitDoor(float f)
    {
        if(f > canopyF)
        {
            if((((FlightModelMain) (super.FM)).Gears.onGround() && super.FM.getSpeed() < 5F || tiltCanopyOpened) && (super.FM.isPlayers() || isNetPlayer()))
            {
                sideWindow = false;
                tiltCanopyOpened = true;
                hierMesh().chunkSetAngles("Blister1_D0", 0.0F, 90F * f, 0.0F);
            } else
            {
                sideWindow = true;
                if(pit != null && canopyF == 0.0F)
                    slideRWindow = pit.isViewRight();
                sideWindowOpened = true;
                resetYPRmodifier();
                Aircraft.xyz[1] = Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 0.24F);
                if(slideRWindow)
                    hierMesh().chunkSetLocate("WindowR1_D0", Aircraft.xyz, Aircraft.ypr);
                else
                    hierMesh().chunkSetLocate("WindowL1_D0", Aircraft.xyz, Aircraft.ypr);
            }
        } else
        if(((FlightModelMain) (super.FM)).Gears.onGround() && super.FM.getSpeed() < 5F && !sideWindowOpened || tiltCanopyOpened)
        {
            sideWindow = false;
            hierMesh().chunkSetAngles("Blister1_D0", 0.0F, 90F * f, 0.0F);
            if(f == 0.0F)
                tiltCanopyOpened = false;
        } else
        {
            sideWindow = true;
            resetYPRmodifier();
            Aircraft.xyz[1] = Aircraft.cvt(f, 0.01F, 0.99F, 0.0F, 0.24F);
            if(slideRWindow)
                hierMesh().chunkSetLocate("WindowR1_D0", Aircraft.xyz, Aircraft.ypr);
            else
                hierMesh().chunkSetLocate("WindowL1_D0", Aircraft.xyz, Aircraft.ypr);
            if(f == 0.0F)
                sideWindowOpened = false;
        }
        canopyF = f;
        if((double)canopyF < 0.01D)
            canopyF = 0.0F;
        if(Config.isUSE_RENDER())
        {
            if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                Main3D.cur3D().cockpits[0].onDoorMoved(f);
            setDoorSnd(f);
        }
    }
   
    static java.lang.Class _mthclass$(java.lang.String s)
    {
        java.lang.Class class1;
        try
        {
            class1 = java.lang.Class.forName(s);
        }
        catch(java.lang.ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    public float canopyF;
    private float fMaxKMHSpeedForOpenCanopy;
    private float kangle;
    public boolean tiltCanopyOpened;
    public boolean bHasBlister;
    private boolean sideWindowOpened;
    private boolean slideRWindow;
    public boolean sideWindow;
    CockpitBF_109Bx pit;
    public boolean bChangedPit;
    private float shake;
}