package com.maddox.il2.objects.air;

import com.maddox.JGP.Tuple3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.objects.Wreckage;
import com.maddox.il2.objects.sounds.SndAircraft;

public class BF_109E extends BF_109
{

    public BF_109E()
    {
        canopyF = 0.0F;
        tiltCanopyOpened = false;
        sideWindowOpened = false;
        sideWindow = false;
        bHasBlister = true;
        pit = null;
    }

    public void update(float f)
    {
        super.update(f);
        if((double)((FlightModelMain) (super.FM)).CT.getCockpitDoor() > 0.20000000000000001D && bHasBlister && super.FM.getSpeedKMH() > 100F && hierMesh().chunkFindCheck("Blister1_D0") != -1)
        {
            try
            {
                if(this == World.getPlayerAircraft())
                    ((CockpitBF_109E)Main3D.cur3D().cockpitCur).removeCanopy();
            }
            catch(Exception exception) { }
            hierMesh().hideSubTrees("Blister1_D0");
            Wreckage wreckage = new Wreckage(this, hierMesh().chunkFind("Blister1_D0"));
            wreckage.collide(true);
            Vector3d vector3d = new Vector3d();
            vector3d.set(((FlightModelMain) (super.FM)).Vwld);
            wreckage.setSpeed(vector3d);
            bHasBlister = false;
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            super.FM.setGCenter(-0.5F);
        }
    }

    public void moveCockpitDoor(float f)
    {
        if(f > canopyF)
        {
            if((((FlightModelMain) (super.FM)).Gears.onGround() && super.FM.getSpeed() < 5F || tiltCanopyOpened) && (super.FM.isPlayers() || isNetPlayer()))
            {
                sideWindow = false;
                tiltCanopyOpened = true;
                hierMesh().chunkSetAngles("Blister1_D0", 0.0F, 90F * f, 0.0F);
            } else
            {
                sideWindow = true;
                if(pit != null && canopyF == 0.0F)
                    sideWindowOpened = true;
            }
        } else
        if(((FlightModelMain) (super.FM)).Gears.onGround() && super.FM.getSpeed() < 5F && !sideWindowOpened || tiltCanopyOpened)
        {
            sideWindow = false;
            hierMesh().chunkSetAngles("Blister1_D0", 0.0F, 90F * f, 0.0F);
            if(f == 0.0F)
                tiltCanopyOpened = false;
        } else
        {
            sideWindow = true;
            if(f == 0.0F)
                sideWindowOpened = false;
        }
        canopyF = f;
        if((double)canopyF < 0.01D)
            canopyF = 0.0F;
        if(Config.isUSE_RENDER())
        {
            if(Main3D.cur3D().cockpits != null && Main3D.cur3D().cockpits[0] != null)
                Main3D.cur3D().cockpits[0].onDoorMoved(f);
            setDoorSnd(f);
        }
        if(FM.isPlayers() && FM.Sq.squareElevators > 0.0F)
        {
            RealFlightModel realflightmodel = (RealFlightModel)FM;
            if(realflightmodel.RealMode && realflightmodel.fullMach > 0.7F)
            {
                float f2 = 1.0F + 3.84237F * (0.7F - realflightmodel.fullMach);
                if(f2 < 0.0F)
                    f2 = 0.0F;
                FM.SensPitch = 0.7F * f2;
                if(realflightmodel.fullMach > 0.636F)
                {
                    shake = 0.636F - realflightmodel.fullMach * f2;
                    realflightmodel.producedShakeLevel += shake * shake;
                    FM.producedAM.y += 6000F * shake * shake * 750F;
                    FM.producedAM.x -= 300F * ((0.636F - realflightmodel.fullMach) * 400F);
                }
            } else
            {
                FM.SensPitch = 0.7F;
            }
            }
    }

    private float shake;
    public float canopyF;
    private boolean tiltCanopyOpened;
    private boolean sideWindowOpened;
    public boolean sideWindow;
    public boolean bHasBlister;
    CockpitBF_109E pit;
}
