package com.maddox.il2.objects.air;

import com.maddox.JGP.Tuple3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.objects.Wreckage;
import com.maddox.il2.objects.weapons.BombSC50;
import com.maddox.il2.objects.weapons.BombSC250;
import com.maddox.rts.Property;

public class BF_109E3 extends BF_109Ex
{

    public BF_109E3()
    {
        fMaxKMHSpeedForOpenCanopy = 250F;
        bHasBlister = true;
    }

    public void update(float f)
    {
        afterburnerhud();
        super.update(f);
        if((double)((FlightModelMain) (super.FM)).CT.getCockpitDoor() > 0.20000000000000001D && bHasBlister && super.FM.getSpeedKMH() > fMaxKMHSpeedForOpenCanopy && hierMesh().chunkFindCheck("Blister1_D0") != -1)
        {
            try
            {
                if(this == World.getPlayerAircraft())
                    ((CockpitBF_109E3)Main3D.cur3D().cockpitCur).removeCanopy();
            }
            catch(Exception exception) { }
            hierMesh().hideSubTrees("Blister1_D0");
            Wreckage wreckage = new Wreckage(this, hierMesh().chunkFind("Blister1_D0"));
            wreckage.collide(true);
            Vector3d vector3d = new Vector3d();
            vector3d.set(((FlightModelMain) (super.FM)).Vwld);
            wreckage.setSpeed(vector3d);
            bHasBlister = false;
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx += 0.04F;
            super.FM.setGCenter(-0.0F);
        }
        if(super.FM.isPlayers())
            if(!Main3D.cur3D().isViewOutside())
                hierMesh().chunkVisible("CF_D0", false);
            else
                hierMesh().chunkVisible("CF_D0", true);
        if(super.FM.isPlayers())
        {
            if(!Main3D.cur3D().isViewOutside())
                hierMesh().chunkVisible("CF_D1", false);
            hierMesh().chunkVisible("CF_D2", false);
            hierMesh().chunkVisible("CF_D3", false);
        }
        if(super.FM.isPlayers())
        {
            if(!Main3D.cur3D().isViewOutside())
                hierMesh().chunkVisible("Blister1_D0", false);
            else
            if(bHasBlister)
                hierMesh().chunkVisible("Blister1_D0", true);
            com.maddox.JGP.Point3d point3d = ((Actor) (World.getPlayerAircraft())).pos.getAbsPoint();
            if(((Tuple3d) (point3d)).z - World.land().HQ(((Tuple3d) (point3d)).x, ((Tuple3d) (point3d)).y) < 0.01D)
                hierMesh().chunkVisible("CF_D0", true);
            if(((FlightModelMain) (super.FM)).AS.bIsAboutToBailout)
                hierMesh().chunkVisible("Blister1_D0", false);
        }
        if(super.FM.isPlayers())
        {
            if(!Main3D.cur3D().isViewOutside())
            {
                hierMesh().chunkVisible("Blister1_D0", false);
                hierMesh().chunkVisible("WindowL1_D0", false);
                hierMesh().chunkVisible("WindowR1_D0", false);
            } else
            if(bHasBlister)
            {
                hierMesh().chunkVisible("Blister1_D0", true);
                hierMesh().chunkVisible("WindowL1_D0", true);
                hierMesh().chunkVisible("WindowR1_D0", true);
            }
            if(((FlightModelMain) (super.FM)).AS.bIsAboutToBailout)
            {
                hierMesh().chunkVisible("Blister1_D0", false);
                hierMesh().chunkVisible("WindowL1_D0", false);
                hierMesh().chunkVisible("WindowR1_D0", false);
            }
        }
    }

    public void onAircraftLoaded()
    {
        super.onAircraftLoaded();
        Object aobj[] = super.pos.getBaseAttached();
        if(aobj != null)
        {
            for(int i = 0; i < aobj.length; i++)
                if(aobj[i] instanceof BombSC50)
                {
                    hierMesh().chunkVisible("ETC50", true);
                }
        }
        if(aobj != null)
        {
            for(int i = 0; i < aobj.length; i++)
                if(aobj[i] instanceof BombSC250)
                {
                    hierMesh().chunkVisible("Rack", true);
                }
        }
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("Hochleistung inbegriffen!");
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private float fMaxKMHSpeedForOpenCanopy;
    public boolean bHasBlister;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.BF_109E3.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Bf-109E-3");
        Property.set(class1, "meshName", "3DO/Plane/Bf-109E-3/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar01());
        Property.set(class1, "yearService", 1939F);
        Property.set(class1, "yearExpired", 1942F);
        Property.set(class1, "FlightModel", "FlightModels/Bf-109E-3.fmd:Bf");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitBF_109E3.class
        });
        Property.set(class1, "LOSElevation", 0.74985F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 1, 1, 1, 9, 3, 3, 3, 3, 
            3, 9
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_CANNON02", "_CANNON03", "_ExternalDev01", "_ExternalBomb01", "_ExternalBomb02", "_ExternalBomb03", "_ExternalBomb04", 
            "_ExternalBomb05", "_ExternalDev02"
        });
/*         String as[] = new String[12];
        as[0] = "MGunMG17si 1000";
        as[1] = "MGunMG17si 1000";
        as[3] = "MGunMGFFs 60";
        as[4] = "MGunMGFFs 60";
        AircraftLH.XweaponsRegister(class1, "default", as);
        String as1[] = new String[12];
        as1[0] = "MGunMG17si 1000";
        as1[1] = "MGunMG17si 1000";
        as1[2] = "MGunMGFFki 60";
        as1[3] = "MGunMGFFs 60";
        as1[4] = "MGunMGFFs 60";
        AircraftLH.XweaponsRegister(class1, "1xMGFF", as1);
        String as2[] = new String[12];
        as2[0] = "MGunMG17si 1000";
        as2[1] = "MGunMG17si 1000";
        as2[3] = "MGunMGFFs 60";
        as2[4] = "MGunMGFFs 60";
        as2[6] = "BombGunSC250 1";
        AircraftLH.XweaponsRegister(class1, "1sc250", as2);
        String as3[] = new String[12];
        as3[0] = "MGunMG17si 1000";
        as3[1] = "MGunMG17si 1000";
        as3[3] = "MGunMGFFs 60";
        as3[4] = "MGunMGFFs 60";
        as3[7] = "BombGunSC50 1";
        as3[8] = "BombGunSC50 1";
        as3[9] = "BombGunSC50 1";
        as3[10] = "BombGunSC50 1";
        AircraftLH.XweaponsRegister(class1, "4sc50", as3);
        String as4[] = new String[12];
        as4[0] = "MGunMG17si 1000";
        as4[1] = "MGunMG17si 1000";
        as4[3] = "MGunMGFFs 60";
        as4[4] = "MGunMGFFs 60";
        as4[11] = "PylonRECO1BF109 1";
        AircraftLH.XweaponsRegister(class1, "E5", as4);
        AircraftLH.XweaponsRegister(class1, "none", new String[12]); */
    }
}