package com.maddox.il2.objects.air;

import com.maddox.JGP.Tuple3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.*;
import com.maddox.il2.ai.Regiment;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.game.AircraftHotKeys;
import com.maddox.il2.objects.sounds.SndAircraft;
import com.maddox.il2.objects.Wreckage;
import com.maddox.rts.Property;

public class BF_109G10FABIAN extends BF_109Gx
    implements TypeBNZFighter, TypeAcePlane
{

    public BF_109G10FABIAN()
    {
        maxSpeedForOpeningCanopyRandomFactor = 1.0F;
        cockpitDoor_ = 0.0F;
        bHasBlister = true;
        maxSpeedForOpeningCanopyRandomFactor = World.Rnd().nextFloat(0.89F, 1.04F);
    }

    public void update(float f)
    {
        afterburnerhud();
        super.update(f);
        if(super.FM.getSpeed() > 5F)
        {
            hierMesh().chunkSetAngles("SlatL_D0", 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F), 0.0F);
            hierMesh().chunkSetAngles("SlatR_D0", 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F), 0.0F);
        }
        if(((FlightModelMain) (super.FM)).CT.getCockpitDoor() > 0.2F && bHasBlister && super.FM.getSpeedKMH() > 330F * maxSpeedForOpeningCanopyRandomFactor && hierMesh().chunkFindCheck("Blister1_D0") != -1)
        {
            try
            {
                if(this == World.getPlayerAircraft())
                    ((CockpitBF_109G10)Main3D.cur3D().cockpitCur).removeCanopy();
            }
            catch(Exception exception) { }
            playSound("aircraft.arrach", true);
            hierMesh().hideSubTrees("Blister1_D0");
            Wreckage wreckage = new Wreckage(this, hierMesh().chunkFind("Blister1_D0"));
            wreckage.collide(true);
            Vector3d vector3d = new Vector3d();
            vector3d.set(((FlightModelMain) (super.FM)).Vwld);
            wreckage.setSpeed(vector3d);
            bHasBlister = false;
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx += 0.04F;
            super.FM.setGCenter(-0.0F);
        }
        if(super.FM.getSpeedKMH() > 280F && bHasBlister && ((FlightModelMain) (super.FM)).CT.cockpitDoorControl > 0.1F && ((FlightModelMain) (super.FM)).CT.getCockpitDoor() < 0.99F)
        {
            ((FlightModelMain) (super.FM)).CT.cockpitDoorControl = 0.0F;
            ((FlightModelMain) (super.FM)).AS.setCockpitDoor(((Interpolate) (super.FM)).actor, 0);
            float f1 = ((FlightModelMain) (super.FM)).CT.getCockpitDoor();
            if(Math.abs(cockpitDoor_ - f1) > 0.05F)
                moveCockpitDoor(cockpitDoor_ = f1);
            HUD.log("CockpitDoorCLS");
        }
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("Sonder hochleistung MW 50 inbegriffen!");
    }

    public static String getSkinPrefix(String s, Regiment regiment)
    {
        return "fab_";				   
    }

    protected void nextDMGLevel(String s, int i, Actor actor)
    {
        super.nextDMGLevel(s, i, actor);
        if(super.FM.isPlayers())
            bChangedPit = true;
    }
    
    protected void nextCUTLevel(String s, int i, Actor actor)
    {
        super.nextCUTLevel(s, i, actor);
        if(super.FM.isPlayers())
            bChangedPit = true;
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    public float cockpitDoor_;
    private static final float MAX_SPEED_KMH_FOR_OPENING_CANOPY = 280F;
    private static final float MAX_SPEED_KMH_FOR_KEEPING_CANOPY = 330F;
    private float maxSpeedForOpeningCanopyRandomFactor;
    public static boolean bChangedPit = false;
    public boolean bHasBlister;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.BF_109G10FABIAN.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "BF-109G-10-FABIAN");
        Property.set(class1, "meshName", "3DO/Plane/Bf-109G-10/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeSpecial());
        Property.set(class1, "yearService", 1944F);
        Property.set(class1, "yearExpired", 1946F);
        Property.set(class1, "FlightModel", "FlightModels/BF-109G-10FABIAN.fmd:Bf");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitBF_109G10.class
        });
        Property.set(class1, "LOSElevation", 0.7498F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 0, 1, 1, 1, 1, 1, 9, 9
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_CANNON01", "_CANNON02", "_CANNON03", "_CANNON04", "_CANNON05", "_ExternalDev02", "_ExternalDev03"
        });
/*         Aircraft.weaponsRegister(class1, "default", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMK108ki 65", null, null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "R4-MK108", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMK108ki 65", null, null, "MGunMK108kh 35", "MGunMK108kh 35", "PylonMk108", "PylonMk108"
        });
        Aircraft.weaponsRegister(class1, "R6-151-20", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", "MGunMK108ki 65", null, "MGunMG15120kh 140 ", "MGunMG15120kh 140", null, null, "PylonMG15120", "PylonMG15120"
        });
        Aircraft.weaponsRegister(class1, "none", new String[] {
            null, null, null, null, null, null, null, null, null, null
        }); */
    }
}