package com.maddox.il2.objects.air;

import com.maddox.JGP.Tuple3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.Regiment;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.fm.FlightModelMain;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.objects.sounds.SndAircraft;
import com.maddox.il2.objects.Wreckage;
import com.maddox.rts.Property;

public class BF_109G6KOVACS extends BF_109Gx
    implements TypeBNZFighter, TypeAcePlane
{

    public BF_109G6KOVACS()
    {
        maxSpeedForOpeningCanopyRandomFactor = 1.0F;
        cockpitDoor_ = 0.0F;
        bHasBlister = true;
        maxSpeedForOpeningCanopyRandomFactor = World.Rnd().nextFloat(0.89F, 1.04F);
    }

    public void onAircraftLoaded()
    {
        super.onAircraftLoaded();
        FM.Skill = 3;
    }

    public static String getSkinPrefix(String s, Regiment regiment)
    {
        return "kov_";
    }

    public void update(float f)
    {
        afterburnerhud();
        super.update(f);
        if(super.FM.getSpeed() > 5F)
        {
            hierMesh().chunkSetAngles("SlatL_D0", 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F), 0.0F);
            hierMesh().chunkSetAngles("SlatR_D0", 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.5F), 0.0F);
        }
        if(((FlightModelMain) (super.FM)).CT.getCockpitDoor() > 0.2F && bHasBlister && super.FM.getSpeedKMH() > 330F * maxSpeedForOpeningCanopyRandomFactor && hierMesh().chunkFindCheck("Blister1_D0") != -1)
        {
            try
            {
                if(this == World.getPlayerAircraft())
                    ((CockpitBF_109G6)Main3D.cur3D().cockpitCur).removeCanopy();
            }
            catch(Exception exception) { }
            playSound("aircraft.arrach", true);
            hierMesh().hideSubTrees("Blister1_D0");
            Wreckage wreckage = new Wreckage(this, hierMesh().chunkFind("Blister1_D0"));
            wreckage.collide(true);
            Vector3d vector3d = new Vector3d();
            vector3d.set(((FlightModelMain) (super.FM)).Vwld);
            wreckage.setSpeed(vector3d);
            bHasBlister = false;
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx += 0.04F;
            super.FM.setGCenter(-0.0F);
        }
        if(super.FM.getSpeedKMH() > 280F && bHasBlister && ((FlightModelMain) (super.FM)).CT.cockpitDoorControl > 0.1F && ((FlightModelMain) (super.FM)).CT.getCockpitDoor() < 0.99F)
        {
            ((FlightModelMain) (super.FM)).CT.cockpitDoorControl = 0.0F;
            ((FlightModelMain) (super.FM)).AS.setCockpitDoor(((Interpolate) (super.FM)).actor, 0);
            float f1 = ((FlightModelMain) (super.FM)).CT.getCockpitDoor();
            if(Math.abs(cockpitDoor_ - f1) > 0.05F)
                moveCockpitDoor(cockpitDoor_ = f1);
            HUD.log("CockpitDoorCLS");
        }
    }
    
    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("Hochleistung inbegriffen!");
    }

    protected void nextDMGLevel(String s, int i, Actor actor)
    {
        super.nextDMGLevel(s, i, actor);
        if(super.FM.isPlayers())
            bChangedPit = true;
    }
    
    protected void nextCUTLevel(String s, int i, Actor actor)
    {
        super.nextCUTLevel(s, i, actor);
        if(super.FM.isPlayers())
            bChangedPit = true;
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    public float cockpitDoor_;
    private static final float MAX_SPEED_KMH_FOR_OPENING_CANOPY = 280F;
    private static final float MAX_SPEED_KMH_FOR_KEEPING_CANOPY = 330F;
    private float maxSpeedForOpeningCanopyRandomFactor;
    public boolean bHasBlister;
    public static boolean bChangedPit = false;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.BF_109G6KOVACS.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Bf-109G-6-KOVACS");
        Property.set(class1, "meshName", "3do/plane/Bf-109G-6Early/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeSpecial());
        Property.set(class1, "FlightModel", "FlightModels/BF-109G-6EARLY-HARTMANN.fmd:Bf");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitBF_109G6.class
        });
        Property.set(class1, "LOSElevation", 0.7498F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 0, 1, 1, 1, 1, 1, 9, 9, 
            9, 9, 3, 3, 3, 3, 3
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_CANNON01", "_CANNON02", "_CANNON03", "_CANNON04", "_CANNON05", "_ExternalDev01", "_ExternalDev01", 
            "_ExternalDev02", "_ExternalDev03", "_ExternalBomb01", "_ExternalBomb02", "_ExternalBomb03", "_ExternalBomb04", "_ExternalBomb05"
        });
/*         Aircraft.weaponsRegister(class1, "default", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMG15120MGki 200", null, null, null, null, null, null, 
            null, null, null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "U3-MK108", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMK108ki 65", null, null, null, null, null, null, 
            null, null, null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "R1-SC250", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMG15120MGki 200", null, null, null, null, "PylonETC900", null, 
            null, null, "BombGunSC250 1", null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "R1-SC500", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMG15120MGki 200", null, null, null, null, "PylonETC900", null, 
            null, null, "BombGunSC500 1", null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "R2-SC50", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMG15120MGki 200", null, null, null, null, "PylonETC50Bf109", null, 
            null, null, null, "BombGunSC50 1", "BombGunSC50 1", "BombGunSC50 1", "BombGunSC50 1"
        });
        Aircraft.weaponsRegister(class1, "R3-DROPTANK", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMG15120MGki 200", null, null, null, null, "PylonETC900", "FuelTankGun_Type_D", 
            null, null, null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "R5-MK108", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", null, "MGunMG15120MGki 200", null, null, "MGunMK108k 35", "MGunMK108k 35", null, null, 
            "PylonMk108", "PylonMk108", null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "R6-MG151-20", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", "MGunMG15120MGki 200", null, "MGunMG15120MGk 135", "MGunMG15120MGk 135", null, null, null, null, 
            "PylonMG15120", "PylonMG15120", null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "U3R6-MG151-20", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", "MGunMK108ki 65", null, "MGunMG15120MGk 135", "MGunMG15120MGk 135", null, null, null, null, 
            "PylonMG15120", "PylonMG15120", null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "R3R6-MG151-20", new String[] {
            "MGunMG131si 300", "MGunMG131si 300", "MGunMG15120MGki 200", null, "MGunMG15120MGk 135", "MGunMG15120MGk 135", null, null, "PylonETC900", "FuelTankGun_Type_D", 
            "PylonMG15120", "PylonMG15120", null, null, null, null, null
        });
        Aircraft.weaponsRegister(class1, "none", new String[] {
            null, null, null, null, null, null, null, null, null, null, 
            null, null, null, null, null, null, null
        }); */
    }
}