package com.maddox.il2.objects.air;

import com.maddox.JGP.Tuple3d;
import com.maddox.JGP.Vector3d;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Main3D;
import com.maddox.il2.objects.Wreckage;
import com.maddox.il2.objects.weapons.BombSC50;
import com.maddox.rts.Property;

public class BF_109T_2 extends BF_109Ex
{

    public BF_109T_2()
    {
        fMaxKMHSpeedForOpenCanopy = 250F;
        bHasBlister = true;
    }

    public void update(float f)
    {
        afterburnerhud();
        super.update(f);
        if((double)((FlightModelMain) (super.FM)).CT.getCockpitDoor() > 0.20000000000000001D && bHasBlister && super.FM.getSpeedKMH() > fMaxKMHSpeedForOpenCanopy && hierMesh().chunkFindCheck("Blister1_D0") != -1)
        {
            try
            {
                if(this == World.getPlayerAircraft())
                    ((CockpitBF_109E)Main3D.cur3D().cockpitCur).removeCanopy();
            }
            catch(Exception exception) { }
            hierMesh().hideSubTrees("Blister1_D0");
            Wreckage wreckage = new Wreckage(this, hierMesh().chunkFind("Blister1_D0"));
            wreckage.collide(true);
            Vector3d vector3d = new Vector3d();
            vector3d.set(((FlightModelMain) (super.FM)).Vwld);
            wreckage.setSpeed(vector3d);
            bHasBlister = false;
            ((FlightModelMain) (super.FM)).CT.bHasCockpitDoorControl = false;
            ((FlightModelMain) (super.FM)).Sq.dragProducedCx += 0.04F;
            super.FM.setGCenter(-0.0F);
        }
        if(super.FM.isPlayers())
            if(!Main3D.cur3D().isViewOutside())
                hierMesh().chunkVisible("CF_D0", false);
            else
                hierMesh().chunkVisible("CF_D0", true);
        if(super.FM.isPlayers())
        {
            if(!Main3D.cur3D().isViewOutside())
                hierMesh().chunkVisible("CF_D1", false);
            hierMesh().chunkVisible("CF_D2", false);
            hierMesh().chunkVisible("CF_D3", false);
        }
        if(super.FM.isPlayers())
        {
            if(!Main3D.cur3D().isViewOutside())
                hierMesh().chunkVisible("Blister1_D0", false);
            else
            if(bHasBlister)
                hierMesh().chunkVisible("Blister1_D0", true);
            com.maddox.JGP.Point3d point3d = ((Actor) (World.getPlayerAircraft())).pos.getAbsPoint();
            if(((Tuple3d) (point3d)).z - World.land().HQ(((Tuple3d) (point3d)).x, ((Tuple3d) (point3d)).y) < 0.01D)
                hierMesh().chunkVisible("CF_D0", true);
            if(((FlightModelMain) (super.FM)).AS.bIsAboutToBailout)
                hierMesh().chunkVisible("Blister1_D0", false);
        }
        if(super.FM.isPlayers())
        {
            if(!Main3D.cur3D().isViewOutside())
            {
                hierMesh().chunkVisible("Blister1_D0", false);
            } else
            if(bHasBlister)
            {
                hierMesh().chunkVisible("Blister1_D0", true);
            }
            if(((FlightModelMain) (super.FM)).AS.bIsAboutToBailout)
            {
                hierMesh().chunkVisible("Blister1_D0", false);
            }
        }
    }

    public void onAircraftLoaded()
    {
        super.onAircraftLoaded();
        Object aobj[] = super.pos.getBaseAttached();
        if(aobj != null)
        {
            for(int i = 0; i < aobj.length; i++)
                if(aobj[i] instanceof BombSC50)
                {
                    hierMesh().chunkVisible("Rack", false);
                    hierMesh().chunkVisible("ETC50", true);
                }
        }
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("Hochleistung inbegriffen!");
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private float fMaxKMHSpeedForOpenCanopy;
    public boolean bHasBlister;
    protected float arrestor;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.BF_109T_2.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "Bf-109T-2");
        Property.set(class1, "meshName", "3DO/Plane/Bf-109T-1/hierT2.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar02());
        Property.set(class1, "yearService", 1941F);
        Property.set(class1, "yearExpired", 1944F);
        Property.set(class1, "FlightModel", "FlightModels/Bf-109T-2.fmd:Bf");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitBF_109E.class
        });
        Property.set(class1, "LOSElevation", 0.74985F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 0, 1, 1, 3, 3, 3, 3, 3, 9
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_MGUN02", "_CANNON01", "_CANNON02", "_ExternalBomb01", "_ExternalBomb02", "_ExternalBomb03", "_ExternalBomb04", "_ExternalBomb05", "_ExternalDev01"
        });
/*         String as[] = new String[10];
        as[0] = "MGunMG17si 1000";
        as[1] = "MGunMG17si 1000";
        as[2] = "MGunMGFFk 60";
        as[3] = "MGunMGFFk 60";
        AircraftLH.XweaponsRegister(class1, "default", as);
        String as1[] = new String[10];
        as1[0] = "MGunMG17si 1000";
        as1[1] = "MGunMG17si 1000";
        as1[2] = "MGunMGFFk 60";
        as1[3] = "MGunMGFFk 60";
        as1[5] = "BombGunSC50 1";
        as1[6] = "BombGunSC50 1";
        as1[7] = "BombGunSC50 1";
        as1[8] = "BombGunSC50 1";
        AircraftLH.XweaponsRegister(class1, "4xSC50", as1);
        String as2[] = new String[10];
        as2[0] = "MGunMG17si 1000";
        as2[1] = "MGunMG17si 1000";
        as2[2] = "MGunMGFFk 60";
        as2[3] = "MGunMGFFk 60";
        as2[4] = "BombGunSC250 1";
        AircraftLH.XweaponsRegister(class1, "1xSC250", as2);
        String as3[] = new String[10];
        as3[0] = "MGunMG17si 1000";
        as3[1] = "MGunMG17si 1000";
        as3[2] = "MGunMGFFk 60";
        as3[3] = "MGunMGFFk 60";
        as3[9] = "FuelTankGun_Type_D 1";
        AircraftLH.XweaponsRegister(class1, "1xDROPTANK", as3);
        AircraftLH.XweaponsRegister(class1, "none", new String[10]); */
    }
}