package com.maddox.il2.objects.air;

import com.maddox.JGP.*;
import com.maddox.il2.ai.AnglesFork;
import com.maddox.il2.ai.World;
import com.maddox.il2.engine.*;
import com.maddox.il2.engine.hotkey.HookPilot;
import com.maddox.il2.fm.*;
import com.maddox.rts.*;
import com.maddox.util.HashMapExt;

public class CockpitBF_109Bx extends CockpitPilot
{
    class Interpolater extends InterpolateRef
    {

        public boolean tick()
        {
            if(ac != null && ac.bChangedPit)
                ac.bChangedPit = false;
            if(bNeedSetUp)
            {
                reflectPlaneMats();
                bNeedSetUp = false;
            }
            setTmp = setOld;
            setOld = setNew;
            setNew = setTmp;
            setNew.altimeter = fm.getAltitude();
            if(cockpitDimControl)
            {
                if(setNew.dimPosition > 0.0F)
                    setNew.dimPosition = setOld.dimPosition - 0.05F;
            } else
            if(setNew.dimPosition < 1.0F)
                setNew.dimPosition = setOld.dimPosition + 0.05F;
            setNew.throttle = (10F * setOld.throttle + ((FlightModelMain) (fm)).CT.PowerControl) / 11F;
            setNew.mix = (8F * setOld.mix + ((FlightModelMain) (fm)).EI.engines[0].getControlMix()) / 9F;
            float f = waypointAzimuth();
            if(useRealisticNavigationInstruments())
            {
                setNew.waypointAzimuth.setDeg(f - 90F);
                setOld.waypointAzimuth.setDeg(f - 90F);
            } else
            {
                setNew.waypointAzimuth.setDeg(setOld.waypointAzimuth.getDeg(0.1F), f - setOld.azimuth.getDeg(1.0F));
            }
            setNew.azimuth.setDeg(setOld.azimuth.getDeg(1.0F), ((FlightModelMain) (fm)).Or.azimut());
            w.set(fm.getW());
            ((FlightModelMain) (fm)).Or.transform(w);
            setNew.turn = (12F * setOld.turn + ((Tuple3f) (w)).z) / 13F;
            buzzerFX(((FlightModelMain) (fm)).CT.getGear() < 0.999999F && ((FlightModelMain) (fm)).CT.getFlap() > 0.0F);
            return true;
        }

        Interpolater()
        {
        }
    }

    private class Variables
    {

        float altimeter;
        float throttle;
        float dimPosition;
        AnglesFork azimuth;
        AnglesFork waypointAzimuth;
        float turn;
        float mix;

        private Variables()
        {
            azimuth = new AnglesFork();
            waypointAzimuth = new AnglesFork();
        }

        Variables(Variables variables)
        {
            this();
        }
    }

    protected float waypointAzimuth()
    {
        return super.waypointAzimuthInvertMinus(30F);
    }

    protected void reflectPlaneMats()
    {
        HierMesh hiermesh = aircraft().hierMesh();
        com.maddox.il2.engine.Mat mat = hiermesh.material(hiermesh.materialFind("Gloss1D0o"));
        super.mesh.materialReplace("Gloss1D0o", mat);
    }

    public CockpitBF_109Bx()
    {
        super("3DO/Cockpit/Bf-109E-7/BCDhier.him", "bf109");
        hasCanopy = true;
        setOld = new Variables(null);
        setNew = new Variables(null);
        pictAiler = 0.0F;
        pictElev = 0.0F;
        pictManifold = 0.0F;
        bNeedSetUp = true;
        isSlideRight = false;
        ac = null;
        w = new Vector3f();
        setNew.dimPosition = 1.0F;
        HookNamed hooknamed = new HookNamed(super.mesh, "LAMPHOOK1");
        Loc loc = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        hooknamed.computePos(this, new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F), loc);
        light1 = new LightPointActor(new LightPoint(), loc.getPoint());
        light1.light.setColor(227F, 65F, 33F);
        light1.light.setEmit(0.0F, 0.0F);
        super.pos.base().draw.lightMap().put("LAMPHOOK1", light1);
        hooknamed = new HookNamed(super.mesh, "LAMPHOOK2");
        loc = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        hooknamed.computePos(this, new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F), loc);
        light2 = new LightPointActor(new LightPoint(), loc.getPoint());
        light2.light.setColor(227F, 65F, 33F);
        light2.light.setEmit(0.0F, 0.0F);
        super.pos.base().draw.lightMap().put("LAMPHOOK2", light2);
        super.cockpitNightMats = (new String[] {
            "ZClocks1", "ZClocks1DMG", "ZClocks2", "ZClocks3", "FW190A4Compass", "oxigen"
        });
        setNightMats(false);
        interpPut(new Interpolater(), null, Time.current(), null);
        loadBuzzerFX();
        ac = (BF_109Bx)aircraft();
        ac.registerPit(this);
        printCompassHeading = true;
        limits6DoF = (new float[] {
            0.7F, 0.055F, -0.07F, 0.11F, 0.07F, -0.13F, 0.03F, -0.03F
        });
    }

    public void removeCanopy()
    {
        hasCanopy = false;
        if(super.mesh.chunkFindCheck("Top") >= 0)
            super.mesh.chunkVisible("Top", false);
        super.mesh.chunkVisible("WindowL+", false);
        super.mesh.chunkVisible("TopLever", false);
        super.mesh.chunkVisible("WindowR", false);
        super.mesh.chunkVisible("Z_Holes1_D2", false);
        super.mesh.chunkVisible("Z_Holes2_D2", false);
        if(super.mesh.chunkFindCheck("TopE1") >= 0)
            super.mesh.chunkVisible("TopE1", false);
        doToggleUp(false);
    }

    public void reflectWorldToInstruments(float f)
    {
        if(ac.tiltCanopyOpened)
        {
            Aircraft.xyz[0] = ((FlightModelMain) (super.fm)).CT.getCockpitDoor() * 0.33F;
            super.mesh.chunkSetAngles("TopLever", 0.0F, cvt(Aircraft.xyz[0], 0.0F, 0.05F, 0.0F, 50F), 0.0F);
            super.mesh.chunkSetAngles("Top", 0.0F, cvt(((FlightModelMain) (super.fm)).CT.getCockpitDoor(), 0.1F, 1.0F, 0.0F, 90F), 0.0F);
        } else
        {
            resetYPRmodifier();
            super.mesh.chunkSetAngles("TopLever", 0.0F, 0.0F, 0.0F);
            super.mesh.chunkSetAngles("Top", 0.0F, 0.0F, 0.0F);
            Cockpit.xyz[1] = cvt(((FlightModelMain) (super.fm)).CT.getCockpitDoor(), 0.01F, 0.99F, 0.0F, 0.24F);
            if(isSlideRight)
                super.mesh.chunkSetLocate("WindowR", Cockpit.xyz, Cockpit.ypr);
            else
                super.mesh.chunkSetLocate("WindowL", Cockpit.xyz, Cockpit.ypr);
        }
        super.mesh.chunkSetAngles("Z_Altimeter1", cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 3600F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Altimeter2", cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 180F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_ReviTinter", cvt(interp(setNew.dimPosition, setOld.dimPosition, f), 0.0F, 1.0F, 0.0F, -30F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_ReviTint", cvt(interp(setNew.dimPosition, setOld.dimPosition, f), 0.0F, 1.0F, 0.0F, 40F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_ATA1", 15.5F + cvt(pictManifold = 0.75F * pictManifold + 0.25F * ((FlightModelMain) (super.fm)).EI.engines[0].getManifoldPressure(), 0.6F, 1.8F, 0.0F, 327F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Speedometer1", floatindex(cvt(Pitot.Indicator((float)((Tuple3d) (((FlightModelMain) (super.fm)).Loc)).z, super.fm.getSpeedKMH()), 0.0F, 800F, 0.0F, 16F), speedometerScale), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_RPM1", floatindex(cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 4000F, 0.0F, 8F), rpmScale), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_FuelQuantity1", -44.5F + floatindex(cvt(((FlightModelMain) (super.fm)).M.fuel / 0.72F, 0.0F, 400F, 0.0F, 8F), fuelScale), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Iengtemprad1", cvt(((FlightModelMain) (super.fm)).EI.engines[0].tOilOut, 0.0F, 160F, 0.0F, 58.5F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_EngTemp1", cvt(((FlightModelMain) (super.fm)).EI.engines[0].tWaterOut, 0.0F, 120F, 0.0F, 58.5F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_FuelPress1", cvt(((FlightModelMain) (super.fm)).M.fuel <= 1.0F ? 0.0F : 0.26F, 0.0F, 3F, 0.0F, 135F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_OilPress1", cvt(1.0F + 0.05F * ((FlightModelMain) (super.fm)).EI.engines[0].tOilOut, 0.0F, 15F, 0.0F, 135F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_TurnBank1", cvt(setNew.turn, -0.23562F, 0.23562F, 30F, -30F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_TurnBank2", cvt(getBall(6D), -6F, 6F, -7F, 7F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Compass1", 0.0F, -setNew.azimuth.getDeg(f), 0.0F);
        super.mesh.chunkSetAngles("Z_Azimuth1", setNew.waypointAzimuth.getDeg(f * 0.1F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_PropPitch1", 270F - (float)Math.toDegrees(((FlightModelMain) (super.fm)).EI.engines[0].getPropPhi() - ((FlightModelMain) (super.fm)).EI.engines[0].getPropPhiMin()) * 60F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_PropPitch2", 105F - (float)Math.toDegrees(((FlightModelMain) (super.fm)).EI.engines[0].getPropPhi() - ((FlightModelMain) (super.fm)).EI.engines[0].getPropPhiMin()) * 5F, 0.0F, 0.0F);
        super.mesh.chunkVisible("Z_FuelRed1", ((FlightModelMain) (super.fm)).M.fuel < 36F);
        super.mesh.chunkVisible("Z_GearLRed1", ((FlightModelMain) (super.fm)).CT.getGear() == 0.0F);
        super.mesh.chunkVisible("Z_GearRRed1", ((FlightModelMain) (super.fm)).CT.getGear() == 0.0F);
        super.mesh.chunkVisible("Z_GearLGreen1", ((FlightModelMain) (super.fm)).CT.getGear() == 1.0F);
        super.mesh.chunkVisible("Z_GearRGreen1", ((FlightModelMain) (super.fm)).CT.getGear() == 1.0F);
        super.mesh.chunkSetAngles("Z_Hour1", cvt(World.getTimeofDay(), 0.0F, 24F, 0.0F, 720F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Minute1", cvt(World.getTimeofDay() % 1.0F, 0.0F, 1.0F, 0.0F, 360F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Second1", cvt(((World.getTimeofDay() % 1.0F) * 60F) % 1.0F, 0.0F, 1.0F, 0.0F, 360F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Column", (pictAiler = 0.85F * pictAiler + 0.15F * ((FlightModelMain) (super.fm)).CT.AileronControl) * 15F, 0.0F, (pictElev = 0.85F * pictElev + 0.15F * ((FlightModelMain) (super.fm)).CT.ElevatorControl) * 10F);
        super.mesh.chunkSetAngles("Z_PedalStrut", ((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_PedalStrut2", ((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_LeftPedal", -((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_RightPedal", -((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Throttle", interp(setNew.throttle, setOld.throttle, f) * 57.72727F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Throttle_D1", interp(setNew.throttle, setOld.throttle, f) * 27F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Throttle_tube", -interp(setNew.throttle, setOld.throttle, f) * 57.72727F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Mix", interp(setNew.mix, setOld.mix, f) * 70F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Mix_tros", -interp(setNew.mix, setOld.mix, f) * 70F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_MagnetoSwitch", -45F + 28.333F * (float)((FlightModelMain) (super.fm)).EI.engines[0].getControlMagnetos(), 0.0F, 0.0F);
    }

    public void doToggleUp(boolean flag)
    {
        if(ac.tiltCanopyOpened)
            super.doToggleUp(flag);
    }

    public void toggleDim()
    {
        super.cockpitDimControl = !super.cockpitDimControl;
    }

    public void toggleLight()
    {
        super.cockpitLightControl = !super.cockpitLightControl;
        if(super.cockpitLightControl)
        {
            light1.light.setEmit(0.005F, 0.5F);
            light2.light.setEmit(0.005F, 0.5F);
            setNightMats(true);
        } else
        {
            light1.light.setEmit(0.0F, 0.0F);
            light2.light.setEmit(0.0F, 0.0F);
            setNightMats(false);
        }
    }

    public void reflectCockpitState()
    {
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 2) != 0)
        {
            super.mesh.chunkVisible("Z_Armor_D1", true);
            super.mesh.chunkVisible("Z_HullDamage1", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 1) != 0)
        {
            super.mesh.chunkVisible("Z_Holes1_D1", true);
            super.mesh.chunkVisible("Z_Holes2_D1", true);
            super.mesh.chunkVisible("Z_Holes3_D1", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x40) != 0)
        {
            super.mesh.chunkVisible("Z_HullDamage1", true);
            super.mesh.chunkVisible("Z_HullDamage2", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 4) != 0)
            super.mesh.chunkVisible("Z_HullDamage4", true);
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 8) != 0)
        {
            super.mesh.chunkVisible("Z_Throttle", false);
            super.mesh.chunkVisible("Z_Throttle_tube", false);
            super.mesh.chunkVisible("Z_Throttle_D1", true);
            super.mesh.chunkVisible("Z_Throttle_TD1", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x80) != 0)
        {
            super.mesh.chunkVisible("Z_OilSplats_D1", true);
            super.mesh.chunkVisible("Z_OilSplats1_D2", true);
            super.mesh.chunkVisible("Z_OilSplats2_D2", true);
            super.mesh.chunkVisible("Z_OilSplats3_D2", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x10) != 0)
            super.mesh.chunkVisible("Z_HullDamage3", true);
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x20) != 0)
        {
            super.mesh.chunkVisible("Z_HullDamage2", true);
            super.mesh.chunkVisible("Z_Holes1_D2", true);
            super.mesh.chunkVisible("Z_Holes2_D2", true);
            super.mesh.chunkVisible("Z_Holes3_D2", true);
        }
    }

    protected boolean doFocusEnter()
    {
        if(super.doFocusEnter())
        {
            aircraft().hierMesh().chunkVisible("Blister1_D0", false);
            aircraft().hierMesh().chunkVisible("WindowL1_D0", false);
            aircraft().hierMesh().chunkVisible("WindowR1_D0", false);
            if(((FlightModelMain) (super.fm)).AS.bIsAboutToBailout)
                hasCanopy = false;
            return true;
        } else
        {
            return false;
        }
    }

    protected void doFocusLeave()
    {
        if(isFocused() && hasCanopy)
        {
            aircraft().hierMesh().chunkVisible("Blister1_D0", true);
            aircraft().hierMesh().chunkVisible("WindowL1_D0", true);
            aircraft().hierMesh().chunkVisible("WindowR1_D0", true);
            super.doFocusLeave();
        } else
        if(isFocused())
            super.doFocusLeave();
    }

    public boolean isViewRight()
    {
        Loc loc = new Loc();
        Loc loc1 = new Loc();
        HookPilot.current.computePos(this, loc, loc1);
        float f = loc1.getOrient().getYaw();
        if(f < 0.0F)
            isSlideRight = true;
        else
            isSlideRight = false;
        return isSlideRight;
    }

    boolean hasCanopy;
    private Variables setOld;
    private Variables setNew;
    private Variables setTmp;
    private LightPointActor light1;
    private LightPointActor light2;
    private float pictAiler;
    private float pictElev;
    private float pictManifold;
    private boolean bNeedSetUp;
    private boolean isSlideRight;
    BF_109Bx ac;
    public Vector3f w;
    private static final float speedometerScale[] = {
        0.0F, -12.33333F, 18.5F, 37F, 62.5F, 90F, 110.5F, 134F, 158.5F, 186F, 
        212.5F, 238.5F, 265F, 289.5F, 315F, 339.5F, 346F, 346F
    };
    private static final float rpmScale[] = {
        0.0F, 11.25F, 54F, 111F, 171.5F, 229.5F, 282.5F, 334F, 342.5F, 342.5F
    };
    private static final float fuelScale[] = {
        0.0F, 9F, 21F, 29.5F, 37F, 48F, 61.5F, 75.5F, 92F, 92F
    };

    static 
    {
        Property.set(CLASS.THIS(), "normZNs", new float[] {
            1.2F, 0.6F, 0.57F, 0.6F
        });
    }
}