package com.maddox.il2.objects.air;

import com.maddox.JGP.*;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.objects.weapons.Gun;
import com.maddox.rts.Property;
import com.maddox.rts.Time;
import com.maddox.util.HashMapExt;

public class CockpitBF_109E7 extends CockpitPilot
{
    class Interpolater extends InterpolateRef
    {

        public boolean tick()
        {
            setTmp = setOld;
            setOld = setNew;
            setNew = setTmp;
            setNew.altimeter = fm.getAltitude();
            if(!MagnetProtectDown)
            {
                if(setNew.stbyPosition2 > 0.0F)
                    setNew.stbyPosition2 = setOld.stbyPosition2 - 0.1F;
            } else
            if(setNew.stbyPosition2 < 1.0F)
                setNew.stbyPosition2 = setOld.stbyPosition2 + 0.1F;
            if(((FlightModelMain) (fm)).EI.engines[0].getStage() <= 0 || ((FlightModelMain) (fm)).EI.engines[0].getStage() >= 6)
            {
                if(setNew.stbyPosition3 > 0.0F)
                    setNew.stbyPosition3 = setOld.stbyPosition3 - 0.1F;
            } else
            if(setNew.stbyPosition3 < 1.0F)
                setNew.stbyPosition3 = setOld.stbyPosition3 + 0.1F;
            if(!MagnetProtectDown2)
            {
                if(setNew.stbyPosition6 > 0.0F)
                    setNew.stbyPosition6 = setOld.stbyPosition6 - 0.1F;
            } else
            if(setNew.stbyPosition6 < 1.0F)
                setNew.stbyPosition6 = setOld.stbyPosition6 + 0.1F;
            if(((FlightModelMain) (fm)).EI.engines[0].getStage() <= 0 || ((FlightModelMain) (fm)).EI.engines[0].getStage() >= 6)
            {
                if(setNew.stbyPosition7 > 0.0F)
                    setNew.stbyPosition7 = setOld.stbyPosition7 - 0.1F;
            } else
            if(setNew.stbyPosition7 < 1.0F)
                setNew.stbyPosition7 = setOld.stbyPosition7 + 0.1F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 0.2F)
            {
                if(setNew.stbyPosition8 > 0.0F)
                    setNew.stbyPosition8 = setOld.stbyPosition8 - 0.05F;
            } else
            if(setNew.stbyPosition8 < 1.0F)
                setNew.stbyPosition8 = setOld.stbyPosition8 + 0.05F;
            if(((FlightModelMain) (fm)).CT.GearControl == 1.0F)
            {
                if(setNew.stbyPosition9 > 0.0F)
                    setNew.stbyPosition9 = setOld.stbyPosition9 - 0.5F;
            } else
            if(setNew.stbyPosition9 < 1.0F)
                setNew.stbyPosition9 = setOld.stbyPosition9 + 0.5F;
            if(!FuelPress2)
            {
                if(setNew.stbyPosition11 > 0.0F)
                    setNew.stbyPosition11 = setOld.stbyPosition11 - 0.005F;
            } else
            if(setNew.stbyPosition11 < 1.0F)
                setNew.stbyPosition11 = setOld.stbyPosition11 + 0.005F;
            if(!((FlightModelMain) (fm)).CT.saveWeaponControl[1])
            {
                if(setNew.stbyPosition12 > 0.0F)
                    setNew.stbyPosition12 = setOld.stbyPosition12 - 0.05F;
            } else
            if(setNew.stbyPosition12 < 1.0F)
                setNew.stbyPosition12 = setOld.stbyPosition12 + 0.05F;
            if(!EjectCanop)
            {
                if(setNew.stbyPosition13 > 0.0F)
                    setNew.stbyPosition13 = setOld.stbyPosition13 - 0.1F;
            } else
            if(setNew.stbyPosition13 < 1.0F)
                setNew.stbyPosition13 = setOld.stbyPosition13 + 0.1F;
            if(!EjectCanop)
            {
                if(setNew.stbyPosition26 > 0.0F)
                    setNew.stbyPosition26 = setOld.stbyPosition26 - 0.1F;
            } else
            if(setNew.stbyPosition26 < 1.0F)
                setNew.stbyPosition26 = setOld.stbyPosition26 + 0.1F;
            if(!((FlightModelMain) (fm)).Gears.bTailwheelLocked)
            {
                if(setNew.stbyPosition27 > 0.0F)
                    setNew.stbyPosition27 = setOld.stbyPosition27 - 0.07F;
            } else
            if(setNew.stbyPosition27 < 1.0F)
                setNew.stbyPosition27 = setOld.stbyPosition27 + 0.07F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 0.4F)
            {
                if(setNew.stbyPosition28 > 0.0F)
                    setNew.stbyPosition28 = setOld.stbyPosition28 - 0.05F;
            } else
            if(setNew.stbyPosition28 < 1.0F)
                setNew.stbyPosition28 = setOld.stbyPosition28 + 0.05F;
            if(((FlightModelMain) (fm)).CT.cockpitDoorControl == 0.0F)
            {
                if(setNew.stbyPosition30 > 0.0F)
                    setNew.stbyPosition30 = setOld.stbyPosition30 - 0.022F;
            } else
            if(setNew.stbyPosition30 < 1.0F)
                setNew.stbyPosition30 = setOld.stbyPosition30 + 0.022F;
            if(!OilPress)
            {
                if(setNew.stbyPosition33 > 0.0F)
                    setNew.stbyPosition33 = setOld.stbyPosition33 - 0.005F;
            } else
            if(setNew.stbyPosition33 < 1.0F)
                setNew.stbyPosition33 = setOld.stbyPosition33 + 0.005F;
            if(!CanopyClosedState)
            {
                if(setNew.stbyPosition34 > 0.0F)
                    setNew.stbyPosition34 = setOld.stbyPosition34 - 0.05F;
            } else
            if(setNew.stbyPosition34 < 1.0F)
                setNew.stbyPosition34 = setOld.stbyPosition34 + 0.05F;
            if(!((FlightModelMain) (fm)).CT.getStepControlAuto())
            {
                if(setNew.stbyPosition35 > 0.0F)
                    setNew.stbyPosition35 = setOld.stbyPosition35 - 0.1F;
            } else
            if(setNew.stbyPosition35 < 1.0F)
                setNew.stbyPosition35 = setOld.stbyPosition35 + 0.1F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 0.6F)
            {
                if(setNew.stbyPosition36 > 0.0F)
                    setNew.stbyPosition36 = setOld.stbyPosition36 - 0.05F;
            } else
            if(setNew.stbyPosition36 < 1.0F)
                setNew.stbyPosition36 = setOld.stbyPosition36 + 0.05F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 0.8F)
            {
                if(setNew.stbyPosition37 > 0.0F)
                    setNew.stbyPosition37 = setOld.stbyPosition37 - 0.05F;
            } else
            if(setNew.stbyPosition37 < 1.0F)
                setNew.stbyPosition37 = setOld.stbyPosition37 + 0.05F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 1.0F)
            {
                if(setNew.stbyPosition38 > 0.0F)
                    setNew.stbyPosition38 = setOld.stbyPosition38 - 0.05F;
            } else
            if(setNew.stbyPosition38 < 1.0F)
                setNew.stbyPosition38 = setOld.stbyPosition38 + 0.05F;
            if(!cockpitLightControl)
            {
                if(setNew.stbyPosition40 > 0.0F)
                    setNew.stbyPosition40 = setOld.stbyPosition40 - 0.1F;
            } else
            if(setNew.stbyPosition40 < 1.0F)
                setNew.stbyPosition40 = setOld.stbyPosition40 + 0.1F;
            if(!((FlightModelMain) (fm)).AS.bNavLightsOn)
            {
                if(setNew.stbyPosition41 > 0.0F)
                    setNew.stbyPosition41 = setOld.stbyPosition41 - 0.1F;
            } else
            if(setNew.stbyPosition41 < 1.0F)
                setNew.stbyPosition41 = setOld.stbyPosition41 + 0.1F;
            if(!PitotOk)
            {
                if(setNew.stbyPosition45 > 0.0F)
                    setNew.stbyPosition45 = setOld.stbyPosition45 - 0.01F;
            } else
            if(setNew.stbyPosition45 < 1.0F)
                setNew.stbyPosition45 = setOld.stbyPosition45 + 0.01F;
            if(!cockpitLightControl)
            {
                if(setNew.stbyPosition46 > 0.0F)
                    setNew.stbyPosition46 = setOld.stbyPosition46 - 0.1F;
            } else
            if(setNew.stbyPosition46 < 1.0F)
                setNew.stbyPosition46 = setOld.stbyPosition46 + 0.1F;
            if(!((FlightModelMain) (fm)).AS.bNavLightsOn)
            {
                if(setNew.stbyPosition47 > 0.0F)
                    setNew.stbyPosition47 = setOld.stbyPosition47 - 0.1F;
            } else
            if(setNew.stbyPosition47 < 1.0F)
                setNew.stbyPosition47 = setOld.stbyPosition47 + 0.1F;
            if(!AccelerationState1)
            {
                if(setNew.stbyPosition52 > 0.0F)
                    setNew.stbyPosition52 = setOld.stbyPosition52 - 0.02F;
            } else
            if(setNew.stbyPosition52 < 1.0F)
                setNew.stbyPosition52 = setOld.stbyPosition52 + 0.02F;
            if(((FlightModelMain) (fm)).CT.GearControl == 1.0F)
            {
                if(setNew.stbyPosition57 > 0.0F)
                    setNew.stbyPosition57 = setOld.stbyPosition57 - 0.005F;
            } else
            if(setNew.stbyPosition57 < 1.0F)
                setNew.stbyPosition57 = setOld.stbyPosition57 + 0.005F;
            if(!GearUp1)
            {
                if(setNew.stbyPosition59 > 0.0F)
                    setNew.stbyPosition59 = setOld.stbyPosition59 - 0.5F;
            } else
            if(setNew.stbyPosition59 < 1.0F)
                setNew.stbyPosition59 = setOld.stbyPosition59 + 0.5F;
            if(!GearUp2)
            {
                if(setNew.stbyPosition60 > 0.0F)
                    setNew.stbyPosition60 = setOld.stbyPosition60 - 0.1F;
            } else
            if(setNew.stbyPosition60 < 1.0F)
                setNew.stbyPosition60 = setOld.stbyPosition60 + 0.1F;
            if(!GearDown1)
            {
                if(setNew.stbyPosition61 > 0.0F)
                    setNew.stbyPosition61 = setOld.stbyPosition61 - 0.5F;
            } else
            if(setNew.stbyPosition61 < 1.0F)
                setNew.stbyPosition61 = setOld.stbyPosition61 + 0.5F;
            if(!GearDown2)
            {
                if(setNew.stbyPosition62 > 0.0F)
                    setNew.stbyPosition62 = setOld.stbyPosition62 - 0.1F;
            } else
            if(setNew.stbyPosition62 < 1.0F)
                setNew.stbyPosition62 = setOld.stbyPosition62 + 0.1F;
            if(((FlightModelMain) (fm)).CT.cockpitDoorControl == 1.0F)
            {
                if(setNew.stbyPosition63 > 0.0F)
                    setNew.stbyPosition63 = setOld.stbyPosition63 - 0.022F;
            } else
            if(setNew.stbyPosition63 < 1.0F)
                setNew.stbyPosition63 = setOld.stbyPosition63 + 0.022F;
            if(!cockpitLightControl)
            {
                if(setNew.stbyPosition64 > 0.0F)
                    setNew.stbyPosition64 = setOld.stbyPosition64 - 0.05F;
            } else
            if(setNew.stbyPosition64 < 1.0F)
                setNew.stbyPosition64 = setOld.stbyPosition64 + 0.05F;
            if(hasBombs())
            {
                if(((FlightModelMain) (fm)).CT.BayDoorControl == 0.0F)
                {
                    if(setNew.stbyPosition65 > 0.0F)
                        setNew.stbyPosition65 = setOld.stbyPosition65 - 0.5F;
                } else
                if(setNew.stbyPosition65 < 1.0F)
                    setNew.stbyPosition65 = setOld.stbyPosition65 + 0.5F;
                if(((FlightModelMain) (fm)).CT.BayDoorControl == 0.0F)
                {
                    if(setNew.stbyPosition67 > 0.0F)
                        setNew.stbyPosition67 = setOld.stbyPosition67 - 0.5F;
                } else
                if(setNew.stbyPosition67 < 1.0F)
                    setNew.stbyPosition67 = setOld.stbyPosition67 + 0.5F;
            }
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 0.2F)
            {
                if(setNew.stbyPosition80 > 0.0F)
                    setNew.stbyPosition80 = setOld.stbyPosition80 - 0.05F;
            } else
            if(setNew.stbyPosition80 < 1.0F)
                setNew.stbyPosition80 = setOld.stbyPosition80 + 0.05F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 0.4F)
            {
                if(setNew.stbyPosition81 > 0.0F)
                    setNew.stbyPosition81 = setOld.stbyPosition81 - 0.05F;
            } else
            if(setNew.stbyPosition81 < 1.0F)
                setNew.stbyPosition81 = setOld.stbyPosition81 + 0.05F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 0.6F)
            {
                if(setNew.stbyPosition82 > 0.0F)
                    setNew.stbyPosition82 = setOld.stbyPosition82 - 0.05F;
            } else
            if(setNew.stbyPosition82 < 1.0F)
                setNew.stbyPosition82 = setOld.stbyPosition82 + 0.05F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 0.8F)
            {
                if(setNew.stbyPosition83 > 0.0F)
                    setNew.stbyPosition83 = setOld.stbyPosition83 - 0.05F;
            } else
            if(setNew.stbyPosition83 < 1.0F)
                setNew.stbyPosition83 = setOld.stbyPosition83 + 0.05F;
            if(((FlightModelMain) (fm)).EI.engines[0].getControlRadiator() < 1.0F)
            {
                if(setNew.stbyPosition84 > 0.0F)
                    setNew.stbyPosition84 = setOld.stbyPosition84 - 0.05F;
            } else
            if(setNew.stbyPosition84 < 1.0F)
                setNew.stbyPosition84 = setOld.stbyPosition84 + 0.05F;
            if(!cockpitDimControl)
            {
                if(setNew.dimPosition > 0.0F)
                    setNew.dimPosition = setOld.dimPosition - 0.05F;
            } else
            if(setNew.dimPosition < 1.0F)
                setNew.dimPosition = setOld.dimPosition + 0.05F;
            setNew.throttle = (10F * setOld.throttle + ((FlightModelMain) (fm)).CT.PowerControl) / 11F;
            setNew.azimuth = ((FlightModelMain) (fm)).Or.getYaw();
            if(setOld.azimuth > 270F && setNew.azimuth < 90F)
                setOld.azimuth -= 360F;
            if(setOld.azimuth < 90F && setNew.azimuth > 270F)
                setOld.azimuth += 360F;
            setNew.waypointAzimuth = (10F * setOld.waypointAzimuth + (waypointAzimuth() - setOld.azimuth) + World.Rnd().nextFloat(-30F, 30F)) / 11F;
            buzzerFX(((FlightModelMain) (fm)).CT.getGear() < 0.999999F && ((FlightModelMain) (fm)).CT.getFlap() > 0.1F);
            return true;
        }

        Interpolater()
        {
        }
    }

    private class Variables
    {
        float altimeter;
        float throttle;
        float dimPosition;
        float azimuth;
        float waypointAzimuth;
        float stbyPosition2;
        float stbyPosition3;
        float stbyPosition6;
        float stbyPosition7;
        float stbyPosition8;
        float stbyPosition9;
        float stbyPosition11;
        float stbyPosition12;
        float stbyPosition13;
        float stbyPosition26;
        float stbyPosition27;
        float stbyPosition28;
        float stbyPosition30;
        float stbyPosition33;
        float stbyPosition34;
        float stbyPosition35;
        float stbyPosition36;
        float stbyPosition37;
        float stbyPosition38;
        float stbyPosition40;
        float stbyPosition41;
        float stbyPosition45;
        float stbyPosition46;
        float stbyPosition47;
        float stbyPosition52;
        float stbyPosition57;
        float stbyPosition59;
        float stbyPosition60;
        float stbyPosition61;
        float stbyPosition62;
        float stbyPosition63;
        float stbyPosition64;
        float stbyPosition65;
        float stbyPosition67;
        float stbyPosition80;
        float stbyPosition81;
        float stbyPosition82;
        float stbyPosition83;
        float stbyPosition84;

        private Variables()
        {
        }

        Variables(Variables variables)
        {
            this();
        }
    }

    protected float waypointAzimuth()
    {
        WayPoint waypoint = ((FlightModelMain) (super.fm)).AP.way.curr();
        if(waypoint == null)
        {
            return 0.0F;
        } else
        {
            waypoint.getP(tmpP);
            tmpV.sub(tmpP, ((FlightModelMain) (super.fm)).Loc);
            return (float)(57.295779513082323D * Math.atan2(((Tuple3d) (tmpV)).y, ((Tuple3d) (tmpV)).x));
        }
    }

    public CockpitBF_109E7()
    {
        super("3do/cockpit/Bf-109E-4/hier.him", "bf109");
        gun = new Gun[4];
        setOld = new Variables(null);
        setNew = new Variables(null);
        oldctl = -1F;
        curctl = -1F;
        AccelerationState1 = false;
        PitotOk = false;
        FuelPress2 = false;
        GearUp1 = false;
        GearUp2 = false;
        GearDown1 = false;
        GearDown2 = false;
        timeCounterGearUp1 = 0.0F;
        timeGearUp1 = 101F;
        timeCounterGearUp2 = 0.0F;
        timeGearUp2 = 10F;
        timeCounterGearUp3 = 0.0F;
        timeGearUp3 = 100F;
        timeCounterGearDown1 = 0.0F;
        timeGearDown1 = 101F;
        timeCounterGearDown2 = 0.0F;
        timeGearDown2 = 10F;
        timeCounterGearDown3 = 0.0F;
        timeGearDown3 = 100F;
        OilPress = false;
        CanopyClosedState = false;
        EjectCanop = false;
        MagnetProtectDown = false;
        MagnetProtectDown2 = false;
        MagnetosUp = false;
        timeCounterMagnet1 = 0.0F;
        timeMagnet1 = 30F;
        timeCounterMagnet2 = 0.0F;
        timeMagnet2 = 30F;
        pictManifold = 0.0F;
        pictAiler = 0.0F;
        pictElev = 0.0F;
        tmpP = new Point3d();
        tmpV = new Vector3d();
        setNew.dimPosition = 1.0F;
        HookNamed hooknamed = new HookNamed(super.mesh, "LAMPHOOK1");
        Loc loc = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        hooknamed.computePos(this, new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F), loc);
        light1 = new LightPointActor(new LightPoint(), loc.getPoint());
        light1.light.setColor(126F, 232F, 245F);
        light1.light.setEmit(0.0F, 0.0F);
        super.pos.base().draw.lightMap().put("LAMPHOOK1", light1);
        hooknamed = new HookNamed(super.mesh, "LAMPHOOK2");
        loc = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        hooknamed.computePos(this, new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F), loc);
        light2 = new LightPointActor(new LightPoint(), loc.getPoint());
        light2.light.setColor(126F, 232F, 245F);
        light2.light.setEmit(0.0F, 0.0F);
        super.pos.base().draw.lightMap().put("LAMPHOOK2", light2);
        super.cockpitNightMats = (new String[] {
            "ZClocks1", "ZClocksDMG", "ZClocks2", "ZClocks3", "Needles", "ZClocks4"
        });
        setNightMats(false);
        interpPut(new Interpolater(), null, Time.current(), null);
        loadBuzzerFX();
        gun[0] = ((Aircraft)((Interpolate) (super.fm)).actor).getGunByHookName("_MGUN01");
        gun[1] = ((Aircraft)((Interpolate) (super.fm)).actor).getGunByHookName("_MGUN02");
        gun[2] = ((Aircraft)((Interpolate) (super.fm)).actor).getGunByHookName("_CANNON01");
        gun[3] = ((Aircraft)((Interpolate) (super.fm)).actor).getGunByHookName("_CANNON02");
        super.printCompassHeading = true;
        super.limits6DoF = (new float[] {
            0.7F, 0.055F, -0.07F, 0.11F, 0.07F, -0.13F, 0.03F, -0.03F
        });
    }

    public void reflectWorldToInstruments(float f)
    {
        resetYPRmodifier();
        super.mesh.chunkSetAngles("Z_Compass2a", -cvt(((FlightModelMain) (super.fm)).Or.getTangage(), -10F, 10F, -10F, 10F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Compass2b", 0.0F, interp(setNew.azimuth, setOld.azimuth, f), 0.0F);
        super.mesh.chunkSetAngles("Top", 0.0F, 75F * ((FlightModelMain) (super.fm)).CT.getCockpitDoor(), 0.0F);
        super.mesh.chunkSetAngles("Z_TrimIndicator", 330F * ((FlightModelMain) (super.fm)).CT.getTrimElevatorControl(), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_TrimWheel", 720F * ((FlightModelMain) (super.fm)).CT.getTrimElevatorControl(), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_PedalStrut", ((FlightModelMain) (super.fm)).CT.getRudder() * 7F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_LeftPedal", -((FlightModelMain) (super.fm)).CT.getRudder() * 7F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_RightPedal", -((FlightModelMain) (super.fm)).CT.getRudder() * 7F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_FlapsWheel", -360F * ((FlightModelMain) (super.fm)).CT.FlapsControl, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_MagnetProtect", 0.0F, cvt(interp(setNew.stbyPosition2, setOld.stbyPosition2, f), 0.0F, 1.0F, 0.0F, -60F), 0.0F);
        super.mesh.chunkSetAngles("Z_MagnetProtect2", 0.0F, cvt(interp(setNew.stbyPosition6, setOld.stbyPosition6, f), 0.0F, 1.0F, 0.0F, -40F), 0.0F);
        super.mesh.chunkSetAngles("Z_MasterArm", 0.0F, cvt(1.0F, 0.0F, 1.0F, 0.0F, -60F), 0.0F);
        super.mesh.chunkSetAngles("Z_Starter2", 0.0F, cvt(interp(setNew.stbyPosition7, setOld.stbyPosition7, f), 0.0F, 1.0F, 0.0F, 85F), 0.0F);
        super.mesh.chunkSetAngles("Z_GearLever", 0.0F, cvt(interp(setNew.stbyPosition9, setOld.stbyPosition9, f), 0.0F, 1.0F, 0.0F, -65F), 0.0F);
        super.mesh.chunkSetAngles("Z_KG13Trigger", 0.0F, cvt(interp(setNew.stbyPosition12, setOld.stbyPosition12, f), 0.0F, 1.0F, 0.0F, -270F), 0.0F);
        super.mesh.chunkSetAngles("Z_FuelSelector", 0.0F, cvt(1.0F, 0.0F, 1.0F, 0.0F, 11F), 0.0F);
        super.mesh.chunkSetAngles("Z_EjectCanop", 0.0F, cvt(interp(setNew.stbyPosition26, setOld.stbyPosition26, f), 0.0F, 1.0F, 0.0F, 21F), 0.0F);
        super.mesh.chunkSetAngles("Z_TopCable", 0.0F, cvt(interp(setNew.stbyPosition30, setOld.stbyPosition30, f), 0.0F, 1.0F, 0.0F, -90F), 0.0F);
        super.mesh.chunkSetAngles("Z_OxyButton", 0.0F, cvt(1.0F, 0.0F, 1.0F, 0.0F, -244F), 0.0F);
        super.mesh.chunkSetAngles("Z_OxyPressure", 0.0F, cvt(1.0F, 0.0F, 1.0F, 0.0F, -253F), 0.0F);
        super.mesh.chunkSetAngles("Z_CanopyHandle", 0.0F, cvt(interp(setNew.stbyPosition34, setOld.stbyPosition34, f), 0.0F, 1.0F, 0.0F, 35F), 0.0F);
        super.mesh.chunkSetAngles("Z_AutoPropButton", 0.0F, cvt(interp(setNew.stbyPosition35, setOld.stbyPosition35, f), 0.0F, 1.0F, 0.0F, -31F), 0.0F);
        super.mesh.chunkSetAngles("Z_GearLever2b", 0.0F, cvt(interp(setNew.stbyPosition60, setOld.stbyPosition60, f), 0.0F, 1.0F, 0.0F, 103F), 0.0F);
        super.mesh.chunkSetAngles("Z_GearLever2d", 0.0F, cvt(interp(setNew.stbyPosition62, setOld.stbyPosition62, f), 0.0F, 1.0F, 0.0F, -103F), 0.0F);
        super.mesh.chunkSetAngles("Z_LightButton", 0.0F, cvt(interp(setNew.stbyPosition64, setOld.stbyPosition64, f), 0.0F, 1.0F, 0.0F, -128.5F), 0.0F);
        super.mesh.chunkSetAngles("Z_Altimeter1", cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 3600F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Altimeter2", cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 182.14F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Altimeter3", cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 3600F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_OxyAlt", cvt(interp(setNew.altimeter, setOld.altimeter, f), 6000F, 10000F, 0.0F, 50F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_ReviLever", cvt(interp(setNew.dimPosition, setOld.dimPosition, f), 0.0F, 1.0F, 0.0F, 29F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_PropLever", cvt(((FlightModelMain) (super.fm)).CT.getStepControl(), 0.0F, 1.0F, 0.0F, 90.8F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_ATA1", cvt(pictManifold = 0.75F * pictManifold + 0.25F * ((FlightModelMain) (super.fm)).EI.engines[0].getManifoldPressure(), 0.6F, 1.8F, 0.0F, 325.5F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Speedometer1", floatindex(cvt(Pitot.Indicator((float)((Tuple3d) (((FlightModelMain) (super.fm)).Loc)).z, super.fm.getSpeedKMH()), 0.0F, 800F, 0.0F, 16F), speedometerScale), 0.0F, 0.0F);
        if(super.fm.getAltitude() > 3000F)
            super.mesh.chunkSetAngles("Z_Speedometer2", cvt(interp(setNew.stbyPosition45, setOld.stbyPosition45, f), 0.0F, 1.0F, 0.0F, 50F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_RPM1", floatindex(cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 4000F, 0.0F, 8F), rpmScale), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_FuelQuantity", cvt(((FlightModelMain) (super.fm)).M.fuel / 0.72F, 0.0F, 400F, 0.0F, 81F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_OilTemp", cvt(((FlightModelMain) (super.fm)).EI.engines[0].tOilOut, 0.0F, 120F, 0.0F, 77.12F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_WaterTemp", cvt(((FlightModelMain) (super.fm)).EI.engines[0].tWaterOut, 0.0F, 120F, 0.0F, 77.12F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_RadiatorSelector1", 0.0F, cvt(interp(setNew.stbyPosition80, setOld.stbyPosition80, f), 0.0F, 1.0F, 0.0F, -54F), 0.0F);
        super.mesh.chunkSetAngles("Z_RadiatorSelector2", 0.0F, cvt(interp(setNew.stbyPosition81, setOld.stbyPosition81, f), 0.0F, 1.0F, 0.0F, -54F), 0.0F);
        super.mesh.chunkSetAngles("Z_RadiatorSelector3", 0.0F, cvt(interp(setNew.stbyPosition82, setOld.stbyPosition82, f), 0.0F, 1.0F, 0.0F, -54F), 0.0F);
        super.mesh.chunkSetAngles("Z_RadiatorSelector4", 0.0F, cvt(interp(setNew.stbyPosition83, setOld.stbyPosition83, f), 0.0F, 1.0F, 0.0F, -54F), 0.0F);
        super.mesh.chunkSetAngles("Z_RadiatorSelector5", 0.0F, cvt(interp(setNew.stbyPosition84, setOld.stbyPosition84, f), 0.0F, 1.0F, 0.0F, -54F), 0.0F);
        super.mesh.chunkSetAngles("Z_OilCooler1", 0.0F, cvt(interp(setNew.stbyPosition8, setOld.stbyPosition8, f), 0.0F, 1.0F, 0.0F, -6.8F), 0.0F);
        super.mesh.chunkSetAngles("Z_OilCooler2", 0.0F, cvt(interp(setNew.stbyPosition28, setOld.stbyPosition28, f), 0.0F, 1.0F, 0.0F, -6.8F), 0.0F);
        super.mesh.chunkSetAngles("Z_OilCooler3", 0.0F, cvt(interp(setNew.stbyPosition36, setOld.stbyPosition36, f), 0.0F, 1.0F, 0.0F, -6.8F), 0.0F);
        super.mesh.chunkSetAngles("Z_OilCooler4", 0.0F, cvt(interp(setNew.stbyPosition37, setOld.stbyPosition37, f), 0.0F, 1.0F, 0.0F, -6.8F), 0.0F);
        super.mesh.chunkSetAngles("Z_OilCooler5", 0.0F, cvt(interp(setNew.stbyPosition38, setOld.stbyPosition38, f), 0.0F, 1.0F, 0.0F, -6.8F), 0.0F);
        if(((FlightModelMain) (super.fm)).EI.engines[0].getStage() == 6)
        {
            FuelPress2 = true;
            OilPress = true;
        }
        if(((FlightModelMain) (super.fm)).M.fuel == 0.0F)
            FuelPress2 = false;
        updateWeaponsInstruments();
        super.mesh.chunkSetAngles("Z_FuelPress1", cvt(1.0F, 0.0F, 1.0F, 0.0F, 37.87F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_FuelPress2", cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM() / 1500F, 0.0F, 3F, -40F, 100F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_OilPress1", -cvt(1.0F + 0.05F * ((FlightModelMain) (super.fm)).EI.engines[0].tOilOut + ((FlightModelMain) (super.fm)).EI.engines[0].getRPM() / 1500F, 0.0F, 15F, 10F, -200F), 0.0F, 0.0F);
        if(!aircraft().isFMTrackMirror())
        {
            float f2 = cvt((setNew.azimuth - setOld.azimuth) / Time.tickLenFs(), -5F, 5F, 18F, -18F);
            if(aircraft().fmTrack() != null)
                aircraft().fmTrack().setCockpitAzimuthSpeed(f2);
            super.mesh.chunkSetAngles("Z_TopCable3", 0.0F, f2, 0.0F);
            if(((FlightModelMain) (super.fm)).EI.engines[0].getStage() == 6)
                super.mesh.chunkSetAngles("Z_TurnBank1", f2, 0.0F, 0.0F);
        }
        super.mesh.chunkSetAngles("Z_TurnBank2", cvt(getBall(6D), -10F, 10F, -8.8F, 8.8F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_PropPitch1", 270F - (float)Math.toDegrees(((FlightModelMain) (super.fm)).EI.engines[0].getPropPhi() - ((FlightModelMain) (super.fm)).EI.engines[0].getPropPhiMin()) * 60F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_PropPitch2", 105F - (float)Math.toDegrees(((FlightModelMain) (super.fm)).EI.engines[0].getPropPhi() - ((FlightModelMain) (super.fm)).EI.engines[0].getPropPhiMin()) * 5F, 0.0F, 0.0F);
        if(hasBombs())
        {
            super.mesh.chunkVisible("BombsPanel1", true);
            super.mesh.chunkVisible("BombsPanel2", true);
            super.mesh.chunkVisible("BombsPanel3", true);
            super.mesh.chunkVisible("Z_BombsContact1", true);
            super.mesh.chunkVisible("Z_BombsContact2", true);
            super.mesh.chunkVisible("Z_BombsSelector", true);
        } else
        {
            super.mesh.chunkVisible("BombsPanel1", false);
            super.mesh.chunkVisible("BombsPanel2", false);
            super.mesh.chunkVisible("BombsPanel3", false);
            super.mesh.chunkVisible("Z_BombsContact1", false);
            super.mesh.chunkVisible("Z_BombsContact2", false);
            super.mesh.chunkVisible("Z_BombsSelector", false);
        }
        if(((FlightModelMain) (super.fm)).CT.GearControl == 0.0F)
        {
            GearUp1 = true;
            timeCounterGearUp1 += f;
            timeCounterGearUp2 += f;
            timeCounterGearUp3 += f;
            if(timeCounterGearUp1 > timeGearUp1)
                GearUp1 = false;
            if(timeCounterGearUp2 > timeGearUp2)
            {
                GearUp2 = true;
                timeCounterGearUp3 += f;
                if(timeCounterGearUp3 > timeGearUp3)
                    GearUp2 = false;
            }
        } else
        {
            timeCounterGearUp1 = 0.0F;
            timeCounterGearUp2 = 0.0F;
            timeCounterGearUp3 = 0.0F;
            timeGearUp1 = 101F;
            timeGearUp2 = 10F;
            timeGearUp3 = 100F;
            GearUp1 = false;
            GearUp2 = false;
        }
        if(((FlightModelMain) (super.fm)).CT.GearControl == 1.0F)
        {
            GearDown1 = true;
            timeCounterGearDown1 += f;
            timeCounterGearDown2 += f;
            timeCounterGearDown3 += f;
            if(timeCounterGearDown1 > timeGearDown1)
                GearDown1 = false;
            if(timeCounterGearDown2 > timeGearDown2)
            {
                GearDown2 = true;
                timeCounterGearDown3 += f;
                if(timeCounterGearDown3 > timeGearDown3)
                    GearDown2 = false;
            }
        } else
        {
            timeCounterGearDown1 = 0.0F;
            timeCounterGearDown2 = 0.0F;
            timeCounterGearDown3 = 0.0F;
            timeGearDown1 = 101F;
            timeGearDown2 = 10F;
            timeGearDown3 = 100F;
            GearDown1 = false;
            GearDown2 = false;
        }
        if(((FlightModelMain) (super.fm)).CT.getCockpitDoor() > 0.1F)
            super.mesh.chunkVisible("Z_TopCable2", true);
        else
            super.mesh.chunkVisible("Z_TopCable2", false);
        if(((FlightModelMain) (super.fm)).CT.getCockpitDoor() == 0.0F)
            super.mesh.chunkVisible("Z_TopCable4", true);
        else
            super.mesh.chunkVisible("Z_TopCable4", false);
        if(((FlightModelMain) (super.fm)).CT.getCockpitDoor() == 0.0F)
            CanopyClosedState = true;
        else
            CanopyClosedState = false;
        super.mesh.chunkVisible("Z_PitotLight", false);
        if(((FlightModelMain) (super.fm)).M.fuel < 30F)
            super.mesh.chunkVisible("Z_FuelWarning1", true);
        else
            super.mesh.chunkVisible("Z_FuelWarning1", false);
        if(((FlightModelMain) (super.fm)).CT.getGear() == 0.0F)
        {
            super.mesh.chunkVisible("Z_GearLRed1", true);
            super.mesh.chunkVisible("Z_GearRRed1", true);
        } else
        {
            super.mesh.chunkVisible("Z_GearLRed1", false);
            super.mesh.chunkVisible("Z_GearRRed1", false);
        }
        if(((FlightModelMain) (super.fm)).CT.getGear() == 1.0F)
        {
            super.mesh.chunkVisible("Z_GearLGreen1", true);
            super.mesh.chunkVisible("Z_GearRGreen1", true);
        } else
        {
            super.mesh.chunkVisible("Z_GearLGreen1", false);
            super.mesh.chunkVisible("Z_GearRGreen1", false);
        }
        if(hasBombs())
            super.mesh.chunkVisible("Z_BombsLight", true);
        else
            super.mesh.chunkVisible("Z_BombsLight", false);
        super.mesh.chunkSetAngles("Z_Hour1", cvt(World.getTimeofDay(), 0.0F, 24F, 0.0F, 720F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Minute1", cvt(World.getTimeofDay() % 1.0F, 0.0F, 1.0F, 0.0F, 360F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_Second1", cvt(((World.getTimeofDay() % 1.0F) * 60F) % 1.0F, 0.0F, 1.0F, 0.0F, 360F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_KG13a", (pictAiler = 0.85F * pictAiler + 0.15F * ((FlightModelMain) (super.fm)).CT.AileronControl) * 15F, 0.0F, (pictElev = 0.85F * pictElev + 0.15F * ((FlightModelMain) (super.fm)).CT.ElevatorControl) * 9F);
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 8) == 0)
            super.mesh.chunkSetAngles("Z_Throttle", interp(setNew.throttle, setOld.throttle, f) * 48.74F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Z_MagnetoSwitch", 26.4F * (float)((FlightModelMain) (super.fm)).EI.engines[0].getControlMagnetos(), 0.0F, 0.0F);
        if((float)((FlightModelMain) (super.fm)).EI.engines[0].getControlMagnetos() > 0.0F)
        {
            MagnetProtectDown = true;
            MagnetosUp = true;
        }
        if(MagnetosUp && !MagnetProtectDown && (float)((FlightModelMain) (super.fm)).EI.engines[0].getControlMagnetos() < 2.0F)
            MagnetProtectDown2 = true;
        if(MagnetProtectDown)
        {
            timeCounterMagnet1 += f;
            if(timeCounterMagnet1 > timeMagnet1)
                MagnetProtectDown = false;
        } else
        {
            timeCounterMagnet1 = 0.0F;
            timeMagnet1 = 30F;
        }
        if(MagnetProtectDown2)
        {
            timeCounterMagnet2 += f;
            if(timeCounterMagnet2 > timeMagnet2)
            {
                MagnetProtectDown2 = false;
                MagnetosUp = false;
            }
        } else
        {
            timeCounterMagnet2 = 0.0F;
            timeMagnet2 = 30F;
        }
        if(super.fm.getSpeedKMH() > 200F)
            ((FlightModelMain) (super.fm)).CT.bHasCockpitDoorControl = false;
        else
            ((FlightModelMain) (super.fm)).CT.bHasCockpitDoorControl = true;
        super.mesh.chunkVisible("Z_Z_RETICLE", true);
        if(curctl == -1F)
        {
            curctl = oldctl = ((FlightModelMain) (super.fm)).EI.engines[0].getControlThrottle();
        } else
        {
            curctl = ((FlightModelMain) (super.fm)).EI.engines[0].getControlThrottle();
            if(curctl > 0.5F && (curctl - oldctl) / f > 0.0F && ((FlightModelMain) (super.fm)).EI.engines[0].getRPM() > 300F && super.fm.getSpeedKMH() > 0.0F && super.fm.getSpeedKMH() <= 90F && ((FlightModelMain) (super.fm)).EI.engines[0].getStage() == 6)
                AccelerationState1 = true;
            oldctl = curctl;
        }
        if(super.fm.getSpeedKMH() > 100F)
            AccelerationState1 = false;
        resetYPRmodifier();
        Cockpit.xyz[1] = cvt(interp(setNew.dimPosition, setOld.dimPosition, f), 0.0F, 1.0F, 0.0F, -0.071F);
        super.mesh.chunkSetLocate("ReviTinter", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.dimPosition, setOld.dimPosition, f), 0.0F, 1.0F, 0.0F, -0.041F);
        super.mesh.chunkSetLocate("ReviTinter2", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
        Cockpit.xyz[1] = cvt(1.0F, 0.0F, 1.0F, 0.0F, -0.005F);
        super.mesh.chunkSetLocate("Z_Master", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition3, setOld.stbyPosition3, f), 0.0F, 1.0F, 0.0F, 0.008F);
        super.mesh.chunkSetLocate("Z_Starter1", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition13, setOld.stbyPosition13, f), 0.0F, 1.0F, 0.0F, -0.004F);
        super.mesh.chunkSetLocate("Z_EjectCanop2", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition27, setOld.stbyPosition27, f), 0.0F, 1.0F, 0.0F, -0.02F);
        super.mesh.chunkSetLocate("Z_LockTWheel", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(1.0F, 0.0F, 1.0F, 0.0F, -0.01F);
        super.mesh.chunkSetLocate("Z_MasterSwitch", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(1.0F, 0.0F, 1.0F, 0.0F, -0.007F);
        super.mesh.chunkSetLocate("Z_CircuitBreakers", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(1.0F, 0.0F, 1.0F, 0.0F, -0.007F);
        super.mesh.chunkSetLocate("Z_PropPitch", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(1.0F, 0.0F, 1.0F, 0.0F, -0.007F);
        super.mesh.chunkSetLocate("Z_RadioSwitch", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition40, setOld.stbyPosition40, f), 0.0F, 1.0F, 0.0F, -0.007F);
        super.mesh.chunkSetLocate("Z_CockpitLights", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition41, setOld.stbyPosition41, f), 0.0F, 1.0F, 0.0F, -0.007F);
        super.mesh.chunkSetLocate("Z_NavLights", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition46, setOld.stbyPosition46, f), 0.0F, 1.0F, 0.0F, 0.007F);
        super.mesh.chunkSetLocate("Z_CockpitLights2", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition47, setOld.stbyPosition47, f), 0.0F, 1.0F, 0.0F, 0.004F);
        super.mesh.chunkSetLocate("Z_NavLights2", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(1.0F, 0.0F, 1.0F, 0.0F, -0.007F);
        super.mesh.chunkSetLocate("Z_Divers1", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(1.0F, 0.0F, 1.0F, 0.0F, -0.007F);
        super.mesh.chunkSetLocate("Z_Divers2", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition52, setOld.stbyPosition52, f), 0.0F, 1.0F, 0.0F, -0.03F);
        super.mesh.chunkSetLocate("Cockpit", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition57, setOld.stbyPosition57, f), 0.0F, 1.0F, 0.0F, -0.053F);
        super.mesh.chunkSetLocate("Z_GearIndicator", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition59, setOld.stbyPosition59, f), 0.0F, 1.0F, 0.0F, 0.01F);
        super.mesh.chunkSetLocate("Z_GearLever2a", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition61, setOld.stbyPosition61, f), 0.0F, 1.0F, 0.0F, 0.01F);
        super.mesh.chunkSetLocate("Z_GearLever2c", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition65, setOld.stbyPosition65, f), 0.0F, 1.0F, 0.0F, -0.003F);
        super.mesh.chunkSetLocate("Z_BombsContact1", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = cvt(interp(setNew.stbyPosition67, setOld.stbyPosition67, f), 0.0F, 1.0F, 0.0F, 0.003F);
        super.mesh.chunkSetLocate("Z_BombsContact2", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
        Cockpit.xyz[1] = cvt(interp(setNew.throttle, setOld.throttle, f), 0.0F, 1.0F, 0.0F, 0.028F);
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 8) == 0)
            super.mesh.chunkSetLocate("Z_Throttle2", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
        Cockpit.xyz[1] = cvt(((FlightModelMain) (super.fm)).EI.engines[0].getControlRadiator(), 0.0F, 1.0F, 0.0F, 0.029F);
        super.mesh.chunkSetLocate("Z_OilCoolerb", Cockpit.xyz, Cockpit.ypr);
    }

    public void toggleDim()
    {
        super.cockpitDimControl = !super.cockpitDimControl;
    }

    public void toggleLight()
    {
        super.cockpitLightControl = !super.cockpitLightControl;
        if(super.cockpitLightControl)
        {
            light1.light.setEmit(0.004F, 0.4F);
            light2.light.setEmit(0.004F, 0.4F);
            setNightMats(true);
        } else
        {
            light1.light.setEmit(0.0F, 0.0F);
            light2.light.setEmit(0.0F, 0.0F);
            setNightMats(false);
        }
    }

    public void reflectCockpitState()
    {
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 2) != 0)
        {
            super.mesh.chunkVisible("Z_HitArmor1", true);
            super.mesh.chunkVisible("Z_Holes1", true);
            super.mesh.chunkVisible("Z_Holes3", true);
            super.mesh.chunkVisible("Z_Holes3bis", true);
            super.mesh.chunkVisible("Z_Z_RETICLE", false);
            super.mesh.chunkVisible("Z_Z_MASK", false);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 1) != 0)
            super.mesh.chunkVisible("Z_Holes2", true);
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x40) != 0)
        {
            super.mesh.chunkVisible("Z_Holes3", true);
            super.mesh.chunkVisible("Z_Holes3bis", true);
            super.mesh.chunkVisible("Z_Holes2", true);
            super.mesh.chunkVisible("DMGInstruments", true);
            super.mesh.chunkVisible("Z_Altimeter1", false);
            super.mesh.chunkVisible("Z_Altimeter2", false);
            super.mesh.chunkVisible("Z_Speedometer1", false);
            super.mesh.chunkVisible("Z_ATA1", false);
            super.mesh.chunkVisible("Z_FuelQuantity1", false);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 4) != 0)
        {
            super.mesh.chunkVisible("Z_Holes1", true);
            super.mesh.chunkVisible("Z_Holes3", true);
            super.mesh.chunkVisible("Z_Holes3bis", true);
            super.mesh.chunkVisible("Z_Holes2", true);
            super.mesh.chunkVisible("DMGInstruments", true);
            super.mesh.chunkVisible("Z_Altimeter1", false);
            super.mesh.chunkVisible("Z_Altimeter2", false);
            super.mesh.chunkVisible("Z_Speedometer1", false);
            super.mesh.chunkVisible("Z_ATA1", false);
            super.mesh.chunkVisible("Z_FuelQuantity1", false);
			super.mesh.chunkVisible("Z_Blood", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x20) != 0)
            super.mesh.chunkVisible("Z_Holes1", true);
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x80) != 0)
            super.mesh.chunkVisible("Z_OilSplats", true);
    }

    public void removeCanopy()
    {
        hasCanopy = false;
        super.mesh.chunkVisible("Top", false);
        super.mesh.chunkVisible("Top2", false);
        super.mesh.chunkVisible("Top10", false);
        super.mesh.chunkVisible("Top13", false);
        super.mesh.chunkVisible("Top20", false);
        super.mesh.chunkVisible("Top21", false);
        super.mesh.chunkVisible("Top22", false);
        super.mesh.chunkVisible("Top23", false);
        super.mesh.chunkVisible("Top25", false);
        super.mesh.chunkVisible("Top3", false);
        super.mesh.chunkVisible("Top4", false);
        super.mesh.chunkVisible("Top27", false);
        super.mesh.chunkVisible("Top28", false);
        super.mesh.chunkVisible("Top14", false);
        super.mesh.chunkVisible("TopSideGlass", false);
        super.mesh.chunkVisible("Z_TopCable", false);
        super.mesh.chunkVisible("Z_TopCable2", false);
        super.mesh.chunkVisible("Z_TopCable3", false);
        super.mesh.chunkVisible("Z_TopCable4", false);
        super.mesh.chunkVisible("Z_Holes3", false);
        super.mesh.chunkVisible("Z_Holes3bis", false);
        super.mesh.chunkVisible("Z_CanopyHandle", false);
    }

    protected boolean doFocusEnter()
    {
        if(super.doFocusEnter())
        {
            aircraft().hierMesh().chunkVisible("Blister1_D0", false);
            if(((FlightModelMain) (super.fm)).AS.bIsAboutToBailout)
                hasCanopy = false;
            return true;
        } else
        {
            return false;
        }
    }

    protected void doFocusLeave()
    {
        if(isFocused() && hasCanopy)
        {
            aircraft().hierMesh().chunkVisible("Blister1_D0", true);
        }
        super.doFocusLeave();
    }

    public boolean hasBombs()
    {
        if(((FlightModelMain) (super.fm)).CT.Weapons[3] != null)
        {
            for(int i = 0; i < ((FlightModelMain) (super.fm)).CT.Weapons[3].length; i++)
                if(((FlightModelMain) (super.fm)).CT.Weapons[3][i] != null)
                    return true;

        }
        return false;
    }

    protected void updateWeaponsInstruments()
    {
        if(gun[2] != null)
        {
            super.mesh.chunkSetAngles("Z_AmmoCounter1", cvt(gun[2].countBullets() / 10, 0.0F, 9F, 0.0F, 324F), 0.0F, 0.0F);
            super.mesh.chunkSetAngles("Z_AmmoCounter2", cvt(gun[2].countBullets() % 10, 0.0F, 9F, 0.0F, 324F), 0.0F, 0.0F);
        }
        if(gun[3] != null)
        {
            super.mesh.chunkSetAngles("Z_AmmoCounter3", cvt(gun[3].countBullets() / 10, 0.0F, 9F, 0.0F, 324F), 0.0F, 0.0F);
            super.mesh.chunkSetAngles("Z_AmmoCounter4", cvt(gun[3].countBullets() % 10, 0.0F, 9F, 0.0F, 324F), 0.0F, 0.0F);
        }
        if((float)gun[2].countBullets() > 0.0F)
            super.mesh.chunkVisible("Z_Gun0Light", true);
        else
            super.mesh.chunkVisible("Z_Gun0Light", false);
        if((float)gun[3].countBullets() > 0.0F)
            super.mesh.chunkVisible("Z_Gun1Light", true);
        else
            super.mesh.chunkVisible("Z_Gun1Light", false);
        if((float)gun[0].countBullets() > 0.0F)
            super.mesh.chunkVisible("Z_Gun2Light", true);
        else
            super.mesh.chunkVisible("Z_Gun2Light", false);
        if((float)gun[1].countBullets() > 0.0F)
            super.mesh.chunkVisible("Z_Gun3Light", true);
        else
            super.mesh.chunkVisible("Z_Gun3Light", false);
    }

    boolean hasCanopy;
    public Gun gun[];
    private Variables setOld;
    private Variables setNew;
    private Variables setTmp;
    private float oldctl;
    private float curctl;
    private boolean AccelerationState1;
    private boolean PitotOk;
    private boolean FuelPress2;
    private boolean OilPress;
    private boolean GearUp1;
    private boolean GearUp2;
    private boolean GearDown1;
    private boolean GearDown2;
    private float timeCounterGearUp1;
    private float timeGearUp1;
    private float timeCounterGearUp2;
    private float timeGearUp2;
    private float timeCounterGearUp3;
    private float timeGearUp3;
    private float timeCounterGearDown1;
    private float timeGearDown1;
    private float timeCounterGearDown2;
    private float timeGearDown2;
    private float timeCounterGearDown3;
    private float timeGearDown3;
    private boolean CanopyClosedState;
    private boolean EjectCanop;
    private boolean MagnetProtectDown;
    private boolean MagnetProtectDown2;
    private boolean MagnetosUp;
    private float timeCounterMagnet1;
    private float timeMagnet1;
    private float timeCounterMagnet2;
    private float timeMagnet2;
    private LightPointActor light1;
    private LightPointActor light2;
    private float pictAiler;
    private float pictElev;
    private float pictManifold;
    private static final float speedometerScale[] = {
        0.0F, 9.5F, 20.2F, 42.1F, 66F, 90F, 115F, 137F, 160.4F, 187F, 
        213.8F, 241.2F, 269.5F, 296.2F, 322.6F, 349.6F, 380.2F
    };
    private static final float rpmScale[] = {
        0.0F, 11.8F, 54F, 107.2F, 167.5F, 229.5F, 283.8F, 335.5F, 344F
    };
    private Point3d tmpP;
    private Vector3d tmpV;

    static 
    {
        Property.set(com.maddox.il2.objects.air.CockpitBF_109E7.class, "normZN", 0.5F);
        Property.set(com.maddox.il2.objects.air.CockpitBF_109E7.class, "gsZN", 0.5F);
        Property.set(com.maddox.il2.objects.air.CockpitBF_109E7.class, "normZNs", new float[] {
            0.92F, 0.6F, 0.57F, 0.6F
        });
    }
}
