package com.maddox.il2.objects.air;

import com.maddox.JGP.*;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.Mission;
import com.maddox.il2.objects.weapons.GunEmpty;
import com.maddox.rts.*;

public class CockpitLAGG_3_66 extends CockpitPilot
{
    class Interpolater extends InterpolateRef
    {

        public boolean tick()
        {
            if(bNeedSetUp)
            {
                reflectPlaneMats();
                bNeedSetUp = false;
            }
            if(fm != null)
            {
                setTmp = setOld;
                setOld = setNew;
                setNew = setTmp;
                setNew.mix = 0.8F * setOld.mix + 0.2F * fm.EI.engines[0].getControlMix();
                setNew.throttle = (10F * setOld.throttle + ((FlightModelMain) (fm)).CT.PowerControl) / 11F;
                setNew.prop = (8F * setOld.prop + ((FlightModelMain) (fm)).CT.getStepControl()) / 9F;
                setNew.altimeter = fm.getAltitude();
                setNew.azimuth.setDeg(setOld.azimuth.getDeg(1.0F), fm.Or.azimut());
                setNew.vspeed = (199F * setOld.vspeed + fm.getVertSpeed()) / 200F;
                float f1 = waypointAzimuth();
                if(useRealisticNavigationInstruments())
                {
                    setNew.waypointAzimuth.setDeg(setOld.waypointAzimuth.getDeg(1.0F), getBeaconDirection());
                } else
                {
                    setNew.waypointAzimuth.setDeg(setOld.waypointAzimuth.getDeg(0.1F), f1 - setOld.azimuth.getDeg(1.0F));
                }
                if(fm.getAltitude() > 3000F)
                {
                    float f = (float)Math.sin(1.0F * cvt(fm.getOverload(), 1.0F, 8F, 1.0F, 0.45F) * cvt(((FlightModelMain) (fm)).AS.astatePilotStates[0], 0.0F, 100F, 1.0F, 0.1F) * (0.001F * (float)Time.current()));
                    if(f > 0.0F)
                    {
                        pictBlinker += 0.3F;
                        if(pictBlinker > 1.0F)
                            pictBlinker = 1.0F;
                    } else
                    {
                        pictBlinker -= 0.3F;
                        if(pictBlinker < 0.0F)
                            pictBlinker = 0.0F;
                    }
                }
                pictStage = 0.8F * pictStage + 0.1F * (float)((FlightModelMain) (fm)).EI.engines[0].getControlCompressor();
            }
            return true;
        }

        Interpolater()
        {
        }
    }

    private class Variables
    {
        float mix;
        float throttle;
        float prop;
        float altimeter;
        AnglesFork azimuth;
        AnglesFork waypointAzimuth;
        float vspeed;
        float xyz[] = {
            0.0F, 0.0F, 0.0F
        };
        float ypr[] = {
            0.0F, 0.0F, 0.0F
        };

        private Variables()
        {
            azimuth = new AnglesFork();
            waypointAzimuth = new AnglesFork();
        }
    }

    protected float waypointAzimuth()
    {
        return super.waypointAzimuthInvertMinus(5F);
    }

    public CockpitLAGG_3_66()
    {
        super("3DO/Cockpit/LaGG-3/hier_66.him", "bf109");
        setOld = new Variables();
        setNew = new Variables();
        w = new Vector3f();
        bNeedSetUp = true;
        t1 = 0L;
        pictAiler = 0.0F;
        pictElev = 0.0F;
        pictBlinker = 0.0F;
        pictStage = 0.0F;
        super.cockpitNightMats = (new String[] {
            "Prib_One", "Prib_Two", "Prib_Three", "Prib_Four", "Prib_Five", "Shkala128", "Prib_Seven"
        });
        setNightMats(false);
        interpPut(new Interpolater(), null, Time.current(), null);
        if(Mission.getMissionDate(false) < 0x1298C45)
        {
            mesh.materialReplace("prib_three", "EmptyGauge");
            mesh.materialReplace("prib_three_night", "EmptyGauge_night");
            mesh.chunkVisible("zRPK10", false);
            setNightMats(true);
            setNightMats(false);
        }
    }

    public void reflectWorldToInstruments(float f)
    {
        if(bNeedSetUp)
        {
            reflectPlaneMats();
            bNeedSetUp = false;
        }
        resetYPRmodifier();
        Cockpit.xyz[0] = -cvt(((FlightModelMain) (super.fm)).CT.getCockpitDoor(), 0.01F, 0.99F, 0.0F, 0.58F);
        super.mesh.chunkSetLocate("Blister", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
        Cockpit.xyz[1] = cvt(((FlightModelMain) (super.fm)).CT.getCockpitDoor(), 0.01F, 0.99F, 0.0F, 0.58F);
        super.mesh.chunkSetLocate("Z_Holes1_D1", Cockpit.xyz, Cockpit.ypr);
        super.mesh.chunkSetLocate("Z_Holes2_D1", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
        if(((FlightModelMain) (super.fm)).CT.getStepControlAuto())
            super.mesh.chunkSetAngles("PropPitchHandle", -70F + 70F * interp(setNew.throttle, setOld.throttle, f), 0.0F, 0.0F);
        else
            super.mesh.chunkSetAngles("PropPitchHandle", 0.0F, 0.0F, -70F + 70F * interp(setNew.prop, setOld.prop, f));
        Cockpit.ypr[2] = interp(setNew.throttle, setOld.throttle, f) * 84F * 0.91F;
        Cockpit.xyz[0] = Cockpit.ypr[2] > 75F ? -0.004F : 0.0F;
        super.mesh.chunkSetLocate("TQHandle", Cockpit.xyz, Cockpit.ypr);
		Cockpit.ypr[2] = interp(setNew.mix, setOld.mix, f) * 84F * 0.91F;
		if(setNew.mix >= 0.91F)
		Cockpit.xyz[0] = 0.005F;
	        else
		Cockpit.xyz[0] = Cockpit.ypr[2] <= 35F ? -0.0015F : 0.0000F;
        super.mesh.chunkSetLocate("v_corr", Cockpit.xyz, Cockpit.ypr);
        super.mesh.chunkSetAngles("ChargerHandle", -90F * (float)((FlightModelMain) (super.fm)).EI.engines[0].getControlCompressor(), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("CStick5FN", 0.0F, (pictAiler = 0.85F * pictAiler + 0.15F * ((FlightModelMain) (super.fm)).CT.AileronControl) * 15F, (pictElev = 0.85F * pictElev + 0.15F * ((FlightModelMain) (super.fm)).CT.ElevatorControl) * 10F);
        super.mesh.chunkSetAngles("PriTrigger", ((FlightModelMain) (super.fm)).CT.WeaponControl[1] ? -30F : 0.0F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("SecTrigger", ((FlightModelMain) (super.fm)).CT.WeaponControl[0] ? -30F : 0.0F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Ped_Base", ((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("PedalL", -((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("PedalR", -((FlightModelMain) (super.fm)).CT.getRudder() * 15F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("Tross_L", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 15.65F, 0.0F);
        super.mesh.chunkSetAngles("Tross_R", 0.0F, ((FlightModelMain) (super.fm)).CT.getRudder() * 15.65F, 0.0F);
        super.mesh.chunkSetAngles("IgnitionSwitch", 0.0F, -40F * (float)((FlightModelMain) (super.fm)).EI.engines[0].getControlMagnetos(), 0.0F);
        super.mesh.chunkSetAngles("SW_Radio", 60F, 0.0F, 0.0F);
        super.mesh.chunkSetAngles("SW_NavLight", ((FlightModelMain) (super.fm)).AS.bNavLightsOn ? 60F : 0.0F, 0.0F, 0.0F);
        resetYPRmodifier();
        super.mesh.chunkSetAngles("zAlt1a", cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 3600F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zAlt1b", cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 10000F, 0.0F, 360F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zAzimuth1a", 0.0F, 0.0F, cvt(((FlightModelMain) (super.fm)).Or.getTangage(), -40F, 40F, 40F, -40F));
        super.mesh.chunkSetAngles("zAzimuth1b", setNew.azimuth.getDeg(0.05F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zManifold1a", floatindex(cvt(((FlightModelMain) (super.fm)).EI.engines[0].getManifoldPressure(), 0.4078518F, 2.1752096F, 3F, 16F), manifoldScale), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zGas1a", cvt(((FlightModelMain) (super.fm)).M.fuel / 0.725F, 0.0F, 400F, 0.0F, 180F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zSpeed1a", floatindex(cvt(Pitot.Indicator((float)((Tuple3d) (((FlightModelMain) (super.fm)).Loc)).z, super.fm.getSpeedKMH()), 0.0F, 800F, 0.0F, 16F), speedometerScale), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zTWater", cvt(((FlightModelMain) (super.fm)).EI.engines[0].tWaterOut, 0.0F, 120F, 0.0F, 86F), 0.0F, 0.0F);
        w.set(super.fm.getW());
        ((FlightModelMain) (super.fm)).Or.transform(w);
        super.mesh.chunkSetAngles("zTurn1a", cvt(((Tuple3f) (w)).z, -0.23562F, 0.23562F, 25F, -25F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zSlide1a", cvt(getBall(8D), -8F, 8F, -25F, 25F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zTOilOut1a", cvt(((FlightModelMain) (super.fm)).EI.engines[0].tOilOut, 0.0F, 125F, 0.0F, 180F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zOilPrs1a", floatindex(cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 3000F, 0.0F, 10F), oilScale), 0.0F, 0.0F);
		if(((FlightModelMain) (super.fm)).EI.engines[0].getRPM() < 200F)
            super.mesh.chunkSetAngles("zOilPrs1a", cvt(0.0F, 0.0F, 10F, 0.0F, 180F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zGasPrs1a", cvt(((FlightModelMain) (super.fm)).M.fuel > 1.0F ? cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 3050F, 0.0F, 4F) : 0.0F, 0.0F, 8F, 0.0F, -180F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zVariometer1a", floatindex(cvt(setNew.vspeed, -30F, 30F, 0.0F, 6F), variometerScale), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zRPM1a", cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 10000F, 0.0F, 3600F), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("zRPM1b", cvt(((FlightModelMain) (super.fm)).EI.engines[0].getRPM(), 0.0F, 10000F, 0.0F, 360F), 0.0F, 0.0F);
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x40) == 0)
        {
            super.mesh.chunkSetAngles("zClock1a", cvt(World.getTimeofDay() % 1.0F, 0.0F, 1.0F, 0.0F, 360F), 0.0F, 0.0F);
            super.mesh.chunkSetAngles("zClock1b", cvt(World.getTimeofDay(), 0.0F, 24F, 0.0F, 720F), 0.0F, 0.0F);
            super.mesh.chunkSetAngles("zClock1sec", cvt(((World.getTimeofDay() % 1.0F) * 60F) % 1.0F, 0.0F, 1.0F, 0.0F, 360F), 0.0F, 0.0F);
            super.mesh.chunkSetAngles("zRPK10", cvt(setNew.waypointAzimuth.getDeg(f * 0.2F), -25F, 25F, -35F, 35F), 0.0F, 0.0F);
        }
        super.mesh.chunkVisible("XGearUP_L", ((FlightModelMain) (super.fm)).CT.getGear() == 0.0F && ((FlightModelMain) (super.fm)).Gears.lgear);
        super.mesh.chunkVisible("XGearUP_R", ((FlightModelMain) (super.fm)).CT.getGear() == 0.0F && ((FlightModelMain) (super.fm)).Gears.rgear);
        super.mesh.chunkVisible("XGearDown_L", ((FlightModelMain) (super.fm)).CT.getGear() == 1.0F && ((FlightModelMain) (super.fm)).Gears.lgear);
        super.mesh.chunkVisible("XGearDown_R", ((FlightModelMain) (super.fm)).CT.getGear() == 1.0F && ((FlightModelMain) (super.fm)).Gears.rgear);
        super.mesh.chunkVisible("XGearDown_C", ((FlightModelMain) (super.fm)).CT.getGear() == 1.0F);
        if(t1 < Time.current())
        {
            BulletEmitter bulletemitter = ((Aircraft)((Interpolate) (super.fm)).actor).getBulletEmitterByHookName("_ExternalBomb01");
            if(bulletemitter != GunEmpty.get())
                super.mesh.chunkVisible("XBombOnboard_L", bulletemitter.haveBullets());
            else
                super.mesh.chunkVisible("XBombOnboard_L", false);
            bulletemitter = ((Aircraft)((Interpolate) (super.fm)).actor).getBulletEmitterByHookName("_ExternalBomb02");
            if(bulletemitter != GunEmpty.get())
                super.mesh.chunkVisible("XBombOnboard_R", bulletemitter.haveBullets());
            else
                super.mesh.chunkVisible("XBombOnboard_R", false);
            t1 = Time.current() + 500L;
        }
        super.mesh.chunkSetAngles("ZFlaps", -cvt(((FlightModelMain) (super.fm)).CT.getFlap(), 0.0F, 1.0F, 0.0F, -150F), 0.0F, 0.0F);
        resetYPRmodifier();
        Cockpit.xyz[2] = ((FlightModelMain) (super.fm)).CT.GearControl == 0.0F && ((FlightModelMain) (super.fm)).CT.getGear() != 0.0F ? -0.0107F : 0.0F;
        super.mesh.chunkSetLocate("GearUp", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[2] = ((FlightModelMain) (super.fm)).CT.GearControl == 1.0F && ((FlightModelMain) (super.fm)).CT.getGear() != 1.0F ? -0.0107F : 0.0F;
        super.mesh.chunkSetLocate("GearDown", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
        Cockpit.xyz[2] = ((FlightModelMain) (super.fm)).CT.FlapsControl < ((FlightModelMain) (super.fm)).CT.getFlap() ? -0.0107F : 0.0F;
        super.mesh.chunkSetLocate("FlapControl2", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[2] = ((FlightModelMain) (super.fm)).CT.FlapsControl > ((FlightModelMain) (super.fm)).CT.getFlap() ? -0.0107F : 0.0F;
        super.mesh.chunkSetLocate("FlapControl1", Cockpit.xyz, Cockpit.ypr);
        if(fm.CT.saveWeaponControl[3])
        {
            mesh.chunkSetAngles("BSLHandle", 30F, 0.0F, 0.0F);
            mesh.chunkSetAngles("BSLClamp", 11F, 0.0F, 0.0F);
        }
 		super.mesh.chunkSetAngles("SW_Light", cockpitLightControl ? -80F : 0.0F, 0.0F, 0.0F);
 		super.mesh.chunkSetAngles("SW_Cabin", cockpitLightControl ? -80F : 0.0F, 0.0F, 0.0F);
        if(fm.CT.bHasBrakeControl)
        {
            float f2 = fm.CT.getBrake();
            mesh.chunkSetAngles("WheelBrake", 0.0F, f2 * 20F + 1F, 0.0F);
            mesh.chunkSetAngles("zBrakeAir_R", cvt(f2 + f2 * fm.CT.getRudder(), 0.0F, 1.5F, 0.0F, 175F), 0.0F, 0.0F);
            mesh.chunkSetAngles("zBrakeAir_L", cvt(f2 - f2 * fm.CT.getRudder(), 0.0F, 1.5F, 0.0F, 175F), 0.0F, 0.0F);
            mesh.chunkSetAngles("zSystemAir", 1 - f2 * 45F, 0.0F, 0.0F);
        }
 		super.mesh.chunkSetAngles("TrimTangage", 720F * ((FlightModelMain) (super.fm)).CT.getTrimElevatorControl(), 0.0F, 0.0F);
 		super.mesh.chunkSetAngles("TrimRudder", 720F * ((FlightModelMain) (super.fm)).CT.getTrimRudderControl(), 0.0F, 0.0F);
 		super.mesh.chunkSetAngles("TrimAileron", 720F * ((FlightModelMain) (super.fm)).CT.getTrimAileronControl(), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("RadOil", -75F * (float)((FlightModelMain) (super.fm)).CT.getRadiatorControl(), 0.0F, 0.0F);
        super.mesh.chunkSetAngles("RadWater", -75F * (float)((FlightModelMain) (super.fm)).CT.getRadiatorControl(), 0.0F, 0.0F);
        float f1 = 0.0F;
        f1 = Atmosphere.temperature((float)fm.Loc.z) - 273.09F;
        if(f1 < 5F)
			super.mesh.chunkSetAngles("SW_PitotHeat", 60F, 0.0F, 0.0F);
		else
			super.mesh.chunkSetAngles("SW_PitotHeat", 0.0F, 0.0F, 0.0F);
    }

    public void reflectCockpitState()
    {
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 4) != 0 || (((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x10) != 0)
        {
            super.mesh.materialReplace("Prib_One", "DPrib_One");
            super.mesh.materialReplace("Prib_One_night", "DPrib_One_night");
            super.mesh.chunkVisible("zAlt1b", false);
            super.mesh.chunkVisible("zAlt1a", false);
            super.mesh.chunkVisible("zSpeed1a", false);
            super.mesh.chunkVisible("zRPM1a", false);
            super.mesh.chunkVisible("zRPM1b", false);
            super.mesh.chunkVisible("zTOilOut1a", false);
            super.mesh.chunkVisible("zOilPrs1a", false);
            super.mesh.chunkVisible("zGasPrs1a", false);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 8) != 0 || (((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x20) != 0)
        {
            super.mesh.materialReplace("Prib_Two", "DPrib_Two");
            super.mesh.materialReplace("Prib_Two_night", "DPrib_Two_night");
            super.mesh.chunkVisible("zManifold1a", false);
            super.mesh.chunkVisible("zVariometer1a", false);
            super.mesh.chunkVisible("zGas1a", false);
            super.mesh.chunkVisible("zTurn1a", false);
            super.mesh.chunkVisible("zSlide1a", false);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x40) != 0)
        {
        if(Mission.getMissionDate(false) < 0x1285681)
            {
                mesh.materialReplace("Prib_Three", "EmptyGaugeD_night");
                mesh.materialReplace("Prib_Three_night", "EmptyGaugeD_night");
            } else
            {
                mesh.materialReplace("Prib_Three", "DPrib_Three");
                mesh.materialReplace("Prib_Three_night", "DPrib_Three_night");
            }
            super.mesh.chunkVisible("zHorizon1a", false);
            super.mesh.chunkVisible("zHorizon1b", false);
            super.mesh.materialReplace("Prib_Four", "DPrib_Four");
            super.mesh.materialReplace("Prib_Four_night", "DPrib_Four_night");
            super.mesh.chunkVisible("zAzimuth1a", false);
            super.mesh.chunkVisible("zAzimuth1b", false);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 2) != 0 || (((FlightModelMain) (super.fm)).AS.astateCockpitState & 1) != 0)
        {
            super.mesh.chunkVisible("PBP-1", false);
            super.mesh.chunkVisible("PBP-1_D0", true);
            super.mesh.chunkVisible("Z_Z_RETICLE", false);
            super.mesh.chunkVisible("Z_Z_MASK", false);
            super.mesh.chunkVisible("Z_Holes1_D0", true);
            super.mesh.chunkVisible("Z_Holes1_D1", true);
            super.mesh.chunkVisible("Z_Holes2_D0", true);
            super.mesh.chunkVisible("Z_Holes2_D1", true);
        }
        if((((FlightModelMain) (super.fm)).AS.astateCockpitState & 0x80) != 0)
            super.mesh.chunkVisible("Z_OilSplats_D0", true);
        retoggleLight();
    }

    protected void reflectPlaneMats()
    {
        HierMesh hiermesh = aircraft().hierMesh();
        com.maddox.il2.engine.Mat mat = hiermesh.material(hiermesh.materialFind("Gloss1D0o"));
        super.mesh.materialReplace("Gloss1D0o", mat);
    }

    public void toggleLight()
    {
        super.cockpitLightControl = !super.cockpitLightControl;
        if(super.cockpitLightControl)
            setNightMats(true);
        else
            setNightMats(false);
    }

    private void retoggleLight()
    {
        if(super.cockpitLightControl)
        {
            setNightMats(false);
            setNightMats(true);
        } else
        {
            setNightMats(true);
            setNightMats(false);
        }
    }

    private Variables setOld;
    private Variables setNew;
    private Variables setTmp;
    public Vector3f w;
    private boolean bNeedSetUp;
    private long t1;
    private float pictAiler;
    private float pictElev;
    private float pictBlinker;
    private float pictStage;
    private static final float speedometerScale[] = {
/* 		0		50	100	 150     200	250	 300	350	400		450 */
        0.0F, 0.0F, 12F, 46.3F, 88.5F, 136F, 185F, 205F, 219F, 232.5F, 
/* 		500		550		600	650		700		750		800 */
        247F, 262F, 277F, 291.5F, 308F, 323.3F, 338.9F
    };
    private static final float manifoldScale[] = {
        0.0F, 0.0F, 0.0F, 0.0F, 26F, 52F, 79F, 106F, 129F, 152F, 
        174F, 197F, 220F, 245F, 271F, 299F, 326F
    };
    private static final float variometerScale[] = {
        -180F, -141F, -81F, 0.0F, 81F, 141F, 180F
    };
    private static final float oilScale[] = {
        0.0F, 20F, 24.88F, 37.32F, 49.76F,
        62.2F, 74.64F, 87.08F, 99.52F, 110F,
    };
    static 
    {
        Property.set(CLASS.THIS(), "normZNs", new float[] {
            0.9F, 0.76F, 0.96F, 0.76F
        });
    }
}