package com.maddox.il2.objects.air;

import com.maddox.il2.ai.World;
import com.maddox.il2.engine.Config;
import com.maddox.il2.engine.HierMesh;
import com.maddox.il2.fm.*;
import com.maddox.il2.game.HUD;
import com.maddox.il2.game.Mission;
import com.maddox.il2.game.Main3D;
import com.maddox.rts.Property;

public class LAGG_3SERIES35 extends LAGG_3
    implements TypeTNBFighter
{

    public LAGG_3SERIES35()
    {
        kangle = 0.0F;
        kl = 1.0F;
        kr = 1.0F;
        kc = 1.0F;
    }

    public void rareAction(float paramFloat, boolean paramBoolean)
    {
        super.rareAction(paramFloat, paramBoolean);
        if(paramBoolean)
        {
			//Код перекидывания огня на соседний бак, вероятность 14%
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[0] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 1, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 0, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 3, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[3] > 4 && World.Rnd().nextFloat() < 0.14F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 2, 1);
			//Код перекидывания огня на бак другой консоли, вероятность 1.96% (имитация возгарания фюзеляжного бака и перекидывания огня с него)
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[1] > 4 && World.Rnd().nextFloat() < 0.0196F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 2, 1);
            if(((FlightModelMain) (super.FM)).AS.astateTankStates[2] > 4 && World.Rnd().nextFloat() < 0.0196F)
                ((FlightModelMain) (super.FM)).AS.hitTank(this, 1, 1);
        }
    }

    public void onAircraftLoaded()
    {
        super.onAircraftLoaded();
        if(thisWeaponsName.startsWith("2xFAB") || thisWeaponsName.startsWith("2xDROPTANK"))
            hierMesh().chunkVisible("BombRack_L", true);
            hierMesh().chunkVisible("BombRack_R", true);
        if(super.thisWeaponsName.startsWith("2x"))
            ((FlightModelMain) (super.FM)).M.massEmpty += 20F;
		//масса 2 держателей ДЗ-40 по данным Ил-2 БзС
        if(super.thisWeaponsName.startsWith("kinderwud"))
            ((FlightModelMain) (super.FM)).M.massEmpty += 35F;
		//разница масс по данным Ил-2 БзС
    }

    public void update(float dt)
    {
        if(super.FM.getSpeed() > 5F)
        {
            hierMesh().chunkSetAngles("SlatL_D0", 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.2F), 0.0F);
            hierMesh().chunkSetAngles("SlatR_D0", 0.0F, Aircraft.cvt(super.FM.getAOA(), 6.8F, 11F, 0.0F, 1.2F), 0.0F);
        }
        super.hierMesh().chunkSetAngles("Oil_luk", 0.0F, -9F + 9F * kangle, 0.0F);
        kangle = 0.95F * kangle + 0.05F * FM.EI.engines[0].getControlRadiator();
        super.update(dt);
		afterburnerhud();
    }

    public static void moveGear(HierMesh hiermesh, float left, float right, float center)
    {
        hiermesh.chunkSetAngles("GearL2_D0", 0.0F, 80F * left * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR2_D0", 0.0F, -80F * right * kr, 0.0F);
        hiermesh.chunkSetAngles("GearL3_D0", 0.0F, -100F * left * kl, 0.0F);
        hiermesh.chunkSetAngles("GearR3_D0", 0.0F, 100F * right * kr, 0.0F);
		hiermesh.chunkSetAngles("GearC2_D0", 0.0F, 85F * center * kc, 0.0F);
        float pk = Math.max(-center * 1400F, -80F);
        hiermesh.chunkSetAngles("GearC3_D0", 0.0F, -pk * kc, 0.0F);
        hiermesh.chunkSetAngles("GearC4_D0", 0.0F, -pk * kc, 0.0F);
        Aircraft.xyz[0] = Aircraft.xyz[1] = Aircraft.xyz[2] = 0.0F;
        Aircraft.ypr[0] = Aircraft.ypr[1] = Aircraft.ypr[2] = 0.0F;
        Aircraft.xyz[2] = Aircraft.cvt(left, 0.0F, 1.0F, 0.0F, 0.1F);
        hiermesh.chunkSetLocate("poleL_D0", Aircraft.xyz, Aircraft.ypr);
        hiermesh.chunkSetLocate("poleR_D0", Aircraft.xyz, Aircraft.ypr);
    }

    protected void moveGear(float left, float right, float center)
    {
        moveGear(hierMesh(), left, right, center);
        if(((FlightModelMain) (super.FM)).CT.getGear() >= 0.997F)
        {
            kl = 1.0F;
            kr = 1.0F;
            kc = 1.0F;
		}
    }

    protected void afterburnerhud()
    {
        if(super.FM.isPlayers() && ((FlightModelMain) (super.FM)).EI.engines[0].getControlAfterburner())
            HUD.logRightBottom("\u041D\u0430\u0434\u0434\u0443\u0432 1050 \u043C\u043C \u0440\u0442. \u0441\u0442.!");
    }

    static Class _mthclass$(String s)
    {
        Class class1;
        try
        {
            class1 = Class.forName(s);
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
        return class1;
    }

    private float kangle;
    private static float kl = 1.0F;
    private static float kr = 1.0F;
    private static float kc = 1.0F;

    static 
    {
        Class class1 = com.maddox.il2.objects.air.LAGG_3SERIES35.class;
        new NetAircraft.SPAWN(class1);
        Property.set(class1, "iconFar_shortClassName", "LaGG-3 ser 35");
        Property.set(class1, "meshName", "3DO/Plane/LaGG-3series35/hier.him");
        Property.set(class1, "PaintScheme", new PaintSchemeFMPar03());
        Property.set(class1, "yearService", 1942F);
        Property.set(class1, "yearExpired", 1944.5F);
        Property.set(class1, "FlightModel", "FlightModels/LaGG-3series35.fmd:LAGG");
        Property.set(class1, "cockpitClass", new Class[] {
            com.maddox.il2.objects.air.CockpitLAGG_3_35.class
        });
        Property.set(class1, "LOSElevation", 0.69445F);
        Aircraft.weaponTriggersRegister(class1, new int[] {
            0, 1, 3, 3, 9, 2, 9, 2, 9, 2, 
            9, 2, 9, 2, 9, 2, 9, 2, 9, 2, 
            9, 9
        });
        Aircraft.weaponHooksRegister(class1, new String[] {
            "_MGUN01", "_CANNON01", "_ExternalBomb01", "_ExternalBomb02", "_ExternalDev01", "_ExternalRock01", "_ExternalDev02", "_ExternalRock02", "_ExternalDev03", "_ExternalRock03", 
            "_ExternalDev04", "_ExternalRock04", "_ExternalDev05", "_ExternalRock05", "_ExternalDev06", "_ExternalRock06", "_ExternalDev07", "_ExternalRock07", "_ExternalDev08", "_ExternalRock08", 
            "_ExternalBomb01", "_ExternalBomb02"
        });
    }
}